// Persistence of Vision Ray Tracer Scene Description File
// File: stpaul.inc
// Desc: The dome of St.Pauls Cathedral.
// Date: 1996.10.04
// Auth: Ib Rasmusen (ib@ibras.dk)
//
// You have my permission to use this object in your own scenes, as
// long as you don't pass it of as your own creation. 
//
// This file assumes, that the standard pov includes are included
// in your main scene file.
//
// Hint: If memory space is a problem, it may help to rem out the 
// declaration of the finished dome at the end of this file, and
// insert the eleven parts directly in your scene.
//
// This scene was not written with publication in mind, so it is not
// commented, and the object naming is a mess of mixed danish and english

/************************ Declarations *******************************/

/*-------------------------- Textures -------------------------------*/

#declare T_Sandstone=texture {
   pigment { granite
      turbulence 0.6
      color_map{
	  [0.000, 0.154   color rgbf <0.999, 0.777, 0.444, 0.000>
                          color rgbf <0.999, 0.777, 0.777, 0.000>]
	  [0.154, 0.308   color rgbf <0.999, 0.777, 0.555, 0.000>
			  color rgbf <0.999, 0.777, 0.444, 0.000>]
	  [0.308, 0.444   color rgbf <0.999, 0.777, 0.444, 0.000>
			  color rgbf <0.999, 0.777, 0.777, 0.000>]
	  [0.444, 0.615   color rgbf <0.999, 0.777, 0.555, 0.000>
			  color rgbf <0.999, 0.777, 0.444, 0.000>]
	  [0.615, 0.812   color rgbf <0.999, 0.777, 0.444, 0.000>
			  color rgbf <0.999, 0.777, 0.777, 0.000>]
	  [0.812, 1.001   color rgbf <0.999, 0.777, 0.555, 0.000>
			  color rgbf <0.999, 0.777, 0.444, 0.000>]
      }
   }
   scale <10, 10, 10>
   finish { ambient 0.1 diffuse 0.5 }
}

#declare T_Lead=texture {
   pigment { color Gray70 }
   finish { ambient 0.1 diffuse 0.4 }
}
texture {
   pigment{ gradient y
      color_map{
	 [0.000, 0.500 color rgbf <0.99, 0.99, 0.99, 1.0>
		       color rgbf <0.99, 0.99, 0.99, 0.0>]
	 [0.500, 1.001 color rgbf <0.99, 0.99, 0.99, 0.0>
		       color rgbf <0.99, 0.99, 0.99, 0.0>]
      }
   }
   finish { ambient 0.1 diffuse 0.4 }
}

/*------------------------- Objects ----------------------------------*/

#declare Sokkel=union{
   cylinder { <0, -300, 0>, <0, -27, 0>, 758 }
   cylinder { <0,  -27, 0>, <0, -18, 0>, 768 }
   cylinder { <0,  -18, 0>, <0, -11, 0>, 780 }
   cylinder { <0,  -11, 0>, <0,   0, 0>, 790 }
   cylinder { <0,    0, 0>, <0,  15, 0>, 680 }
   cylinder { <0,   15, 0>, <0,  28, 0>, 602 }
   cylinder { <0,   28, 0>, <0,  40, 0>, 597 }
   torus { 790, 4 translate <0, -6, 0> }
   texture { T_Sandstone }
}

/*------------ Sjlegang ----------------*/

#declare Snegl=union{
   torus { 6, 2.5 }
   torus { 6, 2.5 translate <0,  4, 0> }
   torus { 2, 2.5 translate <0,  4, 0> }
   torus { 6, 2.5 translate <0, -4, 0> }
   torus { 2, 2.5 translate <0, -4, 0> }
   box { <8, -8, -4>, <12, 8, 8> }
   cylinder { <10, -8, -4>, <10, 8, -4>, 2 }
   rotate <0, 0, 90>
}

#declare Blad=difference{
   torus { 40, 17 rotate <0, 0, 90> scale <1, 2, 1> translate <0, -23, 0> }
   torus { 40, 14 rotate <0, 0, 90> scale <1, 2, 1> translate <0, -23, 0> }
   plane { x, 0 rotate <0, -30, 0> }
   plane { x, 0 translate <-6, 0, 0> }
   plane {-x, 0 rotate <0, 30, 0> }
   plane {-x, 0 translate < 6, 0, 0> }
   plane { y, 0 }
   plane { -y, 0 translate <0, 23, 0> }
   plane {-z, 0 translate <0, 0, 24> }
   plane { z, 0 translate <0, 0, 6> }
}

#declare Kapitael=union{
   cylinder { <0, 0, 0>, <0, 8, 0>, 17 }
   torus { 17, 2 translate <0, 6, 0> }
   cone { <0, 8, 0>, 12, <0, 31, 0>, 18 }
   cylinder { <0, 31, 0>, <0, 51, 0>, 18 }

   object { Blad translate <0, 8, -38> }
   object { Blad translate <0, 8, -38> rotate <0, 45, 0> }
   object { Blad translate <0, 8, -38> rotate <0, 90, 0> }
   object { Blad translate <0, 8, -38> rotate <0,135, 0> }
   object { Blad translate <0, 8, -38> rotate <0,180, 0> }
   object { Blad translate <0, 8, -38> rotate <0,225, 0> }
   object { Blad translate <0, 8, -38> rotate <0,270, 0> }
   object { Blad translate <0, 8, -38> rotate <0,315, 0> }

   object { Snegl translate <0, 39, -21> }
   object { Snegl translate <0, 39, -21> rotate <0,  90, 0> }
   object { Snegl translate <0, 39, -21> rotate <0, 180, 0> }
   object { Snegl translate <0, 39, -21> rotate <0, 270, 0> }
   object { Snegl rotate <0, -45, 0> translate <19, 39, -19> rotate <0,   0, 0> }
   object { Snegl rotate <0, -45, 0> translate <19, 39, -19> rotate <0,  90, 0> }
   object { Snegl rotate <0, -45, 0> translate <19, 39, -19> rotate <0, 180, 0> }
   object { Snegl rotate <0, -45, 0> translate <19, 39, -19> rotate <0, 270, 0> }
}

#declare Pillar=union{
   box { <-28.5, 0, -28.5>, <28.5, 22, 28.5> }
   box { <-26.5, 22, -26.5>, <26.5, 32, 26.5> }
   torus { 22, 3 translate <0, 35, 0> }
   difference{
      cylinder { <0, 36, 0>, <0, 52, 0>, 22 }
      torus { 34, 16 translate <0, 52, 0> }
   }
   torus { 17.5, 3 translate <0, 52, 0> }
   difference{
      cylinder { <0, 55, 0>, <0, 230, 0>, 18.5 }
      torus { 18.5, 1 translate <0,  80, 0> }
      torus { 18.5, 1 translate <0, 105, 0> }
      torus { 18.5, 1 translate <0, 130, 0> }
      torus { 18.5, 1 translate <0, 155, 0> }
      torus { 18.5, 1 translate <0, 180, 0> }
      torus { 18.5, 1 translate <0, 205, 0> }
      torus { 18.5, 1 translate <0, 230, 0> }
   }
   difference{
      cone { <0, 230, 0>, 18.5, <0, 355, 0>, 17 }
      torus { 18.5, 1 translate <0, 230, 0> }
      torus { 18.2, 1 translate <0, 255, 0> }
      torus { 17.9, 1 translate <0, 280, 0> }
      torus { 17.6, 1 translate <0, 305, 0> }
      torus { 17.3, 1 translate <0, 330, 0> }
   }
   object { Kapitael translate <0, 355, 0> }

   texture { T_Sandstone }
}

#declare ArcKapi=union{
   box { <-15, -1, -3>, <15, -5, 0> }
   cylinder { <-15, -3, -3>, <15, -3, -3>, 2 }
   object { Snegl rotate <0,  45, 0> translate <-17, 31, -7> scale <0.6, 0.6, 0.6> }
   object { Blad translate <0, 0, -28> rotate <0,  45, 0> translate <-8, 0, 0> scale <0.6, 0.6, 0.6> }
   object { Snegl rotate <0, -45, 0> translate < 17, 31, -7> scale <0.6, 0.6, 0.6> }
   object { Blad translate <0, 0, -28> rotate <0, -45, 0> translate <8, 0, 0> scale <0.6, 0.6, 0.6> }
   object { Blad translate <0, 0, -30>  scale <0.7, 1.0, 0.5> }
   box { <-16, 24, -9>, <16, 27, 0> }
   cylinder { <-16, 25.5, -9>, <16, 25.5, -9>, 1.5 }
   box { <-15, 27, -3>, <15, 45, 0> }
   box { <-13.5, 45, -4.5>, <13.5, 48, 0> }
   cylinder { <-13.5, 46.5, -4.5>, <13.5, 46.5, -4.5>, 1.5 }
   box { <-15, 48, -5.5>, <15, 51, 0> }
   cylinder { <-15, 49.5, -5.5>, <15, 49.5, -5.5>, 1.5 }
}

#declare ArcDeco=union{
   difference {
      cylinder { <0, 275,  0>, <0, 275, -3>, 56 }
      cylinder { <0, 275,  1>, <0, 275, -4>, 53 }
      plane { y, 0 translate <0, 275, 0> }
   }
   difference{
      torus { 54.5, 1.5 rotate <-90, 0, 0> translate <0, 275, -3> }
      plane { y, 0 translate <0, 275, 0> }
   }
   difference{
      torus { 51.5, 1.5 rotate <-90, 0, 0> translate <0, 275, -2> }
      plane { y, 0 translate <0, 275, 0> }
   }
   object { ArcKapi translate <-47, 226, 0> }
   object { ArcKapi translate < 47, 226, 0> }
}

#declare Arc=union{
   difference{
      box { <-10, 0, -75>, <10, 406, 110> }
      box { <-20, 0, -32>, <20, 275, 32> }
      cylinder { <-20, 275, 0>, <20, 275, 0>, 32 }
      cylinder { <-20, 372, 0>, <20, 372, 0>, 17 }
   }
   box { <-15,  0, -70>, <15,  28, -27> }
   box { <-12, 28, -70>, <12,  40, -30> }
   box { <-15,  0,  27>, <15,  28, 100> }
   box { <-12, 28,  30>, <12,  40, 100> }
   object { ArcDeco rotate <0, 90, 0> translate <-10, 0, 0> }
   object { ArcDeco rotate <0, -90, 0> translate <10, 0, 0> }
   texture { T_Sandstone }
}

#declare ArcPair=union{
   object { Arc translate <0, 0, -660> rotate <0, 3*360/64, 0> }
   object { Arc translate <0, 0, -660> rotate <0, 5*360/64, 0> }
}

#declare N_Cutout=union{
   box { <-42, 59, -2>, <42, 407, 2> }
   cylinder { <0, 106, 0>, <0, 270, 0>, 31 }
   sphere { <0, 270, 0>, 31 }
}

#declare N_Sidecut=union{
   box { <-14,  0, -27>, <14,  28, 27> }
   box { <-17, 28, -30>, <17,  40, 30> }
   box { <-20, 40, -32>, <20, 275, 32> }
   cylinder { <-20, 275, 0>, <20, 275, 0>, 32 }
}

#declare N_Arc=difference{
   union{
      difference{
	 cylinder { <0, -2, 0>, <0, 2, 0>, 55 }
	 cylinder { <0, -5, 0>, <0, 5, 0>, 42 }
      }
      torus { 53.5, 1.5 translate <0, 2, 0> }
      torus { 51, 1 translate <0, 3, 0> }
      rotate <-90, 0, 0>
   }
   plane { y, 0 }
}

#declare N_Frame=union{
   difference{
      box { <-36, -18, -3>, <36, 18, 0> }
      box { <-33, -15, -4>, <33, 15, 1> }
   }
   cylinder { <-30,  12, 0>, < 30,  12, 0>, 1.5 }
   cylinder { <-30, -12, 0>, < 30, -12, 0>, 1.5 }
   cylinder { <-30,  12, 0>, <-30, -12, 0>, 1.5 }
   cylinder { < 30,  12, 0>, < 30, -12, 0>, 1.5 }

   cylinder { <-32,  14, 0>, < 32,  14, 0>, 1.0 }
   cylinder { <-32, -14, 0>, < 32, -14, 0>, 1.0 }
   cylinder { <-32,  14, 0>, <-32, -14, 0>, 1.0 }
   cylinder { < 32,  14, 0>, < 32, -14, 0>, 1.0 }

   cylinder { <-34.5,  16.5, -3>, < 34.5,  16.5, -3>, 1.5 }
   cylinder { <-34.5, -16.5, -3>, < 34.5, -16.5, -3>, 1.5 }
   cylinder { <-34.5,  16.5, -3>, <-34.5, -16.5, -3>, 1.5 }
   cylinder { < 34.5,  16.5, -3>, < 34.5, -16.5, -3>, 1.5 }
}

#declare N_GPart=difference{
   union{
      torus { 21, 1.5 translate <6, 0, 6> }
      torus { 15, 1.5 }
      torus { 12, 1.5 }
      torus {  9, 1.5 }
      torus { 12, 1.2 translate <4, 0, 4> }
      sphere { <-3, 0, 4>, 4 scale <1, 0.7, 1>}
      sphere { < 2, 0, -3>, 4 }
      rotate <-90, 0, 0>
   }
   plane { -x, 0 rotate <0, 0, 45> translate <4, 0, 0> }
}

#declare N_Guirl=union{
   sphere { <-31,  11, 0>, 9 }
   sphere { < 31,  11, 0>, 9 }
   sphere { <-12, -15, 0>, 5 }
   sphere { < -4, -16, 0>, 4 }
   sphere { <  4, -16, 0>, 4 }
   sphere { < 12, -15, 0>, 5 }
   difference {
      union{
	 torus { 26, 1.5 rotate <90, 0, 0> translate <0, 21, -1> }
	 torus { 23, 1.5 rotate <90, 0, 0> translate <0, 15, -1> }
	 torus { 25, 1.5 rotate <90, 0, 0> translate <0, 14, -1> }
      }
      plane {-y, 0 translate <0, 14, 0> }
   }
   object { N_GPart translate <-23.5, -3.5, -1> }
   object { N_GPart rotate <0, 180, 0> translate <23.5, -3.5, -1> }
   scale <1, 1, 0.5>
}

#declare N_MPart=difference{
   sphere { <0, 0, 0>, 31 }
   sphere { <0, 0, 0>, 27 }
   plane { z, 0 }
   plane { y, 0 }
   plane { x, 0  rotate <0, 0,  7> }
   plane {-x, 0  rotate <0, 0, -7> }
}

#declare N_Musling=union{
   object { N_MPart rotate <0, 0, -13.5> }
   object { N_MPart rotate <0, 0, -40.5> }
   object { N_MPart rotate <0, 0, -67.5> }
   object { N_MPart rotate <0, 0,  13.5> }
   object { N_MPart rotate <0, 0,  40.5> }
   object { N_MPart rotate <0, 0,  67.5> }
   difference {
      sphere { <0, 0, 0>, 27 }
      plane { y, 0 translate <0, 2, 0> }
      plane { z, 0 translate <0, 0, 23> }
   }
}

#declare Niche=union{
   difference{
      union{
	 box { <-75,  0, -744>, <75,  22, -550> }
	 box { <-75, 22, -741>, <75,  40, -550> }
	 box { <-75, 40, -738>, <75, 406, -550> }
      }
      plane { x, 0 rotate <0,  360/64, 0> }
      plane {-x, 0 rotate <0, -360/64, 0> }
      torus { 660, 17 translate <0, 372, 0> }
      object { N_Sidecut translate <0, 0, -660> rotate <0,  360/64, 0> }
      object { N_Sidecut translate <0, 0, -660> rotate <0, -360/64, 0> }
      object { N_Cutout translate <0, 0, -738> }
   }

   object { ArcDeco rotate <0, 90, 0> translate <0, 0,-660> rotate <0, 360/64, 0> }
   object { ArcDeco rotate <0,-90, 0> translate <0, 0,-660> rotate <0,-360/64, 0> }

   box { <-5,  0, -590>, <1, 28, -633> rotate <0, 360/64, 0> }
   box { <-2, 28, -590>, <1, 40, -630> rotate <0, 360/64, 0> }
   box { <-5,  0, -687>, <1, 28, -730> rotate <0, 360/64, 0> }
   box { <-2, 28, -690>, <1, 40, -730> rotate <0, 360/64, 0> }

   box { <5,  0, -590>, <-1, 28, -633> rotate <0, -360/64, 0> }
   box { <2, 28, -590>, <-1, 40, -630> rotate <0, -360/64, 0> }
   box { <5,  0, -687>, <-1, 28, -730> rotate <0, -360/64, 0> }
   box { <2, 28, -690>, <-1, 40, -730> rotate <0, -360/64, 0> }

   box { <-36, 71, -738>, <36, 105, -735> }
   cylinder { <-32,  99, -738>, <32,  99, -738>, 1.5 }
   cylinder { <-35, 101, -739>, <35, 101, -739>, 1.5 }
   cylinder { <-38, 103, -740>, <38, 103, -740>, 1 }
   cylinder { <-38, 106, -740>, <38, 106, -740>, 2 }

   cylinder { <-60, 243, -738>, <-42, 243, -738>, 1.5 }
   cylinder { < 42, 243, -738>, < 60, 243, -738>, 1.5 }
   cylinder { <-42, 243, -736>, <-29, 243, -736>, 1.5 }
   cylinder { < 29, 243, -736>, < 42, 243, -736>, 1.5 }
   difference {
      torus { 31, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 243, -738>
   }

   cylinder { <-60, 258, -738>, <-42, 258, -738>, 1.5 }
   cylinder { < 42, 258, -738>, < 60, 258, -738>, 1.5 }
   cylinder { <-42, 258, -736>, <-29, 258, -736>, 1.5 }
   cylinder { < 29, 258, -736>, < 42, 258, -736>, 1.5 }
   difference {
      torus { 31, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 258, -738>
   }

   cylinder { <-60, 260, -738>, <-42, 260, -738>, 1.5 }
   cylinder { < 42, 260, -738>, < 60, 260, -738>, 1.5 }
   cylinder { <-42, 260, -736>, <-29, 260, -736>, 1.5 }
   cylinder { < 29, 260, -736>, < 42, 260, -736>, 1.5 }
   difference {
      torus { 30.5, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 260, -738>
   }

   cylinder { <-60, 268, -739>, <-42, 268, -739>, 1.5 }
   cylinder { < 42, 268, -739>, < 60, 268, -739>, 1.5 }
   cylinder { <-42, 268, -737>, <-28, 268, -737>, 1.5 }
   cylinder { < 28, 268, -737>, < 42, 268, -737>, 1.5 }
   difference {
      torus { 29.5, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 268, -738>
   }

   cylinder { <-60, 270, -739.5>, <-42, 270, -739.5>, 1.5 }
   cylinder { < 42, 270, -739.5>, < 60, 270, -739.5>, 1.5 }
   cylinder { <-42, 270, -737.5>, <-27, 270, -737.5>, 1.5 }
   cylinder { < 27, 270, -737.5>, < 42, 270, -737.5>, 1.5 }
   difference {
      torus { 28, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 270, -738>
   }

   object { N_Musling translate <0, 270, -738> }
   object { N_Arc translate <0, 270, -738> }
   object { N_Frame translate <0, 342, -736> }
   object { N_Guirl translate <0, 380, -736> }

   texture { T_Sandstone }
}

#declare A_WGlass=box { <-35, 40, 0>, <35, 210, 1> texture { T_Beerbottle_Glass } }

#declare A_WBars=union{
   #declare h = -35;
   #while (h < 36)
      cylinder { <h, 40, 0>, <h, 210, 0>, 1 }
      #declare h = h + 5;
   #end
   #declare h = 40;
   #while (h < 211)
      cylinder { <-35, h, 0>, <35, h, 0>, 1 }
      #declare h = h + 8.5;
   #end
   texture { pigment { Gray40 } }
}

#declare A_WWall=union{
   difference {
      box { <-75, 40, -595>, <75, 325, -550> }
      box { <-35, 40, -600>, <35, 250, -500> }
      plane { x, 0 rotate <0,  360/64, 0> }
      plane {-x, 0 rotate <0, -360/64, 0> }
   }
   difference{
      box { <-75, 210, -580>, <75, 406, -550> }
      plane { x, 0 rotate <0,  360/64, 0> }
      plane {-x, 0 rotate <0, -360/64, 0> }
   }

   difference {
      box { <-30, 265, -600>, <30, 310, -595> }
      box { <-27, 268, -601>, <27, 307, -597> }
   }
   cylinder { <-29, 266, -600>, < 29, 266, -600>, 1 }
   cylinder { <-29, 309, -600>, < 29, 309, -600>, 1 }
   cylinder { <-29, 266, -600>, <-29, 309, -600>, 1 }
   cylinder { < 29, 266, -600>, < 29, 309, -600>, 1 }

   cylinder { <-27, 268, -599>, < 27, 268, -599>, 1 }
   cylinder { <-27, 307, -599>, < 27, 307, -599>, 1 }
   cylinder { <-27, 268, -599>, <-27, 307, -599>, 1 }
   cylinder { < 27, 268, -599>, < 27, 307, -599>, 1 }

   cylinder { <-24, 271, -599>, < 24, 271, -599>, 1 }
   cylinder { <-24, 304, -599>, < 24, 304, -599>, 1 }
   cylinder { <-24, 271, -599>, <-24, 304, -599>, 1 }
   cylinder { < 24, 271, -599>, < 24, 304, -599>, 1 }

   cylinder { <-22, 273, -598>, < 22, 273, -598>, 1 }
   cylinder { <-22, 302, -598>, < 22, 302, -598>, 1 }
   cylinder { <-22, 273, -598>, <-22, 302, -598>, 1 }
   cylinder { < 22, 273, -598>, < 22, 302, -598>, 1 }

   texture { T_Sandstone }
}

#declare A_Window=union{
   object { A_WWall }
   object { A_WGlass translate <0, 0, -565> }
   object { A_WBars translate <0, 0, -565> }
}

#declare A_WindowTrio=union{
   object { A_Window rotate <0,   360/32, 0> }
   object { A_Window rotate <0, 2*360/32, 0> }
   object { A_Window rotate <0, 3*360/32, 0> }
}

#declare Arcade=union{
   #declare ang=360/64;
   #while (ang < 360)
      object { Pillar translate <0, 0, -740> rotate <0, ang, 0> }
      #declare ang = ang + 360/32;
   #end
   #declare ang=0;
   #while (ang < 360)
      object { Niche rotate <0, ang, 0> }
      object { ArcPair rotate <0, ang, 0> }
      object { A_WindowTrio rotate <0, ang, 0> }
      #declare ang = ang + 360/8;
   #end
}

/*------------ Entablement ---------------*/

#declare Entablement=union{
   cylinder { <0,  0, 0>, <0,  6, 0>, 762 }
   cylinder { <0,  6, 0>, <0, 14, 0>, 764 }
   cylinder { <0, 14, 0>, <0, 16, 0>, 763 }
   cylinder { <0, 16, 0>, <0, 66, 0>, 764 }
   torus { 764, 2 translate <0, 18, 0> }
   #declare ang=0;
   #while (ang < 360)
      box { <-5, 56, -788>, <5, 66, 760> rotate <0, ang, 0> }
      #declare ang = ang + 360/192;
   #end
   cylinder { <0, 66, 0>, <0, 74, 0>, 792 }
   cylinder { <0, 74, 0>, <0, 82, 0>, 796 }
   texture { T_Sandstone }
}

/*------------ Balustrade ----------------*/

#declare Baluster=union{
   cylinder { <0, 0, 0>, <0, 2, 0>, 7.5 }
   cone { <0, 2, 0>, 7.5, <0, 4, 0>, 5.5 }
   cylinder { <0, 4, 0>, <0, 8, 0>, 5.5 }
   torus { 5.5, 2 translate <0, 6, 0> }
   difference{
      sphere { <0, 14, 0>, 7.5 }
      plane { -y, 0 translate <0, 15.367, 0> }
   }
   cone { <0, 15.367, 0>, 7.3913, <0, 31, 0>, 4.5 }
   cylinder { <0, 31, 0>, <0, 35, 0>, 4.5 }
   torus { 4.5, 2 translate <0, 33, 0> }
   sphere { < 0, 0, 0> 7.5 scale <1.0, 0.8, 1.0> translate <0, 40, 0> }
   cone { <0, 45, 0>, 5.5, <0, 47, 0>, 7.5 }
   cylinder { <0, 47, 0>, <0, 49, 0>, 7.5 }

   texture { T_Sandstone }
}

#declare B_Sokkel=difference{
   union{
      cylinder { <0, 0, 0>, <0, 21, 0>, 771 }
      cone { <0, 21, 0>, 771, <0, 32, 0>, 767.5 }
   }
   cylinder { <0, -1, 0>, <0, 33, 0>, 750 }
   texture { T_Sandstone }
}

#declare B_Pillar=union{
   box { <-15.5, 0, -776>, <15.5, 21, -750> }
   intersection{
      box { <-15.5, 21, -776>, <15.5, 32, -750> }
      plane { x, 0 rotate <0, 0, 12.8> translate < 15.5, 21, 0> }
      plane {-x, 0 rotate <0, 0,-12.8> translate <-15.5, 21, 0> }
      plane {-z, 0 rotate <19.98, 0, 0> translate <0, 21, -776> }
   }
   box { <-13, 32, -772>, <13, 81, -750> }
   texture { T_Sandstone }
}

#declare B_Rail=union{
   difference{
      cylinder { <0,  0, 0>, <0, 12, 0>, 772 }
      cylinder { <0, -1, 0>, <0, 13, 0>, 750 }
   }
   torus { 772, 2.5 translate <0, 9.5, 0> }
   torus { 750, 2.5 translate <0, 9.5, 0> }
   texture { T_Sandstone }
}

#declare Balustrade=union{
   object { B_Sokkel }

   #declare ang=0;
   #while (ang < 360)
      object { Baluster translate <0, 32, -760> rotate <0, ang, 0> }
      #declare ang = ang + 360/224;
   #end

   #declare ang=360/64;
   #while (ang < 360)
      object { B_Pillar rotate <0, ang, 0> }
      #declare ang = ang + 360/32;
   #end

   object { B_Rail translate <0, 81, 0> }
}

/*------------ Galleri ----------------*/

#declare FlatPillar=union{
   difference{
      box { <-16, 0, -16>, <16, 274, 16> }
      #declare h=27;
      #while (h < 270)
	 cylinder { <-20, h, -16.5>, < 20, h, -16.5>, 1 }
	 cylinder { <-16, h, -20>, <-16, h,  20>, 1 }
	 cylinder { < 16, h, -20>, < 16, h,  20>, 1 }
	 #declare h = h + 27;
      #end
   }
   cylinder { <-17, 272, -17>, < 17, 272,-17>, 2 }
   cylinder { <-17, 272, -17>, <-17, 272, 17>, 2 }
   cylinder { < 17, 272, -17>, < 17, 272, 17>, 2 }
   sphere { <-17, 272, -17>, 2 }
   sphere { < 17, 272, -17>, 2 }

   box { <-15.5, 274, -15.5>, <15.5, 305, 15.5> }

   box { <-20.5, 296, -24>, <-15.5, 305, 15.5> }
   box { <-11.5, 296, -24>, < -6.5, 305, 15.5> }
   box { < -2.5, 296, -24>, <  2.5, 305, 15.5> }
   box { <  6.5, 296, -24>, < 11.5, 305, 15.5> }
   box { < 15.5, 296, -24>, < 20.5, 305, 15.5> }

   box { <-29, 305, -34>, <29, 316, 16> }

   cylinder { <-30, 320, -34>, <-25, 320, -34>, 4 }
   cylinder { <-24, 320, -34>, <-19, 320, -34>, 4 }
   cylinder { <-18, 320, -34>, <-13, 320, -34>, 4 }
   cylinder { <-12, 320, -34>, < -7, 320, -34>, 4 }
   cylinder { < -6, 320, -34>, < -1, 320, -34>, 4 }
   cylinder { <  0, 320, -34>, <  5, 320, -34>, 4 }
   cylinder { <  6, 320, -34>, < 11, 320, -34>, 4 }
   cylinder { < 12, 320, -34>, < 17, 320, -34>, 4 }
   cylinder { < 18, 320, -34>, < 23, 320, -34>, 4 }
   cylinder { < 24, 320, -34>, < 30, 320, -34>, 4 }

   box { <-30, 316, -34>, <30, 324, 16> }

   texture { T_Sandstone }
}

#declare Blind=union{
   difference{
      box { <-43, 0, -6>, <43, 304, 16> }
      box { <-26, 182, -10>, <26, 252, 20> }
      #declare h=27;
      #while (h < 270)
	 cylinder { <-50, h, -6.5>, < 50, h, -6.5>, 1 }
	 #declare h = h + 27;
      #end
   }

   box { <-26, 257, -9>, <-15, 305, 0> }
   box { <-15, 262, -9>, < 15, 305, 0> }
   box { < 15, 257, -9>, < 26, 305, 0> }

   cylinder { <-43, 272,  -6>, <43, 272, -6>, 2 }

   cylinder { <-36, 262,  -6>, < 36, 262, -6>, 2 }
   sphere { <-36, 262,  -6>, 2 }
   sphere { < 36, 262,  -6>, 2 }
   cylinder { <-36, 238,  -6>, <-36, 262, -6>, 2 }
   cylinder { < 36, 238,  -6>, < 36, 262, -6>, 2 }
   cylinder { <-34, 175,  -6>, <-34, 240, -6>, 2 }
   cylinder { < 34, 175,  -6>, < 34, 240, -6>, 2 }
   cylinder { <-34, 175,  -6>, <-19, 175, -6>, 2 }
   sphere { <-34, 175,  -6>, 2 }
   cylinder { < 19, 175,  -6>, < 34, 175, -6>, 2 }
   sphere { < 34, 175,  -6>, 2 }
   cylinder { <-21, 171,  -6>, < 21, 171, -6>, 2 }

   cylinder { <-36, 162,  -6>, < 36, 162, -6>, 2 }
   sphere { <-36, 162,  -6>, 2 }
   sphere { < 36, 162,  -6>, 2 }
   cylinder { <-36,  42,  -6>, < 36,  42, -6>, 2 }
   sphere { <-36,  42,  -6>, 2 }
   sphere { < 36,  42,  -6>, 2 }
   cylinder { <-36,  42,  -6>, <-36, 162, -6>, 2 }
   cylinder { < 36,  42,  -6>, < 36, 162, -6>, 2 }
   cylinder { <-36, 160,  -6>, < 36, 160, -6>, 1.5 }
   cylinder { <-36,  44,  -6>, < 36,  44, -6>, 1.5 }
   cylinder { <-34,  44,  -6>, <-34, 160, -6>, 1.5 }
   cylinder { < 34,  44,  -6>, < 34, 160, -6>, 1.5 }
   cylinder { <-34, 158,  -6>, < 34, 158, -6>, 1 }
   cylinder { <-34,  46,  -6>, < 34,  46, -6>, 1 }
   cylinder { <-32,  46,  -6>, <-32, 158, -6>, 1 }
   cylinder { < 32,  46,  -6>, < 32, 158, -6>, 1 }

   box { <-30.5, 296, -16>, <-25.5, 305, 16> }
   box { <-22.5, 296, -16>, <-17.5, 305, 16> }
   box { <-14.5, 296, -16>, < -9.5, 305, 16> }
   box { < -6.5, 296, -16>, < -1.5, 305, 16> }
   box { <  1.5, 296, -16>, <  6.5, 305, 16> }
   box { <  9.5, 296, -16>, < 14.5, 305, 16> }
   box { < 17.5, 296, -16>, < 22.5, 305, 16> }
   box { < 25.5, 296, -16>, < 30.5, 305, 16> }

   box { <-43, 305, -18>, <43, 316, 16> }

   cylinder { <-30, 320, -20>, <-25, 320, -20>, 4 }
   cylinder { <-24, 320, -20>, <-19, 320, -20>, 4 }
   cylinder { <-18, 320, -20>, <-13, 320, -20>, 4 }
   cylinder { <-12, 320, -20>, < -7, 320, -20>, 4 }
   cylinder { < -6, 320, -20>, < -1, 320, -20>, 4 }
   cylinder { <  0, 320, -20>, <  5, 320, -20>, 4 }
   cylinder { <  6, 320, -20>, < 11, 320, -20>, 4 }
   cylinder { < 12, 320, -20>, < 17, 320, -20>, 4 }
   cylinder { < 18, 320, -20>, < 23, 320, -20>, 4 }
   cylinder { < 24, 320, -20>, < 29, 320, -20>, 4 }

   texture { T_Sandstone }
}

#declare G_Window=union{
   #declare h = 182 + (70 / 8);
   #while (h < 252)
      cylinder { <-26, h, 15>, <26, h, 15>, 1 }
      #declare h = h + (70 / 8);
   #end
   #declare h = -26 + (52 / 12);
   #while (h < 26)
      cylinder { <h, 182, 15>, <h, 252,  15>, 1 }
      #declare h = h + (52 / 12);
   #end
   texture { pigment { Gray40 } }
}

#declare G_WGlass=box { <-26, 182, 15>, <26, 252, 16> texture { T_Beerbottle_Glass } }

#declare Gallery=union{
   #declare ang=360/64;
   #while (ang < 360)
      object { FlatPillar translate <0, 0, -610> rotate <0, ang, 0> }
      #declare ang = ang + 360/32;
   #end
   #declare ang=0;
   #while (ang < 360)
      object { Blind    translate <0, 0, -610> rotate <0, ang, 0> }
      object { G_Window translate <0, 0, -610> rotate <0, ang, 0> }
      object { G_WGlass translate <0, 0, -610> rotate <0, ang, 0> }
      #declare ang = ang + 360/32;
   #end
}

/*------------ Kuppel ----------------*/

#declare Ring=union{
   cylinder { <0,  0, 0>, <0, 16, 0>, 628 }
   cylinder { <0, 16, 0>, <0, 53, 0>, 626 }
   torus { 626, 8.5 translate <0, 44.5, 0> }
   cylinder { <0, 53, 0>, <0, 93, 0>, 604 }
   torus { 604, 9 translate <0, 84, 0> }
   texture { T_Lead scale <1.0, 100, 1.0> }
}

#declare Dome_A=difference{
   union{
      difference{
	 sphere { <0, 0, 0>, 592 scale <1, 1.1, 1> }
	 plane { x, 0 rotate <0, 360/64, 0> }
	 plane {-x, 0 rotate <0, -(360/64), 0> }
      }
      torus { 592, 9 rotate <90, 84.375, 0> scale <1, 1.1, 1>}
      torus { 592, 9 rotate <90, 95.625, 0> scale <1, 1.1, 1>}
      difference{
	 torus { 592, 3 rotate <90, 86.3, 0> scale <1, 1.1, 1>}
	 plane { y, 0 translate <0, 48, 0> }
      }
      difference{
	 torus { 592, 3 rotate <90, 93.7, 0> scale <1, 1.1, 1>}
	 plane { y, 0 translate <0, 48, 0> }
      }
      difference{
	 torus {  38, 3 rotate <92, 0, 0> translate <0, 48, -590> }
	 plane {-y, 0 translate <0, 48, 0> }
      }
   }
   plane { y, 0 }
   cylinder { <0, 555, 0>, <0, 1000, 0>, 295 }
   plane {-z, 0 }
}

#declare Dome_B=difference{
   union{
      difference{
	 sphere { <0, 0, 0>, 592 scale <1, 1.1, 1> }
	 plane { x, 0 rotate <0, 360/64, 0> }
	 plane {-x, 0 rotate <0, -(360/64), 0> }
      }
      torus { 592, 9 rotate <90, 84.375, 0> scale <1, 1.1, 1>}
      torus { 592, 9 rotate <90, 95.625, 0> scale <1, 1.1, 1>}
      difference{
	 torus { 592, 3 rotate <90, 86.3, 0> scale <1, 1.1, 1>}
	 plane { y, 0 translate <0, 48, 0> }
      }
      difference{
	 torus { 592, 3 rotate <90, 93.7, 0> scale <1, 1.1, 1>}
	 plane { y, 0 translate <0, 48, 0> }
      }
      difference{
	 torus {  38, 3 rotate <92, 0, 0> translate <0, 48, -590> }
	 plane {-y, 0 translate <0, 48, 0> }
      }
   }
   plane { y, 0 }
   cylinder { <0, 555, 0>, <0, 1000, 0>, 170 }
   plane {-z, 0 }
}

#declare LeadDome=union{
   #declare ang = 0;
   #while (ang < 360 )
      object { Dome_B rotate <0,  360/32*2+ang, 0> }
      object { Dome_A rotate <0,    360/32+ang, 0> }
      object { Dome_A rotate <0,         0+ang, 0> }
      object { Dome_A rotate <0, -(360/32)+ang, 0> }
      #declare ang = ang + 45;
   #end
   texture { T_Lead  scale <1.0, 650, 1.0> }
}

#declare D_Win=difference{
   cylinder { <0, 560, 0>, <0, 608, 0>, 170.1 }
   plane { x, 0 translate <-12, 0, 0> }
   plane {-x, 0 translate < 12, 0, 0> }
   texture { pigment { color Gray40 } }
}

#declare DomeWindow=union{
   cylinder { <0, 555, 0>, <0, 620, 0>, 170 texture { T_Sandstone } }
   cylinder { <0, 620, 0>, <0, 635, 0>, 173 texture { T_Sandstone } }
   #declare ang = 0;
   #while (ang < 180 )
      object { D_Win rotate <0, ang-9, 0> }
      object { D_Win rotate <0, ang, 0> }
      object { D_Win rotate <0, ang+9, 0> }
      #declare ang = ang + 45;
   #end
}

#declare Dome=union{
   object { Ring }
   object { LeadDome   translate <0, 93, 0> }
   object { DomeWindow translate <0, 93, 0> }
}

/*------------ Platform ----------------*/

#declare Pattern=union{
   box { <-5, 5, -2>, <5, 25, 2> }
   cylinder { <0, 25, -2>, <0, 25, 2>, 5 }
   box { <-3, 7, -2>, <3, 25, 3> }
   cylinder { <0, 25, -2>, <0, 25, 3>, 3 }
   translate  <0, 0, -175>
}

#declare SnirkelDel=union{
   cylinder { <0, 32, 0>, <0, 32, -6>, 3 }
   difference{
      torus { 7, 3 rotate <0, 0, 90> }
      plane { -z, 0 }
      plane { -z, 0 rotate <31.373, 0, 0> }
      translate <0, 25, -6>
   }
   difference{
      torus { 17, 3 rotate <0, 0, 90> }
      plane { y, 0 translate <0, 1, 0> }
      plane { z, 0 rotate <31.373, 0, 0> }
      translate <0, 4.5, -18.5>
   }
   torus { 3, 3 rotate <0, 0, 90> translate <0, 25, -6> }
   sphere { <0, 25, -6>, 3 }
}

#declare Snirkel=union{
   object { SnirkelDel translate <-6, 0, 0> }
   object { SnirkelDel translate <-2, 0, 0> }
   object { SnirkelDel translate < 2, 0, 0> }
   object { SnirkelDel translate < 6, 0, 0> }
   cylinder { <-6, 5.5, -2>, <6, 5.5, -2>, 3 }
   sphere { <-6, 5.5, -2>, 3 }
   sphere { < 6, 5.5, -2>, 3 }
}

#declare Rekverk=union{
   torus { 174, 0.5  translate <0,  5, 0> }
   torus { 174, 0.5  translate <0, 38, 0> }
   #declare ang = 0;
   #while (ang < 360 )
      cylinder { <0, 5, -174>, <0, 38, -174>, 0.5 rotate <0, ang, 0> }
      #declare ang = ang + 360/192;
   #end
   #declare ang = 0;
   #while (ang < 360 )
      cylinder { <0, 0, -174>, <0, 5, -174>, 0.5 rotate <0, ang, 0> }
      #declare ang = ang + 360/24;
   #end
   texture { T_Gold_3C }
}

#declare Gesims=union{
   torus {175, 4 }
   difference {
      cylinder { <0, 0, 0>, <0, 58, 0>, 175 }
      #declare ang = 0;
      #while (ang < 360 )
	 object { Pattern rotate <0, ang, 0> }
	 #declare ang = ang + 360/64;
      #end
   }
   #declare ang = 360/16;
   #while (ang < 360 )
      object { Snirkel translate <0, 4, -175> rotate <0, ang-(360/64), 0> }
      object { Snirkel translate <0, 4, -175> rotate <0, ang+(360/64), 0> }
      #declare ang = ang + 360/8;
   #end
   difference{
      torus { 175, 12 translate <0, 38, 0> }
      plane { y, 0 translate <0, 38, 0> }
   }
   torus { 175, 2 translate <0, 56, 0> }
   texture { T_Sandstone }
}

#declare Platform=union{
   object { Gesims }
   object { Rekverk translate <0, 58, 0> }
}

/*------------ Fodstykke ----------------*/

#declare F_Door=union{
   box { <-21, 0, -1>, <21, 60, 3> }
   cylinder { <0, 60, -1>, <0, 60, 3>, 21 }
   box { <-18, 0, -1>, <18, 60, 5> }
   cylinder { <0, 60, -1>, <0, 60, 5>, 18 }
}

#declare F_Midt=union{
   difference{
      box { <-31, 0, -125>, < 31, 104, 0> }
      object { F_Door translate <0, 0, -125> }
   }
   box { <-2, 0, -122>, <2, 81, -120> }
   difference{
      box { <-10, 0, -127>, <10, 23, -120> }
      plane { x, 0 rotate <0, 0, 5> translate <-5, 0, 0> }
      plane {-x, 0 rotate <0, 0,-5> translate < 5, 0, 0> }
      translate <0, 80, 0>
   }
   cylinder { <-31, 103, -124>, <31, 103, -124>, 2 }
   cylinder { <-31, 107, -125>, <31, 107, -125>, 2 }
}

#declare F_Window=union{
   box { <-9, 22, -1>, <9, 62, 3> }
   cylinder { <0, 62, -1>, <0, 62, 3>, 9 }
   box { <-7, 25, -1>, <7, 62, 6> }
   cylinder { <0, 62, -1>, <0, 62, 6>, 7 }
}

#declare F_Glass=union{
   box { <-7, 25, 5.5>, <7, 62, 6> }
   cylinder { <0, 62, 5.5>, <0, 62, 6>, 7 }
   texture { pigment { color Gray40 } }
}

#declare F_Side=union{
   difference{
      box { <-21, 0, -132>, <21, 104, 0> }
      object { F_Window translate <0, 0, -132> }
   }
   object { F_Glass translate <0, 0, -132> }
   cylinder { <-10, 22, -132>, <10, 22, -132>, 1 }
   cylinder { <-21, 103, -131>, < 21, 103, -131>, 2 }
   cylinder { <-21, 107, -132>, < 21, 107, -132>, 2 }
   cylinder { <-20, 103, -131>, <-20, 103,    0>, 2 }
   cylinder { <-21, 107, -132>, <-21, 107,    0>, 2 }
   cylinder { < 20, 103, -131>, < 20, 103,    0>, 2 }
   cylinder { < 21, 107, -132>, < 21, 107,    0>, 2 }
   sphere { <-20, 103, -131>, 2 }
   sphere { <-21, 107, -132>, 2 }
   sphere { < 20, 103, -131>, 2 }
   sphere { < 21, 107, -132>, 2 }
}

#declare F_Corner=union{
   box { < -40, 0, -123>, <40, 104, 0> }
   cylinder { <-40, 103, -122>, <40, 103, -122>, 2 }
   cylinder { <-40, 107, -123>, <40, 107, -123>, 2 }
   cylinder { <-40, 114, -138>, <40, 114, -138>, 5 }
   box { <-40, 109, -138>, <40, 119, 0> }
   rotate <0, 45, 0>
}

#declare KvartFod=union{
   object { F_Side translate <-52, 0, 0> }
   object { F_Midt }
   object { F_Side translate < 52, 0, 0> }
   cylinder { <-85, 114, -134>, < 85, 114, -134>, 5 }
   cylinder { <-85, 114, -134>, <-85, 114,    0>, 5 }
   box { <-85, 109, -134>, <85, 119, 0> }
   cylinder { < 85, 114, -134>, < 85, 114,    0>, 5 }
   sphere { <-85, 114, -134>, 5 }
   sphere { < 85, 114, -134>, 5 }
   object { F_Corner }
   texture { T_Sandstone }
}

#declare Fodstykke=union{
   object { KvartFod }
   object { KvartFod rotate <0,  90, 0> }
   object { KvartFod rotate <0, 180, 0> }
   object { KvartFod rotate <0, 270, 0> }
}

/*------------ Trn ----------------*/

#declare Hak=intersection{
   plane { x, 0 translate <-4, 0, 0> }
   plane {-x, 0 rotate <0, 45, 0> translate < 2.828, 0, -2.828> }
}

#declare T_Kapitael=difference{
   cone { <0, 164, 0>, 11, <0, 184, 0>, 17 }
   #declare ang=0;
   #while (ang < 360)
      object { Hak rotate <0, ang, 0> }
      #declare ang = ang + 45;
   #end
}

#declare T_Urn=union{
   cylinder { <0, 0, 0>, <0, 4, 0>, 9 }
   cylinder { <0, 4, 0>, <0, 8, 0>, 7 }
   cone { <0, 0, 0>, 9, <0, 16, 0>, 3 }
   difference{
      sphere { <0, 0, 0>, 10 scale <1, 1.4, 1> translate <0, 25, 0>}
      plane {-y, 0 translate <0, 25, 0> }
   }
   difference{
      sphere { <0, 19.4, 0>, 10.6 }
      plane { y, 0 translate <0, 25, 0> }
   }
   cone { <0, 26, 0>, 3, <0, 60, 0>, 0 }
   sphere { <0, 44, 0>, 3 }
   sphere { <0, 52, 0>, 2 }
   texture { T_Gold_3C }
}

#declare T_Urnpair=union{
   box { <-20, 0, -11>, <20, 4, 11> texture { T_Sandstone }}
   object { T_Urn translate <-10, 4, 0> }
   object { T_Urn translate < 10, 4, 0> }
}

#declare T_Pillar=union{
   box { <-13, 0, -13>, <13, 4, 13> }
   torus { 10, 3 translate <0, 7, 0> }
   torus { 10, 2.5 translate <0, 12, 0> }
   cylinder { <0, 0, 0>, <0, 165, 0>, 11 }
   torus { 10, 2 translate <0, 165, 0> }
   object { T_Kapitael }
   texture { T_Sandstone }
}

#declare T_Pillarpair=union{
   box { <-26, 0, -13>, <26, 6, 13> }
   object { T_Pillar translate <-13, 6, 0> }
   object { T_Pillar translate < 13, 6, 0> }
   texture { T_Sandstone }
}

#declare T_WGlass1=box {
   <-24, 50, 2>, <24, 165, 3>
   texture { pigment { color Gray40 } }
}

#declare T_Side=union{
   difference{
      box { <-60,  0, -100>, <60, 184, 0> }
      box { <-22, 50, -101>, <22, 165, 1> }
   }
   object { T_WGlass1 translate <0, 0, -100> }
   difference{
      box { <-5, 0, -101>, <5, 10, -100> }
      plane { x, 0 rotate <0, 0, 5> translate <-2, 0, 0> }
      plane {-x, 0 rotate <0, 0,-5> translate < 2, 0, 0> }
      translate <0, 165, 0>
   }
   cylinder { <-60, 50, -100>, < 60, 50, -100>, 3 }
   cylinder { <-60, 50, -100>, <-60, 50,    0>, 3 }
   cylinder { < 60, 50, -100>, < 60, 50,    0>, 3 }
   sphere { <-60, 50, -100>, 3 }
   sphere { < 60, 50, -100>, 3 }
   cylinder { <-20, 44, -100>, < 20, 44, -100>, 2 }
   cylinder { <-20, 44, -100>, <-20, 14, -100>, 2 }
   cylinder { < 20, 44, -100>, < 20, 14, -100>, 2 }
   cylinder { <-20, 14, -100>, < 20, 14, -100>, 2 }

   box { <-73, 190, -134>, <73, 238, 0> }
   box { <-76, 194, -137>, <76, 204, 0> }
   cylinder { <-76, 199, -137>, < 76, 199, -137>, 3 }
   cylinder { <-76, 199, -137>, <-76, 199,    0>, 3 }
   cylinder { < 76, 199, -137>, < 76, 199,    0>, 3 }
   sphere { <-76, 199, -137>, 3}
   sphere { < 76, 199, -137>, 3}

   #declare pos = -69;
   #while (pos < 72)
      sphere { <pos, 220, -134>, 4 }
      #declare pos = pos+6;
   #end

   #declare pos = -131;
   #while (pos < -92)
      sphere { <-73, 220, pos>, 4 }
      sphere { < 73, 220, pos>, 4 }
      #declare pos = pos+6;
   #end

   box { <-88, 224, -140>, <88, 234, 0> }
   cylinder { <-88, 229, -140>, < 88, 229, -140>, 3 }
   cylinder { <-88, 229, -140>, <-88, 229,    0>, 3 }
   cylinder { < 88, 229, -140>, < 88, 229,    0>, 3 }
   sphere { <-88, 229, -140>, 3 }
   sphere { < 88, 229, -140>, 3 }

   texture { T_Sandstone }
}

#declare T_Window=union{
   box { <-8, 55, -1>, <8, 130, 5> }
   cylinder { <0, 130, -1>, <0, 130, 5>, 8 }
}

#declare T_WGlass2=union{
   box { <-8, 55, 3>, <8, 130, 4> }
   cylinder { <0, 130, 3>, <0, 130, 4>, 8 }
   texture { pigment { color Gray40 } }
}

#declare T_Corner=union{
   difference{
      box { <-28.3, 0, -113>, <28.3, 184, 0> }
      object { T_Window translate <0, 0, -113> }
   }
   cylinder { <-28.5, 50, -113>, < 28.5, 50, -113>, 3 }

   box { <-25, 190, -120>, <25, 238, 0> }
   box { <-25, 194, -123>, <25, 204, 0> }
   cylinder { <-25, 199, -123>, < 25, 199, -123>, 3 }

   #declare pos = -12;
   #while (pos < 18)
      sphere { <pos, 220, -120>, 4 }
      #declare pos = pos+6;
   #end

   box { <-25, 224, -140>, <25, 234, 0> }
   cylinder { <-25, 229, -140>, < 25, 229, -140>, 3 }

   rotate <0, 45, 0>
   texture { T_Sandstone }
}

#declare KvartTow=union{
   object { T_Side }
   object { T_Corner }
   object { T_WGlass2 translate <0, 0, -113> rotate <0, 45, 0> }
   object { T_Pillarpair translate <-47, 0, -119> }
   object { T_Pillarpair translate < 47, 0, -119> }
   object { T_Urnpair translate <-47, 238, -119> }
   object { T_Urnpair translate < 47, 238, -119> }
}

#declare Tower=union{
   object { KvartTow }
   object { KvartTow rotate <0,  90, 0> }
   object { KvartTow rotate <0, 180, 0> }
   object { KvartTow rotate <0, 270, 0> }
}

/*------------ Loft ----------------*/

#declare L_WGlass=cylinder{
   <0, 88, -75>, <0, 88, 0>, 24
   texture { pigment { Gray40 } }
}

#declare L_Side=union{
   difference{
      union{
	 box { <-48, 0, -80>, <48, 145, 0> }
	 cylinder { <0, 88, -82>, <0, 88, 0>, 30 }
      }
      cylinder { <0, 88, -90>, <0, 88, 0>, 24 }
   }
   box { <-34,  54, -82>, < 34,  60, 0> }
   box { <-34,  54, -82>, <-28, 125, 0> }
   box { < 34,  54, -82>, < 28, 125, 0> }
   box { <-37, 116, -82>, < 37, 125, 0> }
   box { <-37, 108, -82>, <-31, 125, 0> }
   box { < 37, 108, -82>, < 31, 125, 0> }

   box { <-53, 135, -85>, <53, 145, 0> }
   box { <-57, 138, -89>, <57, 142, 0> }

   box { <-47, 145, -79>, <47, 175, 0> }
   box { <-50, 169, -82>, <50, 175, 0> }
   cylinder { <-50, 173, -82>, < 50, 173, -82>, 2 }
   cylinder { <-50, 173, -82>, <-50, 173,   0>, 2 }
   cylinder { < 50, 173, -82>, < 50, 173,   0>, 2 }
   sphere { <-50, 173, -82>, 2 }
   sphere { < 50, 173, -82>, 2 }

   object { L_WGlass }
   texture { T_Sandstone }
}

#declare L_Corner=union{
   box { <-20, 0, -86>, <20, 145, 0> }
   box { <-20, 135, -91>, <20, 145, 0> }
   box { <-20, 138, -95>, <20, 142, 0> }

   cylinder { <-15, 130, -86>, <15, 130, -86>, 2 }
   cylinder { <-15, 130, -86>, <-15, 10, -86>, 2 }
   cylinder { < 15, 130, -86>, < 15, 10, -86>, 2 }
   cylinder { <-15, 10, -86>, <15, 10, -86>, 2 }

   box { <-20, 145, -85>, <20, 175, 0> }
   box { <-20, 169, -88>, <20, 175, 0> }
   cylinder { <-20, 173, -88>, <20, 173, -88>, 2 }

   rotate <0, 45, 0>
   texture { T_Sandstone }
}

#declare KvartLoft=union{
   object { L_Side }
   object { L_Corner }
}

#declare L_Domelead=difference{
   union{
      sphere { <0, 0, 0>, 75 }
      torus { 75, 2 scale <1, 3, 1> rotate <90,  60, 0> }
      torus { 75, 2 scale <1, 3, 1> rotate <90, -60, 0> }
      torus { 75, 2 scale <1, 3, 1> rotate <90,  30, 0> }
      torus { 75, 2 scale <1, 3, 1> rotate <90, -30, 0> }
      scale <1, 1.3, 1>
   }
   plane { y, 0 }
   texture { T_Lead scale <1.0, 100, 1.0> }
}

#declare L_Domegold=union{
   difference{
      union{
	 torus { 77, 2 rotate <90,  60, 0> }
	 torus { 77, 2 rotate <90, -60, 0> }
	 torus { 77, 2 rotate <90,  30, 0> }
	 torus { 77, 2 rotate <90, -30, 0> }
	 scale <1, 1.3, 1>
      }
      plane { y, 0 }
   }
   torus { 11, 2 rotate <-63, 0, 0> translate <0, 50, -65> }
   torus { 11, 2 rotate <-63, 0, 0> translate <0, 50, -65> rotate <0,  90, 0>}
   torus { 11, 2 rotate <-63, 0, 0> translate <0, 50, -65> rotate <0, 180, 0>}
   torus { 11, 2 rotate <-63, 0, 0> translate <0, 50, -65> rotate <0, 270, 0>}
   torus { 25, 3  translate <0, 97, 0> }
   texture { T_Gold_3A }
}

#declare Loft=union{
   object { KvartLoft }
   object { KvartLoft rotate <0,  90, 0> }
   object { KvartLoft rotate <0, 180, 0> }
   object { KvartLoft rotate <0, 270, 0> }
   object { L_Domelead translate <0, 175, 0> }
   object { L_Domegold translate <0, 175, 0> }
   cylinder { <0, -3, 0>, <0, 0, 0>, 11 rotate <-63, 0, 0> translate <0, 225, -65> texture { pigment { Gray40} } }
   cylinder { <0, -3, 0>, <0, 0, 0>, 11 rotate <-63, 0, 0> translate <0, 225, -65> rotate <0,  90, 0> texture { pigment { Gray40} } }
   cylinder { <0, -3, 0>, <0, 0, 0>, 11 rotate <-63, 0, 0> translate <0, 225, -65> rotate <0, 180, 0> texture { pigment { Gray40} } }
   cylinder { <0, -3, 0>, <0, 0, 0>, 11 rotate <-63, 0, 0> translate <0, 225, -65> rotate <0, 270, 0> texture { pigment { Gray40} } }
}

/*------------ Spir ----------------*/

#declare S_Base=union{
   difference{
      cone { <0, 0, 0>, 30, <0, 130, 0>, 17 }
      box { <-40, 45, -40>, <40, 100, 40> }
   }
   sphere { <0, 0, 0>, 45 scale <1, 0.3, 1> translate <0, 20, 0>}
   torus { 24, 6 translate <0, 112, 0> }
   texture { T_Gold_3A }
}

#declare S_SnirkelDel=union{
   cylinder { <0, 48, 0>, <0, 48, -9>, 3 }
   difference{
      torus { 10.5, 3 rotate <0, 0, 90> }
      plane { -z, 0 }
      plane { -z, 0 rotate <31.373, 0, 0> }
      translate <0, 37.5, -9>
   }
   difference{
      torus { 25.5, 3 rotate <0, 0, 90> }
      plane { y, 0 translate <0, 1.5, 0> }
      plane { z, 0 rotate <31.373, 0, 0> }
      translate <0, 6.75, -27.75>
   }
   torus { 4.5, 3 rotate <0, 0, 90> translate <0, 37.5, -9> }
   sphere { <0, 37.5, -9>, 3 }
   torus { 5, 3 rotate <0, 0, 90> translate <0, 2, -3> }
   sphere { <0, 2, -3>, 3 }
   cylinder { <0, 0, 0>, <0, 45, 0>, 3 }
}

#declare S_Snirkel=union{
   object { S_SnirkelDel translate <-2, 0, 0> }
   object { S_SnirkelDel translate < 2, 0, 0> }
   rotate <0, 0, 180>
   translate <0, 51, 0>
   texture { T_Gold_3A }
}

#declare Globe=union{
   sphere { <0, 0, 0>, 40 }
   difference{
      sphere { <0, 0, 0>, 43 }
      box { <-50, -50, -50>, <50, -3, 50> }
      box { <-50,  3, -50>, <-3, 50, -3> }
      box { <-50,  3,  50>, <-3, 50,  3> }
      box { < 50,  3, -50>, < 3, 50, -3> }
      box { < 50,  3,  50>, < 3, 50,  3> }
   }
   texture { T_Gold_3A }
}

#declare CrossArc=difference{
   torus { 35, 8 rotate <90, 0, 0> }
   plane { y, 0 }
   plane { x, 0 }
}

#declare CrossPind=union{
   cylinder { <0, 0, -9>, <0, 0, 9>, 5 }
   sphere { <0, 0, -9>, 3 }
   sphere { <0, 0,  9>, 3 }
}

#declare CrossKryds=union{
   object { CrossPind translate <-18,  18, 0> }
   object { CrossPind translate < 18,  18, 0> }
   object { CrossPind translate <-18, -18, 0> }
   object { CrossPind translate < 18, -18, 0> }
   box { <-14.5, -14.5, -8>, <14.5, 14.5, 8> rotate <0, 0, 45> }
   difference{
      union{
	 sphere { <0, 0, 0>, 27 scale <1, 1, 0.5> }
	 box { <-18, -18, -10>, <18, 18, 10> }
      }
      cylinder { <-20,   0, -30>, <-20,   0, 30>, 11 }
      cylinder { < 20,   0, -30>, < 20,   0, 30>, 11 }
      cylinder { <  0,  20, -30>, <  0,  20, 30>, 11 }
      cylinder { <  0, -20, -30>, <  0, -20, 30>, 11 }
   }
}

#declare Cross=union{
   cylinder { <0, 0, 0>, <0, 150, 0>, 8 }
   cylinder { <-55, 100, 0>, <55, 100, 0>, 8 }
   sphere { <-55, 100, 0>, 8 }
   sphere { < 55, 100, 0>, 8 }
   sphere { < 0, 150, 0>, 8 }
   object { CrossArc translate <-35, 65, 0> }
   object { CrossArc rotate <0, 0,  90> translate < 35,  65, 0> }
   object { CrossArc rotate <0, 0, 180> translate < 35, 135, 0> }
   object { CrossArc rotate <0, 0, 270> translate <-35, 135, 0> }
   object { CrossKryds translate < 0, 100, 0> }
   texture { T_Gold_3C }
}


#declare Spir=union{
   object { S_Base translate <0, 0, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0,   0, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0,  45, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0,  90, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 135, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 180, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 225, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 270, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 315, 0> }
   object { Globe translate <0, 170, 0> }
   object { Cross translate <0, 200, 0> }
}

/*------------ Finished Dome ----------------*/

#declare StPauls=union{
   object { Sokkel }
   object { Arcade }
   object { Entablement translate <0,  406, 0> }
   object { Balustrade  translate <0,  488, 0> }
   object { Gallery     translate <0,  488, 0> }
   object { Dome        translate <0,  812, 0> }
   object { Platform    translate <0, 1538, 0> }
   object { Fodstykke   translate <0, 1596, 0> }
   object { Tower       translate <0, 1715, 0> }
   object { Loft        translate <0, 1953, 0> }
   object { Spir        translate <0, 2228, 0> }
}

