//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 23 lights, 22 materials and 592 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2002 Lutz + Kretzschmar
//

//  Date : 11/02/2002    (02.11.2002)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.01
  ambient_light <0.0,0.0,0.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  charset utf8
  radiosity {
    brightness       1.5
    count            200
    distance_maximum 12.0
    error_bound      1.8
    gray_threshold   0.0
    low_error_factor 1.0
    minimum_reuse    0.01
    nearest_count    5
    recursion_limit  1
    #if (version>3.1)
      adc_bailout      0.01
      max_sample       1.0
      media            on
      normal           off
      always_sample    0

      pretrace_start   0.08
      pretrace_end     0.04
    #end
  }
  photons {
    adc_bailout       0.01
    spacing           0.5
    count             0
    gather            20, 100
    media             6, 1.0
    jitter            1.0
    max_trace_level   15
    autostop          0.5
    radius            1.0
    expand_thresholds 0.2, 35.0
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <    -15.623,      67.864,      76.576>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.73205,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle        120.00000    // Vertical      90.000
  look_at   <      6.131,      67.286,     147.019>
}

//    Other cameras are commented out.
/*
camera {  //  Camera StdCam
  location  <   -114.936,     105.270,     144.165>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.42803,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         72.67500    // Vertical      54.506
  look_at   <      0.000,       0.000,       0.000>
}

*/

//
// *******  L I G H T S *******
//

#declare AreaFire = light_source {   // Arealight AreaFire
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.614, 0.229>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 2
  jitter
  circular
  fade_distance  60.0
  fade_power 1.2
  media_interaction off
  scale 2.0
  translate  <-110.75, 52.0, 9.0>
}


#declare GasLamp1_PointLight = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.750, 0.850, 1.000>
  fade_distance  36.0
  fade_power 1.5
  media_attenuation on
  rotate -0.0*x
  translate  <0.0, 0.0, 1.5>
}

#declare Candle_PointLight = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.957, 0.743>
  fade_distance  12.0
  fade_power 2.0
  media_attenuation on
  photons {
    refraction on
  }
  translate  2.0*z
}

#declare Candle_AreaLight = light_source {   // Arealight Candle_AreaLight
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.800, 0.600>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 2
  jitter
  circular
  fade_distance  24.0
  fade_power 1.2
  media_interaction off
  scale <1.0, 0.5, 1.0>
  rotate <-0.0, -90.0, -90.0>
  translate  2.25*z
}



//
// ********  MATERIALS  *******
//

#include "library.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Group018 = union {
  box { // Brick008
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    rotate -90.0*z
    translate  <-106.0, 29.75, 1.25>
  }
  box { // Brick009
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-107.75, 35.5, 1.25>
  }
  box { // Brick010
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-111.75, 28.0, 1.25>
  }
  box { // Brick030
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-111.75, 77.0, 1.25>
  }
  box { // Brick031
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    rotate -90.0*z
    translate  <-106.0, 75.25, 1.25>
  }
  box { // Brick032
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-107.75, 69.25, 1.25>
  }
}
#declare Group058 = union {
  box { // Brick011
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    rotate -90.0*z
    translate  <-106.0, 33.75, 1.25>
  }
  box { // Brick012
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-111.75, 35.5, 1.25>
  }
  box { // Brick013
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-107.75, 28.0, 1.25>
  }
  box { // Brick033
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    rotate -90.0*z
    translate  <-106.0, 71.0, 1.25>
  }
  box { // Brick034
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-107.75, 77.0, 1.25>
  }
  box { // Brick035
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-111.75, 69.25, 1.25>
  }
  translate  2.5*z
}
#declare Brick016 = object {
  box { // Brick016
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    rotate -90.0*z
    translate  <-106.0, 33.75, 1.25>
  }
}
#declare Group063 = union {
  box { // Brick014
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-107.75, 28.0, 1.25>
  }
  box { // Brick015
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    translate  <-107.75, 77.0, 1.25>
  }
  object { Brick016 }
  object { // Brick017 -> Brick016
    Brick016
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, 7.5, 0.0>
  }
  object { // Brick018 -> Brick016
    Brick016
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, 15.0, 0.0>
  }
  object { // Brick019 -> Brick016
    Brick016
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, 22.5, 0.0>
  }
  object { // Brick020 -> Brick016
    Brick016
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, 30.0, 0.0>
  }
  object { // Brick021 -> Brick016
    Brick016
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, 37.5, 0.0>
  }
  translate  27.5*z
}
#declare Brick001 = object {
  box { // Brick001
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    rotate -90.0*z
    translate  <-106.0, 30.0, 1.25>
  }
}
#declare Group006 = union {
  object { Brick001 }
  object { // Brick002 -> Brick001
    Brick001
    rotate -0.0*z
    translate  <0.0, 7.5, 0.0>
  }
  object { // Brick003 -> Brick001
    Brick001
    rotate -0.0*z
    translate  <0.0, 15.0, 0.0>
  }
  object { // Brick004 -> Brick001
    Brick001
    rotate -0.0*z
    translate  <0.0, 22.5, 0.0>
  }
  object { // Brick005 -> Brick001
    Brick001
    rotate -0.0*z
    translate  <0.0, 30.0, 0.0>
  }
  object { // Brick006 -> Brick001
    Brick001
    rotate -0.0*z
    translate  <0.0, 37.5, 0.0>
  }
  object { // Brick007 -> Brick001
    Brick001
    rotate -0.0*z
    translate  <0.0, 45.0, 0.0>
  }
  translate  30.0*z
}
#declare Brick038 = object {
  box { // Brick038
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    rotate -90.0*z
    translate  <-106.0, 46.75, 1.25>
  }
}
#declare Brick040 = object {
  box { // Brick040
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    rotate -90.0*z
    translate  <-106.0, 58.25, 1.25>
  }
}
#declare Brick022 = object {
  box { // Brick022
    <-1, -1, -1>, <1, 1, 1>
    material {
      BrownBrick
    }
    scale <3.5, 1.75, 1.0>
    rotate -90.0*z
    translate  <-106.0, 30.0, 1.25>
  }
}


#declare Cube132 = object {
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.5, 13.75>
    translate  <-11.5, -7.5, 30.25>
  }
}
#declare Cube134 = object {
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.5, 5.0>
    translate  <-11.5, 2.5, 21.5>
  }
}
#declare Cube136 = object {
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 10.0, 7.0>
    translate  <-11.5, -1.0, 9.5>
  }
}


#declare CSG039 = difference {
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <4.125, 1.125, 4.0>
    translate  2.0*z
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <6.0, 6.0, 2.5>
    rotate -90.0*x
    translate  2.0*z
  }
}
#declare CSG038 = difference {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <4.0, 1.0, 4.0>
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <3.0, 4.0, 2.5>
    rotate -90.0*x
  }
  object { CSG039 }
}


#declare Cylndr089 = object {
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 11.25>
    translate  <8.6, 0.0, 0.125>
  }
}
#declare Cylndr090 = object {
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 8.6>
    rotate -90.0*y
    translate  <8.6, 0.0, 0.125>
  }
}
#declare Sphere002 = object {
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.125
    translate  <8.6, 0.0, 0.125>
  }
}
#declare Cylndr092 = object {
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 11.25>
    translate  <8.6, 0.0, 0.125>
  }
}
#declare Cylndr093 = object {
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 8.6>
    rotate -90.0*y
    translate  <8.6, 0.0, 0.125>
  }
}
#declare Sphere004 = object {
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.125
    translate  <8.6, 0.0, 0.125>
  }
}
#declare CSG034 = intersection {
  torus { // Torus005
    0.125, 0.125  rotate -x*90
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, -1.0, 0.0>
    scale 0.25
  }
  translate  <0.0, -0.75, 0.125>
}


#declare DoorFrameCSGL1_1 = difference {
  box { // DoorFrameL03_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <0.5, 0.5, 41.25>
    translate  <0.938, -1.969, -0.125>
  }
  cylinder { // DoorFrameL04_1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 82.5>
    translate  <0.438, -1.5, -0.25>
  }
}
#declare DoorFrameCSGL2_1 = difference {
  box { // DoorFrameL05_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <0.5, 0.5, 41.25>
    translate  <0.562, 2.0, -0.125>
  }
  cylinder { // DoorFrameL06_1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 82.5>
    translate  <0.062, 1.5, -0.25>
  }
}
#declare DoorFrameL_1 = difference {
  box { // DoorFrameL01_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <1.0, 2.0, 41.0>
  }
  box { // DoorFrameL02_1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 1.0>
    scale <0.5, 2.0156, 41.25>
    rotate 7.125*z
    translate  <1.0, -2.0, -0.125>
  }
  object { DoorFrameCSGL1_1 }
  object { DoorFrameCSGL2_1 }
  box { // DoorFrameL07_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  <0.0, 4.325, 1.0>
    scale <0.125, 0.125, 41.25>
    rotate 7.125*z
    translate  <0.75, 0.0, -0.125>
  }
  box { // DoorFrameL08_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  <0.0, 1.5, 1.0>
    scale <0.125, 0.125, 41.25>
    rotate 7.125*z
    translate  <0.75, 0.0, -0.125>
  }
  box { // DoorFrameL09_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  <0.0, -1.325, 1.0>
    scale <0.125, 0.125, 41.25>
    rotate 7.125*z
    translate  <0.75, 0.0, -0.125>
  }
  box { // DoorFrameL10_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  <0.0, -4.15, 1.0>
    scale <0.125, 0.125, 41.25>
    rotate 7.125*z
    translate  <0.75, 0.0, -0.125>
  }
  box { // DoorFrameL11_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <2.0, 3.0, 1.5>
    rotate <-45.0, 0.0, -0.0>
    translate  80.0*z
  }
  material {
    Oak
  }
  translate  -16.0*y
}
#declare DoorFrameCSGR1_1 = difference {
  box { // DoorFrameR03_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <0.5, 0.5, 41.25>
    translate  <0.938, -1.969, -0.125>
  }
  cylinder { // DoorFrameR04_1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 82.5>
    translate  <0.438, -1.5, -0.25>
  }
}
#declare DoorFrameCSGR2_1 = difference {
  box { // DoorFrameR05_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <0.5, 0.5, 41.25>
    translate  <0.562, 2.0, -0.125>
  }
  cylinder { // DoorFrameR06_1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 82.5>
    translate  <0.062, 1.5, -0.25>
  }
}
#declare DoorFrameR_1 = difference {
  box { // DoorFrameR01_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <1.0, 2.0, 41.0>
  }
  box { // DoorFrameR02_1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 1.0>
    scale <0.5, 2.0156, 41.25>
    rotate 7.125*z
    translate  <1.0, -2.0, -0.125>
  }
  object { DoorFrameCSGR1_1 }
  object { DoorFrameCSGR2_1 }
  box { // DoorFrameR07_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  <0.0, 4.325, 1.0>
    scale <0.125, 0.125, 41.25>
    rotate 7.125*z
    translate  <0.75, 0.0, -0.125>
  }
  box { // DoorFrameR08_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  <0.0, 1.5, 1.0>
    scale <0.125, 0.125, 41.25>
    rotate 7.125*z
    translate  <0.75, 0.0, -0.125>
  }
  box { // DoorFrameR09_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  <0.0, -1.325, 1.0>
    scale <0.125, 0.125, 41.25>
    rotate 7.125*z
    translate  <0.75, 0.0, -0.125>
  }
  box { // DoorFrameR10_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  <0.0, -4.15, 1.0>
    scale <0.125, 0.125, 41.25>
    rotate 7.125*z
    translate  <0.75, 0.0, -0.125>
  }
  box { // DoorFrameR11_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <2.0, 3.0, 1.5>
    rotate <-45.0, 0.0, -0.0>
    translate  80.0*z
  }
  material {
    Oak
  }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  16.0*y
}
#declare DoorFrameCSGT1_1 = difference {
  box { // DoorFrameT03_1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 19.0, 0.5>
    translate  <0.938, 0.0, 3.969>
  }
  cylinder { // DoorFrameT04_1
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <0.5, 0.5, 38.5>
    rotate -90.0*x
    translate  <0.438, 0.0, 3.5>
  }
}
#declare DoorFrameCSGT2_1 = difference {
  box { // DoorFrameT05_1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 19.0, 0.5>
    translate  0.562*x
  }
  cylinder { // DoorFrameT06_1
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <0.5, 0.5, 38.5>
    rotate -90.0*x
    translate  <0.062, 0.0, 0.5>
  }
}
#declare DoorFrameT_1 = difference {
  box { // DoorFrameT01_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <1.0, 18.0, 2.0>
  }
  box { // DoorFrameT02_1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <0.5, 19.0, 2.0156>
    rotate <0.0, 7.125, -0.0>
    translate  0.5*x
  }
  object { DoorFrameCSGT1_1 }
  object { DoorFrameCSGT2_1 }
  box { // DoorFrameT07_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*y
    translate  14.675*z
    scale <0.125, 19.0, 0.125>
    rotate 7.125*y
    translate  0.5*x
  }
  box { // DoorFrameT08_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*y
    translate  20.325*z
    scale <0.125, 19.0, 0.125>
    rotate 7.125*y
    translate  0.5*x
  }
  box { // DoorFrameT09_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*y
    translate  17.5*z
    scale <0.125, 19.0, 0.125>
    rotate 7.125*y
    translate  0.5*x
  }
  box { // DoorFrameT10_1
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*y
    translate  11.85*z
    scale <0.125, 19.0, 0.125>
    rotate 7.125*y
    translate  0.5*x
  }
  box { // DoorFrameT11_1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    scale <2.0, 1.5, 3.0>
    rotate <45.0, 0.0, -0.0>
    translate  <0.0, -16.0, 2.0>
  }
  box { // DoorFrameT12_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*y
    scale <2.0, 1.5, 3.0>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 16.0, 2.0>
  }
  material {
    Oak90x
  }
  translate  78.0*z
}
#declare DoorFrame1 = union {
  object { DoorFrameL_1 }
  object { DoorFrameR_1 }
  object { DoorFrameT_1 }
  scale <2.0, 1.0, 1.0>
  translate  <-117.0, 132.0, 96.0>
}
#declare CSG004 = difference {
  box { // Door1_Part12
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <0.75, 4.0, 0.5>
    translate  <0.0, 6.0, 69.0>
  }
  box { // Door1_Part13
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    scale <0.3, 4.25, 0.55902>
    rotate <0.0, -26.56505, -0.0>
    translate  <0.25, 6.0, 70.0>
  }
  box { // Door1_Part14
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, -1.0>
    scale <0.3, 4.25, 0.55902>
    rotate <0.0, 26.56505, -0.0>
    translate  <-0.25, 6.0, 70.0>
  }
  box { // Door1_Part15
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    scale <1.0, 0.70711, 0.5>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 3.0, 69.0>
  }
  box { // Door1_Part16
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <1.0, 0.5, 0.70711>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 9.0, 69.0>
  }
  material {
    Oak90x
  }
  translate  <-117.5, 132.0, 96.0>
}
#declare CSG005 = difference {
  box { // Door1_Part17
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <0.75, 4.0, 0.5>
    translate  <0.0, 6.0, 44.0>
  }
  box { // Door1_Part18
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <0.3, 4.25, 0.55902>
    rotate <0.0, 26.56505, -0.0>
    translate  <0.25, 6.0, 44.0>
  }
  box { // Door1_Part19
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale <0.3, 4.25, 0.55902>
    rotate <0.0, -26.56505, -0.0>
    translate  <-0.25, 6.0, 44.0>
  }
  box { // Door1_Part20
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    scale <1.0, 0.5, 0.70711>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 3.0, 45.0>
  }
  box { // Door1_Part21
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <1.0, 0.70711, 0.5>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 9.0, 45.0>
  }
  material {
    Oak90x
  }
  translate  <-117.5, 132.0, 96.0>
}
#declare CSG006 = difference {
  box { // Door1_Part22
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*y
    scale <0.75, 0.5, 13.0>
    translate  <0.0, 9.0, 57.0>
  }
  box { // Door1_Part23
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    scale <0.3, 0.55902, 13.25>
    rotate 26.56505*z
    translate  <0.25, 10.0, 57.0>
  }
  box { // Door1_Part24
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, -1.0, 0.0>
    scale <0.3, 0.55902, 13.25>
    rotate -26.56505*z
    translate  <-0.25, 10.0, 57.0>
  }
  box { // Door1_Part25
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    scale <1.0, 0.5, 0.70711>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 9.0, 69.0>
  }
  box { // Door1_Part26
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 0.70711, 0.5>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 9.0, 45.0>
  }
  material {
    Oak
  }
  translate  <-117.5, 132.0, 96.0>
}
#declare CSG007 = difference {
  box { // Door1_Part27
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    scale <0.75, 0.5, 13.0>
    translate  <0.0, 3.0, 57.0>
  }
  box { // Door1_Part28
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.0>
    scale <0.3, 0.55902, 13.25>
    rotate -26.56505*z
    translate  <0.25, 2.0, 57.0>
  }
  box { // Door1_Part29
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 0.0>
    scale <0.3, 0.55902, 13.25>
    rotate 26.56505*z
    translate  <-0.25, 2.0, 57.0>
  }
  box { // Door1_Part30
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    scale <1.0, 0.70711, 0.5>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 3.0, 69.0>
  }
  box { // Door1_Part31
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 0.5, 0.70711>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 3.0, 45.0>
  }
  material {
    Oak
  }
  translate  <-117.5, 132.0, 96.0>
}
#declare TopPanel1 = union {
  box { // Door1_Part8
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      Oak
    }
    scale <0.75, 3.0, 12.0>
    rotate <0.0, -0.0, -0.0>
    translate  <-117.5, 138.0, 141.0>
  }
  object { CSG004 }
  object { CSG005 }
  object { CSG006 }
  object { CSG007 }
  rotate <-0.0, 0.0, 0.0>
  translate  <117.5, -132.0, -96.0>
}
#declare CSG008 = difference {
  box { // Door1_Part32
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <0.75, 4.0, 0.5>
    translate  <0.0, 6.0, 35.0>
  }
  box { // Door1_Part33
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    scale <0.3, 4.25, 0.55902>
    rotate <0.0, -26.56505, -0.0>
    translate  <0.25, 6.0, 36.0>
  }
  box { // Door1_Part34
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, -1.0>
    scale <0.3, 4.25, 0.55902>
    rotate <0.0, 26.56505, -0.0>
    translate  <-0.25, 6.0, 36.0>
  }
  box { // Door1_Part35
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    scale <1.0, 0.70711, 0.5>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 3.0, 35.0>
  }
  box { // Door1_Part36
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <1.0, 0.5, 0.70711>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 9.0, 35.0>
  }
  material {
    Oak90x
  }
}
#declare CSG009 = difference {
  box { // Door1_Part37
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <0.75, 4.0, 0.5>
    translate  <0.0, 6.0, 8.0>
  }
  box { // Door1_Part38
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <0.3, 4.25, 0.55902>
    rotate <0.0, 26.56505, -0.0>
    translate  <0.25, 6.0, 8.0>
  }
  box { // Door1_Part39
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale <0.3, 4.25, 0.55902>
    rotate <0.0, -26.56505, -0.0>
    translate  <-0.25, 6.0, 8.0>
  }
  box { // Door1_Part40
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    scale <1.0, 0.5, 0.70711>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 3.0, 9.0>
  }
  box { // Door1_Part41
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <1.0, 0.70711, 0.5>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 9.0, 9.0>
  }
  material {
    Oak90x
  }
}
#declare CSG059 = difference {
  box { // Door1_Part42
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*y
    scale <0.75, 0.5, 14.0>
    translate  <0.0, 9.0, 22.0>
  }
  box { // Door1_Part43
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    scale <0.3, 0.55902, 14.25>
    rotate 26.56505*z
    translate  <0.25, 10.0, 22.0>
  }
  box { // Door1_Part44
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, -1.0, 0.0>
    scale <0.3, 0.55902, 14.25>
    rotate -26.56505*z
    translate  <-0.25, 10.0, 22.0>
  }
  box { // Door1_Part45
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    scale <1.0, 0.5, 0.70711>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 9.0, 35.0>
  }
  box { // Door1_Part46
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 0.70711, 0.5>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 9.0, 9.0>
  }
  material {
    Oak
  }
}
#declare CSG070 = difference {
  box { // Door1_Part47
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    scale <0.75, 0.5, 14.0>
    translate  <0.0, 3.0, 22.0>
  }
  box { // Door1_Part48
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.0>
    scale <0.3, 0.55902, 14.25>
    rotate -26.56505*z
    translate  <0.25, 2.0, 22.0>
  }
  box { // Door1_Part49
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 0.0>
    scale <0.3, 0.55902, 14.25>
    rotate 26.56505*z
    translate  <-0.25, 2.0, 22.0>
  }
  box { // Door1_Part50
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    scale <1.0, 0.70711, 0.5>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 3.0, 35.0>
  }
  box { // Door1_Part51
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 0.5, 0.70711>
    rotate <-45.0, 0.0, -0.0>
    translate  <0.0, 3.0, 9.0>
  }
  material {
    Oak
  }
}
#declare BottomPanel1 = union {
  box { // Door1_Part10
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      Oak
    }
    scale <0.75, 3.0, 13.0>
    translate  <0.0, 6.0, 9.0>
  }
  object { CSG008 }
  object { CSG009 }
  object { CSG059 }
  object { CSG070 }
}
#declare DoorKnob1 = union {
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 1.2, 2.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.5, 1.0, 1.0>
    translate  <2.0, 0.0, 0.7>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    rotate 90.0*y
    translate  <0.6, 0.0, 0.7>
  }
  material {
    Iron
  }
  translate  <0.0, -12.0, 36.0>
}
#declare Door1 = union {
  box { // Door1_Part1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      Oak
    }
    scale <0.5, 2.0, 39.0>
    translate  -12.0*y
  }
  box { // Door1_Part2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      Oak
    }
    scale <0.5, 2.0, 39.0>
    translate  12.0*y
  }
  box { // Door1_Part3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      Oak90x
    }
    scale <0.5, 10.0, 4.0>
  }
  box { // Door1_Part4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      Oak90x
    }
    scale <0.5, 10.0, 4.0>
    translate  36.0*z
  }
  box { // Door1_Part5
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      Oak90x
    }
    scale <0.5, 10.0, 4.0>
    translate  70.0*z
  }
  box { // Door1_Part6
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      Oak
    }
    scale <0.5, 2.0, 14.0>
    translate  8.0*z
  }
  box { // Door1_Part7
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      Oak
    }
    scale <0.5, 2.0, 13.0>
    translate  44.0*z
  }
  object { TopPanel1 }
  object { // TopPanel2 -> TopPanel1
    TopPanel1
    rotate <-0.0, 0.0, 0.0>
    translate  <0.0, -12.0, 0.0>
  }
  object { BottomPanel1 }
  object { // BottomPanel2 -> BottomPanel1
    BottomPanel1
    translate  -12.0*y
  }
  object { DoorKnob1 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.5, -14.0, 0.0>
  translate  <-117.0, 146.0, 96.0>
}


#declare CSG042 = difference {
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <2.0, 2.0, 0.125>
    translate  1.25*z
  }
  cone { // GasLamp1_EndoGlass1
    <0,0,0>, 1.25, <0,0,1>, 2.125
    scale <0.93, 0.93, 1.85>
    translate  -0.05*z
  }
}
#declare GasLamp1_Glass = difference {
  cone { // GasLamp1_ExoGlass
    <0,0,0>, 1.25, <0,0,1>, 2.0
    scale <1.0, 1.0, 1.75>
  }
  cone { // GasLamp1_EndoGlass
    <0,0,0>, 1.25, <0,0,1>, 2.125
    scale <0.9, 0.9, 1.85>
    translate  -0.05*z
  }
  object { CSG042 }
  material {
    FrostedGlass
  }
  no_shadow
  hollow
  photons {
    pass_through
  }
}
#declare GasLamp1_BaseA = difference {
  cone { // GasLamp1_ExoBaseA
    <0,0,0>, 0.5, <0,0,1>, 1.25
    translate  -1.0*z
    scale <1.0, 1.0, 0.5>
  }
  cone { // GasLamp1_EndoBaseA
    <0,0,0>, 0.125, <0,0,1>, 0.5
    translate  -1.0*z
    scale <1.0, 1.0, 0.6>
    translate  0.1*z
  }
}
#declare GasLamp1_WallMount = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -2.0>,
  <1.0, -2.0>,
  <2.0, 1.0>,
  <1.5, 1.5>,
  <-1.5, 1.5>,
  <-2.0, 1.0>,
  <-1.0, -2.0>
  rotate -x*90
  scale <1.0, 1.0, 0.5>
  rotate 90.0*x
  translate  <0.0, 4.0, -1.25>
}
#declare GasLamp1_SwitchGrip1 = object {
  box { // GasLamp1_SwitchGrip1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.01, 0.03>
    rotate -0.0*x
    translate  -2.07*z
  }
}
#declare GasLamp1 = union {
  object { GasLamp1_Glass }
  object { GasLamp1_BaseA }
  cone { // GasLamp1_BaseB
    <0,0,0>, 0.125, <0,0,1>, 0.5
    translate  -1.0*z
    scale <1.0, 1.0, 1.5>
    translate  -0.5*z
  }
  sphere { // GasLamp1_HotFlame
    <0,0,0>,1
    material {
      Flame_Orange
    }
    hollow
    scale 0.5
    translate  1.0*z
  }
  object { GasLamp1_WallMount }
  cylinder { // GasLamp1_Arm
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.5>
    rotate <80.0, -0.0, 0.0>
    translate  <0.0, 3.75, -1.5>
  }
  cylinder { // GasLamp1_SwitchBody
    <0,0,1>, <0,0,0>, 1 
    scale <0.0625, 0.0625, 0.1>
    rotate -0.0*x
    translate  -2.1*z
  }
  object { GasLamp1_SwitchGrip1 }
  object { // GasLamp1_SwitchGrip2 -> GasLamp1_SwitchGrip1
    GasLamp1_SwitchGrip1
    rotate <-0.0, 0.0, -30.0>
    translate  -0.0*y
  }
  object { // GasLamp1_SwitchGrip3 -> GasLamp1_SwitchGrip1
    GasLamp1_SwitchGrip1
    rotate <-0.0, 0.0, -60.0>
    translate  0.0*y
  }
  object { // GasLamp1_SwitchGrip4 -> GasLamp1_SwitchGrip1
    GasLamp1_SwitchGrip1
    rotate <-0.0, 0.0, -90.0>
  }
  object { // GasLamp1_SwitchGrip5 -> GasLamp1_SwitchGrip1
    GasLamp1_SwitchGrip1
    rotate <-0.0, 0.0, -120.0>
  }
  object { // GasLamp1_SwitchGrip6 -> GasLamp1_SwitchGrip1
    GasLamp1_SwitchGrip1
    rotate <-0.0, 0.0, -150.0>
  }
  object { GasLamp1_PointLight }
  sphere { // Sphere013
    <0,0,0>,1
    material {
      Flame_Blue
    }
    hollow
    scale <1.0, 1.0, 1.5>
    translate  1.5*z
  }
  material {
    Iron
  }
  scale 1.5
  translate  <-55.0, 144.0, 150.0>
}
#declare GasLamp3 = object {
  object { // GasLamp3 -> GasLamp1
    GasLamp1
    rotate <-0.0, 0.0, 180.0>
    translate  <-44.0, 30.0, 0.0>
  }
}


#declare CSG010 = difference {
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <2.0, 2.0, 1.0>
  }
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <1.5, 2.1, 0.8>
    rotate -45.0*y
    translate  -2.0*x
  }
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale <1.5, 2.1, 0.8>
    rotate 45.0*y
    translate  2.0*x
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <2.1, 1.5, 0.8>
    rotate 45.0*x
    translate  -2.0*y
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    scale <2.1, 1.5, 0.8>
    rotate -45.0*x
    translate  2.0*y
  }
  translate  35.5*z
}
#declare CSG001 = union {
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <2.0, 2.0, 1.25>
  }
  cone { // Cone019
    <0,0,0>, 2.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 3.0>
    translate  2.5*z
  }
  cone { // Cone020
    <0,0,0>, 1.0, <0,0,1>, 2.0
    scale <1.0, 1.0, 8.0>
    translate  5.5*z
  }
  cone { // Cone021
    <0,0,0>, 2.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 13.0>
    translate  13.5*z
  }
  cone { // Cone022
    <0,0,0>, 1.0, <0,0,1>, 2.0
    scale <1.0, 1.0, 3.0>
    translate  26.5*z
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <2.0, 2.0, 3.0>
    translate  29.5*z
  }
  object { CSG010 }
  sphere { // Sphere009
    <0,0,0>,1
    scale <1.5, 1.5, 1.0>
    translate  38.0*z
  }
  translate  <-9.0, 86.0, 8.5>
}
#declare Cylndr008 = object {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 33.5>
    translate  <-91.0, 86.0, 88.0>
  }
}
#declare Cylndr018 = object {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 29.5>
    translate  <-87.0, 86.0, 88.0>
  }
}
#declare Cylndr028 = object {
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 32.0>
    translate  <-90.0, 116.0, 96.0>
  }
}
#declare Cylndr050 = object {
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 32.0>
    translate  <-2.0, 112.0, 96.0>
  }
}
#declare WalkwaySpindles1 = union {
  object { Cylndr050 }
  object { // Cylndr051 -> Cylndr050
    Cylndr050
    translate  -4.0*y
  }
  object { // Cylndr052 -> Cylndr050
    Cylndr050
    translate  -8.0*y
  }
  object { // Cylndr053 -> Cylndr050
    Cylndr050
    translate  -12.0*y
  }
  object { // Cylndr054 -> Cylndr050
    Cylndr050
    translate  -16.0*y
  }
  object { // Cylndr055 -> Cylndr050
    Cylndr050
    translate  -20.0*y
  }
  object { // Cylndr056 -> Cylndr050
    Cylndr050
    translate  -24.0*y
  }
  object { // Cylndr072 -> Cylndr050
    Cylndr050
    translate  -28.0*y
  }
  object { // Cylndr073 -> Cylndr050
    Cylndr050
    translate  -32.0*y
  }
  object { // Cylndr074 -> Cylndr050
    Cylndr050
    translate  -36.0*y
  }
  object { // Cylndr075 -> Cylndr050
    Cylndr050
    translate  -40.0*y
  }
  object { // Cylndr076 -> Cylndr050
    Cylndr050
    translate  -44.0*y
  }
  object { // Cylndr077 -> Cylndr050
    Cylndr050
    translate  -48.0*y
  }
  object { // Cylndr078 -> Cylndr050
    Cylndr050
    translate  -52.0*y
  }
  object { // Cylndr079 -> Cylndr050
    Cylndr050
    translate  -56.0*y
  }
  object { // Cylndr080 -> Cylndr050
    Cylndr050
    translate  -60.0*y
  }
  object { // Cylndr081 -> Cylndr050
    Cylndr050
    translate  -64.0*y
  }
  object { // Cylndr082 -> Cylndr050
    Cylndr050
    translate  -68.0*y
  }
  object { // Cylndr083 -> Cylndr050
    Cylndr050
    translate  -72.0*y
  }
  object { // Cylndr084 -> Cylndr050
    Cylndr050
    translate  -76.0*y
  }
  object { // Cylndr085 -> Cylndr050
    Cylndr050
    translate  -80.0*y
  }
  object { // Cylndr086 -> Cylndr050
    Cylndr050
    translate  -84.0*y
  }
  object { // Cylndr087 -> Cylndr050
    Cylndr050
    translate  -88.0*y
  }
  object { // Cylndr088 -> Cylndr050
    Cylndr050
    translate  -92.0*y
  }
}
#declare Cylndr113 = object {
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 32.0>
    translate  <-99.0, 86.0, 96.0>
  }
}


#declare Cube093 = object {
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 2.0, 4.0>
    translate  <-54.5, 61.0, 92.0>
  }
}


#declare Cube016 = object {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <13.0, 66.0, 0.5>
    translate  <71.0, -54.0, 6.0>
  }
}
#declare Cube104 = object {
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <13.0, 1.0, 80.0>
    translate  <35.0, 11.25, 0.0>
  }
}


#declare Cube107 = object {
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <6.0, 1.0, 80.0>
    translate  <78.0, 11.25, 0.0>
  }
}
#declare Cube003 = object {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 66.0, 0.5>
    translate  <78.0, -54.0, 6.0>
  }
}


#declare Group007 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 15.0, 0.5>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <0.5, 0.5, 30.0>
    rotate -90.0*x
    translate  4.0*x
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <0.5, 0.5, 8.0>
    rotate -90.0*y
    translate  -15.0*y
  }
  sphere { // Sphere007
    <0,0,0>,1
    scale 0.5
    rotate -0.0*x
    translate  <4.0, -15.0, 0.0>
  }
  sphere { // Sphere008
    <0,0,0>,1
    scale 0.5
    rotate -0.0*x
    translate  <-4.0, -15.0, 0.0>
  }
  translate  <-89.0, 99.0, 88.0>
}


#declare Cube081 = object {
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 15.0, 3.9>
    translate  <-58.49, 75.1, 92.0>
  }
}


#declare RotSweep001 = lathe {
  cubic_spline
  46  // control points
  <0.0, 0.0>,
  <0.0, 0.0>,
  <0.10355, 0.075581>,
  <0.172353, 0.201299>,
  <0.2, 0.375>,
  <0.332501, 0.490799>,
  <0.385, 0.617274>,
  <0.366241, 0.75437>,
  <0.3125, 0.875>,
  <0.384279, 0.966123>,
  <0.432254, 1.040073>,
  <0.47241, 1.128795>,
  <0.4875, 1.212615>,
  <0.491167, 1.312228>,
  <0.471134, 1.427537>,
  <0.42272, 1.534596>,
  <0.3875, 1.625>,
  <0.472241, 1.704741>,
  <0.499841, 1.812586>,
  <0.5625, 1.875>,
  <0.807904, 1.940425>,
  <0.964491, 2.021565>,
  <1.074512, 2.181396>,
  <1.125, 2.375>,
  <1.120281, 2.515103>,
  <1.086846, 2.678798>,
  <1.044805, 2.826306>,
  <1.033333, 2.875>,
  <1.054803, 2.919541>,
  <1.193473, 3.083054>,
  <1.3, 3.5>,
  <1.21755, 3.496497>,
  <1.103876, 3.080576>,
  <0.98275, 2.91808>,
  <0.95305, 2.87721>,
  <0.963124, 2.831178>,
  <1.009468, 2.679371>,
  <1.041856, 2.515372>,
  <1.034526, 2.370101>,
  <0.988274, 2.181488>,
  <0.861468, 2.02157>,
  <0.593082, 1.936964>,
  <0.477502, 1.870521>,
  <0.398414, 1.789224>,
  <0.0, 1.75>,
  <0.0, 1.75>
  rotate <90,0,90>
  material {
    Glass
  }
  photons {
    target 1.0
    refraction on
  }
  translate  -2.03*z
}
#declare Group004 = union {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    translate  17.0*y
    scale <0.0625, 0.0625, 3.0>
    rotate <55.356491, 90.0, 0.0>
  }
}
#declare Candle1 = union {
  object { Candle_PointLight }
  sphere { // Candle_HotFlame
    <0,0,0>,1
    material {
      Flame_Blue
    }
    hollow
    photons {
      pass_through
    }
    scale <0.25, 0.25, 0.5>
    translate  1.5*z
  }
  sphere { // Candle_EndoFlame
    <0,0,0>,1
    material {
      Flame_Yellow
    }
    hollow
    photons {
      pass_through
    }
    scale <0.175, 0.175, 0.75>
    translate  2.25*z
  }
  sphere { // Candle_ExoFlame
    <0,0,0>,1
    material {
      Flame_Orange
    }
    hollow
    photons {
      pass_through
    }
    scale <0.4, 0.4, 1.25>
    translate  2.25*z
  }
  object { Candle_AreaLight }
  object { RotSweep001 }
  torus { // Torus006
    1.09375, 0.09375  rotate -x*90
  }
  cone { // Fake_Candle_Fuel
    <0,0,0>, 0.75, <0,0,1>, 0.75
    material {
      White
    }
    no_image
    no_reflection
    photons {
      pass_through
    }
    translate  -0.0625*z
  }
  translate  7.0625*y
  translate  0.3125*z
}
#declare CSG044 = intersection {
  torus { // Torus007
    0.125, 0.03125  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    scale 0.1
  }
  translate  0.125*z
  rotate 20.0*x
}
#declare CSG045 = intersection {
  torus { // Torus008
    0.125, 0.03125  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, -1.0>
    scale 0.1
  }
  translate  0.125*z
  rotate -20.0*x
}
#declare CSG046 = intersection {
  torus { // Torus009
    0.125, 0.03125  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale 0.1
  }
  translate  -0.125*z
  rotate <20.0, 0.0, -90.0>
  translate  0.501*z
}
#declare CSG047 = intersection {
  torus { // Torus010
    0.125, 0.03125  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale 0.1
  }
  translate  -0.125*z
  rotate <-20.0, 0.0, -90.0>
  translate  0.501*z
}
#declare Group002 = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.03125, 0.03125, 0.29>
    rotate <-2.5, -16.625, 0.0>
  }
  translate  <0.125, 0.0, 0.125>
  rotate 20.0*x
}
#declare Group003 = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.03125, 0.03125, 0.29>
    rotate <-2.5, -16.625, 0.0>
  }
  translate  <0.125, 0.0, 0.125>
  rotate <20.0, 0.0, -180.0>
}
#declare Group001 = union {
  object { CSG044 }
  object { CSG045 }
  object { CSG046 }
  object { CSG047 }
  sphere { // Sphere006
    <0,0,0>,1
    translate  <4.0, 0.0, 4.0>
    scale 0.03125
    rotate <20.0, -0.0, -0.0>
  }
  sphere { // Sphere010
    <0,0,0>,1
    translate  <-4.0, 0.0, 4.0>
    scale 0.03125
    rotate <-20.0, -0.0, -0.0>
  }
  sphere { // Sphere011
    <0,0,0>,1
    translate  <0.0, 4.0, -4.0>
    scale 0.03125
    rotate <0.0, 20.0, -0.0>
    translate  0.5*z
  }
  sphere { // Sphere012
    <0,0,0>,1
    translate  <0.0, -4.0, -4.0>
    scale 0.03125
    rotate <0.0, -20.0, -0.0>
    translate  0.5*z
  }
  object { Group002 }
  object { Group003 }
  material {
    Iron
  }
  rotate <0.0, -180.0, -90.0>
}
#declare Chain1 = union {
  object { Group001 }
  object { // Group021 -> Group001
    Group001
    rotate 0.0*z
    translate  -0.44*z
  }
  object { // Group022 -> Group001
    Group001
    rotate 0.0*z
    translate  -0.88*z
  }
  object { // Group023 -> Group001
    Group001
    rotate 0.0*z
    translate  -1.32*z
  }
  object { // Group024 -> Group001
    Group001
    rotate 0.0*z
    translate  -1.76*z
  }
  object { // Group025 -> Group001
    Group001
    rotate 0.0*z
    translate  -2.2*z
  }
  object { // Group026 -> Group001
    Group001
    rotate 0.0*z
    translate  -2.64*z
  }
  object { // Group027 -> Group001
    Group001
    rotate 0.0*z
    translate  -3.08*z
  }
  object { // Group028 -> Group001
    Group001
    rotate 0.0*z
    translate  -3.52*z
  }
  object { // Group029 -> Group001
    Group001
    rotate 0.0*z
    translate  -3.96*z
  }
  object { // Group030 -> Group001
    Group001
    rotate 0.0*z
    translate  -4.4*z
  }
  object { // Group031 -> Group001
    Group001
    rotate 0.0*z
    translate  -4.84*z
  }
  object { // Group032 -> Group001
    Group001
    rotate 0.0*z
    translate  -5.28*z
  }
  object { // Group033 -> Group001
    Group001
    rotate 0.0*z
    translate  -5.72*z
  }
  object { // Group034 -> Group001
    Group001
    rotate 0.0*z
    translate  -6.16*z
  }
  object { // Group035 -> Group001
    Group001
    rotate 0.0*z
    translate  -6.6*z
  }
  object { // Group036 -> Group001
    Group001
    rotate 0.0*z
    translate  -7.04*z
  }
  object { // Group037 -> Group001
    Group001
    rotate 0.0*z
    translate  -7.48*z
  }
  object { // Group038 -> Group001
    Group001
    rotate 0.0*z
    translate  -7.92*z
  }
  object { // Group039 -> Group001
    Group001
    rotate 0.0*z
    translate  -8.36*z
  }
  object { // Group040 -> Group001
    Group001
    rotate 0.0*z
    translate  -8.8*z
  }
  object { // Group041 -> Group001
    Group001
    rotate 0.0*z
    translate  -9.24*z
  }
  object { // Group042 -> Group001
    Group001
    rotate 0.0*z
    translate  -9.68*z
  }
  object { // Group043 -> Group001
    Group001
    rotate 0.0*z
    translate  -10.12*z
  }
  object { // Group044 -> Group001
    Group001
    rotate 0.0*z
    translate  -10.56*z
  }
  object { // Group046 -> Group001
    Group001
    rotate 0.0*z
    translate  -11.0*z
  }
  object { // Group047 -> Group001
    Group001
    rotate 0.0*z
    translate  -11.44*z
  }
  object { // Group048 -> Group001
    Group001
    rotate 0.0*z
    translate  -11.88*z
  }
  object { // Group049 -> Group001
    Group001
    rotate 0.0*z
    translate  -12.32*z
  }
  object { // Group050 -> Group001
    Group001
    rotate 0.0*z
    translate  -12.76*z
  }
  object { // Group051 -> Group001
    Group001
    rotate 0.0*z
    translate  -13.2*z
  }
  object { // Group052 -> Group001
    Group001
    rotate 0.0*z
    translate  -13.64*z
  }
  rotate -23.888098*y
  translate  <0.0, 0.0, 14.16>
}
#declare Group045 = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.0625, 0.0625, 0.575>
    translate  <5.6875, 0.0, 0.125>
  }
  torus { // Torus001
    0.3125, 0.0625  rotate -x*90
    rotate -90.0*y
    translate  <5.6875, 0.0, 1.0>
  }
  object { Chain1 }
}


#declare Cube039 = object {
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <13.0, 66.0, 0.5>
    translate  <71.0, -54.0, 6.0>
  }
}
#declare Cube105 = object {
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <13.0, 1.0, 80.0>
    translate  <35.0, 11.25, 0.0>
  }
}




//
// ********  OBJECTS  *******
//

mesh2 {   // Tapestry
  vertex_vectors {
    8,
    <-1.0000000, -1.0000000, -1.0000000>,
    <-1.0000000, 1.0000000, -1.0000000>,
    <1.0000000, 1.0000000, -1.0000000>,
    <1.0000000, -1.0000000, -1.0000000>,
    <-1.0000000, -1.0000000, 1.0000000>,
    <-1.0000000, 1.0000000, 1.0000000>,
    <1.0000000, 1.0000000, 1.0000000>,
    <1.0000000, -1.0000000, 1.0000000>
  }
  normal_vectors {
    6,
    <0.0000000, 0.0000000, 1.0000000>,
    <0.0000000, -1.0000000, 0.0000000>,
    <0.0000000, 0.0000000, -1.0000000>,
    <0.0000000, 1.0000000, 0.0000000>,
    <-1.0000000, 0.0000000, 0.0000000>,
    <1.0000000, 0.0000000, 0.0000000>
  }
  uv_vectors {
    12,
    <-3.5348073, -5.3108276>,
    <-3.3681406, -5.3108276>,
    <-3.3681406, -5.3108276>,
    <-3.5348073, -5.3108276>,
    <-3.5348073, -5.2274942>,
    <-3.3681406, -5.2274942>,
    <-3.3681406, -5.2274942>,
    <-3.5348073, -5.2274942>,
    <1.0000000, 0.0000000>,
    <1.0000000, 1.0000000>,
    <0.0000000, 1.0000000>,
    <0.0000000, 0.0000000>
  }
  texture_list {
    1,
    texture { Tapestry1 }
  }
  face_indices {
    12,   // 0 triangles and 6 quads
    <5, 4, 7>, 0,
    <5, 7, 6>, 0,
    <4, 0, 3>, 0,
    <4, 3, 7>, 0,
    <0, 1, 2>, 0,
    <0, 2, 3>, 0,
    <1, 5, 6>, 0,
    <1, 6, 2>, 0,
    <0, 4, 5>, 0,
    <0, 5, 1>, 0,
    <2, 6, 7>, 0,
    <2, 7, 3>, 0
  }
  normal_indices {
    12,   // from 0 triangles and 6 quads
    <0, 0, 0>,
    <0, 0, 0>,
    <1, 1, 1>,
    <1, 1, 1>,
    <2, 2, 2>,
    <2, 2, 2>,
    <3, 3, 3>,
    <3, 3, 3>,
    <4, 4, 4>,
    <4, 4, 4>,
    <5, 5, 5>,
    <5, 5, 5>
  }
  uv_indices {
    12,   // from 0 triangles and 6 quads
    <5, 4, 7>,
    <5, 7, 6>    <4, 0, 3>,
    <4, 3, 7>    <0, 1, 2>,
    <0, 2, 3>    <1, 5, 6>,
    <1, 6, 2>    <8, 9, 10>,
    <8, 10, 11>    <2, 6, 7>,
    <2, 7, 3>
  }
  uv_mapping
  scale <0.125, 6.0, 12.0>
  translate  <81.533967, 47.417687, 138.459862>
}



difference { // Wall
  box { // ExoWall
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    hollow
    scale <101.0, 135.25, 97.75>
    translate  <84.25, -120.25, -1.0>
  }
  box { // EndoWall
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    hollow
    scale <100.5, 135.0, 97.0>
    translate  <83.981479, -120.0, 0.0>
  }
  box { // Door2Cut
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <1.0, 14.5, 39.5>
    translate  <-117.5, 132.0, 96.0>
  }
  material {
    Plaster
  }
}


union { // Chandelier
  object { Candle1 }
  object { // Candle2 -> Candle1
    Candle1
    rotate -60.0*z
  }
  object { // Candle3 -> Candle1
    Candle1
    rotate -120.0*z
  }
  object { // Candle4 -> Candle1
    Candle1
    rotate 180.0*z
  }
  object { // Candle5 -> Candle1
    Candle1
    rotate 120.0*z
  }
  object { // Candle6 -> Candle1
    Candle1
    rotate 60.0*z
  }
  material {
    Iron
  }
  translate  <10.0, 60.0, 178.3>
}


box { // Dust
  <-1, -1, -1>, <1, 1, 1>
  translate  <-1.0, 1.0, 1.0>
  material {
    Haze
  }
  hollow
  photons {
    target 1.0
    collect on
  }
  scale <100.75, 135.125, 97.375>
  translate  <84.0, -120.125, -0.5>
}


