// Object Viewer
// 
// This POV program displays objects from an include file. You just have to 
// change the name of the include-file and the objects name. Object placement,
// lighting, scaling and rotation are done automatically

// ===== DO NOT EDIT !!! =====
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
// ===== END OF BLOCK =====

// Change the filename as necessary...
#include "main_wing.inc"      

// Make sure the objects name is correct...
#declare my_object_real = 
   // object { main_wing_front_inner_upper }
   
   // /*
union {
   object { main_wing_tip_front_upper }
   object { main_wing_tip_rear_upper }
   object { main_wing_inner_upper }
   object { main_wing_outer_upper }
   object { main_wing_front_inner_upper }
   object { main_wing_front_outer_upper }
   }
// */  

// ===== DO NOT EDIT BELOW !!! =====

// This part of the code takes the object "my_object_real"
// and scales it to fit in a cube 0,0,0 - 1,1,1. With this 
// code it is easy to quickly look at objects, without the 
// need to find accurate camera and light positions.

global_settings { 
  assumed_gamma 2.2 
  max_trace_level 5
}

camera {
  location <0.5, 2, -8>
  right <4/3, 0, 0>
  up <0, 1, 0>
  sky <0, 1, 0>
  direction <0, 0, 2.5>
  look_at <0,0,0>
}

light_source { <40, 40, -80> colour Gray40 }
light_source { <0, 50, 20> colour Gray40 }
light_source { <50, 50, -50> colour Gray40 }
light_source { <-50, 50, -50> colour Gray40 }

background { color SkyBlue }

plane { y, -25
   pigment {
      checker colour Yellow colour Green
      scale 5
   }
   finish {
      ambient 0.2
      diffuse 0.8
   }
}

#declare Min = min_extent(my_object_real);
#declare Max = max_extent(my_object_real);
#declare norm_scale = max(abs(Max.x - Min.x),abs(Max.y - Min.y),abs(Max.z - Min.z));

#declare my_object = 
object {
  my_object_real
  translate -Min
  // scale 1 / VDist(Max,Min)
  scale 2 / norm_scale
  translate -0.5
  }
 
object {
  my_object
  texture { Aluminum }
  // pigment { colour Red }
  rotate <0, 0, 90>
  translate <1, 0, 0>
  }
  
object {
  my_object
  // texture { Aluminum }  
  pigment { colour Red }
  rotate <0, 0, 90>
  translate <0, -1, 0>
  }  

// ===== END OF BLOCK =====
