/*

  "i_fruitext.inc"

   --
   Jaime Vives Piqueres, Jun-2002. 
   
   jaime@ignorancia.org
   http://www.ignorancia.org

   --
  
   Fruit texturing macros. See example "test_apple.pov" attached for use
   instructions and a little exaplnation about the technique.
 
*/


/*
   Macro to create the "sloped" texture, intended for internal use on the
   next macro, "m_radial_sloped()". The different layers are mixed here because
   otherwise they can't be layered over the final patterned texture.
   
*/
#macro m_sloped(cnt,n,t_base,p_stripes,t_upper,r_rad)

texture{t_base}
texture{
 pigment{
  slope y
  pigment_map{
   [0.0 p_stripes translate 10*rand(r_rad) rotate -18*5*z rotate (360*cnt/n)*y]
   [0.1 p_stripes translate 10*rand(r_rad) rotate -18*4*z rotate (360*cnt/n)*y]
   [0.3 p_stripes translate 10*rand(r_rad) rotate -18*2*z rotate (360*cnt/n)*y]
   [0.5 p_stripes translate 10*rand(r_rad) rotate  18*0*z rotate (360*cnt/n)*y]
   [0.7 p_stripes translate 10*rand(r_rad) rotate  18*2*z rotate (360*cnt/n)*y]
   [0.9 p_stripes translate 10*rand(r_rad) rotate  18*4*z rotate (360*cnt/n)*y]
   [1.0 p_stripes translate 10*rand(r_rad) rotate  18*5*z rotate (360*cnt/n)*y]
  }
 }
}
texture{t_upper}

#end // of macro 


/*
   Macro to create the "radial-sloped" texture, calling "m_sloped()" (for the
   rotations following the slope y) for each radial entry and rotating it to
   face the shape. It returns the final texture to use on the fruit object.
   
*/
#macro m_radial_sloped(t_base,p_stripes,t_upper,r_man)

#local cnt=1;
#local n=32;

texture{
 radial
 texture_map{
  #declare t_apple_base=m_sloped(0,n,t_base,p_stripes,t_upper,r_man)
  [0 t_apple_base]
  #while (cnt<=n)
   #declare t_apple_base=m_sloped(cnt,n,t_base,p_stripes,t_upper,r_man)
   [(cnt/n) t_apple_base]
   #declare cnt=cnt+1;
  #end
 }
}

#end // of macro 


