//ImageA35.pov for POV-Ray Megapatch 0.7: Serenity  (c) 2002 Ch. Gerber

#version unofficial MegaPov 0.7;


//--- Control ---

#declare Rad = 2500000/(2*pi);
 
global_settings {max_trace_level 155 assumed_gamma 1.5}  

#declare HQ = 1;
#declare Rad_on = 1;
#declare Fog_on = 1;
#declare Clouds_on = 1;
#declare Stones_on = 1; 
#declare Rider_on = 1;

#include "colors.inc"
#include "mytextures.inc"

global_settings {
  assumed_gamma 2.6
  max_trace_level 12
  #if (Rad_on = 1) 
  ambient_light 0
  ini_option "+QR"
  radiosity {
    pretrace_start 0.08
    pretrace_end   0.01
    count 20
    nearest_count 5
    error_bound 0.4
    recursion_limit 1
    low_error_factor 0.5
    gray_threshold 0
    minimum_reuse 0.015
    brightness 1.5
    adc_bailout 0.006
    normal on
  }
  #end
}


//--- Camera  & Lights ---

camera {
  location <-100, 15, -150>
  direction z
  up y
  right 1024/614*x
  look_at <0, 20, 0>
}

light_source {
  5500*z 
  color rgb <0.75,0.65,0.5>
  #if (HQ=1)
   area_light <550,0,0>,<0,550,0>,5,5
   adaptive 1
   jitter
   orient
  #end 
  media_attenuation on 
  media_interaction on 
  rotate <-15,40,0>
}

light_source { //fill in
  -500*z
  color rgb <0.525,0.4,0.45>/3
  shadowless 
  media_attenuation off 
  media_interaction off
  rotate <30,0,0>
} 

light_source {
  5500*z 
  glow { 
    type 1 
    size 70
    color rgb <1,1,0.5>/4
  }
  rotate <-15,40,0>
}

sky_sphere {
  pigment {
    gradient y 
    turbulence 0.2
    color_map {[0.0 color rgb <1,0.9,0.65>/1.2] [0.4 color rgb<0.7,0.8,1>/1.2]}
    rotate 15*x 
  }
}


//--- Clouds ---

#if (Clouds_on = 1)

difference {
  sphere {0,Rad}
  sphere {0,Rad-7000}
  material {
    texture {pigment {rgbf 1}}
    interior {
      media {            
        scattering {3, 0.01/12 extinction 0.2}
        scattering {3, <0.011,0.013,0.01>/12 extinction 0.5}
        method 3
        #if (HQ=1) samples 25,25 #else samples 5,5 #end
        intervals 1
        density {
          wrinkles
          color_map {           
            [0   rgb 0]           
            [0.5 rgb 0]     
            [0.6 rgb 0.2]    
            [1   rgb 0.5]
          }                     
          turbulence 0.3 lambda 3
          scale <200,100,400>*80
          rotate -60*y
          translate <100,Rad-9000,0> 
          rotate <9,15,0> //21*x for different clouds
        }
      }  
    }
  }
  rotate 22*y 
  rotate 0.75*x
  translate <0,12000-Rad,0>
  hollow
}

#end //Clouds_on


//--- Fog ---

#if (Fog_on = 1)

fog {
  fog_type 2 
  distance 1000
  rgb <1,0.75,0.45>*0.75
  fog_offset 0
  fog_alt 25
}

#end //Fog_on


//--- Beach ---

#declare Beach = height_field {
  tga "Beach.tga" smooth translate <-0.5,0,-0.5>
  scale <500, 10, 500>
  texture {Sand}
  rotate 60*y
}

#declare Hills = height_field {
  tga "hills.tga" smooth translate <-0.5,0,-0.5>
  scale <2000, 100, 2000>
  texture {Sand scale 10}
  translate <250,0,1100>
}

object {Beach}
object {Hills}
plane {y,0 texture {Sand}}      
plane {y,7 hollow material {Water}}
 
#if (Stones_on = 1)

#declare BigStone   = object {#declare Seed = 317; #declare Splits = 4; #declare Rough = 0.2; #include "rock.inc" scale <1,0.5,1>*0.5 texture {Stone}} 
#declare SmallStone = object {#declare Seed = 222; #declare Splits = 3; #declare Rough = 0.2; #include "rock.inc" scale <1,0.5,1>*0.1 texture {Stone}} 

#declare StoneSeed = seed(2001);

#declare Norm = <0,0,0>;
#declare Xpos = -250;
#declare Zpos = -250; 
#declare Pig = pigment {spotted color_map {[0 rgb 1][1 rgb 0]} scale 10 translate <-50,0,250>}
#while (Xpos<250)
  #while (Zpos<250)
    #declare SPos = <Xpos,100,Zpos>;
    #declare PP = eval_pigment(Pig,<Xpos,0,Zpos>);
    #declare XX = PP.x;
    #declare Inter = trace (Beach,SPos,<0,-1,0>,Norm); 
    #if (vlength(Norm) != 0 & XX > 0.65)
      #if (Inter.y > 7.5)
        object {
          BigStone 
          scale <1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5>
          rotate <-20+rand(StoneSeed)*40,rand(StoneSeed)*360,-20+rand(StoneSeed)*40> 
          translate <Inter.x+rand(StoneSeed)*10,Inter.y+1,Inter.z+rand(StoneSeed)*10>
        }
      #end
    #end 
    #declare Zpos = Zpos + 10;
  #end           
  #declare Zpos = -250;
  #declare Xpos = Xpos + 10; 
#end 

#declare Norm = <0,0,0>;
#declare Xpos = -250;
#declare Zpos = -250; 
#declare Pig = pigment {spotted color_map {[0 rgb 1][1 rgb 0]} scale 10 translate <50,0,-50>}
#while (Xpos<250)
  #while (Zpos<250)
    #declare SPos = <Xpos,100,Zpos>;
    #declare PP = eval_pigment(Pig,<Xpos,0,Zpos>);
    #declare XX = PP.x;
    #declare Inter = trace (Beach,SPos,<0,-1,0>,Norm); 
    #if (vlength(Norm) != 0 & XX > 0.6)
      #if (Inter.y > 7.5)
        object {
          SmallStone 
          scale <1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5>
          rotate <-20+rand(StoneSeed)*40,rand(StoneSeed)*360,-20+rand(StoneSeed)*40> 
          translate <Inter.x+rand(StoneSeed)*4,Inter.y+0.2,Inter.z+rand(StoneSeed)*4>
        }
      #end
    #end 
    #declare Zpos = Zpos + 4;
  #end           
  #declare Zpos = -250;
  #declare Xpos = Xpos + 4; 
#end 

#declare Norm = <0,0,0>;
#declare Xpos = -750;
#declare Zpos =  100; 
#declare Pig = pigment {spotted color_map {[0 rgb 1][1 rgb 0]} scale 10 translate <-50,0,250>}
#while (Xpos<1250)
  #while (Zpos<2100)
    #declare SPos = <Xpos,1000,Zpos>;
    #declare PP = eval_pigment(Pig,<Xpos,0,Zpos>);
    #declare XX = PP.x;
    #declare Inter = trace (Hills,SPos,<0,-1,0>,Norm); 
    #if (vlength(Norm) != 0 & XX > 0.65)
      #if (Inter.y > 7.5 & Inter.y < 15 )
        object {
          BigStone 
          scale <1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5>
          rotate <-20+rand(StoneSeed)*40,rand(StoneSeed)*360,-20+rand(StoneSeed)*40> 
          translate <Inter.x+rand(StoneSeed)*10,Inter.y+1,Inter.z+rand(StoneSeed)*10>
        }
      #end
    #end 
    #declare Zpos = Zpos + 10;
  #end           
  #declare Zpos = 100;
  #declare Xpos = Xpos + 10; 
#end 

#end //Stones_on


//--- Rider ---

#if (Rider_on = 1)

#include "rider.inc"

#declare Inter = trace(Beach,<0,20,-70>,<0,-1,0>) - <0,-0.2,0>;

object {Rider rotate -50*y scale 15 translate Inter}

#end //Rider_on