// Animation parameter:  final_fame = 177


camera { location  <1, 40, 50> look_at <-20, 40, 0>}

sky_sphere { pigment {
    function {abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,100> colour rgb 1.7}

plane {y,5 pigment {rgb <.3,1,.3>}}

#fopen IN "grenade.txt" read

#declare N=-1;
#while (N<frame_number)
  #read(IN,Hipx,Hipy,Hipz,HipZ,HipX,HipY,CheZ,CheX,CheY,NecZ,NecX,NecY,HeaZ,HeaX,HeaY)
  #read(IN,LcZ,LcX,LcY,LuaZ,LuaX,LuaY,LlaZ,LlaX,LlaY,LhZ,LhX,LhY)
  #read(IN,RcZ,RcX,RcY,RuaZ,RuaX,RuaY,RlaZ,RlaX,RlaY,RhZ,RhX,RhY)
  #read(IN,LulZ,LulX,LulY,LllZ,LllX,LllY,LfZ,LfX,LfY)
  #read(IN,RulZ,RulX,RulY,RllZ,RllX,RllY,RfZ,RfX,RfY)
  #declare N=N+1;
#end

#debug concat(str(frame_number,0,0),"\n")
#debug concat(str(Hipx,0,-1)," ",str(Hipy,0,-1)," ",str(Hipz,0,-1),"\n")


// Simple animatable body shape

#declare LeftFoot = cylinder {0,<0,-3.04,0>,1 scale <1,1,4>}

#declare LeftLowLeg = union {
  cone {0,2,<0,-14.95,0>,1 scale <1,1,1>}
  object {LeftFoot rotate <0,0,LfZ> rotate <LfX,LfY,0> translate <0,-14.95,0> }
}  

#declare LeftUpLeg = union {
  cylinder {0,<0,-16.08,0>,1 scale <2,1,2>}
  object {LeftLowLeg rotate <0,0,LllZ> rotate <LllX,LllY,0> translate <0,-16.08,0>}
}  

#declare RightFoot = cylinder {0,<0,-3.04,0>,1 scale <1,1,4>}

#declare RightLowLeg = union {
  cone {0,2,<0,-14.00,0>,1 scale <1,1,1>}
  object {RightFoot rotate <0,0,RfZ> rotate <RfX,RfY,0> translate <0,-14.00,0>}
}  

#declare RightUpLeg = union {
  cylinder {0,<0,-16.03,0>,1 scale <2,1,2>}
  object {RightLowLeg rotate <0,0,RllZ> rotate <RllX,RllY,0> translate <0,-16.03,0>}
}  

#declare LeftHand = cylinder {0,<0,-6.1,0>,1 scale <1,1,1.5>}

#declare LeftLowArm = union {
  cone {0,2,<0,-9.24,0>,1 scale <1,1,1>}
  object {LeftHand rotate <0,0,LhZ> rotate <LhX,LhY,0> translate <0,-9.24,0>}
}  

#declare LeftUpArm = union {
  cylinder {0,<0,-12.35,0>,1 scale <2,1,2>}
  object {LeftLowArm rotate <0,0,LlaZ> rotate <LlaX,LlaY,0> translate <0,-12.35,0>}
}  

#declare LeftCollar = union {
  cylinder {0,<7.22,0,0>,1 scale <1,2,2>}
  object {LeftUpArm rotate <0,0,LuaZ> rotate <LuaX,LuaY,0> translate <7.22,0,0>}
}  

#declare RightHand = cylinder {0,<0,-6.53,0>1 scale <1,1,1.5>}

#declare RightLowArm = union {
  cone {0,2,<0,-9.48,0>,1 scale <1,1,1>}
  object {RightHand rotate <0,0,RhZ> rotate <RhX,RhY,0> translate <0,-9.48,0>}
}  

#declare RightUpArm = union {
  cylinder {0,<0,-12.1,0>,1 scale <2,1,2>}
  object {RightLowArm rotate <0,0,RlaZ> rotate <RlaX,RlaY,0> translate <0,-12.1,0>}
}  

#declare RightCollar = union {
  cylinder {0,<-7.09,0,0>,1 scale <1,2,2>}
  object {RightUpArm rotate <0,0,RuaZ> rotate <RuaX,RuaY,0> translate <-7.09,0,0>}
}  

#declare Head = cylinder {0,<0,3.71,0>,1 scale <3,2,3>}

#declare Neck = union {
  cylinder {0,<0,5.04,0>,2 scale <1,1,1>}
  object {Head rotate <0,0,HeaZ> rotate <HeaX,HeaY,0> translate <0,5.04,0>}
}

#declare Chest = union {
  cone {0,1,<0,19.11,0>,1.5 scale <4,1,2>}
  object {Neck rotate <0,0,NecZ> rotate <NecX,NecY,0> translate <0,19.11,0>}
  object {LeftCollar rotate <0,0,LcZ> rotate <LcX,LcY,0> translate <1.15,16.62,1.91>}
  object {RightCollar rotate <0,0,RcZ> rotate <RcX,RcY,0> translate <-1.15,16.62,1.91>}
}


#declare Body = union {
   sphere {0,1 scale <5,5,3>}
   object {Chest rotate <0,0,CheZ> rotate <CheX,CheY,0> translate <0,4.72,0>}
   object {LeftUpLeg rotate <0,0,LulZ> rotate <LulX,LulY,0> translate <3.54,-0.33,0.43>}
   object {RightUpLeg rotate <0,0,RulZ> rotate <0,0,RulZ> translate <-3.54,-0.33,0.43>}
   rotate <0,0,HipZ> rotate <HipX,HipY,0> translate <Hipx,Hipy,Hipz>
}


object {Body pigment {rgb 1}}

    