// Parametric mesh generator with deformations
// Based on Gilles Tran's MakeTree
// Modifications bt David Wallace
//#version unofficial MegaPov 0.7;

#macro TrackSpline(spl, h, vc)
	#local pm = <0,0,0>+spl(h-1e-4);
	#local ps = <0,0,0>+spl(h);
	#local pp = <0,0,0>+spl(h+1e-4);
	#local dir = vnormalize(pp-pm);
	#local norm = vnormalize(2*ps-pm-pp);
	#local ortho = vcross(dir,norm);
	#local pt0 = ps+dir*vc.z*norm*vc.x+ortho*vc.y;
	pt0
#end

#macro vecdir(spl,i)
  vnormalize(spl(i+1e-4)-spl(i-1e-4))
#end

#macro vecnorm(spl,i)
  vnormalize(spl(i)*2-spl(i-1e-4)-spl(i+1e-4))
#end

#macro vecortho(spl,i)
  vcross(vecdir(spl,i),vecnorm(spl,i))
#end

#macro ParaTree(iName, fName)
  #include iName

	#declare Points = array[uNum][vNum]
	#declare Interp = array[uNum][vNum]
	#declare pMapUV = array[uNum][vNum]
	#declare iMapUV = array[uNum][vNum]
	#declare Splines = array[level0]
	#declare lb=array[level0] // Branch length
	#declare rb=array[level0] // Branch radius
	#declare ab=array[level0] // Branch angle

  #local m = uNum-1;
  #local n = vNum-1;

	#declare mx = <0, 0, 0>;
	#declare mn = <0, 0, 0>;
	
	#local i = level0 -1;
	#declare lb[i]=lb0;
	#declare rb[i]=rb0;
	#declare ab[i]=ab0;
  
	#while (i>0)
		#local i=i-1;
		#declare lb[i]=lb[i+1]*qlb;
		#declare rb[i]=rb[i+1]*qrb;
		#declare ab[i]=ab[i+1]*qab;
	#end

  #ifndef (IsRnd) #declare IsRnd = false; #end
  #ifndef (uSeed) #declare uSeed = 0; #end
  #ifndef (vSeed) #declare vSeed = 0; #end
  #ifndef (Detail) #declare Detail = "None"; #end
  #ifndef (IsUV) #declare IsUV = false; #end

  // File write
  #fopen pFile fName write
 	#write (pFile, "mesh {\n")
  #debug concat("Writing ",fName,"...\n")
  MakeBranch(level0, pos0, v0, rb0, rb0*qrb, true, fName)
  #if (IsUV)
 		#write (pFile, "  uv_mapping\n}\n")
 	#else
 		#write (pFile, "}\n")
	#end
  #local smx = concat("< ",str(mx.x,0,4),", ",str(mx.y,0,4),", ",str(mx.z,0,4)," >")
  #local smn = concat("< ",str(mn.x,0,4),", ",str(mn.y,0,4),", ",str(mn.z,0,4)," >")
  #debug concat(fName," complete.\nObject extends from ", smn," to ", smx,".\n")
  #fclose pFile

#end

#macro MakeBranch(Level, pos, vb, rBase, rTop, dotop, fName)
	#if (Level>level0-3) #debug concat("level ",str(Level,0,0),"\n") #end
	//-----------------------------------------
	// The branch is made up of segments
	// First we create the branch segments
	//-----------------------------------------
	#local curlev = Level-1;
	#local nseg=max(1,nseg0-level0+Level);  // number of branch segments
	#local lbseg=lb[curlev]/nseg; // length of branch segment
	#local i=0;
	#local ay= 360*(0.5-rand(rd));
	#local curpos = pos;
	#declare rad0 = rBase;
	#declare rad1 = rTop;
	#declare Splines[curlev] = spline {
		cubic_spline
		0, curpos
		#while (i<nseg)
			//-----------------------------------------
			// Segment calculation and positionning
			//-----------------------------------------
			// calculates the force (wind, gravity) to apply to the segment
			// the force is stronger at the end of the branch
			// for trunk, vpush gets a vertical boost if dotop is true
			#if(dotop & (Level = level0)) 
				#local vp = vpush + <0, 0.5, 0>;
				#local fp = fpush+0.2; 
			#else 
				#local vp = vpush; 
				#local fp = fpush; 
			#end
			#if (vlength(vp)>0) #local vp = vnormalize(vp); #end
			// then we add the gnarledness
			#local vg=<0.5-rand(rd),0.5-rand(rd),0.5-rand(rd)>;
			#if (vlength(vg)>0) #local vg=vnormalize(vg); #end
			// now we calculate the position ; vb is the original direction of the segment
			#local curpos = curpos+lbseg*vnormalize(vb+vp*fp+vg*fgnarl)*(1+(0.5-rand(rd))*stdlseg);
			// segments must be kept over the ground
			#if (curpos.y<aboveground) 
				#local curpos=<curpos.x,aboveground+rand(rd)*i/nseg,curpos.z>; 
			#end
			// segments must be kept under the sky !
			#if (curpos.y>belowsky) 
				#local curpos=<curpos.x,belowsky-rand(rd)*i/nseg,curpos.z>; 
			#end
   	  #local i = i + 1;
     	i/nseg, curpos
		#end
	}
	MakePara(curlev, Splines[curlev], fName)

 	// set up continuing branch, if applicable
 	#if (Level>1)
	  #local nrb = rTop;
 		#local nrt = (curlev=1 ? 0 : nrb*qrb);
		#local nps = <0, 0, 0> + Splines[curlev](1);
		#local nvb = vecdir(Splines[curlev],1);
		MakeBranch(curlev, nps, nvb, nrb, nrt, false, fName)

		// now the others
		#local i = 1;
		#while (i<nb)
			#local i = i + 1;
			#if (rand(rd)<=branchproba)
				#local hgt = jb+rand(rd)*(1-jb);
				#local lngt = radians(i*360/nb + stday*(0.5-rand(rd))); // Longitude
				#local azim = radians(ab[curlev] + stdax*(0.5-rand(rd))); // Latitude
				#local nps = <0,0,0>+Splines[curlev](hgt);
				#local vec = <cos(azim)*cos(lngt), cos(azim)*sin(lngt), sin(azim) >;
				#local nvb = TrackSpline(Splines[curlev],hgt,vec);
				#local nrb = rTop*(1-(1-qjb)*(1-qrb)*hgt);
				#local nrt = (curlev=1 ? 0 : nrb*qrb);
				MakeBranch(curlev, nps, nvb, nrb, nrt, false, fName)
			#end
		#end
	#end
	
	// trunk specials
	#if (Level=level0)
		// twigs
		#if(twigproba>0)
			#local i=0;
			#local nrb = rb[0];
			#local nrt = 0;
			#while (i<nseg)
				#if (rand(rd)<=twigproba)
					#local hgt = (i+rand(rd))/nseg;
					#local azim = pi*rand(rd)*.25; // Latitude
					#local lngt = 2*pi*rand(rd); // Longitude
					#local nps = <0,0,0>+Splines[curlev](hgt);
					#local vec = <cos(azim)*cos(lngt), cos(azim)*sin(lngt), sin(azim) >;
					#local nvb = TrackSpline(Splines[curlev],hgt,vec);
					MakeBranch(1, nps, nvb, nrb, nrt, false, fName)
					#local i = i + 1;
				#end
			#end
		#end
		
		// roots
		#if (rootproba>0)
			#local nps = yroot;
			#local nrb = rb[1];
			#local nrt = rb[0];
			#local i=0;
			#while (i<nroot)
				#if (rand(rd)<=rootproba)
					#local yang = i/nroot*360;
					#local nvb = vrotate(vroot,y*yang);
					MakeRoot(2, nps, nvb, nrb, nrt, fName)
					#local i = i + 1;
				#end
			#end
		#end
	#end
#end
	
#macro MakeRoot(Level, pos, vb, rBase, rTop, fName)
	#debug concat("level ",str(Level,0,0),"\n")
	//-----------------------------------------
	// The root is made up of segments
	// First we create the root segments
	//-----------------------------------------
	#local nseg=max( 1, nseg0 - level0 + Level );  // number of root segments
	#local lbseg=lb[Level]/nseg; // length of root segment
	#local i=0;
	#local ay= 360*(0.5-rand(rd));
	#local curpos = pos;
	#local curlev = Level-1;
	#declare rad0 = rBase;
	#declare rad1 = rTop;
	#declare Splines[curlev] = spline {
		cubic_spline
		0, curpos
		#while (i<nseg)
			//-----------------------------------------
			// Segment calculation and positionning
			//-----------------------------------------
			// calculates the force (wind, gravity) to apply to the segment
			// the force is stronger at the end of the root
			#local fp = 0.2;
			#local vp = -y*i/nseg;
			// then we add the gnarledness
			#local vg=<0.5-rand(rd),0.5-rand(rd),0.5-rand(rd)>;
			#if (vlength(vg)>0) #local vg=vnormalize(vg); #end
			// now we calculate the position ; vb is the original direction of the segment
			#local curpos = curpos+lbseg*vnormalize(vb+vp*fp+vg*fgnarl)*(1+(0.5-rand(rd))*stdlseg);
			// distant segments must be kept under the ground
      #if (curpos.y>0 & (i/nseg)>=0.3) #local curpos=curpos*<1,0,1>; #end
   	  #local i = i + 1;
     	i/nseg, curpos
		#end
	}
	MakePara(curlev, Splines[curlev], fName)

 	// set up continuing root, if applicable
 	#if (Level>1)
	  #local nrb = rTop;
 		#local nrt = (curlev=1 ? 0 : nrb*qrb);
		#local nps = <0,0,0>+Splines[curlev](1);
		#local nvb = vecdir(Splines[curlev],1);
		MakeRoot(curlev, nps, nvb, nrb, nrt, fName)

		// now the others
		#local i = 1;
		#while (i<nroot)
			#local i = i + 1;
			#if (rand(rd)<=rootproba)
				#local hgt = jb+rand(rd)*(1-jb);
				#local lngt = radians(i*360/nroot + stday*(0.5-rand(rd))); // Longitude
				#local azim = radians(ab[curlev] + stdax*(0.5-rand(rd))); // Latitude
				#local nps = <0,0,0>+Splines[curlev](hgt);
				#local vec = <cos(azim)*cos(lngt), cos(azim)*sin(lngt), sin(azim) >;
				#local nvb = TrackSpline(Splines[curlev],hgt,vec);
				#local nrb = rTop*(1-(1-qjb)*(1-qrb)*hgt);
				#local nrt = (curlev=1 ? 0 : nrb*qrb);
				MakeRoot(curlev, nps, nvb, nrb, nrt, fName)
			#end
		#end
	#end
	
#end

#macro MakePara(Level, spl, fName)
  #local i = 0;

  // Set random seed if applicable
  #debug concat("Initializing ",fName," data...\n")
  #if (IsRnd)
	  #declare uRnd = seed(uSeed); // Random seed
	  #declare vRnd = seed(vSeed); // Random seed
  #else
	  #declare uvr = 0; // Variance, is always 0 if IsRnd=false
	  #declare vvr = 0; // Variance, is always 0 if IsRnd=false
  #end

  // Populate points matrices
  #if (strcmp(Detail,"Partial")=0) #debug concat("  Calculating points\n") #end
    #while (i<uNum)
	  #local j = 0;
 		#if (IsRnd) #local uvr = rand(uRnd); #end
    #if (strcmp(Detail,"Verbose")=0) #debug concat("  Calculating points for row ",str(i,0,0),"\n") #end
  	#while (j<vNum)

	    // Input values
		  #local upt = uMin+((uMax-uMin)*i/m);
		  #local vpt = vMin+((vMax-vMin)*j/n);
	  	#local uin = uMin+((uMax-uMin)*(i+.5)/m);
		  #local vin = vMin+((vMax-vMin)*(j+.5)/n);
  		#if (IsRnd) #local vvr = rand(vRnd); #end
      
		  // Output values
		  #declare pMapUV[i][j] = <upt, vpt>;
		  #declare iMapUV[i][j] = <uin, vin>;
  		//#declare Points[i][j] = <0, 0, 0>;
	  	//#declare Interp[i][j] = <0, 0, 0>;
  		#declare Points[i][j] = pnt(upt, vpt, uvr, vvr, spl);
	  	#declare Interp[i][j] = pnt(uin, vin, uvr, vvr, spl);
		  #local j = j + 1;
  	#end
	  #local i = i + 1;
  #end

  #if (Smooth)
	  #if (strcmp(Detail,"Partial")=0) #debug concat("  Smoothing points\n") #end
    #declare pSmooth = array[uNum][vNum]
	  #declare iSmooth = array[uNum][vNum]

  	// Corners
	  #if (strcmp(Detail,"Verbose")=0) #debug "  Smoothing corners\n" #end
  	#declare iSmooth[0][0] = vnormalize( Points[0][0]+Points[0][1]+Points[1][0]+Points[0][0]-4*Interp[0][0] );
	  #if(uWrap)
		  #declare iSmooth[m][0] = vnormalize( Points[m][0]+Points[m][1]+Points[0][0]+Points[0][1]-4*Interp[m][0] );
		  #if(vWrap)
			  #declare pSmooth[0][0] = vnormalize( Interp[m][n]+Interp[0][n]+Interp[m][0]+Interp[0][0]-4*Points[0][0] );
			  #declare pSmooth[m][0] = vnormalize( Interp[m-1][n]+Interp[m][n]+Interp[m-1][0]+Interp[m][0]-4*Points[m][0] );
		  	#declare pSmooth[0][n] = vnormalize( Interp[m][n-1]+Interp[0][n-1]+Interp[m][n]+Interp[0][n]-4*Points[0][n] );
			  #declare pSmooth[m][n] = vnormalize( Interp[m-1][n-1]+Interp[m][n-1]+Interp[m-1][n]+Interp[m][n]-4*Points[m][n] );
			#declare iSmooth[0][n] = vnormalize( Points[m][n-1]+Points[0][n-1]+Points[m][n]+Points[0][n]-4*Interp[0][n] );
			  #declare iSmooth[m][n] = vnormalize( Points[m-1][n-1]+Points[m][n-1]+Points[m-1][n]+Points[m][n]-4*Interp[m][n] );
  		  #else
	  		#declare pSmooth[0][0] = vnormalize( Points[0][1]+Interp[m][0]+Interp[0][0]-3*Points[0][0] );
			  #declare pSmooth[m][0] = vnormalize( Points[m][1]+Interp[m-1][0]+Interp[m][0]-3*Points[m][0] );
		  	#declare pSmooth[0][n] = vnormalize( Points[0][n-1]+Interp[m][n-1]+Interp[0][n-1]-3*Points[0][n] );
	  		#declare pSmooth[m][n] = vnormalize( Points[m][n-1]+Interp[m-1][n-1]+Interp[m][n-1]-3*Points[m][n] );
  		#end
  	#else
	  	#if(vWrap)
		  	#declare pSmooth[0][0] = vnormalize( Points[1][0]+Interp[0][n]+Interp[0][0]-3*Points[0][0] );
			  #declare pSmooth[m][0] = vnormalize( Points[m-1][0]+Interp[m-1][0]+Interp[m-1][n]-3*Points[m][0] );
			  #declare pSmooth[0][n] = vnormalize( Points[1][n]+Interp[0][n-1]+Interp[0][n]-3*Points[0][n] );
		  	#declare pSmooth[m][n] = vnormalize( Points[m-1][n]+Interp[m-1][n-1]+Interp[m-1][n]-3*Points[m][n] );
	  		#declare iSmooth[0][n] = vnormalize( Points[m][n-1]+Points[0][n-1]+Points[m][n]+Points[0][n]-4*Interp[0][n] );
  		#else
		  	#declare pSmooth[0][0] = vnormalize( Points[1][0]+Points[0][1]+Interp[0][0]-3*Points[0][0] );
			  #declare pSmooth[m][0] = vnormalize( Points[m-1][0]+Points[m][1]+Interp[m-1][0]-3*Points[m][0] );
			  #declare pSmooth[0][n] = vnormalize( Points[1][n]+Points[0][n-1]+Interp[0][n-1]-3*Points[0][n] );
		  	#declare pSmooth[m][n] = vnormalize( Points[m-1][n]+Points[m][n-1]+Interp[m-1][n-1]-3*Points[m][n] );
	  	#end
  	#end
	
  	// Edges
	  #local i=1;
  	#if (strcmp(Detail,"Verbose")=0) #debug "  Smoothing bottom edge\n" #end
	  #while (i<m)
		  #declare iSmooth[i][0] = vnormalize( Points[i][0]+Points[i][1]+Points[i-1][0]+Points[i-1][1]-4*Interp[i][0] );
		  #if(vWrap)
			  #declare pSmooth[i][0] = vnormalize( Interp[i][0]+Interp[i][n]+Interp[i-1][0]+Interp[i-1][n]-4*Points[i][0] );
			  #declare pSmooth[i][n] = vnormalize( Interp[i-1][n-1]+Interp[i][n-1]+Interp[i-1][n]+Interp[i][n]-4*Points[i][n] );
	  		#declare iSmooth[i][n] = vnormalize( Points[i][n]+Points[i][0]+Points[i-1][n]+Points[i-1][0]-4*Interp[i][n] );
  		#else
		  	#declare pSmooth[i][0] = vnormalize( Points[i][1]+Interp[i][0]+Interp[i-1][0]-3*Points[i][0] );
			  #declare pSmooth[i][n] = vnormalize( Points[i][n-1]+Interp[i-1][n-1]+Interp[i][n-1]-3*Points[i][n] );
		  #end
	  	#local i = i + 1;
  	#end

  	#local j=1;
	  #if (strcmp(Detail,"Verbose")=0) #debug "  Smoothing right edge\n" #end
  	#while (j<n)
	  	#declare iSmooth[0][j] = vnormalize( Points[0][j]+Points[1][j]+Points[0][j-1]+Points[1][j-1]-4*Interp[0][j] );
		  #if(vWrap)
			  #declare pSmooth[0][j] = vnormalize( Interp[0][j]+Interp[m][j]+Interp[0][j-1]+Interp[m][j-1]-4*Points[0][j] );
	  		#declare pSmooth[m][j] = vnormalize( Interp[m-1][j-1]+Interp[m-1][j]+Interp[m][j-1]+Interp[m][j]-4*Points[m][j] );
			  #declare iSmooth[m][j] = vnormalize( Points[m][j]+Points[0][j]+Points[m][j-1]+Points[0][j-1]-4*Interp[m][j] );
		  #else
  			#declare pSmooth[0][j] = vnormalize( Points[1][j]+Interp[i][0]+Interp[i-1][0]-3*Points[0][j] );
			  #declare pSmooth[m][j] = vnormalize( Points[m-1][j]+Interp[m-1][j-1]+Interp[m-1][j]-3*Points[m][j] );
		  #end
	  	#local j = j + 1;
  	#end
	
  	// Center
	  #local i=1;
  	#while (i<m)
		  #local j=1;
	  	#if (strcmp(Detail,"Verbose")=0) #debug concat("  Smoothing row ",str(i,0,0),"\n") #end
  		#while (j<n)
			  #declare pSmooth[i][j] = vnormalize( Interp[i-1][j-1] + Interp[i-1][j] + Interp[i][j-1] + Interp[i][j] - 4*Points[i][j] );
			  #declare iSmooth[i][j] = vnormalize( Points[i+1][j+1] + Points[i+1][j] + Points[i][j+1] + Points[i][j] - 4*Interp[i][j] );
			  #local j = j + 1;
		  #end
		  #local i = i + 1;
	  #end
  #end
  
  #debug "  Writing points...\n"
  #local i=0;
  #while (i<m)
	  #local j=0;
	  #if (strcmp(Detail,"Verbose")=0) #debug concat("  Writing row ",str(i,0,0),"\n") #end
  	#while (j<n)
	  	WriteGrid(i,j)
	  	#local j = j + 1;
  	#end
	  #local i = i + 1;
  #end

  #if (uWrap)
	  #if (strcmp(Detail,"Verbose")=0) #debug "  Writing bottom wraparound\n" #end
  	#local j=0;
	  #while (j<n)
	  	WriteGrid(m,j)
		  #local j = j + 1;
	  #end
  #end

  #if (vWrap)
	  #if (strcmp(Detail,"Verbose")=0) #debug "  Writing right wraparound\n" #end
  	#local i=0;
	  #while (i<m)
	  	WriteGrid(i,n)
		  #local i = i + 1;
	  #end
  #end

  #if (uWrap*vWrap)
	  #if (strcmp(Detail,"Verbose")=0) #debug "  Writing corner wraparound\n" #end
	  WriteGrid(m,n)
  #end

#end

#macro WriteGrid(upos,vpos)
	#local umax = mod(upos+1,uNum);
	#local vmax = mod(vpos+1,vNum);
 	#local mmp = Points[upos][vpos];
  #local mpp = Points[upos][vmax];
 	#local pmp = Points[umax][vpos];
  #local ppp = Points[umax][vmax];
 	#local pin = Interp[upos][vpos];
 	#local xx = max(max(mx.x, mmp.x), max(max(mpp.x, pmp.x), max(ppp.x, pin.x)));
 	#local nx = min(min(mn.x, mmp.x), min(min(mpp.x, pmp.x), min(ppp.x, pin.x)));
 	#local xy = max(max(mx.y, mmp.y), max(max(mpp.y, pmp.y), max(ppp.y, pin.y)));
 	#local ny = min(min(mn.y, mmp.y), min(min(mpp.y, pmp.y), min(ppp.y, pin.y)));
 	#local xz = max(max(mx.z, mmp.z), max(max(mpp.z, pmp.z), max(ppp.z, pin.z)));
 	#local nz = min(min(mn.z, mmp.z), min(min(mpp.z, pmp.z), min(ppp.z, pin.z)));
 	#declare mx = <xx, xy, xz>;
 	#declare mn = <nx, ny, nz>;
 	#if (IsUV)
 		#local uvmm = pMapUV[upos][vpos];
  	#local uvmp = pMapUV[upos][vmax];
 		#local uvpm = pMapUV[umax][vpos];
  	#local uvpp = pMapUV[umax][vmax];
 		#local uvin = iMapUV[upos][vpos];
 	#end
  #if (Smooth)
	  #local mms = -pSmooth[upos][vpos];
	  #local mps = -pSmooth[upos][vmax];
	  #local pms = -pSmooth[umax][vpos];
	  #local pps = -pSmooth[umax][vmax];
 		#local ins = -iSmooth[upos][vpos];
 		#if (IsUV)
  		#write (pFile, "  smooth_triangle {\n    ",mmp," , ",mms," , ",pmp,",\n    ",pms," , ",pin," , ",ins,"\n    uv_vectors ",uvmm," , ",uvpm," , ",uvin,"\n  }\n")
	  	#write (pFile, "  smooth_triangle {\n    ",pmp," , ",pms," , ",ppp,",\n    ",pps," , ",pin," , ",ins,"\n    uv_vectors ",uvpm," , ",uvpp," , ",uvin,"\n  }\n")
 			#write (pFile, "  smooth_triangle {\n    ",ppp," , ",pps," , ",mpp,",\n    ",mps," , ",pin," , ",ins,"\n    uv_vectors ",uvpp," , ",uvmp," , ",uvin,"\n  }\n")
  		#write (pFile, "  smooth_triangle {\n    ",mpp," , ",mps," , ",mmp,",\n    ",mms," , ",pin," , ",ins,"\n    uv_vectors ",uvmp," , ",uvmm," , ",uvin,"\n  }\n")
  	#else
  		#write (pFile, "  smooth_triangle {\n    ",mmp," , ",mms," , ",pmp,",\n    ",pms," , ",pin," , ",ins,"\n  }\n")
	  	#write (pFile, "  smooth_triangle {\n    ",pmp," , ",pms," , ",ppp,",\n    ",pps," , ",pin," , ",ins,"\n  }\n")
 			#write (pFile, "  smooth_triangle {\n    ",ppp," , ",pps," , ",mpp,",\n    ",mps," , ",pin," , ",ins,"\n  }\n")
  		#write (pFile, "  smooth_triangle {\n    ",mpp," , ",mps," , ",mmp,",\n    ",mms," , ",pin," , ",ins,"\n  }\n")
  	#end
 	#else
 		#if (IsUV)
	  	#write (pFile, "  triangle {\n    ",mmp," , ",pmp," , ",pin,"\n    uv_vectors ",uvmm," , ",uvpm," , ",uvin,"\n  }\n")
		  #write (pFile, "  triangle {\n    ",pmp," , ",ppp," , ",pin,"\n    uv_vectors ",uvpm," , ",uvpp," , ",uvin,"\n  }\n")
	  	#write (pFile, "  triangle {\n    ",ppp," , ",mpp," , ",pin,"\n    uv_vectors ",uvpp," , ",uvmp," , ",uvin,"\n  }\n")
	  	#write (pFile, "  triangle {\n    ",mpp," , ",mmp," , ",pin,"\n    uv_vectors ",uvmp," , ",uvmm," , ",uvin,"\n  }\n")
	  #else
	  	#write (pFile, "  triangle {\n    ",mmp," , ",pmp," , ",pin,"\n  }\n")
		  #write (pFile, "  triangle {\n    ",pmp," , ",ppp," , ",pin,"\n  }\n")
	  	#write (pFile, "  triangle {\n    ",ppp," , ",mpp," , ",pin,"\n  }\n")
	  	#write (pFile, "  triangle {\n    ",mpp," , ",mmp," , ",pin,"\n  }\n")
	  #end
  #end
#end
