#include "colors.inc"	// Standard Color definitions

#declare Light = light_source { <0, 30, 10> color White }
#declare LightWide = light_source { <0, 30, 30> color White }
#declare SubLight = light_source { <0, 30, 40> color rgb 0.4 }
#declare BaseLight = light_source { 0 color rgb .4 }

#declare Lighting = union {
	object { Light }
	object { Light rotate y*120 }
	object { Light rotate y*240 }
}

#declare LightingWide = union {
	object { LightWide }
	object { LightWide rotate y*120 }
	object { LightWide rotate y*240 }
}

#declare SurroundLight = union {
	object { SubLight }
	object { SubLight rotate y*60 }
	object { SubLight rotate y*120 }
	object { SubLight rotate y*180 }
	object { SubLight rotate y*240 }
	object { SubLight rotate y*300 }
}

#declare LightZ = union {
	light_source { <0, 0, 30> color White }
	light_source { <0, 0, -30> color White }
}

#declare LightCenter = light_source { <0, 30, 0> color White }

#macro LightStar(Pos,Siz)
	union {
		object { BaseLight translate  x*Siz }
		object { BaseLight translate -x*Siz }
		object { BaseLight translate  y*Siz }
		object { BaseLight translate -y*Siz }
		object { BaseLight translate  z*Siz }
		object { BaseLight translate -z*Siz }
		translate Pos
	}
#end

#macro Fader(Power, Reach, Pos)
	light_source {
		Pos, Power
		fade_distance Reach
		fade_power 1.2
	}
#end

#declare SunCol = < 1.00, 0.95, 0.87 >*100;

#macro Sun(Col, Dist, Size, Azim, Dir)
	light_source {
		z*Dist
		Col
		area_light
		<0, Size, 0>, <Size, 0, 0>
		4, 4
	  adaptive 1
  	jitter
	  fade_distance 50
  	fade_power 1
	}
	rotate x*-Azim
	rotate y*Dir
#end
