//=========================================
// Tree macro Parameters
//-----------------------------------------
// This parameter file must be called by the tree macro
//-----------------------------------------
#declare txtTree=texture{ pigment { rgb <0.5, 0.2, 0.1> } } // Bark texture

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rst=6372;      // random seed
#declare rsl=1095;      // random seed
#declare rd=seed(rst);  // random stream for branches
#declare rdl=seed(rsl); // separate random stream for leaves

//-----------------------------------------
// Tree structure parameters        
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
//#declare level0=7;      // recursion level
#declare level0=3;      // recursion level
#declare nseg0=12;       // initial number of branch segments (decreases of one at each level)
#declare nb=2;          // max number of branches per level
#declare dotop=true;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=105;        // initial branch length
#declare rb0=3.000;         // initial branch radius
#declare ab0=60;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=0.70;       // branch length decrease ratio (1=constant length)
#declare qrb=0.70;       // branch radius decrease ratio (1=constant radius)
#declare qab=1.00;       // branch angle decrease ratio (1=constant angle)
#declare stdax=20;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=20;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=0.75; // probability of branch apparition 
#declare jb=0.60;        // secondary branches start after this ratio of branch length
#declare qjb=0.55;       // branch length decrease ratio by height (1 = no variance with height)

#declare fgnarl=0.15;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.5;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0.00; // probability to have a twig on a trunk segment

#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush=< 0.0,-1.0, 0.0 >;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
#declare fpush=0.3;       // force of push
#declare aboveground=0; // constrains the branches above this level 
#declare belowsky=550;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=0.7;   // probability of root 0=no root ; 1=all [nb] roots
#declare nroot=6;      // number of roots;
#declare vroot=<1,-1,0>; // initial direction of root 
#declare yroot=<0,0.5,0>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=1.00;  // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=2;   // level where the leaves start to appear
#declare alz0=150;       // max z angle for leaf
#declare alx0=-05;      // start x angle for leaf
#declare stdalx=20;     // std x angle for leaf
#declare stdlsize=0.0;     // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare txtLeaf=texture{txtLeaf_3} // Leaf texture
#declare lsize=1.4;     // leaf size
#declare seg=20;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=7;          // leaf length
#declare wl=0.6;          // leaf width 
#declare fl=0.3;        // depth of leaf fold
#declare lpow=1.4;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=30;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=2.5;        // curve power, how slow the leaf bends
#declare ndents=2;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=1;      // number of lobes (individual leaves)
#declare alobes=80;    // angle made by all the lobes
#declare qlobes=0.8;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=2;          // stalk length (0=no stalk)
#declare ws=0.12;        // width of stalk
#declare as=15;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// parametric variables
//=========================================

#declare uMin = 0; // Minimum u value
#declare uMax = radians(350); // Maximum u value
#declare uNum = 36; // Number of points in u direction
#declare uWrap = 1; // u wraps around if != 0
#declare uSeed = 6323; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = 1; // Maximum v value
#declare vNum = 120; // Number of points in v direction
#declare vWrap = 0; // v wraps around if != 0
#declare vSeed = 8420; // Random number seed for v parameter

#declare IsRnd = true; // True if random number used
#declare IsUV = false; // True if object is to be UV-mapped

#declare Detail = "Partial"

// point function
#macro pnt(i, j, p, q, spl)
	#local vx = vecnorm(spl, j);
	#local vy = vecortho(spl, j);
	
	#local mrad = rad1*j+rad0*(vMax-j);
	#local irad = 0.85 + 0.10*sin(i*5) + (p-.5)*.05;
	#local pt0 = (vx*cos(i)+vy*sin(i))*mrad*irad+spl(j);
	
	pt0
#end

#declare Smooth = 0; // Smooth flag
