// tech_s12_drk_01.pov by Peter C. Capasso
// pogo@bestweb.net
#version 3.5;


// #declare remap_hue = <0, 0.2, 1>;
#declare remap_hue = <0.5, 0.5, 0.5>;


global_settings {
  assumed_gamma 2.4
  max_trace_level 20
}


#macro camera_transforms() // better than transform { }
  rotate z*14
  translate <0, 0, -3>
#end


camera {
  location 0
  direction <0, 0, 1.5>
  right <image_width / image_height, 0, 0>
  up <0, 1, 0>
  camera_transforms()
}


background { color rgb 0.7 }


#macro do_quad(p1, p2, p3, p4) // NOT A MESH!
  prism {
    linear_sweep
    linear_spline
    -0.001,
    0.001,
    5,
    <p1.x, p1.y>,
    <p2.x, p2.y>,
    <p3.x, p3.y>,
    <p4.x, p4.y>,
    <p1.x, p1.y>
    rotate x*-90
  }
#end


// stuff in front of camera (overlays)
#declare i_aspect = image_width / image_height;
merge {
  //upper part of mask
  do_quad( // not a mesh!!!!
    <-0.2 * i_aspect,  0.38, 0>,
    <-0.2 * i_aspect + 0.02,  0.4, 0>,
    < 0.5 * i_aspect,  0.4, 0>,
    < 0.5 * i_aspect,  0.38, 0>
  )
  do_quad(
    <-0.5 * i_aspect, 0.38, 0>,
    <-0.5 * i_aspect + 0.5, 0.38, 0>,
    <-0.5 * i_aspect + 0.5 - 0.05, 0.38 - 0.05, 0>,
    <-0.5 * i_aspect, 0.38 - 0.05, 0>
  )
  // lower part of mask
  do_quad( // not a mesh!!!!
    <-0.5 * i_aspect, -0.38, 0>,
    < 0.5 * i_aspect, -0.38, 0>,
    < 0.5 * i_aspect, -0.4, 0>,
    <-0.5 * i_aspect, -0.4, 0>,
  )
  no_shadow
  no_reflection
  pigment { color rgbt <0, 0, 0, 0.7> }
  finish { ambient 1 diffuse 0 }
  scale 0.67
  translate <0, 0, 1>
  camera_transforms()
}


#declare grid_function_1 = function {
  pigment {
    gradient <1, 0, 0>
    color_map {
      [ 0.0 color rgb 1 ]
      [ 0.04 color rgb 0 ]

      [ 0.125 - 0.01 color rgb 0 ]
      [ 0.125 color rgb 1 ]
      [ 0.125 + 0.01 color rgb 0 ]

      [ 0.25 - 0.01 color rgb 0 ]
      [ 0.25 color rgb 1 ]
      [ 0.25 + 0.01 color rgb 0 ]

      [ 0.375 - 0.01 color rgb 0 ]
      [ 0.375 color rgb 1 ]
      [ 0.375 + 0.01 color rgb 0 ]

      [ 0.5 - 0.01 color rgb 0 ]
      [ 0.5 color rgb 1 ]
      [ 0.5 + 0.01 color rgb 0 ]

      [ 0.625 - 0.01 color rgb 0 ]
      [ 0.625 color rgb 1 ]
      [ 0.625 + 0.01 color rgb 0 ]

      [ 0.75 - 0.01 color rgb 0 ]
      [ 0.75 color rgb 1 ]
      [ 0.75 + 0.01 color rgb 0 ]

      [ 0.875 - 0.01 color rgb 0 ]
      [ 0.875 color rgb 1 ]
      [ 0.875 + 0.01 color rgb 0 ]

      [ 1 - 0.04 color rgb 0 ]
      [ 1 color rgb 1 ]
    }
  }
}


#declare grid_fade = function {
  pigment {
    planar
    color_map {
      [ 0 color rgb 1 ]
      [ 0.25 color rgb 0.8 ]
      [ 0.5 color rgb 0 ]
    }
  }
}


// grid overlay
box {
  <-0.5 * i_aspect, -0.5, -0.001>,
  <0.5 * i_aspect, 0.5, 0>
  pigment {
    function {
      grid_fade(x,y * 0.4,z).red * 
      (
        0.5 * grid_function_1(x * 2.3, y * 2.3, z).red +
        0.5 * grid_function_1(y * 2.3, x * 2.3, z).red
      )
    }
    scale 0.2
    pigment_map {
      [ 0.0 color rgbt 1 ]
      [ 1.0 color rgbt <1, 1, 1, 0.7> ]
    }
  }
  finish { ambient 1 diffuse 0 }
  no_reflection
  no_shadow
  scale 0.67
  translate <0, 0, 0.99>
  camera_transforms()
}


#declare mix_1 = pigment {
  planar
  color_map {
    [ 0 color rgb 0 ] // edge and beyond
    [ 0.4 color rgb 1 ] // to the center
  }
  rotate z*90 // x gradient
}


#declare mix_2 = pigment {
  planar // y gradient
  pigment_map {
    [ 0 color rgb 0 ] // edge and beyond
    [ 0.4 mix_1 ] // to the center
  }
}


#macro mix_to_box(x1, y1, x2, y2) // x1 < x2, y1 < y2
  #local rx1 = min(x1, x2);
  #local rx2 = max(x1, x2);
  #local ry1 = min(y1, y2);
  #local ry2 = max(y1, y2);

  #local f1 = pigment { // asuming pic pigment <0, 0> to <1, 1>
    mix_2
    translate <1, 1, 0>
    scale <0.5, 0.5, 1>
    scale <rx2 - rx1, ry2 - ry1, 1>
    translate <rx1, ry1, 0>
  }
  f1
#end


#macro lazy_map(lm_filename)
  #local lz_sl = strlen(lm_filename);
  #local lz_ext = strlwr(substr(lm_filename, lz_sl - 2, 3)) // get file type
  #if (strcmp(lz_ext, "tga") = 0)
    tga lm_filename
  #else
    #if (strcmp(lz_ext, "png") = 0)
      png lm_filename
    #else
      #if (strcmp(lz_ext, "gif") = 0)
        gif lm_filename
      #else
        #if (strcmp(lz_ext, "iff") = 0)
          iff lm_filename
        #else
          #if (strcmp(lz_ext, "jpg") = 0)
            jpeg lm_filename
          #else
            sys lm_filename
          #end
        #end
      #end
    #end
  #end
#end


#macro place_piccy(pic_name, x1, y1, x2, y2) // x1 < x2, y1 < y2
  #local rx1 = min(x1, x2);
  #local rx2 = max(x1, x2);
  #local ry1 = min(y1, y2);
  #local ry2 = max(y1, y2);

  #local f1 = pigment {
    image_map {
      lazy_map(pic_name)  // pic pigment <0, 0> to <1, 1>
    }
    scale <(rx2 - rx1), (ry2 - ry1), 1> // scale for aspect and size
    translate <rx1, ry1, 0> // position
  }
  f1
#end


#macro pic_fade(add_pig, bounce_pig, mixing_pig)
  #local f1 = function {
    pigment { mixing_pig }
  }
  #local f2 = pigment {
    function { f1(x, y, z).green }
    pigment_map {
      [ 0.0 bounce_pig ]
      [ 1.0 add_pig ]
    }
  }
  f2
#end


#macro pic_fade_frontend(which_pic, bounce_pig, XYpos, Xsize, Ysize)
  pic_fade(
    pigment {  // pig to add
      place_piccy(
        which_pic,
        XYpos.u + (Xsize / -2),
        XYpos.v + (Ysize / -2),
        XYpos.u + (Xsize / 2),
        XYpos.v + (Ysize / 2)
      )
    },
    pigment { bounce_pig }, // bounce pig
    pigment {
      mix_to_box(
        XYpos.u - (Xsize / 2),
        XYpos.v - (Ysize / 2),
        XYpos.u + (Xsize /2),
        XYpos.v + (Ysize / 2)
      )
    }
  )
#end


#declare colloge_pig2 = pigment {
  pic_fade_frontend(
    "idea_copy.tga",
    pic_fade_frontend(
      "alexie-saile.tga",
      pic_fade_frontend(
        "lizard_zoom.tga",
        pic_fade_frontend(
          "new_texture.tga",
          pic_fade_frontend(
            "empire_screen2.iff",
            pic_fade_frontend(
              "new_texture2.tga",
              pic_fade_frontend(
                "pic_garden_04.gif",
                pic_fade_frontend(
                  "from_oct_2000.tga",
                  pic_fade_frontend(
                    "me_flag.tga",
                    pigment { bozo scale 0.2 color_map { [ 0 color rgb 0 ] [ 1 color rgb 1 ] } warp { turbulence 1.0 } },
                    <-0.012, -0.014>, 1.38816 * 0.6, 0.6
                  )
                  <0.446, 0.314>, 1.33333 * 0.6, 0.6
                )
                <-0.432, -0.322>, 1.34236 * 0.6, 0.6
              )
              <-0.437, 0.004>, 1.33333 * 0.6, 0.6
            )
            <0.003, -0.317>, 1.43636 * 0.6, 0.6
          )
          <-0.429, 0.329>, 1.33333 * 0.6, 0.6
        )
        <-0.002, 0.341>, 1.33333 * 0.6, 0.6
      )
      <0.440, 0.018>, 1.38816 * 0.6, 0.6
    )
    <0.434, -0.323>, 1.33333 * 0.6, 0.6
  )
  translate <0.5 * (4/3), 0.5, 0>  warp { repeat <(4/3), 0, 0>}
  warp { repeat <0, 1, 0> }
  translate <-0.5 * (4/3), -0.5, 0>
}


#macro do_remap(p_in)
  #local p1 = function {
    pigment { p_in }
  }
  #local p2 = pigment {
    function { p1(x, y, z).grey }
    color_map {
      //[ 0.0 color rgb 0 ]
      //[ 0.5 color rgb (1 + remap_hue) * 0.5 ]
      //[ 1.0 color rgb 1 ]
      [ 0.0 color rgb 0 ]
      [ 1.0 color rgb remap_hue * 0.13 + 0.12 ]
    }
  }
  p2
#end


#declare colloge_pig1 = pigment { do_remap(colloge_pig2) }
#declare c_w = 0.02;


union { // hallway
  box {
    <-0.5 * (4/3), -0.5, 4>,  < 0.5 * (4/3),  0.5, 4>  pigment { colloge_pig1 }
    finish { ambient 1 diffuse 0 }
    scale 4
  }


  box {
    <-0.5 * (4/3), -0.5, 0>,
    <-0.5 * (4/3),  0.5, 4>
    pigment { colloge_pig1 rotate y*-90 translate <0, 0, -0.5 * (4/3)>}
    finish { ambient 1 diffuse 0 }
    scale 4
  }


  box {
    <0.5 * (4/3), -0.5, 0>,
    <0.5 * (4/3), 0.5, 4>
    pigment { colloge_pig1 rotate y*90 translate <0, 0, -0.5 * (4/3)>}
    finish { ambient 1 diffuse 0 }
    scale 4
  }


  box {
    <-0.5 * (4/3), 0.5, 0>,
    <0.5 * (4/3), 0.5, 4>
    pigment { colloge_pig1 rotate x*-90 translate <0, 0, -0.5>}
    finish { ambient 1 diffuse 0 }
    scale 4
  }


  box {
    <-0.5 * (4/3), -0.5, 0>,
    <0.5 * (4/3), -0.5, 4>
    pigment { colloge_pig1 rotate x*90 translate <0, 0, -0.5>}
    finish { ambient 1 diffuse 0 }
    scale 4
  }


  union { 
    cylinder {
      <(4/3) * -2, 2, 12 * (4/3)>,
      <(4/3) * -2, 2, 0>, c_w
    }
    cylinder {
      <(4/3) *  2, 2, 12 * (4/3)>,
      <(4/3) *  2, 2, 0>, c_w
    }
    cylinder {
      <(4/3) * -2, -2, 12 * (4/3)>,
      <(4/3) * -2, -2, 0>, c_w
    }
    cylinder {
      <(4/3) * 2, -2, 12 * (4/3)>,
      <(4/3) * 2, -2, 0>, c_w
    }
    #declare zz = 0;
    #while (zz < 4)
      cylinder { // left wall
        <(4/3) * -2,  2, zz * 4 * (4/3)>,
        <(4/3) * -2, -2, zz * 4 * (4/3)>, c_w
      }
      cylinder { // right wall
        <(4/3) *  2,  2, zz * 4 * (4/3)>,
        <(4/3) *  2, -2, zz * 4 * (4/3)>, c_w
      }
      #declare zz = zz + 1;
    #end
    #declare zz = 0;
    #while (zz < 5)
      cylinder { // upper
        <(4/3) * -2,  2, zz * 4>,
        <(4/3) *  2,  2, zz * 4>, c_w
      }
      cylinder { // lower
        <(4/3) * -2, -2, zz * 4>,
        <(4/3) *  2, -2, zz * 4>, c_w
      }
      #declare zz = zz + 1;
    #end
    pigment { color rgb 0 }
    finish { ambient 1 diffuse 0 }
  }


  scale 10 // make halway big: to make room for media/lights
}


// Peter C. Capasso
#declare s12_1 = 63.4349488;
#declare gr = (sqrt(5) + 1) / 2;  // golden ratio, again
#declare p_size = 0.75;


#declare penta_face = union {
  intersection {
    prism {
      linear_sweep
      linear_spline
      0,    // sweep from
      -0.15, // sweep to
      6,    // number of points
      p_size * <sin(0), cos(0)>,
      p_size * <sin((pi * 2) * (1/5)), cos((pi * 2) * (1/5))>,
      p_size * <sin((pi * 2) * (2/5)), cos((pi * 2) * (2/5))>,
      p_size * <sin((pi * 2) * (3/5)), cos((pi * 2) * (3/5))>,
      p_size * <sin((pi * 2) * (4/5)), cos((pi * 2) * (4/5))>,
      p_size * <sin(0), cos(0)>
    }
    prism {
      linear_sweep
      linear_spline
      0.001,  // sweep from
      -0.151, // sweep to
      6,      // number of points
      p_size * <sin(0), cos(0)>,
      p_size * <sin((pi * 2) * (1/5)), cos((pi * 2) * (1/5))>,
      p_size * <sin((pi * 2) * (2/5)), cos((pi * 2) * (2/5))>,
      p_size * <sin((pi * 2) * (3/5)), cos((pi * 2) * (3/5))>,
      p_size * <sin((pi * 2) * (4/5)), cos((pi * 2) * (4/5))>,
      p_size * <sin(0), cos(0)>
      scale <0.8, 1, 0.8>
      inverse
    }
  }
  intersection {
    union {
      prism {
        linear_sweep
        linear_spline
        -0.03,  // sweep from
        -0.05, // sweep to
        6,      // number of points
        p_size * <sin(0), cos(0)>,
        p_size * <sin((pi * 2) * (1/5)), cos((pi * 2) * (1/5))>,
        p_size * <sin((pi * 2) * (2/5)), cos((pi * 2) * (2/5))>,
        p_size * <sin((pi * 2) * (3/5)), cos((pi * 2) * (3/5))>,
        p_size * <sin((pi * 2) * (4/5)), cos((pi * 2) * (4/5))>,
        p_size * <sin(0), cos(0)>
        scale <0.81, 1, 0.81>
      }
      prism {
        linear_sweep
        linear_spline
        -0.1,  // sweep from
        -0.12, // sweep to
        6,      // number of points
        p_size * <sin(0), cos(0)>,
        p_size * <sin((pi * 2) * (1/5)), cos((pi * 2) * (1/5))>,
        p_size * <sin((pi * 2) * (2/5)), cos((pi * 2) * (2/5))>,
        p_size * <sin((pi * 2) * (3/5)), cos((pi * 2) * (3/5))>,
        p_size * <sin((pi * 2) * (4/5)), cos((pi * 2) * (4/5))>,
        p_size * <sin(0), cos(0)>
        scale <0.81, 1, 0.81>
      }
    }
    prism {
      linear_sweep
      linear_spline
      -0.02,  // sweep from
      -0.13, // sweep to
      6,      // number of points
      p_size * <sin(0), cos(0)>,
      p_size * <sin((pi * 2) * (1/5)), cos((pi * 2) * (1/5))>,
      p_size * <sin((pi * 2) * (2/5)), cos((pi * 2) * (2/5))>,
      p_size * <sin((pi * 2) * (3/5)), cos((pi * 2) * (3/5))>,
      p_size * <sin((pi * 2) * (4/5)), cos((pi * 2) * (4/5))>,
      p_size * <sin(0), cos(0)>
      inverse
      scale <0.77, 1, 0.77>
    }
  }
  #declare roty = 0;
  #while (roty < 360)
    box { <-0.3, 0, -0.51>, <0.3, 0.04, -0.56> rotate y*roty }
    #declare roty = roty + 72;
  #end
}


#declare s12_transforms = transform {
  rotate y*17
  rotate x*21
  rotate z*-20
  scale 0.4
}

union {
  object { penta_face translate <0, 1, 0>}
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 }
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 rotate y*72 }
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 rotate y*-72 }
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 rotate y*2*72 }
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 rotate y*2*-72 }

  object { penta_face translate <0, 1, 0> rotate x*180 }
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 rotate x*180 }
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 rotate y*72 rotate x*180}
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 rotate y*-72 rotate x*180}
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 rotate y*2*72 rotate x*180}
  object { penta_face translate <0, 1, 0> rotate y*36 rotate x*-s12_1 rotate y*2*-72 rotate x*180}
  transform s12_transforms
  pigment { color rgb 0.4 }
  finish { ambient 0.3 diffuse 0.7 }
  normal { agate bump_size -0.13 scale 0.2 }
}


sphere { // light blocker (inside s12)
  0, 1
  hollow
  no_shadow
  pigment { color rgbt 1 }
  finish { ambient 1 diffuse 0 }
  interior {
    media {
      absorption 7
      density {
        spherical
        color_map {
          [ 0 color rgb 0 ]
          [ 0.3 color rgb 1 ]
        }
      }
    }
  }
  transform s12_transforms
}


// try a beam of light now ....
#declare light_beam = cylinder {
  <0, 0.2, 0>, <0, 37, 0>, 1
  hollow
  pigment { color rgbt 1 }
  finish { ambient 1 diffuse 0 }
  interior {
    media {
      emission 1
      density {
        cylindrical
        color_map {
          [ 0.0 color rgb 0 ]
          [ 0.4 color rgb remap_hue ]
          [ 0.8 color rgb 4 ]
          [ 1.0 color rgb 6 ]
        }
      }
    }
    media {
      absorption 1
      density {
        cylindrical
        color_map {
          [ 0.0 color rgb 0 ]
          [ 0.4 color rgb (<1, 1, 1> - remap_hue) ]
          [ 0.8 color rgb 1 ]
        }
      }
    }
  }
  scale <0.7, 1, 0.7>
}


union {
//  object { light_beam }
  object { light_beam rotate y*36 rotate x*-s12_1 } // tetra ok - up
  object { light_beam rotate y*36 rotate x*-s12_1 rotate y*72 } // 5th ok
//  object { light_beam rotate y*36 rotate x*-s12_1 rotate y*-72 }
//  object { light_beam rotate y*36 rotate x*-s12_1 rotate y*2*72 } // bad
  object { light_beam scale <0.8, 1, 0.8> rotate y*36 rotate x*-s12_1 rotate y*2*-72 } // tetra OK - rear, right

//  object { light_beam rotate x*180 }
//  object { light_beam rotate y*36 rotate x*-s12_1 rotate x*180 } // bottom
  object { light_beam rotate y*36 rotate x*-s12_1 rotate y*72 rotate x*180 } // tetra OK - lower left near
  object { light_beam rotate y*36 rotate x*-s12_1 rotate y*-72 rotate x*180 } // tetra OK - near lower right
//  object { light_beam rotate y*36 rotate x*-s12_1 rotate y*2*72 rotate x*180 }
//  object { light_beam rotate y*36 rotate x*-s12_1 rotate y*2*-72 rotate x*180 }
  transform s12_transforms
}


light_source {
  <2000, 2000, -3000>
  color rgb 1
  shadowless
}


/* actual end of this file */
