// *******************************************************
// Persistence Of Vision Ray Tracer Scene Description File
// File name  : bolts1.pov
// Version    : 3.5
// Description: freestyle version of brazil demo scene
// Date       : January 2002
// Author     : Jaime Vives Piqueres
// Scene scale: 1 pov unit = 1 cm
// *******************************************************

// +w600 +h400

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

// *** control center ***
#declare use_area=0;
#declare use_blur=4; //(x8 = samples)
#declare use_norm=1;
#declare use_rad =0;

global_settings{
  ambient_light 0.0
  assumed_gamma 1.1
  // Kari cornell-box settings
  #if (use_rad)
  radiosity{
    //pretrace_start 0.04
    //pretrace_end 0.01
    //count 80 //200
    //recursion_limit 3
    nearest_count 10
    error_bound 0.5
  }
  #end
}


// *************************
// *** lightsys includes ***
// *************************
#include "i_spectra.inc"     // spectrum-to-rgb macros
#include "i_lights.inc"       // bulb-light macro
#include "i_light_const.inc" // useful predefined constants (lumens, filters and spectrums)


// ************************************
// *** setup global light variables ***
// ************************************
// + maximum global lumens (decrease to "overexpose", increase to "underexpose")
#declare MAX_LUMENS=lm_w15_fluorescent*.4; // a little overexposed...
// + film temperature (color balancing)
#declare REF_WHITE=ft_indoor;        // 3200K
//#declare REF_WHITE=ft_daylight;        // 5500K
// + color correction filter for all lights (absorption)
//#declare COLOR_FILTER=0;               // no filter: note the greenish tone of fluorescents!
#declare COLOR_FILTER=Blue*.6+Green*.5;      // green filter for fluorescents


// *******************
// *** build lamps ***
// *******************
// + declare light colors from predefined spectral-samples arrays
#declare cl_warm_fluor  =SpectrumToRGB(sp_warm_white_fluor);  // warm white fluorescent
#declare cl_incandescent=SpectrumToRGB(sp_incandescent_60w);  // incandescent
// + declare common test lumens for all lights
#declare lm_test=lm_w15_fluorescent*2;
// + lamp object
#macro sheet(cl)
box{-.5,.5
 material{
  texture{
   pigment { color rgbf<1, 1, 1, 1> }
   finish { ambient 0 diffuse 0 }
  }
  interior{
   media {
    emission cl*MAX_LUMENS
    intervals 10
    samples 1, 10
    confidence 0.9999
    variance 1/1000
   }
  }
 }
 hollow
 no_shadow
}
#end
// + build the lamps
union{
 light(cl_warm_fluor,lm_test,<26,0,0>,<0,0,20>,13*use_area,10*use_area,1,1,1)
 object{sheet(cl_warm_fluor)scale <20,.1,20> translate .9*y}
 translate <40,145,14>
}
union{
 light(cl_incandescent,1200,0,0,0,0,0,0,1)
 object{sheet(cl_incandescent)scale <20,.1,20> translate .9*y}
 translate <-50,140,-30>
}


// *****************
// *** test room ***
// *****************
// + main room
box{-.5,.5
 scale <500,250,1000>
 texture{
  pigment{White}
  finish{diffuse 0.75}
 }
 hollow
 translate 125*y
}


// *************************
// *** OLD BRUSHED METAL ***
// *************************
// + free imagemap found on the net
#declare p_map_metal=
pigment{image_map{jpeg "im_metal"} scale 3}
// + "proceduralize" it "a la tran".
#declare p_imagemap=
pigment{
 wrinkles turbulence .3 lambda 3
 pigment_map{
  [0.0 p_map_metal]
  [1.0 p_map_metal rotate 90*y translate 1000]
 }
 scale 10
 rotate 90*x
}
// + microsurface normal
#declare p_micro=
pigment{
 onion turbulence .5
 color_map{
  [0.0 White]
  [0.45 White]
  [0.55 White*.96]
  [1.0 White*.96]
 }
 scale .1
}
// + big dents pattern 1
#declare p_dents1=
pigment{
 granite
 color_map{
  [0.0 White]
  [0.8 White]
  [0.9 White*.2]
  [1.0 White*.01]
 }
 turbulence .7
 scale 40
}
// + big dents pattern 2
#declare p_dents2=
pigment{
 crackle
 color_map{
  [0.0 White]
  [0.6 White]
  [0.7 White*.2]
  [1.0 White*.01]
 }
 turbulence .7
 scale 40
}
// + average all the normals (micro + big dents)
#declare p_brushed=
pigment{
 average turbulence 0
 pigment_map{
  [0.0 p_micro translate 1000*y]
  [0.1 p_micro translate 1000*x]
  [0.2 p_micro translate 1000*z]
  [0.3 p_dents1]
  [0.5 p_imagemap]
  [0.6 p_dents2]
  [0.8 p_micro translate <1000,1000,0>]
  [0.9 p_micro translate <1000,0,1000>]
  [1.0 p_micro translate<0,1000,1000>]
 }
 scale .02
}
// + declare the final normal as image_pattern
#declare n_brushed=
normal{pigment_pattern{p_brushed} .1}
// + declare the final metal texture
#declare t_metal=
texture{
 pigment{p_imagemap}
 #if (use_norm)
 normal{n_brushed 1.5}
 #end
 finish{F_MetalA}
}


// ********************
// *** BOLTS & NUTS ***
// ********************
#declare bolt=
union{
 intersection{
  union{
   cylinder{<0,-.3,0>,<0,.3,0>,.6}
   torus{.6,.3}
  }
  plane{z,.72}
  plane{z,-.72 inverse}
  plane{x,0 rotate 30*y inverse translate -.82*x}
  plane{x,0 rotate -30*y inverse translate -.82*x}
  plane{x,0 rotate 30*y translate .82*x}
  plane{x,0 rotate -30*y translate .82*x}
 }
 height_field{
  png "hf_bolt"
  smooth
  water_level 0.1
  translate -.5
  scale <1.3,.1,1.3>
  translate <0,.27,0>
 }
}
#declare nut=
difference{
 intersection{
  union{
   cylinder{<0,-.3,0>,<0,.3,0>,.6}
   torus{.6,.3}
  }
  plane{z,.72}
  plane{z,-.72 inverse}
  plane{x,0 rotate 30*y inverse translate -.82*x}
  plane{x,0 rotate -30*y inverse translate -.82*x}
  plane{x,0 rotate 30*y translate .82*x}
  plane{x,0 rotate -30*y translate .82*x}
  plane{y,-.29 inverse}
 }
 cylinder{<0,-.4,0>,<0,.4,0>,.4}
 torus{.4,.05}
 torus{.4,.05 translate .12*y}
 torus{.4,.05 translate -.12*y}
 torus{.4,.05 translate .24*y}
 torus{.4,.05 translate -.24*y}
 torus{.4,.05 translate .3*y}
 torus{.4,.05 translate -.3*y}
}
#declare rn=seed(3673);
union{
 object{bolt rotate 360*rand(rn)*y translate <0,101.31,-15>}
 object{bolt rotate 360*rand(rn)*y translate <0,101.31,-10>}
 object{bolt rotate 360*rand(rn)*y translate <0,101.31,-5>}
 object{bolt rotate 360*rand(rn)*y translate <0,101.31,5>}
 object{bolt rotate 360*rand(rn)*y translate <0,101.31,10>}
 object{bolt rotate 360*rand(rn)*y translate <0,101.31,15>}
 object{bolt rotate 360*rand(rn)*y translate <0,101.31,25>}
 object{bolt rotate 360*rand(rn)*y translate <0,101.31,30>}
 object{bolt rotate 360*rand(rn)*y translate <0,101.31,35>}
 texture{t_metal}
}
object{nut
 texture{t_metal translate 10*y}
 translate <-1.5,101.31,-9.5>
}
object{nut
 texture{t_metal translate 20*y}
 rotate <90,30,0>
 translate <-1.4,101.74,-11.2>
}
union{
  superellipsoid{<.1,.1> scale .5 rotate -90*x scale <5,2,300>}
  superellipsoid{<.1,.1> scale .5 rotate -90*x scale <5,1,300> rotate 90*y translate <0,-1,20>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,-15>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,-10>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,-5>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,5>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,10>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,15>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,25>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,30>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,35>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <0,-1,20>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <5,-1,20>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <10,-1,20>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <15,-1,20>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <-5,-1,20>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <-10,-1,20>}
  cylinder{<0,0,0>,<0,-100,0>,1 translate <-15,-1,20>}
  texture{t_metal}
  translate <0,100,0>
}


// **************
// *** camera ***
// **************
camera{
 location <-4,108,-50>
 up 1.5*y
 right 3.0*x
 direction 13.5*z
 look_at <0,101.3,-7>
 #if (use_blur)
 focal_point <0,100.3,-10>
 aperture 1.2
 blur_samples 8*use_blur
 #end
}


