
 

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}



camera {
  location  <-23.0, 5, 5>

  look_at   <0.0, 0.0,  0.0> 
  angle 40
}

sky_sphere {
  pigment {
    bozo
    color_map {
      [0.0 rgb <0.8,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
    scale .5
  }
  
}

light_source {
  <-30, 10, 0>
  color rgb <1, 1, 1>
  
}

// 
#include "3dlife.inc"

// declare these variables *after* calling 3dlife.inc
// so that they will override the defaults 

#declare RS1=seed(31);
//#declare cubeTexture=texture{
//        pigment{Red}
//}
#declare gbNewTexture=texture{
        pigment{Green}
}                    
#declare gbOldTexture=texture{
        pigment{Red}
}                  
#declare gbDiedTexture=texture{
        pigment{White transmit .8}
}


#declare diffScale=.5;// make old (growingBlobs) cells 50% larger than new ones

// size of the cell array
#declare xSize=7;
#declare ySize=7;
#declare zSize=7;

// Each of the three ways to get an initial generation requires some
// additional parameter
//      To generate live cells randomly, livePercent needs to be specified. to generate live cells randomly
#declare livePercent=20; // livePercent=10 makes 10 percent of the array live cells                                           


//      a file of cell values, initialGenerationFile, needs to be specified in order to make the
//      first generation from a file:
//#declare initialGenerationFile="glider5766.lif";
//      could use tempCellFileName to pickup from the end
//      of the last run
//      #declare initialGenerationFile="lifecells.tmp";


//      an array of indexes of the live cells needs to be specified in order
//      to generate from a 'live array'
#declare liveArray=liveGlider5766; 
//      it might be convenient to define the liveArray about 0,0,0     
//#declare liveArray=array[4][3]{{0,1,0},{1,0,0},{0,0,1},{0,0,0}} 
//      in which case, the cells need to be centered in the cell array.
#declare centerTheArray=1;


#declare myRules=array[4]{5,7,3,3}
//#declare myRules=rules5766


object{
        
        generateSceneCells(xSize,ySize,zSize,myRules,fromRandom,cubeCells,torusWrap) 

}
// ---- end of scene  

// The main macro to call is
// generateSceneCells(xS,yS,zS,rules,gen1From,cellType,wrap)
//
// xS = 'x' direction width of cell array (integer)

// yS = 'y' direction width of cell array (integer)

// zS = 'z' direction width of cell array (integer)

// rules = an array[4] of integers specifying the Life rules
// Using RulesArray=array[4]{r1,r2,r3,r4} 
// makes the rule: 
//        if a cell is already 'live' and it has from 
//        r1 through r2 (inclusive) live neighbors, then 
//                it remains alive in the next generation.
//                That is, it will survive. 
//        Otherwise it becomes 'dead'.
//        On the other hand. if the cell is now dead, then 
//        if it has from r3 through r4 (inclusive) live neighbors then 
//                it will be alive in the next generation.

// gen1From tells where the first generation comes from. 
//      fromLiveArray takes an array of cell indexes and each
//              cell in the array will be 'alive' in the first generation.
//              For example, using the array
//                      #declare liveArray= array[2][3]={{0,0,1},{0,0,0}}
//              would make two cells alive: the cell at 0,0,1 and the cell at 0,0,0
//              The second index of the array must be '3' since a cell is specified
//              by three indices
//   
//      fromFile gets the first generation from a file name by 'initialGenerationFile'
//              The file contains the cell Values for all of the cells in the Life game
//              cell value > 0 is alive. cell value <=0 is dead.
//              
//      fromRandom generates the first generation randomly with livePercent of the cells
//              alive.

// cellType is either 'cubeCells' (plain cubes occupy live cells) or 'growingBlobs' (where
//      live cells which were 'just born' (weren't alive in the last generation) are green.
//      Alive cells which survived from the last generation are larger and red.
//      Cells which were alive in the last generation but are now dead are small and white)

// wrap tells whether to wrap the cell array or not.
//      noWrap means that a cell on the edge of the cell array has no neighboring cells
//              outside the array.
//      torusWrap 'wraps' the array around from top to bottom and left to right. so a cell
//              at the edge has neighboring cells on the other side of the array.
