//==============================================================
// TROMBONE.INC                                                 
//--------------------------------------------------------------
// Created by Martin Magnusson, mama7121@student.uu.se
//
// 1 unit = 1 cm
// Total length is approximately 112 units. Origin is at the
// centre of the bell.
//
// Created with sPatch, Copyright 1996-1998 by Mike Clifton     
//==============================================================

  
// Texture declarations-----------------------------------------  
#declare brass_color =
  rgb <1, 0.90, 0.45>;

#declare chrome_color =
  rgb <0.93, 0.95, 0.90>;
  
#declare brass_texture =
  texture {
    pigment {brass_color}
    finish {
      metallic 1
      reflection brass_color
      brilliance 10
      specular 0.9
      roughness 0.00025
    }
  }

#declare chrome_texture =
  texture {
    pigment {chrome_color}
    finish {
      metallic 1
      reflection chrome_color
      brilliance 10
      specular 0.9
      roughness 0.00025
    }
  }           
  
#declare cork_texture =
  texture {
    pigment {rgb <0.9, 0.8, 0.7>}
    finish {                    
      ambient 0.5  
      diffuse 0.2
    }  
  }
  
#declare black_plastic_texture =
  texture {
    pigment {rgb 0.3}
  }        
// -------------------------------------------------------------

                                                                
                                                                
                                                                
// The trombone-------------------------------------------------  

union {
// Layer 1 - brass parts
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 5.658, 3.000> <0.000, 6.876, 2.000> <0.000, 8.669, 0.888> <0.000, 9.972, 0.000> 
		<-1.299, 5.658, 3.000> <-1.299, 6.876, 2.000> <-2.289, 8.669, 0.888> <-2.289, 9.972, 0.000> 
		<-3.082, 4.919, 3.000> <-3.943, 5.780, 2.000> <-4.510, 7.748, 0.888> <-5.431, 8.669, 0.000> 
		<-4.000, 4.000, 3.000> <-4.862, 4.862, 2.000> <-6.129, 6.129, 0.888> <-7.050, 7.050, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 5.658, 3.000> <-1.299, 5.658, 3.000> <-3.082, 4.919, 3.000> <-4.000, 4.000, 3.000> 
		<0.000, 5.037, 3.510> <-1.299, 5.037, 3.510> <-2.642, 4.479, 3.510> <-3.561, 3.561, 3.510> 
		<0.000, 4.241, 4.284> <-0.890, 4.241, 4.284> <-2.369, 3.628, 4.284> <-2.998, 2.998, 4.284> 
		<0.000, 3.877, 5.000> <-0.890, 3.877, 5.000> <-2.111, 3.370, 5.000> <-2.741, 2.741, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 5.658, 3.000> <1.299, 5.658, 3.000> <3.082, 4.919, 3.000> <4.000, 4.000, 3.000> 
		<0.000, 6.876, 2.000> <1.299, 6.876, 2.000> <3.943, 5.780, 2.000> <4.862, 4.862, 2.000> 
		<0.000, 8.669, 0.888> <2.289, 8.669, 0.888> <4.510, 7.748, 0.888> <6.129, 6.129, 0.888> 
		<0.000, 9.972, 0.000> <2.289, 9.972, 0.000> <5.431, 8.669, 0.000> <7.050, 7.050, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 5.658, 3.000> <0.000, 5.037, 3.510> <0.000, 4.241, 4.284> <0.000, 3.877, 5.000> 
		<1.299, 5.658, 3.000> <1.299, 5.037, 3.510> <0.890, 4.241, 4.284> <0.890, 3.877, 5.000> 
		<3.082, 4.919, 3.000> <2.642, 4.479, 3.510> <2.369, 3.628, 4.284> <2.111, 3.370, 5.000> 
		<4.000, 4.000, 3.000> <3.561, 3.561, 3.510> <2.998, 2.998, 4.284> <2.741, 2.741, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.000, 4.000, 3.000> <4.919, 3.082, 3.000> <5.658, 1.299, 3.000> <5.658, 0.000, 3.000> 
		<4.862, 4.862, 2.000> <5.780, 3.943, 2.000> <6.876, 1.299, 2.000> <6.876, 0.000, 2.000> 
		<6.129, 6.129, 0.888> <7.748, 4.510, 0.888> <8.669, 2.289, 0.888> <8.669, 0.000, 0.888> 
		<7.050, 7.050, 0.000> <8.669, 5.431, 0.000> <9.972, 2.289, 0.000> <9.972, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.000, 4.000, 3.000> <3.561, 3.561, 3.510> <2.998, 2.998, 4.284> <2.741, 2.741, 5.000> 
		<4.919, 3.082, 3.000> <4.479, 2.642, 3.510> <3.628, 2.369, 4.284> <3.370, 2.111, 5.000> 
		<5.658, 1.299, 3.000> <5.037, 1.299, 3.510> <4.241, 0.890, 4.284> <3.877, 0.890, 5.000> 
		<5.658, 0.000, 3.000> <5.037, 0.000, 3.510> <4.241, 0.000, 4.284> <3.877, 0.000, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.658, 0.000, 3.000> <5.658, -1.299, 3.000> <4.919, -3.082, 3.000> <4.000, -4.000, 3.000> 
		<6.876, 0.000, 2.000> <6.876, -1.299, 2.000> <5.780, -3.943, 2.000> <4.862, -4.862, 2.000> 
		<8.669, 0.000, 0.888> <8.669, -2.289, 0.888> <7.748, -4.510, 0.888> <6.129, -6.129, 0.888> 
		<9.972, 0.000, 0.000> <9.972, -2.289, 0.000> <8.669, -5.431, 0.000> <7.050, -7.050, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.658, 0.000, 3.000> <5.037, 0.000, 3.510> <4.241, 0.000, 4.284> <3.877, 0.000, 5.000> 
		<5.658, -1.299, 3.000> <5.037, -1.299, 3.510> <4.241, -0.890, 4.284> <3.877, -0.890, 5.000> 
		<4.919, -3.082, 3.000> <4.479, -2.642, 3.510> <3.628, -2.369, 4.284> <3.370, -2.111, 5.000> 
		<4.000, -4.000, 3.000> <3.561, -3.561, 3.510> <2.998, -2.998, 4.284> <2.741, -2.741, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.000, -4.000, 3.000> <3.082, -4.919, 3.000> <1.299, -5.658, 3.000> <0.000, -5.658, 3.000> 
		<4.862, -4.862, 2.000> <3.943, -5.780, 2.000> <1.299, -6.876, 2.000> <0.000, -6.876, 2.000> 
		<6.129, -6.129, 0.888> <4.510, -7.748, 0.888> <2.289, -8.669, 0.888> <0.000, -8.669, 0.888> 
		<7.050, -7.050, 0.000> <5.431, -8.669, 0.000> <2.289, -9.972, 0.000> <0.000, -9.972, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.000, -4.000, 3.000> <3.561, -3.561, 3.510> <2.998, -2.998, 4.284> <2.741, -2.741, 5.000> 
		<3.082, -4.919, 3.000> <2.642, -4.479, 3.510> <2.369, -3.628, 4.284> <2.111, -3.370, 5.000> 
		<1.299, -5.658, 3.000> <1.299, -5.037, 3.510> <0.890, -4.241, 4.284> <0.890, -3.877, 5.000> 
		<0.000, -5.658, 3.000> <0.000, -5.037, 3.510> <0.000, -4.241, 4.284> <0.000, -3.877, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -5.658, 3.000> <-1.299, -5.658, 3.000> <-3.082, -4.919, 3.000> <-4.000, -4.000, 3.000> 
		<0.000, -6.876, 2.000> <-1.299, -6.876, 2.000> <-3.943, -5.780, 2.000> <-4.862, -4.862, 2.000> 
		<0.000, -8.669, 0.888> <-2.289, -8.669, 0.888> <-4.510, -7.748, 0.888> <-6.129, -6.129, 0.888> 
		<0.000, -9.972, 0.000> <-2.289, -9.972, 0.000> <-5.431, -8.669, 0.000> <-7.050, -7.050, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -5.658, 3.000> <0.000, -5.037, 3.510> <0.000, -4.241, 4.284> <0.000, -3.877, 5.000> 
		<-1.299, -5.658, 3.000> <-1.299, -5.037, 3.510> <-0.890, -4.241, 4.284> <-0.890, -3.877, 5.000> 
		<-3.082, -4.919, 3.000> <-2.642, -4.479, 3.510> <-2.369, -3.628, 4.284> <-2.111, -3.370, 5.000> 
		<-4.000, -4.000, 3.000> <-3.561, -3.561, 3.510> <-2.998, -2.998, 4.284> <-2.741, -2.741, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.000, -4.000, 3.000> <-4.919, -3.082, 3.000> <-5.658, -1.299, 3.000> <-5.658, 0.000, 3.000> 
		<-4.862, -4.862, 2.000> <-5.780, -3.943, 2.000> <-6.876, -1.299, 2.000> <-6.876, 0.000, 2.000> 
		<-6.129, -6.129, 0.888> <-7.748, -4.510, 0.888> <-8.669, -2.289, 0.888> <-8.669, 0.000, 0.888> 
		<-7.050, -7.050, 0.000> <-8.669, -5.431, 0.000> <-9.972, -2.289, 0.000> <-9.972, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.000, -4.000, 3.000> <-3.561, -3.561, 3.510> <-2.998, -2.998, 4.284> <-2.741, -2.741, 5.000> 
		<-4.919, -3.082, 3.000> <-4.479, -2.642, 3.510> <-3.628, -2.369, 4.284> <-3.370, -2.111, 5.000> 
		<-5.658, -1.299, 3.000> <-5.037, -1.299, 3.510> <-4.241, -0.890, 4.284> <-3.877, -0.890, 5.000> 
		<-5.658, 0.000, 3.000> <-5.037, 0.000, 3.510> <-4.241, 0.000, 4.284> <-3.877, 0.000, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.658, 0.000, 3.000> <-5.658, 1.299, 3.000> <-4.919, 3.082, 3.000> <-4.000, 4.000, 3.000> 
		<-6.876, 0.000, 2.000> <-6.876, 1.299, 2.000> <-5.780, 3.943, 2.000> <-4.862, 4.862, 2.000> 
		<-8.669, 0.000, 0.888> <-8.669, 2.289, 0.888> <-7.748, 4.510, 0.888> <-6.129, 6.129, 0.888> 
		<-9.972, 0.000, 0.000> <-9.972, 2.289, 0.000> <-8.669, 5.431, 0.000> <-7.050, 7.050, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.658, 0.000, 3.000> <-5.037, 0.000, 3.510> <-4.241, 0.000, 4.284> <-3.877, 0.000, 5.000> 
		<-5.658, 1.299, 3.000> <-5.037, 1.299, 3.510> <-4.241, 0.890, 4.284> <-3.877, 0.890, 5.000> 
		<-4.919, 3.082, 3.000> <-4.479, 2.642, 3.510> <-3.628, 2.369, 4.284> <-3.370, 2.111, 5.000> 
		<-4.000, 4.000, 3.000> <-3.561, 3.561, 3.510> <-2.998, 2.998, 4.284> <-2.741, 2.741, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 3.877, 5.000> <-0.890, 3.877, 5.000> <-2.111, 3.370, 5.000> <-2.741, 2.741, 5.000> 
		<0.000, 3.455, 5.828> <-0.890, 3.455, 5.828> <-1.814, 3.072, 5.828> <-2.443, 2.443, 5.828> 
		<0.000, 3.300, 7.090> <-0.715, 3.300, 7.090> <-1.828, 2.839, 7.090> <-2.333, 2.333, 7.090> 
		<0.000, 3.113, 8.000> <-0.715, 3.113, 8.000> <-1.695, 2.706, 8.000> <-2.201, 2.201, 8.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 3.877, 5.000> <0.000, 3.455, 5.828> <0.000, 3.300, 7.090> <0.000, 3.113, 8.000> 
		<0.890, 3.877, 5.000> <0.890, 3.455, 5.828> <0.715, 3.300, 7.090> <0.715, 3.113, 8.000> 
		<2.111, 3.370, 5.000> <1.814, 3.072, 5.828> <1.828, 2.839, 7.090> <1.695, 2.706, 8.000> 
		<2.741, 2.741, 5.000> <2.443, 2.443, 5.828> <2.333, 2.333, 7.090> <2.201, 2.201, 8.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.741, 2.741, 5.000> <2.443, 2.443, 5.828> <2.333, 2.333, 7.090> <2.201, 2.201, 8.000> 
		<3.370, 2.111, 5.000> <3.072, 1.814, 5.828> <2.839, 1.828, 7.090> <2.706, 1.695, 8.000> 
		<3.877, 0.890, 5.000> <3.455, 0.890, 5.828> <3.300, 0.715, 7.090> <3.113, 0.715, 8.000> 
		<3.877, 0.000, 5.000> <3.455, 0.000, 5.828> <3.300, 0.000, 7.090> <3.113, 0.000, 8.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.877, 0.000, 5.000> <3.455, 0.000, 5.828> <3.300, 0.000, 7.090> <3.113, 0.000, 8.000> 
		<3.877, -0.890, 5.000> <3.455, -0.890, 5.828> <3.300, -0.715, 7.090> <3.113, -0.715, 8.000> 
		<3.370, -2.111, 5.000> <3.072, -1.814, 5.828> <2.839, -1.828, 7.090> <2.706, -1.695, 8.000> 
		<2.741, -2.741, 5.000> <2.443, -2.443, 5.828> <2.333, -2.333, 7.090> <2.201, -2.201, 8.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.741, -2.741, 5.000> <2.443, -2.443, 5.828> <2.333, -2.333, 7.090> <2.201, -2.201, 8.000> 
		<2.111, -3.370, 5.000> <1.814, -3.072, 5.828> <1.828, -2.839, 7.090> <1.695, -2.706, 8.000> 
		<0.890, -3.877, 5.000> <0.890, -3.455, 5.828> <0.715, -3.300, 7.090> <0.715, -3.113, 8.000> 
		<0.000, -3.877, 5.000> <0.000, -3.455, 5.828> <0.000, -3.300, 7.090> <0.000, -3.113, 8.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -3.877, 5.000> <0.000, -3.455, 5.828> <0.000, -3.300, 7.090> <0.000, -3.113, 8.000> 
		<-0.890, -3.877, 5.000> <-0.890, -3.455, 5.828> <-0.715, -3.300, 7.090> <-0.715, -3.113, 8.000> 
		<-2.111, -3.370, 5.000> <-1.814, -3.072, 5.828> <-1.828, -2.839, 7.090> <-1.695, -2.706, 8.000> 
		<-2.741, -2.741, 5.000> <-2.443, -2.443, 5.828> <-2.333, -2.333, 7.090> <-2.201, -2.201, 8.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.741, -2.741, 5.000> <-2.443, -2.443, 5.828> <-2.333, -2.333, 7.090> <-2.201, -2.201, 8.000> 
		<-3.370, -2.111, 5.000> <-3.072, -1.814, 5.828> <-2.839, -1.828, 7.090> <-2.706, -1.695, 8.000> 
		<-3.877, -0.890, 5.000> <-3.455, -0.890, 5.828> <-3.300, -0.715, 7.090> <-3.113, -0.715, 8.000> 
		<-3.877, 0.000, 5.000> <-3.455, 0.000, 5.828> <-3.300, 0.000, 7.090> <-3.113, 0.000, 8.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.877, 0.000, 5.000> <-3.455, 0.000, 5.828> <-3.300, 0.000, 7.090> <-3.113, 0.000, 8.000> 
		<-3.877, 0.890, 5.000> <-3.455, 0.890, 5.828> <-3.300, 0.715, 7.090> <-3.113, 0.715, 8.000> 
		<-3.370, 2.111, 5.000> <-3.072, 1.814, 5.828> <-2.839, 1.828, 7.090> <-2.706, 1.695, 8.000> 
		<-2.741, 2.741, 5.000> <-2.443, 2.443, 5.828> <-2.333, 2.333, 7.090> <-2.201, 2.201, 8.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 3.113, 8.000> <-0.715, 3.113, 8.000> <-1.695, 2.706, 8.000> <-2.201, 2.201, 8.000> 
		<0.000, 2.991, 8.593> <-0.715, 2.991, 8.593> <-1.609, 2.620, 8.593> <-2.114, 2.114, 8.593> 
		<0.000, 2.911, 9.398> <-0.654, 2.911, 9.398> <-1.596, 2.520, 9.398> <-2.058, 2.058, 9.398> 
		<0.000, 2.846, 10.000> <-0.654, 2.846, 10.000> <-1.550, 2.475, 10.000> <-2.012, 2.012, 10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 3.113, 8.000> <0.000, 2.991, 8.593> <0.000, 2.911, 9.398> <0.000, 2.846, 10.000> 
		<0.715, 3.113, 8.000> <0.715, 2.991, 8.593> <0.654, 2.911, 9.398> <0.654, 2.846, 10.000> 
		<1.695, 2.706, 8.000> <1.609, 2.620, 8.593> <1.596, 2.520, 9.398> <1.550, 2.475, 10.000> 
		<2.201, 2.201, 8.000> <2.114, 2.114, 8.593> <2.058, 2.058, 9.398> <2.012, 2.012, 10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.201, 2.201, 8.000> <2.114, 2.114, 8.593> <2.058, 2.058, 9.398> <2.012, 2.012, 10.000> 
		<2.706, 1.695, 8.000> <2.620, 1.609, 8.593> <2.520, 1.596, 9.398> <2.475, 1.550, 10.000> 
		<3.113, 0.715, 8.000> <2.991, 0.715, 8.593> <2.911, 0.654, 9.398> <2.846, 0.654, 10.000> 
		<3.113, 0.000, 8.000> <2.991, 0.000, 8.593> <2.911, 0.000, 9.398> <2.846, 0.000, 10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.113, 0.000, 8.000> <2.991, 0.000, 8.593> <2.911, 0.000, 9.398> <2.846, 0.000, 10.000> 
		<3.113, -0.715, 8.000> <2.991, -0.715, 8.593> <2.911, -0.654, 9.398> <2.846, -0.654, 10.000> 
		<2.706, -1.695, 8.000> <2.620, -1.609, 8.593> <2.520, -1.596, 9.398> <2.475, -1.550, 10.000> 
		<2.201, -2.201, 8.000> <2.114, -2.114, 8.593> <2.058, -2.058, 9.398> <2.012, -2.012, 10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.201, -2.201, 8.000> <2.114, -2.114, 8.593> <2.058, -2.058, 9.398> <2.012, -2.012, 10.000> 
		<1.695, -2.706, 8.000> <1.609, -2.620, 8.593> <1.596, -2.520, 9.398> <1.550, -2.475, 10.000> 
		<0.715, -3.113, 8.000> <0.715, -2.991, 8.593> <0.654, -2.911, 9.398> <0.654, -2.846, 10.000> 
		<0.000, -3.113, 8.000> <0.000, -2.991, 8.593> <0.000, -2.911, 9.398> <0.000, -2.846, 10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -3.113, 8.000> <0.000, -2.991, 8.593> <0.000, -2.911, 9.398> <0.000, -2.846, 10.000> 
		<-0.715, -3.113, 8.000> <-0.715, -2.991, 8.593> <-0.654, -2.911, 9.398> <-0.654, -2.846, 10.000> 
		<-1.695, -2.706, 8.000> <-1.609, -2.620, 8.593> <-1.596, -2.520, 9.398> <-1.550, -2.475, 10.000> 
		<-2.201, -2.201, 8.000> <-2.114, -2.114, 8.593> <-2.058, -2.058, 9.398> <-2.012, -2.012, 10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.201, -2.201, 8.000> <-2.114, -2.114, 8.593> <-2.058, -2.058, 9.398> <-2.012, -2.012, 10.000> 
		<-2.706, -1.695, 8.000> <-2.620, -1.609, 8.593> <-2.520, -1.596, 9.398> <-2.475, -1.550, 10.000> 
		<-3.113, -0.715, 8.000> <-2.991, -0.715, 8.593> <-2.911, -0.654, 9.398> <-2.846, -0.654, 10.000> 
		<-3.113, 0.000, 8.000> <-2.991, 0.000, 8.593> <-2.911, 0.000, 9.398> <-2.846, 0.000, 10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.113, 0.000, 8.000> <-2.991, 0.000, 8.593> <-2.911, 0.000, 9.398> <-2.846, 0.000, 10.000> 
		<-3.113, 0.715, 8.000> <-2.991, 0.715, 8.593> <-2.911, 0.654, 9.398> <-2.846, 0.654, 10.000> 
		<-2.706, 1.695, 8.000> <-2.620, 1.609, 8.593> <-2.520, 1.596, 9.398> <-2.475, 1.550, 10.000> 
		<-2.201, 2.201, 8.000> <-2.114, 2.114, 8.593> <-2.058, 2.058, 9.398> <-2.012, 2.012, 10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.846, 10.000> <-0.654, 2.846, 10.000> <-1.550, 2.475, 10.000> <-2.012, 2.012, 10.000> 
		<0.000, 2.750, 10.898> <-0.654, 2.750, 10.898> <-1.482, 2.406, 10.898> <-1.944, 1.944, 10.898> 
		<0.000, 2.648, 12.099> <-0.591, 2.648, 12.099> <-1.454, 2.290, 12.099> <-1.872, 1.872, 12.099> 
		<0.000, 2.575, 13.000> <-0.591, 2.575, 13.000> <-1.402, 2.238, 13.000> <-1.820, 1.820, 13.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.846, 10.000> <0.000, 2.750, 10.898> <0.000, 2.648, 12.099> <0.000, 2.575, 13.000> 
		<0.654, 2.846, 10.000> <0.654, 2.750, 10.898> <0.591, 2.648, 12.099> <0.591, 2.575, 13.000> 
		<1.550, 2.475, 10.000> <1.482, 2.406, 10.898> <1.454, 2.290, 12.099> <1.402, 2.238, 13.000> 
		<2.012, 2.012, 10.000> <1.944, 1.944, 10.898> <1.872, 1.872, 12.099> <1.820, 1.820, 13.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.012, 2.012, 10.000> <1.944, 1.944, 10.898> <1.872, 1.872, 12.099> <1.820, 1.820, 13.000> 
		<2.475, 1.550, 10.000> <2.406, 1.482, 10.898> <2.290, 1.454, 12.099> <2.238, 1.402, 13.000> 
		<2.846, 0.654, 10.000> <2.750, 0.654, 10.898> <2.648, 0.591, 12.099> <2.575, 0.591, 13.000> 
		<2.846, 0.000, 10.000> <2.750, 0.000, 10.898> <2.648, 0.000, 12.099> <2.575, 0.000, 13.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.846, 0.000, 10.000> <2.750, 0.000, 10.898> <2.648, 0.000, 12.099> <2.575, 0.000, 13.000> 
		<2.846, -0.654, 10.000> <2.750, -0.654, 10.898> <2.648, -0.591, 12.099> <2.575, -0.591, 13.000> 
		<2.475, -1.550, 10.000> <2.406, -1.482, 10.898> <2.290, -1.454, 12.099> <2.238, -1.402, 13.000> 
		<2.012, -2.012, 10.000> <1.944, -1.944, 10.898> <1.872, -1.872, 12.099> <1.820, -1.820, 13.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.012, -2.012, 10.000> <1.944, -1.944, 10.898> <1.872, -1.872, 12.099> <1.820, -1.820, 13.000> 
		<1.550, -2.475, 10.000> <1.482, -2.406, 10.898> <1.454, -2.290, 12.099> <1.402, -2.238, 13.000> 
		<0.654, -2.846, 10.000> <0.654, -2.750, 10.898> <0.591, -2.648, 12.099> <0.591, -2.575, 13.000> 
		<0.000, -2.846, 10.000> <0.000, -2.750, 10.898> <0.000, -2.648, 12.099> <0.000, -2.575, 13.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -2.846, 10.000> <0.000, -2.750, 10.898> <0.000, -2.648, 12.099> <0.000, -2.575, 13.000> 
		<-0.654, -2.846, 10.000> <-0.654, -2.750, 10.898> <-0.591, -2.648, 12.099> <-0.591, -2.575, 13.000> 
		<-1.550, -2.475, 10.000> <-1.482, -2.406, 10.898> <-1.454, -2.290, 12.099> <-1.402, -2.238, 13.000> 
		<-2.012, -2.012, 10.000> <-1.944, -1.944, 10.898> <-1.872, -1.872, 12.099> <-1.820, -1.820, 13.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.012, -2.012, 10.000> <-1.944, -1.944, 10.898> <-1.872, -1.872, 12.099> <-1.820, -1.820, 13.000> 
		<-2.475, -1.550, 10.000> <-2.406, -1.482, 10.898> <-2.290, -1.454, 12.099> <-2.238, -1.402, 13.000> 
		<-2.846, -0.654, 10.000> <-2.750, -0.654, 10.898> <-2.648, -0.591, 12.099> <-2.575, -0.591, 13.000> 
		<-2.846, 0.000, 10.000> <-2.750, 0.000, 10.898> <-2.648, 0.000, 12.099> <-2.575, 0.000, 13.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.846, 0.000, 10.000> <-2.750, 0.000, 10.898> <-2.648, 0.000, 12.099> <-2.575, 0.000, 13.000> 
		<-2.846, 0.654, 10.000> <-2.750, 0.654, 10.898> <-2.648, 0.591, 12.099> <-2.575, 0.591, 13.000> 
		<-2.475, 1.550, 10.000> <-2.406, 1.482, 10.898> <-2.290, 1.454, 12.099> <-2.238, 1.402, 13.000> 
		<-2.012, 2.012, 10.000> <-1.944, 1.944, 10.898> <-1.872, 1.872, 12.099> <-1.820, 1.820, 13.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.575, 13.000> <-0.591, 2.575, 13.000> <-1.402, 2.238, 13.000> <-1.820, 1.820, 13.000> 
		<0.000, 2.502, 13.899> <-0.591, 2.502, 13.899> <-1.351, 2.187, 13.899> <-1.769, 1.769, 13.899> 
		<0.000, 2.432, 15.101> <-0.542, 2.432, 15.101> <-1.336, 2.102, 15.101> <-1.719, 1.719, 15.101> 
		<0.000, 2.360, 16.000> <-0.542, 2.360, 16.000> <-1.285, 2.052, 16.000> <-1.669, 1.669, 16.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.575, 13.000> <0.000, 2.502, 13.899> <0.000, 2.432, 15.101> <0.000, 2.360, 16.000> 
		<0.591, 2.575, 13.000> <0.591, 2.502, 13.899> <0.542, 2.432, 15.101> <0.542, 2.360, 16.000> 
		<1.402, 2.238, 13.000> <1.351, 2.187, 13.899> <1.336, 2.102, 15.101> <1.285, 2.052, 16.000> 
		<1.820, 1.820, 13.000> <1.769, 1.769, 13.899> <1.719, 1.719, 15.101> <1.669, 1.669, 16.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.820, 1.820, 13.000> <1.769, 1.769, 13.899> <1.719, 1.719, 15.101> <1.669, 1.669, 16.000> 
		<2.238, 1.402, 13.000> <2.187, 1.351, 13.899> <2.102, 1.336, 15.101> <2.052, 1.285, 16.000> 
		<2.575, 0.591, 13.000> <2.502, 0.591, 13.899> <2.432, 0.542, 15.101> <2.360, 0.542, 16.000> 
		<2.575, 0.000, 13.000> <2.502, 0.000, 13.899> <2.432, 0.000, 15.101> <2.360, 0.000, 16.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.575, 0.000, 13.000> <2.502, 0.000, 13.899> <2.432, 0.000, 15.101> <2.360, 0.000, 16.000> 
		<2.575, -0.591, 13.000> <2.502, -0.591, 13.899> <2.432, -0.542, 15.101> <2.360, -0.542, 16.000> 
		<2.238, -1.402, 13.000> <2.187, -1.351, 13.899> <2.102, -1.336, 15.101> <2.052, -1.285, 16.000> 
		<1.820, -1.820, 13.000> <1.769, -1.769, 13.899> <1.719, -1.719, 15.101> <1.669, -1.669, 16.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.820, -1.820, 13.000> <1.769, -1.769, 13.899> <1.719, -1.719, 15.101> <1.669, -1.669, 16.000> 
		<1.402, -2.238, 13.000> <1.351, -2.187, 13.899> <1.336, -2.102, 15.101> <1.285, -2.052, 16.000> 
		<0.591, -2.575, 13.000> <0.591, -2.502, 13.899> <0.542, -2.432, 15.101> <0.542, -2.360, 16.000> 
		<0.000, -2.575, 13.000> <0.000, -2.502, 13.899> <0.000, -2.432, 15.101> <0.000, -2.360, 16.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -2.575, 13.000> <0.000, -2.502, 13.899> <0.000, -2.432, 15.101> <0.000, -2.360, 16.000> 
		<-0.591, -2.575, 13.000> <-0.591, -2.502, 13.899> <-0.542, -2.432, 15.101> <-0.542, -2.360, 16.000> 
		<-1.402, -2.238, 13.000> <-1.351, -2.187, 13.899> <-1.336, -2.102, 15.101> <-1.285, -2.052, 16.000> 
		<-1.820, -1.820, 13.000> <-1.769, -1.769, 13.899> <-1.719, -1.719, 15.101> <-1.669, -1.669, 16.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.820, -1.820, 13.000> <-1.769, -1.769, 13.899> <-1.719, -1.719, 15.101> <-1.669, -1.669, 16.000> 
		<-2.238, -1.402, 13.000> <-2.187, -1.351, 13.899> <-2.102, -1.336, 15.101> <-2.052, -1.285, 16.000> 
		<-2.575, -0.591, 13.000> <-2.502, -0.591, 13.899> <-2.432, -0.542, 15.101> <-2.360, -0.542, 16.000> 
		<-2.575, 0.000, 13.000> <-2.502, 0.000, 13.899> <-2.432, 0.000, 15.101> <-2.360, 0.000, 16.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.575, 0.000, 13.000> <-2.502, 0.000, 13.899> <-2.432, 0.000, 15.101> <-2.360, 0.000, 16.000> 
		<-2.575, 0.591, 13.000> <-2.502, 0.591, 13.899> <-2.432, 0.542, 15.101> <-2.360, 0.542, 16.000> 
		<-2.238, 1.402, 13.000> <-2.187, 1.351, 13.899> <-2.102, 1.336, 15.101> <-2.052, 1.285, 16.000> 
		<-1.820, 1.820, 13.000> <-1.769, 1.769, 13.899> <-1.719, 1.719, 15.101> <-1.669, 1.669, 16.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.360, 16.000> <-0.542, 2.360, 16.000> <-1.285, 2.052, 16.000> <-1.669, 1.669, 16.000> 
		<0.000, 2.312, 16.601> <-0.542, 2.312, 16.601> <-1.252, 2.018, 16.601> <-1.635, 1.635, 16.601> 
		<0.000, 2.226, 17.400> <-0.500, 2.226, 17.400> <-1.221, 1.927, 17.400> <-1.574, 1.574, 17.400> 
		<0.000, 2.176, 18.000> <-0.500, 2.176, 18.000> <-1.185, 1.892, 18.000> <-1.539, 1.539, 18.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.360, 16.000> <0.000, 2.312, 16.601> <0.000, 2.226, 17.400> <0.000, 2.176, 18.000> 
		<0.542, 2.360, 16.000> <0.542, 2.312, 16.601> <0.500, 2.226, 17.400> <0.500, 2.176, 18.000> 
		<1.285, 2.052, 16.000> <1.252, 2.018, 16.601> <1.221, 1.927, 17.400> <1.185, 1.892, 18.000> 
		<1.669, 1.669, 16.000> <1.635, 1.635, 16.601> <1.574, 1.574, 17.400> <1.539, 1.539, 18.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.669, 1.669, 16.000> <1.635, 1.635, 16.601> <1.574, 1.574, 17.400> <1.539, 1.539, 18.000> 
		<2.052, 1.285, 16.000> <2.018, 1.252, 16.601> <1.927, 1.221, 17.400> <1.892, 1.185, 18.000> 
		<2.360, 0.542, 16.000> <2.312, 0.542, 16.601> <2.226, 0.500, 17.400> <2.176, 0.500, 18.000> 
		<2.360, 0.000, 16.000> <2.312, 0.000, 16.601> <2.226, 0.000, 17.400> <2.176, 0.000, 18.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.360, 0.000, 16.000> <2.312, 0.000, 16.601> <2.226, 0.000, 17.400> <2.176, 0.000, 18.000> 
		<2.360, -0.542, 16.000> <2.312, -0.542, 16.601> <2.226, -0.500, 17.400> <2.176, -0.500, 18.000> 
		<2.052, -1.285, 16.000> <2.018, -1.252, 16.601> <1.927, -1.221, 17.400> <1.892, -1.185, 18.000> 
		<1.669, -1.669, 16.000> <1.635, -1.635, 16.601> <1.574, -1.574, 17.400> <1.539, -1.539, 18.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.669, -1.669, 16.000> <1.635, -1.635, 16.601> <1.574, -1.574, 17.400> <1.539, -1.539, 18.000> 
		<1.285, -2.052, 16.000> <1.252, -2.018, 16.601> <1.221, -1.927, 17.400> <1.185, -1.892, 18.000> 
		<0.542, -2.360, 16.000> <0.542, -2.312, 16.601> <0.500, -2.226, 17.400> <0.500, -2.176, 18.000> 
		<0.000, -2.360, 16.000> <0.000, -2.312, 16.601> <0.000, -2.226, 17.400> <0.000, -2.176, 18.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -2.360, 16.000> <0.000, -2.312, 16.601> <0.000, -2.226, 17.400> <0.000, -2.176, 18.000> 
		<-0.542, -2.360, 16.000> <-0.542, -2.312, 16.601> <-0.500, -2.226, 17.400> <-0.500, -2.176, 18.000> 
		<-1.285, -2.052, 16.000> <-1.252, -2.018, 16.601> <-1.221, -1.927, 17.400> <-1.185, -1.892, 18.000> 
		<-1.669, -1.669, 16.000> <-1.635, -1.635, 16.601> <-1.574, -1.574, 17.400> <-1.539, -1.539, 18.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.669, -1.669, 16.000> <-1.635, -1.635, 16.601> <-1.574, -1.574, 17.400> <-1.539, -1.539, 18.000> 
		<-2.052, -1.285, 16.000> <-2.018, -1.252, 16.601> <-1.927, -1.221, 17.400> <-1.892, -1.185, 18.000> 
		<-2.360, -0.542, 16.000> <-2.312, -0.542, 16.601> <-2.226, -0.500, 17.400> <-2.176, -0.500, 18.000> 
		<-2.360, 0.000, 16.000> <-2.312, 0.000, 16.601> <-2.226, 0.000, 17.400> <-2.176, 0.000, 18.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.360, 0.000, 16.000> <-2.312, 0.000, 16.601> <-2.226, 0.000, 17.400> <-2.176, 0.000, 18.000> 
		<-2.360, 0.542, 16.000> <-2.312, 0.542, 16.601> <-2.226, 0.500, 17.400> <-2.176, 0.500, 18.000> 
		<-2.052, 1.285, 16.000> <-2.018, 1.252, 16.601> <-1.927, 1.221, 17.400> <-1.892, 1.185, 18.000> 
		<-1.669, 1.669, 16.000> <-1.635, 1.635, 16.601> <-1.574, 1.574, 17.400> <-1.539, 1.539, 18.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.176, 18.000> <-0.500, 2.176, 18.000> <-1.185, 1.892, 18.000> <-1.539, 1.539, 18.000> 
		<0.000, 2.126, 18.600> <-0.500, 2.126, 18.600> <-1.150, 1.857, 18.600> <-1.503, 1.503, 18.600> 
		<0.000, 2.065, 19.400> <-0.465, 2.065, 19.400> <-1.131, 1.789, 19.400> <-1.460, 1.460, 19.400> 
		<0.000, 2.026, 20.000> <-0.465, 2.026, 20.000> <-1.104, 1.762, 20.000> <-1.433, 1.433, 20.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.176, 18.000> <0.000, 2.126, 18.600> <0.000, 2.065, 19.400> <0.000, 2.026, 20.000> 
		<0.500, 2.176, 18.000> <0.500, 2.126, 18.600> <0.465, 2.065, 19.400> <0.465, 2.026, 20.000> 
		<1.185, 1.892, 18.000> <1.150, 1.857, 18.600> <1.131, 1.789, 19.400> <1.104, 1.762, 20.000> 
		<1.539, 1.539, 18.000> <1.503, 1.503, 18.600> <1.460, 1.460, 19.400> <1.433, 1.433, 20.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.539, 1.539, 18.000> <1.503, 1.503, 18.600> <1.460, 1.460, 19.400> <1.433, 1.433, 20.000> 
		<1.892, 1.185, 18.000> <1.857, 1.150, 18.600> <1.789, 1.131, 19.400> <1.762, 1.104, 20.000> 
		<2.176, 0.500, 18.000> <2.126, 0.500, 18.600> <2.065, 0.465, 19.400> <2.026, 0.465, 20.000> 
		<2.176, 0.000, 18.000> <2.126, 0.000, 18.600> <2.065, 0.000, 19.400> <2.026, 0.000, 20.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.176, 0.000, 18.000> <2.126, 0.000, 18.600> <2.065, 0.000, 19.400> <2.026, 0.000, 20.000> 
		<2.176, -0.500, 18.000> <2.126, -0.500, 18.600> <2.065, -0.465, 19.400> <2.026, -0.465, 20.000> 
		<1.892, -1.185, 18.000> <1.857, -1.150, 18.600> <1.789, -1.131, 19.400> <1.762, -1.104, 20.000> 
		<1.539, -1.539, 18.000> <1.503, -1.503, 18.600> <1.460, -1.460, 19.400> <1.433, -1.433, 20.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.539, -1.539, 18.000> <1.503, -1.503, 18.600> <1.460, -1.460, 19.400> <1.433, -1.433, 20.000> 
		<1.185, -1.892, 18.000> <1.150, -1.857, 18.600> <1.131, -1.789, 19.400> <1.104, -1.762, 20.000> 
		<0.500, -2.176, 18.000> <0.500, -2.126, 18.600> <0.465, -2.065, 19.400> <0.465, -2.026, 20.000> 
		<0.000, -2.176, 18.000> <0.000, -2.126, 18.600> <0.000, -2.065, 19.400> <0.000, -2.026, 20.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -2.176, 18.000> <0.000, -2.126, 18.600> <0.000, -2.065, 19.400> <0.000, -2.026, 20.000> 
		<-0.500, -2.176, 18.000> <-0.500, -2.126, 18.600> <-0.465, -2.065, 19.400> <-0.465, -2.026, 20.000> 
		<-1.185, -1.892, 18.000> <-1.150, -1.857, 18.600> <-1.131, -1.789, 19.400> <-1.104, -1.762, 20.000> 
		<-1.539, -1.539, 18.000> <-1.503, -1.503, 18.600> <-1.460, -1.460, 19.400> <-1.433, -1.433, 20.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.539, -1.539, 18.000> <-1.503, -1.503, 18.600> <-1.460, -1.460, 19.400> <-1.433, -1.433, 20.000> 
		<-1.892, -1.185, 18.000> <-1.857, -1.150, 18.600> <-1.789, -1.131, 19.400> <-1.762, -1.104, 20.000> 
		<-2.176, -0.500, 18.000> <-2.126, -0.500, 18.600> <-2.065, -0.465, 19.400> <-2.026, -0.465, 20.000> 
		<-2.176, 0.000, 18.000> <-2.126, 0.000, 18.600> <-2.065, 0.000, 19.400> <-2.026, 0.000, 20.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.176, 0.000, 18.000> <-2.126, 0.000, 18.600> <-2.065, 0.000, 19.400> <-2.026, 0.000, 20.000> 
		<-2.176, 0.500, 18.000> <-2.126, 0.500, 18.600> <-2.065, 0.465, 19.400> <-2.026, 0.465, 20.000> 
		<-1.892, 1.185, 18.000> <-1.857, 1.150, 18.600> <-1.789, 1.131, 19.400> <-1.762, 1.104, 20.000> 
		<-1.539, 1.539, 18.000> <-1.503, 1.503, 18.600> <-1.460, 1.460, 19.400> <-1.433, 1.433, 20.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.026, 20.000> <-0.465, 2.026, 20.000> <-1.104, 1.762, 20.000> <-1.433, 1.433, 20.000> 
		<0.000, 1.912, 21.800> <-0.465, 1.912, 21.800> <-1.023, 1.680, 21.800> <-1.351, 1.351, 21.800> 
		<0.000, 1.769, 24.200> <-0.382, 1.769, 24.200> <-0.981, 1.521, 24.200> <-1.251, 1.251, 24.200> 
		<0.000, 1.666, 26.000> <-0.382, 1.666, 26.000> <-0.907, 1.448, 26.000> <-1.178, 1.178, 26.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.026, 20.000> <0.000, 1.912, 21.800> <0.000, 1.769, 24.200> <0.000, 1.666, 26.000> 
		<0.465, 2.026, 20.000> <0.465, 1.912, 21.800> <0.382, 1.769, 24.200> <0.382, 1.666, 26.000> 
		<1.104, 1.762, 20.000> <1.023, 1.680, 21.800> <0.981, 1.521, 24.200> <0.907, 1.448, 26.000> 
		<1.433, 1.433, 20.000> <1.351, 1.351, 21.800> <1.251, 1.251, 24.200> <1.178, 1.178, 26.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.433, 1.433, 20.000> <1.351, 1.351, 21.800> <1.251, 1.251, 24.200> <1.178, 1.178, 26.000> 
		<1.762, 1.104, 20.000> <1.680, 1.023, 21.800> <1.521, 0.981, 24.200> <1.448, 0.907, 26.000> 
		<2.026, 0.465, 20.000> <1.912, 0.465, 21.800> <1.769, 0.382, 24.200> <1.666, 0.382, 26.000> 
		<2.026, 0.000, 20.000> <1.912, 0.000, 21.800> <1.769, 0.000, 24.200> <1.666, 0.000, 26.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.026, 0.000, 20.000> <1.912, 0.000, 21.800> <1.769, 0.000, 24.200> <1.666, 0.000, 26.000> 
		<2.026, -0.465, 20.000> <1.912, -0.465, 21.800> <1.769, -0.382, 24.200> <1.666, -0.382, 26.000> 
		<1.762, -1.104, 20.000> <1.680, -1.023, 21.800> <1.521, -0.981, 24.200> <1.448, -0.907, 26.000> 
		<1.433, -1.433, 20.000> <1.351, -1.351, 21.800> <1.251, -1.251, 24.200> <1.178, -1.178, 26.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.433, -1.433, 20.000> <1.351, -1.351, 21.800> <1.251, -1.251, 24.200> <1.178, -1.178, 26.000> 
		<1.104, -1.762, 20.000> <1.023, -1.680, 21.800> <0.981, -1.521, 24.200> <0.907, -1.448, 26.000> 
		<0.465, -2.026, 20.000> <0.465, -1.912, 21.800> <0.382, -1.769, 24.200> <0.382, -1.666, 26.000> 
		<0.000, -2.026, 20.000> <0.000, -1.912, 21.800> <0.000, -1.769, 24.200> <0.000, -1.666, 26.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -2.026, 20.000> <0.000, -1.912, 21.800> <0.000, -1.769, 24.200> <0.000, -1.666, 26.000> 
		<-0.465, -2.026, 20.000> <-0.465, -1.912, 21.800> <-0.382, -1.769, 24.200> <-0.382, -1.666, 26.000> 
		<-1.104, -1.762, 20.000> <-1.023, -1.680, 21.800> <-0.981, -1.521, 24.200> <-0.907, -1.448, 26.000> 
		<-1.433, -1.433, 20.000> <-1.351, -1.351, 21.800> <-1.251, -1.251, 24.200> <-1.178, -1.178, 26.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.433, -1.433, 20.000> <-1.351, -1.351, 21.800> <-1.251, -1.251, 24.200> <-1.178, -1.178, 26.000> 
		<-1.762, -1.104, 20.000> <-1.680, -1.023, 21.800> <-1.521, -0.981, 24.200> <-1.448, -0.907, 26.000> 
		<-2.026, -0.465, 20.000> <-1.912, -0.465, 21.800> <-1.769, -0.382, 24.200> <-1.666, -0.382, 26.000> 
		<-2.026, 0.000, 20.000> <-1.912, 0.000, 21.800> <-1.769, 0.000, 24.200> <-1.666, 0.000, 26.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.026, 0.000, 20.000> <-1.912, 0.000, 21.800> <-1.769, 0.000, 24.200> <-1.666, 0.000, 26.000> 
		<-2.026, 0.465, 20.000> <-1.912, 0.465, 21.800> <-1.769, 0.382, 24.200> <-1.666, 0.382, 26.000> 
		<-1.762, 1.104, 20.000> <-1.680, 1.023, 21.800> <-1.521, 0.981, 24.200> <-1.448, 0.907, 26.000> 
		<-1.433, 1.433, 20.000> <-1.351, 1.351, 21.800> <-1.251, 1.251, 24.200> <-1.178, 1.178, 26.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.666, 26.000> <-0.382, 1.666, 26.000> <-0.907, 1.448, 26.000> <-1.178, 1.178, 26.000> 
		<0.000, 1.597, 27.200> <-0.382, 1.597, 27.200> <-0.858, 1.399, 27.200> <-1.129, 1.129, 27.200> 
		<0.000, 1.479, 28.799> <-0.333, 1.479, 28.799> <-0.810, 1.281, 28.799> <-1.046, 1.046, 28.799> 
		<0.000, 1.451, 30.000> <-0.333, 1.451, 30.000> <-0.790, 1.261, 30.000> <-1.026, 1.026, 30.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.666, 26.000> <0.000, 1.597, 27.200> <0.000, 1.479, 28.799> <0.000, 1.451, 30.000> 
		<0.382, 1.666, 26.000> <0.382, 1.597, 27.200> <0.333, 1.479, 28.799> <0.333, 1.451, 30.000> 
		<0.907, 1.448, 26.000> <0.858, 1.399, 27.200> <0.810, 1.281, 28.799> <0.790, 1.261, 30.000> 
		<1.178, 1.178, 26.000> <1.129, 1.129, 27.200> <1.046, 1.046, 28.799> <1.026, 1.026, 30.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.178, 1.178, 26.000> <1.129, 1.129, 27.200> <1.046, 1.046, 28.799> <1.026, 1.026, 30.000> 
		<1.448, 0.907, 26.000> <1.399, 0.858, 27.200> <1.281, 0.810, 28.799> <1.261, 0.790, 30.000> 
		<1.666, 0.382, 26.000> <1.597, 0.382, 27.200> <1.479, 0.333, 28.799> <1.451, 0.333, 30.000> 
		<1.666, 0.000, 26.000> <1.597, 0.000, 27.200> <1.479, 0.000, 28.799> <1.451, 0.000, 30.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.666, 0.000, 26.000> <1.597, 0.000, 27.200> <1.479, 0.000, 28.799> <1.451, 0.000, 30.000> 
		<1.666, -0.382, 26.000> <1.597, -0.382, 27.200> <1.479, -0.333, 28.799> <1.451, -0.333, 30.000> 
		<1.448, -0.907, 26.000> <1.399, -0.858, 27.200> <1.281, -0.810, 28.799> <1.261, -0.790, 30.000> 
		<1.178, -1.178, 26.000> <1.129, -1.129, 27.200> <1.046, -1.046, 28.799> <1.026, -1.026, 30.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.178, -1.178, 26.000> <1.129, -1.129, 27.200> <1.046, -1.046, 28.799> <1.026, -1.026, 30.000> 
		<0.907, -1.448, 26.000> <0.858, -1.399, 27.200> <0.810, -1.281, 28.799> <0.790, -1.261, 30.000> 
		<0.382, -1.666, 26.000> <0.382, -1.597, 27.200> <0.333, -1.479, 28.799> <0.333, -1.451, 30.000> 
		<0.000, -1.666, 26.000> <0.000, -1.597, 27.200> <0.000, -1.479, 28.799> <0.000, -1.451, 30.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -1.666, 26.000> <0.000, -1.597, 27.200> <0.000, -1.479, 28.799> <0.000, -1.451, 30.000> 
		<-0.382, -1.666, 26.000> <-0.382, -1.597, 27.200> <-0.333, -1.479, 28.799> <-0.333, -1.451, 30.000> 
		<-0.907, -1.448, 26.000> <-0.858, -1.399, 27.200> <-0.810, -1.281, 28.799> <-0.790, -1.261, 30.000> 
		<-1.178, -1.178, 26.000> <-1.129, -1.129, 27.200> <-1.046, -1.046, 28.799> <-1.026, -1.026, 30.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.178, -1.178, 26.000> <-1.129, -1.129, 27.200> <-1.046, -1.046, 28.799> <-1.026, -1.026, 30.000> 
		<-1.448, -0.907, 26.000> <-1.399, -0.858, 27.200> <-1.281, -0.810, 28.799> <-1.261, -0.790, 30.000> 
		<-1.666, -0.382, 26.000> <-1.597, -0.382, 27.200> <-1.479, -0.333, 28.799> <-1.451, -0.333, 30.000> 
		<-1.666, 0.000, 26.000> <-1.597, 0.000, 27.200> <-1.479, 0.000, 28.799> <-1.451, 0.000, 30.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.666, 0.000, 26.000> <-1.597, 0.000, 27.200> <-1.479, 0.000, 28.799> <-1.451, 0.000, 30.000> 
		<-1.666, 0.382, 26.000> <-1.597, 0.382, 27.200> <-1.479, 0.333, 28.799> <-1.451, 0.333, 30.000> 
		<-1.448, 0.907, 26.000> <-1.399, 0.858, 27.200> <-1.281, 0.810, 28.799> <-1.261, 0.790, 30.000> 
		<-1.178, 1.178, 26.000> <-1.129, 1.129, 27.200> <-1.046, 1.046, 28.799> <-1.026, 1.026, 30.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.451, 30.000> <-0.333, 1.451, 30.000> <-0.790, 1.261, 30.000> <-1.026, 1.026, 30.000> 
		<0.000, 1.318, 35.699> <-0.333, 1.318, 35.699> <-0.696, 1.167, 35.699> <-0.932, 0.932, 35.699> 
		<0.000, 1.217, 43.300> <-0.259, 1.217, 43.300> <-0.677, 1.044, 43.300> <-0.860, 0.860, 43.300> 
		<0.000, 1.129, 49.000> <-0.259, 1.129, 49.000> <-0.615, 0.981, 49.000> <-0.798, 0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.451, 30.000> <0.000, 1.318, 35.699> <0.000, 1.217, 43.300> <0.000, 1.129, 49.000> 
		<0.333, 1.451, 30.000> <0.333, 1.318, 35.699> <0.259, 1.217, 43.300> <0.259, 1.129, 49.000> 
		<0.790, 1.261, 30.000> <0.696, 1.167, 35.699> <0.677, 1.044, 43.300> <0.615, 0.981, 49.000> 
		<1.026, 1.026, 30.000> <0.932, 0.932, 35.699> <0.860, 0.860, 43.300> <0.798, 0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.026, 1.026, 30.000> <0.932, 0.932, 35.699> <0.860, 0.860, 43.300> <0.798, 0.798, 49.000> 
		<1.261, 0.790, 30.000> <1.167, 0.696, 35.699> <1.044, 0.677, 43.300> <0.981, 0.615, 49.000> 
		<1.451, 0.333, 30.000> <1.318, 0.333, 35.699> <1.217, 0.259, 43.300> <1.129, 0.259, 49.000> 
		<1.451, 0.000, 30.000> <1.318, 0.000, 35.699> <1.217, 0.000, 43.300> <1.129, 0.000, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.451, 0.000, 30.000> <1.318, 0.000, 35.699> <1.217, 0.000, 43.300> <1.129, 0.000, 49.000> 
		<1.451, -0.333, 30.000> <1.318, -0.333, 35.699> <1.217, -0.259, 43.300> <1.129, -0.259, 49.000> 
		<1.261, -0.790, 30.000> <1.167, -0.696, 35.699> <1.044, -0.677, 43.300> <0.981, -0.615, 49.000> 
		<1.026, -1.026, 30.000> <0.932, -0.932, 35.699> <0.860, -0.860, 43.300> <0.798, -0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.026, -1.026, 30.000> <0.932, -0.932, 35.699> <0.860, -0.860, 43.300> <0.798, -0.798, 49.000> 
		<0.790, -1.261, 30.000> <0.696, -1.167, 35.699> <0.677, -1.044, 43.300> <0.615, -0.981, 49.000> 
		<0.333, -1.451, 30.000> <0.333, -1.318, 35.699> <0.259, -1.217, 43.300> <0.259, -1.129, 49.000> 
		<0.000, -1.451, 30.000> <0.000, -1.318, 35.699> <0.000, -1.217, 43.300> <0.000, -1.129, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -1.451, 30.000> <0.000, -1.318, 35.699> <0.000, -1.217, 43.300> <0.000, -1.129, 49.000> 
		<-0.333, -1.451, 30.000> <-0.333, -1.318, 35.699> <-0.259, -1.217, 43.300> <-0.259, -1.129, 49.000> 
		<-0.790, -1.261, 30.000> <-0.696, -1.167, 35.699> <-0.677, -1.044, 43.300> <-0.615, -0.981, 49.000> 
		<-1.026, -1.026, 30.000> <-0.932, -0.932, 35.699> <-0.860, -0.860, 43.300> <-0.798, -0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.026, -1.026, 30.000> <-0.932, -0.932, 35.699> <-0.860, -0.860, 43.300> <-0.798, -0.798, 49.000> 
		<-1.261, -0.790, 30.000> <-1.167, -0.696, 35.699> <-1.044, -0.677, 43.300> <-0.981, -0.615, 49.000> 
		<-1.451, -0.333, 30.000> <-1.318, -0.333, 35.699> <-1.217, -0.259, 43.300> <-1.129, -0.259, 49.000> 
		<-1.451, 0.000, 30.000> <-1.318, 0.000, 35.699> <-1.217, 0.000, 43.300> <-1.129, 0.000, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.451, 0.000, 30.000> <-1.318, 0.000, 35.699> <-1.217, 0.000, 43.300> <-1.129, 0.000, 49.000> 
		<-1.451, 0.333, 30.000> <-1.318, 0.333, 35.699> <-1.217, 0.259, 43.300> <-1.129, 0.259, 49.000> 
		<-1.261, 0.790, 30.000> <-1.167, 0.696, 35.699> <-1.044, 0.677, 43.300> <-0.981, 0.615, 49.000> 
		<-1.026, 1.026, 30.000> <-0.932, 0.932, 35.699> <-0.860, 0.860, 43.300> <-0.798, 0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.063, 55.000> <0.000, 1.083, 53.200> <0.000, 1.101, 50.800> <0.000, 1.129, 49.000> 
		<-0.244, 1.063, 55.000> <-0.244, 1.083, 53.200> <-0.259, 1.101, 50.800> <-0.259, 1.129, 49.000> 
		<-0.579, 0.925, 55.000> <-0.593, 0.938, 53.200> <-0.595, 0.962, 50.800> <-0.615, 0.981, 49.000> 
		<-0.752, 0.752, 55.000> <-0.766, 0.766, 53.200> <-0.778, 0.778, 50.800> <-0.798, 0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.063, 55.000> <0.244, 1.063, 55.000> <0.579, 0.925, 55.000> <0.752, 0.752, 55.000> 
		<0.000, 1.083, 53.200> <0.244, 1.083, 53.200> <0.593, 0.938, 53.200> <0.766, 0.766, 53.200> 
		<0.000, 1.101, 50.800> <0.259, 1.101, 50.800> <0.595, 0.962, 50.800> <0.778, 0.778, 50.800> 
		<0.000, 1.129, 49.000> <0.259, 1.129, 49.000> <0.615, 0.981, 49.000> <0.798, 0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.752, 0.752, 55.000> <0.925, 0.579, 55.000> <1.063, 0.244, 55.000> <1.063, 0.000, 55.000> 
		<0.766, 0.766, 53.200> <0.938, 0.593, 53.200> <1.083, 0.244, 53.200> <1.083, 0.000, 53.200> 
		<0.778, 0.778, 50.800> <0.962, 0.595, 50.800> <1.101, 0.259, 50.800> <1.101, 0.000, 50.800> 
		<0.798, 0.798, 49.000> <0.981, 0.615, 49.000> <1.129, 0.259, 49.000> <1.129, 0.000, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.063, 0.000, 55.000> <1.063, -0.244, 55.000> <0.925, -0.579, 55.000> <0.752, -0.752, 55.000> 
		<1.083, 0.000, 53.200> <1.083, -0.244, 53.200> <0.938, -0.593, 53.200> <0.766, -0.766, 53.200> 
		<1.101, 0.000, 50.800> <1.101, -0.259, 50.800> <0.962, -0.595, 50.800> <0.778, -0.778, 50.800> 
		<1.129, 0.000, 49.000> <1.129, -0.259, 49.000> <0.981, -0.615, 49.000> <0.798, -0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.752, -0.752, 55.000> <0.579, -0.925, 55.000> <0.244, -1.063, 55.000> <0.000, -1.063, 55.000> 
		<0.766, -0.766, 53.200> <0.593, -0.938, 53.200> <0.244, -1.083, 53.200> <0.000, -1.083, 53.200> 
		<0.778, -0.778, 50.800> <0.595, -0.962, 50.800> <0.259, -1.101, 50.800> <0.000, -1.101, 50.800> 
		<0.798, -0.798, 49.000> <0.615, -0.981, 49.000> <0.259, -1.129, 49.000> <0.000, -1.129, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -1.063, 55.000> <-0.244, -1.063, 55.000> <-0.579, -0.925, 55.000> <-0.752, -0.752, 55.000> 
		<0.000, -1.083, 53.200> <-0.244, -1.083, 53.200> <-0.593, -0.938, 53.200> <-0.766, -0.766, 53.200> 
		<0.000, -1.101, 50.800> <-0.259, -1.101, 50.800> <-0.595, -0.962, 50.800> <-0.778, -0.778, 50.800> 
		<0.000, -1.129, 49.000> <-0.259, -1.129, 49.000> <-0.615, -0.981, 49.000> <-0.798, -0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.752, -0.752, 55.000> <-0.925, -0.579, 55.000> <-1.063, -0.244, 55.000> <-1.063, 0.000, 55.000> 
		<-0.766, -0.766, 53.200> <-0.938, -0.593, 53.200> <-1.083, -0.244, 53.200> <-1.083, 0.000, 53.200> 
		<-0.778, -0.778, 50.800> <-0.962, -0.595, 50.800> <-1.101, -0.259, 50.800> <-1.101, 0.000, 50.800> 
		<-0.798, -0.798, 49.000> <-0.981, -0.615, 49.000> <-1.129, -0.259, 49.000> <-1.129, 0.000, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.063, 0.000, 55.000> <-1.063, 0.244, 55.000> <-0.925, 0.579, 55.000> <-0.752, 0.752, 55.000> 
		<-1.083, 0.000, 53.200> <-1.083, 0.244, 53.200> <-0.938, 0.593, 53.200> <-0.766, 0.766, 53.200> 
		<-1.101, 0.000, 50.800> <-1.101, 0.259, 50.800> <-0.962, 0.595, 50.800> <-0.778, 0.778, 50.800> 
		<-1.129, 0.000, 49.000> <-1.129, 0.259, 49.000> <-0.981, 0.615, 49.000> <-0.798, 0.798, 49.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.886, -0.004, 53.515> <-0.972, -0.004, 53.589> <-1.164, -0.004, 53.647> <-1.173, -0.004, 53.759> 
		<-0.886, 0.480, 53.514> <-0.972, 0.480, 53.587> <-1.164, 0.636, 53.645> <-1.173, 0.637, 53.757> 
		<-0.483, 0.882, 53.512> <-0.483, 0.968, 53.585> <-0.640, 1.083, 53.683> <-0.640, 1.170, 53.756> 
		<0.000, 0.882, 53.512> <0.000, 0.968, 53.585> <0.000, 1.083, 53.683> <0.000, 1.170, 53.756> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.886, -0.004, 53.515> <-0.886, -0.487, 53.517> <-0.483, -0.889, 53.518> <0.000, -0.889, 53.518> 
		<-0.972, -0.004, 53.589> <-0.972, -0.487, 53.590> <-0.483, -0.975, 53.592> <0.000, -0.975, 53.592> 
		<-1.164, -0.004, 53.647> <-1.164, -0.644, 53.649> <-0.640, -1.091, 53.690> <0.000, -1.091, 53.690> 
		<-1.173, -0.004, 53.759> <-1.173, -0.644, 53.762> <-0.640, -1.177, 53.763> <0.000, -1.177, 53.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.889, 53.518> <0.483, -0.889, 53.518> <0.886, -0.487, 53.517> <0.886, -0.004, 53.515> 
		<0.000, -0.975, 53.592> <0.483, -0.975, 53.592> <0.972, -0.487, 53.590> <0.972, -0.004, 53.589> 
		<0.000, -1.091, 53.690> <0.640, -1.091, 53.690> <1.164, -0.644, 53.649> <1.164, -0.004, 53.647> 
		<0.000, -1.177, 53.763> <0.640, -1.177, 53.763> <1.173, -0.644, 53.762> <1.173, -0.004, 53.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.886, -0.004, 53.515> <0.886, 0.480, 53.514> <0.483, 0.882, 53.512> <0.000, 0.882, 53.512> 
		<0.972, -0.004, 53.589> <0.972, 0.480, 53.587> <0.483, 0.968, 53.585> <0.000, 0.968, 53.585> 
		<1.164, -0.004, 53.647> <1.164, 0.636, 53.645> <0.640, 1.083, 53.683> <0.000, 1.083, 53.683> 
		<1.173, -0.004, 53.759> <1.173, 0.637, 53.757> <0.640, 1.170, 53.756> <0.000, 1.170, 53.756> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.173, -0.004, 53.759> <-1.237, -0.002, 54.502> <-1.212, 0.002, 55.504> <-1.121, 0.004, 56.244> 
		<-1.173, 0.637, 53.757> <-1.237, 0.639, 54.500> <-1.212, 0.613, 55.502> <-1.121, 0.615, 56.242> 
		<-0.640, 1.170, 53.756> <-0.640, 1.156, 54.501> <-0.612, 1.138, 55.495> <-0.612, 1.124, 56.240> 
		<0.000, 1.170, 53.756> <0.000, 1.156, 54.501> <0.000, 1.138, 55.495> <0.000, 1.124, 56.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.173, -0.004, 53.759> <-1.173, -0.004, 53.759> <-1.173, -0.004, 53.759> <-1.173, -0.004, 53.759> 
		<-1.173, 0.637, 53.757> <-1.173, -0.004, 53.759> <-1.173, -0.004, 53.759> <-1.173, -0.644, 53.762> 
		<-0.640, 1.170, 53.756> <-0.640, 0.466, 53.758> <-0.640, -0.473, 53.761> <-0.640, -1.177, 53.763> 
		<0.000, 1.170, 53.756> <0.000, 0.466, 53.758> <0.000, -0.473, 53.761> <0.000, -1.177, 53.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.173, -0.004, 53.759> <-1.173, -0.644, 53.762> <-0.640, -1.177, 53.763> <0.000, -1.177, 53.763> 
		<-1.237, -0.002, 54.502> <-1.237, -0.642, 54.504> <-0.640, -1.159, 54.509> <0.000, -1.159, 54.509> 
		<-1.212, 0.002, 55.504> <-1.212, -0.610, 55.506> <-0.612, -1.135, 55.502> <0.000, -1.135, 55.502> 
		<-1.121, 0.004, 56.244> <-1.121, -0.608, 56.246> <-0.612, -1.117, 56.248> <0.000, -1.117, 56.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -1.177, 53.763> <0.000, -1.177, 53.763> <0.000, -1.177, 53.763> <0.000, -1.177, 53.763> 
		<0.000, -0.473, 53.761> <0.640, -0.473, 53.761> <0.640, -0.473, 53.761> <0.640, -1.177, 53.763> 
		<0.000, 0.466, 53.758> <0.640, 0.466, 53.758> <1.173, -0.004, 53.759> <1.173, -0.644, 53.762> 
		<0.000, 1.170, 53.756> <0.640, 1.170, 53.756> <1.173, 0.637, 53.757> <1.173, -0.004, 53.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -1.177, 53.763> <0.640, -1.177, 53.763> <1.173, -0.644, 53.762> <1.173, -0.004, 53.759> 
		<0.000, -1.159, 54.509> <0.640, -1.159, 54.509> <1.237, -0.642, 54.504> <1.237, -0.002, 54.502> 
		<0.000, -1.135, 55.502> <0.612, -1.135, 55.502> <1.212, -0.610, 55.506> <1.212, 0.002, 55.504> 
		<0.000, -1.117, 56.248> <0.612, -1.117, 56.248> <1.121, -0.608, 56.246> <1.121, 0.004, 56.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.173, -0.004, 53.759> <1.173, 0.637, 53.757> <0.640, 1.170, 53.756> <0.000, 1.170, 53.756> 
		<1.237, -0.002, 54.502> <1.237, 0.639, 54.500> <0.640, 1.156, 54.501> <0.000, 1.156, 54.501> 
		<1.212, 0.002, 55.504> <1.212, 0.613, 55.502> <0.612, 1.138, 55.495> <0.000, 1.138, 55.495> 
		<1.121, 0.004, 56.244> <1.121, 0.615, 56.242> <0.612, 1.124, 56.240> <0.000, 1.124, 56.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.849, 0.004, 56.389> <-0.849, 0.467, 56.387> <-0.463, 0.852, 56.386> <0.000, 0.852, 56.386> 
		<-0.930, 0.004, 56.345> <-0.930, 0.467, 56.344> <-0.463, 0.934, 56.342> <0.000, 0.934, 56.342> 
		<-1.109, 0.004, 56.336> <-1.109, 0.616, 56.334> <-0.612, 1.043, 56.284> <0.000, 1.043, 56.284> 
		<-1.121, 0.004, 56.244> <-1.121, 0.615, 56.242> <-0.612, 1.124, 56.240> <0.000, 1.124, 56.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.849, 0.004, 56.389> <-0.930, 0.004, 56.345> <-1.109, 0.004, 56.336> <-1.121, 0.004, 56.244> 
		<-0.849, -0.459, 56.390> <-0.930, -0.459, 56.347> <-1.109, -0.608, 56.338> <-1.121, -0.608, 56.246> 
		<-0.463, -0.845, 56.391> <-0.463, -0.927, 56.348> <-0.612, -1.035, 56.291> <-0.612, -1.117, 56.248> 
		<0.000, -0.845, 56.391> <0.000, -0.927, 56.348> <0.000, -1.035, 56.291> <0.000, -1.117, 56.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.845, 56.391> <0.000, -0.927, 56.348> <0.000, -1.035, 56.291> <0.000, -1.117, 56.248> 
		<0.463, -0.845, 56.391> <0.463, -0.927, 56.348> <0.612, -1.035, 56.291> <0.612, -1.117, 56.248> 
		<0.849, -0.459, 56.390> <0.930, -0.459, 56.347> <1.109, -0.608, 56.338> <1.121, -0.608, 56.246> 
		<0.849, 0.004, 56.389> <0.930, 0.004, 56.345> <1.109, 0.004, 56.336> <1.121, 0.004, 56.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.849, 0.004, 56.389> <0.930, 0.004, 56.345> <1.109, 0.004, 56.336> <1.121, 0.004, 56.244> 
		<0.849, 0.467, 56.387> <0.930, 0.467, 56.344> <1.109, 0.616, 56.334> <1.121, 0.615, 56.242> 
		<0.463, 0.852, 56.386> <0.463, 0.934, 56.342> <0.612, 1.043, 56.284> <0.612, 1.124, 56.240> 
		<0.000, 0.852, 56.386> <0.000, 0.934, 56.342> <0.000, 1.043, 56.284> <0.000, 1.124, 56.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.121, 0.004, 56.244> <-1.121, 0.004, 56.244> <-1.121, 0.004, 56.244> <-1.121, 0.004, 56.244> 
		<-1.121, 0.615, 56.242> <-1.121, 0.004, 56.244> <-1.121, 0.004, 56.244> <-1.121, -0.608, 56.246> 
		<-0.612, 1.124, 56.240> <-0.612, 0.452, 56.242> <-0.612, -0.445, 56.245> <-0.612, -1.117, 56.248> 
		<0.000, 1.124, 56.240> <0.000, 0.452, 56.242> <0.000, -0.445, 56.245> <0.000, -1.117, 56.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -1.117, 56.248> <0.000, -1.117, 56.248> <0.000, -1.117, 56.248> <0.000, -1.117, 56.248> 
		<0.000, -0.445, 56.245> <0.612, -0.445, 56.245> <0.612, -0.445, 56.245> <0.612, -1.117, 56.248> 
		<0.000, 0.452, 56.242> <0.612, 0.452, 56.242> <1.121, 0.004, 56.244> <1.121, -0.608, 56.246> 
		<0.000, 1.124, 56.240> <0.612, 1.124, 56.240> <1.121, 0.615, 56.242> <1.121, 0.004, 56.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, -1.500, 55.000> <-0.500, -1.500, 55.000> <-0.500, -1.500, 55.000> <-0.500, -1.500, 55.000> 
		<-0.500, -1.500, 54.727> <-0.500, -1.500, 55.000> <-0.500, -1.500, 55.000> <-0.500, -1.500, 55.273> 
		<-0.273, -1.500, 54.500> <-0.273, -1.500, 54.800> <-0.273, -1.500, 55.200> <-0.273, -1.500, 55.500> 
		<0.000, -1.500, 54.500> <0.000, -1.500, 54.800> <0.000, -1.500, 55.200> <0.000, -1.500, 55.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, -1.500, 55.000> <-0.500, -1.500, 54.727> <-0.273, -1.500, 54.500> <0.000, -1.500, 54.500> 
		<-0.500, -4.200, 55.000> <-0.500, -4.200, 54.727> <-0.273, -4.200, 54.500> <0.000, -4.200, 54.500> 
		<-0.500, -7.800, 55.000> <-0.500, -7.800, 54.727> <-0.273, -7.800, 54.500> <0.000, -7.800, 54.500> 
		<-0.500, -10.500, 55.000> <-0.500, -10.500, 54.727> <-0.273, -10.500, 54.500> <0.000, -10.500, 54.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, -1.500, 55.000> <-0.500, -4.200, 55.000> <-0.500, -7.800, 55.000> <-0.500, -10.500, 55.000> 
		<-0.500, -1.500, 55.273> <-0.500, -4.200, 55.273> <-0.500, -7.800, 55.273> <-0.500, -10.500, 55.273> 
		<-0.273, -1.500, 55.500> <-0.273, -4.200, 55.500> <-0.273, -7.800, 55.500> <-0.273, -10.500, 55.500> 
		<0.000, -1.500, 55.500> <0.000, -4.200, 55.500> <0.000, -7.800, 55.500> <0.000, -10.500, 55.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, -1.500, 55.000> <0.500, -1.500, 55.273> <0.273, -1.500, 55.500> <0.000, -1.500, 55.500> 
		<0.500, -4.200, 55.000> <0.500, -4.200, 55.273> <0.273, -4.200, 55.500> <0.000, -4.200, 55.500> 
		<0.500, -7.800, 55.000> <0.500, -7.800, 55.273> <0.273, -7.800, 55.500> <0.000, -7.800, 55.500> 
		<0.500, -10.500, 55.000> <0.500, -10.500, 55.273> <0.273, -10.500, 55.500> <0.000, -10.500, 55.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, -1.500, 55.000> <0.500, -1.500, 55.000> <0.500, -1.500, 55.000> <0.500, -1.500, 55.000> 
		<0.500, -1.500, 55.273> <0.500, -1.500, 55.000> <0.500, -1.500, 55.000> <0.500, -1.500, 54.727> 
		<0.273, -1.500, 55.500> <0.273, -1.500, 55.200> <0.273, -1.500, 54.800> <0.273, -1.500, 54.500> 
		<0.000, -1.500, 55.500> <0.000, -1.500, 55.200> <0.000, -1.500, 54.800> <0.000, -1.500, 54.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, -1.500, 55.000> <0.500, -4.200, 55.000> <0.500, -7.800, 55.000> <0.500, -10.500, 55.000> 
		<0.500, -1.500, 54.727> <0.500, -4.200, 54.727> <0.500, -7.800, 54.727> <0.500, -10.500, 54.727> 
		<0.273, -1.500, 54.500> <0.273, -4.200, 54.500> <0.273, -7.800, 54.500> <0.273, -10.500, 54.500> 
		<0.000, -1.500, 54.500> <0.000, -4.200, 54.500> <0.000, -7.800, 54.500> <0.000, -10.500, 54.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, -10.500, 55.000> <-0.500, -10.500, 55.000> <-0.500, -10.500, 55.000> <-0.500, -10.500, 55.000> 
		<-0.500, -10.500, 55.273> <-0.500, -10.500, 55.000> <-0.500, -10.500, 55.000> <-0.500, -10.500, 54.727> 
		<-0.273, -10.500, 55.500> <-0.273, -10.500, 55.200> <-0.273, -10.500, 54.800> <-0.273, -10.500, 54.500> 
		<0.000, -10.500, 55.500> <0.000, -10.500, 55.200> <0.000, -10.500, 54.800> <0.000, -10.500, 54.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, -10.500, 55.000> <0.500, -10.500, 55.000> <0.500, -10.500, 55.000> <0.500, -10.500, 55.000> 
		<0.500, -10.500, 54.727> <0.500, -10.500, 55.000> <0.500, -10.500, 55.000> <0.500, -10.500, 55.273> 
		<0.273, -10.500, 54.500> <0.273, -10.500, 54.800> <0.273, -10.500, 55.200> <0.273, -10.500, 55.500> 
		<0.000, -10.500, 54.500> <0.000, -10.500, 54.800> <0.000, -10.500, 55.200> <0.000, -10.500, 55.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.583, 0.523, 55.000> <-0.583, 0.523, 55.000> <-0.583, 0.523, 55.000> <-0.583, 0.523, 55.000> 
		<-0.583, 0.523, 54.682> <-0.583, 0.523, 55.000> <-0.583, 0.523, 55.000> <-0.583, 0.523, 55.318> 
		<-0.318, 0.523, 54.417> <-0.318, 0.523, 54.767> <-0.318, 0.523, 55.233> <-0.318, 0.523, 55.583> 
		<0.000, 0.523, 54.417> <0.000, 0.523, 54.767> <0.000, 0.523, 55.233> <0.000, 0.523, 55.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.583, 0.523, 55.000> <-0.583, 0.523, 54.682> <-0.318, 0.523, 54.417> <0.000, 0.523, 54.417> 
		<-0.583, -0.524, 55.000> <-0.583, -0.524, 54.682> <-0.318, -0.524, 54.417> <0.000, -0.524, 54.417> 
		<-0.626, -1.921, 55.000> <-0.626, -1.921, 54.682> <-0.318, -1.920, 54.417> <0.000, -1.920, 54.417> 
		<-0.583, -2.967, 55.000> <-0.583, -2.967, 54.682> <-0.318, -2.967, 54.417> <0.000, -2.967, 54.417> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.583, 0.523, 55.000> <-0.583, -0.524, 55.000> <-0.626, -1.921, 55.000> <-0.583, -2.967, 55.000> 
		<-0.583, 0.523, 55.318> <-0.583, -0.524, 55.318> <-0.626, -1.921, 55.318> <-0.583, -2.967, 55.318> 
		<-0.318, 0.523, 55.583> <-0.318, -0.524, 55.583> <-0.318, -1.920, 55.583> <-0.318, -2.967, 55.583> 
		<0.000, 0.523, 55.583> <0.000, -0.524, 55.583> <0.000, -1.920, 55.583> <0.000, -2.967, 55.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.583, 0.523, 55.000> <0.583, 0.523, 55.318> <0.318, 0.523, 55.583> <0.000, 0.523, 55.583> 
		<0.583, -0.524, 55.000> <0.583, -0.524, 55.318> <0.318, -0.524, 55.583> <0.000, -0.524, 55.583> 
		<0.626, -1.921, 55.000> <0.626, -1.921, 55.318> <0.318, -1.920, 55.583> <0.000, -1.920, 55.583> 
		<0.583, -2.967, 55.000> <0.583, -2.967, 55.318> <0.318, -2.967, 55.583> <0.000, -2.967, 55.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.583, 0.523, 55.000> <0.583, 0.523, 55.000> <0.583, 0.523, 55.000> <0.583, 0.523, 55.000> 
		<0.583, 0.523, 55.318> <0.583, 0.523, 55.000> <0.583, 0.523, 55.000> <0.583, 0.523, 54.682> 
		<0.318, 0.523, 55.583> <0.318, 0.523, 55.233> <0.318, 0.523, 54.767> <0.318, 0.523, 54.417> 
		<0.000, 0.523, 55.583> <0.000, 0.523, 55.233> <0.000, 0.523, 54.767> <0.000, 0.523, 54.417> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.583, 0.523, 55.000> <0.583, -0.524, 55.000> <0.626, -1.921, 55.000> <0.583, -2.967, 55.000> 
		<0.583, 0.523, 54.682> <0.583, -0.524, 54.682> <0.626, -1.921, 54.682> <0.583, -2.967, 54.682> 
		<0.318, 0.523, 54.417> <0.318, -0.524, 54.417> <0.318, -1.920, 54.417> <0.318, -2.967, 54.417> 
		<0.000, 0.523, 54.417> <0.000, -0.524, 54.417> <0.000, -1.920, 54.417> <0.000, -2.967, 54.417> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.436, -3.032, 55.000> <-0.480, -3.013, 55.000> <-0.581, -3.015, 55.000> <-0.583, -2.967, 55.000> 
		<-0.436, -3.032, 54.762> <-0.480, -3.013, 54.762> <-0.581, -3.015, 54.682> <-0.583, -2.967, 54.682> 
		<-0.238, -3.032, 54.564> <-0.238, -3.013, 54.520> <-0.318, -2.987, 54.461> <-0.318, -2.967, 54.417> 
		<0.000, -3.032, 54.564> <0.000, -3.013, 54.520> <0.000, -2.987, 54.461> <0.000, -2.967, 54.417> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.436, -3.032, 55.000> <-0.436, -3.032, 55.238> <-0.238, -3.032, 55.436> <0.000, -3.032, 55.436> 
		<-0.480, -3.013, 55.000> <-0.480, -3.013, 55.238> <-0.238, -3.013, 55.480> <0.000, -3.013, 55.480> 
		<-0.581, -3.015, 55.000> <-0.581, -3.015, 55.318> <-0.318, -2.987, 55.539> <0.000, -2.987, 55.539> 
		<-0.583, -2.967, 55.000> <-0.583, -2.967, 55.318> <-0.318, -2.967, 55.583> <0.000, -2.967, 55.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -3.032, 55.436> <0.238, -3.032, 55.436> <0.436, -3.032, 55.238> <0.436, -3.032, 55.000> 
		<0.000, -3.013, 55.480> <0.238, -3.013, 55.480> <0.480, -3.013, 55.238> <0.480, -3.013, 55.000> 
		<0.000, -2.987, 55.539> <0.318, -2.987, 55.539> <0.581, -3.015, 55.318> <0.581, -3.015, 55.000> 
		<0.000, -2.967, 55.583> <0.318, -2.967, 55.583> <0.583, -2.967, 55.318> <0.583, -2.967, 55.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.436, -3.032, 55.000> <0.436, -3.032, 54.762> <0.238, -3.032, 54.564> <0.000, -3.032, 54.564> 
		<0.480, -3.013, 55.000> <0.480, -3.013, 54.762> <0.238, -3.013, 54.520> <0.000, -3.013, 54.520> 
		<0.581, -3.015, 55.000> <0.581, -3.015, 54.682> <0.318, -2.987, 54.461> <0.000, -2.987, 54.461> 
		<0.583, -2.967, 55.000> <0.583, -2.967, 54.682> <0.318, -2.967, 54.417> <0.000, -2.967, 54.417> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.583, -2.967, 55.000> <-0.583, -2.967, 55.000> <-0.583, -2.967, 55.000> <-0.583, -2.967, 55.000> 
		<-0.583, -2.967, 55.318> <-0.583, -2.967, 55.000> <-0.583, -2.967, 55.000> <-0.583, -2.967, 54.682> 
		<-0.318, -2.967, 55.583> <-0.318, -2.967, 55.233> <-0.318, -2.967, 54.767> <-0.318, -2.967, 54.417> 
		<0.000, -2.967, 55.583> <0.000, -2.967, 55.233> <0.000, -2.967, 54.767> <0.000, -2.967, 54.417> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -2.967, 55.583> <0.000, -2.967, 55.583> <0.000, -2.967, 55.583> <0.000, -2.967, 55.583> 
		<0.318, -2.967, 55.583> <0.318, -2.967, 55.233> <0.318, -2.967, 55.233> <0.000, -2.967, 55.233> 
		<0.583, -2.967, 55.318> <0.583, -2.967, 55.000> <0.318, -2.967, 54.767> <0.000, -2.967, 54.767> 
		<0.583, -2.967, 55.000> <0.583, -2.967, 54.682> <0.318, -2.967, 54.417> <0.000, -2.967, 54.417> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.725, -10.481, 53.893> <-0.725, -10.481, 53.893> <-0.725, -10.481, 53.893> <-0.725, -10.481, 53.893> 
		<-0.725, -10.085, 53.892> <-0.725, -10.481, 53.893> <-0.725, -10.481, 53.893> <-0.725, -10.877, 53.894> 
		<-0.396, -9.756, 53.891> <-0.396, -10.191, 53.892> <-0.396, -10.772, 53.894> <-0.396, -11.207, 53.895> 
		<0.000, -9.756, 53.891> <0.000, -10.191, 53.892> <0.000, -10.772, 53.894> <0.000, -11.207, 53.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.725, -10.481, 53.893> <-0.725, -10.085, 53.892> <-0.396, -9.756, 53.891> <0.000, -9.756, 53.891> 
		<-0.725, -10.483, 51.527> <-0.725, -10.087, 51.526> <-0.396, -9.757, 51.525> <0.000, -9.757, 51.525> 
		<-0.725, -10.467, 48.372> <-0.725, -10.071, 48.371> <-0.396, -9.759, 48.370> <0.000, -9.759, 48.370> 
		<-0.725, -10.486, 46.006> <-0.725, -10.090, 46.005> <-0.396, -9.760, 46.004> <0.000, -9.760, 46.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.725, -10.481, 53.893> <-0.725, -10.483, 51.527> <-0.725, -10.467, 48.372> <-0.725, -10.486, 46.006> 
		<-0.725, -10.877, 53.894> <-0.725, -10.879, 51.528> <-0.725, -10.863, 48.373> <-0.725, -10.882, 46.007> 
		<-0.396, -11.207, 53.895> <-0.396, -11.208, 51.529> <-0.396, -11.210, 48.374> <-0.396, -11.211, 46.008> 
		<0.000, -11.207, 53.895> <0.000, -11.208, 51.529> <0.000, -11.210, 48.374> <0.000, -11.211, 46.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, -10.481, 53.893> <0.725, -10.877, 53.894> <0.396, -11.207, 53.895> <0.000, -11.207, 53.895> 
		<0.725, -10.483, 51.527> <0.725, -10.879, 51.528> <0.396, -11.208, 51.529> <0.000, -11.208, 51.529> 
		<0.725, -10.467, 48.372> <0.725, -10.863, 48.373> <0.396, -11.210, 48.374> <0.000, -11.210, 48.374> 
		<0.725, -10.486, 46.006> <0.725, -10.882, 46.007> <0.396, -11.211, 46.008> <0.000, -11.211, 46.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, -10.481, 53.893> <0.725, -10.481, 53.893> <0.725, -10.481, 53.893> <0.725, -10.481, 53.893> 
		<0.725, -10.877, 53.894> <0.725, -10.481, 53.893> <0.725, -10.481, 53.893> <0.725, -10.085, 53.892> 
		<0.396, -11.207, 53.895> <0.396, -10.772, 53.894> <0.396, -10.191, 53.892> <0.396, -9.756, 53.891> 
		<0.000, -11.207, 53.895> <0.000, -10.772, 53.894> <0.000, -10.191, 53.892> <0.000, -9.756, 53.891> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, -10.481, 53.893> <0.725, -10.483, 51.527> <0.725, -10.467, 48.372> <0.725, -10.486, 46.006> 
		<0.725, -10.085, 53.892> <0.725, -10.087, 51.526> <0.725, -10.071, 48.371> <0.725, -10.090, 46.005> 
		<0.396, -9.756, 53.891> <0.396, -9.757, 51.525> <0.396, -9.759, 48.370> <0.396, -9.760, 46.004> 
		<0.000, -9.756, 53.891> <0.000, -9.757, 51.525> <0.000, -9.759, 48.370> <0.000, -9.760, 46.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.725, -10.486, 46.006> <-0.725, -10.486, 46.006> <-0.725, -10.486, 46.006> <-0.725, -10.486, 46.006> 
		<-0.725, -10.882, 46.007> <-0.725, -10.486, 46.006> <-0.725, -10.486, 46.006> <-0.725, -10.090, 46.005> 
		<-0.396, -11.211, 46.008> <-0.396, -10.776, 46.007> <-0.396, -10.196, 46.005> <-0.396, -9.760, 46.004> 
		<0.000, -11.211, 46.008> <0.000, -10.776, 46.007> <0.000, -10.196, 46.005> <0.000, -9.760, 46.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.725, -10.486, 46.006> <-0.725, -10.090, 46.005> <-0.396, -9.760, 46.004> <0.000, -9.760, 46.004> 
		<-0.725, -10.489, 45.631> <-0.725, -10.093, 45.630> <-0.396, -9.782, 45.611> <0.000, -9.782, 45.611> 
		<-0.725, -10.530, 45.133> <-0.725, -10.135, 45.097> <-0.396, -9.806, 45.086> <0.000, -9.806, 45.086> 
		<-0.725, -10.555, 44.759> <-0.725, -10.160, 44.723> <-0.396, -9.832, 44.694> <0.000, -9.832, 44.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.725, -10.486, 46.006> <-0.725, -10.489, 45.631> <-0.725, -10.530, 45.133> <-0.725, -10.555, 44.759> 
		<-0.725, -10.882, 46.007> <-0.725, -10.885, 45.632> <-0.725, -10.924, 45.168> <-0.725, -10.949, 44.795> 
		<-0.396, -11.211, 46.008> <-0.396, -11.231, 45.653> <-0.396, -11.253, 45.179> <-0.396, -11.277, 44.824> 
		<0.000, -11.211, 46.008> <0.000, -11.231, 45.653> <0.000, -11.253, 45.179> <0.000, -11.277, 44.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.211, 46.008> <0.000, -11.211, 46.008> <0.000, -11.211, 46.008> <0.000, -11.211, 46.008> 
		<0.396, -11.211, 46.008> <0.396, -10.776, 46.007> <0.396, -10.776, 46.007> <0.000, -10.776, 46.007> 
		<0.725, -10.882, 46.007> <0.725, -10.486, 46.006> <0.396, -10.196, 46.005> <0.000, -10.196, 46.005> 
		<0.725, -10.486, 46.006> <0.725, -10.090, 46.005> <0.396, -9.760, 46.004> <0.000, -9.760, 46.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.211, 46.008> <0.000, -11.231, 45.653> <0.000, -11.253, 45.179> <0.000, -11.277, 44.824> 
		<0.396, -11.211, 46.008> <0.396, -11.231, 45.653> <0.396, -11.253, 45.179> <0.396, -11.277, 44.824> 
		<0.725, -10.882, 46.007> <0.725, -10.885, 45.632> <0.725, -10.924, 45.168> <0.725, -10.949, 44.795> 
		<0.725, -10.486, 46.006> <0.725, -10.489, 45.631> <0.725, -10.530, 45.133> <0.725, -10.555, 44.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, -10.486, 46.006> <0.725, -10.489, 45.631> <0.725, -10.530, 45.133> <0.725, -10.555, 44.759> 
		<0.725, -10.090, 46.005> <0.725, -10.093, 45.630> <0.725, -10.135, 45.097> <0.725, -10.160, 44.723> 
		<0.396, -9.760, 46.004> <0.396, -9.782, 45.611> <0.396, -9.806, 45.086> <0.396, -9.832, 44.694> 
		<0.000, -9.760, 46.004> <0.000, -9.782, 45.611> <0.000, -9.806, 45.086> <0.000, -9.832, 44.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.725, -11.486, 31.006> <-0.725, -11.206, 35.132> <-0.725, -10.830, 40.633> <-0.725, -10.555, 44.759> 
		<-0.725, -11.091, 30.975> <-0.725, -10.812, 35.101> <-0.725, -10.435, 40.597> <-0.725, -10.160, 44.723> 
		<-0.396, -10.763, 30.949> <-0.396, -10.483, 35.073> <-0.396, -10.107, 40.570> <-0.396, -9.832, 44.694> 
		<0.000, -10.763, 30.949> <0.000, -10.483, 35.073> <0.000, -10.107, 40.570> <0.000, -9.832, 44.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.725, -11.486, 31.006> <-0.725, -11.881, 31.037> <-0.396, -12.209, 31.062> <0.000, -12.209, 31.062> 
		<-0.725, -11.206, 35.132> <-0.725, -11.601, 35.163> <-0.396, -11.930, 35.191> <0.000, -11.930, 35.191> 
		<-0.725, -10.830, 40.633> <-0.725, -11.224, 40.668> <-0.396, -11.553, 40.695> <0.000, -11.553, 40.695> 
		<-0.725, -10.555, 44.759> <-0.725, -10.949, 44.795> <-0.396, -11.277, 44.824> <0.000, -11.277, 44.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -12.209, 31.062> <0.396, -12.209, 31.062> <0.725, -11.881, 31.037> <0.725, -11.486, 31.006> 
		<0.000, -11.930, 35.191> <0.396, -11.930, 35.191> <0.725, -11.601, 35.163> <0.725, -11.206, 35.132> 
		<0.000, -11.553, 40.695> <0.396, -11.553, 40.695> <0.725, -11.224, 40.668> <0.725, -10.830, 40.633> 
		<0.000, -11.277, 44.824> <0.396, -11.277, 44.824> <0.725, -10.949, 44.795> <0.725, -10.555, 44.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, -11.486, 31.006> <0.725, -11.091, 30.975> <0.396, -10.763, 30.949> <0.000, -10.763, 30.949> 
		<0.725, -11.206, 35.132> <0.725, -10.812, 35.101> <0.396, -10.483, 35.073> <0.000, -10.483, 35.073> 
		<0.725, -10.830, 40.633> <0.725, -10.435, 40.597> <0.396, -10.107, 40.570> <0.000, -10.107, 40.570> 
		<0.725, -10.555, 44.759> <0.725, -10.160, 44.723> <0.396, -9.832, 44.694> <0.000, -9.832, 44.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.865, -11.544, 30.150> <-0.865, -11.449, 31.516> <-0.970, -11.316, 33.342> <-0.865, -11.226, 34.704> 
		<-0.865, -11.073, 30.119> <-0.865, -10.977, 31.486> <-0.970, -10.845, 33.311> <-0.865, -10.755, 34.673> 
		<-0.472, -10.681, 30.094> <-0.472, -10.585, 31.460> <-0.472, -10.458, 33.281> <-0.472, -10.363, 34.648> 
		<0.000, -10.681, 30.094> <0.000, -10.585, 31.460> <0.000, -10.458, 33.281> <0.000, -10.363, 34.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.865, -11.544, 30.150> <-0.865, -11.544, 30.150> <-0.865, -11.544, 30.150> <-0.865, -11.544, 30.150> 
		<-0.865, -12.015, 30.181> <-0.865, -11.544, 30.150> <-0.865, -11.544, 30.150> <-0.865, -11.073, 30.119> 
		<-0.472, -12.408, 30.207> <-0.472, -11.890, 30.173> <-0.472, -11.199, 30.128> <-0.472, -10.681, 30.094> 
		<0.000, -12.408, 30.207> <0.000, -11.890, 30.173> <0.000, -11.199, 30.128> <0.000, -10.681, 30.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.865, -11.544, 30.150> <-0.865, -12.015, 30.181> <-0.472, -12.408, 30.207> <0.000, -12.408, 30.207> 
		<-0.865, -11.449, 31.516> <-0.865, -11.920, 31.547> <-0.472, -12.312, 31.573> <0.000, -12.312, 31.573> 
		<-0.970, -11.316, 33.342> <-0.970, -11.787, 33.372> <-0.472, -12.185, 33.394> <0.000, -12.185, 33.394> 
		<-0.865, -11.226, 34.704> <-0.865, -11.698, 34.735> <-0.472, -12.090, 34.761> <0.000, -12.090, 34.761> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.865, -11.544, 30.150> <0.865, -11.544, 30.150> <0.865, -11.544, 30.150> <0.865, -11.544, 30.150> 
		<0.865, -11.073, 30.119> <0.865, -11.544, 30.150> <0.865, -11.544, 30.150> <0.865, -12.015, 30.181> 
		<0.472, -10.681, 30.094> <0.472, -11.199, 30.128> <0.472, -11.890, 30.173> <0.472, -12.408, 30.207> 
		<0.000, -10.681, 30.094> <0.000, -11.199, 30.128> <0.000, -11.890, 30.173> <0.000, -12.408, 30.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.865, -11.544, 30.150> <0.865, -11.449, 31.516> <0.970, -11.316, 33.342> <0.865, -11.226, 34.704> 
		<0.865, -12.015, 30.181> <0.865, -11.920, 31.547> <0.970, -11.787, 33.372> <0.865, -11.698, 34.735> 
		<0.472, -12.408, 30.207> <0.472, -12.312, 31.573> <0.472, -12.185, 33.394> <0.472, -12.090, 34.761> 
		<0.000, -12.408, 30.207> <0.000, -12.312, 31.573> <0.000, -12.185, 33.394> <0.000, -12.090, 34.761> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.865, -11.544, 30.150> <0.865, -11.073, 30.119> <0.472, -10.681, 30.094> <0.000, -10.681, 30.094> 
		<0.865, -11.449, 31.516> <0.865, -10.977, 31.486> <0.472, -10.585, 31.460> <0.000, -10.585, 31.460> 
		<0.970, -11.316, 33.342> <0.970, -10.845, 33.311> <0.472, -10.458, 33.281> <0.000, -10.458, 33.281> 
		<0.865, -11.226, 34.704> <0.865, -10.755, 34.673> <0.472, -10.363, 34.648> <0.000, -10.363, 34.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.494, -11.226, 34.981> <-0.494, -10.957, 34.963> <-0.270, -10.733, 34.949> <0.000, -10.733, 34.949> 
		<-0.605, -11.226, 34.898> <-0.605, -10.957, 34.880> <-0.270, -10.622, 34.858> <0.000, -10.622, 34.858> 
		<-0.855, -11.217, 34.842> <-0.855, -10.746, 34.812> <-0.472, -10.474, 34.738> <0.000, -10.474, 34.738> 
		<-0.865, -11.226, 34.704> <-0.865, -10.755, 34.673> <-0.472, -10.363, 34.648> <0.000, -10.363, 34.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.494, -11.226, 34.981> <-0.605, -11.226, 34.898> <-0.855, -11.217, 34.842> <-0.865, -11.226, 34.704> 
		<-0.494, -11.495, 34.999> <-0.605, -11.495, 34.916> <-0.855, -11.689, 34.873> <-0.865, -11.698, 34.735> 
		<-0.270, -11.719, 35.013> <-0.270, -11.830, 34.937> <-0.472, -11.979, 34.836> <-0.472, -12.090, 34.761> 
		<0.000, -11.719, 35.013> <0.000, -11.830, 34.937> <0.000, -11.979, 34.836> <0.000, -12.090, 34.761> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.719, 35.013> <0.000, -11.830, 34.937> <0.000, -11.979, 34.836> <0.000, -12.090, 34.761> 
		<0.270, -11.719, 35.013> <0.270, -11.830, 34.937> <0.472, -11.979, 34.836> <0.472, -12.090, 34.761> 
		<0.494, -11.495, 34.999> <0.605, -11.495, 34.916> <0.855, -11.689, 34.873> <0.865, -11.698, 34.735> 
		<0.494, -11.226, 34.981> <0.605, -11.226, 34.898> <0.855, -11.217, 34.842> <0.865, -11.226, 34.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.494, -11.226, 34.981> <0.605, -11.226, 34.898> <0.855, -11.217, 34.842> <0.865, -11.226, 34.704> 
		<0.494, -10.957, 34.963> <0.605, -10.957, 34.880> <0.855, -10.746, 34.812> <0.865, -10.755, 34.673> 
		<0.270, -10.733, 34.949> <0.270, -10.622, 34.858> <0.472, -10.474, 34.738> <0.472, -10.363, 34.648> 
		<0.000, -10.733, 34.949> <0.000, -10.622, 34.858> <0.000, -10.474, 34.738> <0.000, -10.363, 34.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.865, -11.226, 34.704> <-0.865, -11.226, 34.704> <-0.865, -11.226, 34.704> <-0.865, -11.226, 34.704> 
		<-0.865, -10.755, 34.673> <-0.865, -11.226, 34.704> <-0.865, -11.226, 34.704> <-0.865, -11.698, 34.735> 
		<-0.472, -10.363, 34.648> <-0.472, -10.881, 34.682> <-0.472, -11.572, 34.727> <-0.472, -12.090, 34.761> 
		<0.000, -10.363, 34.648> <0.000, -10.881, 34.682> <0.000, -11.572, 34.727> <0.000, -12.090, 34.761> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -12.090, 34.761> <0.000, -12.090, 34.761> <0.000, -12.090, 34.761> <0.000, -12.090, 34.761> 
		<0.000, -11.572, 34.727> <0.472, -11.572, 34.727> <0.472, -11.572, 34.727> <0.472, -12.090, 34.761> 
		<0.000, -10.881, 34.682> <0.472, -10.881, 34.682> <0.865, -11.226, 34.704> <0.865, -11.698, 34.735> 
		<0.000, -10.363, 34.648> <0.472, -10.363, 34.648> <0.865, -10.755, 34.673> <0.865, -11.226, 34.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.595, 29.338> <-1.149, -11.595, 29.338> <-1.149, -11.595, 29.338> <-1.149, -11.595, 29.338> 
		<-1.149, -12.216, 29.383> <-1.149, -11.595, 29.338> <-1.149, -11.595, 29.338> <-1.149, -10.974, 29.292> 
		<-0.631, -12.732, 29.421> <-0.631, -12.050, 29.371> <-0.631, -11.140, 29.304> <-0.631, -10.458, 29.254> 
		<-0.009, -12.732, 29.421> <-0.009, -12.050, 29.371> <-0.009, -11.140, 29.304> <-0.009, -10.458, 29.254> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.595, 29.338> <-1.149, -12.216, 29.383> <-0.631, -12.732, 29.421> <-0.009, -12.732, 29.421> 
		<-1.175, -11.570, 29.635> <-1.175, -12.190, 29.681> <-0.631, -12.710, 29.720> <-0.009, -12.710, 29.720> 
		<-1.149, -11.541, 30.036> <-1.149, -12.162, 30.081> <-0.631, -12.681, 30.119> <-0.009, -12.681, 30.119> 
		<-1.149, -11.522, 30.335> <-1.149, -12.142, 30.380> <-0.631, -12.659, 30.418> <-0.009, -12.659, 30.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.595, 29.338> <-1.149, -12.216, 29.383> <-0.631, -12.732, 29.421> <-0.009, -12.732, 29.421> 
		<-1.145, -11.599, 29.294> <-1.145, -12.219, 29.339> <-0.631, -12.710, 29.386> <-0.009, -12.710, 29.386> 
		<-1.078, -11.611, 29.264> <-1.078, -12.180, 29.306> <-0.580, -12.677, 29.341> <-0.009, -12.677, 29.341> 
		<-1.055, -11.615, 29.227> <-1.055, -12.184, 29.269> <-0.580, -12.658, 29.304> <-0.009, -12.658, 29.304> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.595, 29.338> <-1.175, -11.570, 29.635> <-1.149, -11.541, 30.036> <-1.149, -11.522, 30.335> 
		<-1.149, -10.974, 29.292> <-1.175, -10.949, 29.590> <-1.149, -10.920, 29.990> <-1.149, -10.901, 30.289> 
		<-0.631, -10.458, 29.254> <-0.631, -10.436, 29.553> <-0.631, -10.407, 29.952> <-0.631, -10.385, 30.251> 
		<-0.009, -10.458, 29.254> <-0.009, -10.436, 29.553> <-0.009, -10.407, 29.952> <-0.009, -10.385, 30.251> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.595, 29.338> <-1.145, -11.599, 29.294> <-1.078, -11.611, 29.264> <-1.055, -11.615, 29.227> 
		<-1.149, -10.974, 29.292> <-1.145, -10.978, 29.248> <-1.078, -11.042, 29.222> <-1.055, -11.046, 29.186> 
		<-0.631, -10.458, 29.254> <-0.631, -10.492, 29.223> <-0.580, -10.544, 29.187> <-0.580, -10.572, 29.151> 
		<-0.009, -10.458, 29.254> <-0.009, -10.492, 29.223> <-0.009, -10.544, 29.187> <-0.009, -10.572, 29.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -10.458, 29.254> <-0.009, -10.458, 29.254> <-0.009, -10.458, 29.254> <-0.009, -10.458, 29.254> 
		<-0.009, -11.140, 29.304> <0.613, -11.140, 29.304> <0.613, -11.140, 29.304> <0.613, -10.458, 29.254> 
		<-0.009, -12.050, 29.371> <0.613, -12.050, 29.371> <1.131, -11.595, 29.338> <1.131, -10.974, 29.292> 
		<-0.009, -12.732, 29.421> <0.613, -12.732, 29.421> <1.131, -12.216, 29.383> <1.131, -11.595, 29.338> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -10.458, 29.254> <-0.009, -10.436, 29.553> <-0.009, -10.407, 29.952> <-0.009, -10.385, 30.251> 
		<0.613, -10.458, 29.254> <0.613, -10.436, 29.553> <0.613, -10.407, 29.952> <0.613, -10.385, 30.251> 
		<1.131, -10.974, 29.292> <1.156, -10.949, 29.590> <1.131, -10.920, 29.990> <1.131, -10.901, 30.289> 
		<1.131, -11.595, 29.338> <1.156, -11.570, 29.635> <1.131, -11.541, 30.036> <1.131, -11.522, 30.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -10.458, 29.254> <-0.009, -10.492, 29.223> <-0.009, -10.544, 29.187> <-0.009, -10.572, 29.151> 
		<0.613, -10.458, 29.254> <0.613, -10.492, 29.223> <0.561, -10.544, 29.187> <0.561, -10.572, 29.151> 
		<1.131, -10.974, 29.292> <1.127, -10.978, 29.248> <1.060, -11.042, 29.222> <1.036, -11.046, 29.186> 
		<1.131, -11.595, 29.338> <1.127, -11.599, 29.294> <1.060, -11.611, 29.264> <1.036, -11.615, 29.227> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.131, -11.595, 29.338> <1.156, -11.570, 29.635> <1.131, -11.541, 30.036> <1.131, -11.522, 30.335> 
		<1.131, -12.216, 29.383> <1.156, -12.190, 29.681> <1.131, -12.162, 30.081> <1.131, -12.142, 30.380> 
		<0.613, -12.732, 29.421> <0.613, -12.710, 29.720> <0.613, -12.681, 30.119> <0.613, -12.659, 30.418> 
		<-0.009, -12.732, 29.421> <-0.009, -12.710, 29.720> <-0.009, -12.681, 30.119> <-0.009, -12.659, 30.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.131, -11.595, 29.338> <1.127, -11.599, 29.294> <1.060, -11.611, 29.264> <1.036, -11.615, 29.227> 
		<1.131, -12.216, 29.383> <1.127, -12.219, 29.339> <1.060, -12.180, 29.306> <1.036, -12.184, 29.269> 
		<0.613, -12.732, 29.421> <0.613, -12.710, 29.386> <0.561, -12.677, 29.341> <0.561, -12.658, 29.304> 
		<-0.009, -12.732, 29.421> <-0.009, -12.710, 29.386> <-0.009, -12.677, 29.341> <-0.009, -12.658, 29.304> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.055, -11.615, 29.227> <-1.055, -12.184, 29.269> <-0.580, -12.658, 29.304> <-0.009, -12.658, 29.304> 
		<-1.034, -11.619, 29.195> <-1.034, -12.188, 29.237> <-0.580, -12.640, 29.269> <-0.009, -12.640, 29.269> 
		<-1.041, -11.620, 29.118> <-1.041, -12.161, 29.158> <-0.552, -12.648, 29.194> <-0.009, -12.648, 29.194> 
		<-1.004, -11.619, 29.109> <-1.004, -12.160, 29.149> <-0.552, -12.611, 29.182> <-0.009, -12.611, 29.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.055, -11.615, 29.227> <-1.034, -11.619, 29.195> <-1.041, -11.620, 29.118> <-1.004, -11.619, 29.109> 
		<-1.055, -11.046, 29.186> <-1.034, -11.049, 29.153> <-1.041, -11.078, 29.078> <-1.004, -11.078, 29.070> 
		<-0.580, -10.572, 29.151> <-0.580, -10.596, 29.121> <-0.552, -10.590, 29.043> <-0.552, -10.627, 29.037> 
		<-0.009, -10.572, 29.151> <-0.009, -10.596, 29.121> <-0.009, -10.590, 29.043> <-0.009, -10.627, 29.037> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -10.572, 29.151> <-0.009, -10.596, 29.121> <-0.009, -10.590, 29.043> <-0.009, -10.627, 29.037> 
		<0.561, -10.572, 29.151> <0.561, -10.596, 29.121> <0.534, -10.590, 29.043> <0.534, -10.627, 29.037> 
		<1.036, -11.046, 29.186> <1.016, -11.049, 29.153> <1.023, -11.078, 29.078> <0.985, -11.078, 29.070> 
		<1.036, -11.615, 29.227> <1.016, -11.619, 29.195> <1.023, -11.620, 29.118> <0.985, -11.619, 29.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.036, -11.615, 29.227> <1.016, -11.619, 29.195> <1.023, -11.620, 29.118> <0.985, -11.619, 29.109> 
		<1.036, -12.184, 29.269> <1.016, -12.188, 29.237> <1.023, -12.161, 29.158> <0.985, -12.160, 29.149> 
		<0.561, -12.658, 29.304> <0.561, -12.640, 29.269> <0.534, -12.648, 29.194> <0.534, -12.611, 29.182> 
		<-0.009, -12.658, 29.304> <-0.009, -12.640, 29.269> <-0.009, -12.648, 29.194> <-0.009, -12.611, 29.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.365, -11.608, 29.068> <-0.556, -11.612, 29.081> <-0.816, -11.617, 29.066> <-1.004, -11.619, 29.109> 
		<-0.365, -11.802, 29.083> <-0.556, -11.805, 29.095> <-0.816, -12.159, 29.106> <-1.004, -12.160, 29.149> 
		<-0.203, -11.963, 29.094> <-0.203, -12.157, 29.121> <-0.552, -12.423, 29.126> <-0.552, -12.611, 29.182> 
		<-0.009, -11.963, 29.094> <-0.009, -12.157, 29.121> <-0.009, -12.423, 29.126> <-0.009, -12.611, 29.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.365, -11.608, 29.068> <-0.365, -11.415, 29.054> <-0.203, -11.254, 29.042> <-0.009, -11.254, 29.042> 
		<-0.556, -11.612, 29.081> <-0.556, -11.418, 29.067> <-0.203, -11.066, 29.041> <-0.009, -11.066, 29.041> 
		<-0.816, -11.617, 29.066> <-0.816, -11.076, 29.027> <-0.552, -10.813, 29.007> <-0.009, -10.813, 29.007> 
		<-1.004, -11.619, 29.109> <-1.004, -11.078, 29.070> <-0.552, -10.627, 29.037> <-0.009, -10.627, 29.037> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -11.254, 29.042> <0.185, -11.254, 29.042> <0.346, -11.415, 29.054> <0.346, -11.608, 29.068> 
		<-0.009, -11.066, 29.041> <0.185, -11.066, 29.041> <0.538, -11.418, 29.067> <0.538, -11.612, 29.081> 
		<-0.009, -10.813, 29.007> <0.534, -10.813, 29.007> <0.798, -11.076, 29.027> <0.798, -11.617, 29.066> 
		<-0.009, -10.627, 29.037> <0.534, -10.627, 29.037> <0.985, -11.078, 29.070> <0.985, -11.619, 29.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.346, -11.608, 29.068> <0.346, -11.802, 29.083> <0.185, -11.963, 29.094> <-0.009, -11.963, 29.094> 
		<0.538, -11.612, 29.081> <0.538, -11.805, 29.095> <0.185, -12.157, 29.121> <-0.009, -12.157, 29.121> 
		<0.798, -11.617, 29.066> <0.798, -12.159, 29.106> <0.534, -12.423, 29.126> <-0.009, -12.423, 29.126> 
		<0.985, -11.619, 29.109> <0.985, -12.160, 29.149> <0.534, -12.611, 29.182> <-0.009, -12.611, 29.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.522, 30.335> <-1.149, -11.522, 30.335> <-1.149, -11.522, 30.335> <-1.149, -11.522, 30.335> 
		<-1.149, -10.901, 30.289> <-1.149, -11.522, 30.335> <-1.149, -11.522, 30.335> <-1.149, -12.142, 30.380> 
		<-0.631, -10.385, 30.251> <-0.631, -11.067, 30.302> <-0.631, -11.977, 30.368> <-0.631, -12.659, 30.418> 
		<-0.009, -10.385, 30.251> <-0.009, -11.067, 30.302> <-0.009, -11.977, 30.368> <-0.009, -12.659, 30.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.522, 30.335> <-1.149, -12.142, 30.380> <-0.631, -12.659, 30.418> <-0.009, -12.659, 30.418> 
		<-1.149, -11.519, 30.377> <-1.149, -12.140, 30.422> <-0.631, -12.615, 30.460> <-0.009, -12.615, 30.460> 
		<-1.149, -11.523, 30.433> <-1.149, -12.106, 30.475> <-0.593, -12.550, 30.509> <-0.009, -12.550, 30.509> 
		<-1.149, -11.522, 30.474> <-1.149, -12.104, 30.517> <-0.593, -12.513, 30.556> <-0.009, -12.513, 30.556> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.522, 30.335> <-1.149, -11.519, 30.377> <-1.149, -11.523, 30.433> <-1.149, -11.522, 30.474> 
		<-1.149, -10.901, 30.289> <-1.149, -10.899, 30.331> <-1.149, -10.941, 30.390> <-1.149, -10.939, 30.432> 
		<-0.631, -10.385, 30.251> <-0.631, -10.428, 30.299> <-0.593, -10.495, 30.356> <-0.593, -10.529, 30.410> 
		<-0.009, -10.385, 30.251> <-0.009, -10.428, 30.299> <-0.009, -10.495, 30.356> <-0.009, -10.529, 30.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -10.385, 30.251> <-0.009, -10.385, 30.251> <-0.009, -10.385, 30.251> <-0.009, -10.385, 30.251> 
		<0.613, -10.385, 30.251> <0.613, -11.067, 30.302> <0.613, -11.067, 30.302> <-0.009, -11.067, 30.302> 
		<1.131, -10.901, 30.289> <1.131, -11.522, 30.335> <0.613, -11.977, 30.368> <-0.009, -11.977, 30.368> 
		<1.131, -11.522, 30.335> <1.131, -12.142, 30.380> <0.613, -12.659, 30.418> <-0.009, -12.659, 30.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -10.385, 30.251> <-0.009, -10.428, 30.299> <-0.009, -10.495, 30.356> <-0.009, -10.529, 30.410> 
		<0.613, -10.385, 30.251> <0.613, -10.428, 30.299> <0.575, -10.495, 30.356> <0.575, -10.529, 30.410> 
		<1.131, -10.901, 30.289> <1.131, -10.899, 30.331> <1.131, -10.941, 30.390> <1.131, -10.939, 30.432> 
		<1.131, -11.522, 30.335> <1.131, -11.519, 30.377> <1.131, -11.523, 30.433> <1.131, -11.522, 30.474> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.131, -11.522, 30.335> <1.131, -11.519, 30.377> <1.131, -11.523, 30.433> <1.131, -11.522, 30.474> 
		<1.131, -12.142, 30.380> <1.131, -12.140, 30.422> <1.131, -12.106, 30.475> <1.131, -12.104, 30.517> 
		<0.613, -12.659, 30.418> <0.613, -12.615, 30.460> <0.575, -12.550, 30.509> <0.575, -12.513, 30.556> 
		<-0.009, -12.659, 30.418> <-0.009, -12.615, 30.460> <-0.009, -12.550, 30.509> <-0.009, -12.513, 30.556> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.522, 30.474> <-1.149, -12.104, 30.517> <-0.593, -12.513, 30.556> <-0.009, -12.513, 30.556> 
		<-1.149, -11.520, 30.516> <-1.149, -12.102, 30.559> <-0.593, -12.487, 30.589> <-0.009, -12.487, 30.589> 
		<-1.191, -11.511, 30.608> <-1.191, -12.081, 30.650> <-0.580, -12.493, 30.678> <-0.009, -12.493, 30.678> 
		<-1.149, -11.511, 30.614> <-1.149, -12.080, 30.656> <-0.580, -12.451, 30.683> <-0.009, -12.451, 30.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.149, -11.522, 30.474> <-1.149, -11.520, 30.516> <-1.191, -11.511, 30.608> <-1.149, -11.511, 30.614> 
		<-1.149, -10.939, 30.432> <-1.149, -10.938, 30.473> <-1.191, -10.942, 30.566> <-1.149, -10.942, 30.572> 
		<-0.593, -10.529, 30.410> <-0.593, -10.552, 30.446> <-0.580, -10.530, 30.534> <-0.580, -10.571, 30.545> 
		<-0.009, -10.529, 30.410> <-0.009, -10.552, 30.446> <-0.009, -10.530, 30.534> <-0.009, -10.571, 30.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -10.529, 30.410> <-0.009, -10.552, 30.446> <-0.009, -10.530, 30.534> <-0.009, -10.571, 30.545> 
		<0.575, -10.529, 30.410> <0.575, -10.552, 30.446> <0.562, -10.530, 30.534> <0.562, -10.571, 30.545> 
		<1.131, -10.939, 30.432> <1.131, -10.938, 30.473> <1.172, -10.942, 30.566> <1.131, -10.942, 30.572> 
		<1.131, -11.522, 30.474> <1.131, -11.520, 30.516> <1.172, -11.511, 30.608> <1.131, -11.511, 30.614> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.131, -11.522, 30.474> <1.131, -11.520, 30.516> <1.172, -11.511, 30.608> <1.131, -11.511, 30.614> 
		<1.131, -12.104, 30.517> <1.131, -12.102, 30.559> <1.172, -12.081, 30.650> <1.131, -12.080, 30.656> 
		<0.575, -12.513, 30.556> <0.575, -12.487, 30.589> <0.562, -12.493, 30.678> <0.562, -12.451, 30.683> 
		<-0.009, -12.513, 30.556> <-0.009, -12.487, 30.589> <-0.009, -12.493, 30.678> <-0.009, -12.451, 30.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, -11.512, 30.605> <-0.492, -11.512, 30.608> <-0.870, -11.508, 30.653> <-1.149, -11.511, 30.614> 
		<-0.211, -11.650, 30.615> <-0.492, -11.650, 30.618> <-0.870, -12.077, 30.694> <-1.149, -12.080, 30.656> 
		<-0.148, -11.807, 30.635> <-0.148, -12.000, 30.650> <-0.580, -12.258, 30.704> <-0.580, -12.451, 30.683> 
		<-0.009, -11.807, 30.635> <-0.009, -12.000, 30.650> <-0.009, -12.258, 30.704> <-0.009, -12.451, 30.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, -11.512, 30.605> <-0.211, -11.374, 30.595> <-0.148, -11.215, 30.592> <-0.009, -11.215, 30.592> 
		<-0.492, -11.512, 30.608> <-0.492, -11.373, 30.597> <-0.148, -11.022, 30.578> <-0.009, -11.022, 30.578> 
		<-0.870, -11.508, 30.653> <-0.870, -10.939, 30.611> <-0.580, -10.759, 30.594> <-0.009, -10.759, 30.594> 
		<-1.149, -11.511, 30.614> <-1.149, -10.942, 30.572> <-0.580, -10.571, 30.545> <-0.009, -10.571, 30.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -11.215, 30.592> <0.129, -11.215, 30.592> <0.192, -11.374, 30.595> <0.192, -11.512, 30.605> 
		<-0.009, -11.022, 30.578> <0.129, -11.022, 30.578> <0.474, -11.373, 30.597> <0.474, -11.512, 30.608> 
		<-0.009, -10.759, 30.594> <0.562, -10.759, 30.594> <0.852, -10.939, 30.611> <0.852, -11.508, 30.653> 
		<-0.009, -10.571, 30.545> <0.562, -10.571, 30.545> <1.131, -10.942, 30.572> <1.131, -11.511, 30.614> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.192, -11.512, 30.605> <0.192, -11.650, 30.615> <0.129, -11.807, 30.635> <-0.009, -11.807, 30.635> 
		<0.474, -11.512, 30.608> <0.474, -11.650, 30.618> <0.129, -12.000, 30.650> <-0.009, -12.000, 30.650> 
		<0.852, -11.508, 30.653> <0.852, -12.077, 30.694> <0.562, -12.258, 30.704> <-0.009, -12.258, 30.704> 
		<1.131, -11.511, 30.614> <1.131, -12.080, 30.656> <0.562, -12.451, 30.683> <-0.009, -12.451, 30.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.013, -9.760, 65.323> <0.013, -9.824, 64.823> <0.012, -9.763, 64.146> <0.012, -9.764, 63.642> 
		<-0.387, -9.761, 65.323> <-0.387, -9.825, 64.823> <-0.387, -9.764, 64.147> <-0.388, -9.765, 63.643> 
		<-0.719, -10.095, 65.323> <-0.706, -10.150, 64.821> <-0.719, -10.098, 64.146> <-0.719, -10.099, 63.641> 
		<-0.717, -10.495, 65.323> <-0.705, -10.550, 64.821> <-0.718, -10.497, 64.144> <-0.718, -10.498, 63.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.013, -9.760, 65.323> <-0.387, -9.761, 65.323> <-0.719, -10.095, 65.323> <-0.717, -10.495, 65.323> 
		<0.013, -9.694, 65.843> <-0.387, -9.695, 65.843> <-0.733, -10.028, 65.935> <-0.732, -10.428, 65.935> 
		<0.012, -9.549, 66.540> <-0.436, -9.551, 66.540> <-0.790, -9.916, 66.593> <-0.789, -10.330, 66.764> 
		<0.012, -9.333, 67.018> <-0.437, -9.334, 67.018> <-0.809, -9.681, 67.161> <-0.808, -10.095, 67.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.013, -9.760, 65.323> <0.413, -9.759, 65.323> <0.747, -10.091, 65.323> <0.748, -10.491, 65.323> 
		<0.013, -9.824, 64.823> <0.413, -9.823, 64.823> <0.734, -10.146, 64.820> <0.735, -10.546, 64.820> 
		<0.012, -9.763, 64.146> <0.412, -9.762, 64.146> <0.746, -10.094, 64.145> <0.747, -10.493, 64.143> 
		<0.012, -9.764, 63.642> <0.412, -9.763, 63.641> <0.746, -10.095, 63.639> <0.747, -10.495, 63.636> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.013, -9.760, 65.323> <0.013, -9.694, 65.843> <0.012, -9.549, 66.540> <0.012, -9.333, 67.018> 
		<0.413, -9.759, 65.323> <0.413, -9.693, 65.843> <0.461, -9.548, 66.540> <0.461, -9.332, 67.018> 
		<0.747, -10.091, 65.323> <0.761, -10.024, 65.935> <0.817, -9.911, 66.593> <0.835, -9.676, 67.161> 
		<0.748, -10.491, 65.323> <0.763, -10.424, 65.935> <0.819, -10.326, 66.764> <0.836, -10.090, 67.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.748, -10.491, 65.323> <0.749, -10.890, 65.323> <0.417, -11.224, 65.323> <0.017, -11.225, 65.323> 
		<0.735, -10.546, 64.820> <0.737, -10.945, 64.820> <0.417, -11.272, 64.818> <0.017, -11.273, 64.818> 
		<0.747, -10.493, 64.143> <0.748, -10.893, 64.140> <0.416, -11.227, 64.139> <0.016, -11.228, 64.140> 
		<0.747, -10.495, 63.636> <0.748, -10.894, 63.634> <0.416, -11.228, 63.632> <0.016, -11.229, 63.633> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.748, -10.491, 65.323> <0.763, -10.424, 65.935> <0.819, -10.326, 66.764> <0.836, -10.090, 67.332> 
		<0.749, -10.890, 65.323> <0.764, -10.824, 65.935> <0.820, -10.740, 66.936> <0.838, -10.505, 67.504> 
		<0.417, -11.224, 65.323> <0.417, -11.158, 66.026> <0.466, -11.106, 66.988> <0.465, -10.851, 67.647> 
		<0.017, -11.225, 65.323> <0.017, -11.159, 66.026> <0.017, -11.107, 66.988> <0.016, -10.852, 67.647> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.017, -11.225, 65.323> <-0.383, -11.226, 65.323> <-0.716, -10.895, 65.323> <-0.717, -10.495, 65.323> 
		<0.017, -11.273, 64.818> <-0.383, -11.274, 64.818> <-0.704, -10.950, 64.821> <-0.705, -10.550, 64.821> 
		<0.016, -11.228, 64.140> <-0.383, -11.229, 64.141> <-0.717, -10.897, 64.141> <-0.718, -10.497, 64.144> 
		<0.016, -11.229, 63.633> <-0.384, -11.230, 63.633> <-0.717, -10.898, 63.636> <-0.718, -10.498, 63.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.017, -11.225, 65.323> <0.017, -11.159, 66.026> <0.017, -11.107, 66.988> <0.016, -10.852, 67.647> 
		<-0.383, -11.226, 65.323> <-0.383, -11.161, 66.026> <-0.432, -11.108, 66.988> <-0.432, -10.854, 67.647> 
		<-0.716, -10.895, 65.323> <-0.731, -10.828, 65.935> <-0.788, -10.745, 66.936> <-0.807, -10.510, 67.504> 
		<-0.717, -10.495, 65.323> <-0.732, -10.428, 65.935> <-0.789, -10.330, 66.764> <-0.808, -10.095, 67.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.012, -9.333, 67.018> <-0.437, -9.334, 67.018> <-0.809, -9.681, 67.161> <-0.808, -10.095, 67.332> 
		<0.011, -9.120, 67.488> <-0.438, -9.121, 67.488> <-0.828, -9.445, 67.728> <-0.827, -9.860, 67.900> 
		<0.010, -8.722, 68.073> <-0.455, -8.724, 68.073> <-0.833, -9.063, 68.272> <-0.832, -9.392, 68.601> 
		<0.009, -8.352, 68.433> <-0.456, -8.353, 68.433> <-0.843, -8.628, 68.707> <-0.842, -8.957, 69.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.012, -9.333, 67.018> <0.011, -9.120, 67.488> <0.010, -8.722, 68.073> <0.009, -8.352, 68.433> 
		<0.461, -9.332, 67.018> <0.460, -9.119, 67.488> <0.475, -8.721, 68.073> <0.474, -8.351, 68.433> 
		<0.835, -9.676, 67.161> <0.853, -9.441, 67.728> <0.856, -9.058, 68.272> <0.862, -8.623, 68.707> 
		<0.836, -10.090, 67.332> <0.854, -9.855, 67.900> <0.857, -9.387, 68.601> <0.863, -8.952, 69.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.009, -8.352, 68.433> <-0.456, -8.353, 68.433> <-0.843, -8.628, 68.707> <-0.842, -8.957, 69.036> 
		<0.008, -7.984, 68.791> <-0.457, -7.985, 68.791> <-0.852, -8.194, 69.141> <-0.851, -8.523, 69.470> 
		<0.006, -7.393, 69.172> <-0.471, -7.394, 69.172> <-0.864, -7.639, 69.498> <-0.864, -7.822, 69.938> 
		<0.005, -6.917, 69.366> <-0.472, -6.918, 69.366> <-0.869, -7.071, 69.733> <-0.869, -7.254, 70.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.009, -8.352, 68.433> <0.008, -7.984, 68.791> <0.006, -7.393, 69.172> <0.005, -6.917, 69.366> 
		<0.474, -8.351, 68.433> <0.473, -7.982, 68.791> <0.483, -7.391, 69.172> <0.482, -6.916, 69.366> 
		<0.862, -8.623, 68.707> <0.869, -8.189, 69.141> <0.878, -7.634, 69.498> <0.880, -7.066, 69.733> 
		<0.863, -8.952, 69.036> <0.870, -8.518, 69.470> <0.878, -7.817, 69.938> <0.880, -7.249, 70.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, -6.917, 69.366> <-0.472, -6.918, 69.366> <-0.869, -7.071, 69.733> <-0.869, -7.254, 70.174> 
		<0.003, -6.443, 69.559> <-0.474, -6.444, 69.559> <-0.874, -6.504, 69.968> <-0.874, -6.686, 70.409> 
		<0.001, -5.755, 69.699> <-0.476, -5.756, 69.699> <-0.873, -5.860, 70.096> <-0.873, -5.860, 70.573> 
		<0.000, -5.242, 69.699> <-0.477, -5.244, 69.699> <-0.874, -5.245, 70.096> <-0.874, -5.245, 70.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, -6.917, 69.366> <0.003, -6.443, 69.559> <0.001, -5.755, 69.699> <0.000, -5.242, 69.699> 
		<0.482, -6.916, 69.366> <0.481, -6.441, 69.559> <0.479, -5.753, 69.699> <0.477, -5.241, 69.699> 
		<0.880, -7.066, 69.733> <0.881, -6.499, 69.968> <0.876, -5.854, 70.096> <0.874, -5.240, 70.096> 
		<0.880, -7.249, 70.174> <0.882, -6.681, 70.409> <0.876, -5.854, 70.573> <0.874, -5.240, 70.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -5.242, 69.699> <-0.477, -5.244, 69.699> <-0.874, -5.245, 70.096> <-0.874, -5.245, 70.573> 
		<-0.001, -4.730, 69.699> <-0.479, -4.732, 69.699> <-0.876, -4.630, 70.096> <-0.876, -4.630, 70.573> 
		<-0.003, -4.041, 69.562> <-0.481, -4.043, 69.562> <-0.878, -3.986, 69.968> <-0.879, -3.804, 70.409> 
		<-0.005, -3.568, 69.366> <-0.482, -3.569, 69.366> <-0.880, -3.419, 69.733> <-0.880, -3.236, 70.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -5.242, 69.699> <-0.001, -4.730, 69.699> <-0.003, -4.041, 69.562> <-0.005, -3.568, 69.366> 
		<0.477, -5.241, 69.699> <0.476, -4.729, 69.699> <0.474, -4.040, 69.562> <0.472, -3.567, 69.366> 
		<0.874, -5.240, 70.096> <0.873, -4.625, 70.096> <0.871, -3.981, 69.968> <0.869, -3.413, 69.733> 
		<0.874, -5.240, 70.573> <0.873, -4.625, 70.573> <0.870, -3.799, 70.409> <0.869, -3.231, 70.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, -3.568, 69.366> <-0.482, -3.569, 69.366> <-0.880, -3.419, 69.733> <-0.880, -3.236, 70.174> 
		<-0.006, -3.095, 69.170> <-0.483, -3.096, 69.170> <-0.881, -2.851, 69.498> <-0.882, -2.668, 69.938> 
		<-0.008, -2.511, 68.779> <-0.485, -2.512, 68.779> <-0.883, -2.305, 69.133> <-0.884, -1.967, 69.470> 
		<-0.009, -2.148, 68.417> <-0.486, -2.150, 68.417> <-0.884, -1.870, 68.698> <-0.885, -1.533, 69.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, -3.568, 69.366> <-0.006, -3.095, 69.170> <-0.008, -2.511, 68.779> <-0.009, -2.148, 68.417> 
		<0.472, -3.567, 69.366> <0.471, -3.093, 69.170> <0.469, -2.509, 68.779> <0.468, -2.147, 68.417> 
		<0.869, -3.413, 69.733> <0.867, -2.846, 69.498> <0.866, -2.300, 69.133> <0.865, -1.865, 68.698> 
		<0.869, -3.231, 70.174> <0.867, -2.663, 69.938> <0.865, -1.962, 69.470> <0.864, -1.528, 69.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -2.148, 68.417> <-0.486, -2.150, 68.417> <-0.884, -1.870, 68.698> <-0.885, -1.533, 69.036> 
		<-0.010, -1.786, 68.055> <-0.487, -1.788, 68.055> <-0.885, -1.436, 68.264> <-0.886, -1.098, 68.601> 
		<-0.011, -1.388, 67.474> <-0.488, -1.390, 67.474> <-0.878, -1.071, 67.717> <-0.879, -0.630, 67.900> 
		<-0.012, -1.200, 66.998> <-0.489, -1.201, 66.998> <-0.887, -0.836, 67.150> <-0.888, -0.395, 67.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -2.148, 68.417> <-0.010, -1.786, 68.055> <-0.011, -1.388, 67.474> <-0.012, -1.200, 66.998> 
		<0.468, -2.147, 68.417> <0.467, -1.785, 68.055> <0.466, -1.387, 67.474> <0.465, -1.199, 66.998> 
		<0.865, -1.865, 68.698> <0.863, -1.431, 68.264> <0.854, -1.066, 67.717> <0.862, -0.830, 67.150> 
		<0.864, -1.528, 69.036> <0.862, -1.093, 68.601> <0.852, -0.625, 67.900> <0.860, -0.390, 67.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.012, -1.200, 66.998> <-0.489, -1.201, 66.998> <-0.887, -0.836, 67.150> <-0.888, -0.395, 67.332> 
		<-0.012, -1.012, 66.524> <-0.490, -1.014, 66.524> <-0.896, -0.600, 66.582> <-0.898, -0.159, 66.764> 
		<-0.013, -0.965, 65.831> <-0.520, -0.966, 65.831> <-0.935, -0.569, 65.934> <-0.937, -0.061, 65.934> 
		<-0.013, -0.923, 65.323> <-0.520, -0.925, 65.323> <-0.944, -0.503, 65.323> <-0.946, 0.005, 65.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.012, -1.200, 66.998> <-0.012, -1.012, 66.524> <-0.013, -0.965, 65.831> <-0.013, -0.923, 65.323> 
		<0.465, -1.199, 66.998> <0.465, -1.011, 66.524> <0.495, -0.963, 65.831> <0.495, -0.922, 65.323> 
		<0.862, -0.830, 67.150> <0.869, -0.595, 66.582> <0.908, -0.563, 65.934> <0.917, -0.498, 65.323> 
		<0.860, -0.390, 67.332> <0.868, -0.154, 66.764> <0.906, -0.055, 65.934> <0.915, 0.010, 65.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, -0.923, 65.323> <-0.520, -0.925, 65.323> <-0.944, -0.503, 65.323> <-0.946, 0.005, 65.323> 
		<-0.013, -0.880, 64.799> <-0.520, -0.882, 64.799> <-0.952, -0.447, 64.796> <-0.954, 0.061, 64.796> 
		<-0.012, -0.920, 64.096> <-0.520, -0.921, 64.096> <-0.944, -0.500, 64.093> <-0.945, 0.008, 64.086> 
		<-0.012, -0.918, 63.570> <-0.519, -0.920, 63.570> <-0.943, -0.498, 63.563> <-0.945, 0.010, 63.556> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, -0.923, 65.323> <-0.013, -0.880, 64.799> <-0.012, -0.920, 64.096> <-0.012, -0.918, 63.570> 
		<0.495, -0.922, 65.323> <0.495, -0.879, 64.799> <0.496, -0.918, 64.097> <0.496, -0.917, 63.571> 
		<0.917, -0.498, 65.323> <0.925, -0.441, 64.797> <0.917, -0.495, 64.095> <0.918, -0.493, 63.565> 
		<0.915, 0.010, 65.323> <0.923, 0.066, 64.797> <0.916, 0.013, 64.087> <0.916, 0.015, 63.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.836, -10.090, 67.332> <0.854, -9.855, 67.900> <0.857, -9.387, 68.601> <0.863, -8.952, 69.036> 
		<0.838, -10.505, 67.504> <0.855, -10.270, 68.072> <0.858, -9.716, 68.930> <0.864, -9.281, 69.365> 
		<0.465, -10.851, 67.647> <0.464, -10.594, 68.312> <0.479, -10.055, 69.129> <0.478, -9.556, 69.638> 
		<0.016, -10.852, 67.647> <0.016, -10.596, 68.312> <0.014, -10.056, 69.129> <0.013, -9.558, 69.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.863, -8.952, 69.036> <0.870, -8.518, 69.470> <0.878, -7.817, 69.938> <0.880, -7.249, 70.174> 
		<0.864, -9.281, 69.365> <0.871, -8.847, 69.799> <0.879, -7.999, 70.379> <0.881, -7.432, 70.615> 
		<0.478, -9.556, 69.638> <0.476, -9.055, 70.150> <0.486, -8.245, 70.705> <0.484, -7.585, 70.981> 
		<0.013, -9.558, 69.638> <0.011, -9.057, 70.150> <0.009, -8.246, 70.705> <0.007, -7.586, 70.981> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.880, -7.249, 70.174> <0.882, -6.681, 70.409> <0.876, -5.854, 70.573> <0.874, -5.240, 70.573> 
		<0.881, -7.432, 70.615> <0.882, -6.864, 70.850> <0.876, -5.854, 71.050> <0.874, -5.240, 71.050> 
		<0.484, -7.585, 70.981> <0.482, -6.924, 71.259> <0.479, -5.958, 71.448> <0.477, -5.241, 71.448> 
		<0.007, -7.586, 70.981> <0.005, -6.925, 71.259> <0.002, -5.959, 71.448> <0.000, -5.242, 71.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.874, -5.240, 70.573> <0.873, -4.625, 70.573> <0.870, -3.799, 70.409> <0.869, -3.231, 70.174> 
		<0.874, -5.240, 71.050> <0.873, -4.625, 71.050> <0.870, -3.616, 70.850> <0.868, -3.048, 70.615> 
		<0.477, -5.241, 71.448> <0.475, -4.524, 71.448> <0.472, -3.560, 71.256> <0.470, -2.897, 70.981> 
		<0.000, -5.242, 71.448> <-0.002, -4.526, 71.448> <-0.005, -3.561, 71.256> <-0.007, -2.899, 70.981> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.869, -3.231, 70.174> <0.867, -2.663, 69.938> <0.865, -1.962, 69.470> <0.864, -1.528, 69.036> 
		<0.868, -3.048, 70.615> <0.866, -2.480, 70.379> <0.864, -1.625, 69.808> <0.863, -1.190, 69.373> 
		<0.470, -2.897, 70.981> <0.468, -2.235, 70.707> <0.466, -1.417, 70.161> <0.465, -0.911, 69.654> 
		<-0.007, -2.899, 70.981> <-0.009, -2.236, 70.707> <-0.011, -1.419, 70.161> <-0.013, -0.912, 69.654> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.864, -1.528, 69.036> <0.862, -1.093, 68.601> <0.852, -0.625, 67.900> <0.860, -0.390, 67.332> 
		<0.863, -1.190, 69.373> <0.861, -0.756, 68.938> <0.851, -0.184, 68.083> <0.859, 0.051, 67.515> 
		<0.465, -0.911, 69.654> <0.463, -0.404, 69.147> <0.462, 0.135, 68.326> <0.461, 0.417, 67.667> 
		<-0.013, -0.912, 69.654> <-0.014, -0.405, 69.147> <-0.016, 0.134, 68.326> <-0.016, 0.416, 67.667> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.860, -0.390, 67.332> <0.868, -0.154, 66.764> <0.906, -0.055, 65.934> <0.915, 0.010, 65.323> 
		<0.859, 0.051, 67.515> <0.867, 0.287, 66.947> <0.905, 0.453, 65.934> <0.914, 0.518, 65.323> 
		<0.461, 0.417, 67.667> <0.460, 0.700, 67.005> <0.490, 0.848, 66.038> <0.490, 0.939, 65.323> 
		<-0.016, 0.416, 67.667> <-0.017, 0.699, 67.005> <-0.018, 0.847, 66.038> <-0.018, 0.938, 65.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.915, 0.010, 65.323> <0.923, 0.066, 64.797> <0.916, 0.013, 64.087> <0.916, 0.015, 63.558> 
		<0.914, 0.518, 65.323> <0.922, 0.574, 64.797> <0.915, 0.521, 64.080> <0.915, 0.522, 63.550> 
		<0.490, 0.939, 65.323> <0.490, 1.007, 64.793> <0.491, 0.943, 64.077> <0.491, 0.944, 63.543> 
		<-0.018, 0.938, 65.323> <-0.018, 1.006, 64.793> <-0.017, 0.941, 64.077> <-0.017, 0.943, 63.543> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.016, -10.852, 67.647> <0.016, -10.596, 68.312> <0.014, -10.056, 69.129> <0.013, -9.558, 69.638> 
		<-0.432, -10.854, 67.647> <-0.433, -10.597, 68.312> <-0.451, -10.058, 69.129> <-0.453, -9.559, 69.638> 
		<-0.807, -10.510, 67.504> <-0.826, -10.275, 68.072> <-0.832, -9.721, 68.930> <-0.841, -9.286, 69.365> 
		<-0.808, -10.095, 67.332> <-0.827, -9.860, 67.900> <-0.832, -9.392, 68.601> <-0.842, -8.957, 69.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.013, -9.558, 69.638> <0.011, -9.057, 70.150> <0.009, -8.246, 70.705> <0.007, -7.586, 70.981> 
		<-0.453, -9.559, 69.638> <-0.454, -9.058, 70.150> <-0.468, -8.247, 70.705> <-0.470, -7.588, 70.981> 
		<-0.841, -9.286, 69.365> <-0.850, -8.852, 69.799> <-0.863, -8.004, 70.379> <-0.868, -7.437, 70.615> 
		<-0.842, -8.957, 69.036> <-0.851, -8.523, 69.470> <-0.864, -7.822, 69.938> <-0.869, -7.254, 70.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.007, -7.586, 70.981> <0.005, -6.925, 71.259> <0.002, -5.959, 71.448> <0.000, -5.242, 71.448> 
		<-0.470, -7.588, 70.981> <-0.472, -6.926, 71.259> <-0.475, -5.961, 71.448> <-0.477, -5.244, 71.448> 
		<-0.868, -7.437, 70.615> <-0.873, -6.869, 70.850> <-0.873, -5.860, 71.050> <-0.874, -5.245, 71.050> 
		<-0.869, -7.254, 70.174> <-0.874, -6.686, 70.409> <-0.873, -5.860, 70.573> <-0.874, -5.245, 70.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -5.242, 71.448> <-0.002, -4.526, 71.448> <-0.005, -3.561, 71.256> <-0.007, -2.899, 70.981> 
		<-0.477, -5.244, 71.448> <-0.479, -4.527, 71.448> <-0.482, -3.562, 71.256> <-0.484, -2.900, 70.981> 
		<-0.874, -5.245, 71.050> <-0.876, -4.630, 71.050> <-0.879, -3.621, 70.850> <-0.881, -3.053, 70.615> 
		<-0.874, -5.245, 70.573> <-0.876, -4.630, 70.573> <-0.879, -3.804, 70.409> <-0.880, -3.236, 70.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.007, -2.899, 70.981> <-0.009, -2.236, 70.707> <-0.011, -1.419, 70.161> <-0.013, -0.912, 69.654> 
		<-0.484, -2.900, 70.981> <-0.486, -2.238, 70.707> <-0.488, -1.420, 70.161> <-0.490, -0.913, 69.654> 
		<-0.881, -3.053, 70.615> <-0.882, -2.486, 70.379> <-0.885, -1.630, 69.808> <-0.886, -1.195, 69.373> 
		<-0.880, -3.236, 70.174> <-0.882, -2.668, 69.938> <-0.884, -1.967, 69.470> <-0.885, -1.533, 69.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, -0.912, 69.654> <-0.014, -0.405, 69.147> <-0.016, 0.134, 68.326> <-0.016, 0.416, 67.667> 
		<-0.490, -0.913, 69.654> <-0.491, -0.406, 69.147> <-0.493, 0.133, 68.326> <-0.494, 0.414, 67.667> 
		<-0.886, -1.195, 69.373> <-0.887, -0.761, 68.938> <-0.880, -0.189, 68.083> <-0.890, 0.046, 67.515> 
		<-0.885, -1.533, 69.036> <-0.886, -1.098, 68.601> <-0.879, -0.630, 67.900> <-0.888, -0.395, 67.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 0.416, 67.667> <-0.017, 0.699, 67.005> <-0.018, 0.847, 66.038> <-0.018, 0.938, 65.323> 
		<-0.494, 0.414, 67.667> <-0.494, 0.697, 67.005> <-0.526, 0.845, 66.038> <-0.526, 0.936, 65.323> 
		<-0.890, 0.046, 67.515> <-0.899, 0.281, 66.947> <-0.938, 0.447, 65.934> <-0.947, 0.513, 65.323> 
		<-0.888, -0.395, 67.332> <-0.898, -0.159, 66.764> <-0.937, -0.061, 65.934> <-0.946, 0.005, 65.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.018, 0.938, 65.323> <-0.018, 1.006, 64.793> <-0.017, 0.941, 64.077> <-0.017, 0.943, 63.543> 
		<-0.526, 0.936, 65.323> <-0.526, 1.004, 64.793> <-0.525, 0.940, 64.076> <-0.524, 0.941, 63.542> 
		<-0.947, 0.513, 65.323> <-0.955, 0.569, 64.796> <-0.946, 0.516, 64.078> <-0.946, 0.517, 63.548> 
		<-0.946, 0.005, 65.323> <-0.954, 0.061, 64.796> <-0.945, 0.008, 64.086> <-0.945, 0.010, 63.556> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 9.972, 0.000> <0.000, 10.014, -0.029> <0.000, 10.086, -0.069> <0.000, 10.135, -0.053> 
		<-2.289, 9.972, 0.000> <-2.289, 10.014, -0.029> <-2.327, 10.086, -0.069> <-2.327, 10.135, -0.053> 
		<-5.431, 8.669, 0.000> <-5.461, 8.699, -0.029> <-5.486, 8.776, -0.069> <-5.520, 8.811, -0.053> 
		<-7.050, 7.050, 0.000> <-7.080, 7.080, -0.029> <-7.131, 7.131, -0.069> <-7.166, 7.166, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 9.972, 0.000> <2.289, 9.972, 0.000> <5.431, 8.669, 0.000> <7.050, 7.050, 0.000> 
		<0.000, 10.014, -0.029> <2.289, 10.014, -0.029> <5.461, 8.699, -0.029> <7.080, 7.080, -0.029> 
		<0.000, 10.086, -0.069> <2.327, 10.086, -0.069> <5.486, 8.776, -0.069> <7.131, 7.131, -0.069> 
		<0.000, 10.135, -0.053> <2.327, 10.135, -0.053> <5.520, 8.811, -0.053> <7.166, 7.166, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.050, 7.050, 0.000> <8.669, 5.431, 0.000> <9.972, 2.289, 0.000> <9.972, 0.000, 0.000> 
		<7.080, 7.080, -0.029> <8.699, 5.461, -0.029> <10.014, 2.289, -0.029> <10.014, 0.000, -0.029> 
		<7.131, 7.131, -0.069> <8.776, 5.486, -0.069> <10.086, 2.327, -0.069> <10.086, 0.000, -0.069> 
		<7.166, 7.166, -0.053> <8.811, 5.520, -0.053> <10.135, 2.327, -0.053> <10.135, 0.000, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.972, 0.000, 0.000> <9.972, -2.289, 0.000> <8.669, -5.431, 0.000> <7.050, -7.050, 0.000> 
		<10.014, 0.000, -0.029> <10.014, -2.289, -0.029> <8.699, -5.461, -0.029> <7.080, -7.080, -0.029> 
		<10.086, 0.000, -0.069> <10.086, -2.327, -0.069> <8.776, -5.486, -0.069> <7.131, -7.131, -0.069> 
		<10.135, 0.000, -0.053> <10.135, -2.327, -0.053> <8.811, -5.520, -0.053> <7.166, -7.166, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.050, -7.050, 0.000> <5.431, -8.669, 0.000> <2.289, -9.972, 0.000> <0.000, -9.972, 0.000> 
		<7.080, -7.080, -0.029> <5.461, -8.699, -0.029> <2.289, -10.014, -0.029> <0.000, -10.014, -0.029> 
		<7.131, -7.131, -0.069> <5.486, -8.776, -0.069> <2.327, -10.086, -0.069> <0.000, -10.086, -0.069> 
		<7.166, -7.166, -0.053> <5.520, -8.811, -0.053> <2.327, -10.135, -0.053> <0.000, -10.135, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -9.972, 0.000> <-2.289, -9.972, 0.000> <-5.431, -8.669, 0.000> <-7.050, -7.050, 0.000> 
		<0.000, -10.014, -0.029> <-2.289, -10.014, -0.029> <-5.461, -8.699, -0.029> <-7.080, -7.080, -0.029> 
		<0.000, -10.086, -0.069> <-2.327, -10.086, -0.069> <-5.486, -8.776, -0.069> <-7.131, -7.131, -0.069> 
		<0.000, -10.135, -0.053> <-2.327, -10.135, -0.053> <-5.520, -8.811, -0.053> <-7.166, -7.166, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.050, -7.050, 0.000> <-8.669, -5.431, 0.000> <-9.972, -2.289, 0.000> <-9.972, 0.000, 0.000> 
		<-7.080, -7.080, -0.029> <-8.699, -5.461, -0.029> <-10.014, -2.289, -0.029> <-10.014, 0.000, -0.029> 
		<-7.131, -7.131, -0.069> <-8.776, -5.486, -0.069> <-10.086, -2.327, -0.069> <-10.086, 0.000, -0.069> 
		<-7.166, -7.166, -0.053> <-8.811, -5.520, -0.053> <-10.135, -2.327, -0.053> <-10.135, 0.000, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.972, 0.000, 0.000> <-9.972, 2.289, 0.000> <-8.669, 5.431, 0.000> <-7.050, 7.050, 0.000> 
		<-10.014, 0.000, -0.029> <-10.014, 2.289, -0.029> <-8.699, 5.461, -0.029> <-7.080, 7.080, -0.029> 
		<-10.086, 0.000, -0.069> <-10.086, 2.327, -0.069> <-8.776, 5.486, -0.069> <-7.131, 7.131, -0.069> 
		<-10.135, 0.000, -0.053> <-10.135, 2.327, -0.053> <-8.811, 5.520, -0.053> <-7.166, 7.166, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 10.135, -0.053> <0.000, 10.201, -0.032> <0.000, 10.302, 0.037> <0.000, 10.301, 0.106> 
		<-2.327, 10.135, -0.053> <-2.327, 10.201, -0.032> <-2.365, 10.302, 0.037> <-2.365, 10.301, 0.106> 
		<-5.520, 8.811, -0.053> <-5.567, 8.858, -0.032> <-5.611, 8.956, 0.037> <-5.611, 8.955, 0.106> 
		<-7.166, 7.166, -0.053> <-7.212, 7.212, -0.032> <-7.283, 7.283, 0.037> <-7.283, 7.283, 0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 10.135, -0.053> <2.327, 10.135, -0.053> <5.520, 8.811, -0.053> <7.166, 7.166, -0.053> 
		<0.000, 10.201, -0.032> <2.327, 10.201, -0.032> <5.567, 8.858, -0.032> <7.212, 7.212, -0.032> 
		<0.000, 10.302, 0.037> <2.365, 10.302, 0.037> <5.611, 8.956, 0.037> <7.283, 7.283, 0.037> 
		<0.000, 10.301, 0.106> <2.365, 10.301, 0.106> <5.611, 8.955, 0.106> <7.283, 7.283, 0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.166, 7.166, -0.053> <8.811, 5.520, -0.053> <10.135, 2.327, -0.053> <10.135, 0.000, -0.053> 
		<7.212, 7.212, -0.032> <8.858, 5.567, -0.032> <10.201, 2.327, -0.032> <10.201, 0.000, -0.032> 
		<7.283, 7.283, 0.037> <8.956, 5.611, 0.037> <10.302, 2.365, 0.037> <10.302, 0.000, 0.037> 
		<7.283, 7.283, 0.106> <8.955, 5.611, 0.106> <10.301, 2.365, 0.106> <10.301, 0.000, 0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.135, 0.000, -0.053> <10.135, -2.327, -0.053> <8.811, -5.520, -0.053> <7.166, -7.166, -0.053> 
		<10.201, 0.000, -0.032> <10.201, -2.327, -0.032> <8.858, -5.567, -0.032> <7.212, -7.212, -0.032> 
		<10.302, 0.000, 0.037> <10.302, -2.365, 0.037> <8.956, -5.611, 0.037> <7.283, -7.283, 0.037> 
		<10.301, 0.000, 0.106> <10.301, -2.365, 0.106> <8.955, -5.611, 0.106> <7.283, -7.283, 0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.166, -7.166, -0.053> <5.520, -8.811, -0.053> <2.327, -10.135, -0.053> <0.000, -10.135, -0.053> 
		<7.212, -7.212, -0.032> <5.567, -8.858, -0.032> <2.327, -10.201, -0.032> <0.000, -10.201, -0.032> 
		<7.283, -7.283, 0.037> <5.611, -8.956, 0.037> <2.365, -10.302, 0.037> <0.000, -10.302, 0.037> 
		<7.283, -7.283, 0.106> <5.611, -8.955, 0.106> <2.365, -10.301, 0.106> <0.000, -10.301, 0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -10.135, -0.053> <-2.327, -10.135, -0.053> <-5.520, -8.811, -0.053> <-7.166, -7.166, -0.053> 
		<0.000, -10.201, -0.032> <-2.327, -10.201, -0.032> <-5.567, -8.858, -0.032> <-7.212, -7.212, -0.032> 
		<0.000, -10.302, 0.037> <-2.365, -10.302, 0.037> <-5.611, -8.956, 0.037> <-7.283, -7.283, 0.037> 
		<0.000, -10.301, 0.106> <-2.365, -10.301, 0.106> <-5.611, -8.955, 0.106> <-7.283, -7.283, 0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.166, -7.166, -0.053> <-8.811, -5.520, -0.053> <-10.135, -2.327, -0.053> <-10.135, 0.000, -0.053> 
		<-7.212, -7.212, -0.032> <-8.858, -5.567, -0.032> <-10.201, -2.327, -0.032> <-10.201, 0.000, -0.032> 
		<-7.283, -7.283, 0.037> <-8.956, -5.611, 0.037> <-10.302, -2.365, 0.037> <-10.302, 0.000, 0.037> 
		<-7.283, -7.283, 0.106> <-8.955, -5.611, 0.106> <-10.301, -2.365, 0.106> <-10.301, 0.000, 0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.135, 0.000, -0.053> <-10.135, 2.327, -0.053> <-8.811, 5.520, -0.053> <-7.166, 7.166, -0.053> 
		<-10.201, 0.000, -0.032> <-10.201, 2.327, -0.032> <-8.858, 5.567, -0.032> <-7.212, 7.212, -0.032> 
		<-10.302, 0.000, 0.037> <-10.302, 2.365, 0.037> <-8.956, 5.611, 0.037> <-7.283, 7.283, 0.037> 
		<-10.301, 0.000, 0.106> <-10.301, 2.365, 0.106> <-8.955, 5.611, 0.106> <-7.283, 7.283, 0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 10.301, 0.106> <0.000, 10.301, 0.179> <0.000, 10.206, 0.286> <0.000, 10.133, 0.282> 
		<-2.365, 10.301, 0.106> <-2.365, 10.301, 0.179> <-2.326, 10.206, 0.286> <-2.326, 10.133, 0.282> 
		<-5.611, 8.955, 0.106> <-5.610, 8.955, 0.179> <-5.571, 8.861, 0.286> <-5.519, 8.809, 0.282> 
		<-7.283, 7.283, 0.106> <-7.283, 7.283, 0.179> <-7.216, 7.216, 0.286> <-7.164, 7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 10.301, 0.106> <2.365, 10.301, 0.106> <5.611, 8.955, 0.106> <7.283, 7.283, 0.106> 
		<0.000, 10.301, 0.179> <2.365, 10.301, 0.179> <5.610, 8.955, 0.179> <7.283, 7.283, 0.179> 
		<0.000, 10.206, 0.286> <2.326, 10.206, 0.286> <5.571, 8.861, 0.286> <7.216, 7.216, 0.286> 
		<0.000, 10.133, 0.282> <2.326, 10.133, 0.282> <5.519, 8.809, 0.282> <7.164, 7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.283, 7.283, 0.106> <8.955, 5.611, 0.106> <10.301, 2.365, 0.106> <10.301, 0.000, 0.106> 
		<7.283, 7.283, 0.179> <8.955, 5.610, 0.179> <10.301, 2.365, 0.179> <10.301, 0.000, 0.179> 
		<7.216, 7.216, 0.286> <8.861, 5.571, 0.286> <10.206, 2.326, 0.286> <10.206, 0.000, 0.286> 
		<7.164, 7.164, 0.282> <8.809, 5.519, 0.282> <10.133, 2.326, 0.282> <10.133, 0.000, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.301, 0.000, 0.106> <10.301, -2.365, 0.106> <8.955, -5.611, 0.106> <7.283, -7.283, 0.106> 
		<10.301, 0.000, 0.179> <10.301, -2.365, 0.179> <8.955, -5.610, 0.179> <7.283, -7.283, 0.179> 
		<10.206, 0.000, 0.286> <10.206, -2.326, 0.286> <8.861, -5.571, 0.286> <7.216, -7.216, 0.286> 
		<10.133, 0.000, 0.282> <10.133, -2.326, 0.282> <8.809, -5.519, 0.282> <7.164, -7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.283, -7.283, 0.106> <5.611, -8.955, 0.106> <2.365, -10.301, 0.106> <0.000, -10.301, 0.106> 
		<7.283, -7.283, 0.179> <5.610, -8.955, 0.179> <2.365, -10.301, 0.179> <0.000, -10.301, 0.179> 
		<7.216, -7.216, 0.286> <5.571, -8.861, 0.286> <2.326, -10.206, 0.286> <0.000, -10.206, 0.286> 
		<7.164, -7.164, 0.282> <5.519, -8.809, 0.282> <2.326, -10.133, 0.282> <0.000, -10.133, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -10.301, 0.106> <-2.365, -10.301, 0.106> <-5.611, -8.955, 0.106> <-7.283, -7.283, 0.106> 
		<0.000, -10.301, 0.179> <-2.365, -10.301, 0.179> <-5.610, -8.955, 0.179> <-7.283, -7.283, 0.179> 
		<0.000, -10.206, 0.286> <-2.326, -10.206, 0.286> <-5.571, -8.861, 0.286> <-7.216, -7.216, 0.286> 
		<0.000, -10.133, 0.282> <-2.326, -10.133, 0.282> <-5.519, -8.809, 0.282> <-7.164, -7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.283, -7.283, 0.106> <-8.955, -5.611, 0.106> <-10.301, -2.365, 0.106> <-10.301, 0.000, 0.106> 
		<-7.283, -7.283, 0.179> <-8.955, -5.610, 0.179> <-10.301, -2.365, 0.179> <-10.301, 0.000, 0.179> 
		<-7.216, -7.216, 0.286> <-8.861, -5.571, 0.286> <-10.206, -2.326, 0.286> <-10.206, 0.000, 0.286> 
		<-7.164, -7.164, 0.282> <-8.809, -5.519, 0.282> <-10.133, -2.326, 0.282> <-10.133, 0.000, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.301, 0.000, 0.106> <-10.301, 2.365, 0.106> <-8.955, 5.611, 0.106> <-7.283, 7.283, 0.106> 
		<-10.301, 0.000, 0.179> <-10.301, 2.365, 0.179> <-8.955, 5.610, 0.179> <-7.283, 7.283, 0.179> 
		<-10.206, 0.000, 0.286> <-10.206, 2.326, 0.286> <-8.861, 5.571, 0.286> <-7.216, 7.216, 0.286> 
		<-10.133, 0.000, 0.282> <-10.133, 2.326, 0.282> <-8.809, 5.519, 0.282> <-7.164, 7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 9.912, 0.088> <-2.276, 9.912, 0.088> <-5.398, 8.617, 0.088> <-7.008, 7.008, 0.088> 
		<0.000, 9.978, 0.146> <-2.276, 9.978, 0.146> <-5.445, 8.664, 0.146> <-7.054, 7.054, 0.146> 
		<0.000, 10.045, 0.278> <-2.326, 10.045, 0.278> <-5.456, 8.747, 0.278> <-7.102, 7.102, 0.278> 
		<0.000, 10.133, 0.282> <-2.326, 10.133, 0.282> <-5.519, 8.809, 0.282> <-7.164, 7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 9.912, 0.088> <0.000, 9.978, 0.146> <0.000, 10.045, 0.278> <0.000, 10.133, 0.282> 
		<2.276, 9.912, 0.088> <2.276, 9.978, 0.146> <2.326, 10.045, 0.278> <2.326, 10.133, 0.282> 
		<5.398, 8.617, 0.088> <5.445, 8.664, 0.146> <5.456, 8.747, 0.278> <5.519, 8.809, 0.282> 
		<7.008, 7.008, 0.088> <7.054, 7.054, 0.146> <7.102, 7.102, 0.278> <7.164, 7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.008, 7.008, 0.088> <7.054, 7.054, 0.146> <7.102, 7.102, 0.278> <7.164, 7.164, 0.282> 
		<8.617, 5.398, 0.088> <8.664, 5.445, 0.146> <8.747, 5.456, 0.278> <8.809, 5.519, 0.282> 
		<9.912, 2.276, 0.088> <9.978, 2.276, 0.146> <10.045, 2.326, 0.278> <10.133, 2.326, 0.282> 
		<9.912, 0.000, 0.088> <9.978, 0.000, 0.146> <10.045, 0.000, 0.278> <10.133, 0.000, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.912, 0.000, 0.088> <9.978, 0.000, 0.146> <10.045, 0.000, 0.278> <10.133, 0.000, 0.282> 
		<9.912, -2.276, 0.088> <9.978, -2.276, 0.146> <10.045, -2.326, 0.278> <10.133, -2.326, 0.282> 
		<8.617, -5.398, 0.088> <8.664, -5.445, 0.146> <8.747, -5.456, 0.278> <8.809, -5.519, 0.282> 
		<7.008, -7.008, 0.088> <7.054, -7.054, 0.146> <7.102, -7.102, 0.278> <7.164, -7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.008, -7.008, 0.088> <7.054, -7.054, 0.146> <7.102, -7.102, 0.278> <7.164, -7.164, 0.282> 
		<5.398, -8.617, 0.088> <5.445, -8.664, 0.146> <5.456, -8.747, 0.278> <5.519, -8.809, 0.282> 
		<2.276, -9.912, 0.088> <2.276, -9.978, 0.146> <2.326, -10.045, 0.278> <2.326, -10.133, 0.282> 
		<0.000, -9.912, 0.088> <0.000, -9.978, 0.146> <0.000, -10.045, 0.278> <0.000, -10.133, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -9.912, 0.088> <0.000, -9.978, 0.146> <0.000, -10.045, 0.278> <0.000, -10.133, 0.282> 
		<-2.276, -9.912, 0.088> <-2.276, -9.978, 0.146> <-2.326, -10.045, 0.278> <-2.326, -10.133, 0.282> 
		<-5.398, -8.617, 0.088> <-5.445, -8.664, 0.146> <-5.456, -8.747, 0.278> <-5.519, -8.809, 0.282> 
		<-7.008, -7.008, 0.088> <-7.054, -7.054, 0.146> <-7.102, -7.102, 0.278> <-7.164, -7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.008, -7.008, 0.088> <-7.054, -7.054, 0.146> <-7.102, -7.102, 0.278> <-7.164, -7.164, 0.282> 
		<-8.617, -5.398, 0.088> <-8.664, -5.445, 0.146> <-8.747, -5.456, 0.278> <-8.809, -5.519, 0.282> 
		<-9.912, -2.276, 0.088> <-9.978, -2.276, 0.146> <-10.045, -2.326, 0.278> <-10.133, -2.326, 0.282> 
		<-9.912, 0.000, 0.088> <-9.978, 0.000, 0.146> <-10.045, 0.000, 0.278> <-10.133, 0.000, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.912, 0.000, 0.088> <-9.978, 0.000, 0.146> <-10.045, 0.000, 0.278> <-10.133, 0.000, 0.282> 
		<-9.912, 2.276, 0.088> <-9.978, 2.276, 0.146> <-10.045, 2.326, 0.278> <-10.133, 2.326, 0.282> 
		<-8.617, 5.398, 0.088> <-8.664, 5.445, 0.146> <-8.747, 5.456, 0.278> <-8.809, 5.519, 0.282> 
		<-7.008, 7.008, 0.088> <-7.054, 7.054, 0.146> <-7.102, 7.102, 0.278> <-7.164, 7.164, 0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.996, -11.697, 28.039> <-0.994, -11.692, 28.122> <-0.882, -11.696, 28.204> <-0.872, -11.692, 28.286> 
		<-0.996, -11.155, 28.007> <-0.994, -11.149, 28.089> <-0.882, -11.221, 28.175> <-0.872, -11.216, 28.257> 
		<-0.543, -10.703, 27.979> <-0.543, -10.738, 28.055> <-0.476, -10.785, 28.157> <-0.476, -10.821, 28.233> 
		<0.000, -10.703, 27.979> <0.000, -10.738, 28.055> <0.000, -10.785, 28.157> <0.000, -10.821, 28.233> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.996, -11.697, 28.039> <-0.996, -11.697, 28.039> <-0.996, -11.697, 28.039> <-0.996, -11.697, 28.039> 
		<-0.996, -12.239, 28.072> <-0.996, -11.697, 28.039> <-0.996, -11.697, 28.039> <-0.996, -11.155, 28.007> 
		<-0.543, -12.691, 28.100> <-0.543, -12.094, 28.064> <-0.543, -11.299, 28.015> <-0.543, -10.703, 27.979> 
		<0.000, -12.691, 28.100> <0.000, -12.094, 28.064> <0.000, -11.299, 28.015> <0.000, -10.703, 27.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.996, -11.697, 28.039> <-0.996, -11.155, 28.007> <-0.543, -10.703, 27.979> <0.000, -10.703, 27.979> 
		<-1.031, -11.793, 26.543> <-1.031, -11.250, 26.510> <-0.543, -10.802, 26.482> <0.000, -10.802, 26.482> 
		<-0.959, -11.928, 24.547> <-0.959, -11.385, 24.514> <-0.543, -10.970, 24.489> <0.000, -10.970, 24.489> 
		<-0.996, -12.027, 23.050> <-0.996, -11.484, 23.017> <-0.543, -11.033, 22.990> <0.000, -11.033, 22.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.996, -11.697, 28.039> <-0.996, -12.239, 28.072> <-0.543, -12.691, 28.100> <0.000, -12.691, 28.100> 
		<-0.994, -11.692, 28.122> <-0.994, -12.234, 28.155> <-0.543, -12.652, 28.171> <0.000, -12.652, 28.171> 
		<-0.882, -11.696, 28.204> <-0.882, -12.172, 28.233> <-0.476, -12.601, 28.267> <0.000, -12.601, 28.267> 
		<-0.872, -11.692, 28.286> <-0.872, -12.167, 28.315> <-0.476, -12.563, 28.339> <0.000, -12.563, 28.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.996, -11.697, 28.039> <-0.996, -12.239, 28.072> <-0.543, -12.691, 28.100> <0.000, -12.691, 28.100> 
		<-1.031, -11.793, 26.543> <-1.031, -12.335, 26.576> <-0.543, -12.790, 26.603> <0.000, -12.790, 26.603> 
		<-0.959, -11.928, 24.547> <-0.959, -12.470, 24.579> <-0.543, -12.886, 24.604> <0.000, -12.886, 24.604> 
		<-0.996, -12.027, 23.050> <-0.996, -12.569, 23.083> <-0.543, -13.021, 23.111> <0.000, -13.021, 23.111> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -12.691, 28.100> <0.000, -12.691, 28.100> <0.000, -12.691, 28.100> <0.000, -12.691, 28.100> 
		<0.543, -12.691, 28.100> <0.543, -12.094, 28.064> <0.543, -12.094, 28.064> <0.000, -12.094, 28.064> 
		<0.996, -12.239, 28.072> <0.996, -11.697, 28.039> <0.543, -11.299, 28.015> <0.000, -11.299, 28.015> 
		<0.996, -11.697, 28.039> <0.996, -11.155, 28.007> <0.543, -10.703, 27.979> <0.000, -10.703, 27.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -12.691, 28.100> <0.543, -12.691, 28.100> <0.996, -12.239, 28.072> <0.996, -11.697, 28.039> 
		<0.000, -12.790, 26.603> <0.543, -12.790, 26.603> <1.031, -12.335, 26.576> <1.031, -11.793, 26.543> 
		<0.000, -12.886, 24.604> <0.543, -12.886, 24.604> <0.959, -12.470, 24.579> <0.959, -11.928, 24.547> 
		<0.000, -13.021, 23.111> <0.543, -13.021, 23.111> <0.996, -12.569, 23.083> <0.996, -12.027, 23.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -12.691, 28.100> <0.543, -12.691, 28.100> <0.996, -12.239, 28.072> <0.996, -11.697, 28.039> 
		<0.000, -12.652, 28.171> <0.543, -12.652, 28.171> <0.994, -12.234, 28.155> <0.994, -11.692, 28.122> 
		<0.000, -12.601, 28.267> <0.476, -12.601, 28.267> <0.882, -12.172, 28.233> <0.882, -11.696, 28.204> 
		<0.000, -12.563, 28.339> <0.476, -12.563, 28.339> <0.872, -12.167, 28.315> <0.872, -11.692, 28.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.996, -11.697, 28.039> <0.996, -11.155, 28.007> <0.543, -10.703, 27.979> <0.000, -10.703, 27.979> 
		<0.994, -11.692, 28.122> <0.994, -11.149, 28.089> <0.543, -10.738, 28.055> <0.000, -10.738, 28.055> 
		<0.882, -11.696, 28.204> <0.882, -11.221, 28.175> <0.476, -10.785, 28.157> <0.000, -10.785, 28.157> 
		<0.872, -11.692, 28.286> <0.872, -11.216, 28.257> <0.476, -10.821, 28.233> <0.000, -10.821, 28.233> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.996, -11.697, 28.039> <0.996, -11.155, 28.007> <0.543, -10.703, 27.979> <0.000, -10.703, 27.979> 
		<1.031, -11.793, 26.543> <1.031, -11.250, 26.510> <0.543, -10.802, 26.482> <0.000, -10.802, 26.482> 
		<0.959, -11.928, 24.547> <0.959, -11.385, 24.514> <0.543, -10.970, 24.489> <0.000, -10.970, 24.489> 
		<0.996, -12.027, 23.050> <0.996, -11.484, 23.017> <0.543, -11.033, 22.990> <0.000, -11.033, 22.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.872, -11.634, 29.160> <-0.872, -11.158, 29.131> <-0.476, -10.763, 29.107> <0.000, -10.763, 29.107> 
		<-0.872, -11.651, 28.898> <-0.872, -11.176, 28.869> <-0.476, -10.780, 28.845> <0.000, -10.780, 28.845> 
		<-0.844, -11.677, 28.547> <-0.844, -11.202, 28.518> <-0.476, -10.803, 28.495> <0.000, -10.803, 28.495> 
		<-0.872, -11.692, 28.286> <-0.872, -11.216, 28.257> <-0.476, -10.821, 28.233> <0.000, -10.821, 28.233> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.872, -11.634, 29.160> <-0.872, -11.651, 28.898> <-0.844, -11.677, 28.547> <-0.872, -11.692, 28.286> 
		<-0.872, -12.109, 29.189> <-0.872, -12.126, 28.927> <-0.844, -12.152, 28.576> <-0.872, -12.167, 28.315> 
		<-0.476, -12.505, 29.213> <-0.476, -12.522, 28.951> <-0.476, -12.545, 28.601> <-0.476, -12.563, 28.339> 
		<0.000, -12.505, 29.213> <0.000, -12.522, 28.951> <0.000, -12.545, 28.601> <0.000, -12.563, 28.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -12.505, 29.213> <0.000, -12.522, 28.951> <0.000, -12.545, 28.601> <0.000, -12.563, 28.339> 
		<0.476, -12.505, 29.213> <0.476, -12.522, 28.951> <0.476, -12.545, 28.601> <0.476, -12.563, 28.339> 
		<0.872, -12.109, 29.189> <0.872, -12.126, 28.927> <0.844, -12.152, 28.576> <0.872, -12.167, 28.315> 
		<0.872, -11.634, 29.160> <0.872, -11.651, 28.898> <0.844, -11.677, 28.547> <0.872, -11.692, 28.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.872, -11.634, 29.160> <0.872, -11.651, 28.898> <0.844, -11.677, 28.547> <0.872, -11.692, 28.286> 
		<0.872, -11.158, 29.131> <0.872, -11.176, 28.869> <0.844, -11.202, 28.518> <0.872, -11.216, 28.257> 
		<0.476, -10.763, 29.107> <0.476, -10.780, 28.845> <0.476, -10.803, 28.495> <0.476, -10.821, 28.233> 
		<0.000, -10.763, 29.107> <0.000, -10.780, 28.845> <0.000, -10.803, 28.495> <0.000, -10.821, 28.233> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.872, -11.692, 28.286> <-0.872, -11.692, 28.286> <-0.872, -11.692, 28.286> <-0.872, -11.692, 28.286> 
		<-0.872, -11.216, 28.257> <-0.872, -11.692, 28.286> <-0.872, -11.692, 28.286> <-0.872, -12.167, 28.315> 
		<-0.476, -10.821, 28.233> <-0.476, -11.343, 28.265> <-0.476, -12.040, 28.307> <-0.476, -12.563, 28.339> 
		<0.000, -10.821, 28.233> <0.000, -11.343, 28.265> <0.000, -12.040, 28.307> <0.000, -12.563, 28.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -12.563, 28.339> <0.000, -12.563, 28.339> <0.000, -12.563, 28.339> <0.000, -12.563, 28.339> 
		<0.000, -12.040, 28.307> <0.476, -12.040, 28.307> <0.476, -12.040, 28.307> <0.476, -12.563, 28.339> 
		<0.000, -11.343, 28.265> <0.476, -11.343, 28.265> <0.872, -11.692, 28.286> <0.872, -12.167, 28.315> 
		<0.000, -10.821, 28.233> <0.476, -10.821, 28.233> <0.872, -11.216, 28.257> <0.872, -11.692, 28.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.996, -12.027, 23.050> <-0.996, -11.484, 23.017> <-0.543, -11.033, 22.990> <0.000, -11.033, 22.990> 
		<-0.997, -12.029, 23.014> <-0.997, -11.487, 22.981> <-0.543, -11.035, 22.954> <0.000, -11.035, 22.954> 
		<-1.093, -12.025, 23.078> <-1.093, -11.417, 23.041> <-0.609, -10.934, 23.012> <0.000, -10.934, 23.012> 
		<-1.116, -12.027, 23.050> <-1.116, -11.419, 23.013> <-0.609, -10.913, 22.983> <0.000, -10.913, 22.983> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.996, -12.027, 23.050> <-0.996, -12.569, 23.083> <-0.543, -13.021, 23.111> <0.000, -13.021, 23.111> 
		<-0.997, -12.029, 23.014> <-0.997, -12.572, 23.047> <-0.543, -13.024, 23.075> <0.000, -13.024, 23.075> 
		<-1.093, -12.025, 23.078> <-1.093, -12.633, 23.115> <-0.609, -13.116, 23.144> <0.000, -13.116, 23.144> 
		<-1.116, -12.027, 23.050> <-1.116, -12.635, 23.087> <-0.609, -13.141, 23.118> <0.000, -13.141, 23.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -13.021, 23.111> <0.543, -13.021, 23.111> <0.996, -12.569, 23.083> <0.996, -12.027, 23.050> 
		<0.000, -13.024, 23.075> <0.543, -13.024, 23.075> <0.997, -12.572, 23.047> <0.997, -12.029, 23.014> 
		<0.000, -13.116, 23.144> <0.609, -13.116, 23.144> <1.093, -12.633, 23.115> <1.093, -12.025, 23.078> 
		<0.000, -13.141, 23.118> <0.609, -13.141, 23.118> <1.116, -12.635, 23.087> <1.116, -12.027, 23.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.996, -12.027, 23.050> <0.996, -11.484, 23.017> <0.543, -11.033, 22.990> <0.000, -11.033, 22.990> 
		<0.997, -12.029, 23.014> <0.997, -11.487, 22.981> <0.543, -11.035, 22.954> <0.000, -11.035, 22.954> 
		<1.093, -12.025, 23.078> <1.093, -11.417, 23.041> <0.609, -10.934, 23.012> <0.000, -10.934, 23.012> 
		<1.116, -12.027, 23.050> <1.116, -11.419, 23.013> <0.609, -10.913, 22.983> <0.000, -10.913, 22.983> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.027, 23.050> <-1.116, -11.419, 23.013> <-0.609, -10.913, 22.983> <0.000, -10.913, 22.983> 
		<-1.144, -12.029, 23.018> <-1.144, -11.421, 22.982> <-0.609, -10.887, 22.949> <0.000, -10.887, 22.949> 
		<-1.097, -12.034, 22.947> <-1.097, -11.425, 22.911> <-0.611, -10.938, 22.882> <-0.002, -10.938, 22.882> 
		<-1.116, -12.036, 22.910> <-1.116, -11.428, 22.873> <-0.609, -10.922, 22.843> <0.000, -10.922, 22.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.027, 23.050> <-1.116, -12.635, 23.087> <-0.609, -13.141, 23.118> <0.000, -13.141, 23.118> 
		<-1.144, -12.029, 23.018> <-1.144, -12.637, 23.055> <-0.609, -13.170, 23.088> <0.000, -13.170, 23.088> 
		<-1.097, -12.034, 22.947> <-1.097, -12.642, 22.984> <-0.609, -13.129, 23.014> <-0.000, -13.129, 23.014> 
		<-1.116, -12.036, 22.910> <-1.116, -12.644, 22.947> <-0.609, -13.150, 22.978> <0.000, -13.150, 22.978> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -13.141, 23.118> <0.609, -13.141, 23.118> <1.116, -12.635, 23.087> <1.116, -12.027, 23.050> 
		<0.000, -13.170, 23.088> <0.609, -13.170, 23.088> <1.144, -12.637, 23.055> <1.144, -12.029, 23.018> 
		<-0.000, -13.129, 23.014> <0.609, -13.129, 23.014> <1.097, -12.642, 22.985> <1.097, -12.034, 22.948> 
		<0.000, -13.150, 22.978> <0.609, -13.150, 22.978> <1.116, -12.644, 22.947> <1.116, -12.036, 22.910> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.116, -12.027, 23.050> <1.116, -11.419, 23.013> <0.609, -10.913, 22.983> <0.000, -10.913, 22.983> 
		<1.144, -12.029, 23.018> <1.144, -11.421, 22.982> <0.609, -10.887, 22.949> <0.000, -10.887, 22.949> 
		<1.097, -12.034, 22.948> <1.097, -11.425, 22.911> <0.607, -10.938, 22.882> <-0.002, -10.938, 22.882> 
		<1.116, -12.036, 22.910> <1.116, -11.428, 22.873> <0.609, -10.922, 22.843> <0.000, -10.922, 22.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.036, 22.910> <-1.116, -11.428, 22.873> <-0.609, -10.922, 22.843> <0.000, -10.922, 22.843> 
		<-1.134, -12.038, 22.876> <-1.134, -11.430, 22.839> <-0.607, -10.907, 22.807> <0.002, -10.907, 22.807> 
		<-1.209, -12.038, 22.888> <-1.206, -11.367, 22.848> <-0.659, -10.835, 22.811> <0.013, -10.835, 22.810> 
		<-1.227, -12.041, 22.840> <-1.224, -11.371, 22.801> <-0.659, -10.821, 22.763> <0.013, -10.821, 22.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.036, 22.910> <-1.116, -12.644, 22.947> <-0.609, -13.150, 22.978> <0.000, -13.150, 22.978> 
		<-1.134, -12.038, 22.876> <-1.134, -12.646, 22.912> <-0.609, -13.170, 22.943> <0.000, -13.170, 22.943> 
		<-1.209, -12.038, 22.888> <-1.212, -12.705, 22.927> <-0.668, -13.242, 22.954> <0.001, -13.242, 22.953> 
		<-1.227, -12.041, 22.840> <-1.230, -12.708, 22.880> <-0.668, -13.263, 22.906> <0.001, -13.263, 22.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -13.150, 22.978> <0.609, -13.150, 22.978> <1.116, -12.644, 22.947> <1.116, -12.036, 22.910> 
		<0.000, -13.170, 22.943> <0.609, -13.170, 22.943> <1.133, -12.646, 22.912> <1.133, -12.038, 22.876> 
		<0.001, -13.242, 22.953> <0.668, -13.242, 22.951> <1.202, -12.704, 22.922> <1.205, -12.038, 22.883> 
		<0.001, -13.263, 22.905> <0.668, -13.263, 22.904> <1.220, -12.707, 22.875> <1.223, -12.041, 22.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.116, -12.036, 22.910> <1.116, -11.428, 22.873> <0.609, -10.922, 22.843> <0.000, -10.922, 22.843> 
		<1.133, -12.038, 22.876> <1.133, -11.430, 22.839> <0.611, -10.907, 22.807> <0.002, -10.907, 22.807> 
		<1.205, -12.038, 22.883> <1.208, -11.376, 22.844> <0.676, -10.836, 22.809> <0.013, -10.835, 22.810> 
		<1.223, -12.041, 22.836> <1.226, -11.379, 22.797> <0.676, -10.821, 22.761> <0.013, -10.821, 22.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.062, 22.525> <-1.099, -12.064, 22.492> <-1.148, -12.068, 22.420> <-1.116, -12.070, 22.403> 
		<-1.116, -11.454, 22.488> <-1.099, -11.456, 22.455> <-1.148, -11.461, 22.384> <-1.116, -11.462, 22.366> 
		<-0.609, -10.948, 22.458> <-0.609, -10.966, 22.426> <-0.609, -10.923, 22.351> <-0.609, -10.956, 22.335> 
		<0.000, -10.948, 22.458> <-0.000, -10.966, 22.426> <0.000, -10.923, 22.351> <0.000, -10.956, 22.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.062, 22.525> <-1.116, -11.454, 22.488> <-0.609, -10.948, 22.458> <0.000, -10.948, 22.458> 
		<-1.135, -12.059, 22.564> <-1.135, -11.451, 22.527> <-0.609, -10.926, 22.495> <0.000, -10.926, 22.495> 
		<-1.209, -12.058, 22.579> <-1.209, -11.392, 22.539> <-0.669, -10.851, 22.506> <-0.002, -10.851, 22.506> 
		<-1.223, -12.055, 22.619> <-1.223, -11.389, 22.579> <-0.668, -10.834, 22.545> <0.000, -10.834, 22.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.062, 22.525> <-1.116, -12.669, 22.562> <-0.609, -13.175, 22.593> <0.000, -13.175, 22.593> 
		<-1.099, -12.064, 22.492> <-1.099, -12.671, 22.529> <-0.609, -13.161, 22.559> <-0.000, -13.161, 22.559> 
		<-1.148, -12.068, 22.420> <-1.148, -12.676, 22.457> <-0.609, -13.214, 22.490> <0.000, -13.214, 22.490> 
		<-1.116, -12.070, 22.403> <-1.116, -12.677, 22.440> <-0.609, -13.183, 22.470> <0.000, -13.183, 22.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.062, 22.525> <-1.135, -12.059, 22.564> <-1.209, -12.058, 22.579> <-1.223, -12.055, 22.619> 
		<-1.116, -12.669, 22.562> <-1.135, -12.667, 22.600> <-1.209, -12.724, 22.619> <-1.223, -12.722, 22.660> 
		<-0.609, -13.175, 22.593> <-0.609, -13.192, 22.632> <-0.668, -13.265, 22.652> <-0.668, -13.276, 22.693> 
		<0.000, -13.175, 22.593> <0.000, -13.192, 22.632> <-0.000, -13.265, 22.652> <0.000, -13.276, 22.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -13.175, 22.593> <0.609, -13.175, 22.593> <1.116, -12.669, 22.562> <1.116, -12.062, 22.525> 
		<-0.000, -13.161, 22.559> <0.609, -13.161, 22.559> <1.099, -12.671, 22.529> <1.099, -12.064, 22.492> 
		<0.000, -13.214, 22.490> <0.609, -13.214, 22.490> <1.148, -12.676, 22.457> <1.148, -12.068, 22.420> 
		<0.000, -13.183, 22.470> <0.609, -13.183, 22.470> <1.116, -12.677, 22.440> <1.116, -12.070, 22.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -13.175, 22.593> <0.000, -13.192, 22.632> <-0.000, -13.265, 22.652> <0.000, -13.276, 22.693> 
		<0.609, -13.175, 22.593> <0.609, -13.192, 22.632> <0.667, -13.265, 22.652> <0.668, -13.276, 22.693> 
		<1.116, -12.669, 22.562> <1.135, -12.667, 22.600> <1.209, -12.724, 22.619> <1.223, -12.722, 22.660> 
		<1.116, -12.062, 22.525> <1.135, -12.059, 22.564> <1.209, -12.058, 22.579> <1.223, -12.055, 22.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.116, -12.062, 22.525> <1.116, -11.454, 22.488> <0.609, -10.948, 22.458> <0.000, -10.948, 22.458> 
		<1.099, -12.064, 22.492> <1.099, -11.456, 22.455> <0.609, -10.966, 22.426> <-0.000, -10.966, 22.426> 
		<1.148, -12.068, 22.420> <1.148, -11.461, 22.384> <0.609, -10.923, 22.351> <0.000, -10.923, 22.351> 
		<1.116, -12.070, 22.403> <1.116, -11.462, 22.366> <0.609, -10.956, 22.335> <0.000, -10.956, 22.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.116, -12.062, 22.525> <1.135, -12.059, 22.564> <1.209, -12.058, 22.579> <1.223, -12.055, 22.619> 
		<1.116, -11.454, 22.488> <1.135, -11.451, 22.527> <1.209, -11.392, 22.539> <1.223, -11.389, 22.579> 
		<0.609, -10.948, 22.458> <0.609, -10.926, 22.495> <0.666, -10.851, 22.506> <0.668, -10.834, 22.545> 
		<0.000, -10.948, 22.458> <0.000, -10.926, 22.495> <-0.002, -10.851, 22.506> <0.000, -10.834, 22.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.070, 22.403> <-1.057, -12.072, 22.371> <-0.903, -12.074, 22.337> <-0.892, -12.070, 22.403> 
		<-1.116, -11.462, 22.366> <-1.057, -11.464, 22.334> <-0.903, -11.588, 22.307> <-0.892, -11.583, 22.373> 
		<-0.609, -10.956, 22.335> <-0.609, -11.017, 22.307> <-0.487, -11.173, 22.282> <-0.487, -11.179, 22.349> 
		<0.000, -10.956, 22.335> <0.000, -11.017, 22.307> <0.000, -11.173, 22.282> <0.000, -11.179, 22.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, -12.070, 22.403> <-1.116, -12.677, 22.440> <-0.609, -13.183, 22.470> <0.000, -13.183, 22.470> 
		<-1.057, -12.072, 22.371> <-1.057, -12.680, 22.407> <-0.609, -13.127, 22.434> <0.000, -13.127, 22.434> 
		<-0.903, -12.074, 22.337> <-0.903, -12.560, 22.366> <-0.487, -12.975, 22.391> <0.000, -12.975, 22.391> 
		<-0.892, -12.070, 22.403> <-0.892, -12.556, 22.432> <-0.487, -12.960, 22.457> <0.000, -12.960, 22.457> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -13.183, 22.470> <0.609, -13.183, 22.470> <1.116, -12.677, 22.440> <1.116, -12.070, 22.403> 
		<0.000, -13.127, 22.434> <0.609, -13.127, 22.434> <1.057, -12.680, 22.407> <1.057, -12.072, 22.371> 
		<0.000, -12.975, 22.391> <0.487, -12.975, 22.391> <0.903, -12.560, 22.366> <0.903, -12.074, 22.337> 
		<0.000, -12.960, 22.457> <0.487, -12.960, 22.457> <0.892, -12.556, 22.432> <0.892, -12.070, 22.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.116, -12.070, 22.403> <1.116, -11.462, 22.366> <0.609, -10.956, 22.335> <0.000, -10.956, 22.335> 
		<1.057, -12.072, 22.371> <1.057, -11.464, 22.334> <0.609, -11.017, 22.307> <0.000, -11.017, 22.307> 
		<0.903, -12.074, 22.337> <0.903, -11.588, 22.307> <0.487, -11.173, 22.282> <0.000, -11.173, 22.282> 
		<0.892, -12.070, 22.403> <0.892, -11.583, 22.373> <0.487, -11.179, 22.349> <0.000, -11.179, 22.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.892, -11.974, 23.855> <-0.892, -11.487, 23.826> <-0.487, -11.083, 23.801> <0.000, -11.083, 23.801> 
		<-0.892, -12.002, 23.420> <-0.892, -11.516, 23.390> <-0.487, -11.112, 23.366> <0.000, -11.112, 23.366> 
		<-0.826, -12.041, 22.834> <-0.826, -11.555, 22.804> <-0.487, -11.216, 22.784> <0.000, -11.216, 22.784> 
		<-0.892, -12.070, 22.403> <-0.892, -11.583, 22.373> <-0.487, -11.179, 22.349> <0.000, -11.179, 22.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.892, -11.974, 23.855> <-0.892, -12.002, 23.420> <-0.826, -12.041, 22.834> <-0.892, -12.070, 22.403> 
		<-0.892, -12.460, 23.885> <-0.892, -12.489, 23.449> <-0.826, -12.527, 22.863> <-0.892, -12.556, 22.432> 
		<-0.487, -12.864, 23.909> <-0.487, -12.893, 23.474> <-0.487, -12.866, 22.883> <-0.487, -12.960, 22.457> 
		<0.000, -12.864, 23.909> <0.000, -12.893, 23.474> <0.000, -12.866, 22.883> <0.000, -12.960, 22.457> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -12.864, 23.909> <0.000, -12.893, 23.474> <0.000, -12.866, 22.883> <0.000, -12.960, 22.457> 
		<0.487, -12.864, 23.909> <0.487, -12.893, 23.474> <0.487, -12.866, 22.883> <0.487, -12.960, 22.457> 
		<0.892, -12.460, 23.885> <0.892, -12.489, 23.449> <0.826, -12.527, 22.863> <0.892, -12.556, 22.432> 
		<0.892, -11.974, 23.855> <0.892, -12.002, 23.420> <0.826, -12.041, 22.834> <0.892, -12.070, 22.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.892, -11.974, 23.855> <0.892, -12.002, 23.420> <0.826, -12.041, 22.834> <0.892, -12.070, 22.403> 
		<0.892, -11.487, 23.826> <0.892, -11.516, 23.390> <0.826, -11.555, 22.804> <0.892, -11.583, 22.373> 
		<0.487, -11.083, 23.801> <0.487, -11.112, 23.366> <0.487, -11.216, 22.784> <0.487, -11.179, 22.349> 
		<0.000, -11.083, 23.801> <0.000, -11.112, 23.366> <0.000, -11.216, 22.784> <0.000, -11.179, 22.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.223, -12.055, 22.619> <-1.223, -12.055, 22.619> <-1.223, -12.055, 22.619> <-1.223, -12.055, 22.619> 
		<-1.223, -11.389, 22.579> <-1.223, -11.389, 22.579> <-1.223, -11.389, 22.579> <-1.223, -11.389, 22.579> 
		<-0.668, -10.834, 22.545> <-0.668, -10.834, 22.545> <-0.668, -10.834, 22.545> <-0.668, -10.834, 22.545> 
		<0.000, -10.834, 22.545> <0.000, -10.834, 22.545> <0.000, -10.834, 22.545> <0.000, -10.834, 22.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.223, -12.055, 22.619> <-1.223, -12.722, 22.660> <-0.668, -13.276, 22.693> <0.000, -13.276, 22.693> 
		<-1.223, -12.055, 22.619> <-1.223, -12.722, 22.660> <-0.668, -13.276, 22.693> <0.000, -13.276, 22.693> 
		<-1.223, -12.055, 22.619> <-1.223, -12.722, 22.660> <-0.668, -13.276, 22.693> <0.000, -13.276, 22.693> 
		<-1.223, -12.055, 22.619> <-1.223, -12.722, 22.660> <-0.668, -13.276, 22.693> <0.000, -13.276, 22.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -13.276, 22.693> <0.668, -13.276, 22.693> <1.223, -12.722, 22.660> <1.223, -12.055, 22.619> 
		<0.000, -13.276, 22.693> <0.668, -13.276, 22.693> <1.223, -12.722, 22.660> <1.223, -12.055, 22.619> 
		<0.000, -13.276, 22.693> <0.668, -13.276, 22.693> <1.223, -12.722, 22.660> <1.223, -12.055, 22.619> 
		<0.000, -13.276, 22.693> <0.668, -13.276, 22.693> <1.223, -12.722, 22.660> <1.223, -12.055, 22.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.223, -12.055, 22.619> <1.223, -11.389, 22.579> <0.668, -10.834, 22.545> <0.000, -10.834, 22.545> 
		<1.223, -12.055, 22.619> <1.223, -11.389, 22.579> <0.668, -10.834, 22.545> <0.000, -10.834, 22.545> 
		<1.223, -12.055, 22.619> <1.223, -11.389, 22.579> <0.668, -10.834, 22.545> <0.000, -10.834, 22.545> 
		<1.223, -12.055, 22.619> <1.223, -11.389, 22.579> <0.668, -10.834, 22.545> <0.000, -10.834, 22.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.223, -12.055, 22.619> <-1.223, -11.389, 22.579> <-0.668, -10.834, 22.545> <0.000, -10.834, 22.545> 
		<-1.245, -12.051, 22.682> <-1.245, -11.385, 22.642> <-0.665, -10.809, 22.606> <0.002, -10.809, 22.606> 
		<-1.256, -12.046, 22.760> <-1.253, -11.376, 22.721> <-0.659, -10.798, 22.683> <0.013, -10.798, 22.681> 
		<-1.227, -12.041, 22.840> <-1.224, -11.371, 22.801> <-0.659, -10.821, 22.763> <0.013, -10.821, 22.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.223, -12.055, 22.619> <-1.245, -12.051, 22.682> <-1.256, -12.046, 22.760> <-1.227, -12.041, 22.840> 
		<-1.223, -12.722, 22.660> <-1.245, -12.718, 22.722> <-1.259, -12.714, 22.800> <-1.230, -12.708, 22.880> 
		<-0.668, -13.276, 22.693> <-0.667, -13.293, 22.755> <-0.668, -13.296, 22.831> <-0.668, -13.263, 22.906> 
		<0.000, -13.276, 22.693> <0.000, -13.293, 22.755> <0.001, -13.296, 22.830> <0.001, -13.263, 22.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -13.276, 22.693> <0.000, -13.293, 22.755> <0.001, -13.296, 22.830> <0.001, -13.263, 22.905> 
		<0.668, -13.276, 22.693> <0.668, -13.293, 22.755> <0.668, -13.296, 22.829> <0.668, -13.263, 22.904> 
		<1.223, -12.722, 22.660> <1.244, -12.718, 22.721> <1.248, -12.712, 22.797> <1.220, -12.707, 22.875> 
		<1.223, -12.055, 22.619> <1.244, -12.051, 22.681> <1.252, -12.046, 22.758> <1.223, -12.041, 22.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.223, -12.055, 22.619> <1.244, -12.051, 22.681> <1.252, -12.046, 22.758> <1.223, -12.041, 22.836> 
		<1.223, -11.389, 22.579> <1.244, -11.385, 22.641> <1.255, -11.384, 22.719> <1.226, -11.379, 22.797> 
		<0.668, -10.834, 22.545> <0.670, -10.809, 22.606> <0.676, -10.798, 22.680> <0.676, -10.821, 22.761> 
		<0.000, -10.834, 22.545> <0.002, -10.809, 22.606> <0.013, -10.798, 22.681> <0.013, -10.821, 22.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.496, -11.697, 28.039> <-9.494, -11.692, 28.122> <-9.382, -11.696, 28.204> <-9.372, -11.692, 28.286> 
		<-9.496, -11.155, 28.007> <-9.494, -11.149, 28.089> <-9.382, -11.221, 28.175> <-9.372, -11.216, 28.257> 
		<-9.043, -10.703, 27.979> <-9.043, -10.738, 28.055> <-8.976, -10.785, 28.157> <-8.976, -10.821, 28.233> 
		<-8.500, -10.703, 27.979> <-8.500, -10.738, 28.055> <-8.500, -10.785, 28.157> <-8.500, -10.821, 28.233> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.496, -11.697, 28.039> <-9.496, -11.697, 28.039> <-9.496, -11.697, 28.039> <-9.496, -11.697, 28.039> 
		<-9.496, -12.239, 28.072> <-9.496, -11.697, 28.039> <-9.496, -11.697, 28.039> <-9.496, -11.155, 28.007> 
		<-9.043, -12.691, 28.100> <-9.043, -12.094, 28.064> <-9.043, -11.299, 28.015> <-9.043, -10.703, 27.979> 
		<-8.500, -12.691, 28.100> <-8.500, -12.094, 28.064> <-8.500, -11.299, 28.015> <-8.500, -10.703, 27.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.496, -11.697, 28.039> <-9.496, -11.155, 28.007> <-9.043, -10.703, 27.979> <-8.500, -10.703, 27.979> 
		<-9.531, -11.793, 26.543> <-9.531, -11.250, 26.510> <-9.043, -10.802, 26.482> <-8.500, -10.802, 26.482> 
		<-9.459, -11.928, 24.547> <-9.459, -11.385, 24.514> <-9.043, -10.970, 24.489> <-8.500, -10.970, 24.489> 
		<-9.496, -12.027, 23.050> <-9.496, -11.484, 23.017> <-9.043, -11.033, 22.990> <-8.500, -11.033, 22.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.496, -11.697, 28.039> <-9.496, -12.239, 28.072> <-9.043, -12.691, 28.100> <-8.500, -12.691, 28.100> 
		<-9.494, -11.692, 28.122> <-9.494, -12.234, 28.155> <-9.043, -12.652, 28.171> <-8.500, -12.652, 28.171> 
		<-9.382, -11.696, 28.204> <-9.382, -12.172, 28.233> <-8.976, -12.601, 28.267> <-8.500, -12.601, 28.267> 
		<-9.372, -11.692, 28.286> <-9.372, -12.167, 28.315> <-8.976, -12.563, 28.339> <-8.500, -12.563, 28.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.496, -11.697, 28.039> <-9.496, -12.239, 28.072> <-9.043, -12.691, 28.100> <-8.500, -12.691, 28.100> 
		<-9.531, -11.793, 26.543> <-9.531, -12.335, 26.576> <-9.043, -12.790, 26.603> <-8.500, -12.790, 26.603> 
		<-9.459, -11.928, 24.547> <-9.459, -12.470, 24.579> <-9.043, -12.886, 24.604> <-8.500, -12.886, 24.604> 
		<-9.496, -12.027, 23.050> <-9.496, -12.569, 23.083> <-9.043, -13.021, 23.111> <-8.500, -13.021, 23.111> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.691, 28.100> <-8.500, -12.691, 28.100> <-8.500, -12.691, 28.100> <-8.500, -12.691, 28.100> 
		<-7.957, -12.691, 28.100> <-7.957, -12.094, 28.064> <-7.957, -12.094, 28.064> <-8.500, -12.094, 28.064> 
		<-7.504, -12.239, 28.072> <-7.504, -11.697, 28.039> <-7.957, -11.299, 28.015> <-8.500, -11.299, 28.015> 
		<-7.504, -11.697, 28.039> <-7.504, -11.155, 28.007> <-7.957, -10.703, 27.979> <-8.500, -10.703, 27.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.691, 28.100> <-7.957, -12.691, 28.100> <-7.504, -12.239, 28.072> <-7.504, -11.697, 28.039> 
		<-8.500, -12.652, 28.171> <-7.957, -12.652, 28.171> <-7.506, -12.234, 28.155> <-7.506, -11.692, 28.122> 
		<-8.500, -12.601, 28.267> <-8.024, -12.601, 28.267> <-7.618, -12.172, 28.233> <-7.618, -11.696, 28.204> 
		<-8.500, -12.563, 28.339> <-8.024, -12.563, 28.339> <-7.628, -12.167, 28.315> <-7.628, -11.692, 28.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.691, 28.100> <-7.957, -12.691, 28.100> <-7.504, -12.239, 28.072> <-7.504, -11.697, 28.039> 
		<-8.500, -12.790, 26.603> <-7.957, -12.790, 26.603> <-7.469, -12.335, 26.576> <-7.469, -11.793, 26.543> 
		<-8.500, -12.886, 24.604> <-7.957, -12.886, 24.604> <-7.541, -12.470, 24.579> <-7.541, -11.928, 24.547> 
		<-8.500, -13.021, 23.111> <-7.957, -13.021, 23.111> <-7.504, -12.569, 23.083> <-7.504, -12.027, 23.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.504, -11.697, 28.039> <-7.504, -11.155, 28.007> <-7.957, -10.703, 27.979> <-8.500, -10.703, 27.979> 
		<-7.506, -11.692, 28.122> <-7.506, -11.149, 28.089> <-7.957, -10.738, 28.055> <-8.500, -10.738, 28.055> 
		<-7.618, -11.696, 28.204> <-7.618, -11.221, 28.175> <-8.024, -10.785, 28.157> <-8.500, -10.785, 28.157> 
		<-7.628, -11.692, 28.286> <-7.628, -11.216, 28.257> <-8.024, -10.821, 28.233> <-8.500, -10.821, 28.233> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.504, -11.697, 28.039> <-7.504, -11.155, 28.007> <-7.957, -10.703, 27.979> <-8.500, -10.703, 27.979> 
		<-7.469, -11.793, 26.543> <-7.469, -11.250, 26.510> <-7.957, -10.802, 26.482> <-8.500, -10.802, 26.482> 
		<-7.541, -11.928, 24.547> <-7.541, -11.385, 24.514> <-7.957, -10.970, 24.489> <-8.500, -10.970, 24.489> 
		<-7.504, -12.027, 23.050> <-7.504, -11.484, 23.017> <-7.957, -11.033, 22.990> <-8.500, -11.033, 22.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.372, -11.692, 28.286> <-9.372, -11.692, 28.286> <-9.372, -11.692, 28.286> <-9.372, -11.692, 28.286> 
		<-9.372, -11.216, 28.257> <-9.372, -11.692, 28.286> <-9.372, -11.692, 28.286> <-9.372, -12.167, 28.315> 
		<-8.976, -10.821, 28.233> <-8.976, -11.343, 28.265> <-8.976, -12.040, 28.307> <-8.976, -12.563, 28.339> 
		<-8.500, -10.821, 28.233> <-8.500, -11.343, 28.265> <-8.500, -12.040, 28.307> <-8.500, -12.563, 28.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.372, -11.692, 28.286> <-9.344, -11.677, 28.547> <-9.434, -11.651, 28.905> <-9.372, -11.634, 29.160> 
		<-9.372, -11.216, 28.257> <-9.344, -11.202, 28.518> <-9.434, -11.175, 28.876> <-9.372, -11.158, 29.131> 
		<-8.976, -10.821, 28.233> <-8.976, -10.803, 28.495> <-8.976, -10.719, 28.848> <-8.976, -10.763, 29.107> 
		<-8.500, -10.821, 28.233> <-8.500, -10.803, 28.495> <-8.500, -10.719, 28.848> <-8.500, -10.763, 29.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.372, -11.692, 28.286> <-9.372, -12.167, 28.315> <-8.976, -12.563, 28.339> <-8.500, -12.563, 28.339> 
		<-9.344, -11.677, 28.547> <-9.344, -12.152, 28.576> <-8.976, -12.545, 28.601> <-8.500, -12.545, 28.601> 
		<-9.434, -11.651, 28.905> <-9.434, -12.126, 28.934> <-8.976, -12.583, 28.962> <-8.500, -12.583, 28.962> 
		<-9.372, -11.634, 29.160> <-9.372, -12.109, 29.189> <-8.976, -12.505, 29.213> <-8.500, -12.505, 29.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.563, 28.339> <-8.500, -12.563, 28.339> <-8.500, -12.563, 28.339> <-8.500, -12.563, 28.339> 
		<-8.500, -12.040, 28.307> <-8.024, -12.040, 28.307> <-8.024, -12.040, 28.307> <-8.024, -12.563, 28.339> 
		<-8.500, -11.343, 28.265> <-8.024, -11.343, 28.265> <-7.628, -11.692, 28.286> <-7.628, -12.167, 28.315> 
		<-8.500, -10.821, 28.233> <-8.024, -10.821, 28.233> <-7.628, -11.216, 28.257> <-7.628, -11.692, 28.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.563, 28.339> <-8.024, -12.563, 28.339> <-7.628, -12.167, 28.315> <-7.628, -11.692, 28.286> 
		<-8.500, -12.545, 28.601> <-8.024, -12.545, 28.601> <-7.656, -12.152, 28.576> <-7.656, -11.677, 28.547> 
		<-8.500, -12.583, 28.962> <-8.024, -12.583, 28.962> <-7.566, -12.126, 28.934> <-7.566, -11.651, 28.905> 
		<-8.500, -12.505, 29.213> <-8.024, -12.505, 29.213> <-7.628, -12.109, 29.189> <-7.628, -11.634, 29.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.628, -11.692, 28.286> <-7.628, -11.216, 28.257> <-8.024, -10.821, 28.233> <-8.500, -10.821, 28.233> 
		<-7.656, -11.677, 28.547> <-7.656, -11.202, 28.518> <-8.024, -10.803, 28.495> <-8.500, -10.803, 28.495> 
		<-7.566, -11.651, 28.905> <-7.566, -11.175, 28.876> <-8.024, -10.719, 28.848> <-8.500, -10.719, 28.848> 
		<-7.628, -11.634, 29.160> <-7.628, -11.158, 29.131> <-8.024, -10.763, 29.107> <-8.500, -10.763, 29.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.496, -12.027, 23.050> <-9.496, -11.484, 23.017> <-9.043, -11.033, 22.990> <-8.500, -11.033, 22.990> 
		<-9.497, -12.029, 23.014> <-9.497, -11.487, 22.981> <-9.043, -11.035, 22.954> <-8.500, -11.035, 22.954> 
		<-9.593, -12.025, 23.078> <-9.593, -11.417, 23.041> <-9.109, -10.934, 23.012> <-8.500, -10.934, 23.012> 
		<-9.616, -12.027, 23.050> <-9.616, -11.419, 23.013> <-9.109, -10.913, 22.983> <-8.500, -10.913, 22.983> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.496, -12.027, 23.050> <-9.496, -12.569, 23.083> <-9.043, -13.021, 23.111> <-8.500, -13.021, 23.111> 
		<-9.497, -12.029, 23.014> <-9.497, -12.572, 23.047> <-9.043, -13.024, 23.075> <-8.500, -13.024, 23.075> 
		<-9.593, -12.025, 23.078> <-9.593, -12.633, 23.115> <-9.109, -13.116, 23.144> <-8.500, -13.116, 23.144> 
		<-9.616, -12.027, 23.050> <-9.616, -12.635, 23.087> <-9.109, -13.141, 23.118> <-8.500, -13.141, 23.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.021, 23.111> <-7.957, -13.021, 23.111> <-7.504, -12.569, 23.083> <-7.504, -12.027, 23.050> 
		<-8.500, -13.024, 23.075> <-7.957, -13.024, 23.075> <-7.503, -12.572, 23.047> <-7.503, -12.029, 23.014> 
		<-8.500, -13.116, 23.144> <-7.891, -13.116, 23.144> <-7.407, -12.633, 23.115> <-7.407, -12.025, 23.078> 
		<-8.500, -13.141, 23.118> <-7.891, -13.141, 23.118> <-7.384, -12.635, 23.087> <-7.384, -12.027, 23.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.504, -12.027, 23.050> <-7.504, -11.484, 23.017> <-7.957, -11.033, 22.990> <-8.500, -11.033, 22.990> 
		<-7.503, -12.029, 23.014> <-7.503, -11.487, 22.981> <-7.957, -11.035, 22.954> <-8.500, -11.035, 22.954> 
		<-7.407, -12.025, 23.078> <-7.407, -11.417, 23.041> <-7.891, -10.934, 23.012> <-8.500, -10.934, 23.012> 
		<-7.384, -12.027, 23.050> <-7.384, -11.419, 23.013> <-7.891, -10.913, 22.983> <-8.500, -10.913, 22.983> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.027, 23.050> <-9.616, -11.419, 23.013> <-9.109, -10.913, 22.983> <-8.500, -10.913, 22.983> 
		<-9.644, -12.029, 23.018> <-9.644, -11.421, 22.982> <-9.109, -10.887, 22.949> <-8.500, -10.887, 22.949> 
		<-9.597, -12.034, 22.947> <-9.597, -11.425, 22.911> <-9.111, -10.938, 22.882> <-8.502, -10.938, 22.882> 
		<-9.616, -12.036, 22.910> <-9.616, -11.428, 22.873> <-9.109, -10.922, 22.843> <-8.500, -10.922, 22.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.027, 23.050> <-9.616, -12.635, 23.087> <-9.109, -13.141, 23.118> <-8.500, -13.141, 23.118> 
		<-9.644, -12.029, 23.018> <-9.644, -12.637, 23.055> <-9.109, -13.170, 23.088> <-8.500, -13.170, 23.088> 
		<-9.597, -12.034, 22.947> <-9.597, -12.642, 22.984> <-9.109, -13.129, 23.014> <-8.500, -13.129, 23.014> 
		<-9.616, -12.036, 22.910> <-9.616, -12.644, 22.947> <-9.109, -13.150, 22.978> <-8.500, -13.150, 22.978> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.141, 23.118> <-7.891, -13.141, 23.118> <-7.384, -12.635, 23.087> <-7.384, -12.027, 23.050> 
		<-8.500, -13.170, 23.088> <-7.891, -13.170, 23.088> <-7.356, -12.637, 23.055> <-7.356, -12.029, 23.018> 
		<-8.500, -13.129, 23.014> <-7.891, -13.129, 23.014> <-7.403, -12.642, 22.985> <-7.403, -12.034, 22.948> 
		<-8.500, -13.150, 22.978> <-7.891, -13.150, 22.978> <-7.384, -12.644, 22.947> <-7.384, -12.036, 22.910> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.384, -12.027, 23.050> <-7.384, -11.419, 23.013> <-7.891, -10.913, 22.983> <-8.500, -10.913, 22.983> 
		<-7.356, -12.029, 23.018> <-7.356, -11.421, 22.982> <-7.891, -10.887, 22.949> <-8.500, -10.887, 22.949> 
		<-7.403, -12.034, 22.948> <-7.403, -11.425, 22.911> <-7.893, -10.938, 22.882> <-8.502, -10.938, 22.882> 
		<-7.384, -12.036, 22.910> <-7.384, -11.428, 22.873> <-7.891, -10.922, 22.843> <-8.500, -10.922, 22.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.036, 22.910> <-9.616, -11.428, 22.873> <-9.109, -10.922, 22.843> <-8.500, -10.922, 22.843> 
		<-9.634, -12.038, 22.876> <-9.634, -11.430, 22.839> <-9.107, -10.907, 22.807> <-8.498, -10.907, 22.807> 
		<-9.709, -12.038, 22.888> <-9.706, -11.367, 22.848> <-9.159, -10.835, 22.811> <-8.487, -10.835, 22.810> 
		<-9.727, -12.041, 22.840> <-9.724, -11.371, 22.801> <-9.159, -10.821, 22.763> <-8.487, -10.821, 22.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.036, 22.910> <-9.616, -12.644, 22.947> <-9.109, -13.150, 22.978> <-8.500, -13.150, 22.978> 
		<-9.634, -12.038, 22.876> <-9.634, -12.646, 22.912> <-9.109, -13.170, 22.943> <-8.500, -13.170, 22.943> 
		<-9.709, -12.038, 22.888> <-9.712, -12.705, 22.927> <-9.168, -13.242, 22.954> <-8.499, -13.242, 22.953> 
		<-9.727, -12.041, 22.840> <-9.730, -12.708, 22.880> <-9.168, -13.263, 22.906> <-8.499, -13.263, 22.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.150, 22.978> <-7.891, -13.150, 22.978> <-7.384, -12.644, 22.947> <-7.384, -12.036, 22.910> 
		<-8.500, -13.170, 22.943> <-7.891, -13.170, 22.943> <-7.367, -12.646, 22.912> <-7.367, -12.038, 22.876> 
		<-8.499, -13.242, 22.953> <-7.832, -13.242, 22.951> <-7.298, -12.704, 22.922> <-7.295, -12.038, 22.883> 
		<-8.499, -13.263, 22.905> <-7.832, -13.263, 22.904> <-7.280, -12.707, 22.875> <-7.277, -12.041, 22.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.384, -12.036, 22.910> <-7.384, -11.428, 22.873> <-7.891, -10.922, 22.843> <-8.500, -10.922, 22.843> 
		<-7.367, -12.038, 22.876> <-7.367, -11.430, 22.839> <-7.889, -10.907, 22.807> <-8.498, -10.907, 22.807> 
		<-7.295, -12.038, 22.883> <-7.292, -11.376, 22.844> <-7.824, -10.836, 22.809> <-8.487, -10.835, 22.810> 
		<-7.277, -12.041, 22.836> <-7.274, -11.379, 22.797> <-7.824, -10.821, 22.761> <-8.487, -10.821, 22.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.062, 22.525> <-9.599, -12.064, 22.492> <-9.648, -12.068, 22.420> <-9.616, -12.070, 22.403> 
		<-9.616, -11.454, 22.488> <-9.599, -11.456, 22.455> <-9.648, -11.461, 22.384> <-9.616, -11.462, 22.366> 
		<-9.109, -10.948, 22.458> <-9.109, -10.966, 22.426> <-9.109, -10.923, 22.351> <-9.109, -10.956, 22.335> 
		<-8.500, -10.948, 22.458> <-8.500, -10.966, 22.426> <-8.500, -10.923, 22.351> <-8.500, -10.956, 22.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.062, 22.525> <-9.616, -11.454, 22.488> <-9.109, -10.948, 22.458> <-8.500, -10.948, 22.458> 
		<-9.635, -12.059, 22.564> <-9.635, -11.451, 22.527> <-9.109, -10.926, 22.495> <-8.500, -10.926, 22.495> 
		<-9.709, -12.058, 22.579> <-9.709, -11.392, 22.539> <-9.169, -10.851, 22.506> <-8.502, -10.851, 22.506> 
		<-9.723, -12.055, 22.619> <-9.723, -11.389, 22.579> <-9.168, -10.834, 22.545> <-8.500, -10.834, 22.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.062, 22.525> <-9.616, -12.669, 22.562> <-9.109, -13.175, 22.593> <-8.500, -13.175, 22.593> 
		<-9.599, -12.064, 22.492> <-9.599, -12.671, 22.529> <-9.109, -13.161, 22.559> <-8.500, -13.161, 22.559> 
		<-9.648, -12.068, 22.420> <-9.648, -12.676, 22.457> <-9.109, -13.214, 22.490> <-8.500, -13.214, 22.490> 
		<-9.616, -12.070, 22.403> <-9.616, -12.677, 22.440> <-9.109, -13.183, 22.470> <-8.500, -13.183, 22.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.062, 22.525> <-9.635, -12.059, 22.564> <-9.709, -12.058, 22.579> <-9.723, -12.055, 22.619> 
		<-9.616, -12.669, 22.562> <-9.635, -12.667, 22.600> <-9.709, -12.724, 22.619> <-9.723, -12.722, 22.660> 
		<-9.109, -13.175, 22.593> <-9.109, -13.192, 22.632> <-9.168, -13.265, 22.652> <-9.168, -13.276, 22.693> 
		<-8.500, -13.175, 22.593> <-8.500, -13.192, 22.632> <-8.500, -13.265, 22.652> <-8.500, -13.276, 22.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.175, 22.593> <-8.500, -13.192, 22.632> <-8.500, -13.265, 22.652> <-8.500, -13.276, 22.693> 
		<-7.891, -13.175, 22.593> <-7.891, -13.192, 22.632> <-7.833, -13.265, 22.652> <-7.832, -13.276, 22.693> 
		<-7.384, -12.669, 22.562> <-7.365, -12.667, 22.600> <-7.291, -12.724, 22.619> <-7.277, -12.722, 22.660> 
		<-7.384, -12.062, 22.525> <-7.365, -12.059, 22.564> <-7.291, -12.058, 22.579> <-7.277, -12.055, 22.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.175, 22.593> <-7.891, -13.175, 22.593> <-7.384, -12.669, 22.562> <-7.384, -12.062, 22.525> 
		<-8.500, -13.161, 22.559> <-7.891, -13.161, 22.559> <-7.401, -12.671, 22.529> <-7.401, -12.064, 22.492> 
		<-8.500, -13.214, 22.490> <-7.891, -13.214, 22.490> <-7.352, -12.676, 22.457> <-7.352, -12.068, 22.420> 
		<-8.500, -13.183, 22.470> <-7.891, -13.183, 22.470> <-7.384, -12.677, 22.440> <-7.384, -12.070, 22.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.384, -12.062, 22.525> <-7.384, -11.454, 22.488> <-7.891, -10.948, 22.458> <-8.500, -10.948, 22.458> 
		<-7.401, -12.064, 22.492> <-7.401, -11.456, 22.455> <-7.891, -10.966, 22.426> <-8.500, -10.966, 22.426> 
		<-7.352, -12.068, 22.420> <-7.352, -11.461, 22.384> <-7.891, -10.923, 22.351> <-8.500, -10.923, 22.351> 
		<-7.384, -12.070, 22.403> <-7.384, -11.462, 22.366> <-7.891, -10.956, 22.335> <-8.500, -10.956, 22.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.384, -12.062, 22.525> <-7.365, -12.059, 22.564> <-7.291, -12.058, 22.579> <-7.277, -12.055, 22.619> 
		<-7.384, -11.454, 22.488> <-7.365, -11.451, 22.527> <-7.291, -11.392, 22.539> <-7.277, -11.389, 22.579> 
		<-7.891, -10.948, 22.458> <-7.891, -10.926, 22.495> <-7.834, -10.851, 22.506> <-7.832, -10.834, 22.545> 
		<-8.500, -10.948, 22.458> <-8.500, -10.926, 22.495> <-8.502, -10.851, 22.506> <-8.500, -10.834, 22.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.070, 22.403> <-9.557, -12.072, 22.371> <-9.403, -12.074, 22.337> <-9.392, -12.070, 22.403> 
		<-9.616, -11.462, 22.366> <-9.557, -11.464, 22.334> <-9.403, -11.588, 22.307> <-9.392, -11.583, 22.373> 
		<-9.109, -10.956, 22.335> <-9.109, -11.017, 22.307> <-8.987, -11.173, 22.282> <-8.987, -11.179, 22.349> 
		<-8.500, -10.956, 22.335> <-8.500, -11.017, 22.307> <-8.500, -11.173, 22.282> <-8.500, -11.179, 22.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.616, -12.070, 22.403> <-9.616, -12.677, 22.440> <-9.109, -13.183, 22.470> <-8.500, -13.183, 22.470> 
		<-9.557, -12.072, 22.371> <-9.557, -12.680, 22.407> <-9.109, -13.127, 22.434> <-8.500, -13.127, 22.434> 
		<-9.403, -12.074, 22.337> <-9.403, -12.560, 22.366> <-8.987, -12.975, 22.391> <-8.500, -12.975, 22.391> 
		<-9.392, -12.070, 22.403> <-9.392, -12.556, 22.432> <-8.987, -12.960, 22.457> <-8.500, -12.960, 22.457> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.183, 22.470> <-7.891, -13.183, 22.470> <-7.384, -12.677, 22.440> <-7.384, -12.070, 22.403> 
		<-8.500, -13.127, 22.434> <-7.891, -13.127, 22.434> <-7.443, -12.680, 22.407> <-7.443, -12.072, 22.371> 
		<-8.500, -12.975, 22.391> <-8.013, -12.975, 22.391> <-7.597, -12.560, 22.366> <-7.597, -12.074, 22.337> 
		<-8.500, -12.960, 22.457> <-8.013, -12.960, 22.457> <-7.608, -12.556, 22.432> <-7.608, -12.070, 22.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.384, -12.070, 22.403> <-7.384, -11.462, 22.366> <-7.891, -10.956, 22.335> <-8.500, -10.956, 22.335> 
		<-7.443, -12.072, 22.371> <-7.443, -11.464, 22.334> <-7.891, -11.017, 22.307> <-8.500, -11.017, 22.307> 
		<-7.597, -12.074, 22.337> <-7.597, -11.588, 22.307> <-8.013, -11.173, 22.282> <-8.500, -11.173, 22.282> 
		<-7.608, -12.070, 22.403> <-7.608, -11.583, 22.373> <-8.013, -11.179, 22.349> <-8.500, -11.179, 22.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.392, -11.974, 23.855> <-9.392, -11.487, 23.826> <-8.987, -11.083, 23.801> <-8.500, -11.083, 23.801> 
		<-9.392, -12.002, 23.420> <-9.392, -11.516, 23.390> <-8.987, -11.112, 23.366> <-8.500, -11.112, 23.366> 
		<-9.326, -12.041, 22.834> <-9.326, -11.555, 22.804> <-8.987, -11.216, 22.784> <-8.500, -11.216, 22.784> 
		<-9.392, -12.070, 22.403> <-9.392, -11.583, 22.373> <-8.987, -11.179, 22.349> <-8.500, -11.179, 22.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.392, -11.974, 23.855> <-9.392, -12.002, 23.420> <-9.326, -12.041, 22.834> <-9.392, -12.070, 22.403> 
		<-9.392, -12.460, 23.885> <-9.392, -12.489, 23.449> <-9.326, -12.527, 22.863> <-9.392, -12.556, 22.432> 
		<-8.987, -12.864, 23.909> <-8.987, -12.893, 23.474> <-8.987, -12.866, 22.883> <-8.987, -12.960, 22.457> 
		<-8.500, -12.864, 23.909> <-8.500, -12.893, 23.474> <-8.500, -12.866, 22.883> <-8.500, -12.960, 22.457> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.864, 23.909> <-8.500, -12.893, 23.474> <-8.500, -12.866, 22.883> <-8.500, -12.960, 22.457> 
		<-8.013, -12.864, 23.909> <-8.013, -12.893, 23.474> <-8.013, -12.866, 22.883> <-8.013, -12.960, 22.457> 
		<-7.608, -12.460, 23.885> <-7.608, -12.489, 23.449> <-7.674, -12.527, 22.863> <-7.608, -12.556, 22.432> 
		<-7.608, -11.974, 23.855> <-7.608, -12.002, 23.420> <-7.674, -12.041, 22.834> <-7.608, -12.070, 22.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.608, -11.974, 23.855> <-7.608, -12.002, 23.420> <-7.674, -12.041, 22.834> <-7.608, -12.070, 22.403> 
		<-7.608, -11.487, 23.826> <-7.608, -11.516, 23.390> <-7.674, -11.555, 22.804> <-7.608, -11.583, 22.373> 
		<-8.013, -11.083, 23.801> <-8.013, -11.112, 23.366> <-8.013, -11.216, 22.784> <-8.013, -11.179, 22.349> 
		<-8.500, -11.083, 23.801> <-8.500, -11.112, 23.366> <-8.500, -11.216, 22.784> <-8.500, -11.179, 22.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.723, -12.055, 22.619> <-9.723, -12.055, 22.619> <-9.723, -12.055, 22.619> <-9.723, -12.055, 22.619> 
		<-9.723, -11.389, 22.579> <-9.723, -11.389, 22.579> <-9.723, -11.389, 22.579> <-9.723, -11.389, 22.579> 
		<-9.168, -10.834, 22.545> <-9.168, -10.834, 22.545> <-9.168, -10.834, 22.545> <-9.168, -10.834, 22.545> 
		<-8.500, -10.834, 22.545> <-8.500, -10.834, 22.545> <-8.500, -10.834, 22.545> <-8.500, -10.834, 22.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.723, -12.055, 22.619> <-9.723, -12.722, 22.660> <-9.168, -13.276, 22.693> <-8.500, -13.276, 22.693> 
		<-9.723, -12.055, 22.619> <-9.723, -12.722, 22.660> <-9.168, -13.276, 22.693> <-8.500, -13.276, 22.693> 
		<-9.723, -12.055, 22.619> <-9.723, -12.722, 22.660> <-9.168, -13.276, 22.693> <-8.500, -13.276, 22.693> 
		<-9.723, -12.055, 22.619> <-9.723, -12.722, 22.660> <-9.168, -13.276, 22.693> <-8.500, -13.276, 22.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.276, 22.693> <-7.832, -13.276, 22.693> <-7.277, -12.722, 22.660> <-7.277, -12.055, 22.619> 
		<-8.500, -13.276, 22.693> <-7.832, -13.276, 22.693> <-7.277, -12.722, 22.660> <-7.277, -12.055, 22.619> 
		<-8.500, -13.276, 22.693> <-7.832, -13.276, 22.693> <-7.277, -12.722, 22.660> <-7.277, -12.055, 22.619> 
		<-8.500, -13.276, 22.693> <-7.832, -13.276, 22.693> <-7.277, -12.722, 22.660> <-7.277, -12.055, 22.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.277, -12.055, 22.619> <-7.277, -11.389, 22.579> <-7.832, -10.834, 22.545> <-8.500, -10.834, 22.545> 
		<-7.277, -12.055, 22.619> <-7.277, -11.389, 22.579> <-7.832, -10.834, 22.545> <-8.500, -10.834, 22.545> 
		<-7.277, -12.055, 22.619> <-7.277, -11.389, 22.579> <-7.832, -10.834, 22.545> <-8.500, -10.834, 22.545> 
		<-7.277, -12.055, 22.619> <-7.277, -11.389, 22.579> <-7.832, -10.834, 22.545> <-8.500, -10.834, 22.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.723, -12.055, 22.619> <-9.723, -11.389, 22.579> <-9.168, -10.834, 22.545> <-8.500, -10.834, 22.545> 
		<-9.745, -12.051, 22.682> <-9.745, -11.385, 22.642> <-9.165, -10.809, 22.606> <-8.498, -10.809, 22.606> 
		<-9.756, -12.046, 22.760> <-9.753, -11.376, 22.721> <-9.159, -10.798, 22.683> <-8.487, -10.798, 22.681> 
		<-9.727, -12.041, 22.840> <-9.724, -11.371, 22.801> <-9.159, -10.821, 22.763> <-8.487, -10.821, 22.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.723, -12.055, 22.619> <-9.745, -12.051, 22.682> <-9.756, -12.046, 22.760> <-9.727, -12.041, 22.840> 
		<-9.723, -12.722, 22.660> <-9.745, -12.718, 22.722> <-9.759, -12.714, 22.800> <-9.730, -12.708, 22.880> 
		<-9.168, -13.276, 22.693> <-9.167, -13.293, 22.755> <-9.168, -13.296, 22.831> <-9.168, -13.263, 22.906> 
		<-8.500, -13.276, 22.693> <-8.500, -13.293, 22.755> <-8.499, -13.296, 22.830> <-8.499, -13.263, 22.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.276, 22.693> <-8.500, -13.293, 22.755> <-8.499, -13.296, 22.830> <-8.499, -13.263, 22.905> 
		<-7.832, -13.276, 22.693> <-7.832, -13.293, 22.755> <-7.832, -13.296, 22.829> <-7.832, -13.263, 22.904> 
		<-7.277, -12.722, 22.660> <-7.256, -12.718, 22.721> <-7.252, -12.712, 22.797> <-7.280, -12.707, 22.875> 
		<-7.277, -12.055, 22.619> <-7.256, -12.051, 22.681> <-7.248, -12.046, 22.758> <-7.277, -12.041, 22.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.277, -12.055, 22.619> <-7.256, -12.051, 22.681> <-7.248, -12.046, 22.758> <-7.277, -12.041, 22.836> 
		<-7.277, -11.389, 22.579> <-7.256, -11.385, 22.641> <-7.245, -11.384, 22.719> <-7.274, -11.379, 22.797> 
		<-7.832, -10.834, 22.545> <-7.830, -10.809, 22.606> <-7.824, -10.798, 22.680> <-7.824, -10.821, 22.761> 
		<-8.500, -10.834, 22.545> <-8.498, -10.809, 22.606> <-8.487, -10.798, 22.681> <-8.487, -10.821, 22.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.372, -11.634, 29.160> <-9.358, -11.630, 29.221> <-9.173, -11.630, 29.222> <-9.163, -11.634, 29.160> 
		<-9.372, -11.158, 29.131> <-9.358, -11.154, 29.193> <-9.173, -11.269, 29.200> <-9.163, -11.273, 29.138> 
		<-8.976, -10.763, 29.107> <-8.976, -10.774, 29.170> <-8.862, -10.958, 29.181> <-8.862, -10.972, 29.120> 
		<-8.500, -10.763, 29.107> <-8.500, -10.774, 29.170> <-8.500, -10.958, 29.181> <-8.500, -10.972, 29.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.372, -11.634, 29.160> <-9.372, -12.109, 29.189> <-8.976, -12.505, 29.213> <-8.500, -12.505, 29.213> 
		<-9.358, -11.630, 29.221> <-9.358, -12.105, 29.250> <-8.976, -12.486, 29.273> <-8.500, -12.486, 29.273> 
		<-9.173, -11.630, 29.222> <-9.173, -11.991, 29.244> <-8.862, -12.302, 29.263> <-8.500, -12.302, 29.263> 
		<-9.163, -11.634, 29.160> <-9.163, -11.995, 29.182> <-8.862, -12.295, 29.200> <-8.500, -12.295, 29.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.505, 29.213> <-8.024, -12.505, 29.213> <-7.628, -12.109, 29.189> <-7.628, -11.634, 29.160> 
		<-8.500, -12.486, 29.273> <-8.024, -12.486, 29.273> <-7.642, -12.105, 29.250> <-7.642, -11.630, 29.221> 
		<-8.500, -12.302, 29.263> <-8.138, -12.302, 29.263> <-7.827, -11.991, 29.244> <-7.827, -11.630, 29.222> 
		<-8.500, -12.295, 29.200> <-8.138, -12.295, 29.200> <-7.837, -11.995, 29.182> <-7.837, -11.634, 29.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.628, -11.634, 29.160> <-7.628, -11.158, 29.131> <-8.024, -10.763, 29.107> <-8.500, -10.763, 29.107> 
		<-7.642, -11.630, 29.221> <-7.642, -11.154, 29.193> <-8.024, -10.774, 29.170> <-8.500, -10.774, 29.170> 
		<-7.827, -11.630, 29.222> <-7.827, -11.269, 29.200> <-8.138, -10.958, 29.181> <-8.500, -10.958, 29.181> 
		<-7.837, -11.634, 29.160> <-7.837, -11.273, 29.138> <-8.138, -10.972, 29.120> <-8.500, -10.972, 29.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.163, -11.716, 27.913> <-9.163, -11.355, 27.891> <-8.862, -11.055, 27.873> <-8.500, -11.055, 27.873> 
		<-9.163, -11.692, 28.287> <-9.163, -11.331, 28.265> <-8.862, -11.030, 28.247> <-8.500, -11.030, 28.247> 
		<-9.101, -11.658, 28.791> <-9.101, -11.297, 28.769> <-8.862, -11.059, 28.755> <-8.500, -11.059, 28.755> 
		<-9.163, -11.634, 29.160> <-9.163, -11.273, 29.138> <-8.862, -10.972, 29.120> <-8.500, -10.972, 29.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.163, -11.716, 27.913> <-9.163, -11.692, 28.287> <-9.101, -11.658, 28.791> <-9.163, -11.634, 29.160> 
		<-9.163, -12.077, 27.935> <-9.163, -12.053, 28.309> <-9.101, -12.019, 28.813> <-9.163, -11.995, 29.182> 
		<-8.862, -12.378, 27.953> <-8.862, -12.353, 28.327> <-8.862, -12.258, 28.827> <-8.862, -12.295, 29.200> 
		<-8.500, -12.378, 27.953> <-8.500, -12.353, 28.327> <-8.500, -12.258, 28.827> <-8.500, -12.295, 29.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.378, 27.953> <-8.500, -12.353, 28.327> <-8.500, -12.258, 28.827> <-8.500, -12.295, 29.200> 
		<-8.138, -12.378, 27.953> <-8.138, -12.353, 28.327> <-8.138, -12.258, 28.827> <-8.138, -12.295, 29.200> 
		<-7.837, -12.077, 27.935> <-7.837, -12.053, 28.309> <-7.899, -12.019, 28.813> <-7.837, -11.995, 29.182> 
		<-7.837, -11.716, 27.913> <-7.837, -11.692, 28.287> <-7.899, -11.658, 28.791> <-7.837, -11.634, 29.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.837, -11.716, 27.913> <-7.837, -11.692, 28.287> <-7.899, -11.658, 28.791> <-7.837, -11.634, 29.160> 
		<-7.837, -11.355, 27.891> <-7.837, -11.331, 28.265> <-7.899, -11.297, 28.769> <-7.837, -11.273, 29.138> 
		<-8.138, -11.055, 27.873> <-8.138, -11.030, 28.247> <-8.138, -11.059, 28.755> <-8.138, -10.972, 29.120> 
		<-8.500, -11.055, 27.873> <-8.500, -11.030, 28.247> <-8.500, -11.059, 28.755> <-8.500, -10.972, 29.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.784, -14.487, -40.998> <-7.728, -14.520, -40.963> <-7.658, -14.604, -40.929> <-7.648, -14.676, -40.914> 
		<-7.831, -14.459, -41.026> <-7.774, -14.493, -40.991> <-7.707, -14.606, -40.961> <-7.698, -14.678, -40.946> 
		<-7.911, -14.463, -41.080> <-7.868, -14.519, -41.056> <-7.768, -14.607, -41.005> <-7.762, -14.681, -40.994> 
		<-7.959, -14.494, -41.103> <-7.915, -14.550, -41.078> <-7.820, -14.608, -41.033> <-7.814, -14.683, -41.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.258, -14.414, -40.045> <-8.322, -14.383, -40.071> <-8.423, -14.380, -40.128> <-8.485, -14.415, -40.153> 
		<-8.204, -14.440, -40.023> <-8.268, -14.409, -40.049> <-8.404, -14.434, -40.109> <-8.466, -14.469, -40.135> 
		<-8.144, -14.520, -40.010> <-8.231, -14.523, -40.035> <-8.345, -14.530, -40.066> <-8.429, -14.534, -40.097> 
		<-8.132, -14.583, -40.009> <-8.219, -14.586, -40.034> <-8.336, -14.589, -40.060> <-8.420, -14.593, -40.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.097, -14.692, -41.145> <-8.012, -14.689, -41.108> <-7.897, -14.686, -41.063> <-7.814, -14.683, -41.021> 
		<-8.140, -14.931, -41.129> <-8.056, -14.929, -41.091> <-7.879, -14.906, -41.029> <-7.796, -14.903, -40.986> 
		<-8.080, -15.294, -41.154> <-8.002, -15.271, -41.131> <-7.885, -15.242, -41.103> <-7.811, -15.240, -41.065> 
		<-8.141, -15.497, -41.033> <-8.064, -15.474, -41.010> <-7.957, -15.424, -40.995> <-7.883, -15.422, -40.957> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.097, -14.692, -41.145> <-8.097, -14.692, -41.145> <-8.097, -14.692, -41.145> <-8.097, -14.692, -41.145> 
		<-8.012, -14.689, -41.108> <-7.999, -14.617, -41.113> <-7.999, -14.617, -41.113> <-8.084, -14.620, -41.150> 
		<-7.897, -14.686, -41.063> <-7.903, -14.611, -41.075> <-7.972, -14.588, -41.105> <-8.016, -14.531, -41.130> 
		<-7.814, -14.683, -41.021> <-7.820, -14.608, -41.033> <-7.915, -14.550, -41.078> <-7.959, -14.494, -41.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.350, -15.527, -40.645> <-8.283, -15.509, -40.618> <-8.192, -15.470, -40.588> <-8.125, -15.466, -40.555> 
		<-8.417, -15.519, -40.515> <-8.349, -15.500, -40.488> <-8.268, -15.458, -40.444> <-8.201, -15.455, -40.410> 
		<-8.524, -15.571, -40.277> <-8.460, -15.543, -40.234> <-8.376, -15.491, -40.172> <-8.300, -15.490, -40.143> 
		<-8.558, -15.444, -40.213> <-8.495, -15.416, -40.170> <-8.423, -15.352, -40.099> <-8.347, -15.351, -40.070> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.350, -15.527, -40.645> <-8.290, -15.534, -40.763> <-8.175, -15.607, -40.967> <-8.141, -15.497, -41.033> 
		<-8.283, -15.509, -40.618> <-8.223, -15.516, -40.736> <-8.097, -15.584, -40.944> <-8.064, -15.474, -41.010> 
		<-8.192, -15.470, -40.588> <-8.127, -15.480, -40.713> <-8.003, -15.539, -40.926> <-7.957, -15.424, -40.995> 
		<-8.125, -15.466, -40.555> <-8.060, -15.476, -40.680> <-7.928, -15.537, -40.889> <-7.883, -15.422, -40.957> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.648, -14.676, -40.914> <-7.616, -14.914, -40.863> <-7.596, -15.279, -40.910> <-7.652, -15.482, -40.785> 
		<-7.698, -14.678, -40.946> <-7.666, -14.916, -40.895> <-7.666, -15.261, -40.961> <-7.721, -15.464, -40.836> 
		<-7.762, -14.681, -40.994> <-7.744, -14.901, -40.959> <-7.732, -15.238, -41.025> <-7.804, -15.420, -40.917> 
		<-7.814, -14.683, -41.021> <-7.796, -14.903, -40.986> <-7.811, -15.240, -41.065> <-7.883, -15.422, -40.957> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.652, -15.482, -40.785> <-7.681, -15.591, -40.718> <-7.809, -15.508, -40.522> <-7.872, -15.501, -40.407> 
		<-7.721, -15.464, -40.836> <-7.750, -15.573, -40.769> <-7.885, -15.498, -40.566> <-7.948, -15.491, -40.451> 
		<-7.804, -15.420, -40.917> <-7.850, -15.535, -40.849> <-7.980, -15.472, -40.640> <-8.046, -15.462, -40.515> 
		<-7.883, -15.422, -40.957> <-7.928, -15.537, -40.889> <-8.060, -15.476, -40.680> <-8.125, -15.466, -40.555> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.872, -15.501, -40.407> <-7.933, -15.494, -40.294> <-8.031, -15.551, -40.078> <-8.063, -15.436, -40.028> 
		<-7.948, -15.491, -40.451> <-8.009, -15.484, -40.338> <-8.116, -15.525, -40.090> <-8.148, -15.411, -40.041> 
		<-8.046, -15.462, -40.515> <-8.121, -15.450, -40.371> <-8.216, -15.488, -40.112> <-8.263, -15.350, -40.039> 
		<-8.125, -15.466, -40.555> <-8.201, -15.455, -40.410> <-8.300, -15.490, -40.143> <-8.347, -15.351, -40.070> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.558, -15.444, -40.213> <-8.495, -15.416, -40.170> <-8.423, -15.352, -40.099> <-8.347, -15.351, -40.070> 
		<-8.618, -15.225, -40.104> <-8.555, -15.198, -40.061> <-8.489, -15.159, -39.996> <-8.412, -15.158, -39.968> 
		<-8.619, -14.858, -40.201> <-8.565, -14.853, -40.173> <-8.444, -14.821, -40.094> <-8.387, -14.818, -40.072> 
		<-8.601, -14.607, -40.186> <-8.547, -14.603, -40.158> <-8.478, -14.596, -40.114> <-8.420, -14.593, -40.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.063, -15.436, -40.028> <-8.128, -15.208, -39.929> <-8.084, -14.835, -40.005> <-8.132, -14.583, -40.009> 
		<-8.148, -15.411, -40.041> <-8.213, -15.183, -39.942> <-8.171, -14.838, -40.030> <-8.219, -14.586, -40.034> 
		<-8.263, -15.350, -40.039> <-8.328, -15.156, -39.936> <-8.303, -14.814, -40.041> <-8.336, -14.589, -40.060> 
		<-8.347, -15.351, -40.070> <-8.412, -15.158, -39.968> <-8.387, -14.818, -40.072> <-8.420, -14.593, -40.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.601, -14.607, -40.186> <-8.601, -14.607, -40.186> <-8.601, -14.607, -40.186> <-8.601, -14.607, -40.186> 
		<-8.597, -14.539, -40.182> <-8.542, -14.535, -40.154> <-8.542, -14.535, -40.154> <-8.547, -14.603, -40.158> 
		<-8.541, -14.447, -40.176> <-8.521, -14.500, -40.158> <-8.486, -14.537, -40.119> <-8.478, -14.596, -40.114> 
		<-8.485, -14.415, -40.153> <-8.466, -14.469, -40.135> <-8.429, -14.534, -40.097> <-8.420, -14.593, -40.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.353, -16.393, -43.062> <-3.348, -16.237, -43.069> <-3.364, -16.020, -43.015> <-3.368, -15.892, -42.927> 
		<-3.612, -16.395, -43.094> <-3.606, -16.239, -43.101> <-3.619, -16.009, -43.040> <-3.623, -15.880, -42.952> 
		<-3.958, -16.420, -43.128> <-3.959, -16.252, -43.137> <-3.964, -16.021, -43.073> <-3.964, -15.881, -42.979> 
		<-4.219, -16.425, -43.131> <-4.219, -16.256, -43.141> <-4.220, -16.024, -43.072> <-4.221, -15.883, -42.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.353, -16.393, -43.062> <-3.612, -16.395, -43.094> <-3.958, -16.420, -43.128> <-4.219, -16.425, -43.131> 
		<-3.358, -16.539, -43.056> <-3.617, -16.541, -43.087> <-3.958, -16.573, -43.119> <-4.218, -16.578, -43.122> 
		<-3.390, -16.736, -42.982> <-3.634, -16.752, -42.999> <-3.973, -16.772, -43.025> <-4.218, -16.779, -43.027> 
		<-3.402, -16.844, -42.884> <-3.646, -16.860, -42.902> <-3.973, -16.884, -42.920> <-4.218, -16.891, -42.922> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.353, -16.393, -43.062> <-3.068, -16.390, -43.028> <-2.690, -16.413, -42.969> <-2.409, -16.410, -42.912> 
		<-3.348, -16.237, -43.069> <-3.063, -16.235, -43.035> <-2.692, -16.275, -42.970> <-2.411, -16.272, -42.913> 
		<-3.364, -16.020, -43.015> <-3.082, -16.033, -42.986> <-2.706, -16.048, -42.928> <-2.428, -16.077, -42.881> 
		<-3.368, -15.892, -42.927> <-3.086, -15.905, -42.899> <-2.712, -15.936, -42.848> <-2.435, -15.965, -42.801> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.353, -16.393, -43.062> <-3.358, -16.539, -43.056> <-3.390, -16.736, -42.982> <-3.402, -16.844, -42.884> 
		<-3.068, -16.390, -43.028> <-3.074, -16.536, -43.021> <-3.095, -16.716, -42.961> <-3.108, -16.824, -42.863> 
		<-2.690, -16.413, -42.969> <-2.688, -16.526, -42.968> <-2.710, -16.721, -42.918> <-2.713, -16.802, -42.839> 
		<-2.409, -16.410, -42.912> <-2.407, -16.523, -42.911> <-2.419, -16.687, -42.873> <-2.423, -16.768, -42.794> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.219, -16.425, -43.131> <-4.219, -16.256, -43.141> <-4.220, -16.024, -43.072> <-4.221, -15.883, -42.979> 
		<-4.481, -16.429, -43.134> <-4.482, -16.260, -43.144> <-4.478, -16.026, -43.072> <-4.479, -15.885, -42.979> 
		<-4.832, -16.423, -43.112> <-4.835, -16.262, -43.117> <-4.825, -16.022, -43.042> <-4.822, -15.890, -42.949> 
		<-5.092, -16.421, -43.084> <-5.096, -16.260, -43.089> <-5.082, -16.039, -43.019> <-5.078, -15.907, -42.926> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.219, -16.425, -43.131> <-4.481, -16.429, -43.134> <-4.832, -16.423, -43.112> <-5.092, -16.421, -43.084> 
		<-4.218, -16.578, -43.122> <-4.481, -16.582, -43.126> <-4.829, -16.575, -43.108> <-5.090, -16.573, -43.080> 
		<-4.218, -16.779, -43.027> <-4.471, -16.786, -43.029> <-4.816, -16.791, -43.013> <-5.067, -16.776, -42.997> 
		<-4.218, -16.891, -42.922> <-4.470, -16.898, -42.923> <-4.808, -16.904, -42.912> <-5.059, -16.889, -42.896> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.092, -16.421, -43.084> <-5.096, -16.260, -43.089> <-5.082, -16.039, -43.019> <-5.078, -15.907, -42.926> 
		<-5.377, -16.419, -43.053> <-5.380, -16.258, -43.058> <-5.346, -16.056, -42.996> <-5.343, -15.924, -42.902> 
		<-5.757, -16.420, -43.003> <-5.748, -16.288, -43.005> <-5.714, -16.071, -42.951> <-5.695, -15.967, -42.872> 
		<-6.035, -16.412, -42.935> <-6.027, -16.280, -42.938> <-5.975, -16.098, -42.903> <-5.956, -15.994, -42.825> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.092, -16.421, -43.084> <-5.377, -16.419, -43.053> <-5.757, -16.420, -43.003> <-6.035, -16.412, -42.935> 
		<-5.090, -16.573, -43.080> <-5.374, -16.571, -43.049> <-5.765, -16.539, -43.000> <-6.043, -16.530, -42.933> 
		<-5.067, -16.776, -42.997> <-5.354, -16.759, -42.978> <-5.734, -16.740, -42.943> <-6.014, -16.700, -42.889> 
		<-5.059, -16.889, -42.896> <-5.345, -16.872, -42.878> <-5.728, -16.826, -42.861> <-6.007, -16.787, -42.807> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.035, -16.412, -42.935> <-6.027, -16.280, -42.938> <-5.975, -16.098, -42.903> <-5.956, -15.994, -42.825> 
		<-6.266, -16.405, -42.879> <-6.258, -16.273, -42.882> <-6.212, -16.122, -42.860> <-6.193, -16.019, -42.781> 
		<-6.566, -16.381, -42.772> <-6.560, -16.291, -42.780> <-6.522, -16.090, -42.761> <-6.512, -16.022, -42.702> 
		<-6.782, -16.372, -42.675> <-6.777, -16.282, -42.683> <-6.745, -16.146, -42.683> <-6.735, -16.077, -42.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.035, -16.412, -42.935> <-6.266, -16.405, -42.879> <-6.566, -16.381, -42.772> <-6.782, -16.372, -42.675> 
		<-6.043, -16.530, -42.933> <-6.274, -16.524, -42.877> <-6.571, -16.469, -42.763> <-6.788, -16.461, -42.666> 
		<-6.014, -16.700, -42.889> <-6.251, -16.667, -42.844> <-6.552, -16.661, -42.715> <-6.773, -16.593, -42.638> 
		<-6.007, -16.787, -42.807> <-6.244, -16.753, -42.762> <-6.550, -16.717, -42.646> <-6.770, -16.650, -42.570> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.782, -16.372, -42.675> <-6.782, -16.372, -42.675> <-6.782, -16.372, -42.675> <-6.782, -16.372, -42.675> 
		<-6.788, -16.461, -42.666> <-6.985, -16.453, -42.578> <-6.985, -16.453, -42.578> <-6.979, -16.364, -42.587> 
		<-6.773, -16.593, -42.638> <-6.976, -16.531, -42.568> <-7.262, -16.586, -42.444> <-7.249, -16.364, -42.466> 
		<-6.770, -16.650, -42.570> <-6.973, -16.587, -42.499> <-7.422, -16.579, -42.299> <-7.408, -16.357, -42.320> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.782, -16.372, -42.675> <-6.782, -16.372, -42.675> <-6.782, -16.372, -42.675> <-6.782, -16.372, -42.675> 
		<-6.979, -16.364, -42.587> <-6.973, -16.274, -42.595> <-6.973, -16.274, -42.595> <-6.777, -16.282, -42.683> 
		<-7.249, -16.364, -42.466> <-7.234, -16.129, -42.488> <-6.963, -16.200, -42.608> <-6.745, -16.146, -42.683> 
		<-7.408, -16.357, -42.320> <-7.393, -16.121, -42.343> <-6.953, -16.132, -42.549> <-6.735, -16.077, -42.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.782, -16.372, -42.675> <-6.777, -16.282, -42.683> <-6.745, -16.146, -42.683> <-6.735, -16.077, -42.624> 
		<-6.788, -16.461, -42.666> <-6.782, -16.370, -42.675> <-6.963, -16.200, -42.608> <-6.953, -16.132, -42.549> 
		<-6.773, -16.593, -42.638> <-6.976, -16.531, -42.568> <-7.407, -16.343, -42.322> <-7.393, -16.121, -42.343> 
		<-6.770, -16.650, -42.570> <-6.973, -16.587, -42.499> <-7.422, -16.579, -42.299> <-7.408, -16.357, -42.320> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.409, -16.410, -42.912> <-2.152, -16.408, -42.860> <-1.805, -16.389, -42.801> <-1.563, -16.375, -42.700> 
		<-2.411, -16.272, -42.913> <-2.154, -16.270, -42.862> <-1.804, -16.296, -42.803> <-1.563, -16.282, -42.703> 
		<-2.428, -16.077, -42.881> <-2.176, -16.104, -42.837> <-1.832, -16.088, -42.767> <-1.595, -16.145, -42.688> 
		<-2.435, -15.965, -42.801> <-2.183, -15.992, -42.757> <-1.841, -16.020, -42.704> <-1.604, -16.077, -42.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.409, -16.410, -42.912> <-2.407, -16.523, -42.911> <-2.419, -16.687, -42.873> <-2.423, -16.768, -42.794> 
		<-2.152, -16.408, -42.860> <-2.151, -16.521, -42.859> <-2.170, -16.658, -42.834> <-2.173, -16.739, -42.755> 
		<-1.805, -16.389, -42.801> <-1.805, -16.472, -42.798> <-1.830, -16.652, -42.750> <-1.840, -16.704, -42.685> 
		<-1.563, -16.375, -42.700> <-1.564, -16.459, -42.697> <-1.598, -16.583, -42.673> <-1.608, -16.635, -42.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.563, -16.375, -42.700> <-1.563, -16.375, -42.700> <-1.563, -16.375, -42.700> <-1.563, -16.375, -42.700> 
		<-1.563, -16.282, -42.703> <-1.356, -16.271, -42.616> <-1.356, -16.271, -42.616> <-1.357, -16.364, -42.613> 
		<-1.595, -16.145, -42.688> <-1.377, -16.198, -42.614> <-1.093, -16.108, -42.461> <-1.095, -16.344, -42.454> 
		<-1.604, -16.077, -42.624> <-1.386, -16.130, -42.551> <-0.934, -16.092, -42.303> <-0.936, -16.328, -42.296> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.563, -16.375, -42.700> <-1.563, -16.375, -42.700> <-1.563, -16.375, -42.700> <-1.563, -16.375, -42.700> 
		<-1.357, -16.364, -42.613> <-1.357, -16.447, -42.611> <-1.357, -16.447, -42.611> <-1.564, -16.459, -42.697> 
		<-1.095, -16.344, -42.454> <-1.097, -16.584, -42.447> <-1.379, -16.518, -42.599> <-1.598, -16.583, -42.673> 
		<-0.936, -16.328, -42.296> <-0.937, -16.568, -42.289> <-1.388, -16.570, -42.534> <-1.608, -16.635, -42.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.563, -16.375, -42.700> <-1.563, -16.282, -42.703> <-1.595, -16.145, -42.688> <-1.604, -16.077, -42.624> 
		<-1.564, -16.459, -42.697> <-1.563, -16.366, -42.700> <-1.377, -16.198, -42.614> <-1.386, -16.130, -42.551> 
		<-1.598, -16.583, -42.673> <-1.379, -16.518, -42.599> <-0.936, -16.333, -42.296> <-0.934, -16.092, -42.303> 
		<-1.608, -16.635, -42.608> <-1.388, -16.570, -42.534> <-0.937, -16.568, -42.289> <-0.936, -16.328, -42.296> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.936, -16.314, -42.080> <-0.934, -16.078, -42.087> <-1.386, -16.116, -42.335> <-1.604, -16.063, -42.408> 
		<-0.936, -16.318, -42.145> <-0.934, -16.082, -42.152> <-1.386, -16.120, -42.400> <-1.604, -16.067, -42.473> 
		<-0.889, -16.323, -42.251> <-0.888, -16.088, -42.258> <-1.392, -16.083, -42.507> <-1.610, -16.030, -42.580> 
		<-0.936, -16.328, -42.296> <-0.934, -16.092, -42.303> <-1.386, -16.130, -42.551> <-1.604, -16.077, -42.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.936, -16.314, -42.080> <-0.936, -16.318, -42.145> <-0.889, -16.323, -42.251> <-0.936, -16.328, -42.296> 
		<-0.937, -16.554, -42.073> <-0.937, -16.558, -42.138> <-0.891, -16.564, -42.244> <-0.937, -16.568, -42.289> 
		<-1.388, -16.556, -42.318> <-1.388, -16.560, -42.383> <-1.395, -16.610, -42.484> <-1.388, -16.570, -42.534> 
		<-1.608, -16.621, -42.392> <-1.608, -16.625, -42.457> <-1.615, -16.675, -42.557> <-1.608, -16.635, -42.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.608, -16.621, -42.392> <-1.608, -16.625, -42.457> <-1.615, -16.675, -42.557> <-1.608, -16.635, -42.608> 
		<-1.840, -16.689, -42.469> <-1.840, -16.694, -42.534> <-1.847, -16.744, -42.635> <-1.840, -16.704, -42.685> 
		<-2.173, -16.725, -42.539> <-2.173, -16.729, -42.604> <-2.175, -16.786, -42.710> <-2.173, -16.739, -42.755> 
		<-2.423, -16.754, -42.578> <-2.423, -16.758, -42.642> <-2.425, -16.815, -42.748> <-2.423, -16.768, -42.794> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.423, -16.754, -42.578> <-2.423, -16.758, -42.642> <-2.425, -16.815, -42.748> <-2.423, -16.768, -42.794> 
		<-2.713, -16.788, -42.622> <-2.713, -16.792, -42.687> <-2.715, -16.849, -42.793> <-2.713, -16.802, -42.839> 
		<-3.108, -16.809, -42.647> <-3.108, -16.814, -42.712> <-3.113, -16.872, -42.820> <-3.108, -16.824, -42.863> 
		<-3.402, -16.829, -42.668> <-3.402, -16.834, -42.733> <-3.407, -16.892, -42.841> <-3.402, -16.844, -42.884> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.402, -16.829, -42.668> <-3.402, -16.834, -42.733> <-3.407, -16.892, -42.841> <-3.402, -16.844, -42.884> 
		<-3.646, -16.846, -42.685> <-3.646, -16.850, -42.750> <-3.652, -16.909, -42.858> <-3.646, -16.860, -42.902> 
		<-3.973, -16.870, -42.704> <-3.973, -16.874, -42.769> <-3.973, -16.931, -42.875> <-3.973, -16.884, -42.920> 
		<-4.218, -16.876, -42.705> <-4.218, -16.881, -42.770> <-4.218, -16.938, -42.877> <-4.218, -16.891, -42.922> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.218, -16.876, -42.705> <-4.218, -16.881, -42.770> <-4.218, -16.938, -42.877> <-4.218, -16.891, -42.922> 
		<-4.470, -16.883, -42.707> <-4.470, -16.888, -42.772> <-4.470, -16.945, -42.879> <-4.470, -16.898, -42.923> 
		<-4.808, -16.889, -42.696> <-4.808, -16.894, -42.761> <-4.804, -16.952, -42.869> <-4.808, -16.904, -42.912> 
		<-5.059, -16.875, -42.680> <-5.059, -16.879, -42.745> <-5.055, -16.937, -42.853> <-5.059, -16.889, -42.896> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.059, -16.875, -42.680> <-5.059, -16.879, -42.745> <-5.055, -16.937, -42.853> <-5.059, -16.889, -42.896> 
		<-5.345, -16.858, -42.661> <-5.345, -16.862, -42.726> <-5.342, -16.921, -42.834> <-5.345, -16.872, -42.878> 
		<-5.728, -16.811, -42.644> <-5.728, -16.816, -42.709> <-5.724, -16.873, -42.816> <-5.728, -16.826, -42.861> 
		<-6.007, -16.772, -42.591> <-6.007, -16.777, -42.656> <-6.004, -16.834, -42.762> <-6.007, -16.787, -42.807> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.007, -16.772, -42.591> <-6.007, -16.777, -42.656> <-6.004, -16.834, -42.762> <-6.007, -16.787, -42.807> 
		<-6.244, -16.739, -42.546> <-6.244, -16.743, -42.611> <-6.240, -16.800, -42.717> <-6.244, -16.753, -42.762> 
		<-6.550, -16.703, -42.430> <-6.550, -16.707, -42.495> <-6.548, -16.759, -42.596> <-6.550, -16.717, -42.646> 
		<-6.770, -16.635, -42.353> <-6.770, -16.640, -42.418> <-6.769, -16.691, -42.519> <-6.770, -16.650, -42.570> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.770, -16.635, -42.353> <-6.770, -16.640, -42.418> <-6.769, -16.691, -42.519> <-6.770, -16.650, -42.570> 
		<-6.973, -16.573, -42.283> <-6.973, -16.577, -42.348> <-6.971, -16.629, -42.449> <-6.973, -16.587, -42.499> 
		<-7.422, -16.564, -42.083> <-7.422, -16.569, -42.148> <-7.470, -16.576, -42.255> <-7.422, -16.579, -42.299> 
		<-7.408, -16.342, -42.104> <-7.408, -16.347, -42.169> <-7.456, -16.354, -42.277> <-7.408, -16.357, -42.320> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.408, -16.342, -42.104> <-7.408, -16.347, -42.169> <-7.456, -16.354, -42.277> <-7.408, -16.357, -42.320> 
		<-7.393, -16.107, -42.127> <-7.393, -16.111, -42.192> <-7.441, -16.119, -42.299> <-7.393, -16.121, -42.343> 
		<-6.953, -16.117, -42.333> <-6.953, -16.122, -42.397> <-6.945, -16.083, -42.507> <-6.953, -16.132, -42.549> 
		<-6.735, -16.063, -42.408> <-6.735, -16.067, -42.473> <-6.727, -16.028, -42.582> <-6.735, -16.077, -42.624> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.735, -16.063, -42.408> <-6.735, -16.067, -42.473> <-6.727, -16.028, -42.582> <-6.735, -16.077, -42.624> 
		<-6.512, -16.007, -42.486> <-6.512, -16.012, -42.550> <-6.504, -15.973, -42.660> <-6.512, -16.022, -42.702> 
		<-6.193, -16.004, -42.565> <-6.193, -16.009, -42.630> <-6.184, -15.967, -42.743> <-6.193, -16.019, -42.781> 
		<-5.956, -15.980, -42.608> <-5.956, -15.984, -42.673> <-5.946, -15.943, -42.786> <-5.956, -15.994, -42.825> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.956, -15.980, -42.608> <-5.956, -15.984, -42.673> <-5.946, -15.943, -42.786> <-5.956, -15.994, -42.825> 
		<-5.695, -15.953, -42.656> <-5.695, -15.957, -42.721> <-5.685, -15.916, -42.833> <-5.695, -15.967, -42.872> 
		<-5.343, -15.909, -42.686> <-5.343, -15.914, -42.751> <-5.341, -15.871, -42.865> <-5.343, -15.924, -42.902> 
		<-5.078, -15.892, -42.710> <-5.078, -15.897, -42.774> <-5.076, -15.854, -42.888> <-5.078, -15.907, -42.926> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.078, -15.892, -42.710> <-5.078, -15.897, -42.774> <-5.076, -15.854, -42.888> <-5.078, -15.907, -42.926> 
		<-4.822, -15.876, -42.732> <-4.822, -15.880, -42.797> <-4.820, -15.837, -42.911> <-4.822, -15.890, -42.949> 
		<-4.479, -15.871, -42.763> <-4.479, -15.875, -42.828> <-4.479, -15.831, -42.943> <-4.479, -15.885, -42.979> 
		<-4.221, -15.869, -42.763> <-4.221, -15.873, -42.828> <-4.221, -15.829, -42.943> <-4.221, -15.883, -42.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.221, -15.869, -42.763> <-4.221, -15.873, -42.828> <-4.221, -15.829, -42.943> <-4.221, -15.883, -42.979> 
		<-3.964, -15.867, -42.763> <-3.964, -15.871, -42.828> <-3.965, -15.827, -42.944> <-3.964, -15.881, -42.979> 
		<-3.623, -15.866, -42.736> <-3.623, -15.870, -42.801> <-3.624, -15.826, -42.916> <-3.623, -15.880, -42.952> 
		<-3.368, -15.877, -42.711> <-3.368, -15.882, -42.775> <-3.369, -15.838, -42.890> <-3.368, -15.892, -42.927> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.368, -15.877, -42.711> <-3.368, -15.882, -42.775> <-3.369, -15.838, -42.890> <-3.368, -15.892, -42.927> 
		<-3.086, -15.890, -42.682> <-3.086, -15.895, -42.747> <-3.087, -15.851, -42.862> <-3.086, -15.905, -42.899> 
		<-2.712, -15.922, -42.632> <-2.712, -15.926, -42.697> <-2.715, -15.883, -42.810> <-2.712, -15.936, -42.848> 
		<-2.435, -15.951, -42.584> <-2.435, -15.955, -42.649> <-2.438, -15.912, -42.763> <-2.435, -15.965, -42.801> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.435, -15.951, -42.584> <-2.435, -15.955, -42.649> <-2.438, -15.912, -42.763> <-2.435, -15.965, -42.801> 
		<-2.183, -15.977, -42.541> <-2.183, -15.982, -42.606> <-2.186, -15.939, -42.720> <-2.183, -15.992, -42.757> 
		<-1.841, -16.006, -42.488> <-1.841, -16.010, -42.553> <-1.847, -15.973, -42.660> <-1.841, -16.020, -42.704> 
		<-1.604, -16.063, -42.408> <-1.604, -16.067, -42.473> <-1.610, -16.030, -42.580> <-1.604, -16.077, -42.624> 
	}
	texture {brass_texture}
}
// Layer 2 - chrome parts
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.982, -8.019, 62.617> <0.823, -8.120, 62.617> <0.581, -8.238, 62.617> <0.392, -8.238, 62.617> 
		<0.982, -8.019, 62.158> <0.823, -8.120, 62.158> <0.581, -8.238, 62.103> <0.392, -8.238, 62.103> 
		<0.981, -7.758, 61.527> <0.753, -7.833, 61.453> <0.460, -7.950, 61.411> <0.209, -7.951, 61.411> 
		<0.980, -7.433, 61.203> <0.752, -7.508, 61.128> <0.423, -7.588, 61.049> <0.172, -7.589, 61.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.982, -8.019, 62.617> <0.982, -8.019, 62.158> <0.981, -7.758, 61.527> <0.980, -7.433, 61.203> 
		<1.021, -7.994, 62.617> <1.021, -7.994, 62.158> <1.024, -7.744, 61.541> <1.023, -7.419, 61.216> 
		<0.982, -7.864, 62.570> <0.982, -7.864, 62.147> <0.981, -7.623, 61.565> <0.980, -7.323, 61.266> 
		<0.982, -7.864, 62.617> <0.982, -7.864, 62.193> <0.981, -7.623, 61.612> <0.980, -7.323, 61.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.982, -8.019, 62.617> <0.982, -8.019, 63.076> <0.981, -7.758, 63.706> <0.980, -7.433, 64.031> 
		<0.823, -8.120, 62.617> <0.823, -8.120, 63.076> <0.753, -7.833, 63.781> <0.752, -7.508, 64.105> 
		<0.581, -8.238, 62.617> <0.581, -8.238, 63.130> <0.460, -7.950, 63.823> <0.423, -7.588, 64.185> 
		<0.392, -8.238, 62.617> <0.392, -8.238, 63.130> <0.209, -7.951, 63.823> <0.172, -7.589, 64.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.982, -8.019, 62.617> <1.021, -7.994, 62.617> <0.982, -7.864, 62.570> <0.982, -7.864, 62.617> 
		<0.982, -8.019, 63.076> <1.021, -7.994, 63.076> <0.982, -7.864, 62.994> <0.982, -7.864, 63.040> 
		<0.981, -7.758, 63.706> <1.024, -7.744, 63.693> <0.981, -7.623, 63.575> <0.981, -7.623, 63.622> 
		<0.980, -7.433, 64.031> <1.023, -7.419, 64.017> <0.980, -7.323, 63.875> <0.980, -7.323, 63.921> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.392, -8.238, 62.617> <0.256, -8.238, 62.617> <0.115, -8.087, 62.617> <-0.004, -8.022, 62.617> 
		<0.392, -8.238, 62.103> <0.256, -8.238, 62.103> <0.115, -8.087, 62.158> <-0.004, -8.022, 62.158> 
		<0.209, -7.951, 61.411> <0.122, -7.951, 61.411> <0.043, -7.807, 61.481> <-0.013, -7.761, 61.527> 
		<0.172, -7.589, 61.049> <0.086, -7.589, 61.049> <0.040, -7.482, 61.156> <-0.016, -7.436, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.392, -8.238, 62.617> <0.392, -8.238, 63.130> <0.209, -7.951, 63.823> <0.172, -7.589, 64.185> 
		<0.256, -8.238, 62.617> <0.256, -8.238, 63.130> <0.122, -7.951, 63.823> <0.086, -7.589, 64.185> 
		<0.115, -8.087, 62.617> <0.115, -8.087, 63.076> <0.043, -7.807, 63.753> <0.040, -7.482, 64.077> 
		<-0.004, -8.022, 62.617> <-0.004, -8.022, 63.076> <-0.013, -7.761, 63.706> <-0.016, -7.436, 64.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, -8.022, 62.617> <-0.004, -8.022, 62.617> <-0.004, -8.022, 62.617> <-0.004, -8.022, 62.617> 
		<-0.004, -8.022, 62.158> <-0.004, -8.022, 62.158> <-0.004, -8.022, 62.158> <-0.004, -8.022, 62.158> 
		<-0.013, -7.761, 61.527> <-0.013, -7.761, 61.527> <-0.013, -7.761, 61.527> <-0.013, -7.761, 61.527> 
		<-0.016, -7.436, 61.203> <-0.016, -7.436, 61.203> <-0.016, -7.436, 61.203> <-0.016, -7.436, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, -8.022, 62.617> <-0.004, -8.022, 63.076> <-0.013, -7.761, 63.706> <-0.016, -7.436, 64.031> 
		<-0.004, -8.022, 62.617> <-0.004, -8.022, 63.076> <-0.013, -7.761, 63.706> <-0.016, -7.436, 64.031> 
		<-0.004, -8.022, 62.617> <-0.004, -8.022, 63.076> <-0.013, -7.761, 63.706> <-0.016, -7.436, 64.031> 
		<-0.004, -8.022, 62.617> <-0.004, -8.022, 63.076> <-0.013, -7.761, 63.706> <-0.016, -7.436, 64.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.476, -8.250, 62.617> <-0.652, -8.250, 62.617> <-0.886, -8.141, 62.617> <-1.018, -8.025, 62.617> 
		<-0.476, -8.250, 62.101> <-0.652, -8.250, 62.101> <-0.886, -8.141, 62.158> <-1.018, -8.025, 62.158> 
		<-0.277, -7.961, 61.406> <-0.521, -7.962, 61.406> <-0.811, -7.853, 61.437> <-1.019, -7.764, 61.527> 
		<-0.239, -7.597, 61.042> <-0.483, -7.598, 61.042> <-0.812, -7.529, 61.112> <-1.020, -7.439, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.476, -8.250, 62.617> <-0.476, -8.250, 62.101> <-0.277, -7.961, 61.406> <-0.239, -7.597, 61.042> 
		<-0.319, -8.249, 62.617> <-0.319, -8.249, 62.101> <-0.182, -7.961, 61.406> <-0.144, -7.597, 61.042> 
		<-0.146, -8.090, 62.617> <-0.146, -8.090, 62.158> <-0.080, -7.809, 61.479> <-0.083, -7.484, 61.155> 
		<-0.004, -8.022, 62.617> <-0.004, -8.022, 62.158> <-0.013, -7.761, 61.527> <-0.016, -7.436, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.476, -8.250, 62.617> <-0.476, -8.250, 63.133> <-0.277, -7.961, 63.827> <-0.239, -7.597, 64.191> 
		<-0.652, -8.250, 62.617> <-0.652, -8.250, 63.133> <-0.521, -7.962, 63.827> <-0.483, -7.598, 64.191> 
		<-0.886, -8.141, 62.617> <-0.886, -8.141, 63.076> <-0.811, -7.853, 63.797> <-0.812, -7.529, 64.122> 
		<-1.018, -8.025, 62.617> <-1.018, -8.025, 63.076> <-1.019, -7.764, 63.706> <-1.020, -7.439, 64.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.476, -8.250, 62.617> <-0.319, -8.249, 62.617> <-0.146, -8.090, 62.617> <-0.004, -8.022, 62.617> 
		<-0.476, -8.250, 63.133> <-0.319, -8.249, 63.133> <-0.146, -8.090, 63.076> <-0.004, -8.022, 63.076> 
		<-0.277, -7.961, 63.827> <-0.182, -7.961, 63.827> <-0.080, -7.809, 63.754> <-0.013, -7.761, 63.706> 
		<-0.239, -7.597, 64.191> <-0.144, -7.597, 64.191> <-0.083, -7.484, 64.079> <-0.016, -7.436, 64.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.980, -7.433, 64.031> <0.979, -7.108, 64.356> <0.978, -6.478, 64.617> <0.976, -6.019, 64.617> 
		<0.752, -7.508, 64.105> <0.751, -7.183, 64.430> <0.749, -6.479, 64.722> <0.748, -6.019, 64.722> 
		<0.423, -7.588, 64.185> <0.387, -7.229, 64.544> <0.420, -6.530, 64.834> <0.419, -6.020, 64.834> 
		<0.172, -7.589, 64.185> <0.136, -7.230, 64.544> <0.169, -6.530, 64.834> <0.167, -6.021, 64.834> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.980, -7.433, 64.031> <1.023, -7.419, 64.017> <0.980, -7.323, 63.875> <0.980, -7.323, 63.921> 
		<0.979, -7.108, 64.356> <1.022, -7.094, 64.342> <0.979, -7.024, 64.175> <0.979, -7.024, 64.221> 
		<0.978, -6.478, 64.617> <1.020, -6.478, 64.597> <0.978, -6.442, 64.415> <0.978, -6.442, 64.462> 
		<0.976, -6.019, 64.617> <1.019, -6.019, 64.597> <0.976, -6.019, 64.415> <0.976, -6.019, 64.462> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, -6.019, 64.617> <0.975, -5.560, 64.617> <0.973, -4.929, 64.356> <0.972, -4.605, 64.031> 
		<0.748, -6.019, 64.722> <0.747, -5.560, 64.722> <0.745, -4.856, 64.430> <0.744, -4.531, 64.105> 
		<0.419, -6.020, 64.834> <0.417, -5.511, 64.834> <0.380, -4.812, 64.544> <0.414, -4.452, 64.185> 
		<0.167, -6.021, 64.834> <0.166, -5.512, 64.834> <0.129, -4.812, 64.544> <0.163, -4.453, 64.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, -6.019, 64.617> <1.019, -6.019, 64.597> <0.976, -6.019, 64.415> <0.976, -6.019, 64.462> 
		<0.975, -5.560, 64.617> <1.017, -5.559, 64.597> <0.975, -5.595, 64.415> <0.975, -5.595, 64.462> 
		<0.973, -4.929, 64.356> <1.015, -4.943, 64.342> <0.973, -5.014, 64.175> <0.973, -5.014, 64.221> 
		<0.972, -4.605, 64.031> <1.014, -4.618, 64.017> <0.973, -4.714, 63.875> <0.973, -4.714, 63.921> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.972, -4.605, 64.031> <0.971, -4.280, 63.706> <0.970, -4.019, 63.076> <0.970, -4.019, 62.617> 
		<0.744, -4.531, 64.105> <0.743, -4.206, 63.781> <0.810, -3.918, 63.076> <0.810, -3.918, 62.617> 
		<0.414, -4.452, 64.185> <0.449, -4.090, 63.823> <0.568, -3.802, 63.130> <0.568, -3.802, 62.617> 
		<0.163, -4.453, 64.185> <0.197, -4.091, 63.823> <0.379, -3.803, 63.130> <0.379, -3.803, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.972, -4.605, 64.031> <1.014, -4.618, 64.017> <0.973, -4.714, 63.875> <0.973, -4.714, 63.921> 
		<0.971, -4.280, 63.706> <1.014, -4.293, 63.693> <0.972, -4.415, 63.575> <0.972, -4.415, 63.622> 
		<0.970, -4.019, 63.076> <1.010, -4.043, 63.076> <0.971, -4.174, 62.994> <0.971, -4.174, 63.040> 
		<0.970, -4.019, 62.617> <1.010, -4.043, 62.617> <0.971, -4.174, 62.570> <0.971, -4.174, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.970, -4.019, 62.617> <0.970, -4.019, 62.158> <0.971, -4.280, 61.527> <0.972, -4.605, 61.203> 
		<0.810, -3.918, 62.617> <0.810, -3.918, 62.158> <0.743, -4.206, 61.453> <0.744, -4.531, 61.128> 
		<0.568, -3.802, 62.617> <0.568, -3.802, 62.103> <0.449, -4.090, 61.411> <0.414, -4.452, 61.049> 
		<0.379, -3.803, 62.617> <0.379, -3.803, 62.103> <0.197, -4.091, 61.411> <0.163, -4.453, 61.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.970, -4.019, 62.617> <1.010, -4.043, 62.617> <0.971, -4.174, 62.570> <0.971, -4.174, 62.617> 
		<0.970, -4.019, 62.158> <1.010, -4.043, 62.158> <0.971, -4.174, 62.147> <0.971, -4.174, 62.193> 
		<0.971, -4.280, 61.527> <1.014, -4.293, 61.541> <0.972, -4.415, 61.565> <0.972, -4.415, 61.612> 
		<0.972, -4.605, 61.203> <1.014, -4.618, 61.216> <0.973, -4.714, 61.266> <0.973, -4.714, 61.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.972, -4.605, 61.203> <0.973, -4.929, 60.878> <0.975, -5.560, 60.617> <0.976, -6.019, 60.617> 
		<0.744, -4.531, 61.128> <0.745, -4.856, 60.804> <0.747, -5.560, 60.512> <0.748, -6.019, 60.512> 
		<0.414, -4.452, 61.049> <0.380, -4.812, 60.690> <0.417, -5.511, 60.399> <0.419, -6.020, 60.399> 
		<0.163, -4.453, 61.049> <0.129, -4.812, 60.690> <0.166, -5.512, 60.399> <0.167, -6.021, 60.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.972, -4.605, 61.203> <1.014, -4.618, 61.216> <0.973, -4.714, 61.266> <0.973, -4.714, 61.312> 
		<0.973, -4.929, 60.878> <1.015, -4.943, 60.892> <0.973, -5.014, 60.966> <0.973, -5.014, 61.013> 
		<0.975, -5.560, 60.617> <1.017, -5.559, 60.636> <0.975, -5.595, 60.725> <0.975, -5.595, 60.772> 
		<0.976, -6.019, 60.617> <1.019, -6.019, 60.636> <0.976, -6.019, 60.725> <0.976, -6.019, 60.772> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, -6.019, 60.617> <0.978, -6.478, 60.617> <0.979, -7.108, 60.878> <0.980, -7.433, 61.203> 
		<0.748, -6.019, 60.512> <0.749, -6.479, 60.512> <0.751, -7.183, 60.804> <0.752, -7.508, 61.128> 
		<0.419, -6.020, 60.399> <0.420, -6.530, 60.399> <0.387, -7.229, 60.690> <0.423, -7.588, 61.049> 
		<0.167, -6.021, 60.399> <0.169, -6.530, 60.399> <0.136, -7.230, 60.690> <0.172, -7.589, 61.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, -6.019, 60.617> <1.019, -6.019, 60.636> <0.976, -6.019, 60.725> <0.976, -6.019, 60.772> 
		<0.978, -6.478, 60.617> <1.020, -6.478, 60.636> <0.978, -6.442, 60.725> <0.978, -6.442, 60.772> 
		<0.979, -7.108, 60.878> <1.022, -7.094, 60.892> <0.979, -7.024, 60.966> <0.979, -7.024, 61.013> 
		<0.980, -7.433, 61.203> <1.023, -7.419, 61.216> <0.980, -7.323, 61.266> <0.980, -7.323, 61.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.172, -7.589, 64.185> <0.136, -7.230, 64.544> <0.169, -6.530, 64.834> <0.167, -6.021, 64.834> 
		<0.086, -7.589, 64.185> <0.049, -7.230, 64.544> <0.083, -6.531, 64.834> <0.081, -6.021, 64.834> 
		<0.040, -7.482, 64.077> <0.038, -7.157, 64.402> <0.038, -6.481, 64.682> <0.036, -6.022, 64.682> 
		<-0.016, -7.436, 64.031> <-0.018, -7.111, 64.356> <-0.019, -6.481, 64.617> <-0.020, -6.022, 64.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -6.021, 64.834> <0.166, -5.512, 64.834> <0.129, -4.812, 64.544> <0.163, -4.453, 64.185> 
		<0.081, -6.021, 64.834> <0.080, -5.512, 64.834> <0.042, -4.813, 64.544> <0.077, -4.453, 64.185> 
		<0.036, -6.022, 64.682> <0.035, -5.562, 64.682> <0.031, -4.886, 64.402> <0.032, -4.561, 64.077> 
		<-0.020, -6.022, 64.617> <-0.021, -5.562, 64.617> <-0.025, -4.932, 64.356> <-0.024, -4.607, 64.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.163, -4.453, 64.185> <0.197, -4.091, 63.823> <0.379, -3.803, 63.130> <0.379, -3.803, 62.617> 
		<0.077, -4.453, 64.185> <0.111, -4.091, 63.823> <0.244, -3.803, 63.130> <0.244, -3.803, 62.617> 
		<0.032, -4.561, 64.077> <0.033, -4.236, 63.753> <0.103, -3.956, 63.076> <0.103, -3.956, 62.617> 
		<-0.024, -4.607, 64.031> <-0.023, -4.283, 63.706> <-0.016, -4.022, 63.076> <-0.016, -4.022, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.379, -3.803, 62.617> <0.379, -3.803, 62.103> <0.197, -4.091, 61.411> <0.163, -4.453, 61.049> 
		<0.244, -3.803, 62.617> <0.244, -3.803, 62.103> <0.111, -4.091, 61.411> <0.077, -4.453, 61.049> 
		<0.103, -3.956, 62.617> <0.103, -3.956, 62.158> <0.033, -4.236, 61.481> <0.032, -4.561, 61.156> 
		<-0.016, -4.022, 62.617> <-0.016, -4.022, 62.158> <-0.023, -4.283, 61.527> <-0.024, -4.607, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.163, -4.453, 61.049> <0.129, -4.812, 60.690> <0.166, -5.512, 60.399> <0.167, -6.021, 60.399> 
		<0.077, -4.453, 61.049> <0.042, -4.813, 60.690> <0.080, -5.512, 60.399> <0.081, -6.021, 60.399> 
		<0.032, -4.561, 61.156> <0.031, -4.886, 60.832> <0.035, -5.562, 60.552> <0.036, -6.022, 60.552> 
		<-0.024, -4.607, 61.203> <-0.025, -4.932, 60.878> <-0.021, -5.562, 60.617> <-0.020, -6.022, 60.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.167, -6.021, 60.399> <0.169, -6.530, 60.399> <0.136, -7.230, 60.690> <0.172, -7.589, 61.049> 
		<0.081, -6.021, 60.399> <0.083, -6.531, 60.399> <0.049, -7.230, 60.690> <0.086, -7.589, 61.049> 
		<0.036, -6.022, 60.552> <0.038, -6.481, 60.552> <0.038, -7.157, 60.832> <0.040, -7.482, 61.156> 
		<-0.020, -6.022, 60.617> <-0.019, -6.481, 60.617> <-0.018, -7.111, 60.878> <-0.016, -7.436, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, -7.436, 64.031> <-0.018, -7.111, 64.356> <-0.019, -6.481, 64.617> <-0.020, -6.022, 64.617> 
		<-0.016, -7.436, 64.031> <-0.018, -7.111, 64.356> <-0.019, -6.481, 64.617> <-0.020, -6.022, 64.617> 
		<-0.016, -7.436, 64.031> <-0.018, -7.111, 64.356> <-0.019, -6.481, 64.617> <-0.020, -6.022, 64.617> 
		<-0.016, -7.436, 64.031> <-0.018, -7.111, 64.356> <-0.019, -6.481, 64.617> <-0.020, -6.022, 64.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.020, -6.022, 64.617> <-0.021, -5.562, 64.617> <-0.025, -4.932, 64.356> <-0.024, -4.607, 64.031> 
		<-0.020, -6.022, 64.617> <-0.021, -5.562, 64.617> <-0.025, -4.932, 64.356> <-0.024, -4.607, 64.031> 
		<-0.020, -6.022, 64.617> <-0.021, -5.562, 64.617> <-0.025, -4.932, 64.356> <-0.024, -4.607, 64.031> 
		<-0.020, -6.022, 64.617> <-0.021, -5.562, 64.617> <-0.025, -4.932, 64.356> <-0.024, -4.607, 64.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.024, -4.607, 64.031> <-0.023, -4.283, 63.706> <-0.016, -4.022, 63.076> <-0.016, -4.022, 62.617> 
		<-0.024, -4.607, 64.031> <-0.023, -4.283, 63.706> <-0.016, -4.022, 63.076> <-0.016, -4.022, 62.617> 
		<-0.024, -4.607, 64.031> <-0.023, -4.283, 63.706> <-0.016, -4.022, 63.076> <-0.016, -4.022, 62.617> 
		<-0.024, -4.607, 64.031> <-0.023, -4.283, 63.706> <-0.016, -4.022, 63.076> <-0.016, -4.022, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, -4.022, 62.617> <-0.016, -4.022, 62.158> <-0.023, -4.283, 61.527> <-0.024, -4.607, 61.203> 
		<-0.016, -4.022, 62.617> <-0.016, -4.022, 62.158> <-0.023, -4.283, 61.527> <-0.024, -4.607, 61.203> 
		<-0.016, -4.022, 62.617> <-0.016, -4.022, 62.158> <-0.023, -4.283, 61.527> <-0.024, -4.607, 61.203> 
		<-0.016, -4.022, 62.617> <-0.016, -4.022, 62.158> <-0.023, -4.283, 61.527> <-0.024, -4.607, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.024, -4.607, 61.203> <-0.025, -4.932, 60.878> <-0.021, -5.562, 60.617> <-0.020, -6.022, 60.617> 
		<-0.024, -4.607, 61.203> <-0.025, -4.932, 60.878> <-0.021, -5.562, 60.617> <-0.020, -6.022, 60.617> 
		<-0.024, -4.607, 61.203> <-0.025, -4.932, 60.878> <-0.021, -5.562, 60.617> <-0.020, -6.022, 60.617> 
		<-0.024, -4.607, 61.203> <-0.025, -4.932, 60.878> <-0.021, -5.562, 60.617> <-0.020, -6.022, 60.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.020, -6.022, 60.617> <-0.019, -6.481, 60.617> <-0.018, -7.111, 60.878> <-0.016, -7.436, 61.203> 
		<-0.020, -6.022, 60.617> <-0.019, -6.481, 60.617> <-0.018, -7.111, 60.878> <-0.016, -7.436, 61.203> 
		<-0.020, -6.022, 60.617> <-0.019, -6.481, 60.617> <-0.018, -7.111, 60.878> <-0.016, -7.436, 61.203> 
		<-0.020, -6.022, 60.617> <-0.019, -6.481, 60.617> <-0.018, -7.111, 60.878> <-0.016, -7.436, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, -7.436, 64.031> <-0.018, -7.111, 64.356> <-0.019, -6.481, 64.617> <-0.020, -6.022, 64.617> 
		<-0.083, -7.484, 64.079> <-0.086, -7.159, 64.404> <-0.086, -6.481, 64.685> <-0.087, -6.022, 64.685> 
		<-0.144, -7.597, 64.191> <-0.106, -7.236, 64.552> <-0.147, -6.533, 64.844> <-0.148, -6.022, 64.844> 
		<-0.239, -7.597, 64.191> <-0.202, -7.236, 64.552> <-0.242, -6.534, 64.844> <-0.244, -6.022, 64.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.020, -6.022, 64.617> <-0.021, -5.562, 64.617> <-0.025, -4.932, 64.356> <-0.024, -4.607, 64.031> 
		<-0.087, -6.022, 64.685> <-0.089, -5.563, 64.685> <-0.092, -4.884, 64.404> <-0.091, -4.560, 64.079> 
		<-0.148, -6.022, 64.844> <-0.150, -5.511, 64.844> <-0.113, -4.808, 64.552> <-0.153, -4.448, 64.191> 
		<-0.244, -6.022, 64.844> <-0.245, -5.511, 64.844> <-0.209, -4.808, 64.552> <-0.249, -4.448, 64.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.024, -4.607, 64.031> <-0.023, -4.283, 63.706> <-0.016, -4.022, 63.076> <-0.016, -4.022, 62.617> 
		<-0.091, -4.560, 64.079> <-0.091, -4.235, 63.754> <-0.158, -3.954, 63.076> <-0.158, -3.954, 62.617> 
		<-0.153, -4.448, 64.191> <-0.193, -4.084, 63.827> <-0.332, -3.796, 63.133> <-0.332, -3.796, 62.617> 
		<-0.249, -4.448, 64.191> <-0.289, -4.084, 63.827> <-0.489, -3.796, 63.133> <-0.489, -3.796, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, -4.022, 62.617> <-0.016, -4.022, 62.158> <-0.023, -4.283, 61.527> <-0.024, -4.607, 61.203> 
		<-0.158, -3.954, 62.617> <-0.158, -3.954, 62.158> <-0.091, -4.235, 61.479> <-0.091, -4.560, 61.155> 
		<-0.332, -3.796, 62.617> <-0.332, -3.796, 62.101> <-0.193, -4.084, 61.406> <-0.153, -4.448, 61.042> 
		<-0.489, -3.796, 62.617> <-0.489, -3.796, 62.101> <-0.289, -4.084, 61.406> <-0.249, -4.448, 61.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.024, -4.607, 61.203> <-0.025, -4.932, 60.878> <-0.021, -5.562, 60.617> <-0.020, -6.022, 60.617> 
		<-0.091, -4.560, 61.155> <-0.092, -4.884, 60.830> <-0.089, -5.563, 60.549> <-0.087, -6.022, 60.549> 
		<-0.153, -4.448, 61.042> <-0.113, -4.808, 60.682> <-0.150, -5.511, 60.390> <-0.148, -6.022, 60.390> 
		<-0.249, -4.448, 61.042> <-0.209, -4.808, 60.682> <-0.245, -5.511, 60.390> <-0.244, -6.022, 60.390> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.020, -6.022, 60.617> <-0.019, -6.481, 60.617> <-0.018, -7.111, 60.878> <-0.016, -7.436, 61.203> 
		<-0.087, -6.022, 60.549> <-0.086, -6.481, 60.549> <-0.086, -7.159, 60.830> <-0.083, -7.484, 61.155> 
		<-0.148, -6.022, 60.390> <-0.147, -6.533, 60.390> <-0.106, -7.236, 60.682> <-0.144, -7.597, 61.042> 
		<-0.244, -6.022, 60.390> <-0.242, -6.534, 60.390> <-0.202, -7.236, 60.682> <-0.239, -7.597, 61.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.239, -7.597, 64.191> <-0.202, -7.236, 64.552> <-0.242, -6.534, 64.844> <-0.244, -6.022, 64.844> 
		<-0.483, -7.598, 64.191> <-0.445, -7.237, 64.552> <-0.486, -6.534, 64.844> <-0.488, -6.023, 64.844> 
		<-0.812, -7.529, 64.122> <-0.813, -7.204, 64.446> <-0.815, -6.483, 64.745> <-0.816, -6.024, 64.745> 
		<-1.020, -7.439, 64.031> <-1.021, -7.114, 64.356> <-1.022, -6.484, 64.617> <-1.024, -6.025, 64.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.244, -6.022, 64.844> <-0.245, -5.511, 64.844> <-0.209, -4.808, 64.552> <-0.249, -4.448, 64.191> 
		<-0.488, -6.023, 64.844> <-0.489, -5.512, 64.844> <-0.453, -4.809, 64.552> <-0.492, -4.449, 64.191> 
		<-0.816, -6.024, 64.745> <-0.818, -5.565, 64.745> <-0.820, -4.844, 64.446> <-0.821, -4.519, 64.122> 
		<-1.024, -6.025, 64.617> <-1.025, -5.565, 64.617> <-1.027, -4.935, 64.356> <-1.028, -4.610, 64.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.249, -4.448, 64.191> <-0.289, -4.084, 63.827> <-0.489, -3.796, 63.133> <-0.489, -3.796, 62.617> 
		<-0.492, -4.449, 64.191> <-0.532, -4.085, 63.827> <-0.665, -3.797, 63.133> <-0.665, -3.797, 62.617> 
		<-0.821, -4.519, 64.122> <-0.822, -4.195, 63.797> <-0.898, -3.907, 63.076> <-0.898, -3.907, 62.617> 
		<-1.028, -4.610, 64.031> <-1.029, -4.286, 63.706> <-1.030, -4.025, 63.076> <-1.030, -4.025, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.489, -3.796, 62.617> <-0.489, -3.796, 62.101> <-0.289, -4.084, 61.406> <-0.249, -4.448, 61.042> 
		<-0.665, -3.797, 62.617> <-0.665, -3.797, 62.101> <-0.532, -4.085, 61.406> <-0.492, -4.449, 61.042> 
		<-0.898, -3.907, 62.617> <-0.898, -3.907, 62.158> <-0.822, -4.195, 61.437> <-0.821, -4.519, 61.112> 
		<-1.030, -4.025, 62.617> <-1.030, -4.025, 62.158> <-1.029, -4.286, 61.527> <-1.028, -4.610, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.249, -4.448, 61.042> <-0.209, -4.808, 60.682> <-0.245, -5.511, 60.390> <-0.244, -6.022, 60.390> 
		<-0.492, -4.449, 61.042> <-0.453, -4.809, 60.682> <-0.489, -5.512, 60.390> <-0.488, -6.023, 60.390> 
		<-0.821, -4.519, 61.112> <-0.820, -4.844, 60.787> <-0.818, -5.565, 60.489> <-0.816, -6.024, 60.489> 
		<-1.028, -4.610, 61.203> <-1.027, -4.935, 60.878> <-1.025, -5.565, 60.617> <-1.024, -6.025, 60.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.244, -6.022, 60.390> <-0.242, -6.534, 60.390> <-0.202, -7.236, 60.682> <-0.239, -7.597, 61.042> 
		<-0.488, -6.023, 60.390> <-0.486, -6.534, 60.390> <-0.445, -7.237, 60.682> <-0.483, -7.598, 61.042> 
		<-0.816, -6.024, 60.489> <-0.815, -6.483, 60.489> <-0.813, -7.204, 60.787> <-0.812, -7.529, 61.112> 
		<-1.024, -6.025, 60.617> <-1.022, -6.484, 60.617> <-1.021, -7.114, 60.878> <-1.020, -7.439, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.903, -6.027, 60.735> <0.903, -6.027, 60.735> <0.903, -6.027, 60.735> <0.903, -6.027, 60.735> 
		<0.903, -7.055, 60.735> <0.903, -6.027, 60.735> <0.903, -6.027, 60.735> <0.903, -4.999, 60.735> 
		<0.895, -7.911, 61.591> <0.895, -6.781, 61.591> <0.895, -5.274, 61.591> <0.895, -4.144, 61.591> 
		<0.886, -7.911, 62.619> <0.886, -6.781, 62.619> <0.886, -5.274, 62.619> <0.886, -4.144, 62.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.870, -6.027, 64.502> <0.870, -6.027, 64.502> <0.870, -6.027, 64.502> <0.870, -6.027, 64.502> 
		<0.870, -4.999, 64.502> <0.870, -6.027, 64.502> <0.870, -6.027, 64.502> <0.870, -7.055, 64.502> 
		<0.877, -4.144, 63.647> <0.877, -5.274, 63.647> <0.877, -6.781, 63.647> <0.877, -7.911, 63.647> 
		<0.886, -4.144, 62.619> <0.886, -5.274, 62.619> <0.886, -6.781, 62.619> <0.886, -7.911, 62.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.899, -6.027, 60.735> <-0.899, -6.027, 60.735> <-0.899, -6.027, 60.735> <-0.899, -6.027, 60.735> 
		<-0.899, -7.055, 60.735> <-0.899, -6.027, 60.735> <-0.899, -6.027, 60.735> <-0.899, -4.999, 60.735> 
		<-0.906, -7.911, 61.591> <-0.906, -6.781, 61.591> <-0.906, -5.274, 61.591> <-0.906, -4.144, 61.591> 
		<-0.915, -7.911, 62.619> <-0.915, -6.781, 62.619> <-0.915, -5.274, 62.619> <-0.915, -4.144, 62.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.932, -6.027, 64.502> <-0.932, -6.027, 64.502> <-0.932, -6.027, 64.502> <-0.932, -6.027, 64.502> 
		<-0.932, -4.999, 64.502> <-0.932, -6.027, 64.502> <-0.932, -6.027, 64.502> <-0.932, -7.055, 64.502> 
		<-0.924, -4.144, 63.647> <-0.924, -5.274, 63.647> <-0.924, -6.781, 63.647> <-0.924, -7.911, 63.647> 
		<-0.915, -4.144, 62.619> <-0.915, -5.274, 62.619> <-0.915, -6.781, 62.619> <-0.915, -7.911, 62.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.982, -8.019, 62.617> <0.982, -7.972, 62.617> <0.982, -7.864, 62.570> <0.982, -7.864, 62.617> 
		<0.982, -8.019, 62.158> <0.982, -7.972, 62.158> <0.982, -7.864, 62.147> <0.982, -7.864, 62.193> 
		<0.981, -7.758, 61.527> <0.981, -7.725, 61.560> <0.981, -7.623, 61.565> <0.981, -7.623, 61.612> 
		<0.980, -7.433, 61.203> <0.980, -7.400, 61.236> <0.980, -7.323, 61.266> <0.980, -7.323, 61.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.982, -8.019, 62.617> <0.982, -8.019, 63.076> <0.981, -7.758, 63.706> <0.980, -7.433, 64.031> 
		<0.982, -7.972, 62.617> <0.982, -7.972, 63.076> <0.981, -7.725, 63.673> <0.980, -7.400, 63.998> 
		<0.982, -7.864, 62.570> <0.982, -7.864, 62.994> <0.981, -7.623, 63.575> <0.980, -7.323, 63.875> 
		<0.982, -7.864, 62.617> <0.982, -7.864, 63.040> <0.981, -7.623, 63.622> <0.980, -7.323, 63.921> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.980, -7.433, 64.031> <0.979, -7.108, 64.356> <0.978, -6.478, 64.617> <0.976, -6.019, 64.617> 
		<0.980, -7.400, 63.998> <0.979, -7.075, 64.323> <0.978, -6.478, 64.570> <0.976, -6.019, 64.570> 
		<0.980, -7.323, 63.875> <0.979, -7.024, 64.175> <0.978, -6.442, 64.415> <0.976, -6.019, 64.415> 
		<0.980, -7.323, 63.921> <0.979, -7.024, 64.221> <0.978, -6.442, 64.462> <0.976, -6.019, 64.462> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, -6.019, 64.617> <0.975, -5.560, 64.617> <0.973, -4.929, 64.356> <0.972, -4.605, 64.031> 
		<0.976, -6.019, 64.570> <0.975, -5.560, 64.570> <0.973, -4.962, 64.323> <0.972, -4.637, 63.998> 
		<0.976, -6.019, 64.415> <0.975, -5.595, 64.415> <0.973, -5.014, 64.175> <0.973, -4.714, 63.875> 
		<0.976, -6.019, 64.462> <0.975, -5.595, 64.462> <0.973, -5.014, 64.221> <0.973, -4.714, 63.921> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.972, -4.605, 64.031> <0.971, -4.280, 63.706> <0.970, -4.019, 63.076> <0.970, -4.019, 62.617> 
		<0.972, -4.637, 63.998> <0.971, -4.313, 63.673> <0.971, -4.065, 63.076> <0.971, -4.065, 62.617> 
		<0.973, -4.714, 63.875> <0.972, -4.415, 63.575> <0.971, -4.174, 62.994> <0.971, -4.174, 62.570> 
		<0.973, -4.714, 63.921> <0.972, -4.415, 63.622> <0.971, -4.174, 63.040> <0.971, -4.174, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.970, -4.019, 62.617> <0.970, -4.019, 62.158> <0.971, -4.280, 61.527> <0.972, -4.605, 61.203> 
		<0.971, -4.065, 62.617> <0.971, -4.065, 62.158> <0.971, -4.313, 61.560> <0.972, -4.637, 61.236> 
		<0.971, -4.174, 62.570> <0.971, -4.174, 62.147> <0.972, -4.415, 61.565> <0.973, -4.714, 61.266> 
		<0.971, -4.174, 62.617> <0.971, -4.174, 62.193> <0.972, -4.415, 61.612> <0.973, -4.714, 61.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.972, -4.605, 61.203> <0.973, -4.929, 60.878> <0.975, -5.560, 60.617> <0.976, -6.019, 60.617> 
		<0.972, -4.637, 61.236> <0.973, -4.962, 60.911> <0.975, -5.560, 60.663> <0.976, -6.019, 60.663> 
		<0.973, -4.714, 61.266> <0.973, -5.014, 60.966> <0.975, -5.595, 60.725> <0.976, -6.019, 60.725> 
		<0.973, -4.714, 61.312> <0.973, -5.014, 61.013> <0.975, -5.595, 60.772> <0.976, -6.019, 60.772> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, -6.019, 60.617> <0.978, -6.478, 60.617> <0.979, -7.108, 60.878> <0.980, -7.433, 61.203> 
		<0.976, -6.019, 60.663> <0.978, -6.478, 60.663> <0.979, -7.075, 60.911> <0.980, -7.400, 61.236> 
		<0.976, -6.019, 60.725> <0.978, -6.442, 60.725> <0.979, -7.024, 60.966> <0.980, -7.323, 61.266> 
		<0.976, -6.019, 60.772> <0.978, -6.442, 60.772> <0.979, -7.024, 61.013> <0.980, -7.323, 61.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.811, -7.864, 62.617> <0.862, -7.864, 62.617> <0.930, -7.864, 62.617> <0.982, -7.864, 62.617> 
		<0.811, -7.864, 62.193> <0.862, -7.864, 62.193> <0.930, -7.864, 62.193> <0.982, -7.864, 62.193> 
		<0.810, -7.623, 61.612> <0.861, -7.623, 61.612> <0.930, -7.623, 61.612> <0.981, -7.623, 61.612> 
		<0.809, -7.323, 61.312> <0.861, -7.323, 61.312> <0.929, -7.323, 61.312> <0.980, -7.323, 61.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.811, -7.864, 62.617> <0.811, -7.864, 63.040> <0.810, -7.623, 63.622> <0.809, -7.323, 63.921> 
		<0.862, -7.864, 62.617> <0.862, -7.864, 63.040> <0.861, -7.623, 63.622> <0.861, -7.323, 63.921> 
		<0.930, -7.864, 62.617> <0.930, -7.864, 63.040> <0.930, -7.623, 63.622> <0.929, -7.323, 63.921> 
		<0.982, -7.864, 62.617> <0.982, -7.864, 63.040> <0.981, -7.623, 63.622> <0.980, -7.323, 63.921> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.809, -7.323, 63.921> <0.809, -7.024, 64.221> <0.807, -6.442, 64.462> <0.806, -6.019, 64.462> 
		<0.861, -7.323, 63.921> <0.860, -7.024, 64.221> <0.858, -6.442, 64.462> <0.857, -6.019, 64.462> 
		<0.929, -7.323, 63.921> <0.928, -7.024, 64.221> <0.926, -6.442, 64.462> <0.925, -6.019, 64.462> 
		<0.980, -7.323, 63.921> <0.979, -7.024, 64.221> <0.978, -6.442, 64.462> <0.976, -6.019, 64.462> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.806, -6.019, 64.462> <0.804, -5.595, 64.462> <0.803, -5.014, 64.221> <0.802, -4.714, 63.921> 
		<0.857, -6.019, 64.462> <0.856, -5.595, 64.462> <0.854, -5.014, 64.221> <0.853, -4.714, 63.921> 
		<0.925, -6.019, 64.462> <0.924, -5.595, 64.462> <0.922, -5.014, 64.221> <0.921, -4.714, 63.921> 
		<0.976, -6.019, 64.462> <0.975, -5.595, 64.462> <0.973, -5.014, 64.221> <0.973, -4.714, 63.921> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.802, -4.714, 63.921> <0.801, -4.415, 63.622> <0.800, -4.174, 63.040> <0.800, -4.174, 62.617> 
		<0.853, -4.714, 63.921> <0.852, -4.415, 63.622> <0.851, -4.174, 63.040> <0.851, -4.174, 62.617> 
		<0.921, -4.714, 63.921> <0.920, -4.415, 63.622> <0.920, -4.174, 63.040> <0.920, -4.174, 62.617> 
		<0.973, -4.714, 63.921> <0.972, -4.415, 63.622> <0.971, -4.174, 63.040> <0.971, -4.174, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -4.174, 62.617> <0.800, -4.174, 62.193> <0.801, -4.415, 61.612> <0.802, -4.714, 61.312> 
		<0.851, -4.174, 62.617> <0.851, -4.174, 62.193> <0.852, -4.415, 61.612> <0.853, -4.714, 61.312> 
		<0.920, -4.174, 62.617> <0.920, -4.174, 62.193> <0.920, -4.415, 61.612> <0.921, -4.714, 61.312> 
		<0.971, -4.174, 62.617> <0.971, -4.174, 62.193> <0.972, -4.415, 61.612> <0.973, -4.714, 61.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.802, -4.714, 61.312> <0.803, -5.014, 61.013> <0.804, -5.595, 60.772> <0.806, -6.019, 60.772> 
		<0.853, -4.714, 61.312> <0.854, -5.014, 61.013> <0.856, -5.595, 60.772> <0.857, -6.019, 60.772> 
		<0.921, -4.714, 61.312> <0.922, -5.014, 61.013> <0.924, -5.595, 60.772> <0.925, -6.019, 60.772> 
		<0.973, -4.714, 61.312> <0.973, -5.014, 61.013> <0.975, -5.595, 60.772> <0.976, -6.019, 60.772> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.806, -6.019, 60.772> <0.807, -6.442, 60.772> <0.809, -7.024, 61.013> <0.809, -7.323, 61.312> 
		<0.857, -6.019, 60.772> <0.858, -6.442, 60.772> <0.860, -7.024, 61.013> <0.861, -7.323, 61.312> 
		<0.925, -6.019, 60.772> <0.926, -6.442, 60.772> <0.928, -7.024, 61.013> <0.929, -7.323, 61.312> 
		<0.976, -6.019, 60.772> <0.978, -6.442, 60.772> <0.979, -7.024, 61.013> <0.980, -7.323, 61.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.848, -7.807, 62.617> <-0.848, -7.807, 62.216> <-0.849, -7.580, 61.666> <-0.849, -7.296, 61.383> 
		<-0.899, -7.873, 62.617> <-0.899, -7.873, 62.216> <-0.900, -7.622, 61.612> <-0.900, -7.339, 61.329> 
		<-0.967, -7.959, 62.617> <-0.967, -7.959, 62.158> <-0.968, -7.721, 61.581> <-0.969, -7.396, 61.257> 
		<-1.018, -8.025, 62.617> <-1.018, -8.025, 62.158> <-1.019, -7.764, 61.527> <-1.020, -7.439, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.848, -7.807, 62.617> <-0.899, -7.873, 62.617> <-0.967, -7.959, 62.617> <-1.018, -8.025, 62.617> 
		<-0.848, -7.807, 63.018> <-0.899, -7.873, 63.018> <-0.967, -7.959, 63.076> <-1.018, -8.025, 63.076> 
		<-0.849, -7.580, 63.567> <-0.900, -7.622, 63.622> <-0.968, -7.721, 63.652> <-1.019, -7.764, 63.706> 
		<-0.849, -7.296, 63.851> <-0.900, -7.339, 63.905> <-0.969, -7.396, 63.977> <-1.020, -7.439, 64.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.849, -7.296, 63.851> <-0.900, -7.339, 63.905> <-0.969, -7.396, 63.977> <-1.020, -7.439, 64.031> 
		<-0.850, -7.013, 64.134> <-0.901, -7.056, 64.188> <-0.969, -7.071, 64.302> <-1.021, -7.114, 64.356> 
		<-0.852, -6.463, 64.362> <-0.903, -6.452, 64.438> <-0.971, -6.495, 64.540> <-1.022, -6.484, 64.617> 
		<-0.853, -6.063, 64.362> <-0.904, -6.051, 64.438> <-0.972, -6.036, 64.540> <-1.024, -6.025, 64.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.853, -6.063, 64.362> <-0.904, -6.051, 64.438> <-0.972, -6.036, 64.540> <-1.024, -6.025, 64.617> 
		<-0.854, -5.662, 64.362> <-0.905, -5.650, 64.438> <-0.974, -5.577, 64.540> <-1.025, -5.565, 64.617> 
		<-0.856, -5.112, 64.134> <-0.907, -5.046, 64.188> <-0.975, -5.001, 64.302> <-1.027, -4.935, 64.356> 
		<-0.857, -4.829, 63.851> <-0.908, -4.763, 63.905> <-0.976, -4.676, 63.977> <-1.028, -4.610, 64.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.857, -4.829, 63.851> <-0.908, -4.763, 63.905> <-0.976, -4.676, 63.977> <-1.028, -4.610, 64.031> 
		<-0.857, -4.545, 63.567> <-0.909, -4.480, 63.622> <-0.977, -4.351, 63.652> <-1.029, -4.286, 63.706> 
		<-0.858, -4.318, 63.018> <-0.910, -4.230, 63.018> <-0.978, -4.112, 63.076> <-1.030, -4.025, 63.076> 
		<-0.858, -4.318, 62.617> <-0.910, -4.230, 62.617> <-0.978, -4.112, 62.617> <-1.030, -4.025, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.858, -4.318, 62.617> <-0.910, -4.230, 62.617> <-0.978, -4.112, 62.617> <-1.030, -4.025, 62.617> 
		<-0.858, -4.318, 62.216> <-0.910, -4.230, 62.216> <-0.978, -4.112, 62.158> <-1.030, -4.025, 62.158> 
		<-0.857, -4.545, 61.666> <-0.909, -4.480, 61.612> <-0.977, -4.351, 61.581> <-1.029, -4.286, 61.527> 
		<-0.857, -4.829, 61.383> <-0.908, -4.763, 61.329> <-0.976, -4.676, 61.257> <-1.028, -4.610, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.857, -4.829, 61.383> <-0.908, -4.763, 61.329> <-0.976, -4.676, 61.257> <-1.028, -4.610, 61.203> 
		<-0.856, -5.112, 61.100> <-0.907, -5.046, 61.046> <-0.975, -5.001, 60.932> <-1.027, -4.935, 60.878> 
		<-0.854, -5.662, 60.872> <-0.905, -5.650, 60.795> <-0.974, -5.577, 60.693> <-1.025, -5.565, 60.617> 
		<-0.853, -6.063, 60.872> <-0.904, -6.051, 60.795> <-0.972, -6.036, 60.693> <-1.024, -6.025, 60.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.853, -6.063, 60.872> <-0.904, -6.051, 60.795> <-0.972, -6.036, 60.693> <-1.024, -6.025, 60.617> 
		<-0.852, -6.463, 60.872> <-0.903, -6.452, 60.795> <-0.971, -6.495, 60.693> <-1.022, -6.484, 60.617> 
		<-0.850, -7.013, 61.100> <-0.901, -7.056, 61.046> <-0.969, -7.071, 60.932> <-1.021, -7.114, 60.878> 
		<-0.849, -7.296, 61.383> <-0.900, -7.339, 61.329> <-0.969, -7.396, 61.257> <-1.020, -7.439, 61.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.018, -8.025, 62.617> <-1.075, -7.974, 62.617> <-1.066, -7.830, 62.617> <-1.019, -7.769, 62.617> 
		<-1.018, -8.025, 62.158> <-1.075, -7.974, 62.158> <-1.066, -7.830, 62.216> <-1.019, -7.769, 62.216> 
		<-1.019, -7.764, 61.527> <-1.084, -7.735, 61.556> <-1.065, -7.580, 61.618> <-1.019, -7.542, 61.666> 
		<-1.020, -7.439, 61.203> <-1.085, -7.411, 61.231> <-1.066, -7.297, 61.335> <-1.020, -7.258, 61.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.018, -8.025, 62.617> <-1.018, -8.025, 63.076> <-1.019, -7.764, 63.706> <-1.020, -7.439, 64.031> 
		<-1.075, -7.974, 62.617> <-1.075, -7.974, 63.076> <-1.084, -7.735, 63.678> <-1.085, -7.411, 64.003> 
		<-1.066, -7.830, 62.617> <-1.066, -7.830, 63.018> <-1.065, -7.580, 63.616> <-1.066, -7.297, 63.899> 
		<-1.019, -7.769, 62.617> <-1.019, -7.769, 63.018> <-1.019, -7.542, 63.567> <-1.020, -7.258, 63.851> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.020, -7.439, 64.031> <-1.021, -7.114, 64.356> <-1.022, -6.484, 64.617> <-1.024, -6.025, 64.617> 
		<-1.085, -7.411, 64.003> <-1.086, -7.086, 64.327> <-1.087, -6.484, 64.577> <-1.089, -6.025, 64.577> 
		<-1.066, -7.297, 63.899> <-1.066, -7.013, 64.182> <-1.065, -6.416, 64.425> <-1.066, -6.015, 64.425> 
		<-1.020, -7.258, 63.851> <-1.021, -6.975, 64.134> <-1.023, -6.425, 64.362> <-1.024, -6.025, 64.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.024, -6.025, 64.617> <-1.025, -5.565, 64.617> <-1.027, -4.935, 64.356> <-1.028, -4.610, 64.031> 
		<-1.089, -6.025, 64.577> <-1.090, -5.566, 64.577> <-1.092, -4.964, 64.327> <-1.093, -4.639, 64.003> 
		<-1.066, -6.015, 64.425> <-1.067, -5.615, 64.425> <-1.066, -5.024, 64.176> <-1.067, -4.740, 63.892> 
		<-1.024, -6.025, 64.362> <-1.025, -5.624, 64.362> <-1.026, -5.074, 64.134> <-1.027, -4.791, 63.851> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, -4.610, 64.031> <-1.029, -4.286, 63.706> <-1.030, -4.025, 63.076> <-1.030, -4.025, 62.617> 
		<-1.093, -4.639, 64.003> <-1.094, -4.314, 63.678> <-1.087, -4.076, 63.076> <-1.087, -4.076, 62.617> 
		<-1.067, -4.740, 63.892> <-1.068, -4.457, 63.609> <-1.067, -4.214, 63.018> <-1.067, -4.214, 62.617> 
		<-1.027, -4.791, 63.851> <-1.028, -4.507, 63.567> <-1.029, -4.280, 63.018> <-1.029, -4.280, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.030, -4.025, 62.617> <-1.030, -4.025, 62.158> <-1.029, -4.286, 61.527> <-1.028, -4.610, 61.203> 
		<-1.087, -4.076, 62.617> <-1.087, -4.076, 62.158> <-1.094, -4.314, 61.556> <-1.093, -4.639, 61.231> 
		<-1.067, -4.214, 62.617> <-1.067, -4.214, 62.216> <-1.068, -4.457, 61.625> <-1.067, -4.740, 61.341> 
		<-1.029, -4.280, 62.617> <-1.029, -4.280, 62.216> <-1.028, -4.507, 61.666> <-1.027, -4.791, 61.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.028, -4.610, 61.203> <-1.027, -4.935, 60.878> <-1.025, -5.565, 60.617> <-1.024, -6.025, 60.617> 
		<-1.093, -4.639, 61.231> <-1.092, -4.964, 60.906> <-1.090, -5.566, 60.657> <-1.089, -6.025, 60.657> 
		<-1.067, -4.740, 61.341> <-1.066, -5.024, 61.058> <-1.067, -5.615, 60.809> <-1.066, -6.015, 60.809> 
		<-1.027, -4.791, 61.383> <-1.026, -5.074, 61.100> <-1.025, -5.624, 60.872> <-1.024, -6.025, 60.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.024, -6.025, 60.617> <-1.022, -6.484, 60.617> <-1.021, -7.114, 60.878> <-1.020, -7.439, 61.203> 
		<-1.089, -6.025, 60.657> <-1.087, -6.484, 60.657> <-1.086, -7.086, 60.906> <-1.085, -7.411, 61.231> 
		<-1.066, -6.015, 60.809> <-1.065, -6.416, 60.809> <-1.066, -7.013, 61.051> <-1.066, -7.297, 61.335> 
		<-1.024, -6.025, 60.872> <-1.023, -6.425, 60.872> <-1.021, -6.975, 61.100> <-1.020, -7.258, 61.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.848, -7.807, 62.617> <-0.848, -7.807, 62.216> <-0.849, -7.580, 61.666> <-0.849, -7.296, 61.383> 
		<-0.899, -7.796, 62.617> <-0.899, -7.796, 62.216> <-0.900, -7.568, 61.666> <-0.901, -7.285, 61.383> 
		<-0.986, -7.728, 62.617> <-0.986, -7.728, 62.216> <-0.988, -7.516, 61.699> <-0.989, -7.232, 61.416> 
		<-1.019, -7.769, 62.617> <-1.019, -7.769, 62.216> <-1.019, -7.542, 61.666> <-1.020, -7.258, 61.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.848, -7.807, 62.617> <-0.899, -7.796, 62.617> <-0.986, -7.728, 62.617> <-1.019, -7.769, 62.617> 
		<-0.848, -7.807, 63.018> <-0.899, -7.796, 63.018> <-0.986, -7.728, 63.018> <-1.019, -7.769, 63.018> 
		<-0.849, -7.580, 63.567> <-0.900, -7.568, 63.567> <-0.988, -7.516, 63.534> <-1.019, -7.542, 63.567> 
		<-0.849, -7.296, 63.851> <-0.901, -7.285, 63.851> <-0.989, -7.232, 63.818> <-1.020, -7.258, 63.851> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.849, -7.296, 63.851> <-0.901, -7.285, 63.851> <-0.989, -7.232, 63.818> <-1.020, -7.258, 63.851> 
		<-0.850, -7.013, 64.134> <-0.901, -7.002, 64.134> <-0.990, -6.949, 64.101> <-1.021, -6.975, 64.134> 
		<-0.852, -6.463, 64.362> <-0.903, -6.452, 64.362> <-0.994, -6.432, 64.319> <-1.023, -6.425, 64.362> 
		<-0.853, -6.063, 64.362> <-0.904, -6.051, 64.362> <-0.995, -6.031, 64.319> <-1.024, -6.025, 64.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.853, -6.063, 64.362> <-0.904, -6.051, 64.362> <-0.995, -6.031, 64.319> <-1.024, -6.025, 64.362> 
		<-0.854, -5.662, 64.362> <-0.905, -5.650, 64.362> <-0.996, -5.630, 64.319> <-1.025, -5.624, 64.362> 
		<-0.856, -5.112, 64.134> <-0.907, -5.101, 64.134> <-0.999, -5.109, 64.105> <-1.026, -5.074, 64.134> 
		<-0.857, -4.829, 63.851> <-0.908, -4.817, 63.851> <-1.000, -4.825, 63.822> <-1.027, -4.791, 63.851> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.857, -4.829, 63.851> <-0.908, -4.817, 63.851> <-1.000, -4.825, 63.822> <-1.027, -4.791, 63.851> 
		<-0.857, -4.545, 63.567> <-0.909, -4.534, 63.567> <-1.001, -4.542, 63.539> <-1.028, -4.507, 63.567> 
		<-0.858, -4.318, 63.018> <-0.909, -4.306, 63.018> <-1.002, -4.325, 63.018> <-1.029, -4.280, 63.018> 
		<-0.858, -4.318, 62.617> <-0.909, -4.306, 62.617> <-1.002, -4.325, 62.617> <-1.029, -4.280, 62.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.858, -4.318, 62.617> <-0.909, -4.306, 62.617> <-1.002, -4.325, 62.617> <-1.029, -4.280, 62.617> 
		<-0.858, -4.318, 62.216> <-0.909, -4.306, 62.216> <-1.002, -4.325, 62.216> <-1.029, -4.280, 62.216> 
		<-0.857, -4.545, 61.666> <-0.909, -4.534, 61.666> <-1.001, -4.542, 61.695> <-1.028, -4.507, 61.666> 
		<-0.857, -4.829, 61.383> <-0.908, -4.817, 61.383> <-1.000, -4.825, 61.412> <-1.027, -4.791, 61.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.857, -4.829, 61.383> <-0.908, -4.817, 61.383> <-1.000, -4.825, 61.412> <-1.027, -4.791, 61.383> 
		<-0.856, -5.112, 61.100> <-0.907, -5.101, 61.100> <-0.999, -5.109, 61.128> <-1.026, -5.074, 61.100> 
		<-0.854, -5.662, 60.872> <-0.905, -5.650, 60.872> <-0.996, -5.630, 60.915> <-1.025, -5.624, 60.872> 
		<-0.853, -6.063, 60.872> <-0.904, -6.051, 60.872> <-0.995, -6.031, 60.915> <-1.024, -6.025, 60.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.853, -6.063, 60.872> <-0.904, -6.051, 60.872> <-0.995, -6.031, 60.915> <-1.024, -6.025, 60.872> 
		<-0.852, -6.463, 60.872> <-0.903, -6.452, 60.872> <-0.994, -6.432, 60.915> <-1.023, -6.425, 60.872> 
		<-0.850, -7.013, 61.100> <-0.901, -7.002, 61.100> <-0.990, -6.949, 61.133> <-1.021, -6.975, 61.100> 
		<-0.849, -7.296, 61.383> <-0.901, -7.285, 61.383> <-0.989, -7.232, 61.416> <-1.020, -7.258, 61.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.997, 0.003, 61.349> <-0.997, 0.003, 61.349> <-0.997, 0.003, 61.349> <-0.997, 0.003, 61.349> 
		<-0.997, 0.547, 61.348> <-0.997, 0.003, 61.349> <-0.997, 0.003, 61.349> <-0.997, -0.541, 61.350> 
		<-0.544, 1.000, 61.347> <-0.544, 0.402, 61.348> <-0.544, -0.396, 61.349> <-0.544, -0.994, 61.350> 
		<0.000, 1.000, 61.347> <0.000, 0.402, 61.348> <0.000, -0.396, 61.349> <0.000, -0.994, 61.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.997, 0.003, 61.349> <-0.997, 0.547, 61.348> <-0.544, 1.000, 61.347> <0.000, 1.000, 61.347> 
		<-0.997, 0.001, 59.817> <-0.997, 0.545, 59.816> <-0.544, 0.998, 59.815> <0.000, 0.998, 59.815> 
		<-0.997, -0.001, 57.774> <-0.997, 0.543, 57.773> <-0.544, 0.996, 57.773> <0.000, 0.996, 57.773> 
		<-0.997, -0.003, 56.242> <-0.997, 0.541, 56.241> <-0.544, 0.994, 56.241> <0.000, 0.994, 56.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.997, 0.003, 61.349> <-0.997, 0.001, 59.817> <-0.997, -0.001, 57.774> <-0.997, -0.003, 56.242> 
		<-0.997, -0.541, 61.350> <-0.997, -0.543, 59.818> <-0.997, -0.545, 57.775> <-0.997, -0.547, 56.243> 
		<-0.544, -0.994, 61.350> <-0.544, -0.996, 59.818> <-0.544, -0.998, 57.776> <-0.544, -1.000, 56.244> 
		<0.000, -0.994, 61.350> <0.000, -0.996, 59.818> <0.000, -0.998, 57.776> <0.000, -1.000, 56.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.997, 0.003, 61.349> <0.997, -0.541, 61.350> <0.544, -0.994, 61.350> <0.000, -0.994, 61.350> 
		<0.997, 0.001, 59.817> <0.997, -0.543, 59.818> <0.544, -0.996, 59.818> <0.000, -0.996, 59.818> 
		<0.997, -0.001, 57.774> <0.997, -0.545, 57.775> <0.544, -0.998, 57.776> <0.000, -0.998, 57.776> 
		<0.997, -0.003, 56.242> <0.997, -0.547, 56.243> <0.544, -1.000, 56.244> <0.000, -1.000, 56.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.997, 0.003, 61.349> <0.997, 0.003, 61.349> <0.997, 0.003, 61.349> <0.997, 0.003, 61.349> 
		<0.997, -0.541, 61.350> <0.997, 0.003, 61.349> <0.997, 0.003, 61.349> <0.997, 0.547, 61.348> 
		<0.544, -0.994, 61.350> <0.544, -0.396, 61.349> <0.544, 0.402, 61.348> <0.544, 1.000, 61.347> 
		<0.000, -0.994, 61.350> <0.000, -0.396, 61.349> <0.000, 0.402, 61.348> <0.000, 1.000, 61.347> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.997, 0.003, 61.349> <0.997, 0.001, 59.817> <0.997, -0.001, 57.774> <0.997, -0.003, 56.242> 
		<0.997, 0.547, 61.348> <0.997, 0.545, 59.816> <0.997, 0.543, 57.773> <0.997, 0.541, 56.241> 
		<0.544, 1.000, 61.347> <0.544, 0.998, 59.815> <0.544, 0.996, 57.773> <0.544, 0.994, 56.241> 
		<0.000, 1.000, 61.347> <0.000, 0.998, 59.815> <0.000, 0.996, 57.773> <0.000, 0.994, 56.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.997, -0.003, 56.242> <-0.997, -0.003, 56.242> <-0.997, -0.003, 56.242> <-0.997, -0.003, 56.242> 
		<-0.997, -0.547, 56.243> <-0.997, -0.003, 56.242> <-0.997, -0.003, 56.242> <-0.997, 0.541, 56.241> 
		<-0.544, -1.000, 56.244> <-0.544, -0.402, 56.243> <-0.544, 0.396, 56.242> <-0.544, 0.994, 56.241> 
		<0.000, -1.000, 56.244> <0.000, -0.402, 56.243> <0.000, 0.396, 56.242> <0.000, 0.994, 56.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.997, -0.003, 56.242> <0.997, -0.003, 56.242> <0.997, -0.003, 56.242> <0.997, -0.003, 56.242> 
		<0.997, 0.541, 56.241> <0.997, -0.003, 56.242> <0.997, -0.003, 56.242> <0.997, -0.547, 56.243> 
		<0.544, 0.994, 56.241> <0.544, 0.396, 56.242> <0.544, -0.402, 56.243> <0.544, -1.000, 56.244> 
		<0.000, 0.994, 56.241> <0.000, 0.396, 56.242> <0.000, -0.402, 56.243> <0.000, -1.000, 56.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, -10.492, 61.284> <-0.800, -10.492, 61.284> <-0.800, -10.492, 61.284> <-0.800, -10.492, 61.284> 
		<-0.800, -10.056, 61.288> <-0.800, -10.492, 61.284> <-0.800, -10.492, 61.284> <-0.800, -10.929, 61.280> 
		<-0.436, -9.693, 61.292> <-0.436, -10.173, 61.287> <-0.436, -10.812, 61.281> <-0.436, -11.292, 61.277> 
		<0.000, -9.693, 61.292> <0.000, -10.173, 61.287> <0.000, -10.812, 61.281> <0.000, -11.292, 61.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, -10.492, 61.284> <-0.800, -10.056, 61.288> <-0.436, -9.693, 61.292> <0.000, -9.693, 61.292> 
		<-0.800, -10.488, 59.025> <-0.800, -10.052, 59.029> <-0.436, -9.688, 59.032> <0.000, -9.688, 59.032> 
		<-0.856, -10.482, 56.012> <-0.856, -10.045, 56.016> <-0.436, -9.682, 56.020> <0.000, -9.682, 56.020> 
		<-0.800, -10.477, 53.753> <-0.800, -10.041, 53.757> <-0.436, -9.678, 53.760> <0.000, -9.678, 53.760> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, -10.492, 61.284> <-0.800, -10.488, 59.025> <-0.856, -10.482, 56.012> <-0.800, -10.477, 53.753> 
		<-0.800, -10.929, 61.280> <-0.800, -10.924, 59.021> <-0.856, -10.918, 56.008> <-0.800, -10.914, 53.749> 
		<-0.436, -11.292, 61.277> <-0.436, -11.287, 59.017> <-0.436, -11.281, 56.005> <-0.436, -11.277, 53.745> 
		<0.000, -11.292, 61.277> <0.000, -11.287, 59.017> <0.000, -11.281, 56.005> <0.000, -11.277, 53.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -10.492, 61.284> <0.800, -10.929, 61.280> <0.436, -11.292, 61.277> <0.000, -11.292, 61.277> 
		<0.800, -10.488, 59.025> <0.800, -10.924, 59.021> <0.436, -11.287, 59.017> <0.000, -11.287, 59.017> 
		<0.856, -10.482, 56.012> <0.856, -10.918, 56.008> <0.436, -11.281, 56.005> <0.000, -11.281, 56.005> 
		<0.800, -10.477, 53.753> <0.800, -10.914, 53.749> <0.436, -11.277, 53.745> <0.000, -11.277, 53.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -10.492, 61.284> <0.800, -10.492, 61.284> <0.800, -10.492, 61.284> <0.800, -10.492, 61.284> 
		<0.800, -10.929, 61.280> <0.800, -10.492, 61.284> <0.800, -10.492, 61.284> <0.800, -10.056, 61.288> 
		<0.436, -11.292, 61.277> <0.436, -10.812, 61.281> <0.436, -10.173, 61.287> <0.436, -9.693, 61.292> 
		<0.000, -11.292, 61.277> <0.000, -10.812, 61.281> <0.000, -10.173, 61.287> <0.000, -9.693, 61.292> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, -10.492, 61.284> <0.800, -10.488, 59.025> <0.856, -10.482, 56.012> <0.800, -10.477, 53.753> 
		<0.800, -10.056, 61.288> <0.800, -10.052, 59.029> <0.856, -10.045, 56.016> <0.800, -10.041, 53.757> 
		<0.436, -9.693, 61.292> <0.436, -9.688, 59.032> <0.436, -9.682, 56.020> <0.436, -9.678, 53.760> 
		<0.000, -9.693, 61.292> <0.000, -9.688, 59.032> <0.000, -9.682, 56.020> <0.000, -9.678, 53.760> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.608, -10.477, 53.604> <-0.666, -10.477, 53.648> <-0.798, -10.477, 53.680> <-0.800, -10.477, 53.753> 
		<-0.608, -10.145, 53.607> <-0.666, -10.145, 53.652> <-0.798, -10.041, 53.684> <-0.800, -10.041, 53.757> 
		<-0.332, -9.869, 53.609> <-0.332, -9.812, 53.655> <-0.436, -9.735, 53.715> <-0.436, -9.678, 53.760> 
		<0.000, -9.869, 53.609> <0.000, -9.812, 53.655> <0.000, -9.735, 53.715> <0.000, -9.678, 53.760> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.608, -10.477, 53.604> <-0.608, -10.809, 53.601> <-0.332, -11.086, 53.598> <0.000, -11.086, 53.598> 
		<-0.666, -10.477, 53.648> <-0.666, -10.809, 53.645> <-0.332, -11.143, 53.642> <0.000, -11.143, 53.642> 
		<-0.798, -10.477, 53.680> <-0.798, -10.914, 53.676> <-0.436, -11.220, 53.701> <0.000, -11.220, 53.701> 
		<-0.800, -10.477, 53.753> <-0.800, -10.914, 53.749> <-0.436, -11.277, 53.745> <0.000, -11.277, 53.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.086, 53.598> <0.332, -11.086, 53.598> <0.608, -10.809, 53.601> <0.608, -10.477, 53.604> 
		<0.000, -11.143, 53.642> <0.332, -11.143, 53.642> <0.666, -10.809, 53.645> <0.666, -10.477, 53.648> 
		<0.000, -11.220, 53.701> <0.436, -11.220, 53.701> <0.798, -10.914, 53.676> <0.798, -10.477, 53.680> 
		<0.000, -11.277, 53.745> <0.436, -11.277, 53.745> <0.800, -10.914, 53.749> <0.800, -10.477, 53.753> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.608, -10.477, 53.604> <0.608, -10.145, 53.607> <0.332, -9.869, 53.609> <0.000, -9.869, 53.609> 
		<0.666, -10.477, 53.648> <0.666, -10.145, 53.652> <0.332, -9.812, 53.655> <0.000, -9.812, 53.655> 
		<0.798, -10.477, 53.680> <0.798, -10.041, 53.684> <0.436, -9.735, 53.715> <0.000, -9.735, 53.715> 
		<0.800, -10.477, 53.753> <0.800, -10.041, 53.757> <0.436, -9.678, 53.760> <0.000, -9.678, 53.760> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, -10.477, 53.753> <-0.800, -10.477, 53.753> <-0.800, -10.477, 53.753> <-0.800, -10.477, 53.753> 
		<-0.800, -10.914, 53.749> <-0.800, -10.477, 53.753> <-0.800, -10.477, 53.753> <-0.800, -10.041, 53.757> 
		<-0.436, -11.277, 53.745> <-0.436, -10.797, 53.750> <-0.436, -10.158, 53.756> <-0.436, -9.678, 53.760> 
		<0.000, -11.277, 53.745> <0.000, -10.797, 53.750> <0.000, -10.158, 53.756> <0.000, -9.678, 53.760> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.277, 53.745> <0.000, -11.277, 53.745> <0.000, -11.277, 53.745> <0.000, -11.277, 53.745> 
		<0.436, -11.277, 53.745> <0.436, -10.797, 53.750> <0.436, -10.797, 53.750> <0.000, -10.797, 53.750> 
		<0.800, -10.914, 53.749> <0.800, -10.477, 53.753> <0.436, -10.158, 53.756> <0.000, -10.158, 53.756> 
		<0.800, -10.477, 53.753> <0.800, -10.041, 53.757> <0.436, -9.678, 53.760> <0.000, -9.678, 53.760> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, -8.500, 32.000> <-0.532, -7.000, 32.000> <-0.531, -5.000, 32.000> <-0.557, -3.500, 32.000> 
		<-0.557, -8.500, 31.696> <-0.532, -7.000, 31.696> <-0.531, -5.000, 31.696> <-0.557, -3.500, 31.696> 
		<-0.304, -8.500, 31.443> <-0.304, -7.000, 31.443> <-0.304, -5.000, 31.443> <-0.304, -3.500, 31.443> 
		<0.000, -8.500, 31.443> <0.000, -7.000, 31.443> <0.000, -5.000, 31.443> <0.000, -3.500, 31.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, -8.500, 32.000> <-0.557, -8.500, 32.000> <-0.557, -8.500, 32.000> <-0.557, -8.500, 32.000> 
		<-0.557, -8.500, 32.304> <-0.557, -8.500, 32.000> <-0.557, -8.500, 32.000> <-0.557, -8.500, 31.696> 
		<-0.304, -8.500, 32.557> <-0.304, -8.500, 32.223> <-0.304, -8.500, 31.777> <-0.304, -8.500, 31.443> 
		<0.000, -8.500, 32.557> <0.000, -8.500, 32.223> <0.000, -8.500, 31.777> <0.000, -8.500, 31.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, -8.500, 32.000> <-0.557, -8.500, 31.696> <-0.304, -8.500, 31.443> <0.000, -8.500, 31.443> 
		<-0.557, -8.544, 32.000> <-0.557, -8.544, 31.696> <-0.304, -8.536, 31.418> <0.000, -8.536, 31.418> 
		<-0.639, -8.577, 32.000> <-0.639, -8.577, 31.650> <-0.350, -8.577, 31.361> <0.000, -8.577, 31.361> 
		<-0.641, -8.621, 32.000> <-0.641, -8.621, 31.650> <-0.350, -8.621, 31.359> <0.000, -8.621, 31.359> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, -8.500, 32.000> <-0.557, -8.500, 32.304> <-0.304, -8.500, 32.557> <0.000, -8.500, 32.557> 
		<-0.532, -7.000, 32.000> <-0.532, -7.000, 32.304> <-0.304, -7.000, 32.557> <0.000, -7.000, 32.557> 
		<-0.531, -5.000, 32.000> <-0.531, -5.000, 32.304> <-0.304, -5.000, 32.557> <0.000, -5.000, 32.557> 
		<-0.557, -3.500, 32.000> <-0.557, -3.500, 32.304> <-0.304, -3.500, 32.557> <0.000, -3.500, 32.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, -8.500, 32.000> <-0.557, -8.500, 32.304> <-0.304, -8.500, 32.557> <0.000, -8.500, 32.557> 
		<-0.557, -8.544, 32.000> <-0.557, -8.544, 32.304> <-0.304, -8.536, 32.582> <0.000, -8.536, 32.582> 
		<-0.639, -8.577, 32.000> <-0.639, -8.577, 32.350> <-0.350, -8.577, 32.639> <0.000, -8.577, 32.639> 
		<-0.641, -8.621, 32.000> <-0.641, -8.621, 32.350> <-0.350, -8.621, 32.641> <0.000, -8.621, 32.641> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -8.500, 32.557> <0.000, -8.500, 32.557> <0.000, -8.500, 32.557> <0.000, -8.500, 32.557> 
		<0.304, -8.500, 32.557> <0.304, -8.500, 32.223> <0.304, -8.500, 32.223> <0.000, -8.500, 32.223> 
		<0.557, -8.500, 32.304> <0.557, -8.500, 32.000> <0.304, -8.500, 31.777> <0.000, -8.500, 31.777> 
		<0.557, -8.500, 32.000> <0.557, -8.500, 31.696> <0.304, -8.500, 31.443> <0.000, -8.500, 31.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -8.500, 32.557> <0.304, -8.500, 32.557> <0.557, -8.500, 32.304> <0.557, -8.500, 32.000> 
		<0.000, -7.000, 32.557> <0.304, -7.000, 32.557> <0.532, -7.000, 32.304> <0.532, -7.000, 32.000> 
		<0.000, -5.000, 32.557> <0.304, -5.000, 32.557> <0.531, -5.000, 32.304> <0.531, -5.000, 32.000> 
		<0.000, -3.500, 32.557> <0.304, -3.500, 32.557> <0.557, -3.500, 32.304> <0.557, -3.500, 32.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -8.500, 32.557> <0.304, -8.500, 32.557> <0.557, -8.500, 32.304> <0.557, -8.500, 32.000> 
		<0.000, -8.536, 32.582> <0.304, -8.536, 32.582> <0.557, -8.544, 32.304> <0.557, -8.544, 32.000> 
		<0.000, -8.577, 32.639> <0.350, -8.577, 32.639> <0.639, -8.577, 32.350> <0.639, -8.577, 32.000> 
		<0.000, -8.621, 32.641> <0.350, -8.621, 32.641> <0.641, -8.621, 32.350> <0.641, -8.621, 32.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.557, -8.500, 32.000> <0.557, -8.500, 31.696> <0.304, -8.500, 31.443> <0.000, -8.500, 31.443> 
		<0.532, -7.000, 32.000> <0.532, -7.000, 31.696> <0.304, -7.000, 31.443> <0.000, -7.000, 31.443> 
		<0.531, -5.000, 32.000> <0.531, -5.000, 31.696> <0.304, -5.000, 31.443> <0.000, -5.000, 31.443> 
		<0.557, -3.500, 32.000> <0.557, -3.500, 31.696> <0.304, -3.500, 31.443> <0.000, -3.500, 31.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.557, -8.500, 32.000> <0.557, -8.500, 31.696> <0.304, -8.500, 31.443> <0.000, -8.500, 31.443> 
		<0.557, -8.544, 32.000> <0.557, -8.544, 31.696> <0.304, -8.536, 31.418> <0.000, -8.536, 31.418> 
		<0.639, -8.577, 32.000> <0.639, -8.577, 31.650> <0.350, -8.577, 31.361> <0.000, -8.577, 31.361> 
		<0.641, -8.621, 32.000> <0.641, -8.621, 31.650> <0.350, -8.621, 31.359> <0.000, -8.621, 31.359> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.641, -11.621, 32.000> <-0.641, -10.721, 32.000> <-0.665, -9.520, 32.000> <-0.641, -8.621, 32.000> 
		<-0.641, -11.621, 31.650> <-0.641, -10.721, 31.650> <-0.665, -9.520, 31.650> <-0.641, -8.621, 31.650> 
		<-0.350, -11.621, 31.359> <-0.350, -10.721, 31.359> <-0.350, -9.520, 31.335> <-0.350, -8.621, 31.359> 
		<0.000, -11.621, 31.359> <0.000, -10.721, 31.359> <0.000, -9.520, 31.335> <0.000, -8.621, 31.359> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.641, -11.621, 32.000> <-0.641, -11.621, 32.350> <-0.350, -11.621, 32.641> <0.000, -11.621, 32.641> 
		<-0.641, -10.721, 32.000> <-0.641, -10.721, 32.350> <-0.350, -10.721, 32.641> <0.000, -10.721, 32.641> 
		<-0.665, -9.520, 32.000> <-0.665, -9.520, 32.350> <-0.350, -9.520, 32.665> <0.000, -9.520, 32.665> 
		<-0.641, -8.621, 32.000> <-0.641, -8.621, 32.350> <-0.350, -8.621, 32.641> <0.000, -8.621, 32.641> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.621, 32.641> <0.350, -11.621, 32.641> <0.641, -11.621, 32.350> <0.641, -11.621, 32.000> 
		<0.000, -10.721, 32.641> <0.350, -10.721, 32.641> <0.641, -10.721, 32.350> <0.641, -10.721, 32.000> 
		<0.000, -9.520, 32.665> <0.350, -9.520, 32.665> <0.665, -9.520, 32.350> <0.665, -9.520, 32.000> 
		<0.000, -8.621, 32.641> <0.350, -8.621, 32.641> <0.641, -8.621, 32.350> <0.641, -8.621, 32.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.641, -11.621, 32.000> <0.641, -11.621, 31.650> <0.350, -11.621, 31.359> <0.000, -11.621, 31.359> 
		<0.641, -10.721, 32.000> <0.641, -10.721, 31.650> <0.350, -10.721, 31.359> <0.000, -10.721, 31.359> 
		<0.665, -9.520, 32.000> <0.665, -9.520, 31.650> <0.350, -9.520, 31.335> <0.000, -9.520, 31.335> 
		<0.641, -8.621, 32.000> <0.641, -8.621, 31.650> <0.350, -8.621, 31.359> <0.000, -8.621, 31.359> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, -3.500, 32.000> <-0.557, -3.500, 32.000> <-0.557, -3.500, 32.000> <-0.557, -3.500, 32.000> 
		<-0.557, -3.500, 31.696> <-0.557, -3.500, 32.000> <-0.557, -3.500, 32.000> <-0.557, -3.500, 32.304> 
		<-0.304, -3.500, 31.443> <-0.304, -3.500, 31.777> <-0.304, -3.500, 32.223> <-0.304, -3.500, 32.557> 
		<0.000, -3.500, 31.443> <0.000, -3.500, 31.777> <0.000, -3.500, 32.223> <0.000, -3.500, 32.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, -3.500, 32.000> <-0.558, -3.443, 32.000> <-0.644, -3.388, 32.000> <-0.646, -3.331, 32.000> 
		<-0.557, -3.500, 31.696> <-0.558, -3.443, 31.696> <-0.644, -3.388, 31.647> <-0.646, -3.331, 31.647> 
		<-0.304, -3.500, 31.443> <-0.304, -3.449, 31.417> <-0.353, -3.388, 31.356> <-0.353, -3.331, 31.354> 
		<0.000, -3.500, 31.443> <0.000, -3.449, 31.417> <0.000, -3.388, 31.356> <0.000, -3.331, 31.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, -3.500, 32.000> <-0.557, -3.500, 32.304> <-0.304, -3.500, 32.557> <0.000, -3.500, 32.557> 
		<-0.558, -3.443, 32.000> <-0.558, -3.443, 32.304> <-0.304, -3.449, 32.583> <0.000, -3.449, 32.583> 
		<-0.644, -3.388, 32.000> <-0.644, -3.388, 32.353> <-0.353, -3.388, 32.644> <0.000, -3.388, 32.644> 
		<-0.646, -3.331, 32.000> <-0.646, -3.331, 32.353> <-0.353, -3.331, 32.646> <0.000, -3.331, 32.646> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -3.500, 32.557> <0.000, -3.500, 32.557> <0.000, -3.500, 32.557> <0.000, -3.500, 32.557> 
		<0.000, -3.500, 32.223> <0.304, -3.500, 32.223> <0.304, -3.500, 32.223> <0.304, -3.500, 32.557> 
		<0.000, -3.500, 31.777> <0.304, -3.500, 31.777> <0.557, -3.500, 32.000> <0.557, -3.500, 32.304> 
		<0.000, -3.500, 31.443> <0.304, -3.500, 31.443> <0.557, -3.500, 31.696> <0.557, -3.500, 32.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -3.500, 32.557> <0.304, -3.500, 32.557> <0.557, -3.500, 32.304> <0.557, -3.500, 32.000> 
		<0.000, -3.449, 32.583> <0.304, -3.449, 32.583> <0.558, -3.443, 32.304> <0.558, -3.443, 32.000> 
		<0.000, -3.388, 32.644> <0.353, -3.388, 32.644> <0.644, -3.388, 32.353> <0.644, -3.388, 32.000> 
		<0.000, -3.331, 32.646> <0.353, -3.331, 32.646> <0.646, -3.331, 32.353> <0.646, -3.331, 32.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.557, -3.500, 32.000> <0.557, -3.500, 31.696> <0.304, -3.500, 31.443> <0.000, -3.500, 31.443> 
		<0.558, -3.443, 32.000> <0.558, -3.443, 31.696> <0.304, -3.449, 31.417> <0.000, -3.449, 31.417> 
		<0.644, -3.388, 32.000> <0.644, -3.388, 31.647> <0.353, -3.388, 31.356> <0.000, -3.388, 31.356> 
		<0.646, -3.331, 32.000> <0.646, -3.331, 31.647> <0.353, -3.331, 31.354> <0.000, -3.331, 31.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.646, -0.331, 32.000> <-0.646, -0.331, 31.647> <-0.353, -0.331, 31.354> <0.000, -0.331, 31.354> 
		<-0.646, -1.231, 32.000> <-0.646, -1.231, 31.647> <-0.353, -1.231, 31.354> <0.000, -1.231, 31.354> 
		<-0.671, -2.431, 32.000> <-0.671, -2.431, 31.647> <-0.353, -2.431, 31.329> <0.000, -2.431, 31.329> 
		<-0.646, -3.331, 32.000> <-0.646, -3.331, 31.647> <-0.353, -3.331, 31.354> <0.000, -3.331, 31.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.646, -0.331, 32.000> <-0.646, -1.231, 32.000> <-0.671, -2.431, 32.000> <-0.646, -3.331, 32.000> 
		<-0.646, -0.331, 32.353> <-0.646, -1.231, 32.353> <-0.671, -2.431, 32.353> <-0.646, -3.331, 32.353> 
		<-0.353, -0.331, 32.646> <-0.353, -1.231, 32.646> <-0.353, -2.431, 32.671> <-0.353, -3.331, 32.646> 
		<0.000, -0.331, 32.646> <0.000, -1.231, 32.646> <0.000, -2.431, 32.671> <0.000, -3.331, 32.646> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.331, 32.646> <0.000, -1.231, 32.646> <0.000, -2.431, 32.671> <0.000, -3.331, 32.646> 
		<0.353, -0.331, 32.646> <0.353, -1.231, 32.646> <0.353, -2.431, 32.671> <0.353, -3.331, 32.646> 
		<0.646, -0.331, 32.353> <0.646, -1.231, 32.353> <0.671, -2.431, 32.353> <0.646, -3.331, 32.353> 
		<0.646, -0.331, 32.000> <0.646, -1.231, 32.000> <0.671, -2.431, 32.000> <0.646, -3.331, 32.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, -0.331, 32.000> <0.646, -1.231, 32.000> <0.671, -2.431, 32.000> <0.646, -3.331, 32.000> 
		<0.646, -0.331, 31.647> <0.646, -1.231, 31.647> <0.671, -2.431, 31.647> <0.646, -3.331, 31.647> 
		<0.353, -0.331, 31.354> <0.353, -1.231, 31.354> <0.353, -2.431, 31.329> <0.353, -3.331, 31.354> 
		<0.000, -0.331, 31.354> <0.000, -1.231, 31.354> <0.000, -2.431, 31.329> <0.000, -3.331, 31.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.689, 0.013, 61.325> <-0.785, 0.013, 61.360> <-0.997, 0.012, 61.340> <-1.010, 0.013, 61.442> 
		<-0.689, 0.389, 61.327> <-0.785, 0.389, 61.362> <-0.997, 0.563, 61.343> <-1.010, 0.564, 61.444> 
		<-0.376, 0.702, 61.328> <-0.376, 0.798, 61.364> <-0.551, 0.926, 61.411> <-0.551, 1.022, 61.447> 
		<0.000, 0.702, 61.328> <0.000, 0.798, 61.364> <0.000, 0.926, 61.411> <0.000, 1.022, 61.447> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.689, 0.013, 61.325> <-0.689, -0.363, 61.323> <-0.376, -0.676, 61.321> <0.000, -0.676, 61.321> 
		<-0.785, 0.013, 61.360> <-0.785, -0.363, 61.358> <-0.376, -0.773, 61.356> <0.000, -0.773, 61.356> 
		<-0.997, 0.012, 61.340> <-0.997, -0.539, 61.337> <-0.551, -0.901, 61.402> <0.000, -0.901, 61.402> 
		<-1.010, 0.013, 61.442> <-1.010, -0.538, 61.439> <-0.551, -0.997, 61.436> <0.000, -0.997, 61.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.676, 61.321> <0.376, -0.676, 61.321> <0.689, -0.363, 61.323> <0.689, 0.013, 61.325> 
		<0.000, -0.773, 61.356> <0.376, -0.773, 61.356> <0.785, -0.363, 61.358> <0.785, 0.013, 61.360> 
		<0.000, -0.901, 61.402> <0.551, -0.901, 61.402> <0.997, -0.539, 61.337> <0.997, 0.012, 61.340> 
		<0.000, -0.997, 61.436> <0.551, -0.997, 61.436> <1.010, -0.538, 61.439> <1.010, 0.013, 61.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.689, 0.013, 61.325> <0.689, 0.389, 61.327> <0.376, 0.702, 61.328> <0.000, 0.702, 61.328> 
		<0.785, 0.013, 61.360> <0.785, 0.389, 61.362> <0.376, 0.798, 61.364> <0.000, 0.798, 61.364> 
		<0.997, 0.012, 61.340> <0.997, 0.563, 61.343> <0.551, 0.926, 61.411> <0.000, 0.926, 61.411> 
		<1.010, 0.013, 61.442> <1.010, 0.564, 61.444> <0.551, 1.022, 61.447> <0.000, 1.022, 61.447> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.010, 0.013, 61.442> <-1.101, 0.014, 62.167> <-1.113, 0.015, 63.155> <-1.010, 0.017, 63.879> 
		<-1.010, 0.564, 61.444> <-1.101, 0.565, 62.170> <-1.113, 0.566, 63.158> <-1.010, 0.568, 63.882> 
		<-0.551, 1.022, 61.447> <-0.551, 1.023, 62.178> <-0.551, 1.025, 63.153> <-0.551, 1.026, 63.885> 
		<0.000, 1.022, 61.447> <0.000, 1.023, 62.178> <0.000, 1.025, 63.153> <0.000, 1.026, 63.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.010, 0.013, 61.442> <-1.010, 0.013, 61.442> <-1.010, 0.013, 61.442> <-1.010, 0.013, 61.442> 
		<-1.010, 0.564, 61.444> <-1.010, 0.013, 61.442> <-1.010, 0.013, 61.442> <-1.010, -0.538, 61.439> 
		<-0.551, 1.022, 61.447> <-0.551, 0.416, 61.444> <-0.551, -0.391, 61.440> <-0.551, -0.997, 61.436> 
		<0.000, 1.022, 61.447> <0.000, 0.416, 61.444> <0.000, -0.391, 61.440> <0.000, -0.997, 61.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.010, 0.013, 61.442> <-1.010, -0.538, 61.439> <-0.551, -0.997, 61.436> <0.000, -0.997, 61.436> 
		<-1.101, 0.014, 62.167> <-1.101, -0.537, 62.164> <-0.551, -0.996, 62.168> <0.000, -0.996, 62.168> 
		<-1.113, 0.015, 63.155> <-1.113, -0.535, 63.153> <-0.551, -0.994, 63.143> <0.000, -0.994, 63.143> 
		<-1.010, 0.017, 63.879> <-1.010, -0.534, 63.877> <-0.551, -0.993, 63.874> <0.000, -0.993, 63.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.997, 61.436> <0.000, -0.997, 61.436> <0.000, -0.997, 61.436> <0.000, -0.997, 61.436> 
		<0.000, -0.391, 61.440> <0.551, -0.391, 61.440> <0.551, -0.391, 61.440> <0.551, -0.997, 61.436> 
		<0.000, 0.416, 61.444> <0.551, 0.416, 61.444> <1.010, 0.013, 61.442> <1.010, -0.538, 61.439> 
		<0.000, 1.022, 61.447> <0.551, 1.022, 61.447> <1.010, 0.564, 61.444> <1.010, 0.013, 61.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.997, 61.436> <0.551, -0.997, 61.436> <1.010, -0.538, 61.439> <1.010, 0.013, 61.442> 
		<0.000, -0.996, 62.168> <0.551, -0.996, 62.168> <1.101, -0.537, 62.164> <1.101, 0.014, 62.167> 
		<0.000, -0.994, 63.143> <0.551, -0.994, 63.143> <1.113, -0.535, 63.153> <1.113, 0.015, 63.155> 
		<0.000, -0.993, 63.874> <0.551, -0.993, 63.874> <1.010, -0.534, 63.877> <1.010, 0.017, 63.879> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.010, 0.013, 61.442> <1.010, 0.564, 61.444> <0.551, 1.022, 61.447> <0.000, 1.022, 61.447> 
		<1.101, 0.014, 62.167> <1.101, 0.565, 62.170> <0.551, 1.023, 62.178> <0.000, 1.023, 62.178> 
		<1.113, 0.015, 63.155> <1.113, 0.566, 63.158> <0.551, 1.025, 63.153> <0.000, 1.025, 63.153> 
		<1.010, 0.017, 63.879> <1.010, 0.568, 63.882> <0.551, 1.026, 63.885> <0.000, 1.026, 63.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.646, 0.017, 63.996> <-0.646, 0.369, 63.998> <-0.353, 0.663, 64.000> <0.000, 0.663, 64.000> 
		<-0.755, 0.017, 63.961> <-0.755, 0.369, 63.963> <-0.353, 0.772, 63.965> <0.000, 0.772, 63.965> 
		<-0.993, 0.017, 63.993> <-0.993, 0.568, 63.996> <-0.551, 0.917, 63.919> <0.000, 0.917, 63.919> 
		<-1.010, 0.017, 63.879> <-1.010, 0.568, 63.882> <-0.551, 1.026, 63.885> <0.000, 1.026, 63.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.646, 0.017, 63.996> <-0.755, 0.017, 63.961> <-0.993, 0.017, 63.993> <-1.010, 0.017, 63.879> 
		<-0.646, -0.336, 63.994> <-0.755, -0.336, 63.959> <-0.993, -0.534, 63.990> <-1.010, -0.534, 63.877> 
		<-0.353, -0.629, 63.993> <-0.353, -0.738, 63.957> <-0.551, -0.884, 63.910> <-0.551, -0.993, 63.874> 
		<0.000, -0.629, 63.993> <0.000, -0.738, 63.957> <0.000, -0.884, 63.910> <0.000, -0.993, 63.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.629, 63.993> <0.000, -0.738, 63.957> <0.000, -0.884, 63.910> <0.000, -0.993, 63.874> 
		<0.353, -0.629, 63.993> <0.353, -0.738, 63.957> <0.551, -0.884, 63.910> <0.551, -0.993, 63.874> 
		<0.646, -0.336, 63.994> <0.755, -0.336, 63.959> <0.993, -0.534, 63.990> <1.010, -0.534, 63.877> 
		<0.646, 0.017, 63.996> <0.755, 0.017, 63.961> <0.993, 0.017, 63.993> <1.010, 0.017, 63.879> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.646, 0.017, 63.996> <0.755, 0.017, 63.961> <0.993, 0.017, 63.993> <1.010, 0.017, 63.879> 
		<0.646, 0.369, 63.998> <0.755, 0.369, 63.963> <0.993, 0.568, 63.996> <1.010, 0.568, 63.882> 
		<0.353, 0.663, 64.000> <0.353, 0.772, 63.965> <0.551, 0.917, 63.919> <0.551, 1.026, 63.885> 
		<0.000, 0.663, 64.000> <0.000, 0.772, 63.965> <0.000, 0.917, 63.919> <0.000, 1.026, 63.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.010, 0.017, 63.879> <-1.010, 0.017, 63.879> <-1.010, 0.017, 63.879> <-1.010, 0.017, 63.879> 
		<-1.010, 0.568, 63.882> <-1.010, 0.017, 63.879> <-1.010, 0.017, 63.879> <-1.010, -0.534, 63.877> 
		<-0.551, 1.026, 63.885> <-0.551, 0.420, 63.882> <-0.551, -0.387, 63.877> <-0.551, -0.993, 63.874> 
		<0.000, 1.026, 63.885> <0.000, 0.420, 63.882> <0.000, -0.387, 63.877> <0.000, -0.993, 63.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.993, 63.874> <0.000, -0.993, 63.874> <0.000, -0.993, 63.874> <0.000, -0.993, 63.874> 
		<0.000, -0.387, 63.877> <0.551, -0.387, 63.877> <0.551, -0.387, 63.877> <0.551, -0.993, 63.874> 
		<0.000, 0.420, 63.882> <0.551, 0.420, 63.882> <1.010, 0.017, 63.879> <1.010, -0.534, 63.877> 
		<0.000, 1.026, 63.885> <0.551, 1.026, 63.885> <1.010, 0.568, 63.882> <1.010, 0.017, 63.879> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.553, -10.483, 61.266> <-0.630, -10.483, 61.302> <-0.802, -10.483, 61.299> <-0.811, -10.483, 61.383> 
		<-0.553, -10.181, 61.268> <-0.630, -10.181, 61.303> <-0.802, -10.041, 61.302> <-0.811, -10.041, 61.386> 
		<-0.302, -9.930, 61.270> <-0.302, -9.853, 61.306> <-0.442, -9.750, 61.353> <-0.442, -9.673, 61.388> 
		<0.000, -9.930, 61.270> <0.000, -9.853, 61.306> <0.000, -9.750, 61.353> <0.000, -9.673, 61.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.553, -10.483, 61.266> <-0.553, -10.785, 61.265> <-0.302, -11.036, 61.263> <0.000, -11.036, 61.263> 
		<-0.630, -10.483, 61.302> <-0.630, -10.785, 61.300> <-0.302, -11.114, 61.297> <0.000, -11.114, 61.297> 
		<-0.802, -10.483, 61.299> <-0.802, -10.926, 61.296> <-0.442, -11.217, 61.343> <0.000, -11.217, 61.343> 
		<-0.811, -10.483, 61.383> <-0.811, -10.926, 61.380> <-0.442, -11.294, 61.378> <0.000, -11.294, 61.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.036, 61.263> <0.302, -11.036, 61.263> <0.553, -10.785, 61.265> <0.553, -10.483, 61.266> 
		<0.000, -11.114, 61.297> <0.302, -11.114, 61.297> <0.630, -10.785, 61.300> <0.630, -10.483, 61.302> 
		<0.000, -11.217, 61.343> <0.442, -11.217, 61.343> <0.802, -10.926, 61.296> <0.802, -10.483, 61.299> 
		<0.000, -11.294, 61.378> <0.442, -11.294, 61.378> <0.811, -10.926, 61.380> <0.811, -10.483, 61.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.553, -10.483, 61.266> <0.553, -10.181, 61.268> <0.302, -9.930, 61.270> <0.000, -9.930, 61.270> 
		<0.630, -10.483, 61.302> <0.630, -10.181, 61.303> <0.302, -9.853, 61.306> <0.000, -9.853, 61.306> 
		<0.802, -10.483, 61.299> <0.802, -10.041, 61.302> <0.442, -9.750, 61.353> <0.000, -9.750, 61.353> 
		<0.811, -10.483, 61.383> <0.811, -10.041, 61.386> <0.442, -9.673, 61.388> <0.000, -9.673, 61.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.811, -10.483, 61.383> <-0.884, -10.482, 62.111> <-0.894, -10.481, 63.094> <-0.811, -10.480, 63.821> 
		<-0.811, -10.041, 61.386> <-0.884, -10.040, 62.114> <-0.894, -10.039, 63.097> <-0.811, -10.038, 63.824> 
		<-0.442, -9.673, 61.388> <-0.442, -9.672, 62.120> <-0.442, -9.671, 63.095> <-0.442, -9.670, 63.826> 
		<0.000, -9.673, 61.388> <0.000, -9.672, 62.120> <0.000, -9.671, 63.095> <0.000, -9.670, 63.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.811, -10.483, 61.383> <-0.811, -10.483, 61.383> <-0.811, -10.483, 61.383> <-0.811, -10.483, 61.383> 
		<-0.811, -10.041, 61.386> <-0.811, -10.483, 61.383> <-0.811, -10.483, 61.383> <-0.811, -10.926, 61.380> 
		<-0.442, -9.673, 61.388> <-0.442, -10.159, 61.385> <-0.442, -10.808, 61.381> <-0.442, -11.294, 61.378> 
		<0.000, -9.673, 61.388> <0.000, -10.159, 61.385> <0.000, -10.808, 61.381> <0.000, -11.294, 61.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.811, -10.483, 61.383> <-0.811, -10.926, 61.380> <-0.442, -11.294, 61.378> <0.000, -11.294, 61.378> 
		<-0.884, -10.482, 62.111> <-0.884, -10.925, 62.108> <-0.442, -11.293, 62.109> <0.000, -11.293, 62.109> 
		<-0.894, -10.481, 63.094> <-0.894, -10.923, 63.092> <-0.442, -11.292, 63.085> <0.000, -11.292, 63.085> 
		<-0.811, -10.480, 63.821> <-0.811, -10.922, 63.818> <-0.442, -11.291, 63.816> <0.000, -11.291, 63.816> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.294, 61.378> <0.000, -11.294, 61.378> <0.000, -11.294, 61.378> <0.000, -11.294, 61.378> 
		<0.000, -10.808, 61.381> <0.442, -10.808, 61.381> <0.442, -10.808, 61.381> <0.442, -11.294, 61.378> 
		<0.000, -10.159, 61.385> <0.442, -10.159, 61.385> <0.811, -10.483, 61.383> <0.811, -10.926, 61.380> 
		<0.000, -9.673, 61.388> <0.442, -9.673, 61.388> <0.811, -10.041, 61.386> <0.811, -10.483, 61.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.294, 61.378> <0.442, -11.294, 61.378> <0.811, -10.926, 61.380> <0.811, -10.483, 61.383> 
		<0.000, -11.293, 62.109> <0.442, -11.293, 62.109> <0.884, -10.925, 62.108> <0.884, -10.482, 62.111> 
		<0.000, -11.292, 63.085> <0.442, -11.292, 63.085> <0.894, -10.923, 63.092> <0.894, -10.481, 63.094> 
		<0.000, -11.291, 63.816> <0.442, -11.291, 63.816> <0.811, -10.922, 63.818> <0.811, -10.480, 63.821> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.811, -10.483, 61.383> <0.811, -10.041, 61.386> <0.442, -9.673, 61.388> <0.000, -9.673, 61.388> 
		<0.884, -10.482, 62.111> <0.884, -10.040, 62.114> <0.442, -9.672, 62.120> <0.000, -9.672, 62.120> 
		<0.894, -10.481, 63.094> <0.894, -10.039, 63.097> <0.442, -9.671, 63.095> <0.000, -9.671, 63.095> 
		<0.811, -10.480, 63.821> <0.811, -10.038, 63.824> <0.442, -9.670, 63.826> <0.000, -9.670, 63.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.519, -10.480, 63.938> <-0.519, -10.197, 63.940> <-0.283, -9.961, 63.941> <0.000, -9.961, 63.941> 
		<-0.606, -10.480, 63.903> <-0.606, -10.197, 63.905> <-0.283, -9.874, 63.907> <0.000, -9.874, 63.907> 
		<-0.800, -10.480, 63.915> <-0.800, -10.038, 63.918> <-0.442, -9.757, 63.861> <0.000, -9.757, 63.861> 
		<-0.811, -10.480, 63.821> <-0.811, -10.038, 63.824> <-0.442, -9.670, 63.826> <0.000, -9.670, 63.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.519, -10.480, 63.938> <-0.606, -10.480, 63.903> <-0.800, -10.480, 63.915> <-0.811, -10.480, 63.821> 
		<-0.519, -10.763, 63.936> <-0.606, -10.763, 63.901> <-0.800, -10.922, 63.912> <-0.811, -10.922, 63.818> 
		<-0.283, -10.999, 63.935> <-0.283, -11.086, 63.899> <-0.442, -11.203, 63.851> <-0.442, -11.291, 63.816> 
		<0.000, -10.999, 63.935> <0.000, -11.086, 63.899> <0.000, -11.203, 63.851> <0.000, -11.291, 63.816> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -10.999, 63.935> <0.000, -11.086, 63.899> <0.000, -11.203, 63.851> <0.000, -11.291, 63.816> 
		<0.283, -10.999, 63.935> <0.283, -11.086, 63.899> <0.442, -11.203, 63.851> <0.442, -11.291, 63.816> 
		<0.519, -10.763, 63.936> <0.606, -10.763, 63.901> <0.800, -10.922, 63.912> <0.811, -10.922, 63.818> 
		<0.519, -10.480, 63.938> <0.606, -10.480, 63.903> <0.800, -10.480, 63.915> <0.811, -10.480, 63.821> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, -10.480, 63.938> <0.606, -10.480, 63.903> <0.800, -10.480, 63.915> <0.811, -10.480, 63.821> 
		<0.519, -10.197, 63.940> <0.606, -10.197, 63.905> <0.800, -10.038, 63.918> <0.811, -10.038, 63.824> 
		<0.283, -9.961, 63.941> <0.283, -9.874, 63.907> <0.442, -9.757, 63.861> <0.442, -9.670, 63.826> 
		<0.000, -9.961, 63.941> <0.000, -9.874, 63.907> <0.000, -9.757, 63.861> <0.000, -9.670, 63.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.811, -10.480, 63.821> <-0.811, -10.480, 63.821> <-0.811, -10.480, 63.821> <-0.811, -10.480, 63.821> 
		<-0.811, -10.038, 63.824> <-0.811, -10.480, 63.821> <-0.811, -10.480, 63.821> <-0.811, -10.922, 63.818> 
		<-0.442, -9.670, 63.826> <-0.442, -10.156, 63.823> <-0.442, -10.804, 63.819> <-0.442, -11.291, 63.816> 
		<0.000, -9.670, 63.826> <0.000, -10.156, 63.823> <0.000, -10.804, 63.819> <0.000, -11.291, 63.816> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.291, 63.816> <0.000, -11.291, 63.816> <0.000, -11.291, 63.816> <0.000, -11.291, 63.816> 
		<0.000, -10.804, 63.819> <0.442, -10.804, 63.819> <0.442, -10.804, 63.819> <0.442, -11.291, 63.816> 
		<0.000, -10.156, 63.823> <0.442, -10.156, 63.823> <0.811, -10.480, 63.821> <0.811, -10.922, 63.818> 
		<0.000, -9.670, 63.826> <0.442, -9.670, 63.826> <0.811, -10.038, 63.824> <0.811, -10.480, 63.821> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, -1.500, 62.638> <-0.500, -1.500, 62.638> <-0.500, -1.500, 62.638> <-0.500, -1.500, 62.638> 
		<-0.500, -1.500, 62.365> <-0.500, -1.500, 62.638> <-0.500, -1.500, 62.638> <-0.500, -1.500, 62.911> 
		<-0.273, -1.500, 62.138> <-0.273, -1.500, 62.438> <-0.273, -1.500, 62.838> <-0.273, -1.500, 63.138> 
		<0.000, -1.500, 62.138> <0.000, -1.500, 62.438> <0.000, -1.500, 62.838> <0.000, -1.500, 63.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, -1.500, 62.638> <-0.500, -1.500, 62.365> <-0.273, -1.500, 62.138> <0.000, -1.500, 62.138> 
		<-0.500, -4.200, 62.638> <-0.500, -4.200, 62.365> <-0.273, -4.200, 62.138> <0.000, -4.200, 62.138> 
		<-0.500, -7.800, 62.638> <-0.500, -7.800, 62.365> <-0.273, -7.800, 62.138> <0.000, -7.800, 62.138> 
		<-0.500, -10.500, 62.638> <-0.500, -10.500, 62.365> <-0.273, -10.500, 62.138> <0.000, -10.500, 62.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, -1.500, 62.638> <-0.500, -4.200, 62.638> <-0.500, -7.800, 62.638> <-0.500, -10.500, 62.638> 
		<-0.500, -1.500, 62.911> <-0.500, -4.200, 62.911> <-0.500, -7.800, 62.911> <-0.500, -10.500, 62.911> 
		<-0.273, -1.500, 63.138> <-0.273, -4.200, 63.138> <-0.273, -7.800, 63.138> <-0.273, -10.500, 63.138> 
		<0.000, -1.500, 63.138> <0.000, -4.200, 63.138> <0.000, -7.800, 63.138> <0.000, -10.500, 63.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, -1.500, 62.638> <0.500, -1.500, 62.911> <0.273, -1.500, 63.138> <0.000, -1.500, 63.138> 
		<0.500, -4.200, 62.638> <0.500, -4.200, 62.911> <0.273, -4.200, 63.138> <0.000, -4.200, 63.138> 
		<0.500, -7.800, 62.638> <0.500, -7.800, 62.911> <0.273, -7.800, 63.138> <0.000, -7.800, 63.138> 
		<0.500, -10.500, 62.638> <0.500, -10.500, 62.911> <0.273, -10.500, 63.138> <0.000, -10.500, 63.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, -1.500, 62.638> <0.500, -1.500, 62.638> <0.500, -1.500, 62.638> <0.500, -1.500, 62.638> 
		<0.500, -1.500, 62.911> <0.500, -1.500, 62.638> <0.500, -1.500, 62.638> <0.500, -1.500, 62.365> 
		<0.273, -1.500, 63.138> <0.273, -1.500, 62.838> <0.273, -1.500, 62.438> <0.273, -1.500, 62.138> 
		<0.000, -1.500, 63.138> <0.000, -1.500, 62.838> <0.000, -1.500, 62.438> <0.000, -1.500, 62.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, -1.500, 62.638> <0.500, -4.200, 62.638> <0.500, -7.800, 62.638> <0.500, -10.500, 62.638> 
		<0.500, -1.500, 62.365> <0.500, -4.200, 62.365> <0.500, -7.800, 62.365> <0.500, -10.500, 62.365> 
		<0.273, -1.500, 62.138> <0.273, -4.200, 62.138> <0.273, -7.800, 62.138> <0.273, -10.500, 62.138> 
		<0.000, -1.500, 62.138> <0.000, -4.200, 62.138> <0.000, -7.800, 62.138> <0.000, -10.500, 62.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, -10.500, 62.638> <-0.500, -10.500, 62.638> <-0.500, -10.500, 62.638> <-0.500, -10.500, 62.638> 
		<-0.500, -10.500, 62.911> <-0.500, -10.500, 62.638> <-0.500, -10.500, 62.638> <-0.500, -10.500, 62.365> 
		<-0.273, -10.500, 63.138> <-0.273, -10.500, 62.838> <-0.273, -10.500, 62.438> <-0.273, -10.500, 62.138> 
		<0.000, -10.500, 63.138> <0.000, -10.500, 62.838> <0.000, -10.500, 62.438> <0.000, -10.500, 62.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, -10.500, 62.638> <0.500, -10.500, 62.638> <0.500, -10.500, 62.638> <0.500, -10.500, 62.638> 
		<0.500, -10.500, 62.365> <0.500, -10.500, 62.638> <0.500, -10.500, 62.638> <0.500, -10.500, 62.911> 
		<0.273, -10.500, 62.138> <0.273, -10.500, 62.438> <0.273, -10.500, 62.838> <0.273, -10.500, 63.138> 
		<0.000, -10.500, 62.138> <0.000, -10.500, 62.438> <0.000, -10.500, 62.838> <0.000, -10.500, 63.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.583, 0.523, 62.638> <-0.583, 0.523, 62.638> <-0.583, 0.523, 62.638> <-0.583, 0.523, 62.638> 
		<-0.583, 0.523, 62.320> <-0.583, 0.523, 62.638> <-0.583, 0.523, 62.638> <-0.583, 0.523, 62.956> 
		<-0.318, 0.523, 62.055> <-0.318, 0.523, 62.405> <-0.318, 0.523, 62.871> <-0.318, 0.523, 63.221> 
		<0.000, 0.523, 62.055> <0.000, 0.523, 62.405> <0.000, 0.523, 62.871> <0.000, 0.523, 63.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.583, 0.523, 62.638> <-0.583, 0.523, 62.320> <-0.318, 0.523, 62.055> <0.000, 0.523, 62.055> 
		<-0.583, -0.524, 62.638> <-0.583, -0.524, 62.320> <-0.318, -0.524, 62.055> <0.000, -0.524, 62.055> 
		<-0.626, -1.921, 62.638> <-0.626, -1.921, 62.320> <-0.318, -1.920, 62.055> <0.000, -1.920, 62.055> 
		<-0.583, -2.967, 62.638> <-0.583, -2.967, 62.320> <-0.318, -2.967, 62.055> <0.000, -2.967, 62.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.583, 0.523, 62.638> <-0.583, -0.524, 62.638> <-0.626, -1.921, 62.638> <-0.583, -2.967, 62.638> 
		<-0.583, 0.523, 62.956> <-0.583, -0.524, 62.956> <-0.626, -1.921, 62.956> <-0.583, -2.967, 62.956> 
		<-0.318, 0.523, 63.221> <-0.318, -0.524, 63.221> <-0.318, -1.920, 63.221> <-0.318, -2.967, 63.221> 
		<0.000, 0.523, 63.221> <0.000, -0.524, 63.221> <0.000, -1.920, 63.221> <0.000, -2.967, 63.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.583, 0.523, 62.638> <0.583, 0.523, 62.956> <0.318, 0.523, 63.221> <0.000, 0.523, 63.221> 
		<0.583, -0.524, 62.638> <0.583, -0.524, 62.956> <0.318, -0.524, 63.221> <0.000, -0.524, 63.221> 
		<0.626, -1.921, 62.638> <0.626, -1.921, 62.956> <0.318, -1.920, 63.221> <0.000, -1.920, 63.221> 
		<0.583, -2.967, 62.638> <0.583, -2.967, 62.956> <0.318, -2.967, 63.221> <0.000, -2.967, 63.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.583, 0.523, 62.638> <0.583, 0.523, 62.638> <0.583, 0.523, 62.638> <0.583, 0.523, 62.638> 
		<0.583, 0.523, 62.956> <0.583, 0.523, 62.638> <0.583, 0.523, 62.638> <0.583, 0.523, 62.320> 
		<0.318, 0.523, 63.221> <0.318, 0.523, 62.871> <0.318, 0.523, 62.405> <0.318, 0.523, 62.055> 
		<0.000, 0.523, 63.221> <0.000, 0.523, 62.871> <0.000, 0.523, 62.405> <0.000, 0.523, 62.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.583, 0.523, 62.638> <0.583, -0.524, 62.638> <0.626, -1.921, 62.638> <0.583, -2.967, 62.638> 
		<0.583, 0.523, 62.320> <0.583, -0.524, 62.320> <0.626, -1.921, 62.320> <0.583, -2.967, 62.320> 
		<0.318, 0.523, 62.055> <0.318, -0.524, 62.055> <0.318, -1.920, 62.055> <0.318, -2.967, 62.055> 
		<0.000, 0.523, 62.055> <0.000, -0.524, 62.055> <0.000, -1.920, 62.055> <0.000, -2.967, 62.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.436, -3.032, 62.638> <-0.480, -3.013, 62.638> <-0.581, -3.015, 62.638> <-0.583, -2.967, 62.638> 
		<-0.436, -3.032, 62.400> <-0.480, -3.013, 62.400> <-0.581, -3.015, 62.320> <-0.583, -2.967, 62.320> 
		<-0.238, -3.032, 62.202> <-0.238, -3.013, 62.158> <-0.318, -2.987, 62.099> <-0.318, -2.967, 62.055> 
		<0.000, -3.032, 62.202> <0.000, -3.013, 62.158> <0.000, -2.987, 62.099> <0.000, -2.967, 62.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.436, -3.032, 62.638> <-0.436, -3.032, 62.876> <-0.238, -3.032, 63.074> <0.000, -3.032, 63.074> 
		<-0.480, -3.013, 62.638> <-0.480, -3.013, 62.876> <-0.238, -3.013, 63.118> <0.000, -3.013, 63.118> 
		<-0.581, -3.015, 62.638> <-0.581, -3.015, 62.956> <-0.318, -2.987, 63.177> <0.000, -2.987, 63.177> 
		<-0.583, -2.967, 62.638> <-0.583, -2.967, 62.956> <-0.318, -2.967, 63.221> <0.000, -2.967, 63.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -3.032, 63.074> <0.238, -3.032, 63.074> <0.436, -3.032, 62.876> <0.436, -3.032, 62.638> 
		<0.000, -3.013, 63.118> <0.238, -3.013, 63.118> <0.480, -3.013, 62.876> <0.480, -3.013, 62.638> 
		<0.000, -2.987, 63.177> <0.318, -2.987, 63.177> <0.581, -3.015, 62.956> <0.581, -3.015, 62.638> 
		<0.000, -2.967, 63.221> <0.318, -2.967, 63.221> <0.583, -2.967, 62.956> <0.583, -2.967, 62.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.436, -3.032, 62.638> <0.436, -3.032, 62.400> <0.238, -3.032, 62.202> <0.000, -3.032, 62.202> 
		<0.480, -3.013, 62.638> <0.480, -3.013, 62.400> <0.238, -3.013, 62.158> <0.000, -3.013, 62.158> 
		<0.581, -3.015, 62.638> <0.581, -3.015, 62.320> <0.318, -2.987, 62.099> <0.000, -2.987, 62.099> 
		<0.583, -2.967, 62.638> <0.583, -2.967, 62.320> <0.318, -2.967, 62.055> <0.000, -2.967, 62.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.583, -2.967, 62.638> <-0.583, -2.967, 62.638> <-0.583, -2.967, 62.638> <-0.583, -2.967, 62.638> 
		<-0.583, -2.967, 62.956> <-0.583, -2.967, 62.638> <-0.583, -2.967, 62.638> <-0.583, -2.967, 62.320> 
		<-0.318, -2.967, 63.221> <-0.318, -2.967, 62.871> <-0.318, -2.967, 62.405> <-0.318, -2.967, 62.055> 
		<0.000, -2.967, 63.221> <0.000, -2.967, 62.871> <0.000, -2.967, 62.405> <0.000, -2.967, 62.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -2.967, 63.221> <0.000, -2.967, 63.221> <0.000, -2.967, 63.221> <0.000, -2.967, 63.221> 
		<0.318, -2.967, 63.221> <0.318, -2.967, 62.871> <0.318, -2.967, 62.871> <0.000, -2.967, 62.871> 
		<0.583, -2.967, 62.956> <0.583, -2.967, 62.638> <0.318, -2.967, 62.405> <0.000, -2.967, 62.405> 
		<0.583, -2.967, 62.638> <0.583, -2.967, 62.320> <0.318, -2.967, 62.055> <0.000, -2.967, 62.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.134, -12.301, 26.572> <-3.793, -12.282, 26.570> <-4.673, -12.287, 26.571> <-5.332, -12.314, 26.573> 
		<-3.134, -12.320, 26.287> <-3.793, -12.301, 26.286> <-4.673, -12.305, 26.286> <-5.332, -12.332, 26.288> 
		<-3.135, -12.098, 26.034> <-3.794, -12.102, 26.034> <-4.673, -12.107, 26.035> <-5.333, -12.111, 26.035> 
		<-3.136, -11.813, 26.015> <-3.795, -11.817, 26.016> <-4.674, -11.822, 26.016> <-5.334, -11.826, 26.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.134, -12.301, 26.572> <-3.134, -12.301, 26.572> <-3.134, -12.301, 26.572> <-3.134, -12.301, 26.572> 
		<-3.134, -12.282, 26.857> <-3.134, -12.301, 26.572> <-3.134, -12.301, 26.572> <-3.134, -12.320, 26.287> 
		<-3.135, -12.029, 27.078> <-3.135, -12.050, 26.765> <-3.135, -12.078, 26.347> <-3.135, -12.098, 26.034> 
		<-3.136, -11.744, 27.059> <-3.136, -11.765, 26.746> <-3.136, -11.793, 26.328> <-3.136, -11.813, 26.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.134, -12.301, 26.572> <-3.134, -12.320, 26.287> <-3.135, -12.098, 26.034> <-3.136, -11.813, 26.015> 
		<-3.093, -12.302, 26.572> <-3.093, -12.321, 26.287> <-3.101, -12.100, 26.011> <-3.102, -11.815, 25.992> 
		<-3.062, -12.378, 26.577> <-3.062, -12.400, 26.249> <-3.063, -12.146, 25.959> <-3.064, -11.818, 25.938> 
		<-3.021, -12.379, 26.577> <-3.021, -12.401, 26.249> <-3.022, -12.146, 25.958> <-3.022, -11.818, 25.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.134, -12.301, 26.572> <-3.134, -12.282, 26.857> <-3.135, -12.029, 27.078> <-3.136, -11.744, 27.059> 
		<-3.793, -12.282, 26.570> <-3.793, -12.263, 26.855> <-3.794, -12.033, 27.078> <-3.795, -11.748, 27.059> 
		<-4.673, -12.287, 26.571> <-4.673, -12.268, 26.856> <-4.673, -12.038, 27.078> <-4.674, -11.753, 27.060> 
		<-5.332, -12.314, 26.573> <-5.332, -12.295, 26.857> <-5.333, -12.042, 27.079> <-5.334, -11.757, 27.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.134, -12.301, 26.572> <-3.134, -12.282, 26.857> <-3.135, -12.029, 27.078> <-3.136, -11.744, 27.059> 
		<-3.093, -12.302, 26.572> <-3.093, -12.283, 26.857> <-3.101, -12.028, 27.101> <-3.102, -11.743, 27.083> 
		<-3.062, -12.378, 26.577> <-3.062, -12.357, 26.905> <-3.063, -12.067, 27.158> <-3.064, -11.739, 27.137> 
		<-3.021, -12.379, 26.577> <-3.021, -12.358, 26.905> <-3.022, -12.067, 27.159> <-3.022, -11.739, 27.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.136, -11.744, 27.059> <-3.136, -11.744, 27.059> <-3.136, -11.744, 27.059> <-3.136, -11.744, 27.059> 
		<-3.137, -11.460, 27.040> <-3.137, -11.480, 26.727> <-3.137, -11.480, 26.727> <-3.136, -11.765, 26.746> 
		<-3.137, -11.238, 26.788> <-3.137, -11.257, 26.503> <-3.137, -11.508, 26.310> <-3.136, -11.793, 26.328> 
		<-3.137, -11.257, 26.503> <-3.137, -11.276, 26.218> <-3.137, -11.529, 25.997> <-3.136, -11.813, 26.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.136, -11.744, 27.059> <-3.137, -11.460, 27.040> <-3.137, -11.238, 26.788> <-3.137, -11.257, 26.503> 
		<-3.795, -11.748, 27.059> <-3.796, -11.463, 27.040> <-3.796, -11.264, 26.789> <-3.796, -11.283, 26.504> 
		<-4.674, -11.753, 27.060> <-4.675, -11.469, 27.041> <-4.676, -11.271, 26.790> <-4.676, -11.290, 26.505> 
		<-5.334, -11.757, 27.060> <-5.334, -11.472, 27.041> <-5.335, -11.251, 26.788> <-5.335, -11.270, 26.504> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.136, -11.744, 27.059> <-3.137, -11.460, 27.040> <-3.137, -11.238, 26.788> <-3.137, -11.257, 26.503> 
		<-3.102, -11.743, 27.083> <-3.103, -11.458, 27.064> <-3.096, -11.237, 26.787> <-3.096, -11.255, 26.503> 
		<-3.064, -11.739, 27.137> <-3.065, -11.411, 27.115> <-3.065, -11.158, 26.825> <-3.065, -11.179, 26.498> 
		<-3.022, -11.739, 27.138> <-3.023, -11.411, 27.116> <-3.024, -11.156, 26.825> <-3.024, -11.178, 26.497> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.137, -11.257, 26.503> <-3.137, -11.276, 26.218> <-3.137, -11.529, 25.997> <-3.136, -11.813, 26.015> 
		<-3.796, -11.283, 26.504> <-3.796, -11.302, 26.220> <-3.796, -11.532, 25.997> <-3.795, -11.817, 26.016> 
		<-4.676, -11.290, 26.505> <-4.676, -11.308, 26.220> <-4.675, -11.538, 25.997> <-4.674, -11.822, 26.016> 
		<-5.335, -11.270, 26.504> <-5.335, -11.289, 26.219> <-5.334, -11.541, 25.997> <-5.334, -11.826, 26.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.137, -11.257, 26.503> <-3.137, -11.276, 26.218> <-3.137, -11.529, 25.997> <-3.136, -11.813, 26.015> 
		<-3.096, -11.255, 26.503> <-3.096, -11.274, 26.218> <-3.103, -11.530, 25.973> <-3.102, -11.815, 25.992> 
		<-3.065, -11.179, 26.498> <-3.065, -11.201, 26.170> <-3.065, -11.491, 25.916> <-3.064, -11.818, 25.938> 
		<-3.024, -11.178, 26.497> <-3.024, -11.200, 26.170> <-3.023, -11.491, 25.915> <-3.022, -11.818, 25.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -12.371, 26.576> <-1.048, -12.374, 26.577> <-2.175, -12.400, 26.578> <-3.021, -12.379, 26.577> 
		<-0.202, -12.393, 26.249> <-1.048, -12.395, 26.249> <-2.175, -12.421, 26.250> <-3.021, -12.401, 26.249> 
		<-0.203, -12.138, 25.958> <-1.048, -12.141, 25.958> <-2.176, -12.145, 25.935> <-3.022, -12.146, 25.958> 
		<-0.204, -11.811, 25.936> <-1.049, -11.813, 25.936> <-2.177, -11.817, 25.914> <-3.022, -11.818, 25.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.202, -12.371, 26.576> <-0.202, -12.350, 26.904> <-0.203, -12.059, 27.159> <-0.204, -11.731, 27.137> 
		<-1.048, -12.374, 26.577> <-1.048, -12.352, 26.904> <-1.048, -12.061, 27.159> <-1.049, -11.733, 27.137> 
		<-2.175, -12.400, 26.578> <-2.175, -12.378, 26.906> <-2.176, -12.063, 27.182> <-2.177, -11.735, 27.160> 
		<-3.021, -12.379, 26.577> <-3.021, -12.358, 26.905> <-3.022, -12.067, 27.159> <-3.022, -11.739, 27.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.204, -11.731, 27.137> <-0.205, -11.403, 27.116> <-0.205, -11.149, 26.825> <-0.205, -11.170, 26.497> 
		<-1.049, -11.733, 27.137> <-1.050, -11.406, 27.116> <-1.051, -11.151, 26.825> <-1.051, -11.173, 26.497> 
		<-2.177, -11.735, 27.160> <-2.178, -11.407, 27.139> <-2.179, -11.131, 26.824> <-2.179, -11.153, 26.496> 
		<-3.022, -11.739, 27.138> <-3.023, -11.411, 27.116> <-3.024, -11.156, 26.825> <-3.024, -11.178, 26.497> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.205, -11.170, 26.497> <-0.205, -11.192, 26.169> <-0.205, -11.483, 25.914> <-0.204, -11.811, 25.936> 
		<-1.051, -11.173, 26.497> <-1.051, -11.194, 26.169> <-1.050, -11.485, 25.915> <-1.049, -11.813, 25.936> 
		<-2.179, -11.153, 26.496> <-2.179, -11.175, 26.168> <-2.178, -11.490, 25.892> <-2.177, -11.817, 25.914> 
		<-3.024, -11.178, 26.497> <-3.024, -11.200, 26.170> <-3.023, -11.491, 25.915> <-3.022, -11.818, 25.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.332, -12.314, 26.573> <-5.332, -12.314, 26.573> <-5.332, -12.314, 26.573> <-5.332, -12.314, 26.573> 
		<-5.332, -12.332, 26.288> <-5.332, -12.314, 26.573> <-5.332, -12.314, 26.573> <-5.332, -12.295, 26.857> 
		<-5.333, -12.111, 26.035> <-5.333, -12.090, 26.348> <-5.333, -12.063, 26.766> <-5.333, -12.042, 27.079> 
		<-5.334, -11.826, 26.016> <-5.334, -11.806, 26.329> <-5.334, -11.778, 26.747> <-5.334, -11.757, 27.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.332, -12.314, 26.573> <-5.386, -12.316, 26.573> <-5.437, -12.396, 26.578> <-5.491, -12.398, 26.578> 
		<-5.332, -12.332, 26.288> <-5.386, -12.335, 26.288> <-5.437, -12.418, 26.248> <-5.491, -12.420, 26.248> 
		<-5.333, -12.111, 26.035> <-5.381, -12.113, 26.010> <-5.438, -12.163, 25.956> <-5.492, -12.163, 25.954> 
		<-5.334, -11.826, 26.016> <-5.381, -11.828, 25.991> <-5.439, -11.832, 25.934> <-5.493, -11.832, 25.933> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.332, -12.314, 26.573> <-5.332, -12.295, 26.857> <-5.333, -12.042, 27.079> <-5.334, -11.757, 27.060> 
		<-5.386, -12.316, 26.573> <-5.386, -12.297, 26.858> <-5.381, -12.041, 27.104> <-5.381, -11.756, 27.085> 
		<-5.437, -12.396, 26.578> <-5.437, -12.374, 26.908> <-5.438, -12.083, 27.164> <-5.439, -11.752, 27.142> 
		<-5.491, -12.398, 26.578> <-5.491, -12.376, 26.909> <-5.492, -12.083, 27.165> <-5.493, -11.752, 27.144> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.334, -11.757, 27.060> <-5.334, -11.757, 27.060> <-5.334, -11.757, 27.060> <-5.334, -11.757, 27.060> 
		<-5.334, -11.778, 26.747> <-5.334, -11.493, 26.728> <-5.334, -11.493, 26.728> <-5.334, -11.472, 27.041> 
		<-5.334, -11.806, 26.329> <-5.334, -11.521, 26.310> <-5.335, -11.270, 26.504> <-5.335, -11.251, 26.788> 
		<-5.334, -11.826, 26.016> <-5.334, -11.541, 25.997> <-5.335, -11.289, 26.219> <-5.335, -11.270, 26.504> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.334, -11.757, 27.060> <-5.334, -11.472, 27.041> <-5.335, -11.251, 26.788> <-5.335, -11.270, 26.504> 
		<-5.381, -11.756, 27.085> <-5.382, -11.471, 27.066> <-5.389, -11.250, 26.788> <-5.389, -11.268, 26.503> 
		<-5.439, -11.752, 27.142> <-5.440, -11.422, 27.120> <-5.441, -11.166, 26.829> <-5.441, -11.188, 26.498> 
		<-5.493, -11.752, 27.144> <-5.494, -11.422, 27.122> <-5.495, -11.165, 26.829> <-5.495, -11.187, 26.498> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.335, -11.270, 26.504> <-5.335, -11.289, 26.219> <-5.334, -11.541, 25.997> <-5.334, -11.826, 26.016> 
		<-5.389, -11.268, 26.503> <-5.389, -11.287, 26.219> <-5.382, -11.543, 25.972> <-5.381, -11.828, 25.991> 
		<-5.441, -11.188, 26.498> <-5.441, -11.210, 26.168> <-5.440, -11.502, 25.912> <-5.439, -11.832, 25.934> 
		<-5.495, -11.187, 26.498> <-5.495, -11.209, 26.168> <-5.494, -11.502, 25.911> <-5.493, -11.832, 25.933> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.310, -12.406, 26.579> <-8.310, -12.427, 26.248> <-8.311, -12.171, 25.955> <-8.312, -11.840, 25.933> 
		<-7.464, -12.403, 26.578> <-7.464, -12.425, 26.248> <-7.465, -12.168, 25.955> <-7.466, -11.838, 25.933> 
		<-6.336, -12.424, 26.580> <-6.336, -12.446, 26.249> <-6.337, -12.167, 25.931> <-6.338, -11.836, 25.909> 
		<-5.491, -12.398, 26.578> <-5.491, -12.420, 26.248> <-5.492, -12.163, 25.954> <-5.493, -11.832, 25.933> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.310, -12.406, 26.579> <-7.464, -12.403, 26.578> <-6.336, -12.424, 26.580> <-5.491, -12.398, 26.578> 
		<-8.310, -12.384, 26.909> <-7.464, -12.381, 26.909> <-6.336, -12.402, 26.910> <-5.491, -12.376, 26.909> 
		<-8.311, -12.090, 27.166> <-7.465, -12.088, 27.166> <-6.337, -12.083, 27.189> <-5.492, -12.083, 27.165> 
		<-8.312, -11.760, 27.144> <-7.466, -11.758, 27.144> <-6.338, -11.753, 27.168> <-5.493, -11.752, 27.144> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.312, -11.760, 27.144> <-7.466, -11.758, 27.144> <-6.338, -11.753, 27.168> <-5.493, -11.752, 27.144> 
		<-8.313, -11.429, 27.122> <-7.467, -11.427, 27.122> <-6.339, -11.422, 27.146> <-5.494, -11.422, 27.122> 
		<-8.313, -11.173, 26.829> <-7.468, -11.170, 26.829> <-6.340, -11.143, 26.827> <-5.495, -11.165, 26.829> 
		<-8.313, -11.194, 26.499> <-7.468, -11.192, 26.498> <-6.340, -11.165, 26.497> <-5.495, -11.187, 26.498> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.313, -11.194, 26.499> <-7.468, -11.192, 26.498> <-6.340, -11.165, 26.497> <-5.495, -11.187, 26.498> 
		<-8.313, -11.216, 26.168> <-7.468, -11.214, 26.168> <-6.340, -11.187, 26.166> <-5.495, -11.209, 26.168> 
		<-8.313, -11.510, 25.911> <-7.467, -11.507, 25.911> <-6.339, -11.506, 25.887> <-5.494, -11.502, 25.911> 
		<-8.312, -11.840, 25.933> <-7.466, -11.838, 25.933> <-6.338, -11.836, 25.909> <-5.493, -11.832, 25.933> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.756, -16.118, -38.809> <-0.756, -16.118, -38.809> <-0.756, -16.118, -38.809> <-0.756, -16.118, -38.809> 
		<-0.756, -16.530, -38.783> <-0.756, -16.118, -38.809> <-0.756, -16.118, -38.809> <-0.756, -15.706, -38.835> 
		<-0.413, -16.873, -38.762> <-0.413, -16.420, -38.790> <-0.413, -15.816, -38.828> <-0.413, -15.363, -38.856> 
		<0.000, -16.873, -38.762> <0.000, -16.420, -38.790> <0.000, -15.816, -38.828> <0.000, -15.363, -38.856> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.756, -16.118, -38.809> <-0.756, -16.530, -38.783> <-0.413, -16.873, -38.762> <0.000, -16.873, -38.762> 
		<-0.756, -15.061, -22.783> <-0.756, -15.473, -22.758> <-0.413, -15.816, -22.736> <0.000, -15.816, -22.736> 
		<-0.740, -13.652, -1.416> <-0.740, -14.064, -1.390> <-0.413, -14.406, -1.368> <0.000, -14.406, -1.368> 
		<-0.756, -12.595, 14.610> <-0.756, -13.006, 14.636> <-0.413, -13.349, 14.657> <0.000, -13.349, 14.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.756, -16.118, -38.809> <-0.756, -15.061, -22.783> <-0.740, -13.652, -1.416> <-0.756, -12.595, 14.610> 
		<-0.756, -15.706, -38.835> <-0.756, -14.649, -22.809> <-0.740, -13.240, -1.441> <-0.756, -12.183, 14.584> 
		<-0.413, -15.363, -38.856> <-0.413, -14.306, -22.830> <-0.413, -12.897, -1.463> <-0.413, -11.840, 14.563> 
		<0.000, -15.363, -38.856> <0.000, -14.306, -22.830> <0.000, -12.897, -1.463> <0.000, -11.840, 14.563> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.756, -16.118, -38.809> <0.756, -15.706, -38.835> <0.413, -15.363, -38.856> <0.000, -15.363, -38.856> 
		<0.756, -15.061, -22.783> <0.756, -14.649, -22.809> <0.413, -14.306, -22.830> <0.000, -14.306, -22.830> 
		<0.740, -13.652, -1.416> <0.740, -13.240, -1.441> <0.413, -12.897, -1.463> <0.000, -12.897, -1.463> 
		<0.756, -12.595, 14.610> <0.756, -12.183, 14.584> <0.413, -11.840, 14.563> <0.000, -11.840, 14.563> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.756, -16.118, -38.809> <0.756, -16.118, -38.809> <0.756, -16.118, -38.809> <0.756, -16.118, -38.809> 
		<0.756, -15.706, -38.835> <0.756, -16.118, -38.809> <0.756, -16.118, -38.809> <0.756, -16.530, -38.783> 
		<0.413, -15.363, -38.856> <0.413, -15.816, -38.828> <0.413, -16.420, -38.790> <0.413, -16.873, -38.762> 
		<0.000, -15.363, -38.856> <0.000, -15.816, -38.828> <0.000, -16.420, -38.790> <0.000, -16.873, -38.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.756, -16.118, -38.809> <0.756, -15.061, -22.783> <0.740, -13.652, -1.416> <0.756, -12.595, 14.610> 
		<0.756, -16.530, -38.783> <0.756, -15.473, -22.758> <0.740, -14.064, -1.390> <0.756, -13.006, 14.636> 
		<0.413, -16.873, -38.762> <0.413, -15.816, -22.736> <0.413, -14.406, -1.368> <0.413, -13.349, 14.657> 
		<0.000, -16.873, -38.762> <0.000, -15.816, -22.736> <0.000, -14.406, -1.368> <0.000, -13.349, 14.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.756, -12.595, 14.610> <-0.756, -12.595, 14.610> <-0.756, -12.595, 14.610> <-0.756, -12.595, 14.610> 
		<-0.756, -12.183, 14.584> <-0.756, -12.595, 14.610> <-0.756, -12.595, 14.610> <-0.756, -13.006, 14.636> 
		<-0.413, -11.840, 14.563> <-0.413, -12.293, 14.591> <-0.413, -12.896, 14.629> <-0.413, -13.349, 14.657> 
		<0.000, -11.840, 14.563> <0.000, -12.293, 14.591> <0.000, -12.896, 14.629> <0.000, -13.349, 14.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.756, -12.595, 14.610> <-0.756, -13.006, 14.636> <-0.413, -13.349, 14.657> <0.000, -13.349, 14.657> 
		<-0.756, -12.591, 14.663> <-0.756, -13.003, 14.689> <-0.413, -13.363, 14.708> <0.000, -13.363, 14.708> 
		<-0.811, -12.587, 14.724> <-0.811, -13.029, 14.752> <-0.443, -13.397, 14.775> <0.000, -13.397, 14.775> 
		<-0.812, -12.584, 14.777> <-0.812, -13.026, 14.805> <-0.443, -13.394, 14.828> <0.000, -13.394, 14.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.756, -12.595, 14.610> <-0.756, -12.591, 14.663> <-0.811, -12.587, 14.724> <-0.812, -12.584, 14.777> 
		<-0.756, -12.183, 14.584> <-0.756, -12.179, 14.637> <-0.811, -12.145, 14.696> <-0.812, -12.141, 14.749> 
		<-0.413, -11.840, 14.563> <-0.413, -11.820, 14.612> <-0.443, -11.777, 14.673> <-0.443, -11.773, 14.726> 
		<0.000, -11.840, 14.563> <0.000, -11.820, 14.612> <0.000, -11.777, 14.673> <0.000, -11.773, 14.726> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.840, 14.563> <0.000, -11.840, 14.563> <0.000, -11.840, 14.563> <0.000, -11.840, 14.563> 
		<0.413, -11.840, 14.563> <0.413, -12.293, 14.591> <0.413, -12.293, 14.591> <0.000, -12.293, 14.591> 
		<0.756, -12.183, 14.584> <0.756, -12.595, 14.610> <0.413, -12.896, 14.629> <0.000, -12.896, 14.629> 
		<0.756, -12.595, 14.610> <0.756, -13.006, 14.636> <0.413, -13.349, 14.657> <0.000, -13.349, 14.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.840, 14.563> <0.000, -11.820, 14.612> <0.000, -11.777, 14.673> <0.000, -11.773, 14.726> 
		<0.413, -11.840, 14.563> <0.413, -11.820, 14.612> <0.443, -11.777, 14.673> <0.443, -11.773, 14.726> 
		<0.756, -12.183, 14.584> <0.756, -12.179, 14.637> <0.811, -12.145, 14.696> <0.812, -12.141, 14.749> 
		<0.756, -12.595, 14.610> <0.756, -12.591, 14.663> <0.811, -12.587, 14.724> <0.812, -12.584, 14.777> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.756, -12.595, 14.610> <0.756, -12.591, 14.663> <0.811, -12.587, 14.724> <0.812, -12.584, 14.777> 
		<0.756, -13.006, 14.636> <0.756, -13.003, 14.689> <0.811, -13.029, 14.752> <0.812, -13.026, 14.805> 
		<0.413, -13.349, 14.657> <0.413, -13.363, 14.708> <0.443, -13.397, 14.775> <0.443, -13.394, 14.828> 
		<0.000, -13.349, 14.657> <0.000, -13.363, 14.708> <0.000, -13.397, 14.775> <0.000, -13.394, 14.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.812, -12.020, 23.296> <-0.812, -12.189, 20.740> <-0.828, -12.415, 17.333> <-0.812, -12.584, 14.777> 
		<-0.812, -12.462, 23.324> <-0.812, -12.631, 20.768> <-0.828, -12.857, 17.360> <-0.812, -13.026, 14.805> 
		<-0.443, -12.830, 23.347> <-0.443, -12.999, 20.791> <-0.443, -13.241, 17.384> <-0.443, -13.394, 14.828> 
		<0.000, -12.830, 23.347> <0.000, -12.999, 20.791> <0.000, -13.241, 17.384> <0.000, -13.394, 14.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.812, -12.020, 23.296> <-0.812, -11.578, 23.268> <-0.443, -11.210, 23.245> <0.000, -11.210, 23.245> 
		<-0.812, -12.189, 20.740> <-0.812, -11.747, 20.713> <-0.443, -11.379, 20.689> <0.000, -11.379, 20.689> 
		<-0.828, -12.415, 17.333> <-0.828, -11.972, 17.305> <-0.443, -11.588, 17.281> <0.000, -11.588, 17.281> 
		<-0.812, -12.584, 14.777> <-0.812, -12.141, 14.749> <-0.443, -11.773, 14.726> <0.000, -11.773, 14.726> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -11.210, 23.245> <0.443, -11.210, 23.245> <0.812, -11.578, 23.268> <0.812, -12.020, 23.296> 
		<0.000, -11.379, 20.689> <0.443, -11.379, 20.689> <0.812, -11.747, 20.713> <0.812, -12.189, 20.740> 
		<0.000, -11.588, 17.281> <0.443, -11.588, 17.281> <0.828, -11.972, 17.305> <0.828, -12.415, 17.333> 
		<0.000, -11.773, 14.726> <0.443, -11.773, 14.726> <0.812, -12.141, 14.749> <0.812, -12.584, 14.777> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.812, -12.020, 23.296> <0.812, -12.462, 23.324> <0.443, -12.830, 23.347> <0.000, -12.830, 23.347> 
		<0.812, -12.189, 20.740> <0.812, -12.631, 20.768> <0.443, -12.999, 20.791> <0.000, -12.999, 20.791> 
		<0.828, -12.415, 17.333> <0.828, -12.857, 17.360> <0.443, -13.241, 17.384> <0.000, -13.241, 17.384> 
		<0.812, -12.584, 14.777> <0.812, -13.026, 14.805> <0.443, -13.394, 14.828> <0.000, -13.394, 14.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.256, -16.118, -38.809> <-9.256, -16.118, -38.809> <-9.256, -16.118, -38.809> <-9.256, -16.118, -38.809> 
		<-9.256, -16.530, -38.783> <-9.256, -16.118, -38.809> <-9.256, -16.118, -38.809> <-9.256, -15.706, -38.835> 
		<-8.913, -16.873, -38.762> <-8.913, -16.420, -38.790> <-8.913, -15.816, -38.828> <-8.913, -15.363, -38.856> 
		<-8.500, -16.873, -38.762> <-8.500, -16.420, -38.790> <-8.500, -15.816, -38.828> <-8.500, -15.363, -38.856> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.256, -16.118, -38.809> <-9.256, -16.530, -38.783> <-8.913, -16.873, -38.762> <-8.500, -16.873, -38.762> 
		<-9.256, -15.061, -22.783> <-9.256, -15.473, -22.758> <-8.913, -15.816, -22.736> <-8.500, -15.816, -22.736> 
		<-9.240, -13.652, -1.416> <-9.240, -14.064, -1.390> <-8.913, -14.406, -1.368> <-8.500, -14.406, -1.368> 
		<-9.256, -12.595, 14.610> <-9.256, -13.006, 14.636> <-8.913, -13.349, 14.657> <-8.500, -13.349, 14.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.256, -16.118, -38.809> <-9.256, -15.061, -22.783> <-9.240, -13.652, -1.416> <-9.256, -12.595, 14.610> 
		<-9.256, -15.706, -38.835> <-9.256, -14.649, -22.809> <-9.240, -13.240, -1.441> <-9.256, -12.183, 14.584> 
		<-8.913, -15.363, -38.856> <-8.913, -14.306, -22.830> <-8.913, -12.897, -1.463> <-8.913, -11.840, 14.563> 
		<-8.500, -15.363, -38.856> <-8.500, -14.306, -22.830> <-8.500, -12.897, -1.463> <-8.500, -11.840, 14.563> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.744, -16.118, -38.809> <-7.744, -15.706, -38.835> <-8.087, -15.363, -38.856> <-8.500, -15.363, -38.856> 
		<-7.744, -15.061, -22.783> <-7.744, -14.649, -22.809> <-8.087, -14.306, -22.830> <-8.500, -14.306, -22.830> 
		<-7.760, -13.652, -1.416> <-7.760, -13.240, -1.441> <-8.087, -12.897, -1.463> <-8.500, -12.897, -1.463> 
		<-7.744, -12.595, 14.610> <-7.744, -12.183, 14.584> <-8.087, -11.840, 14.563> <-8.500, -11.840, 14.563> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.744, -16.118, -38.809> <-7.744, -16.118, -38.809> <-7.744, -16.118, -38.809> <-7.744, -16.118, -38.809> 
		<-7.744, -15.706, -38.835> <-7.744, -16.118, -38.809> <-7.744, -16.118, -38.809> <-7.744, -16.530, -38.783> 
		<-8.087, -15.363, -38.856> <-8.087, -15.816, -38.828> <-8.087, -16.420, -38.790> <-8.087, -16.873, -38.762> 
		<-8.500, -15.363, -38.856> <-8.500, -15.816, -38.828> <-8.500, -16.420, -38.790> <-8.500, -16.873, -38.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.744, -16.118, -38.809> <-7.744, -15.061, -22.783> <-7.760, -13.652, -1.416> <-7.744, -12.595, 14.610> 
		<-7.744, -16.530, -38.783> <-7.744, -15.473, -22.758> <-7.760, -14.064, -1.390> <-7.744, -13.006, 14.636> 
		<-8.087, -16.873, -38.762> <-8.087, -15.816, -22.736> <-8.087, -14.406, -1.368> <-8.087, -13.349, 14.657> 
		<-8.500, -16.873, -38.762> <-8.500, -15.816, -22.736> <-8.500, -14.406, -1.368> <-8.500, -13.349, 14.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.256, -12.595, 14.610> <-9.256, -12.595, 14.610> <-9.256, -12.595, 14.610> <-9.256, -12.595, 14.610> 
		<-9.256, -12.183, 14.584> <-9.256, -12.595, 14.610> <-9.256, -12.595, 14.610> <-9.256, -13.006, 14.636> 
		<-8.913, -11.840, 14.563> <-8.913, -12.293, 14.591> <-8.913, -12.896, 14.629> <-8.913, -13.349, 14.657> 
		<-8.500, -11.840, 14.563> <-8.500, -12.293, 14.591> <-8.500, -12.896, 14.629> <-8.500, -13.349, 14.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.256, -12.595, 14.610> <-9.256, -13.006, 14.636> <-8.913, -13.349, 14.657> <-8.500, -13.349, 14.657> 
		<-9.256, -12.591, 14.663> <-9.256, -13.003, 14.689> <-8.913, -13.363, 14.708> <-8.500, -13.363, 14.708> 
		<-9.311, -12.587, 14.724> <-9.311, -13.029, 14.752> <-8.943, -13.397, 14.775> <-8.500, -13.397, 14.775> 
		<-9.312, -12.584, 14.777> <-9.312, -13.026, 14.805> <-8.943, -13.394, 14.828> <-8.500, -13.394, 14.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.256, -12.595, 14.610> <-9.256, -12.591, 14.663> <-9.311, -12.587, 14.724> <-9.312, -12.584, 14.777> 
		<-9.256, -12.183, 14.584> <-9.256, -12.179, 14.637> <-9.311, -12.145, 14.696> <-9.312, -12.141, 14.749> 
		<-8.913, -11.840, 14.563> <-8.913, -11.820, 14.612> <-8.943, -11.777, 14.673> <-8.943, -11.773, 14.726> 
		<-8.500, -11.840, 14.563> <-8.500, -11.820, 14.612> <-8.500, -11.777, 14.673> <-8.500, -11.773, 14.726> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -11.840, 14.563> <-8.500, -11.840, 14.563> <-8.500, -11.840, 14.563> <-8.500, -11.840, 14.563> 
		<-8.087, -11.840, 14.563> <-8.087, -12.293, 14.591> <-8.087, -12.293, 14.591> <-8.500, -12.293, 14.591> 
		<-7.744, -12.183, 14.584> <-7.744, -12.595, 14.610> <-8.087, -12.896, 14.629> <-8.500, -12.896, 14.629> 
		<-7.744, -12.595, 14.610> <-7.744, -13.006, 14.636> <-8.087, -13.349, 14.657> <-8.500, -13.349, 14.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -11.840, 14.563> <-8.500, -11.820, 14.612> <-8.500, -11.777, 14.673> <-8.500, -11.773, 14.726> 
		<-8.087, -11.840, 14.563> <-8.087, -11.820, 14.612> <-8.057, -11.777, 14.673> <-8.057, -11.773, 14.726> 
		<-7.744, -12.183, 14.584> <-7.744, -12.179, 14.637> <-7.689, -12.145, 14.696> <-7.688, -12.141, 14.749> 
		<-7.744, -12.595, 14.610> <-7.744, -12.591, 14.663> <-7.689, -12.587, 14.724> <-7.688, -12.584, 14.777> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.744, -12.595, 14.610> <-7.744, -12.591, 14.663> <-7.689, -12.587, 14.724> <-7.688, -12.584, 14.777> 
		<-7.744, -13.006, 14.636> <-7.744, -13.003, 14.689> <-7.689, -13.029, 14.752> <-7.688, -13.026, 14.805> 
		<-8.087, -13.349, 14.657> <-8.087, -13.363, 14.708> <-8.057, -13.397, 14.775> <-8.057, -13.394, 14.828> 
		<-8.500, -13.349, 14.657> <-8.500, -13.363, 14.708> <-8.500, -13.397, 14.775> <-8.500, -13.394, 14.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.312, -12.020, 23.296> <-9.312, -12.189, 20.740> <-9.328, -12.415, 17.333> <-9.312, -12.584, 14.777> 
		<-9.312, -12.462, 23.324> <-9.312, -12.631, 20.768> <-9.328, -12.857, 17.360> <-9.312, -13.026, 14.805> 
		<-8.943, -12.830, 23.347> <-8.943, -12.999, 20.791> <-8.943, -13.241, 17.384> <-8.943, -13.394, 14.828> 
		<-8.500, -12.830, 23.347> <-8.500, -12.999, 20.791> <-8.500, -13.241, 17.384> <-8.500, -13.394, 14.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.312, -12.020, 23.296> <-9.312, -11.578, 23.268> <-8.943, -11.210, 23.245> <-8.500, -11.210, 23.245> 
		<-9.312, -12.189, 20.740> <-9.312, -11.747, 20.713> <-8.943, -11.379, 20.689> <-8.500, -11.379, 20.689> 
		<-9.328, -12.415, 17.333> <-9.328, -11.972, 17.305> <-8.943, -11.588, 17.281> <-8.500, -11.588, 17.281> 
		<-9.312, -12.584, 14.777> <-9.312, -12.141, 14.749> <-8.943, -11.773, 14.726> <-8.500, -11.773, 14.726> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -11.210, 23.245> <-8.057, -11.210, 23.245> <-7.688, -11.578, 23.268> <-7.688, -12.020, 23.296> 
		<-8.500, -11.379, 20.689> <-8.057, -11.379, 20.689> <-7.688, -11.747, 20.713> <-7.688, -12.189, 20.740> 
		<-8.500, -11.588, 17.281> <-8.057, -11.588, 17.281> <-7.672, -11.972, 17.305> <-7.672, -12.415, 17.333> 
		<-8.500, -11.773, 14.726> <-8.057, -11.773, 14.726> <-7.688, -12.141, 14.749> <-7.688, -12.584, 14.777> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.688, -12.020, 23.296> <-7.688, -12.462, 23.324> <-8.057, -12.830, 23.347> <-8.500, -12.830, 23.347> 
		<-7.688, -12.189, 20.740> <-7.688, -12.631, 20.768> <-8.057, -12.999, 20.791> <-8.500, -12.999, 20.791> 
		<-7.672, -12.415, 17.333> <-7.672, -12.857, 17.360> <-8.057, -13.241, 17.384> <-8.500, -13.241, 17.384> 
		<-7.688, -12.584, 14.777> <-7.688, -13.026, 14.805> <-8.057, -13.394, 14.828> <-8.500, -13.394, 14.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.763, -16.157, -39.325> <-0.754, -16.142, -39.106> <-0.765, -16.123, -38.813> <-0.782, -16.108, -38.595> 
		<-0.763, -16.572, -39.298> <-0.754, -16.557, -39.079> <-0.765, -16.547, -38.785> <-0.782, -16.532, -38.567> 
		<-0.416, -16.917, -39.275> <-0.397, -16.907, -39.054> <-0.427, -16.883, -38.762> <-0.428, -16.885, -38.540> 
		<0.000, -16.917, -39.275> <0.019, -16.907, -39.054> <-0.002, -16.883, -38.758> <-0.003, -16.885, -38.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.763, -16.157, -39.325> <-0.763, -16.572, -39.298> <-0.416, -16.917, -39.275> <0.000, -16.917, -39.275> 
		<-0.769, -16.167, -39.485> <-0.769, -16.582, -39.458> <-0.437, -16.928, -39.516> <-0.021, -16.928, -39.516> 
		<-0.787, -16.181, -39.701> <-0.787, -16.588, -39.674> <-0.444, -16.932, -39.695> <-0.062, -16.942, -39.839> 
		<-0.833, -16.192, -39.855> <-0.833, -16.598, -39.828> <-0.515, -16.945, -39.926> <-0.134, -16.954, -40.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.763, -16.157, -39.325> <-0.763, -15.741, -39.353> <-0.416, -15.396, -39.375> <0.000, -15.396, -39.375> 
		<-0.754, -16.142, -39.106> <-0.754, -15.727, -39.134> <-0.397, -15.376, -39.155> <0.019, -15.376, -39.155> 
		<-0.765, -16.123, -38.813> <-0.765, -15.699, -38.842> <-0.427, -15.362, -38.863> <-0.002, -15.362, -38.859> 
		<-0.782, -16.108, -38.595> <-0.782, -15.684, -38.623> <-0.428, -15.331, -38.643> <-0.003, -15.331, -38.639> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.763, -16.157, -39.325> <-0.769, -16.167, -39.485> <-0.787, -16.181, -39.701> <-0.833, -16.192, -39.855> 
		<-0.763, -15.741, -39.353> <-0.769, -15.752, -39.513> <-0.787, -15.775, -39.728> <-0.833, -15.785, -39.882> 
		<-0.416, -15.396, -39.375> <-0.437, -15.416, -39.616> <-0.444, -15.436, -39.794> <-0.515, -15.454, -40.024> 
		<0.000, -15.396, -39.375> <-0.021, -15.416, -39.616> <-0.062, -15.446, -39.938> <-0.134, -15.464, -40.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -15.396, -39.375> <0.416, -15.396, -39.375> <0.763, -15.741, -39.353> <0.763, -16.157, -39.325> 
		<0.019, -15.376, -39.155> <0.435, -15.376, -39.155> <0.789, -15.727, -39.131> <0.789, -16.142, -39.103> 
		<-0.002, -15.362, -38.859> <0.423, -15.362, -38.855> <0.760, -15.698, -38.832> <0.760, -16.122, -38.803> 
		<-0.003, -15.331, -38.639> <0.422, -15.331, -38.635> <0.775, -15.683, -38.609> <0.775, -16.107, -38.581> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -15.396, -39.375> <-0.021, -15.416, -39.616> <-0.062, -15.446, -39.938> <-0.134, -15.464, -40.168> 
		<0.416, -15.396, -39.375> <0.396, -15.416, -39.616> <0.319, -15.455, -40.081> <0.247, -15.473, -40.312> 
		<0.763, -15.741, -39.353> <0.725, -15.762, -39.673> <0.662, -15.799, -40.102> <0.565, -15.820, -40.409> 
		<0.763, -16.157, -39.325> <0.725, -16.178, -39.646> <0.662, -16.206, -40.075> <0.565, -16.226, -40.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.763, -16.157, -39.325> <0.763, -16.572, -39.298> <0.416, -16.917, -39.275> <0.000, -16.917, -39.275> 
		<0.789, -16.142, -39.103> <0.789, -16.557, -39.076> <0.435, -16.907, -39.054> <0.019, -16.907, -39.054> 
		<0.760, -16.122, -38.803> <0.760, -16.546, -38.775> <0.423, -16.883, -38.754> <-0.002, -16.883, -38.758> 
		<0.775, -16.107, -38.581> <0.775, -16.531, -38.553> <0.422, -16.884, -38.533> <-0.003, -16.885, -38.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.763, -16.157, -39.325> <0.725, -16.178, -39.646> <0.662, -16.206, -40.075> <0.565, -16.226, -40.382> 
		<0.763, -16.572, -39.298> <0.725, -16.593, -39.618> <0.662, -16.613, -40.048> <0.565, -16.633, -40.355> 
		<0.416, -16.917, -39.275> <0.396, -16.928, -39.516> <0.319, -16.951, -39.982> <0.247, -16.964, -40.213> 
		<0.000, -16.917, -39.275> <-0.021, -16.928, -39.516> <-0.062, -16.942, -39.839> <-0.134, -16.954, -40.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.753, -16.156, -39.318> <-7.742, -16.166, -39.466> <-7.685, -16.179, -39.661> <-7.627, -16.188, -39.799> 
		<-7.753, -16.563, -39.291> <-7.742, -16.573, -39.439> <-7.685, -16.586, -39.634> <-7.627, -16.595, -39.772> 
		<-8.092, -16.901, -39.268> <-8.063, -16.912, -39.506> <-8.026, -16.927, -39.660> <-7.939, -16.942, -39.883> 
		<-8.500, -16.901, -39.268> <-8.471, -16.912, -39.506> <-8.400, -16.938, -39.820> <-8.314, -16.953, -40.043> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.753, -16.156, -39.318> <-7.753, -16.563, -39.291> <-8.092, -16.901, -39.268> <-8.500, -16.901, -39.268> 
		<-7.769, -16.142, -39.101> <-7.769, -16.549, -39.074> <-8.119, -16.892, -39.053> <-8.526, -16.892, -39.053> 
		<-7.738, -16.123, -38.812> <-7.738, -16.546, -38.783> <-8.073, -16.880, -38.762> <-8.498, -16.880, -38.762> 
		<-7.718, -16.108, -38.596> <-7.718, -16.532, -38.568> <-8.072, -16.885, -38.545> <-8.497, -16.885, -38.546> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.753, -16.156, -39.318> <-7.753, -15.749, -39.344> <-8.092, -15.411, -39.367> <-8.500, -15.411, -39.367> 
		<-7.742, -16.166, -39.466> <-7.742, -15.759, -39.493> <-8.063, -15.431, -39.604> <-8.471, -15.431, -39.604> 
		<-7.685, -16.179, -39.661> <-7.685, -15.772, -39.688> <-8.026, -15.437, -39.758> <-8.400, -15.447, -39.919> 
		<-7.627, -16.188, -39.799> <-7.627, -15.781, -39.826> <-7.939, -15.451, -39.981> <-8.314, -15.462, -40.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.753, -16.156, -39.318> <-7.769, -16.142, -39.101> <-7.738, -16.123, -38.812> <-7.718, -16.108, -38.596> 
		<-7.753, -15.749, -39.344> <-7.769, -15.735, -39.128> <-7.738, -15.699, -38.840> <-7.718, -15.684, -38.624> 
		<-8.092, -15.411, -39.367> <-8.119, -15.392, -39.152> <-8.073, -15.365, -38.862> <-8.072, -15.332, -38.648> 
		<-8.500, -15.411, -39.367> <-8.526, -15.392, -39.152> <-8.498, -15.365, -38.863> <-8.497, -15.332, -38.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.627, -16.188, -39.799> <-7.553, -16.199, -39.973> <-7.428, -16.214, -40.196> <-7.316, -16.224, -40.349> 
		<-7.627, -16.595, -39.772> <-7.553, -16.606, -39.946> <-7.428, -16.621, -40.169> <-7.316, -16.631, -40.322> 
		<-7.939, -16.942, -39.883> <-7.856, -16.956, -40.096> <-7.733, -16.969, -40.300> <-7.600, -16.982, -40.486> 
		<-8.314, -16.953, -40.043> <-8.231, -16.967, -40.256> <-8.074, -16.984, -40.522> <-7.941, -16.997, -40.708> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.627, -16.188, -39.799> <-7.627, -15.781, -39.826> <-7.939, -15.451, -39.981> <-8.314, -15.462, -40.142> 
		<-7.553, -16.199, -39.973> <-7.553, -15.793, -40.000> <-7.856, -15.465, -40.195> <-8.231, -15.476, -40.355> 
		<-7.428, -16.214, -40.196> <-7.428, -15.807, -40.223> <-7.733, -15.479, -40.398> <-8.074, -15.494, -40.621> 
		<-7.316, -16.224, -40.349> <-7.316, -15.817, -40.376> <-7.600, -15.491, -40.584> <-7.941, -15.506, -40.807> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.316, -16.224, -40.349> <-7.206, -16.234, -40.500> <-7.034, -16.246, -40.681> <-6.894, -16.254, -40.804> 
		<-7.316, -16.631, -40.322> <-7.206, -16.641, -40.473> <-7.034, -16.653, -40.654> <-6.894, -16.661, -40.777> 
		<-7.600, -16.982, -40.486> <-7.470, -16.994, -40.666> <-7.308, -17.005, -40.834> <-7.143, -17.015, -40.984> 
		<-7.941, -16.997, -40.708> <-7.812, -17.008, -40.889> <-7.608, -17.023, -41.109> <-7.444, -17.033, -41.259> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.316, -16.224, -40.349> <-7.316, -15.817, -40.376> <-7.600, -15.491, -40.584> <-7.941, -15.506, -40.807> 
		<-7.206, -16.234, -40.500> <-7.206, -15.827, -40.527> <-7.470, -15.503, -40.765> <-7.812, -15.518, -40.988> 
		<-7.034, -16.246, -40.681> <-7.034, -15.839, -40.708> <-7.308, -15.514, -40.932> <-7.608, -15.532, -41.208> 
		<-6.894, -16.254, -40.804> <-6.894, -15.847, -40.831> <-7.143, -15.524, -41.082> <-7.444, -15.542, -41.357> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.894, -16.254, -40.804> <-6.776, -16.261, -40.907> <-6.598, -16.269, -41.022> <-6.461, -16.274, -41.098> 
		<-6.894, -16.661, -40.777> <-6.776, -16.668, -40.880> <-6.598, -16.675, -40.995> <-6.461, -16.681, -41.071> 
		<-7.143, -17.015, -40.984> <-6.999, -17.023, -41.115> <-6.836, -17.030, -41.218> <-6.667, -17.037, -41.317> 
		<-7.444, -17.033, -41.259> <-7.299, -17.042, -41.390> <-7.083, -17.052, -41.541> <-6.915, -17.058, -41.640> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.894, -16.254, -40.804> <-6.894, -15.847, -40.831> <-7.143, -15.524, -41.082> <-7.444, -15.542, -41.357> 
		<-6.776, -16.261, -40.907> <-6.776, -15.854, -40.934> <-6.999, -15.533, -41.214> <-7.299, -15.551, -41.489> 
		<-6.598, -16.269, -41.022> <-6.598, -15.862, -41.049> <-6.836, -15.540, -41.316> <-7.083, -15.561, -41.639> 
		<-6.461, -16.274, -41.098> <-6.461, -15.867, -41.125> <-6.667, -15.546, -41.416> <-6.915, -15.568, -41.739> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.461, -16.274, -41.098> <-6.335, -16.278, -41.168> <-6.154, -16.283, -41.236> <-6.020, -16.286, -41.287> 
		<-6.461, -16.681, -41.071> <-6.335, -16.685, -41.141> <-6.154, -16.690, -41.209> <-6.020, -16.693, -41.260> 
		<-6.667, -17.037, -41.317> <-6.506, -17.043, -41.413> <-6.343, -17.047, -41.471> <-6.170, -17.052, -41.542> 
		<-6.915, -17.058, -41.640> <-6.754, -17.064, -41.736> <-6.523, -17.071, -41.836> <-6.350, -17.076, -41.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.461, -16.274, -41.098> <-6.461, -15.867, -41.125> <-6.667, -15.546, -41.416> <-6.915, -15.568, -41.739> 
		<-6.335, -16.278, -41.168> <-6.335, -15.872, -41.194> <-6.506, -15.553, -41.511> <-6.754, -15.574, -41.834> 
		<-6.154, -16.283, -41.236> <-6.154, -15.876, -41.263> <-6.343, -15.556, -41.570> <-6.523, -15.580, -41.935> 
		<-6.020, -16.286, -41.287> <-6.020, -15.879, -41.314> <-6.170, -15.561, -41.640> <-6.350, -15.585, -42.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.020, -16.286, -41.287> <-5.882, -16.290, -41.340> <-5.697, -16.294, -41.412> <-5.553, -16.297, -41.445> 
		<-6.020, -16.693, -41.260> <-5.882, -16.697, -41.313> <-5.697, -16.701, -41.385> <-5.553, -16.703, -41.418> 
		<-6.170, -17.052, -41.542> <-5.992, -17.056, -41.614> <-5.827, -17.061, -41.679> <-5.641, -17.064, -41.723> 
		<-6.350, -17.076, -41.907> <-6.172, -17.081, -41.979> <-5.932, -17.087, -42.072> <-5.746, -17.090, -42.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.020, -16.286, -41.287> <-6.020, -15.879, -41.314> <-6.170, -15.561, -41.640> <-6.350, -15.585, -42.005> 
		<-5.882, -16.290, -41.340> <-5.882, -15.883, -41.367> <-5.992, -15.566, -41.712> <-6.172, -15.590, -42.077> 
		<-5.697, -16.294, -41.412> <-5.697, -15.888, -41.439> <-5.827, -15.570, -41.777> <-5.932, -15.596, -42.170> 
		<-5.553, -16.297, -41.445> <-5.553, -15.890, -41.472> <-5.641, -15.573, -41.821> <-5.746, -15.599, -42.214> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.553, -16.297, -41.445> <-5.373, -16.299, -41.486> <-5.128, -16.301, -41.514> <-4.944, -16.302, -41.533> 
		<-5.553, -16.703, -41.418> <-5.373, -16.706, -41.459> <-5.128, -16.708, -41.487> <-4.944, -16.709, -41.506> 
		<-5.641, -17.064, -41.723> <-5.421, -17.067, -41.775> <-5.195, -17.069, -41.797> <-4.970, -17.070, -41.821> 
		<-5.746, -17.090, -42.116> <-5.526, -17.093, -42.168> <-5.225, -17.095, -42.203> <-5.001, -17.097, -42.227> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.553, -16.297, -41.445> <-5.553, -15.890, -41.472> <-5.641, -15.573, -41.821> <-5.746, -15.599, -42.214> 
		<-5.373, -16.299, -41.486> <-5.373, -15.893, -41.513> <-5.421, -15.576, -41.874> <-5.526, -15.602, -42.267> 
		<-5.128, -16.301, -41.514> <-5.128, -15.894, -41.541> <-5.195, -15.578, -41.895> <-5.225, -15.605, -42.301> 
		<-4.944, -16.302, -41.533> <-4.944, -15.896, -41.560> <-4.970, -15.579, -41.920> <-5.001, -15.606, -42.325> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.944, -16.302, -41.533> <-4.737, -16.304, -41.554> <-4.459, -16.306, -41.585> <-4.250, -16.306, -41.580> 
		<-4.944, -16.709, -41.506> <-4.737, -16.711, -41.527> <-4.459, -16.713, -41.558> <-4.250, -16.712, -41.553> 
		<-4.970, -17.070, -41.821> <-4.746, -17.072, -41.845> <-4.476, -17.074, -41.874> <-4.250, -17.073, -41.869> 
		<-5.001, -17.097, -42.227> <-4.776, -17.099, -42.251> <-4.476, -17.101, -42.281> <-4.250, -17.100, -42.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.944, -16.302, -41.533> <-4.944, -15.896, -41.560> <-4.970, -15.579, -41.920> <-5.001, -15.606, -42.325> 
		<-4.737, -16.304, -41.554> <-4.737, -15.897, -41.581> <-4.746, -15.581, -41.944> <-4.776, -15.608, -42.349> 
		<-4.459, -16.306, -41.585> <-4.459, -15.899, -41.612> <-4.476, -15.583, -41.973> <-4.476, -15.610, -42.379> 
		<-4.250, -16.306, -41.580> <-4.250, -15.899, -41.607> <-4.250, -15.583, -41.968> <-4.250, -15.610, -42.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.250, -16.306, -41.580> <-4.025, -16.305, -41.575> <-3.727, -16.302, -41.527> <-3.503, -16.300, -41.501> 
		<-4.250, -16.712, -41.553> <-4.025, -16.712, -41.548> <-3.727, -16.709, -41.501> <-3.503, -16.707, -41.474> 
		<-4.250, -17.073, -41.869> <-4.008, -17.073, -41.864> <-3.718, -17.070, -41.818> <-3.478, -17.068, -41.789> 
		<-4.250, -17.100, -42.276> <-4.008, -17.100, -42.271> <-3.687, -17.097, -42.223> <-3.447, -17.095, -42.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.250, -16.306, -41.580> <-4.250, -15.899, -41.607> <-4.250, -15.583, -41.968> <-4.250, -15.610, -42.375> 
		<-4.025, -16.305, -41.575> <-4.025, -15.898, -41.602> <-4.008, -15.582, -41.963> <-4.008, -15.609, -42.370> 
		<-3.727, -16.302, -41.527> <-3.727, -15.895, -41.554> <-3.718, -15.579, -41.916> <-3.687, -15.606, -42.322> 
		<-3.503, -16.300, -41.501> <-3.503, -15.894, -41.528> <-3.478, -15.577, -41.888> <-3.447, -15.604, -42.293> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.503, -16.300, -41.501> <-3.305, -16.299, -41.477> <-3.040, -16.297, -41.450> <-2.844, -16.295, -41.413> 
		<-3.503, -16.707, -41.474> <-3.305, -16.706, -41.450> <-3.040, -16.704, -41.423> <-2.844, -16.701, -41.386> 
		<-3.478, -17.068, -41.789> <-3.246, -17.066, -41.762> <-2.997, -17.065, -41.740> <-2.768, -17.062, -41.693> 
		<-3.447, -17.095, -42.195> <-3.215, -17.093, -42.167> <-2.905, -17.091, -42.136> <-2.676, -17.088, -42.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.503, -16.300, -41.501> <-3.503, -15.894, -41.528> <-3.478, -15.577, -41.888> <-3.447, -15.604, -42.293> 
		<-3.305, -16.299, -41.477> <-3.305, -15.892, -41.504> <-3.246, -15.576, -41.860> <-3.215, -15.602, -42.266> 
		<-3.040, -16.297, -41.450> <-3.040, -15.890, -41.477> <-2.997, -15.574, -41.838> <-2.905, -15.600, -42.234> 
		<-2.844, -16.295, -41.413> <-2.844, -15.888, -41.440> <-2.768, -15.571, -41.792> <-2.676, -15.597, -42.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.844, -16.295, -41.413> <-2.687, -16.293, -41.383> <-2.478, -16.289, -41.332> <-2.327, -16.286, -41.277> 
		<-2.844, -16.701, -41.386> <-2.687, -16.699, -41.356> <-2.478, -16.696, -41.305> <-2.327, -16.692, -41.250> 
		<-2.768, -17.062, -41.693> <-2.568, -17.059, -41.653> <-2.378, -17.056, -41.609> <-2.187, -17.051, -41.536> 
		<-2.676, -17.088, -42.090> <-2.476, -17.085, -42.049> <-2.211, -17.081, -41.979> <-2.020, -17.076, -41.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.844, -16.295, -41.413> <-2.844, -15.888, -41.440> <-2.768, -15.571, -41.792> <-2.676, -15.597, -42.188> 
		<-2.687, -16.293, -41.383> <-2.687, -15.886, -41.410> <-2.568, -15.568, -41.752> <-2.476, -15.595, -42.148> 
		<-2.478, -16.289, -41.332> <-2.478, -15.882, -41.359> <-2.378, -15.565, -41.707> <-2.211, -15.590, -42.078> 
		<-2.327, -16.286, -41.277> <-2.327, -15.879, -41.304> <-2.187, -15.561, -41.635> <-2.020, -15.585, -42.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.327, -16.286, -41.277> <-2.175, -16.282, -41.221> <-1.982, -16.275, -41.124> <-1.842, -16.270, -41.043> 
		<-2.327, -16.692, -41.250> <-2.175, -16.689, -41.194> <-1.982, -16.682, -41.097> <-1.842, -16.677, -41.016> 
		<-2.187, -17.051, -41.536> <-2.002, -17.047, -41.465> <-1.823, -17.041, -41.379> <-1.654, -17.034, -41.276> 
		<-2.020, -17.076, -41.907> <-1.835, -17.071, -41.836> <-1.597, -17.063, -41.717> <-1.428, -17.056, -41.614> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.327, -16.286, -41.277> <-2.327, -15.879, -41.304> <-2.187, -15.561, -41.635> <-2.020, -15.585, -42.005> 
		<-2.175, -16.282, -41.221> <-2.175, -15.875, -41.248> <-2.002, -15.556, -41.564> <-1.835, -15.580, -41.935> 
		<-1.982, -16.275, -41.124> <-1.982, -15.869, -41.151> <-1.823, -15.550, -41.477> <-1.597, -15.573, -41.816> 
		<-1.842, -16.270, -41.043> <-1.842, -15.863, -41.070> <-1.654, -15.543, -41.374> <-1.428, -15.566, -41.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.842, -16.270, -41.043> <-1.711, -16.265, -40.968> <-1.538, -16.258, -40.861> <-1.429, -16.251, -40.758> 
		<-1.842, -16.677, -41.016> <-1.711, -16.672, -40.941> <-1.538, -16.665, -40.834> <-1.429, -16.658, -40.731> 
		<-1.654, -17.034, -41.276> <-1.478, -17.027, -41.168> <-1.326, -17.021, -41.078> <-1.176, -17.011, -40.935> 
		<-1.428, -17.056, -41.614> <-1.252, -17.049, -41.507> <-1.022, -17.039, -41.349> <-0.873, -17.029, -41.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.842, -16.270, -41.043> <-1.842, -15.863, -41.070> <-1.654, -15.543, -41.374> <-1.428, -15.566, -41.713> 
		<-1.711, -16.265, -40.968> <-1.711, -15.858, -40.995> <-1.478, -15.536, -41.267> <-1.252, -15.559, -41.605> 
		<-1.538, -16.258, -40.861> <-1.538, -15.851, -40.888> <-1.326, -15.530, -41.176> <-1.022, -15.548, -41.448> 
		<-1.429, -16.251, -40.758> <-1.429, -15.844, -40.785> <-1.176, -15.521, -41.033> <-0.873, -15.539, -41.305> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.429, -16.251, -40.758> <-1.298, -16.243, -40.633> <-1.148, -16.230, -40.441> <-1.048, -16.220, -40.290> 
		<-1.429, -16.658, -40.731> <-1.298, -16.650, -40.606> <-1.148, -16.637, -40.414> <-1.048, -16.627, -40.263> 
		<-1.176, -17.011, -40.935> <-1.023, -17.002, -40.788> <-0.882, -16.990, -40.608> <-0.767, -16.978, -40.430> 
		<-0.873, -17.029, -41.207> <-0.720, -17.020, -41.060> <-0.544, -17.005, -40.834> <-0.428, -16.993, -40.656> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.429, -16.251, -40.758> <-1.429, -15.844, -40.785> <-1.176, -15.521, -41.033> <-0.873, -15.539, -41.305> 
		<-1.298, -16.243, -40.633> <-1.298, -15.836, -40.660> <-1.023, -15.511, -40.886> <-0.720, -15.529, -41.158> 
		<-1.148, -16.230, -40.441> <-1.148, -15.824, -40.468> <-0.882, -15.499, -40.706> <-0.544, -15.514, -40.933> 
		<-1.048, -16.220, -40.290> <-1.048, -15.814, -40.317> <-0.767, -15.487, -40.528> <-0.428, -15.502, -40.755> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.048, -16.220, -40.290> <-0.968, -16.212, -40.169> <-0.874, -16.201, -39.995> <-0.833, -16.192, -39.855> 
		<-1.048, -16.627, -40.263> <-0.968, -16.619, -40.142> <-0.874, -16.608, -39.968> <-0.833, -16.598, -39.828> 
		<-0.767, -16.978, -40.430> <-0.659, -16.967, -40.264> <-0.574, -16.955, -40.114> <-0.515, -16.945, -39.926> 
		<-0.428, -16.993, -40.656> <-0.321, -16.982, -40.491> <-0.192, -16.965, -40.258> <-0.134, -16.954, -40.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.048, -16.220, -40.290> <-1.048, -15.814, -40.317> <-0.767, -15.487, -40.528> <-0.428, -15.502, -40.755> 
		<-0.968, -16.212, -40.169> <-0.968, -15.805, -40.196> <-0.659, -15.477, -40.363> <-0.321, -15.492, -40.590> 
		<-0.874, -16.201, -39.995> <-0.874, -15.794, -40.022> <-0.574, -15.469, -40.212> <-0.192, -15.478, -40.356> 
		<-0.833, -16.192, -39.855> <-0.833, -15.785, -39.882> <-0.515, -15.454, -40.024> <-0.134, -15.464, -40.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -15.411, -39.367> <-8.908, -15.411, -39.367> <-9.247, -15.749, -39.344> <-9.247, -16.156, -39.318> 
		<-8.471, -15.431, -39.604> <-8.879, -15.431, -39.604> <-9.197, -15.771, -39.670> <-9.197, -16.178, -39.643> 
		<-8.400, -15.447, -39.919> <-8.775, -15.458, -40.079> <-9.114, -15.799, -40.105> <-9.114, -16.206, -40.078> 
		<-8.314, -15.462, -40.142> <-8.688, -15.473, -40.302> <-9.000, -15.820, -40.413> <-9.000, -16.227, -40.387> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -15.411, -39.367> <-8.526, -15.392, -39.152> <-8.498, -15.365, -38.863> <-8.497, -15.332, -38.648> 
		<-8.908, -15.411, -39.367> <-8.934, -15.392, -39.152> <-8.922, -15.365, -38.863> <-8.922, -15.332, -38.649> 
		<-9.247, -15.749, -39.344> <-9.280, -15.735, -39.131> <-9.257, -15.699, -38.841> <-9.275, -15.685, -38.626> 
		<-9.247, -16.156, -39.318> <-9.280, -16.142, -39.104> <-9.257, -16.123, -38.813> <-9.275, -16.108, -38.598> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.314, -15.462, -40.142> <-8.688, -15.473, -40.302> <-9.000, -15.820, -40.413> <-9.000, -16.227, -40.387> 
		<-8.231, -15.476, -40.355> <-8.606, -15.487, -40.515> <-8.908, -15.837, -40.665> <-8.908, -16.243, -40.638> 
		<-8.074, -15.494, -40.621> <-8.415, -15.508, -40.844> <-8.720, -15.857, -40.974> <-8.720, -16.264, -40.947> 
		<-7.941, -15.506, -40.807> <-8.282, -15.521, -41.030> <-8.566, -15.871, -41.193> <-8.566, -16.278, -41.166> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.941, -15.506, -40.807> <-8.282, -15.521, -41.030> <-8.566, -15.871, -41.193> <-8.566, -16.278, -41.166> 
		<-7.812, -15.518, -40.988> <-8.153, -15.533, -41.211> <-8.417, -15.885, -41.404> <-8.417, -16.292, -41.377> 
		<-7.608, -15.532, -41.208> <-7.909, -15.551, -41.483> <-8.183, -15.902, -41.663> <-8.183, -16.309, -41.636> 
		<-7.444, -15.542, -41.357> <-7.744, -15.561, -41.633> <-7.994, -15.914, -41.839> <-7.994, -16.321, -41.812> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.444, -15.542, -41.357> <-7.744, -15.561, -41.633> <-7.994, -15.914, -41.839> <-7.994, -16.321, -41.812> 
		<-7.299, -15.551, -41.489> <-7.599, -15.569, -41.764> <-7.822, -15.925, -41.999> <-7.822, -16.332, -41.972> 
		<-7.083, -15.561, -41.639> <-7.331, -15.582, -41.962> <-7.568, -15.937, -42.185> <-7.568, -16.344, -42.158> 
		<-6.915, -15.568, -41.739> <-7.163, -15.589, -42.062> <-7.369, -15.945, -42.308> <-7.369, -16.352, -42.281> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.915, -15.568, -41.739> <-7.163, -15.589, -42.062> <-7.369, -15.945, -42.308> <-7.369, -16.352, -42.281> 
		<-6.754, -15.574, -41.834> <-7.002, -15.595, -42.157> <-7.172, -15.953, -42.430> <-7.172, -16.360, -42.403> 
		<-6.523, -15.580, -41.935> <-6.703, -15.605, -42.300> <-6.892, -15.962, -42.562> <-6.892, -16.369, -42.535> 
		<-6.350, -15.585, -42.005> <-6.529, -15.609, -42.370> <-6.679, -15.968, -42.652> <-6.679, -16.375, -42.625> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.350, -15.585, -42.005> <-6.529, -15.609, -42.370> <-6.679, -15.968, -42.652> <-6.679, -16.375, -42.625> 
		<-6.172, -15.590, -42.077> <-6.352, -15.614, -42.443> <-6.462, -15.974, -42.743> <-6.462, -16.381, -42.716> 
		<-5.932, -15.596, -42.170> <-6.037, -15.622, -42.563> <-6.167, -15.981, -42.857> <-6.167, -16.388, -42.830> 
		<-5.746, -15.599, -42.214> <-5.851, -15.625, -42.607> <-5.938, -15.985, -42.912> <-5.938, -16.392, -42.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.746, -15.599, -42.214> <-5.851, -15.625, -42.607> <-5.938, -15.985, -42.912> <-5.938, -16.392, -42.885> 
		<-5.526, -15.602, -42.267> <-5.631, -15.628, -42.660> <-5.678, -15.989, -42.975> <-5.678, -16.396, -42.948> 
		<-5.225, -15.605, -42.301> <-5.256, -15.632, -42.707> <-5.323, -15.992, -43.017> <-5.323, -16.399, -42.990> 
		<-5.001, -15.606, -42.325> <-5.031, -15.633, -42.731> <-5.057, -15.994, -43.046> <-5.057, -16.401, -43.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.001, -15.606, -42.325> <-5.031, -15.633, -42.731> <-5.057, -15.994, -43.046> <-5.057, -16.401, -43.019> 
		<-4.776, -15.608, -42.349> <-4.807, -15.635, -42.755> <-4.816, -15.996, -43.073> <-4.816, -16.403, -43.046> 
		<-4.476, -15.610, -42.379> <-4.476, -15.637, -42.786> <-4.493, -15.998, -43.102> <-4.493, -16.404, -43.075> 
		<-4.250, -15.610, -42.375> <-4.250, -15.636, -42.782> <-4.250, -15.997, -43.098> <-4.250, -16.404, -43.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.250, -15.610, -42.375> <-4.250, -15.636, -42.782> <-4.250, -15.997, -43.098> <-4.250, -16.404, -43.071> 
		<-4.008, -15.609, -42.370> <-4.008, -15.636, -42.777> <-3.991, -15.997, -43.093> <-3.991, -16.404, -43.066> 
		<-3.687, -15.606, -42.322> <-3.657, -15.633, -42.727> <-3.648, -15.994, -43.044> <-3.648, -16.401, -43.018> 
		<-3.447, -15.604, -42.293> <-3.416, -15.631, -42.699> <-3.391, -15.992, -43.014> <-3.391, -16.399, -42.987> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.447, -15.604, -42.293> <-3.416, -15.631, -42.699> <-3.391, -15.992, -43.014> <-3.391, -16.399, -42.987> 
		<-3.215, -15.602, -42.266> <-3.185, -15.629, -42.671> <-3.125, -15.990, -42.983> <-3.125, -16.397, -42.956> 
		<-2.905, -15.600, -42.234> <-2.813, -15.627, -42.631> <-2.769, -15.987, -42.947> <-2.769, -16.394, -42.920> 
		<-2.676, -15.597, -42.188> <-2.584, -15.623, -42.585> <-2.507, -15.984, -42.892> <-2.507, -16.391, -42.865> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.676, -15.597, -42.188> <-2.584, -15.623, -42.585> <-2.507, -15.984, -42.892> <-2.507, -16.391, -42.865> 
		<-2.476, -15.595, -42.148> <-2.384, -15.621, -42.544> <-2.264, -15.980, -42.841> <-2.264, -16.387, -42.814> 
		<-2.211, -15.590, -42.078> <-2.043, -15.614, -42.449> <-1.944, -15.975, -42.752> <-1.944, -16.381, -42.725> 
		<-2.020, -15.585, -42.005> <-1.852, -15.610, -42.376> <-1.712, -15.969, -42.662> <-1.712, -16.375, -42.635> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.020, -15.585, -42.005> <-1.852, -15.610, -42.376> <-1.712, -15.969, -42.662> <-1.712, -16.375, -42.635> 
		<-1.835, -15.580, -41.935> <-1.667, -15.605, -42.306> <-1.494, -15.963, -42.577> <-1.494, -16.370, -42.550> 
		<-1.597, -15.573, -41.816> <-1.371, -15.595, -42.155> <-1.212, -15.954, -42.436> <-1.212, -16.360, -42.409> 
		<-1.428, -15.566, -41.713> <-1.202, -15.588, -42.051> <-1.014, -15.945, -42.311> <-1.014, -16.352, -42.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.428, -15.566, -41.713> <-1.202, -15.588, -42.051> <-1.014, -15.945, -42.311> <-1.014, -16.352, -42.284> 
		<-1.252, -15.559, -41.605> <-1.026, -15.581, -41.944> <-0.792, -15.936, -42.171> <-0.792, -16.343, -42.144> 
		<-1.022, -15.548, -41.448> <-0.719, -15.566, -41.720> <-0.507, -15.922, -41.963> <-0.507, -16.329, -41.936> 
		<-0.873, -15.539, -41.305> <-0.570, -15.557, -41.577> <-0.318, -15.910, -41.781> <-0.318, -16.317, -41.754> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.873, -15.539, -41.305> <-0.570, -15.557, -41.577> <-0.318, -15.910, -41.781> <-0.318, -16.317, -41.754> 
		<-0.720, -15.529, -41.158> <-0.417, -15.547, -41.430> <-0.142, -15.899, -41.612> <-0.142, -16.306, -41.585> 
		<-0.544, -15.514, -40.933> <-0.205, -15.529, -41.159> <0.060, -15.882, -41.353> <0.060, -16.289, -41.326> 
		<-0.428, -15.502, -40.755> <-0.090, -15.517, -40.981> <0.192, -15.868, -41.147> <0.192, -16.275, -41.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.428, -15.502, -40.755> <-0.090, -15.517, -40.981> <0.192, -15.868, -41.147> <0.192, -16.275, -41.121> 
		<-0.321, -15.492, -40.590> <0.018, -15.507, -40.816> <0.326, -15.855, -40.939> <0.326, -16.261, -40.912> 
		<-0.192, -15.478, -40.356> <0.189, -15.488, -40.500> <0.490, -15.835, -40.646> <0.490, -16.242, -40.619> 
		<-0.134, -15.464, -40.168> <0.247, -15.473, -40.312> <0.565, -15.820, -40.409> <0.565, -16.226, -40.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.247, -16.156, -39.318> <-9.247, -16.563, -39.291> <-8.908, -16.901, -39.268> <-8.500, -16.901, -39.268> 
		<-9.197, -16.178, -39.643> <-9.197, -16.584, -39.616> <-8.879, -16.912, -39.506> <-8.471, -16.912, -39.506> 
		<-9.114, -16.206, -40.078> <-9.114, -16.613, -40.051> <-8.775, -16.948, -39.981> <-8.400, -16.938, -39.820> 
		<-9.000, -16.227, -40.387> <-9.000, -16.633, -40.360> <-8.688, -16.963, -40.204> <-8.314, -16.953, -40.043> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.247, -16.156, -39.318> <-9.280, -16.142, -39.104> <-9.257, -16.123, -38.813> <-9.275, -16.108, -38.598> 
		<-9.247, -16.563, -39.291> <-9.280, -16.549, -39.077> <-9.257, -16.547, -38.785> <-9.275, -16.532, -38.570> 
		<-8.908, -16.901, -39.268> <-8.934, -16.892, -39.053> <-8.922, -16.880, -38.763> <-8.922, -16.885, -38.546> 
		<-8.500, -16.901, -39.268> <-8.526, -16.892, -39.053> <-8.498, -16.880, -38.762> <-8.497, -16.885, -38.546> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.000, -16.227, -40.387> <-9.000, -16.633, -40.360> <-8.688, -16.963, -40.204> <-8.314, -16.953, -40.043> 
		<-8.908, -16.243, -40.638> <-8.908, -16.650, -40.611> <-8.606, -16.977, -40.417> <-8.231, -16.967, -40.256> 
		<-8.720, -16.264, -40.947> <-8.720, -16.671, -40.920> <-8.415, -16.999, -40.745> <-8.074, -16.984, -40.522> 
		<-8.566, -16.278, -41.166> <-8.566, -16.685, -41.139> <-8.282, -17.011, -40.931> <-7.941, -16.997, -40.708> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.566, -16.278, -41.166> <-8.566, -16.685, -41.139> <-8.282, -17.011, -40.931> <-7.941, -16.997, -40.708> 
		<-8.417, -16.292, -41.377> <-8.417, -16.699, -41.351> <-8.153, -17.023, -41.112> <-7.812, -17.008, -40.889> 
		<-8.183, -16.309, -41.636> <-8.183, -16.716, -41.609> <-7.909, -17.041, -41.384> <-7.608, -17.023, -41.109> 
		<-7.994, -16.321, -41.812> <-7.994, -16.728, -41.785> <-7.744, -17.051, -41.534> <-7.444, -17.033, -41.259> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.994, -16.321, -41.812> <-7.994, -16.728, -41.785> <-7.744, -17.051, -41.534> <-7.444, -17.033, -41.259> 
		<-7.822, -16.332, -41.972> <-7.822, -16.738, -41.945> <-7.599, -17.060, -41.665> <-7.299, -17.042, -41.390> 
		<-7.568, -16.344, -42.158> <-7.568, -16.751, -42.131> <-7.331, -17.073, -41.864> <-7.083, -17.052, -41.541> 
		<-7.369, -16.352, -42.281> <-7.369, -16.759, -42.255> <-7.163, -17.080, -41.963> <-6.915, -17.058, -41.640> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.369, -16.352, -42.281> <-7.369, -16.759, -42.255> <-7.163, -17.080, -41.963> <-6.915, -17.058, -41.640> 
		<-7.172, -16.360, -42.403> <-7.172, -16.767, -42.376> <-7.002, -17.086, -42.059> <-6.754, -17.064, -41.736> 
		<-6.892, -16.369, -42.535> <-6.892, -16.776, -42.508> <-6.703, -17.095, -42.201> <-6.523, -17.071, -41.836> 
		<-6.679, -16.375, -42.625> <-6.679, -16.781, -42.598> <-6.529, -17.100, -42.272> <-6.350, -17.076, -41.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.679, -16.375, -42.625> <-6.679, -16.781, -42.598> <-6.529, -17.100, -42.272> <-6.350, -17.076, -41.907> 
		<-6.462, -16.381, -42.716> <-6.462, -16.788, -42.690> <-6.352, -17.105, -42.344> <-6.172, -17.081, -41.979> 
		<-6.167, -16.388, -42.830> <-6.167, -16.795, -42.803> <-6.037, -17.113, -42.465> <-5.932, -17.087, -42.072> 
		<-5.938, -16.392, -42.885> <-5.938, -16.799, -42.858> <-5.851, -17.116, -42.509> <-5.746, -17.090, -42.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.938, -16.392, -42.885> <-5.938, -16.799, -42.858> <-5.851, -17.116, -42.509> <-5.746, -17.090, -42.116> 
		<-5.678, -16.396, -42.948> <-5.678, -16.803, -42.922> <-5.631, -17.119, -42.561> <-5.526, -17.093, -42.168> 
		<-5.323, -16.399, -42.990> <-5.323, -16.806, -42.963> <-5.256, -17.122, -42.608> <-5.225, -17.095, -42.203> 
		<-5.057, -16.401, -43.019> <-5.057, -16.808, -42.992> <-5.031, -17.124, -42.632> <-5.001, -17.097, -42.227> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.057, -16.401, -43.019> <-5.057, -16.808, -42.992> <-5.031, -17.124, -42.632> <-5.001, -17.097, -42.227> 
		<-4.816, -16.403, -43.046> <-4.816, -16.809, -43.019> <-4.807, -17.125, -42.656> <-4.776, -17.099, -42.251> 
		<-4.493, -16.404, -43.075> <-4.493, -16.811, -43.049> <-4.476, -17.127, -42.688> <-4.476, -17.101, -42.281> 
		<-4.250, -16.404, -43.071> <-4.250, -16.811, -43.044> <-4.250, -17.127, -42.683> <-4.250, -17.100, -42.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.250, -16.404, -43.071> <-4.250, -16.811, -43.044> <-4.250, -17.127, -42.683> <-4.250, -17.100, -42.276> 
		<-3.991, -16.404, -43.066> <-3.991, -16.811, -43.039> <-4.008, -17.127, -42.678> <-4.008, -17.100, -42.271> 
		<-3.648, -16.401, -43.018> <-3.648, -16.807, -42.991> <-3.657, -17.124, -42.629> <-3.687, -17.097, -42.223> 
		<-3.391, -16.399, -42.987> <-3.391, -16.805, -42.960> <-3.416, -17.122, -42.600> <-3.447, -17.095, -42.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.391, -16.399, -42.987> <-3.391, -16.805, -42.960> <-3.416, -17.122, -42.600> <-3.447, -17.095, -42.195> 
		<-3.125, -16.397, -42.956> <-3.125, -16.803, -42.929> <-3.185, -17.120, -42.573> <-3.215, -17.093, -42.167> 
		<-2.769, -16.394, -42.920> <-2.769, -16.801, -42.893> <-2.813, -17.117, -42.532> <-2.905, -17.091, -42.136> 
		<-2.507, -16.391, -42.865> <-2.507, -16.797, -42.838> <-2.584, -17.114, -42.486> <-2.676, -17.088, -42.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.507, -16.391, -42.865> <-2.507, -16.797, -42.838> <-2.584, -17.114, -42.486> <-2.676, -17.088, -42.090> 
		<-2.264, -16.387, -42.814> <-2.264, -16.794, -42.787> <-2.384, -17.111, -42.446> <-2.476, -17.085, -42.049> 
		<-1.944, -16.381, -42.725> <-1.944, -16.788, -42.698> <-2.043, -17.105, -42.350> <-2.211, -17.081, -41.979> 
		<-1.712, -16.375, -42.635> <-1.712, -16.782, -42.608> <-1.852, -17.100, -42.277> <-2.020, -17.076, -41.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.712, -16.375, -42.635> <-1.712, -16.782, -42.608> <-1.852, -17.100, -42.277> <-2.020, -17.076, -41.907> 
		<-1.494, -16.370, -42.550> <-1.494, -16.777, -42.523> <-1.667, -17.096, -42.207> <-1.835, -17.071, -41.836> 
		<-1.212, -16.360, -42.409> <-1.212, -16.767, -42.382> <-1.371, -17.086, -42.056> <-1.597, -17.063, -41.717> 
		<-1.014, -16.352, -42.284> <-1.014, -16.759, -42.257> <-1.202, -17.079, -41.953> <-1.428, -17.056, -41.614> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.014, -16.352, -42.284> <-1.014, -16.759, -42.257> <-1.202, -17.079, -41.953> <-1.428, -17.056, -41.614> 
		<-0.792, -16.343, -42.144> <-0.792, -16.750, -42.117> <-1.026, -17.072, -41.845> <-1.252, -17.049, -41.507> 
		<-0.507, -16.329, -41.936> <-0.507, -16.736, -41.909> <-0.719, -17.057, -41.621> <-1.022, -17.039, -41.349> 
		<-0.318, -16.317, -41.754> <-0.318, -16.724, -41.727> <-0.570, -17.047, -41.479> <-0.873, -17.029, -41.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.318, -16.317, -41.754> <-0.318, -16.724, -41.727> <-0.570, -17.047, -41.479> <-0.873, -17.029, -41.207> 
		<-0.142, -16.306, -41.585> <-0.142, -16.713, -41.558> <-0.417, -17.038, -41.332> <-0.720, -17.020, -41.060> 
		<0.060, -16.289, -41.326> <0.060, -16.696, -41.299> <-0.205, -17.020, -41.061> <-0.544, -17.005, -40.834> 
		<0.192, -16.275, -41.121> <0.192, -16.682, -41.094> <-0.090, -17.008, -40.883> <-0.428, -16.993, -40.656> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.192, -16.275, -41.121> <0.192, -16.682, -41.094> <-0.090, -17.008, -40.883> <-0.428, -16.993, -40.656> 
		<0.326, -16.261, -40.912> <0.326, -16.668, -40.885> <0.018, -16.997, -40.718> <-0.321, -16.982, -40.491> 
		<0.490, -16.242, -40.619> <0.490, -16.649, -40.592> <0.189, -16.974, -40.401> <-0.192, -16.965, -40.258> 
		<0.565, -16.226, -40.382> <0.565, -16.633, -40.355> <0.247, -16.964, -40.213> <-0.134, -16.954, -40.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.718, -16.108, -38.596> <-7.718, -16.532, -38.568> <-8.072, -16.885, -38.545> <-8.497, -16.885, -38.546> 
		<-7.715, -16.106, -38.559> <-7.715, -16.530, -38.531> <-8.072, -16.886, -38.508> <-8.497, -16.886, -38.508> 
		<-7.676, -16.103, -38.517> <-7.676, -16.550, -38.487> <-8.049, -16.922, -38.463> <-8.497, -16.922, -38.464> 
		<-7.676, -16.101, -38.480> <-7.676, -16.548, -38.450> <-8.049, -16.920, -38.426> <-8.497, -16.920, -38.427> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.718, -16.108, -38.596> <-7.715, -16.106, -38.559> <-7.676, -16.103, -38.517> <-7.676, -16.101, -38.480> 
		<-7.718, -15.684, -38.624> <-7.715, -15.682, -38.587> <-7.676, -15.656, -38.546> <-7.676, -15.653, -38.509> 
		<-8.072, -15.332, -38.648> <-8.072, -15.326, -38.611> <-8.049, -15.284, -38.572> <-8.049, -15.281, -38.535> 
		<-8.497, -15.332, -38.648> <-8.497, -15.326, -38.612> <-8.497, -15.284, -38.572> <-8.497, -15.281, -38.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.497, -15.332, -38.648> <-8.497, -15.326, -38.612> <-8.497, -15.284, -38.572> <-8.497, -15.281, -38.535> 
		<-8.922, -15.332, -38.649> <-8.921, -15.326, -38.612> <-8.945, -15.284, -38.573> <-8.945, -15.281, -38.536> 
		<-9.275, -15.685, -38.626> <-9.278, -15.682, -38.589> <-9.318, -15.656, -38.549> <-9.318, -15.654, -38.512> 
		<-9.275, -16.108, -38.598> <-9.278, -16.106, -38.561> <-9.318, -16.103, -38.520> <-9.318, -16.101, -38.483> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.275, -16.108, -38.598> <-9.278, -16.106, -38.561> <-9.318, -16.103, -38.520> <-9.318, -16.101, -38.483> 
		<-9.275, -16.532, -38.570> <-9.278, -16.530, -38.533> <-9.318, -16.550, -38.490> <-9.318, -16.548, -38.453> 
		<-8.922, -16.885, -38.546> <-8.921, -16.886, -38.509> <-8.945, -16.922, -38.465> <-8.945, -16.920, -38.428> 
		<-8.497, -16.885, -38.546> <-8.497, -16.886, -38.508> <-8.497, -16.922, -38.464> <-8.497, -16.920, -38.427> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.782, -16.108, -38.595> <-0.784, -16.106, -38.567> <-0.826, -16.105, -38.540> <-0.827, -16.103, -38.512> 
		<-0.782, -16.532, -38.567> <-0.784, -16.530, -38.539> <-0.826, -16.553, -38.510> <-0.827, -16.551, -38.482> 
		<-0.428, -16.885, -38.540> <-0.428, -16.885, -38.512> <-0.453, -16.925, -38.482> <-0.453, -16.924, -38.454> 
		<-0.003, -16.885, -38.536> <-0.003, -16.885, -38.508> <-0.003, -16.925, -38.479> <-0.003, -16.924, -38.450> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.782, -16.108, -38.595> <-0.782, -15.684, -38.623> <-0.428, -15.331, -38.643> <-0.003, -15.331, -38.639> 
		<-0.784, -16.106, -38.567> <-0.784, -15.682, -38.595> <-0.428, -15.327, -38.615> <-0.003, -15.327, -38.611> 
		<-0.826, -16.105, -38.540> <-0.826, -15.656, -38.570> <-0.453, -15.283, -38.591> <-0.003, -15.283, -38.587> 
		<-0.827, -16.103, -38.512> <-0.827, -15.654, -38.541> <-0.453, -15.281, -38.563> <-0.003, -15.280, -38.559> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.003, -15.331, -38.639> <0.422, -15.331, -38.635> <0.775, -15.683, -38.609> <0.775, -16.107, -38.581> 
		<-0.003, -15.327, -38.611> <0.422, -15.327, -38.607> <0.777, -15.681, -38.580> <0.777, -16.105, -38.552> 
		<-0.003, -15.283, -38.587> <0.446, -15.283, -38.583> <0.820, -15.655, -38.555> <0.820, -16.104, -38.526> 
		<-0.003, -15.280, -38.559> <0.446, -15.280, -38.555> <0.821, -15.653, -38.527> <0.821, -16.102, -38.497> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.775, -16.107, -38.581> <0.775, -16.531, -38.553> <0.422, -16.884, -38.533> <-0.003, -16.885, -38.536> 
		<0.777, -16.105, -38.552> <0.777, -16.529, -38.524> <0.422, -16.885, -38.504> <-0.003, -16.885, -38.508> 
		<0.820, -16.104, -38.526> <0.820, -16.552, -38.496> <0.446, -16.925, -38.475> <-0.003, -16.925, -38.479> 
		<0.821, -16.102, -38.497> <0.821, -16.550, -38.467> <0.446, -16.924, -38.446> <-0.003, -16.924, -38.450> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.676, -16.101, -38.480> <-7.676, -16.548, -38.450> <-8.049, -16.920, -38.426> <-8.497, -16.920, -38.427> 
		<-7.673, -16.085, -38.243> <-7.673, -16.532, -38.214> <-8.049, -16.907, -38.190> <-8.497, -16.907, -38.190> 
		<-7.675, -16.064, -37.926> <-7.675, -16.493, -37.898> <-8.067, -16.884, -37.873> <-8.497, -16.884, -37.874> 
		<-7.709, -16.049, -37.692> <-7.709, -16.478, -37.664> <-8.067, -16.835, -37.641> <-8.497, -16.835, -37.642> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.676, -16.101, -38.480> <-7.673, -16.085, -38.243> <-7.675, -16.064, -37.926> <-7.709, -16.049, -37.692> 
		<-7.676, -15.653, -38.509> <-7.673, -15.638, -38.273> <-7.675, -15.635, -37.955> <-7.709, -15.619, -37.721> 
		<-8.049, -15.281, -38.535> <-8.049, -15.263, -38.298> <-8.067, -15.245, -37.981> <-8.067, -15.262, -37.745> 
		<-8.497, -15.281, -38.535> <-8.497, -15.263, -38.299> <-8.497, -15.245, -37.982> <-8.497, -15.262, -37.746> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.497, -15.281, -38.535> <-8.497, -15.263, -38.299> <-8.497, -15.245, -37.982> <-8.497, -15.262, -37.746> 
		<-8.945, -15.281, -38.536> <-8.945, -15.263, -38.300> <-8.927, -15.245, -37.983> <-8.927, -15.262, -37.747> 
		<-9.318, -15.654, -38.512> <-9.321, -15.638, -38.276> <-9.318, -15.635, -37.958> <-9.285, -15.620, -37.724> 
		<-9.318, -16.101, -38.483> <-9.321, -16.085, -38.246> <-9.318, -16.064, -37.929> <-9.285, -16.049, -37.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.318, -16.101, -38.483> <-9.321, -16.085, -38.246> <-9.318, -16.064, -37.929> <-9.285, -16.049, -37.695> 
		<-9.318, -16.548, -38.453> <-9.321, -16.532, -38.217> <-9.318, -16.493, -37.901> <-9.285, -16.478, -37.667> 
		<-8.945, -16.920, -38.428> <-8.945, -16.907, -38.191> <-8.927, -16.884, -37.874> <-8.927, -16.835, -37.643> 
		<-8.497, -16.920, -38.427> <-8.497, -16.907, -38.190> <-8.497, -16.884, -37.874> <-8.497, -16.835, -37.642> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.827, -16.103, -38.512> <-0.835, -16.087, -38.280> <-0.838, -16.067, -37.969> <-0.810, -16.052, -37.738> 
		<-0.827, -16.551, -38.482> <-0.835, -16.536, -38.250> <-0.838, -16.506, -37.940> <-0.810, -16.491, -37.709> 
		<-0.453, -16.924, -38.454> <-0.453, -16.917, -38.222> <-0.444, -16.900, -37.910> <-0.444, -16.856, -37.682> 
		<-0.003, -16.924, -38.450> <-0.003, -16.916, -38.218> <-0.003, -16.900, -37.906> <-0.003, -16.856, -37.678> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.827, -16.103, -38.512> <-0.827, -15.654, -38.541> <-0.453, -15.281, -38.563> <-0.003, -15.280, -38.559> 
		<-0.835, -16.087, -38.280> <-0.835, -15.639, -38.309> <-0.453, -15.258, -38.331> <-0.003, -15.257, -38.327> 
		<-0.838, -16.067, -37.969> <-0.838, -15.627, -37.998> <-0.444, -15.233, -38.020> <-0.003, -15.233, -38.017> 
		<-0.810, -16.052, -37.738> <-0.810, -15.612, -37.767> <-0.444, -15.246, -37.788> <-0.003, -15.246, -37.785> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.003, -15.280, -38.559> <0.446, -15.280, -38.555> <0.821, -15.653, -38.527> <0.821, -16.102, -38.497> 
		<-0.003, -15.257, -38.327> <0.446, -15.257, -38.323> <0.828, -15.638, -38.295> <0.828, -16.086, -38.265> 
		<-0.003, -15.233, -38.017> <0.437, -15.233, -38.013> <0.832, -15.626, -37.983> <0.832, -16.066, -37.954> 
		<-0.003, -15.246, -37.785> <0.437, -15.246, -37.781> <0.804, -15.611, -37.753> <0.804, -16.051, -37.724> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.821, -16.102, -38.497> <0.821, -16.550, -38.467> <0.446, -16.924, -38.446> <-0.003, -16.924, -38.450> 
		<0.828, -16.086, -38.265> <0.828, -16.535, -38.236> <0.446, -16.916, -38.214> <-0.003, -16.916, -38.218> 
		<0.832, -16.066, -37.954> <0.832, -16.505, -37.925> <0.437, -16.899, -37.903> <-0.003, -16.900, -37.906> 
		<0.804, -16.051, -37.724> <0.804, -16.490, -37.695> <0.437, -16.856, -37.674> <-0.003, -16.856, -37.678> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.788, -16.049, -37.693> <-7.764, -16.049, -37.693> <-7.712, -16.047, -37.669> <-7.709, -16.049, -37.692> 
		<-7.788, -16.435, -37.667> <-7.764, -16.435, -37.667> <-7.712, -16.476, -37.641> <-7.709, -16.478, -37.664> 
		<-8.110, -16.756, -37.646> <-8.110, -16.780, -37.645> <-8.067, -16.830, -37.618> <-8.067, -16.835, -37.641> 
		<-8.497, -16.756, -37.647> <-8.497, -16.780, -37.645> <-8.497, -16.830, -37.619> <-8.497, -16.835, -37.642> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.788, -16.049, -37.693> <-7.788, -15.662, -37.718> <-8.110, -15.341, -37.740> <-8.497, -15.341, -37.741> 
		<-7.764, -16.049, -37.693> <-7.764, -15.662, -37.718> <-8.110, -15.317, -37.741> <-8.497, -15.317, -37.742> 
		<-7.712, -16.047, -37.669> <-7.712, -15.618, -37.697> <-8.067, -15.264, -37.721> <-8.497, -15.264, -37.722> 
		<-7.709, -16.049, -37.692> <-7.709, -15.619, -37.721> <-8.067, -15.262, -37.745> <-8.497, -15.262, -37.746> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.497, -15.341, -37.741> <-8.884, -15.341, -37.741> <-9.206, -15.662, -37.721> <-9.206, -16.049, -37.695> 
		<-8.497, -15.317, -37.742> <-8.884, -15.317, -37.743> <-9.230, -15.662, -37.721> <-9.230, -16.049, -37.695> 
		<-8.497, -15.264, -37.722> <-8.927, -15.264, -37.723> <-9.282, -15.618, -37.700> <-9.282, -16.047, -37.672> 
		<-8.497, -15.262, -37.746> <-8.927, -15.262, -37.747> <-9.285, -15.620, -37.724> <-9.285, -16.049, -37.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.206, -16.049, -37.695> <-9.206, -16.435, -37.670> <-8.884, -16.756, -37.648> <-8.497, -16.756, -37.647> 
		<-9.230, -16.049, -37.695> <-9.230, -16.435, -37.670> <-8.884, -16.780, -37.646> <-8.497, -16.780, -37.645> 
		<-9.282, -16.047, -37.672> <-9.282, -16.476, -37.643> <-8.927, -16.830, -37.619> <-8.497, -16.830, -37.619> 
		<-9.285, -16.049, -37.695> <-9.285, -16.478, -37.667> <-8.927, -16.835, -37.643> <-8.497, -16.835, -37.642> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.732, -16.052, -37.738> <-0.732, -16.448, -37.711> <-0.401, -16.778, -37.687> <-0.003, -16.778, -37.683> 
		<-0.755, -16.052, -37.738> <-0.755, -16.448, -37.712> <-0.401, -16.802, -37.685> <-0.003, -16.801, -37.682> 
		<-0.807, -16.050, -37.715> <-0.807, -16.489, -37.686> <-0.444, -16.852, -37.659> <-0.003, -16.852, -37.655> 
		<-0.810, -16.052, -37.738> <-0.810, -16.491, -37.709> <-0.444, -16.856, -37.682> <-0.003, -16.856, -37.678> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.732, -16.052, -37.738> <-0.755, -16.052, -37.738> <-0.807, -16.050, -37.715> <-0.810, -16.052, -37.738> 
		<-0.732, -15.655, -37.764> <-0.755, -15.655, -37.764> <-0.807, -15.611, -37.744> <-0.810, -15.612, -37.767> 
		<-0.401, -15.325, -37.783> <-0.401, -15.301, -37.784> <-0.444, -15.248, -37.765> <-0.444, -15.246, -37.788> 
		<-0.003, -15.324, -37.779> <-0.003, -15.301, -37.781> <-0.003, -15.247, -37.761> <-0.003, -15.246, -37.785> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.003, -15.324, -37.779> <-0.003, -15.301, -37.781> <-0.003, -15.247, -37.761> <-0.003, -15.246, -37.785> 
		<0.394, -15.324, -37.776> <0.394, -15.301, -37.777> <0.437, -15.247, -37.757> <0.437, -15.246, -37.781> 
		<0.725, -15.654, -37.751> <0.749, -15.654, -37.751> <0.801, -15.610, -37.730> <0.804, -15.611, -37.753> 
		<0.725, -16.051, -37.725> <0.749, -16.051, -37.725> <0.801, -16.049, -37.701> <0.804, -16.051, -37.724> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, -16.051, -37.725> <0.749, -16.051, -37.725> <0.801, -16.049, -37.701> <0.804, -16.051, -37.724> 
		<0.725, -16.447, -37.699> <0.749, -16.447, -37.698> <0.801, -16.489, -37.672> <0.804, -16.490, -37.695> 
		<0.394, -16.778, -37.680> <0.394, -16.801, -37.678> <0.437, -16.852, -37.651> <0.437, -16.856, -37.674> 
		<-0.003, -16.778, -37.683> <-0.003, -16.801, -37.682> <-0.003, -16.852, -37.655> <-0.003, -16.856, -37.678> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.116, -14.722, -38.079> <-7.117, -14.721, -38.381> <-7.107, -14.712, -38.783> <-7.109, -14.701, -39.084> 
		<-7.116, -14.684, -38.082> <-7.117, -14.683, -38.383> <-7.107, -14.655, -38.787> <-7.109, -14.644, -39.088> 
		<-7.110, -14.601, -38.088> <-7.111, -14.596, -38.162> <-7.107, -14.532, -39.022> <-7.108, -14.522, -39.096> 
		<-7.102, -14.595, -38.088> <-7.103, -14.591, -38.163> <-7.099, -14.521, -39.023> <-7.099, -14.511, -39.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.116, -14.722, -38.079> <-7.116, -14.684, -38.082> <-7.110, -14.601, -38.088> <-7.102, -14.595, -38.088> 
		<-7.113, -14.724, -37.628> <-7.113, -14.686, -37.631> <-7.109, -14.607, -37.976> <-7.102, -14.602, -37.977> 
		<-7.115, -14.716, -37.027> <-7.115, -14.699, -37.028> <-7.116, -14.645, -37.032> <-7.099, -14.641, -37.033> 
		<-7.094, -14.710, -36.576> <-7.094, -14.693, -36.577> <-7.095, -14.660, -36.580> <-7.079, -14.656, -36.581> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.116, -14.722, -38.079> <-7.116, -14.760, -38.077> <-7.110, -14.843, -38.072> <-7.102, -14.849, -38.072> 
		<-7.117, -14.721, -38.381> <-7.117, -14.759, -38.378> <-7.111, -14.847, -38.146> <-7.103, -14.852, -38.146> 
		<-7.107, -14.712, -38.783> <-7.107, -14.769, -38.779> <-7.107, -14.875, -38.998> <-7.099, -14.886, -38.998> 
		<-7.109, -14.701, -39.084> <-7.109, -14.758, -39.080> <-7.108, -14.879, -39.072> <-7.099, -14.890, -39.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.116, -14.722, -38.079> <-7.113, -14.724, -37.628> <-7.115, -14.716, -37.027> <-7.094, -14.710, -36.576> 
		<-7.116, -14.760, -38.077> <-7.113, -14.762, -37.626> <-7.115, -14.733, -37.026> <-7.094, -14.727, -36.575> 
		<-7.110, -14.843, -38.072> <-7.109, -14.838, -37.960> <-7.116, -14.786, -37.022> <-7.095, -14.760, -36.573> 
		<-7.102, -14.849, -38.072> <-7.102, -14.843, -37.960> <-7.099, -14.790, -37.022> <-7.079, -14.765, -36.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.102, -14.849, -38.072> <-7.090, -14.858, -38.071> <-6.957, -14.866, -38.077> <-6.895, -14.874, -38.079> 
		<-7.103, -14.852, -38.146> <-7.090, -14.861, -38.146> <-6.970, -14.883, -38.376> <-6.908, -14.890, -38.378> 
		<-7.099, -14.886, -38.998> <-7.091, -14.896, -38.998> <-6.974, -14.900, -38.776> <-6.926, -14.912, -38.777> 
		<-7.099, -14.890, -39.072> <-7.092, -14.900, -39.072> <-6.987, -14.917, -39.075> <-6.939, -14.928, -39.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.102, -14.849, -38.072> <-7.102, -14.843, -37.960> <-7.099, -14.790, -37.022> <-7.079, -14.765, -36.573> 
		<-7.090, -14.858, -38.071> <-7.089, -14.852, -37.960> <-7.026, -14.808, -37.024> <-7.006, -14.782, -36.575> 
		<-6.957, -14.866, -38.077> <-6.937, -14.837, -37.628> <-6.924, -14.802, -37.029> <-6.904, -14.772, -36.581> 
		<-6.895, -14.874, -38.079> <-6.875, -14.845, -37.630> <-6.849, -14.805, -37.032> <-6.829, -14.776, -36.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.895, -14.874, -38.079> <-6.833, -14.867, -38.082> <-6.700, -14.859, -38.089> <-6.687, -14.850, -38.090> 
		<-6.908, -14.890, -38.378> <-6.846, -14.883, -38.382> <-6.706, -14.862, -38.162> <-6.693, -14.854, -38.164> 
		<-6.926, -14.912, -38.777> <-6.878, -14.901, -38.780> <-6.780, -14.897, -39.011> <-6.773, -14.887, -39.012> 
		<-6.939, -14.928, -39.077> <-6.891, -14.917, -39.079> <-6.786, -14.901, -39.085> <-6.779, -14.891, -39.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.895, -14.874, -38.079> <-6.875, -14.845, -37.630> <-6.849, -14.805, -37.032> <-6.829, -14.776, -36.584> 
		<-6.833, -14.867, -38.082> <-6.813, -14.837, -37.634> <-6.774, -14.802, -37.036> <-6.754, -14.773, -36.587> 
		<-6.700, -14.859, -38.089> <-6.691, -14.853, -37.978> <-6.671, -14.809, -37.040> <-6.652, -14.784, -36.591> 
		<-6.687, -14.850, -38.090> <-6.678, -14.844, -37.979> <-6.598, -14.792, -37.044> <-6.579, -14.766, -36.595> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.687, -14.850, -38.090> <-6.680, -14.845, -38.090> <-6.674, -14.761, -38.096> <-6.674, -14.723, -38.099> 
		<-6.693, -14.854, -38.164> <-6.685, -14.848, -38.164> <-6.699, -14.760, -38.397> <-6.699, -14.722, -38.399> 
		<-6.773, -14.887, -39.012> <-6.764, -14.876, -39.013> <-6.744, -14.770, -38.795> <-6.744, -14.713, -38.799> 
		<-6.779, -14.891, -39.086> <-6.770, -14.880, -39.087> <-6.768, -14.759, -39.095> <-6.768, -14.702, -39.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.687, -14.850, -38.090> <-6.678, -14.844, -37.979> <-6.598, -14.792, -37.044> <-6.579, -14.766, -36.595> 
		<-6.680, -14.845, -38.090> <-6.671, -14.839, -37.980> <-6.582, -14.788, -37.045> <-6.563, -14.762, -36.596> 
		<-6.674, -14.761, -38.096> <-6.637, -14.763, -37.647> <-6.582, -14.734, -37.049> <-6.563, -14.729, -36.598> 
		<-6.674, -14.723, -38.099> <-6.637, -14.725, -37.649> <-6.582, -14.717, -37.050> <-6.563, -14.712, -36.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.674, -14.723, -38.099> <-6.674, -14.685, -38.101> <-6.680, -14.602, -38.106> <-6.687, -14.597, -38.106> 
		<-6.699, -14.722, -38.399> <-6.699, -14.684, -38.402> <-6.686, -14.598, -38.181> <-6.693, -14.592, -38.181> 
		<-6.744, -14.713, -38.799> <-6.744, -14.656, -38.803> <-6.764, -14.533, -39.037> <-6.773, -14.522, -39.037> 
		<-6.768, -14.702, -39.099> <-6.768, -14.645, -39.103> <-6.770, -14.523, -39.111> <-6.779, -14.512, -39.111> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.674, -14.723, -38.099> <-6.637, -14.725, -37.649> <-6.582, -14.717, -37.050> <-6.563, -14.712, -36.600> 
		<-6.674, -14.685, -38.101> <-6.637, -14.687, -37.652> <-6.582, -14.700, -37.051> <-6.563, -14.695, -36.601> 
		<-6.680, -14.602, -38.106> <-6.671, -14.608, -37.995> <-6.582, -14.647, -37.055> <-6.563, -14.662, -36.603> 
		<-6.687, -14.597, -38.106> <-6.679, -14.603, -37.995> <-6.598, -14.643, -37.055> <-6.579, -14.658, -36.602> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.687, -14.597, -38.106> <-6.700, -14.588, -38.107> <-6.833, -14.579, -38.101> <-6.895, -14.571, -38.099> 
		<-6.693, -14.592, -38.181> <-6.706, -14.583, -38.181> <-6.846, -14.550, -38.404> <-6.908, -14.542, -38.401> 
		<-6.773, -14.522, -39.037> <-6.780, -14.512, -39.037> <-6.878, -14.515, -38.806> <-6.926, -14.503, -38.804> 
		<-6.779, -14.512, -39.111> <-6.786, -14.502, -39.112> <-6.891, -14.486, -39.108> <-6.939, -14.474, -39.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.687, -14.597, -38.106> <-6.679, -14.603, -37.995> <-6.598, -14.643, -37.055> <-6.579, -14.658, -36.602> 
		<-6.700, -14.588, -38.107> <-6.691, -14.594, -37.995> <-6.671, -14.625, -37.053> <-6.652, -14.640, -36.600> 
		<-6.833, -14.579, -38.101> <-6.813, -14.601, -37.649> <-6.774, -14.631, -37.048> <-6.754, -14.650, -36.595> 
		<-6.895, -14.571, -38.099> <-6.875, -14.594, -37.647> <-6.849, -14.627, -37.044> <-6.829, -14.646, -36.592> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.895, -14.571, -38.099> <-6.957, -14.578, -38.096> <-7.090, -14.587, -38.089> <-7.102, -14.595, -38.088> 
		<-6.908, -14.542, -38.401> <-6.970, -14.549, -38.398> <-7.090, -14.582, -38.164> <-7.103, -14.591, -38.163> 
		<-6.926, -14.503, -38.804> <-6.974, -14.514, -38.801> <-7.091, -14.511, -39.024> <-7.099, -14.521, -39.023> 
		<-6.939, -14.474, -39.107> <-6.987, -14.485, -39.104> <-7.092, -14.501, -39.098> <-7.099, -14.511, -39.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.895, -14.571, -38.099> <-6.875, -14.594, -37.647> <-6.849, -14.627, -37.044> <-6.829, -14.646, -36.592> 
		<-6.957, -14.578, -38.096> <-6.937, -14.601, -37.644> <-6.924, -14.630, -37.041> <-6.904, -14.649, -36.589> 
		<-7.090, -14.587, -38.089> <-7.089, -14.593, -37.978> <-7.026, -14.624, -37.037> <-7.006, -14.639, -36.585> 
		<-7.102, -14.595, -38.088> <-7.102, -14.602, -37.977> <-7.099, -14.641, -37.033> <-7.079, -14.656, -36.581> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.109, -14.701, -39.084> <-7.110, -14.695, -39.236> <-7.113, -14.671, -39.437> <-7.126, -14.664, -39.587> 
		<-7.109, -14.644, -39.088> <-7.110, -14.638, -39.239> <-7.113, -14.591, -39.442> <-7.126, -14.583, -39.593> 
		<-7.108, -14.522, -39.096> <-7.108, -14.517, -39.134> <-7.122, -14.420, -39.566> <-7.126, -14.412, -39.604> 
		<-7.099, -14.511, -39.097> <-7.100, -14.506, -39.135> <-7.113, -14.402, -39.568> <-7.116, -14.395, -39.606> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.109, -14.701, -39.084> <-7.109, -14.758, -39.080> <-7.108, -14.879, -39.072> <-7.099, -14.890, -39.072> 
		<-7.110, -14.695, -39.236> <-7.110, -14.752, -39.232> <-7.108, -14.881, -39.109> <-7.100, -14.892, -39.109> 
		<-7.113, -14.671, -39.437> <-7.113, -14.752, -39.431> <-7.122, -14.911, -39.534> <-7.113, -14.929, -39.533> 
		<-7.126, -14.664, -39.587> <-7.126, -14.744, -39.582> <-7.126, -14.915, -39.571> <-7.116, -14.933, -39.570> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.099, -14.890, -39.072> <-7.092, -14.900, -39.072> <-6.987, -14.917, -39.075> <-6.939, -14.928, -39.077> 
		<-7.100, -14.892, -39.109> <-7.092, -14.902, -39.109> <-6.994, -14.925, -39.225> <-6.946, -14.936, -39.226> 
		<-7.113, -14.929, -39.533> <-7.107, -14.939, -39.533> <-6.992, -14.947, -39.424> <-6.945, -14.947, -39.427> 
		<-7.116, -14.933, -39.570> <-7.111, -14.943, -39.570> <-7.008, -14.956, -39.573> <-6.961, -14.956, -39.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.939, -14.928, -39.077> <-6.891, -14.917, -39.079> <-6.786, -14.901, -39.085> <-6.779, -14.891, -39.086> 
		<-6.946, -14.936, -39.226> <-6.897, -14.925, -39.229> <-6.789, -14.903, -39.122> <-6.781, -14.893, -39.123> 
		<-6.945, -14.947, -39.427> <-6.898, -14.947, -39.429> <-6.807, -14.940, -39.546> <-6.801, -14.930, -39.547> 
		<-6.961, -14.956, -39.575> <-6.914, -14.956, -39.577> <-6.811, -14.944, -39.583> <-6.805, -14.934, -39.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.779, -14.891, -39.086> <-6.770, -14.880, -39.087> <-6.768, -14.759, -39.095> <-6.768, -14.702, -39.099> 
		<-6.781, -14.893, -39.123> <-6.773, -14.882, -39.124> <-6.781, -14.753, -39.246> <-6.781, -14.696, -39.250> 
		<-6.801, -14.930, -39.547> <-6.791, -14.913, -39.549> <-6.777, -14.751, -39.446> <-6.777, -14.670, -39.452> 
		<-6.805, -14.934, -39.584> <-6.796, -14.916, -39.585> <-6.796, -14.745, -39.597> <-6.796, -14.665, -39.602> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.768, -14.702, -39.099> <-6.768, -14.645, -39.103> <-6.770, -14.523, -39.111> <-6.779, -14.512, -39.111> 
		<-6.781, -14.696, -39.250> <-6.781, -14.639, -39.254> <-6.773, -14.518, -39.149> <-6.781, -14.507, -39.149> 
		<-6.777, -14.670, -39.452> <-6.777, -14.590, -39.457> <-6.791, -14.420, -39.581> <-6.801, -14.402, -39.581> 
		<-6.796, -14.665, -39.602> <-6.796, -14.584, -39.607> <-6.796, -14.413, -39.619> <-6.805, -14.395, -39.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.779, -14.512, -39.111> <-6.786, -14.502, -39.112> <-6.891, -14.486, -39.108> <-6.939, -14.474, -39.107> 
		<-6.781, -14.507, -39.149> <-6.789, -14.497, -39.150> <-6.897, -14.455, -39.260> <-6.946, -14.444, -39.259> 
		<-6.801, -14.402, -39.581> <-6.807, -14.392, -39.582> <-6.898, -14.405, -39.465> <-6.945, -14.405, -39.463> 
		<-6.805, -14.395, -39.619> <-6.811, -14.385, -39.620> <-6.914, -14.373, -39.616> <-6.961, -14.372, -39.614> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.939, -14.474, -39.107> <-6.987, -14.485, -39.104> <-7.092, -14.501, -39.098> <-7.099, -14.511, -39.097> 
		<-6.946, -14.444, -39.259> <-6.994, -14.455, -39.256> <-7.092, -14.496, -39.136> <-7.100, -14.506, -39.135> 
		<-6.945, -14.405, -39.463> <-6.992, -14.405, -39.461> <-7.107, -14.392, -39.569> <-7.113, -14.402, -39.568> 
		<-6.961, -14.372, -39.614> <-7.008, -14.372, -39.612> <-7.111, -14.384, -39.607> <-7.116, -14.395, -39.606> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.126, -14.664, -39.587> <-7.133, -14.660, -39.660> <-7.143, -14.665, -39.759> <-7.175, -14.663, -39.824> 
		<-7.126, -14.583, -39.593> <-7.133, -14.579, -39.665> <-7.143, -14.573, -39.765> <-7.175, -14.570, -39.830> 
		<-7.126, -14.412, -39.604> <-7.128, -14.408, -39.622> <-7.150, -14.386, -39.775> <-7.184, -14.375, -39.840> 
		<-7.116, -14.395, -39.606> <-7.118, -14.391, -39.624> <-7.141, -14.365, -39.779> <-7.175, -14.354, -39.845> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.126, -14.664, -39.587> <-7.126, -14.744, -39.582> <-7.126, -14.915, -39.571> <-7.116, -14.933, -39.570> 
		<-7.133, -14.660, -39.660> <-7.133, -14.741, -39.654> <-7.128, -14.917, -39.589> <-7.118, -14.935, -39.588> 
		<-7.143, -14.665, -39.759> <-7.143, -14.758, -39.753> <-7.151, -14.945, -39.737> <-7.141, -14.965, -39.739> 
		<-7.175, -14.663, -39.824> <-7.175, -14.756, -39.818> <-7.185, -14.951, -39.802> <-7.175, -14.972, -39.804> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.116, -14.933, -39.570> <-7.111, -14.943, -39.570> <-7.008, -14.956, -39.573> <-6.961, -14.956, -39.575> 
		<-7.118, -14.935, -39.588> <-7.113, -14.945, -39.588> <-7.017, -14.961, -39.659> <-6.970, -14.961, -39.661> 
		<-7.141, -14.965, -39.739> <-7.136, -14.976, -39.740> <-7.029, -14.971, -39.764> <-6.984, -14.972, -39.779> 
		<-7.175, -14.972, -39.804> <-7.170, -14.983, -39.805> <-7.069, -14.974, -39.840> <-7.023, -14.975, -39.856> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.961, -14.956, -39.575> <-6.914, -14.956, -39.577> <-6.811, -14.944, -39.583> <-6.805, -14.934, -39.584> 
		<-6.970, -14.961, -39.661> <-6.923, -14.961, -39.663> <-6.814, -14.946, -39.607> <-6.808, -14.936, -39.608> 
		<-6.984, -14.972, -39.779> <-6.938, -14.973, -39.795> <-6.831, -14.982, -39.817> <-6.825, -14.971, -39.819> 
		<-7.023, -14.975, -39.856> <-6.978, -14.976, -39.871> <-6.876, -14.989, -39.905> <-6.871, -14.979, -39.908> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.805, -14.934, -39.584> <-6.796, -14.916, -39.585> <-6.796, -14.745, -39.597> <-6.796, -14.665, -39.602> 
		<-6.808, -14.936, -39.608> <-6.798, -14.919, -39.610> <-6.808, -14.742, -39.696> <-6.808, -14.661, -39.702> 
		<-6.825, -14.971, -39.819> <-6.815, -14.951, -39.824> <-6.824, -14.762, -39.833> <-6.824, -14.669, -39.839> 
		<-6.871, -14.979, -39.908> <-6.861, -14.959, -39.913> <-6.871, -14.763, -39.922> <-6.871, -14.670, -39.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.796, -14.665, -39.602> <-6.796, -14.584, -39.607> <-6.796, -14.413, -39.619> <-6.805, -14.395, -39.619> 
		<-6.808, -14.661, -39.702> <-6.808, -14.580, -39.707> <-6.798, -14.408, -39.643> <-6.808, -14.391, -39.644> 
		<-6.824, -14.669, -39.839> <-6.824, -14.577, -39.846> <-6.816, -14.388, -39.860> <-6.825, -14.367, -39.859> 
		<-6.871, -14.670, -39.928> <-6.871, -14.577, -39.934> <-6.863, -14.382, -39.950> <-6.871, -14.361, -39.949> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.805, -14.395, -39.619> <-6.811, -14.385, -39.620> <-6.914, -14.373, -39.616> <-6.961, -14.372, -39.614> 
		<-6.808, -14.391, -39.644> <-6.814, -14.381, -39.644> <-6.923, -14.354, -39.704> <-6.970, -14.353, -39.702> 
		<-6.825, -14.367, -39.859> <-6.830, -14.356, -39.858> <-6.935, -14.318, -39.837> <-6.983, -14.317, -39.821> 
		<-6.871, -14.361, -39.949> <-6.876, -14.350, -39.948> <-6.975, -14.305, -39.917> <-7.023, -14.304, -39.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.961, -14.372, -39.614> <-7.008, -14.372, -39.612> <-7.111, -14.384, -39.607> <-7.116, -14.395, -39.606> 
		<-6.970, -14.353, -39.702> <-7.017, -14.353, -39.700> <-7.113, -14.381, -39.625> <-7.118, -14.391, -39.624> 
		<-6.983, -14.317, -39.821> <-7.031, -14.316, -39.804> <-7.137, -14.354, -39.781> <-7.141, -14.365, -39.779> 
		<-7.023, -14.304, -39.900> <-7.071, -14.303, -39.884> <-7.171, -14.343, -39.847> <-7.175, -14.354, -39.845> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.094, -14.710, -36.576> <-7.094, -14.693, -36.577> <-7.095, -14.660, -36.580> <-7.079, -14.656, -36.581> 
		<-7.093, -14.710, -36.540> <-7.093, -14.693, -36.541> <-7.093, -14.661, -36.544> <-7.077, -14.658, -36.545> 
		<-7.064, -14.705, -36.496> <-7.064, -14.688, -36.497> <-7.066, -14.656, -36.500> <-7.050, -14.651, -36.501> 
		<-7.041, -14.703, -36.467> <-7.041, -14.686, -36.468> <-7.044, -14.654, -36.471> <-7.028, -14.649, -36.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.094, -14.710, -36.576> <-7.093, -14.710, -36.540> <-7.064, -14.705, -36.496> <-7.041, -14.703, -36.467> 
		<-7.094, -14.727, -36.575> <-7.093, -14.727, -36.539> <-7.064, -14.722, -36.495> <-7.041, -14.720, -36.466> 
		<-7.095, -14.760, -36.573> <-7.093, -14.758, -36.537> <-7.066, -14.754, -36.493> <-7.044, -14.753, -36.464> 
		<-7.079, -14.765, -36.573> <-7.077, -14.762, -36.537> <-7.050, -14.759, -36.493> <-7.028, -14.757, -36.464> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.079, -14.765, -36.573> <-7.077, -14.762, -36.537> <-7.050, -14.759, -36.493> <-7.028, -14.757, -36.464> 
		<-7.006, -14.782, -36.575> <-7.004, -14.780, -36.539> <-6.991, -14.777, -36.495> <-6.970, -14.775, -36.466> 
		<-6.904, -14.772, -36.581> <-6.902, -14.770, -36.547> <-6.887, -14.767, -36.503> <-6.885, -14.765, -36.470> 
		<-6.829, -14.776, -36.584> <-6.827, -14.774, -36.550> <-6.825, -14.771, -36.506> <-6.824, -14.768, -36.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.829, -14.776, -36.584> <-6.827, -14.774, -36.550> <-6.825, -14.771, -36.506> <-6.824, -14.768, -36.473> 
		<-6.754, -14.773, -36.587> <-6.752, -14.771, -36.554> <-6.764, -14.768, -36.509> <-6.763, -14.765, -36.476> 
		<-6.652, -14.784, -36.591> <-6.650, -14.781, -36.555> <-6.660, -14.778, -36.509> <-6.678, -14.776, -36.479> 
		<-6.579, -14.766, -36.595> <-6.578, -14.764, -36.559> <-6.601, -14.761, -36.513> <-6.620, -14.759, -36.482> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.579, -14.766, -36.595> <-6.578, -14.764, -36.559> <-6.601, -14.761, -36.513> <-6.620, -14.759, -36.482> 
		<-6.563, -14.762, -36.596> <-6.561, -14.760, -36.560> <-6.585, -14.756, -36.514> <-6.603, -14.754, -36.483> 
		<-6.563, -14.729, -36.598> <-6.562, -14.728, -36.562> <-6.587, -14.723, -36.516> <-6.607, -14.721, -36.485> 
		<-6.563, -14.712, -36.600> <-6.562, -14.711, -36.563> <-6.587, -14.706, -36.517> <-6.607, -14.704, -36.486> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.563, -14.712, -36.600> <-6.562, -14.711, -36.563> <-6.587, -14.706, -36.517> <-6.607, -14.704, -36.486> 
		<-6.563, -14.695, -36.601> <-6.562, -14.695, -36.564> <-6.587, -14.690, -36.518> <-6.607, -14.688, -36.488> 
		<-6.563, -14.662, -36.603> <-6.561, -14.663, -36.567> <-6.585, -14.657, -36.521> <-6.603, -14.655, -36.490> 
		<-6.579, -14.658, -36.602> <-6.578, -14.659, -36.566> <-6.601, -14.652, -36.520> <-6.620, -14.650, -36.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.579, -14.658, -36.602> <-6.578, -14.659, -36.566> <-6.601, -14.652, -36.520> <-6.620, -14.650, -36.490> 
		<-6.652, -14.640, -36.600> <-6.650, -14.641, -36.564> <-6.660, -14.635, -36.519> <-6.678, -14.633, -36.488> 
		<-6.754, -14.650, -36.595> <-6.753, -14.651, -36.562> <-6.764, -14.645, -36.517> <-6.763, -14.642, -36.484> 
		<-6.829, -14.646, -36.592> <-6.827, -14.648, -36.559> <-6.825, -14.641, -36.515> <-6.824, -14.639, -36.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.829, -14.646, -36.592> <-6.827, -14.648, -36.559> <-6.825, -14.641, -36.515> <-6.824, -14.639, -36.481> 
		<-6.904, -14.649, -36.589> <-6.902, -14.651, -36.555> <-6.887, -14.644, -36.512> <-6.885, -14.642, -36.478> 
		<-7.006, -14.639, -36.585> <-7.004, -14.640, -36.549> <-6.991, -14.634, -36.504> <-6.970, -14.632, -36.475> 
		<-7.079, -14.656, -36.581> <-7.077, -14.658, -36.545> <-7.050, -14.651, -36.501> <-7.028, -14.649, -36.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.041, -14.703, -36.467> <-7.041, -14.686, -36.468> <-7.044, -14.654, -36.471> <-7.028, -14.649, -36.472> 
		<-7.017, -14.701, -36.437> <-7.017, -14.684, -36.438> <-7.022, -14.652, -36.440> <-7.006, -14.647, -36.441> 
		<-6.978, -14.699, -36.399> <-6.978, -14.682, -36.400> <-6.984, -14.652, -36.402> <-6.969, -14.645, -36.403> 
		<-6.943, -14.698, -36.382> <-6.943, -14.681, -36.383> <-6.950, -14.651, -36.384> <-6.936, -14.643, -36.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.041, -14.703, -36.467> <-7.017, -14.701, -36.437> <-6.978, -14.699, -36.399> <-6.943, -14.698, -36.382> 
		<-7.041, -14.720, -36.466> <-7.017, -14.718, -36.435> <-6.978, -14.715, -36.398> <-6.943, -14.714, -36.381> 
		<-7.044, -14.753, -36.464> <-7.022, -14.750, -36.433> <-6.984, -14.745, -36.396> <-6.950, -14.744, -36.378> 
		<-7.028, -14.757, -36.464> <-7.006, -14.755, -36.434> <-6.969, -14.753, -36.396> <-6.936, -14.752, -36.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.028, -14.757, -36.464> <-7.006, -14.755, -36.434> <-6.969, -14.753, -36.396> <-6.936, -14.752, -36.378> 
		<-6.970, -14.775, -36.466> <-6.947, -14.773, -36.435> <-6.938, -14.769, -36.397> <-6.905, -14.768, -36.379> 
		<-6.885, -14.765, -36.470> <-6.884, -14.763, -36.443> <-6.856, -14.761, -36.408> <-6.855, -14.759, -36.381> 
		<-6.824, -14.768, -36.473> <-6.823, -14.767, -36.446> <-6.821, -14.764, -36.410> <-6.820, -14.763, -36.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.824, -14.768, -36.473> <-6.823, -14.767, -36.446> <-6.821, -14.764, -36.410> <-6.820, -14.763, -36.383> 
		<-6.763, -14.765, -36.476> <-6.761, -14.764, -36.449> <-6.786, -14.761, -36.411> <-6.785, -14.759, -36.384> 
		<-6.678, -14.776, -36.479> <-6.698, -14.774, -36.446> <-6.703, -14.770, -36.407> <-6.735, -14.768, -36.386> 
		<-6.620, -14.759, -36.482> <-6.639, -14.756, -36.450> <-6.672, -14.754, -36.409> <-6.704, -14.752, -36.389> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.620, -14.759, -36.482> <-6.639, -14.756, -36.450> <-6.672, -14.754, -36.409> <-6.704, -14.752, -36.389> 
		<-6.603, -14.754, -36.483> <-6.623, -14.752, -36.451> <-6.658, -14.746, -36.410> <-6.690, -14.745, -36.390> 
		<-6.607, -14.721, -36.485> <-6.628, -14.719, -36.453> <-6.664, -14.716, -36.412> <-6.697, -14.715, -36.391> 
		<-6.607, -14.704, -36.486> <-6.628, -14.702, -36.454> <-6.664, -14.700, -36.413> <-6.697, -14.698, -36.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.607, -14.704, -36.486> <-6.628, -14.702, -36.454> <-6.664, -14.700, -36.413> <-6.697, -14.698, -36.392> 
		<-6.607, -14.688, -36.488> <-6.628, -14.686, -36.455> <-6.664, -14.683, -36.414> <-6.697, -14.682, -36.394> 
		<-6.603, -14.655, -36.490> <-6.623, -14.653, -36.457> <-6.658, -14.653, -36.417> <-6.690, -14.652, -36.396> 
		<-6.620, -14.650, -36.490> <-6.639, -14.648, -36.457> <-6.672, -14.645, -36.416> <-6.704, -14.644, -36.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.620, -14.650, -36.490> <-6.639, -14.648, -36.457> <-6.672, -14.645, -36.416> <-6.704, -14.644, -36.396> 
		<-6.678, -14.633, -36.488> <-6.698, -14.630, -36.456> <-6.703, -14.629, -36.416> <-6.735, -14.628, -36.395> 
		<-6.763, -14.642, -36.484> <-6.761, -14.641, -36.457> <-6.786, -14.638, -36.420> <-6.785, -14.636, -36.393> 
		<-6.824, -14.639, -36.481> <-6.823, -14.637, -36.454> <-6.821, -14.635, -36.418> <-6.820, -14.633, -36.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.824, -14.639, -36.481> <-6.823, -14.637, -36.454> <-6.821, -14.635, -36.418> <-6.820, -14.633, -36.391> 
		<-6.885, -14.642, -36.478> <-6.884, -14.640, -36.451> <-6.856, -14.638, -36.417> <-6.855, -14.636, -36.390> 
		<-6.970, -14.632, -36.475> <-6.947, -14.630, -36.445> <-6.938, -14.628, -36.406> <-6.905, -14.627, -36.388> 
		<-7.028, -14.649, -36.472> <-7.006, -14.647, -36.441> <-6.969, -14.645, -36.403> <-6.936, -14.643, -36.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.829, -14.696, -36.361> <-6.863, -14.697, -36.367> <-6.912, -14.696, -36.366> <-6.943, -14.698, -36.382> 
		<-6.829, -14.680, -36.362> <-6.863, -14.680, -36.368> <-6.912, -14.680, -36.367> <-6.943, -14.681, -36.383> 
		<-6.831, -14.658, -36.363> <-6.863, -14.658, -36.369> <-6.921, -14.650, -36.369> <-6.950, -14.651, -36.384> 
		<-6.829, -14.642, -36.364> <-6.861, -14.642, -36.371> <-6.907, -14.642, -36.370> <-6.936, -14.643, -36.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.829, -14.696, -36.361> <-6.829, -14.712, -36.360> <-6.831, -14.734, -36.358> <-6.829, -14.750, -36.357> 
		<-6.863, -14.697, -36.367> <-6.863, -14.713, -36.366> <-6.863, -14.735, -36.364> <-6.861, -14.751, -36.363> 
		<-6.912, -14.696, -36.366> <-6.912, -14.713, -36.365> <-6.921, -14.743, -36.363> <-6.907, -14.751, -36.363> 
		<-6.943, -14.698, -36.382> <-6.943, -14.714, -36.381> <-6.950, -14.744, -36.378> <-6.936, -14.752, -36.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.829, -14.750, -36.357> <-6.828, -14.754, -36.357> <-6.822, -14.758, -36.357> <-6.819, -14.761, -36.357> 
		<-6.861, -14.751, -36.363> <-6.860, -14.755, -36.363> <-6.822, -14.758, -36.365> <-6.819, -14.761, -36.365> 
		<-6.907, -14.751, -36.363> <-6.876, -14.767, -36.363> <-6.854, -14.759, -36.374> <-6.820, -14.762, -36.375> 
		<-6.936, -14.752, -36.378> <-6.905, -14.768, -36.379> <-6.855, -14.759, -36.381> <-6.820, -14.763, -36.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.819, -14.761, -36.357> <-6.816, -14.758, -36.357> <-6.810, -14.755, -36.358> <-6.809, -14.750, -36.358> 
		<-6.819, -14.761, -36.365> <-6.816, -14.758, -36.365> <-6.778, -14.755, -36.367> <-6.778, -14.751, -36.367> 
		<-6.820, -14.762, -36.375> <-6.785, -14.759, -36.377> <-6.763, -14.767, -36.368> <-6.732, -14.751, -36.371> 
		<-6.820, -14.763, -36.383> <-6.785, -14.759, -36.384> <-6.735, -14.768, -36.386> <-6.704, -14.752, -36.389> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.809, -14.750, -36.358> <-6.807, -14.734, -36.359> <-6.809, -14.712, -36.360> <-6.809, -14.696, -36.362> 
		<-6.778, -14.751, -36.367> <-6.775, -14.735, -36.368> <-6.775, -14.713, -36.370> <-6.775, -14.697, -36.371> 
		<-6.732, -14.751, -36.371> <-6.717, -14.744, -36.372> <-6.726, -14.713, -36.373> <-6.726, -14.697, -36.374> 
		<-6.704, -14.752, -36.389> <-6.690, -14.745, -36.390> <-6.697, -14.715, -36.391> <-6.697, -14.698, -36.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.809, -14.696, -36.362> <-6.809, -14.680, -36.363> <-6.807, -14.658, -36.364> <-6.809, -14.642, -36.365> 
		<-6.775, -14.697, -36.371> <-6.775, -14.681, -36.372> <-6.775, -14.659, -36.373> <-6.778, -14.643, -36.374> 
		<-6.726, -14.697, -36.374> <-6.726, -14.681, -36.375> <-6.717, -14.651, -36.378> <-6.732, -14.643, -36.378> 
		<-6.697, -14.698, -36.392> <-6.697, -14.682, -36.394> <-6.690, -14.652, -36.396> <-6.704, -14.644, -36.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.809, -14.642, -36.365> <-6.810, -14.638, -36.365> <-6.816, -14.635, -36.365> <-6.819, -14.631, -36.365> 
		<-6.778, -14.643, -36.374> <-6.778, -14.638, -36.375> <-6.816, -14.635, -36.373> <-6.819, -14.632, -36.373> 
		<-6.732, -14.643, -36.378> <-6.763, -14.627, -36.377> <-6.785, -14.636, -36.385> <-6.820, -14.633, -36.384> 
		<-6.704, -14.644, -36.396> <-6.735, -14.628, -36.395> <-6.785, -14.636, -36.393> <-6.820, -14.633, -36.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.819, -14.631, -36.365> <-6.822, -14.635, -36.365> <-6.828, -14.638, -36.365> <-6.829, -14.642, -36.364> 
		<-6.819, -14.632, -36.373> <-6.822, -14.635, -36.373> <-6.860, -14.638, -36.371> <-6.861, -14.642, -36.371> 
		<-6.820, -14.633, -36.384> <-6.854, -14.636, -36.382> <-6.876, -14.626, -36.372> <-6.907, -14.642, -36.370> 
		<-6.820, -14.633, -36.391> <-6.855, -14.636, -36.390> <-6.905, -14.627, -36.388> <-6.936, -14.643, -36.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.175, -14.663, -39.824> <-7.195, -14.662, -39.865> <-7.252, -14.652, -39.897> <-7.290, -14.652, -39.922> 
		<-7.175, -14.570, -39.830> <-7.195, -14.569, -39.871> <-7.252, -14.558, -39.903> <-7.290, -14.558, -39.928> 
		<-7.184, -14.375, -39.840> <-7.205, -14.368, -39.880> <-7.258, -14.361, -39.908> <-7.296, -14.359, -39.933> 
		<-7.175, -14.354, -39.845> <-7.196, -14.348, -39.885> <-7.252, -14.340, -39.917> <-7.290, -14.338, -39.942> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.175, -14.663, -39.824> <-7.175, -14.756, -39.818> <-7.185, -14.951, -39.802> <-7.175, -14.972, -39.804> 
		<-7.195, -14.662, -39.865> <-7.195, -14.754, -39.859> <-7.206, -14.955, -39.842> <-7.196, -14.976, -39.844> 
		<-7.252, -14.652, -39.897> <-7.252, -14.746, -39.890> <-7.259, -14.943, -39.869> <-7.253, -14.964, -39.876> 
		<-7.290, -14.652, -39.922> <-7.290, -14.746, -39.915> <-7.296, -14.945, -39.894> <-7.290, -14.966, -39.901> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.175, -14.972, -39.804> <-7.170, -14.983, -39.805> <-7.069, -14.974, -39.840> <-7.023, -14.975, -39.856> 
		<-7.196, -14.976, -39.844> <-7.191, -14.987, -39.845> <-7.103, -14.977, -39.906> <-7.058, -14.978, -39.922> 
		<-7.253, -14.964, -39.876> <-7.249, -14.975, -39.880> <-7.165, -14.969, -39.950> <-7.137, -14.972, -39.989> 
		<-7.290, -14.966, -39.901> <-7.287, -14.977, -39.905> <-7.226, -14.972, -39.993> <-7.198, -14.975, -40.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.023, -14.975, -39.856> <-6.978, -14.976, -39.871> <-6.876, -14.989, -39.905> <-6.871, -14.979, -39.908> 
		<-7.058, -14.978, -39.922> <-7.012, -14.979, -39.937> <-6.924, -14.997, -39.997> <-6.919, -14.987, -40.000> 
		<-7.137, -14.972, -39.989> <-7.109, -14.975, -40.028> <-7.025, -14.990, -40.096> <-7.022, -14.980, -40.101> 
		<-7.198, -14.975, -40.032> <-7.170, -14.977, -40.071> <-7.108, -14.993, -40.158> <-7.105, -14.983, -40.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.871, -14.979, -39.908> <-6.861, -14.959, -39.913> <-6.871, -14.763, -39.922> <-6.871, -14.670, -39.928> 
		<-6.919, -14.987, -40.000> <-6.909, -14.967, -40.005> <-6.920, -14.763, -40.014> <-6.920, -14.671, -40.020> 
		<-7.022, -14.980, -40.101> <-7.016, -14.959, -40.111> <-7.022, -14.763, -40.115> <-7.022, -14.669, -40.121> 
		<-7.105, -14.983, -40.163> <-7.099, -14.963, -40.173> <-7.105, -14.764, -40.178> <-7.105, -14.669, -40.184> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.871, -14.670, -39.928> <-6.871, -14.577, -39.934> <-6.863, -14.382, -39.950> <-6.871, -14.361, -39.949> 
		<-6.920, -14.671, -40.020> <-6.920, -14.578, -40.026> <-6.910, -14.376, -40.043> <-6.919, -14.355, -40.041> 
		<-7.022, -14.669, -40.121> <-7.022, -14.575, -40.128> <-7.017, -14.380, -40.148> <-7.022, -14.358, -40.142> 
		<-7.105, -14.669, -40.184> <-7.105, -14.575, -40.190> <-7.100, -14.377, -40.211> <-7.105, -14.356, -40.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.871, -14.361, -39.949> <-6.876, -14.350, -39.948> <-6.975, -14.305, -39.917> <-7.023, -14.304, -39.900> 
		<-6.919, -14.355, -40.041> <-6.923, -14.343, -40.040> <-7.009, -14.293, -39.982> <-7.057, -14.292, -39.966> 
		<-7.022, -14.358, -40.142> <-7.025, -14.346, -40.139> <-7.108, -14.297, -40.075> <-7.137, -14.295, -40.034> 
		<-7.105, -14.356, -40.205> <-7.108, -14.344, -40.201> <-7.168, -14.295, -40.119> <-7.198, -14.292, -40.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.023, -14.304, -39.900> <-7.071, -14.303, -39.884> <-7.171, -14.343, -39.847> <-7.175, -14.354, -39.845> 
		<-7.057, -14.292, -39.966> <-7.105, -14.291, -39.949> <-7.191, -14.336, -39.887> <-7.196, -14.348, -39.885> 
		<-7.137, -14.295, -40.034> <-7.166, -14.292, -39.992> <-7.250, -14.329, -39.922> <-7.252, -14.340, -39.917> 
		<-7.198, -14.292, -40.077> <-7.227, -14.289, -40.036> <-7.287, -14.327, -39.947> <-7.290, -14.338, -39.942> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.290, -14.652, -39.922> <-7.462, -14.651, -40.035> <-7.693, -14.652, -40.184> <-7.872, -14.659, -40.285> 
		<-7.290, -14.558, -39.928> <-7.462, -14.557, -40.041> <-7.693, -14.551, -40.191> <-7.872, -14.557, -40.291> 
		<-7.296, -14.359, -39.933> <-7.467, -14.351, -40.047> <-7.697, -14.336, -40.197> <-7.877, -14.343, -40.297> 
		<-7.290, -14.338, -39.942> <-7.462, -14.330, -40.056> <-7.692, -14.313, -40.207> <-7.872, -14.320, -40.307> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.290, -14.652, -39.922> <-7.290, -14.746, -39.915> <-7.296, -14.945, -39.894> <-7.290, -14.966, -39.901> 
		<-7.462, -14.651, -40.035> <-7.462, -14.745, -40.029> <-7.468, -14.951, -40.007> <-7.462, -14.972, -40.014> 
		<-7.693, -14.652, -40.184> <-7.693, -14.754, -40.178> <-7.698, -14.968, -40.154> <-7.693, -14.992, -40.162> 
		<-7.872, -14.659, -40.285> <-7.872, -14.761, -40.278> <-7.877, -14.975, -40.254> <-7.872, -14.998, -40.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.290, -14.966, -39.901> <-7.287, -14.977, -39.905> <-7.226, -14.972, -39.993> <-7.198, -14.975, -40.032> 
		<-7.462, -14.972, -40.014> <-7.459, -14.983, -40.018> <-7.399, -14.979, -40.115> <-7.371, -14.982, -40.155> 
		<-7.693, -14.992, -40.162> <-7.690, -15.003, -40.166> <-7.635, -14.998, -40.258> <-7.613, -15.001, -40.301> 
		<-7.872, -14.998, -40.262> <-7.870, -15.009, -40.266> <-7.820, -15.004, -40.362> <-7.798, -15.007, -40.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.198, -14.975, -40.032> <-7.170, -14.977, -40.071> <-7.108, -14.993, -40.158> <-7.105, -14.983, -40.163> 
		<-7.371, -14.982, -40.155> <-7.343, -14.984, -40.194> <-7.283, -15.001, -40.289> <-7.280, -14.991, -40.294> 
		<-7.613, -15.001, -40.301> <-7.590, -15.004, -40.344> <-7.535, -15.020, -40.435> <-7.533, -15.010, -40.440> 
		<-7.798, -15.007, -40.404> <-7.776, -15.010, -40.447> <-7.726, -15.027, -40.541> <-7.723, -15.017, -40.547> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.105, -14.983, -40.163> <-7.099, -14.963, -40.173> <-7.105, -14.764, -40.178> <-7.105, -14.669, -40.184> 
		<-7.280, -14.991, -40.294> <-7.274, -14.971, -40.304> <-7.280, -14.765, -40.309> <-7.280, -14.671, -40.315> 
		<-7.533, -15.010, -40.440> <-7.528, -14.988, -40.451> <-7.533, -14.772, -40.456> <-7.533, -14.671, -40.462> 
		<-7.723, -15.017, -40.547> <-7.718, -14.995, -40.558> <-7.723, -14.780, -40.562> <-7.723, -14.678, -40.569> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.105, -14.669, -40.184> <-7.105, -14.575, -40.190> <-7.100, -14.377, -40.211> <-7.105, -14.356, -40.205> 
		<-7.280, -14.671, -40.315> <-7.280, -14.577, -40.321> <-7.275, -14.373, -40.342> <-7.280, -14.351, -40.336> 
		<-7.533, -14.671, -40.462> <-7.533, -14.569, -40.469> <-7.528, -14.355, -40.491> <-7.533, -14.332, -40.485> 
		<-7.723, -14.678, -40.569> <-7.723, -14.576, -40.576> <-7.719, -14.363, -40.598> <-7.723, -14.339, -40.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.105, -14.356, -40.205> <-7.108, -14.344, -40.201> <-7.168, -14.295, -40.119> <-7.198, -14.292, -40.077> 
		<-7.280, -14.351, -40.336> <-7.283, -14.339, -40.333> <-7.341, -14.287, -40.242> <-7.371, -14.285, -40.201> 
		<-7.533, -14.332, -40.485> <-7.535, -14.320, -40.481> <-7.589, -14.266, -40.395> <-7.612, -14.263, -40.350> 
		<-7.723, -14.339, -40.591> <-7.726, -14.327, -40.588> <-7.774, -14.273, -40.499> <-7.798, -14.270, -40.453> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.198, -14.292, -40.077> <-7.227, -14.289, -40.036> <-7.287, -14.327, -39.947> <-7.290, -14.338, -39.942> 
		<-7.371, -14.285, -40.201> <-7.400, -14.282, -40.159> <-7.459, -14.319, -40.061> <-7.462, -14.330, -40.056> 
		<-7.612, -14.263, -40.350> <-7.636, -14.260, -40.304> <-7.690, -14.302, -40.212> <-7.692, -14.313, -40.207> 
		<-7.798, -14.270, -40.453> <-7.822, -14.267, -40.408> <-7.870, -14.309, -40.312> <-7.872, -14.320, -40.307> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.872, -14.659, -40.285> <-8.041, -14.665, -40.379> <-8.277, -14.677, -40.483> <-8.450, -14.695, -40.568> 
		<-7.872, -14.557, -40.291> <-8.041, -14.564, -40.386> <-8.277, -14.584, -40.489> <-8.450, -14.601, -40.575> 
		<-7.877, -14.343, -40.297> <-8.046, -14.350, -40.392> <-8.282, -14.381, -40.494> <-8.454, -14.404, -40.579> 
		<-7.872, -14.320, -40.307> <-8.041, -14.327, -40.401> <-8.277, -14.360, -40.504> <-8.450, -14.384, -40.589> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.872, -14.659, -40.285> <-7.872, -14.761, -40.278> <-7.877, -14.975, -40.254> <-7.872, -14.998, -40.262> 
		<-8.041, -14.665, -40.379> <-8.041, -14.767, -40.372> <-8.046, -14.980, -40.348> <-8.041, -15.004, -40.356> 
		<-8.277, -14.677, -40.483> <-8.277, -14.771, -40.477> <-8.282, -14.975, -40.454> <-8.277, -14.996, -40.462> 
		<-8.450, -14.695, -40.568> <-8.450, -14.788, -40.562> <-8.455, -14.985, -40.540> <-8.450, -15.006, -40.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.872, -14.998, -40.262> <-7.870, -15.009, -40.266> <-7.820, -15.004, -40.362> <-7.798, -15.007, -40.404> 
		<-8.041, -15.004, -40.356> <-8.039, -15.015, -40.360> <-7.988, -15.010, -40.456> <-7.966, -15.013, -40.498> 
		<-8.277, -14.996, -40.462> <-8.274, -15.007, -40.466> <-8.224, -15.003, -40.561> <-8.201, -15.005, -40.604> 
		<-8.450, -15.006, -40.548> <-8.447, -15.017, -40.552> <-8.397, -15.012, -40.647> <-8.374, -15.015, -40.689> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.798, -15.007, -40.404> <-7.776, -15.010, -40.447> <-7.726, -15.027, -40.541> <-7.723, -15.017, -40.547> 
		<-7.966, -15.013, -40.498> <-7.944, -15.016, -40.541> <-7.894, -15.033, -40.635> <-7.891, -15.022, -40.640> 
		<-8.201, -15.005, -40.604> <-8.179, -15.008, -40.646> <-8.129, -15.025, -40.740> <-8.126, -15.015, -40.745> 
		<-8.374, -15.015, -40.689> <-8.351, -15.018, -40.732> <-8.301, -15.035, -40.825> <-8.298, -15.025, -40.830> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.723, -15.017, -40.547> <-7.718, -14.995, -40.558> <-7.723, -14.780, -40.562> <-7.723, -14.678, -40.569> 
		<-7.891, -15.022, -40.640> <-7.886, -15.000, -40.651> <-7.891, -14.786, -40.656> <-7.891, -14.684, -40.663> 
		<-8.126, -15.015, -40.745> <-8.121, -14.995, -40.756> <-8.126, -14.790, -40.760> <-8.126, -14.696, -40.766> 
		<-8.298, -15.025, -40.830> <-8.293, -15.005, -40.841> <-8.298, -14.807, -40.845> <-8.298, -14.713, -40.851> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.723, -14.678, -40.569> <-7.723, -14.576, -40.576> <-7.719, -14.363, -40.598> <-7.723, -14.339, -40.591> 
		<-7.891, -14.684, -40.663> <-7.891, -14.582, -40.669> <-7.887, -14.370, -40.692> <-7.892, -14.346, -40.685> 
		<-8.126, -14.696, -40.766> <-8.126, -14.603, -40.772> <-8.122, -14.401, -40.794> <-8.126, -14.379, -40.787> 
		<-8.298, -14.713, -40.851> <-8.298, -14.620, -40.857> <-8.294, -14.424, -40.878> <-8.298, -14.402, -40.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.723, -14.339, -40.591> <-7.726, -14.327, -40.588> <-7.774, -14.273, -40.499> <-7.798, -14.270, -40.453> 
		<-7.892, -14.346, -40.685> <-7.894, -14.334, -40.682> <-7.943, -14.280, -40.593> <-7.967, -14.277, -40.547> 
		<-8.126, -14.379, -40.787> <-8.129, -14.367, -40.783> <-8.178, -14.317, -40.694> <-8.202, -14.314, -40.649> 
		<-8.298, -14.402, -40.872> <-8.300, -14.391, -40.868> <-8.350, -14.342, -40.779> <-8.374, -14.339, -40.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.798, -14.270, -40.453> <-7.822, -14.267, -40.408> <-7.870, -14.309, -40.312> <-7.872, -14.320, -40.307> 
		<-7.967, -14.277, -40.547> <-7.990, -14.274, -40.502> <-8.039, -14.316, -40.406> <-8.041, -14.327, -40.401> 
		<-8.202, -14.314, -40.649> <-8.226, -14.311, -40.604> <-8.275, -14.349, -40.509> <-8.277, -14.360, -40.504> 
		<-8.374, -14.339, -40.734> <-8.398, -14.336, -40.689> <-8.448, -14.373, -40.594> <-8.450, -14.384, -40.589> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.450, -14.695, -40.568> <-8.514, -14.701, -40.600> <-8.599, -14.717, -40.644> <-8.661, -14.739, -40.674> 
		<-8.450, -14.601, -40.575> <-8.514, -14.608, -40.606> <-8.618, -14.626, -40.660> <-8.679, -14.648, -40.690> 
		<-8.454, -14.404, -40.579> <-8.537, -14.416, -40.620> <-8.642, -14.430, -40.675> <-8.722, -14.457, -40.714> 
		<-8.450, -14.384, -40.589> <-8.532, -14.395, -40.630> <-8.642, -14.410, -40.686> <-8.722, -14.437, -40.726> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.450, -14.695, -40.568> <-8.450, -14.788, -40.562> <-8.455, -14.985, -40.540> <-8.450, -15.006, -40.548> 
		<-8.514, -14.701, -40.600> <-8.514, -14.795, -40.594> <-8.501, -14.987, -40.563> <-8.496, -15.009, -40.571> 
		<-8.599, -14.717, -40.644> <-8.581, -14.807, -40.629> <-8.566, -15.003, -40.596> <-8.557, -15.023, -40.602> 
		<-8.661, -14.739, -40.674> <-8.643, -14.829, -40.659> <-8.610, -15.020, -40.618> <-8.601, -15.040, -40.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.450, -15.006, -40.548> <-8.447, -15.017, -40.552> <-8.397, -15.012, -40.647> <-8.374, -15.015, -40.689> 
		<-8.496, -15.009, -40.571> <-8.493, -15.019, -40.575> <-8.443, -15.015, -40.670> <-8.420, -15.018, -40.712> 
		<-8.557, -15.023, -40.602> <-8.552, -15.034, -40.605> <-8.504, -15.029, -40.701> <-8.481, -15.032, -40.743> 
		<-8.601, -15.040, -40.623> <-8.596, -15.051, -40.627> <-8.547, -15.046, -40.722> <-8.525, -15.049, -40.765> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.374, -15.015, -40.689> <-8.351, -15.018, -40.732> <-8.301, -15.035, -40.825> <-8.298, -15.025, -40.830> 
		<-8.420, -15.018, -40.712> <-8.397, -15.021, -40.754> <-8.347, -15.037, -40.848> <-8.344, -15.027, -40.853> 
		<-8.481, -15.032, -40.743> <-8.458, -15.035, -40.786> <-8.405, -15.051, -40.878> <-8.405, -15.041, -40.885> 
		<-8.525, -15.049, -40.765> <-8.502, -15.051, -40.807> <-8.449, -15.067, -40.900> <-8.449, -15.057, -40.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.298, -15.025, -40.830> <-8.293, -15.005, -40.841> <-8.298, -14.807, -40.845> <-8.298, -14.713, -40.851> 
		<-8.344, -15.027, -40.853> <-8.339, -15.007, -40.864> <-8.362, -14.813, -40.877> <-8.362, -14.720, -40.883> 
		<-8.405, -15.041, -40.885> <-8.404, -15.022, -40.897> <-8.429, -14.825, -40.912> <-8.448, -14.734, -40.927> 
		<-8.449, -15.057, -40.906> <-8.448, -15.038, -40.919> <-8.491, -14.846, -40.942> <-8.509, -14.756, -40.957> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.298, -14.713, -40.851> <-8.298, -14.620, -40.857> <-8.294, -14.424, -40.878> <-8.298, -14.402, -40.872> 
		<-8.362, -14.720, -40.883> <-8.362, -14.627, -40.889> <-8.376, -14.435, -40.919> <-8.380, -14.414, -40.912> 
		<-8.448, -14.734, -40.927> <-8.466, -14.644, -40.942> <-8.482, -14.449, -40.974> <-8.490, -14.428, -40.969> 
		<-8.509, -14.756, -40.957> <-8.528, -14.665, -40.973> <-8.561, -14.475, -41.013> <-8.570, -14.454, -41.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.298, -14.402, -40.872> <-8.300, -14.391, -40.868> <-8.350, -14.342, -40.779> <-8.374, -14.339, -40.734> 
		<-8.380, -14.414, -40.912> <-8.383, -14.402, -40.909> <-8.436, -14.354, -40.821> <-8.460, -14.351, -40.776> 
		<-8.490, -14.428, -40.969> <-8.495, -14.417, -40.966> <-8.550, -14.368, -40.880> <-8.574, -14.365, -40.835> 
		<-8.570, -14.454, -41.008> <-8.575, -14.443, -41.006> <-8.632, -14.396, -40.921> <-8.656, -14.393, -40.876> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.374, -14.339, -40.734> <-8.398, -14.336, -40.689> <-8.448, -14.373, -40.594> <-8.450, -14.384, -40.589> 
		<-8.460, -14.351, -40.776> <-8.484, -14.348, -40.731> <-8.530, -14.384, -40.635> <-8.532, -14.395, -40.630> 
		<-8.574, -14.365, -40.835> <-8.598, -14.363, -40.790> <-8.642, -14.399, -40.693> <-8.642, -14.410, -40.686> 
		<-8.656, -14.393, -40.876> <-8.680, -14.390, -40.831> <-8.722, -14.426, -40.732> <-8.722, -14.437, -40.726> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.661, -14.739, -40.674> <-8.725, -14.761, -40.706> <-8.807, -14.802, -40.745> <-8.864, -14.842, -40.772> 
		<-8.679, -14.648, -40.690> <-8.743, -14.671, -40.721> <-8.840, -14.717, -40.768> <-8.897, -14.757, -40.794> 
		<-8.722, -14.457, -40.714> <-8.801, -14.484, -40.753> <-8.900, -14.530, -40.801> <-8.971, -14.579, -40.833> 
		<-8.722, -14.437, -40.726> <-8.800, -14.464, -40.764> <-8.903, -14.511, -40.814> <-8.974, -14.560, -40.847> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.661, -14.739, -40.674> <-8.643, -14.829, -40.659> <-8.610, -15.020, -40.618> <-8.601, -15.040, -40.623> 
		<-8.725, -14.761, -40.706> <-8.706, -14.852, -40.690> <-8.658, -15.038, -40.641> <-8.649, -15.059, -40.647> 
		<-8.807, -14.802, -40.745> <-8.774, -14.887, -40.723> <-8.723, -15.075, -40.672> <-8.710, -15.094, -40.676> 
		<-8.864, -14.842, -40.772> <-8.831, -14.927, -40.749> <-8.766, -15.105, -40.692> <-8.754, -15.124, -40.697> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.601, -15.040, -40.623> <-8.596, -15.051, -40.627> <-8.547, -15.046, -40.722> <-8.525, -15.049, -40.765> 
		<-8.649, -15.059, -40.647> <-8.644, -15.069, -40.650> <-8.596, -15.065, -40.746> <-8.573, -15.067, -40.788> 
		<-8.710, -15.094, -40.676> <-8.704, -15.104, -40.679> <-8.657, -15.100, -40.775> <-8.635, -15.102, -40.818> 
		<-8.754, -15.124, -40.697> <-8.748, -15.134, -40.699> <-8.701, -15.130, -40.796> <-8.678, -15.132, -40.838> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.525, -15.049, -40.765> <-8.502, -15.051, -40.807> <-8.449, -15.067, -40.900> <-8.449, -15.057, -40.906> 
		<-8.573, -15.067, -40.788> <-8.550, -15.070, -40.831> <-8.498, -15.086, -40.923> <-8.497, -15.076, -40.930> 
		<-8.635, -15.102, -40.818> <-8.612, -15.105, -40.860> <-8.558, -15.120, -40.952> <-8.559, -15.110, -40.959> 
		<-8.678, -15.132, -40.838> <-8.656, -15.134, -40.881> <-8.601, -15.149, -40.972> <-8.603, -15.140, -40.980> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.449, -15.057, -40.906> <-8.448, -15.038, -40.919> <-8.491, -14.846, -40.942> <-8.509, -14.756, -40.957> 
		<-8.497, -15.076, -40.930> <-8.496, -15.057, -40.943> <-8.555, -14.869, -40.973> <-8.573, -14.778, -40.988> 
		<-8.559, -15.110, -40.959> <-8.561, -15.092, -40.973> <-8.623, -14.903, -41.006> <-8.656, -14.819, -41.028> 
		<-8.603, -15.140, -40.980> <-8.605, -15.122, -40.994> <-8.680, -14.943, -41.032> <-8.713, -14.858, -41.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.509, -14.756, -40.957> <-8.528, -14.665, -40.973> <-8.561, -14.475, -41.013> <-8.570, -14.454, -41.008> 
		<-8.573, -14.778, -40.988> <-8.591, -14.688, -41.004> <-8.640, -14.501, -41.052> <-8.649, -14.481, -41.047> 
		<-8.656, -14.819, -41.028> <-8.689, -14.734, -41.051> <-8.740, -14.548, -41.100> <-8.752, -14.528, -41.097> 
		<-8.713, -14.858, -41.055> <-8.745, -14.774, -41.077> <-8.811, -14.596, -41.133> <-8.822, -14.576, -41.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.570, -14.454, -41.008> <-8.575, -14.443, -41.006> <-8.632, -14.396, -40.921> <-8.656, -14.393, -40.876> 
		<-8.649, -14.481, -41.047> <-8.653, -14.469, -41.044> <-8.714, -14.423, -40.961> <-8.738, -14.420, -40.916> 
		<-8.752, -14.528, -41.097> <-8.758, -14.517, -41.095> <-8.820, -14.471, -41.012> <-8.844, -14.469, -40.967> 
		<-8.822, -14.576, -41.130> <-8.829, -14.566, -41.128> <-8.893, -14.521, -41.046> <-8.917, -14.519, -41.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.656, -14.393, -40.876> <-8.680, -14.390, -40.831> <-8.722, -14.426, -40.732> <-8.722, -14.437, -40.726> 
		<-8.738, -14.420, -40.916> <-8.762, -14.417, -40.871> <-8.800, -14.453, -40.771> <-8.800, -14.464, -40.764> 
		<-8.844, -14.469, -40.967> <-8.868, -14.466, -40.922> <-8.905, -14.501, -40.821> <-8.903, -14.511, -40.814> 
		<-8.917, -14.519, -41.001> <-8.941, -14.516, -40.957> <-8.976, -14.550, -40.854> <-8.974, -14.560, -40.847> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.864, -14.842, -40.772> <-8.927, -14.886, -40.801> <-9.003, -14.958, -40.836> <-9.056, -15.017, -40.858> 
		<-8.897, -14.757, -40.794> <-8.960, -14.802, -40.823> <-9.053, -14.888, -40.866> <-9.106, -14.947, -40.889> 
		<-8.971, -14.579, -40.833> <-9.051, -14.634, -40.871> <-9.150, -14.717, -40.917> <-9.213, -14.796, -40.943> 
		<-8.974, -14.560, -40.847> <-9.054, -14.615, -40.884> <-9.157, -14.701, -40.931> <-9.220, -14.781, -40.958> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.864, -14.842, -40.772> <-8.831, -14.927, -40.749> <-8.766, -15.105, -40.692> <-8.754, -15.124, -40.697> 
		<-8.927, -14.886, -40.801> <-8.894, -14.971, -40.778> <-8.810, -15.135, -40.713> <-8.798, -15.154, -40.717> 
		<-9.003, -14.958, -40.836> <-8.955, -15.026, -40.806> <-8.870, -15.184, -40.741> <-8.855, -15.200, -40.743> 
		<-9.056, -15.017, -40.858> <-9.007, -15.085, -40.829> <-8.907, -15.226, -40.757> <-8.891, -15.241, -40.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.754, -15.124, -40.697> <-8.748, -15.134, -40.699> <-8.701, -15.130, -40.796> <-8.678, -15.132, -40.838> 
		<-8.798, -15.154, -40.717> <-8.792, -15.164, -40.719> <-8.745, -15.160, -40.816> <-8.722, -15.162, -40.859> 
		<-8.855, -15.200, -40.743> <-8.846, -15.208, -40.745> <-8.802, -15.205, -40.842> <-8.779, -15.207, -40.885> 
		<-8.891, -15.241, -40.759> <-8.883, -15.249, -40.761> <-8.839, -15.246, -40.859> <-8.816, -15.248, -40.901> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.678, -15.132, -40.838> <-8.656, -15.134, -40.881> <-8.601, -15.149, -40.972> <-8.603, -15.140, -40.980> 
		<-8.722, -15.162, -40.859> <-8.700, -15.165, -40.901> <-8.646, -15.179, -40.993> <-8.647, -15.170, -41.000> 
		<-8.779, -15.207, -40.885> <-8.757, -15.209, -40.928> <-8.701, -15.222, -41.018> <-8.704, -15.215, -41.027> 
		<-8.816, -15.248, -40.901> <-8.793, -15.250, -40.944> <-8.737, -15.263, -41.034> <-8.741, -15.255, -41.043> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.603, -15.140, -40.980> <-8.605, -15.122, -40.994> <-8.680, -14.943, -41.032> <-8.713, -14.858, -41.055> 
		<-8.647, -15.170, -41.000> <-8.649, -15.152, -41.015> <-8.742, -14.987, -41.061> <-8.775, -14.902, -41.084> 
		<-8.704, -15.215, -41.027> <-8.710, -15.201, -41.042> <-8.804, -15.041, -41.089> <-8.852, -14.973, -41.119> 
		<-8.741, -15.255, -41.043> <-8.746, -15.241, -41.058> <-8.856, -15.099, -41.113> <-8.905, -15.032, -41.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.713, -14.858, -41.055> <-8.745, -14.774, -41.077> <-8.811, -14.596, -41.133> <-8.822, -14.576, -41.130> 
		<-8.775, -14.902, -41.084> <-8.808, -14.817, -41.107> <-8.891, -14.651, -41.170> <-8.903, -14.631, -41.167> 
		<-8.852, -14.973, -41.119> <-8.902, -14.903, -41.149> <-8.991, -14.733, -41.216> <-9.006, -14.717, -41.215> 
		<-8.905, -15.032, -41.142> <-8.955, -14.961, -41.172> <-9.054, -14.812, -41.243> <-9.069, -14.796, -41.242> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.822, -14.576, -41.130> <-8.829, -14.566, -41.128> <-8.893, -14.521, -41.046> <-8.917, -14.519, -41.001> 
		<-8.903, -14.631, -41.167> <-8.909, -14.621, -41.166> <-8.977, -14.579, -41.086> <-9.001, -14.576, -41.041> 
		<-9.006, -14.717, -41.215> <-9.015, -14.707, -41.214> <-9.085, -14.667, -41.135> <-9.109, -14.665, -41.090> 
		<-9.069, -14.796, -41.242> <-9.078, -14.787, -41.241> <-9.151, -14.749, -41.163> <-9.175, -14.747, -41.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.917, -14.519, -41.001> <-8.941, -14.516, -40.957> <-8.976, -14.550, -40.854> <-8.974, -14.560, -40.847> 
		<-9.001, -14.576, -41.041> <-9.025, -14.573, -40.996> <-9.056, -14.605, -40.892> <-9.054, -14.615, -40.884> 
		<-9.109, -14.665, -41.090> <-9.133, -14.662, -41.045> <-9.161, -14.693, -40.940> <-9.157, -14.701, -40.931> 
		<-9.175, -14.747, -41.118> <-9.199, -14.745, -41.074> <-9.224, -14.772, -40.967> <-9.220, -14.781, -40.958> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.056, -15.017, -40.858> <-9.112, -15.081, -40.883> <-9.182, -15.175, -40.909> <-9.226, -15.251, -40.930> 
		<-9.106, -14.947, -40.889> <-9.162, -15.011, -40.914> <-9.236, -15.133, -40.940> <-9.280, -15.208, -40.961> 
		<-9.213, -14.796, -40.943> <-9.282, -14.884, -40.973> <-9.352, -15.014, -40.997> <-9.398, -15.117, -41.018> 
		<-9.220, -14.781, -40.958> <-9.289, -14.868, -40.988> <-9.360, -15.005, -41.012> <-9.406, -15.108, -41.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.056, -15.017, -40.858> <-9.007, -15.085, -40.829> <-8.907, -15.226, -40.757> <-8.891, -15.241, -40.759> 
		<-9.112, -15.081, -40.883> <-9.064, -15.149, -40.854> <-8.949, -15.273, -40.775> <-8.933, -15.288, -40.778> 
		<-9.182, -15.175, -40.909> <-9.119, -15.225, -40.873> <-8.999, -15.350, -40.792> <-8.980, -15.362, -40.793> 
		<-9.226, -15.251, -40.930> <-9.162, -15.300, -40.894> <-9.032, -15.405, -40.809> <-9.013, -15.416, -40.810> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.891, -15.241, -40.759> <-8.883, -15.249, -40.761> <-8.839, -15.246, -40.859> <-8.816, -15.248, -40.901> 
		<-8.933, -15.288, -40.778> <-8.925, -15.296, -40.779> <-8.881, -15.293, -40.877> <-8.858, -15.295, -40.920> 
		<-8.980, -15.362, -40.793> <-8.970, -15.368, -40.794> <-8.928, -15.367, -40.893> <-8.905, -15.369, -40.935> 
		<-9.013, -15.416, -40.810> <-9.003, -15.422, -40.811> <-8.961, -15.421, -40.910> <-8.938, -15.423, -40.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.816, -15.248, -40.901> <-8.793, -15.250, -40.944> <-8.737, -15.263, -41.034> <-8.741, -15.255, -41.043> 
		<-8.858, -15.295, -40.920> <-8.835, -15.297, -40.962> <-8.780, -15.310, -41.053> <-8.783, -15.302, -41.061> 
		<-8.905, -15.369, -40.935> <-8.883, -15.371, -40.978> <-8.825, -15.381, -41.068> <-8.830, -15.376, -41.077> 
		<-8.938, -15.423, -40.952> <-8.916, -15.425, -40.995> <-8.859, -15.435, -41.085> <-8.863, -15.430, -41.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.741, -15.255, -41.043> <-8.746, -15.241, -41.058> <-8.856, -15.099, -41.113> <-8.905, -15.032, -41.142> 
		<-8.783, -15.302, -41.061> <-8.789, -15.288, -41.077> <-8.914, -15.163, -41.138> <-8.962, -15.095, -41.167> 
		<-8.830, -15.376, -41.077> <-8.839, -15.365, -41.094> <-8.969, -15.239, -41.157> <-9.032, -15.189, -41.193> 
		<-8.863, -15.430, -41.094> <-8.872, -15.419, -41.111> <-9.012, -15.314, -41.178> <-9.076, -15.264, -41.214> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.905, -15.032, -41.142> <-8.955, -14.961, -41.172> <-9.054, -14.812, -41.243> <-9.069, -14.796, -41.242> 
		<-8.962, -15.095, -41.167> <-9.012, -15.025, -41.197> <-9.123, -14.899, -41.273> <-9.138, -14.883, -41.271> 
		<-9.032, -15.189, -41.193> <-9.086, -15.147, -41.224> <-9.194, -15.028, -41.297> <-9.210, -15.019, -41.296> 
		<-9.076, -15.264, -41.214> <-9.130, -15.222, -41.245> <-9.241, -15.132, -41.317> <-9.256, -15.122, -41.316> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.069, -14.796, -41.242> <-9.078, -14.787, -41.241> <-9.151, -14.749, -41.163> <-9.175, -14.747, -41.118> 
		<-9.138, -14.883, -41.271> <-9.147, -14.874, -41.271> <-9.223, -14.839, -41.194> <-9.247, -14.837, -41.149> 
		<-9.210, -15.019, -41.296> <-9.221, -15.012, -41.295> <-9.298, -14.980, -41.220> <-9.322, -14.977, -41.175> 
		<-9.256, -15.122, -41.316> <-9.267, -15.115, -41.316> <-9.347, -15.086, -41.241> <-9.370, -15.084, -41.196> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.175, -14.747, -41.118> <-9.199, -14.745, -41.074> <-9.224, -14.772, -40.967> <-9.220, -14.781, -40.958> 
		<-9.247, -14.837, -41.149> <-9.271, -14.834, -41.105> <-9.292, -14.860, -40.996> <-9.289, -14.868, -40.988> 
		<-9.322, -14.977, -41.175> <-9.346, -14.975, -41.130> <-9.365, -14.999, -41.021> <-9.360, -15.005, -41.012> 
		<-9.370, -15.084, -41.196> <-9.394, -15.082, -41.151> <-9.411, -15.102, -41.042> <-9.406, -15.108, -41.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.226, -15.251, -40.930> <-9.264, -15.316, -40.949> <-9.304, -15.409, -40.980> <-9.326, -15.483, -40.989> 
		<-9.280, -15.208, -40.961> <-9.318, -15.274, -40.979> <-9.359, -15.389, -41.009> <-9.380, -15.464, -41.019> 
		<-9.398, -15.117, -41.018> <-9.440, -15.211, -41.037> <-9.482, -15.335, -41.066> <-9.504, -15.437, -41.075> 
		<-9.406, -15.108, -41.032> <-9.448, -15.202, -41.051> <-9.490, -15.332, -41.080> <-9.512, -15.434, -41.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.226, -15.251, -40.930> <-9.162, -15.300, -40.894> <-9.032, -15.405, -40.809> <-9.013, -15.416, -40.810> 
		<-9.264, -15.316, -40.949> <-9.200, -15.366, -40.913> <-9.060, -15.452, -40.824> <-9.042, -15.463, -40.825> 
		<-9.304, -15.409, -40.980> <-9.234, -15.433, -40.942> <-9.091, -15.521, -40.855> <-9.072, -15.528, -40.856> 
		<-9.326, -15.483, -40.989> <-9.255, -15.507, -40.952> <-9.116, -15.572, -40.864> <-9.096, -15.578, -40.865> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.013, -15.416, -40.810> <-9.003, -15.422, -40.811> <-8.961, -15.421, -40.910> <-8.938, -15.423, -40.952> 
		<-9.042, -15.463, -40.825> <-9.032, -15.469, -40.826> <-8.990, -15.468, -40.925> <-8.967, -15.470, -40.967> 
		<-9.072, -15.528, -40.856> <-9.060, -15.531, -40.856> <-9.019, -15.532, -40.955> <-8.997, -15.534, -40.998> 
		<-9.096, -15.578, -40.865> <-9.085, -15.582, -40.866> <-9.044, -15.583, -40.965> <-9.022, -15.585, -41.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.938, -15.423, -40.952> <-8.916, -15.425, -40.995> <-8.859, -15.435, -41.085> <-8.863, -15.430, -41.094> 
		<-8.967, -15.470, -40.967> <-8.945, -15.472, -41.010> <-8.888, -15.482, -41.100> <-8.892, -15.477, -41.109> 
		<-8.997, -15.534, -40.998> <-8.975, -15.536, -41.041> <-8.917, -15.544, -41.130> <-8.923, -15.541, -41.140> 
		<-9.022, -15.585, -41.008> <-9.000, -15.587, -41.050> <-8.942, -15.595, -41.140> <-8.948, -15.591, -41.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.863, -15.430, -41.094> <-8.872, -15.419, -41.111> <-9.012, -15.314, -41.178> <-9.076, -15.264, -41.214> 
		<-8.892, -15.477, -41.109> <-8.901, -15.466, -41.126> <-9.051, -15.379, -41.197> <-9.114, -15.330, -41.233> 
		<-8.923, -15.541, -41.140> <-8.933, -15.535, -41.157> <-9.085, -15.446, -41.227> <-9.156, -15.422, -41.264> 
		<-8.948, -15.591, -41.150> <-8.958, -15.586, -41.167> <-9.107, -15.520, -41.236> <-9.177, -15.496, -41.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.076, -15.264, -41.214> <-9.130, -15.222, -41.245> <-9.241, -15.132, -41.317> <-9.256, -15.122, -41.316> 
		<-9.114, -15.330, -41.233> <-9.169, -15.287, -41.264> <-9.283, -15.225, -41.336> <-9.299, -15.215, -41.335> 
		<-9.156, -15.422, -41.264> <-9.211, -15.403, -41.294> <-9.326, -15.349, -41.365> <-9.342, -15.346, -41.365> 
		<-9.177, -15.496, -41.274> <-9.232, -15.477, -41.303> <-9.348, -15.451, -41.374> <-9.364, -15.447, -41.373> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.256, -15.122, -41.316> <-9.267, -15.115, -41.316> <-9.347, -15.086, -41.241> <-9.370, -15.084, -41.196> 
		<-9.299, -15.215, -41.335> <-9.309, -15.209, -41.335> <-9.391, -15.184, -41.261> <-9.415, -15.181, -41.216> 
		<-9.342, -15.346, -41.365> <-9.354, -15.343, -41.364> <-9.437, -15.320, -41.292> <-9.461, -15.318, -41.246> 
		<-9.364, -15.447, -41.373> <-9.376, -15.444, -41.372> <-9.460, -15.426, -41.300> <-9.484, -15.424, -41.255> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.370, -15.084, -41.196> <-9.394, -15.082, -41.151> <-9.411, -15.102, -41.042> <-9.406, -15.108, -41.032> 
		<-9.415, -15.181, -41.216> <-9.439, -15.179, -41.171> <-9.453, -15.196, -41.061> <-9.448, -15.202, -41.051> 
		<-9.461, -15.318, -41.246> <-9.484, -15.316, -41.201> <-9.497, -15.330, -41.091> <-9.490, -15.332, -41.080> 
		<-9.484, -15.424, -41.255> <-9.507, -15.422, -41.210> <-9.519, -15.432, -41.099> <-9.512, -15.434, -41.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.326, -15.483, -40.989> <-9.344, -15.549, -40.998> <-9.361, -15.642, -40.995> <-9.357, -15.711, -40.990> 
		<-9.380, -15.464, -41.019> <-9.399, -15.530, -41.027> <-9.414, -15.644, -41.025> <-9.410, -15.713, -41.020> 
		<-9.504, -15.437, -41.075> <-9.522, -15.522, -41.082> <-9.537, -15.635, -41.076> <-9.530, -15.722, -41.069> 
		<-9.512, -15.434, -41.088> <-9.530, -15.519, -41.095> <-9.545, -15.636, -41.089> <-9.538, -15.723, -41.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.326, -15.483, -40.989> <-9.255, -15.507, -40.952> <-9.116, -15.572, -40.864> <-9.096, -15.578, -40.865> 
		<-9.344, -15.549, -40.998> <-9.274, -15.573, -40.960> <-9.134, -15.610, -40.871> <-9.114, -15.616, -40.872> 
		<-9.361, -15.642, -40.995> <-9.299, -15.640, -40.959> <-9.170, -15.665, -40.864> <-9.152, -15.666, -40.865> 
		<-9.357, -15.711, -40.990> <-9.295, -15.708, -40.955> <-9.172, -15.708, -40.863> <-9.154, -15.708, -40.864> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.096, -15.578, -40.865> <-9.085, -15.582, -40.866> <-9.044, -15.583, -40.965> <-9.022, -15.585, -41.008> 
		<-9.114, -15.616, -40.872> <-9.103, -15.620, -40.873> <-9.063, -15.621, -40.972> <-9.041, -15.623, -41.015> 
		<-9.152, -15.666, -40.865> <-9.140, -15.666, -40.865> <-9.100, -15.670, -40.967> <-9.078, -15.672, -41.010> 
		<-9.154, -15.708, -40.864> <-9.143, -15.709, -40.865> <-9.103, -15.713, -40.964> <-9.081, -15.715, -41.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.022, -15.585, -41.008> <-9.000, -15.587, -41.050> <-8.942, -15.595, -41.140> <-8.948, -15.591, -41.150> 
		<-9.041, -15.623, -41.015> <-9.018, -15.625, -41.057> <-8.961, -15.633, -41.147> <-8.967, -15.629, -41.157> 
		<-9.078, -15.672, -41.010> <-9.056, -15.674, -41.053> <-8.998, -15.678, -41.144> <-9.003, -15.679, -41.155> 
		<-9.081, -15.715, -41.007> <-9.059, -15.717, -41.050> <-9.003, -15.721, -41.139> <-9.008, -15.721, -41.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.948, -15.591, -41.150> <-8.958, -15.586, -41.167> <-9.107, -15.520, -41.236> <-9.177, -15.496, -41.274> 
		<-8.967, -15.629, -41.157> <-8.977, -15.624, -41.174> <-9.126, -15.586, -41.245> <-9.197, -15.561, -41.283> 
		<-9.003, -15.679, -41.155> <-9.011, -15.679, -41.171> <-9.149, -15.653, -41.252> <-9.211, -15.655, -41.287> 
		<-9.008, -15.721, -41.150> <-9.016, -15.722, -41.166> <-9.148, -15.721, -41.241> <-9.210, -15.723, -41.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.177, -15.496, -41.274> <-9.232, -15.477, -41.303> <-9.348, -15.451, -41.374> <-9.364, -15.447, -41.373> 
		<-9.197, -15.561, -41.283> <-9.251, -15.542, -41.312> <-9.367, -15.535, -41.381> <-9.383, -15.532, -41.380> 
		<-9.211, -15.655, -41.287> <-9.264, -15.657, -41.317> <-9.379, -15.649, -41.383> <-9.394, -15.650, -41.382> 
		<-9.210, -15.723, -41.276> <-9.263, -15.725, -41.306> <-9.376, -15.735, -41.369> <-9.391, -15.736, -41.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.364, -15.447, -41.373> <-9.376, -15.444, -41.372> <-9.460, -15.426, -41.300> <-9.484, -15.424, -41.255> 
		<-9.383, -15.532, -41.380> <-9.395, -15.529, -41.379> <-9.480, -15.516, -41.308> <-9.504, -15.514, -41.263> 
		<-9.394, -15.650, -41.382> <-9.407, -15.650, -41.381> <-9.495, -15.640, -41.306> <-9.518, -15.638, -41.261> 
		<-9.391, -15.736, -41.368> <-9.404, -15.736, -41.367> <-9.490, -15.732, -41.295> <-9.513, -15.730, -41.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.484, -15.424, -41.255> <-9.507, -15.422, -41.210> <-9.519, -15.432, -41.099> <-9.512, -15.434, -41.088> 
		<-9.504, -15.514, -41.263> <-9.527, -15.512, -41.218> <-9.537, -15.517, -41.106> <-9.530, -15.519, -41.095> 
		<-9.518, -15.638, -41.261> <-9.541, -15.636, -41.216> <-9.551, -15.637, -41.100> <-9.545, -15.636, -41.089> 
		<-9.513, -15.730, -41.250> <-9.537, -15.728, -41.205> <-9.544, -15.724, -41.093> <-9.538, -15.723, -41.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.357, -15.711, -40.990> <-9.347, -15.875, -40.979> <-9.306, -16.090, -40.951> <-9.279, -16.251, -40.938> 
		<-9.410, -15.713, -41.020> <-9.400, -15.877, -41.009> <-9.357, -16.095, -40.977> <-9.330, -16.257, -40.963> 
		<-9.530, -15.722, -41.069> <-9.517, -15.894, -41.056> <-9.475, -16.119, -41.028> <-9.437, -16.286, -41.009> 
		<-9.538, -15.723, -41.082> <-9.525, -15.895, -41.069> <-9.484, -16.121, -41.040> <-9.445, -16.288, -41.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.357, -15.711, -40.990> <-9.295, -15.708, -40.955> <-9.172, -15.708, -40.863> <-9.154, -15.708, -40.864> 
		<-9.347, -15.875, -40.979> <-9.285, -15.872, -40.944> <-9.181, -15.871, -40.863> <-9.163, -15.871, -40.864> 
		<-9.306, -16.090, -40.951> <-9.263, -16.085, -40.929> <-9.161, -16.089, -40.864> <-9.149, -16.090, -40.866> 
		<-9.279, -16.251, -40.938> <-9.236, -16.246, -40.916> <-9.145, -16.252, -40.860> <-9.133, -16.252, -40.862> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.154, -15.708, -40.864> <-9.143, -15.709, -40.865> <-9.103, -15.713, -40.964> <-9.081, -15.715, -41.007> 
		<-9.163, -15.871, -40.864> <-9.152, -15.872, -40.864> <-9.117, -15.875, -40.955> <-9.095, -15.877, -40.998> 
		<-9.149, -16.090, -40.866> <-9.140, -16.090, -40.867> <-9.104, -16.093, -40.952> <-9.088, -16.094, -40.984> 
		<-9.133, -16.252, -40.862> <-9.125, -16.253, -40.863> <-9.095, -16.255, -40.937> <-9.079, -16.256, -40.969> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.081, -15.715, -41.007> <-9.059, -15.717, -41.050> <-9.003, -15.721, -41.139> <-9.008, -15.721, -41.150> 
		<-9.095, -15.877, -40.998> <-9.073, -15.879, -41.041> <-9.021, -15.882, -41.121> <-9.026, -15.882, -41.132> 
		<-9.088, -16.094, -40.984> <-9.072, -16.096, -41.016> <-9.023, -16.099, -41.094> <-9.027, -16.099, -41.102> 
		<-9.079, -16.256, -40.969> <-9.062, -16.258, -41.000> <-9.020, -16.260, -41.067> <-9.024, -16.260, -41.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.008, -15.721, -41.150> <-9.016, -15.722, -41.166> <-9.148, -15.721, -41.241> <-9.210, -15.723, -41.276> 
		<-9.026, -15.882, -41.132> <-9.034, -15.883, -41.148> <-9.147, -15.885, -41.214> <-9.209, -15.887, -41.249> 
		<-9.027, -16.099, -41.102> <-9.033, -16.099, -41.113> <-9.141, -16.094, -41.165> <-9.185, -16.099, -41.188> 
		<-9.024, -16.260, -41.075> <-9.030, -16.261, -41.086> <-9.126, -16.254, -41.128> <-9.170, -16.259, -41.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.210, -15.723, -41.276> <-9.263, -15.725, -41.306> <-9.376, -15.735, -41.369> <-9.391, -15.736, -41.368> 
		<-9.209, -15.887, -41.249> <-9.262, -15.889, -41.280> <-9.371, -15.907, -41.341> <-9.386, -15.907, -41.340> 
		<-9.185, -16.099, -41.188> <-9.235, -16.105, -41.213> <-9.348, -16.128, -41.277> <-9.362, -16.130, -41.277> 
		<-9.170, -16.259, -41.151> <-9.220, -16.265, -41.176> <-9.322, -16.295, -41.233> <-9.336, -16.296, -41.233> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.391, -15.736, -41.368> <-9.404, -15.736, -41.367> <-9.490, -15.732, -41.295> <-9.513, -15.730, -41.250> 
		<-9.386, -15.907, -41.340> <-9.398, -15.907, -41.339> <-9.481, -15.903, -41.275> <-9.504, -15.901, -41.230> 
		<-9.362, -16.130, -41.277> <-9.372, -16.131, -41.277> <-9.453, -16.127, -41.218> <-9.471, -16.126, -41.183> 
		<-9.336, -16.296, -41.233> <-9.346, -16.298, -41.233> <-9.420, -16.294, -41.186> <-9.438, -16.293, -41.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.513, -15.730, -41.250> <-9.537, -15.728, -41.205> <-9.544, -15.724, -41.093> <-9.538, -15.723, -41.082> 
		<-9.504, -15.901, -41.230> <-9.528, -15.899, -41.184> <-9.531, -15.895, -41.079> <-9.525, -15.895, -41.069> 
		<-9.471, -16.126, -41.183> <-9.489, -16.125, -41.148> <-9.489, -16.122, -41.047> <-9.484, -16.121, -41.040> 
		<-9.438, -16.293, -41.151> <-9.456, -16.292, -41.116> <-9.451, -16.290, -41.028> <-9.445, -16.288, -41.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.279, -16.251, -40.938> <-9.255, -16.396, -40.926> <-9.256, -16.605, -40.930> <-9.186, -16.733, -40.906> 
		<-9.330, -16.257, -40.963> <-9.305, -16.402, -40.951> <-9.291, -16.606, -40.948> <-9.222, -16.734, -40.924> 
		<-9.437, -16.286, -41.009> <-9.405, -16.425, -40.993> <-9.377, -16.626, -40.988> <-9.298, -16.742, -40.958> 
		<-9.445, -16.288, -41.020> <-9.413, -16.427, -41.004> <-9.383, -16.626, -40.995> <-9.304, -16.743, -40.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.279, -16.251, -40.938> <-9.236, -16.246, -40.916> <-9.145, -16.252, -40.860> <-9.133, -16.252, -40.862> 
		<-9.255, -16.396, -40.926> <-9.211, -16.391, -40.904> <-9.132, -16.398, -40.857> <-9.120, -16.398, -40.859> 
		<-9.256, -16.605, -40.930> <-9.217, -16.604, -40.910> <-9.124, -16.599, -40.856> <-9.114, -16.600, -40.856> 
		<-9.186, -16.733, -40.906> <-9.148, -16.732, -40.886> <-9.069, -16.734, -40.840> <-9.058, -16.734, -40.840> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.133, -16.252, -40.862> <-9.125, -16.253, -40.863> <-9.095, -16.255, -40.937> <-9.079, -16.256, -40.969> 
		<-9.120, -16.398, -40.859> <-9.111, -16.398, -40.860> <-9.087, -16.400, -40.923> <-9.070, -16.401, -40.955> 
		<-9.114, -16.600, -40.856> <-9.108, -16.600, -40.857> <-9.081, -16.601, -40.921> <-9.070, -16.602, -40.941> 
		<-9.058, -16.734, -40.840> <-9.053, -16.734, -40.840> <-9.034, -16.735, -40.888> <-9.023, -16.736, -40.909> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.079, -16.256, -40.969> <-9.062, -16.258, -41.000> <-9.020, -16.260, -41.067> <-9.024, -16.260, -41.075> 
		<-9.070, -16.401, -40.955> <-9.054, -16.403, -40.986> <-9.017, -16.405, -41.043> <-9.021, -16.405, -41.051> 
		<-9.070, -16.602, -40.941> <-9.060, -16.602, -40.962> <-9.023, -16.605, -41.021> <-9.027, -16.605, -41.026> 
		<-9.023, -16.736, -40.909> <-9.012, -16.736, -40.930> <-8.984, -16.738, -40.973> <-8.988, -16.738, -40.978> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.024, -16.260, -41.075> <-9.030, -16.261, -41.086> <-9.126, -16.254, -41.128> <-9.170, -16.259, -41.151> 
		<-9.021, -16.405, -41.051> <-9.027, -16.405, -41.061> <-9.113, -16.398, -41.096> <-9.157, -16.403, -41.118> 
		<-9.027, -16.605, -41.026> <-9.033, -16.605, -41.035> <-9.131, -16.609, -41.079> <-9.169, -16.610, -41.098> 
		<-8.988, -16.738, -40.978> <-8.994, -16.738, -40.987> <-9.077, -16.735, -41.024> <-9.116, -16.736, -41.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.170, -16.259, -41.151> <-9.220, -16.265, -41.176> <-9.322, -16.295, -41.233> <-9.336, -16.296, -41.233> 
		<-9.157, -16.403, -41.118> <-9.207, -16.409, -41.143> <-9.301, -16.432, -41.197> <-9.315, -16.434, -41.197> 
		<-9.169, -16.610, -41.098> <-9.205, -16.611, -41.116> <-9.288, -16.631, -41.161> <-9.298, -16.631, -41.162> 
		<-9.116, -16.736, -41.044> <-9.151, -16.738, -41.062> <-9.224, -16.746, -41.103> <-9.234, -16.746, -41.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.336, -16.296, -41.233> <-9.346, -16.298, -41.233> <-9.420, -16.294, -41.186> <-9.438, -16.293, -41.151> 
		<-9.315, -16.434, -41.197> <-9.324, -16.435, -41.197> <-9.393, -16.433, -41.160> <-9.411, -16.431, -41.125> 
		<-9.298, -16.631, -41.162> <-9.305, -16.632, -41.162> <-9.375, -16.630, -41.127> <-9.387, -16.630, -41.102> 
		<-9.234, -16.746, -41.104> <-9.241, -16.746, -41.104> <-9.302, -16.745, -41.082> <-9.314, -16.745, -41.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.438, -16.293, -41.151> <-9.456, -16.292, -41.116> <-9.451, -16.290, -41.028> <-9.445, -16.288, -41.020> 
		<-9.411, -16.431, -41.125> <-9.429, -16.430, -41.090> <-9.419, -16.429, -41.012> <-9.413, -16.427, -41.004> 
		<-9.387, -16.630, -41.102> <-9.400, -16.629, -41.078> <-9.388, -16.627, -41.001> <-9.383, -16.626, -40.995> 
		<-9.314, -16.745, -41.058> <-9.327, -16.744, -41.033> <-9.309, -16.743, -40.971> <-9.304, -16.743, -40.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.872, -17.004, -40.794> <-8.896, -17.005, -40.807> <-8.948, -17.011, -40.831> <-8.954, -17.012, -40.835> 
		<-8.966, -16.923, -40.828> <-8.991, -16.924, -40.840> <-9.053, -16.931, -40.871> <-9.059, -16.931, -40.874> 
		<-9.126, -16.845, -40.884> <-9.161, -16.846, -40.902> <-9.222, -16.854, -40.929> <-9.228, -16.854, -40.937> 
		<-9.186, -16.733, -40.906> <-9.222, -16.734, -40.924> <-9.298, -16.742, -40.958> <-9.304, -16.743, -40.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.872, -17.004, -40.794> <-8.966, -16.923, -40.828> <-9.126, -16.845, -40.884> <-9.186, -16.733, -40.906> 
		<-8.857, -17.004, -40.787> <-8.952, -16.922, -40.820> <-9.087, -16.844, -40.865> <-9.148, -16.732, -40.886> 
		<-8.828, -17.007, -40.770> <-8.898, -16.925, -40.791> <-9.027, -16.835, -40.827> <-9.069, -16.734, -40.840> 
		<-8.824, -17.007, -40.769> <-8.894, -16.925, -40.790> <-9.017, -16.835, -40.827> <-9.058, -16.734, -40.840> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.824, -17.007, -40.769> <-8.894, -16.925, -40.790> <-9.017, -16.835, -40.827> <-9.058, -16.734, -40.840> 
		<-8.822, -17.007, -40.769> <-8.893, -16.925, -40.790> <-9.011, -16.835, -40.828> <-9.053, -16.734, -40.840> 
		<-8.817, -17.006, -40.781> <-8.880, -16.925, -40.818> <-8.998, -16.835, -40.864> <-9.034, -16.735, -40.888> 
		<-8.815, -17.006, -40.787> <-8.877, -16.925, -40.823> <-8.988, -16.836, -40.885> <-9.023, -16.736, -40.909> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.815, -17.006, -40.787> <-8.877, -16.925, -40.823> <-8.988, -16.836, -40.885> <-9.023, -16.736, -40.909> 
		<-8.812, -17.005, -40.792> <-8.874, -16.925, -40.829> <-8.977, -16.836, -40.905> <-9.012, -16.736, -40.930> 
		<-8.805, -17.005, -40.803> <-8.859, -16.925, -40.855> <-8.955, -16.837, -40.937> <-8.984, -16.738, -40.973> 
		<-8.806, -17.005, -40.804> <-8.860, -16.925, -40.856> <-8.958, -16.837, -40.942> <-8.988, -16.738, -40.978> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.806, -17.005, -40.804> <-8.860, -16.925, -40.856> <-8.958, -16.837, -40.942> <-8.988, -16.738, -40.978> 
		<-8.808, -17.004, -40.807> <-8.863, -16.924, -40.859> <-8.964, -16.837, -40.950> <-8.994, -16.738, -40.987> 
		<-8.839, -17.001, -40.822> <-8.918, -16.922, -40.886> <-9.030, -16.845, -40.976> <-9.077, -16.735, -41.024> 
		<-8.854, -17.002, -40.829> <-8.932, -16.922, -40.894> <-9.069, -16.847, -40.996> <-9.116, -16.736, -41.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.854, -17.002, -40.829> <-8.932, -16.922, -40.894> <-9.069, -16.847, -40.996> <-9.116, -16.736, -41.044> 
		<-8.878, -17.002, -40.842> <-8.957, -16.923, -40.906> <-9.104, -16.848, -41.014> <-9.151, -16.738, -41.062> 
		<-8.929, -17.009, -40.869> <-9.018, -16.930, -40.938> <-9.162, -16.856, -41.047> <-9.224, -16.746, -41.103> 
		<-8.935, -17.009, -40.871> <-9.025, -16.930, -40.941> <-9.172, -16.856, -41.048> <-9.234, -16.746, -41.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.935, -17.009, -40.871> <-9.025, -16.930, -40.941> <-9.172, -16.856, -41.048> <-9.234, -16.746, -41.104> 
		<-8.939, -17.009, -40.872> <-9.028, -16.930, -40.942> <-9.179, -16.856, -41.048> <-9.241, -16.746, -41.104> 
		<-8.976, -17.010, -40.885> <-9.075, -16.930, -40.940> <-9.231, -16.857, -41.039> <-9.302, -16.745, -41.082> 
		<-8.982, -17.011, -40.872> <-9.082, -16.931, -40.928> <-9.243, -16.857, -41.014> <-9.314, -16.745, -41.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.982, -17.011, -40.872> <-9.082, -16.931, -40.928> <-9.243, -16.857, -41.014> <-9.314, -16.745, -41.058> 
		<-8.988, -17.012, -40.860> <-9.088, -16.932, -40.916> <-9.256, -16.856, -40.990> <-9.327, -16.744, -41.033> 
		<-8.956, -17.012, -40.837> <-9.062, -16.931, -40.876> <-9.233, -16.855, -40.942> <-9.309, -16.743, -40.971> 
		<-8.954, -17.012, -40.835> <-9.059, -16.931, -40.874> <-9.228, -16.854, -40.937> <-9.304, -16.743, -40.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.606, -11.170, 34.702> <-6.606, -10.737, 34.666> <-6.853, -10.142, 34.617> <-7.161, -9.835, 34.592> 
		<-6.751, -11.168, 34.731> <-6.751, -10.734, 34.695> <-6.956, -10.242, 34.654> <-7.263, -9.935, 34.629> 
		<-6.958, -11.167, 34.734> <-6.958, -10.847, 34.707> <-7.182, -10.308, 34.663> <-7.410, -10.081, 34.644> 
		<-7.099, -11.171, 34.687> <-7.099, -10.851, 34.660> <-7.282, -10.410, 34.624> <-7.509, -10.184, 34.605> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.606, -11.170, 34.702> <-6.751, -11.168, 34.731> <-6.958, -11.167, 34.734> <-7.099, -11.171, 34.687> 
		<-6.606, -11.603, 34.738> <-6.751, -11.601, 34.766> <-6.958, -11.488, 34.760> <-7.099, -11.492, 34.713> 
		<-6.853, -12.198, 34.787> <-6.956, -12.094, 34.807> <-7.182, -12.027, 34.805> <-7.282, -11.932, 34.750> 
		<-7.161, -12.505, 34.812> <-7.263, -12.400, 34.833> <-7.410, -12.254, 34.824> <-7.509, -12.159, 34.769> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.606, -11.170, 34.702> <-6.552, -11.171, 34.691> <-6.489, -11.177, 34.620> <-6.484, -11.181, 34.566> 
		<-6.606, -10.737, 34.666> <-6.552, -10.737, 34.656> <-6.489, -10.716, 34.582> <-6.484, -10.720, 34.528> 
		<-6.853, -10.142, 34.617> <-6.815, -10.105, 34.603> <-6.751, -10.086, 34.530> <-6.748, -10.087, 34.475> 
		<-7.161, -9.835, 34.592> <-7.123, -9.798, 34.578> <-7.078, -9.760, 34.503> <-7.075, -9.761, 34.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.606, -11.170, 34.702> <-6.606, -11.603, 34.738> <-6.853, -12.198, 34.787> <-7.161, -12.505, 34.812> 
		<-6.552, -11.171, 34.691> <-6.552, -11.604, 34.727> <-6.815, -12.237, 34.780> <-7.123, -12.544, 34.805> 
		<-6.489, -11.177, 34.620> <-6.489, -11.638, 34.659> <-6.751, -12.268, 34.711> <-7.078, -12.594, 34.738> 
		<-6.484, -11.181, 34.566> <-6.484, -11.642, 34.604> <-6.748, -12.275, 34.657> <-7.075, -12.602, 34.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.099, -11.171, 34.687> <-7.099, -10.851, 34.660> <-7.282, -10.410, 34.624> <-7.509, -10.184, 34.605> 
		<-7.157, -11.173, 34.667> <-7.157, -10.852, 34.641> <-7.323, -10.453, 34.608> <-7.551, -10.227, 34.589> 
		<-7.186, -11.181, 34.567> <-7.186, -10.883, 34.542> <-7.359, -10.466, 34.507> <-7.571, -10.255, 34.490> 
		<-7.195, -11.186, 34.506> <-7.195, -10.888, 34.481> <-7.366, -10.478, 34.447> <-7.577, -10.267, 34.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.099, -11.171, 34.687> <-7.157, -11.173, 34.667> <-7.186, -11.181, 34.567> <-7.195, -11.186, 34.506> 
		<-7.099, -11.492, 34.713> <-7.157, -11.493, 34.694> <-7.186, -11.480, 34.591> <-7.195, -11.485, 34.530> 
		<-7.282, -11.932, 34.750> <-7.323, -11.892, 34.727> <-7.359, -11.896, 34.626> <-7.366, -11.895, 34.564> 
		<-7.509, -12.159, 34.769> <-7.551, -12.119, 34.746> <-7.571, -12.107, 34.643> <-7.577, -12.106, 34.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.727, -11.249, 33.751> <-6.727, -10.843, 33.717> <-6.958, -10.286, 33.671> <-7.246, -9.999, 33.647> 
		<-6.670, -11.247, 33.772> <-6.670, -10.841, 33.739> <-6.918, -10.244, 33.689> <-7.206, -9.957, 33.666> 
		<-6.547, -11.250, 33.739> <-6.547, -10.799, 33.702> <-6.799, -10.192, 33.652> <-7.119, -9.873, 33.625> 
		<-6.530, -11.245, 33.797> <-6.530, -10.794, 33.760> <-6.787, -10.175, 33.709> <-7.107, -9.856, 33.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.727, -11.249, 33.751> <-6.670, -11.247, 33.772> <-6.547, -11.250, 33.739> <-6.530, -11.245, 33.797> 
		<-6.727, -11.654, 33.784> <-6.670, -11.653, 33.806> <-6.547, -11.700, 33.777> <-6.530, -11.696, 33.835> 
		<-6.958, -12.211, 33.830> <-6.918, -12.250, 33.855> <-6.799, -12.307, 33.827> <-6.787, -12.314, 33.886> 
		<-7.246, -12.498, 33.854> <-7.206, -12.536, 33.879> <-7.119, -12.626, 33.853> <-7.107, -12.633, 33.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.727, -11.249, 33.751> <-6.735, -11.249, 33.747> <-6.722, -11.251, 33.725> <-6.730, -11.251, 33.721> 
		<-6.727, -10.843, 33.717> <-6.735, -10.843, 33.714> <-6.722, -10.846, 33.692> <-6.730, -10.846, 33.687> 
		<-6.958, -10.286, 33.671> <-6.964, -10.292, 33.668> <-6.955, -10.284, 33.645> <-6.961, -10.290, 33.641> 
		<-7.246, -9.999, 33.647> <-7.252, -10.005, 33.645> <-7.243, -9.998, 33.622> <-7.248, -10.004, 33.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.727, -11.249, 33.751> <-6.727, -11.654, 33.784> <-6.958, -12.211, 33.830> <-7.246, -12.498, 33.854> 
		<-6.735, -11.249, 33.747> <-6.735, -11.655, 33.781> <-6.964, -12.206, 33.827> <-7.252, -12.493, 33.850> 
		<-6.722, -11.251, 33.725> <-6.722, -11.656, 33.759> <-6.955, -12.217, 33.805> <-7.243, -12.504, 33.829> 
		<-6.730, -11.251, 33.721> <-6.730, -11.656, 33.754> <-6.961, -12.212, 33.800> <-7.248, -12.498, 33.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.195, -11.186, 34.506> <-7.195, -10.888, 34.481> <-7.366, -10.478, 34.447> <-7.577, -10.267, 34.430> 
		<-7.232, -11.206, 34.272> <-7.232, -10.907, 34.248> <-7.391, -10.523, 34.216> <-7.603, -10.312, 34.198> 
		<-7.215, -11.232, 33.954> <-7.215, -10.946, 33.930> <-7.388, -10.528, 33.896> <-7.591, -10.326, 33.879> 
		<-7.250, -11.251, 33.720> <-7.250, -10.965, 33.697> <-7.413, -10.573, 33.664> <-7.616, -10.370, 33.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.195, -11.186, 34.506> <-7.232, -11.206, 34.272> <-7.215, -11.232, 33.954> <-7.250, -11.251, 33.720> 
		<-7.195, -11.485, 34.530> <-7.232, -11.504, 34.297> <-7.215, -11.518, 33.978> <-7.250, -11.537, 33.744> 
		<-7.366, -11.895, 34.564> <-7.391, -11.888, 34.329> <-7.388, -11.935, 34.012> <-7.413, -11.930, 33.777> 
		<-7.577, -12.106, 34.582> <-7.603, -12.099, 34.346> <-7.591, -12.138, 34.029> <-7.616, -12.132, 33.793> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.484, -11.181, 34.566> <-6.465, -11.200, 34.336> <-6.464, -11.227, 34.019> <-6.530, -11.245, 33.797> 
		<-6.484, -10.720, 34.528> <-6.465, -10.739, 34.298> <-6.464, -10.776, 33.981> <-6.530, -10.794, 33.760> 
		<-6.748, -10.087, 34.475> <-6.734, -10.092, 34.244> <-6.740, -10.110, 33.926> <-6.787, -10.175, 33.709> 
		<-7.075, -9.761, 34.448> <-7.061, -9.766, 34.217> <-7.060, -9.792, 33.900> <-7.107, -9.856, 33.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.484, -11.181, 34.566> <-6.484, -11.642, 34.604> <-6.748, -12.275, 34.657> <-7.075, -12.602, 34.684> 
		<-6.465, -11.200, 34.336> <-6.465, -11.661, 34.374> <-6.734, -12.308, 34.427> <-7.061, -12.634, 34.454> 
		<-6.464, -11.227, 34.019> <-6.464, -11.677, 34.056> <-6.740, -12.343, 34.111> <-7.060, -12.661, 34.137> 
		<-6.530, -11.245, 33.797> <-6.530, -11.696, 33.835> <-6.787, -12.314, 33.886> <-7.107, -12.633, 33.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.853, -11.254, 33.682> <-6.853, -10.877, 33.651> <-7.068, -10.360, 33.608> <-7.335, -10.094, 33.586> 
		<-6.824, -11.252, 33.707> <-6.824, -10.875, 33.676> <-7.047, -10.337, 33.632> <-7.315, -10.071, 33.610> 
		<-6.764, -11.253, 33.702> <-6.764, -10.848, 33.669> <-6.985, -10.316, 33.625> <-7.272, -10.029, 33.601> 
		<-6.730, -11.251, 33.721> <-6.730, -10.846, 33.687> <-6.961, -10.290, 33.641> <-7.248, -10.004, 33.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.853, -11.254, 33.682> <-6.824, -11.252, 33.707> <-6.764, -11.253, 33.702> <-6.730, -11.251, 33.721> 
		<-6.853, -11.631, 33.713> <-6.824, -11.629, 33.739> <-6.764, -11.658, 33.736> <-6.730, -11.656, 33.754> 
		<-7.068, -12.149, 33.756> <-7.047, -12.167, 33.783> <-6.985, -12.190, 33.780> <-6.961, -12.212, 33.800> 
		<-7.335, -12.415, 33.778> <-7.315, -12.434, 33.805> <-7.272, -12.476, 33.804> <-7.248, -12.498, 33.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.853, -11.254, 33.682> <-6.889, -11.257, 33.650> <-6.919, -11.262, 33.589> <-6.934, -11.266, 33.544> 
		<-6.853, -10.877, 33.651> <-6.889, -10.880, 33.619> <-6.919, -10.904, 33.560> <-6.934, -10.908, 33.514> 
		<-7.068, -10.360, 33.608> <-7.094, -10.388, 33.579> <-7.128, -10.401, 33.518> <-7.139, -10.416, 33.473> 
		<-7.335, -10.094, 33.586> <-7.361, -10.122, 33.557> <-7.382, -10.148, 33.497> <-7.393, -10.163, 33.452> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.853, -11.254, 33.682> <-6.853, -11.631, 33.713> <-7.068, -12.149, 33.756> <-7.335, -12.415, 33.778> 
		<-6.889, -11.257, 33.650> <-6.889, -11.634, 33.682> <-7.094, -12.126, 33.722> <-7.361, -12.392, 33.744> 
		<-6.919, -11.262, 33.589> <-6.919, -11.620, 33.619> <-7.128, -12.123, 33.661> <-7.382, -12.376, 33.681> 
		<-6.934, -11.266, 33.544> <-6.934, -11.624, 33.573> <-7.139, -12.116, 33.614> <-7.393, -12.369, 33.635> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.934, -11.266, 33.544> <-6.950, -11.270, 33.498> <-6.938, -11.275, 33.430> <-6.955, -11.279, 33.385> 
		<-6.934, -10.908, 33.514> <-6.950, -10.911, 33.469> <-6.938, -10.922, 33.401> <-6.955, -10.926, 33.356> 
		<-7.139, -10.416, 33.473> <-7.150, -10.431, 33.429> <-7.145, -10.425, 33.360> <-7.157, -10.440, 33.316> 
		<-7.393, -10.163, 33.452> <-7.404, -10.177, 33.408> <-7.396, -10.175, 33.339> <-7.408, -10.191, 33.295> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.934, -11.266, 33.544> <-6.934, -11.624, 33.573> <-7.139, -12.116, 33.614> <-7.393, -12.369, 33.635> 
		<-6.950, -11.270, 33.498> <-6.950, -11.628, 33.528> <-7.150, -12.108, 33.568> <-7.404, -12.362, 33.589> 
		<-6.938, -11.275, 33.430> <-6.938, -11.629, 33.459> <-7.145, -12.126, 33.500> <-7.396, -12.376, 33.521> 
		<-6.955, -11.279, 33.385> <-6.955, -11.632, 33.414> <-7.157, -12.117, 33.454> <-7.408, -12.367, 33.475> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.999, -11.280, 33.375> <-6.999, -10.936, 33.347> <-7.195, -10.465, 33.308> <-7.438, -10.222, 33.288> 
		<-6.997, -11.279, 33.388> <-6.997, -10.935, 33.360> <-7.193, -10.462, 33.321> <-7.437, -10.219, 33.301> 
		<-6.960, -11.280, 33.373> <-6.960, -10.927, 33.343> <-7.160, -10.445, 33.304> <-7.411, -10.195, 33.283> 
		<-6.955, -11.279, 33.385> <-6.955, -10.926, 33.356> <-7.157, -10.440, 33.316> <-7.408, -10.191, 33.295> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.999, -11.280, 33.375> <-6.997, -11.279, 33.388> <-6.960, -11.280, 33.373> <-6.955, -11.279, 33.385> 
		<-6.999, -11.623, 33.404> <-6.997, -11.622, 33.417> <-6.960, -11.633, 33.402> <-6.955, -11.632, 33.414> 
		<-7.195, -12.095, 33.443> <-7.193, -12.095, 33.456> <-7.160, -12.115, 33.442> <-7.157, -12.117, 33.454> 
		<-7.438, -12.338, 33.463> <-7.437, -12.338, 33.476> <-7.411, -12.365, 33.462> <-7.408, -12.367, 33.475> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.999, -11.280, 33.375> <-7.045, -11.306, 33.056> <-7.028, -11.343, 32.617> <-7.113, -11.369, 32.305> 
		<-6.999, -10.936, 33.347> <-7.045, -10.963, 33.027> <-7.028, -11.025, 32.590> <-7.113, -11.051, 32.279> 
		<-7.195, -10.465, 33.308> <-7.227, -10.524, 32.991> <-7.234, -10.530, 32.549> <-7.294, -10.615, 32.242> 
		<-7.438, -10.222, 33.288> <-7.471, -10.281, 32.971> <-7.459, -10.306, 32.531> <-7.519, -10.391, 32.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.999, -11.280, 33.375> <-6.999, -11.623, 33.404> <-7.195, -12.095, 33.443> <-7.438, -12.338, 33.463> 
		<-7.045, -11.306, 33.056> <-7.045, -11.650, 33.084> <-7.227, -12.089, 33.121> <-7.471, -12.331, 33.141> 
		<-7.028, -11.343, 32.617> <-7.028, -11.660, 32.643> <-7.234, -12.155, 32.684> <-7.459, -12.380, 32.703> 
		<-7.113, -11.369, 32.305> <-7.113, -11.686, 32.332> <-7.294, -12.122, 32.368> <-7.519, -12.346, 32.387> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.440, -11.415, 31.742> <-7.440, -11.172, 31.722> <-7.579, -10.840, 31.693> <-7.751, -10.668, 31.679> 
		<-7.322, -11.402, 31.898> <-7.322, -11.159, 31.877> <-7.495, -10.743, 31.842> <-7.667, -10.572, 31.827> 
		<-7.164, -11.384, 32.117> <-7.164, -11.067, 32.090> <-7.330, -10.667, 32.057> <-7.555, -10.442, 32.038> 
		<-7.113, -11.369, 32.305> <-7.113, -11.051, 32.279> <-7.294, -10.615, 32.242> <-7.519, -10.391, 32.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.440, -11.415, 31.742> <-7.322, -11.402, 31.898> <-7.164, -11.384, 32.117> <-7.113, -11.369, 32.305> 
		<-7.440, -11.657, 31.763> <-7.322, -11.644, 31.918> <-7.164, -11.702, 32.143> <-7.113, -11.686, 32.332> 
		<-7.579, -11.990, 31.791> <-7.495, -12.061, 31.953> <-7.330, -12.101, 32.177> <-7.294, -12.122, 32.368> 
		<-7.751, -12.161, 31.806> <-7.667, -12.232, 31.968> <-7.555, -12.326, 32.195> <-7.519, -12.346, 32.387> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.440, -11.415, 31.742> <-7.514, -11.423, 31.646> <-7.649, -11.430, 31.553> <-7.744, -11.437, 31.478> 
		<-7.440, -11.172, 31.722> <-7.514, -11.180, 31.626> <-7.649, -11.257, 31.539> <-7.744, -11.264, 31.464> 
		<-7.579, -10.840, 31.693> <-7.630, -10.899, 31.602> <-7.776, -10.953, 31.513> <-7.843, -11.026, 31.444> 
		<-7.751, -10.668, 31.679> <-7.802, -10.727, 31.588> <-7.898, -10.831, 31.503> <-7.965, -10.904, 31.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.440, -11.415, 31.742> <-7.440, -11.657, 31.763> <-7.579, -11.990, 31.791> <-7.751, -12.161, 31.806> 
		<-7.514, -11.423, 31.646> <-7.514, -11.665, 31.667> <-7.631, -11.946, 31.691> <-7.803, -12.118, 31.705> 
		<-7.649, -11.430, 31.553> <-7.649, -11.604, 31.567> <-7.776, -11.908, 31.593> <-7.898, -12.030, 31.603> 
		<-7.744, -11.437, 31.478> <-7.744, -11.610, 31.492> <-7.843, -11.847, 31.512> <-7.965, -11.970, 31.522> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.750, -11.519, 30.482> <-7.750, -11.348, 30.467> <-7.848, -11.112, 30.448> <-7.970, -10.991, 30.438> 
		<-7.713, -11.514, 30.547> <-7.713, -11.342, 30.532> <-7.822, -11.080, 30.511> <-7.943, -10.959, 30.501> 
		<-7.645, -11.507, 30.633> <-7.645, -11.311, 30.617> <-7.756, -11.042, 30.594> <-7.895, -10.904, 30.583> 
		<-7.644, -11.500, 30.708> <-7.644, -11.305, 30.691> <-7.756, -11.036, 30.669> <-7.895, -10.897, 30.658> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.750, -11.519, 30.482> <-7.713, -11.514, 30.547> <-7.645, -11.507, 30.633> <-7.644, -11.500, 30.708> 
		<-7.750, -11.691, 30.496> <-7.713, -11.685, 30.561> <-7.645, -11.703, 30.649> <-7.644, -11.696, 30.724> 
		<-7.848, -11.926, 30.515> <-7.822, -11.947, 30.582> <-7.756, -11.971, 30.671> <-7.756, -11.965, 30.746> 
		<-7.970, -12.048, 30.525> <-7.943, -12.069, 30.593> <-7.895, -12.109, 30.683> <-7.895, -12.104, 30.758> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.750, -11.519, 30.482> <-7.756, -11.520, 30.471> <-7.783, -11.520, 30.474> <-7.785, -11.521, 30.462> 
		<-7.750, -11.348, 30.467> <-7.756, -11.348, 30.457> <-7.783, -11.356, 30.460> <-7.785, -11.357, 30.448> 
		<-7.848, -11.112, 30.448> <-7.852, -11.117, 30.438> <-7.877, -11.131, 30.441> <-7.878, -11.132, 30.429> 
		<-7.970, -10.991, 30.438> <-7.974, -10.996, 30.428> <-7.993, -11.015, 30.432> <-7.994, -11.017, 30.420> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.750, -11.519, 30.482> <-7.750, -11.691, 30.496> <-7.848, -11.926, 30.515> <-7.970, -12.048, 30.525> 
		<-7.756, -11.520, 30.471> <-7.756, -11.692, 30.485> <-7.852, -11.923, 30.505> <-7.974, -12.044, 30.515> 
		<-7.783, -11.520, 30.474> <-7.783, -11.684, 30.487> <-7.877, -11.909, 30.506> <-7.993, -12.025, 30.515> 
		<-7.785, -11.521, 30.462> <-7.785, -11.685, 30.475> <-7.878, -11.909, 30.494> <-7.994, -12.025, 30.503> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.744, -11.437, 31.478> <-7.752, -11.437, 31.472> <-7.771, -11.436, 31.483> <-7.778, -11.437, 31.475> 
		<-7.744, -11.264, 31.464> <-7.752, -11.264, 31.458> <-7.771, -11.271, 31.470> <-7.778, -11.272, 31.462> 
		<-7.843, -11.026, 31.444> <-7.848, -11.032, 31.438> <-7.867, -11.040, 31.451> <-7.872, -11.045, 31.443> 
		<-7.965, -10.904, 31.434> <-7.971, -10.910, 31.428> <-7.985, -10.923, 31.441> <-7.989, -10.928, 31.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.744, -11.437, 31.478> <-7.744, -11.610, 31.492> <-7.843, -11.847, 31.512> <-7.965, -11.970, 31.522> 
		<-7.752, -11.437, 31.472> <-7.752, -11.610, 31.486> <-7.848, -11.842, 31.505> <-7.971, -11.965, 31.515> 
		<-7.771, -11.436, 31.483> <-7.771, -11.602, 31.497> <-7.867, -11.833, 31.516> <-7.985, -11.950, 31.526> 
		<-7.778, -11.437, 31.475> <-7.778, -11.602, 31.489> <-7.872, -11.829, 31.508> <-7.989, -11.946, 31.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.841, -11.458, 31.224> <-7.841, -11.307, 31.211> <-7.927, -11.100, 31.194> <-8.034, -10.993, 31.185> 
		<-7.843, -11.452, 31.296> <-7.843, -11.301, 31.283> <-7.928, -11.096, 31.266> <-8.035, -10.989, 31.257> 
		<-7.783, -11.445, 31.381> <-7.783, -11.277, 31.368> <-7.874, -11.058, 31.349> <-7.993, -10.939, 31.340> 
		<-7.765, -11.439, 31.451> <-7.765, -11.271, 31.437> <-7.861, -11.040, 31.418> <-7.980, -10.921, 31.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.841, -11.458, 31.224> <-7.843, -11.452, 31.296> <-7.783, -11.445, 31.381> <-7.765, -11.439, 31.451> 
		<-7.841, -11.609, 31.236> <-7.843, -11.603, 31.308> <-7.783, -11.613, 31.395> <-7.765, -11.607, 31.465> 
		<-7.927, -11.816, 31.254> <-7.928, -11.808, 31.325> <-7.874, -11.831, 31.413> <-7.861, -11.838, 31.484> 
		<-8.034, -11.922, 31.262> <-8.035, -11.915, 31.334> <-7.993, -11.950, 31.423> <-7.980, -11.957, 31.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.841, -11.458, 31.224> <-7.838, -11.464, 31.146> <-7.768, -11.472, 31.056> <-7.750, -11.478, 30.980> 
		<-7.841, -11.307, 31.211> <-7.838, -11.313, 31.133> <-7.768, -11.300, 31.042> <-7.750, -11.306, 30.966> 
		<-7.927, -11.100, 31.194> <-7.925, -11.105, 31.116> <-7.861, -11.077, 31.023> <-7.848, -11.071, 30.946> 
		<-8.034, -10.993, 31.185> <-8.032, -10.998, 31.107> <-7.982, -10.956, 31.013> <-7.970, -10.949, 30.936> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.841, -11.458, 31.224> <-7.841, -11.609, 31.236> <-7.927, -11.816, 31.254> <-8.034, -11.922, 31.262> 
		<-7.838, -11.464, 31.146> <-7.838, -11.615, 31.158> <-7.925, -11.824, 31.176> <-8.032, -11.931, 31.184> 
		<-7.768, -11.472, 31.056> <-7.768, -11.643, 31.070> <-7.861, -11.866, 31.088> <-7.982, -11.988, 31.099> 
		<-7.750, -11.478, 30.980> <-7.750, -11.650, 30.994> <-7.848, -11.885, 31.014> <-7.970, -12.006, 31.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.750, -11.478, 30.980> <-7.748, -11.479, 30.969> <-7.778, -11.479, 30.967> <-7.778, -11.480, 30.957> 
		<-7.750, -11.306, 30.966> <-7.748, -11.307, 30.955> <-7.778, -11.314, 30.954> <-7.778, -11.315, 30.943> 
		<-7.848, -11.071, 30.946> <-7.846, -11.070, 30.936> <-7.872, -11.087, 30.935> <-7.872, -11.088, 30.924> 
		<-7.970, -10.949, 30.936> <-7.968, -10.949, 30.925> <-7.990, -10.970, 30.925> <-7.989, -10.971, 30.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.750, -11.478, 30.980> <-7.750, -11.650, 30.994> <-7.848, -11.885, 31.014> <-7.970, -12.006, 31.024> 
		<-7.748, -11.479, 30.969> <-7.748, -11.650, 30.984> <-7.846, -11.888, 31.003> <-7.968, -12.009, 31.013> 
		<-7.778, -11.479, 30.967> <-7.778, -11.644, 30.981> <-7.872, -11.871, 31.000> <-7.990, -11.988, 31.009> 
		<-7.778, -11.480, 30.957> <-7.778, -11.645, 30.970> <-7.872, -11.872, 30.989> <-7.989, -11.989, 30.999> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.644, -11.500, 30.708> <-7.644, -11.305, 30.691> <-7.756, -11.036, 30.669> <-7.895, -10.897, 30.658> 
		<-7.644, -11.494, 30.782> <-7.644, -11.299, 30.765> <-7.755, -11.029, 30.743> <-7.894, -10.891, 30.732> 
		<-7.712, -11.487, 30.867> <-7.712, -11.315, 30.853> <-7.820, -11.054, 30.831> <-7.943, -10.932, 30.821> 
		<-7.747, -11.482, 30.932> <-7.747, -11.310, 30.918> <-7.845, -11.073, 30.898> <-7.967, -10.951, 30.888> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.644, -11.500, 30.708> <-7.644, -11.494, 30.782> <-7.712, -11.487, 30.867> <-7.747, -11.482, 30.932> 
		<-7.644, -11.696, 30.724> <-7.644, -11.690, 30.798> <-7.712, -11.660, 30.881> <-7.747, -11.654, 30.946> 
		<-7.756, -11.965, 30.746> <-7.755, -11.959, 30.820> <-7.820, -11.921, 30.903> <-7.845, -11.891, 30.966> 
		<-7.895, -12.104, 30.758> <-7.894, -12.098, 30.832> <-7.943, -12.043, 30.913> <-7.967, -12.013, 30.976> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.785, -11.521, 30.462> <-7.786, -11.522, 30.450> <-7.755, -11.522, 30.446> <-7.755, -11.523, 30.434> 
		<-7.785, -11.357, 30.448> <-7.786, -11.358, 30.436> <-7.755, -11.352, 30.432> <-7.755, -11.353, 30.420> 
		<-7.878, -11.132, 30.429> <-7.879, -11.134, 30.417> <-7.852, -11.118, 30.413> <-7.852, -11.119, 30.401> 
		<-7.994, -11.017, 30.420> <-7.995, -11.019, 30.408> <-7.973, -10.997, 30.403> <-7.973, -10.998, 30.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.785, -11.521, 30.462> <-7.785, -11.685, 30.475> <-7.878, -11.909, 30.494> <-7.994, -12.025, 30.503> 
		<-7.786, -11.522, 30.450> <-7.786, -11.686, 30.463> <-7.879, -11.909, 30.482> <-7.995, -12.025, 30.491> 
		<-7.755, -11.522, 30.446> <-7.755, -11.693, 30.460> <-7.852, -11.926, 30.480> <-7.973, -12.047, 30.490> 
		<-7.755, -11.523, 30.434> <-7.755, -11.694, 30.448> <-7.852, -11.928, 30.468> <-7.973, -12.048, 30.478> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.755, -11.523, 30.434> <-7.745, -11.553, 30.075> <-7.748, -11.593, 29.595> <-7.750, -11.622, 29.236> 
		<-7.755, -11.353, 30.420> <-7.745, -11.382, 30.061> <-7.748, -11.421, 29.581> <-7.750, -11.451, 29.222> 
		<-7.852, -11.119, 30.401> <-7.845, -11.141, 30.041> <-7.847, -11.184, 29.562> <-7.848, -11.215, 29.202> 
		<-7.973, -10.998, 30.391> <-7.966, -11.021, 30.031> <-7.969, -11.063, 29.552> <-7.970, -11.094, 29.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.755, -11.523, 30.434> <-7.755, -11.694, 30.448> <-7.852, -11.928, 30.468> <-7.973, -12.048, 30.478> 
		<-7.745, -11.553, 30.075> <-7.745, -11.723, 30.089> <-7.845, -11.965, 30.109> <-7.966, -12.085, 30.119> 
		<-7.748, -11.593, 29.595> <-7.748, -11.764, 29.610> <-7.847, -12.001, 29.629> <-7.969, -12.122, 29.639> 
		<-7.750, -11.622, 29.236> <-7.750, -11.794, 29.250> <-7.848, -12.029, 29.270> <-7.970, -12.151, 29.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.766, -11.747, 27.729> <-7.766, -11.579, 27.715> <-7.862, -11.349, 27.696> <-7.981, -11.230, 27.686> 
		<-7.761, -11.710, 28.181> <-7.761, -11.542, 28.167> <-7.859, -11.308, 28.148> <-7.978, -11.189, 28.138> 
		<-7.752, -11.660, 28.784> <-7.752, -11.488, 28.769> <-7.849, -11.254, 28.750> <-7.971, -11.133, 28.740> 
		<-7.750, -11.622, 29.236> <-7.750, -11.451, 29.222> <-7.848, -11.215, 29.202> <-7.970, -11.094, 29.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.766, -11.747, 27.729> <-7.761, -11.710, 28.181> <-7.752, -11.660, 28.784> <-7.750, -11.622, 29.236> 
		<-7.766, -11.915, 27.743> <-7.761, -11.877, 28.195> <-7.752, -11.831, 28.798> <-7.750, -11.794, 29.250> 
		<-7.862, -12.145, 27.762> <-7.859, -12.111, 28.214> <-7.849, -12.066, 28.817> <-7.848, -12.029, 29.270> 
		<-7.981, -12.264, 27.771> <-7.978, -12.230, 28.224> <-7.971, -12.187, 28.827> <-7.970, -12.151, 29.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.250, -11.251, 33.720> <-7.250, -10.965, 33.697> <-7.413, -10.573, 33.664> <-7.616, -10.370, 33.648> 
		<-7.318, -11.289, 33.269> <-7.318, -11.003, 33.245> <-7.461, -10.658, 33.217> <-7.664, -10.456, 33.200> 
		<-7.367, -11.340, 32.649> <-7.367, -11.120, 32.631> <-7.543, -10.697, 32.596> <-7.699, -10.542, 32.583> 
		<-7.539, -11.375, 32.226> <-7.539, -11.155, 32.207> <-7.665, -10.854, 32.182> <-7.821, -10.698, 32.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.250, -11.251, 33.720> <-7.318, -11.289, 33.269> <-7.367, -11.340, 32.649> <-7.539, -11.375, 32.226> 
		<-7.250, -11.537, 33.744> <-7.318, -11.575, 33.293> <-7.367, -11.560, 32.667> <-7.539, -11.595, 32.244> 
		<-7.413, -11.930, 33.777> <-7.461, -11.919, 33.321> <-7.543, -11.983, 32.702> <-7.665, -11.896, 32.269> 
		<-7.616, -12.132, 33.793> <-7.664, -12.121, 33.338> <-7.699, -12.138, 32.715> <-7.821, -12.052, 32.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.539, -11.375, 32.226> <-7.539, -11.155, 32.207> <-7.665, -10.854, 32.182> <-7.821, -10.698, 32.169> 
		<-7.621, -11.392, 32.026> <-7.621, -11.172, 32.007> <-7.722, -10.927, 31.987> <-7.878, -10.772, 31.974> 
		<-8.044, -11.398, 31.943> <-8.044, -11.297, 31.934> <-8.106, -11.148, 31.921> <-8.178, -11.077, 31.915> 
		<-8.060, -11.416, 31.727> <-8.060, -11.315, 31.719> <-8.118, -11.177, 31.707> <-8.189, -11.106, 31.701> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.539, -11.375, 32.226> <-7.621, -11.392, 32.026> <-8.044, -11.398, 31.943> <-8.060, -11.416, 31.727> 
		<-7.539, -11.595, 32.244> <-7.621, -11.611, 32.044> <-8.044, -11.499, 31.951> <-8.060, -11.517, 31.736> 
		<-7.665, -11.896, 32.269> <-7.722, -11.856, 32.064> <-8.106, -11.648, 31.964> <-8.118, -11.655, 31.748> 
		<-7.821, -12.052, 32.282> <-7.878, -12.011, 32.077> <-8.178, -11.719, 31.970> <-8.189, -11.726, 31.754> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.875, -11.747, 27.725> <-7.930, -11.648, 28.925> <-8.149, -11.515, 30.529> <-8.060, -11.416, 31.727> 
		<-7.875, -11.604, 27.713> <-7.930, -11.505, 28.914> <-8.149, -11.414, 30.520> <-8.060, -11.315, 31.719> 
		<-7.956, -11.408, 27.697> <-7.996, -11.348, 28.900> <-8.181, -11.339, 30.514> <-8.118, -11.177, 31.707> 
		<-8.058, -11.307, 27.688> <-8.097, -11.246, 28.892> <-8.252, -11.268, 30.508> <-8.189, -11.106, 31.701> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.875, -11.747, 27.725> <-7.875, -11.890, 27.737> <-7.956, -12.087, 27.753> <-8.058, -12.188, 27.761> 
		<-7.930, -11.648, 28.925> <-7.930, -11.791, 28.937> <-7.996, -11.948, 28.951> <-8.097, -12.049, 28.959> 
		<-8.149, -11.515, 30.529> <-8.149, -11.616, 30.537> <-8.181, -11.691, 30.543> <-8.252, -11.762, 30.549> 
		<-8.060, -11.416, 31.727> <-8.060, -11.517, 31.736> <-8.118, -11.655, 31.748> <-8.189, -11.726, 31.754> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.778, -11.480, 30.957> <-7.777, -11.481, 30.945> <-7.752, -11.481, 30.942> <-7.747, -11.482, 30.932> 
		<-7.778, -11.315, 30.943> <-7.777, -11.316, 30.931> <-7.752, -11.309, 30.928> <-7.747, -11.310, 30.918> 
		<-7.872, -11.088, 30.924> <-7.871, -11.088, 30.912> <-7.849, -11.076, 30.909> <-7.845, -11.073, 30.898> 
		<-7.989, -10.971, 30.914> <-7.989, -10.971, 30.903> <-7.971, -10.954, 30.899> <-7.967, -10.951, 30.888> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.778, -11.480, 30.957> <-7.778, -11.645, 30.970> <-7.872, -11.872, 30.989> <-7.989, -11.989, 30.999> 
		<-7.777, -11.481, 30.945> <-7.777, -11.646, 30.959> <-7.871, -11.874, 30.977> <-7.989, -11.991, 30.987> 
		<-7.752, -11.481, 30.942> <-7.752, -11.653, 30.957> <-7.849, -11.886, 30.976> <-7.971, -12.008, 30.986> 
		<-7.747, -11.482, 30.932> <-7.747, -11.654, 30.946> <-7.845, -11.891, 30.966> <-7.967, -12.013, 30.976> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.778, -11.437, 31.475> <-7.783, -11.437, 31.469> <-7.763, -11.438, 31.459> <-7.765, -11.439, 31.451> 
		<-7.778, -11.272, 31.462> <-7.783, -11.272, 31.455> <-7.763, -11.270, 31.445> <-7.765, -11.271, 31.437> 
		<-7.872, -11.045, 31.443> <-7.875, -11.049, 31.437> <-7.860, -11.038, 31.426> <-7.861, -11.040, 31.418> 
		<-7.989, -10.928, 31.433> <-7.993, -10.932, 31.427> <-7.979, -10.919, 31.416> <-7.980, -10.921, 31.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.778, -11.437, 31.475> <-7.778, -11.602, 31.489> <-7.872, -11.829, 31.508> <-7.989, -11.946, 31.518> 
		<-7.783, -11.437, 31.469> <-7.783, -11.603, 31.483> <-7.875, -11.826, 31.501> <-7.993, -11.943, 31.511> 
		<-7.763, -11.438, 31.459> <-7.763, -11.606, 31.473> <-7.860, -11.839, 31.492> <-7.979, -11.957, 31.502> 
		<-7.765, -11.439, 31.451> <-7.765, -11.607, 31.465> <-7.861, -11.838, 31.484> <-7.980, -11.957, 31.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.058, -12.188, 27.761> <-8.159, -12.289, 27.770> <-8.356, -12.371, 27.776> <-8.500, -12.371, 27.776> 
		<-8.097, -12.049, 28.959> <-8.199, -12.151, 28.967> <-8.356, -12.216, 28.973> <-8.500, -12.216, 28.973> 
		<-8.252, -11.762, 30.549> <-8.324, -11.833, 30.556> <-8.399, -11.864, 30.558> <-8.500, -11.864, 30.558> 
		<-8.189, -11.726, 31.754> <-8.260, -11.797, 31.760> <-8.399, -11.854, 31.765> <-8.500, -11.854, 31.765> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.371, 27.776> <-8.644, -12.371, 27.776> <-8.841, -12.289, 27.770> <-8.942, -12.188, 27.761> 
		<-8.500, -12.216, 28.973> <-8.644, -12.216, 28.973> <-8.801, -12.151, 28.967> <-8.903, -12.049, 28.959> 
		<-8.500, -11.864, 30.558> <-8.601, -11.864, 30.558> <-8.676, -11.833, 30.556> <-8.748, -11.762, 30.549> 
		<-8.500, -11.854, 31.765> <-8.601, -11.854, 31.765> <-8.740, -11.797, 31.760> <-8.811, -11.726, 31.754> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.942, -12.188, 27.761> <-9.044, -12.087, 27.753> <-9.125, -11.890, 27.737> <-9.125, -11.747, 27.725> 
		<-8.903, -12.049, 28.959> <-9.004, -11.948, 28.951> <-9.070, -11.791, 28.937> <-9.070, -11.648, 28.925> 
		<-8.748, -11.762, 30.549> <-8.819, -11.691, 30.543> <-8.851, -11.616, 30.537> <-8.851, -11.515, 30.529> 
		<-8.811, -11.726, 31.754> <-8.882, -11.655, 31.748> <-8.940, -11.517, 31.736> <-8.940, -11.416, 31.727> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.125, -11.747, 27.725> <-9.125, -11.604, 27.713> <-9.044, -11.408, 27.697> <-8.942, -11.307, 27.688> 
		<-9.070, -11.648, 28.925> <-9.070, -11.505, 28.914> <-9.004, -11.348, 28.900> <-8.903, -11.246, 28.892> 
		<-8.851, -11.515, 30.529> <-8.851, -11.414, 30.520> <-8.819, -11.339, 30.514> <-8.748, -11.268, 30.508> 
		<-8.940, -11.416, 31.727> <-8.940, -11.315, 31.719> <-8.882, -11.177, 31.707> <-8.811, -11.106, 31.701> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.942, -11.307, 27.688> <-8.841, -11.205, 27.680> <-8.644, -11.124, 27.673> <-8.500, -11.124, 27.673> 
		<-8.903, -11.246, 28.892> <-8.801, -11.145, 28.884> <-8.644, -11.080, 28.878> <-8.500, -11.080, 28.878> 
		<-8.748, -11.268, 30.508> <-8.676, -11.197, 30.502> <-8.601, -11.166, 30.499> <-8.500, -11.166, 30.499> 
		<-8.811, -11.106, 31.701> <-8.740, -11.035, 31.695> <-8.601, -10.978, 31.690> <-8.500, -10.978, 31.690> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -11.124, 27.673> <-8.356, -11.124, 27.673> <-8.159, -11.205, 27.680> <-8.058, -11.307, 27.688> 
		<-8.500, -11.080, 28.878> <-8.356, -11.080, 28.878> <-8.199, -11.145, 28.884> <-8.097, -11.246, 28.892> 
		<-8.500, -11.166, 30.499> <-8.399, -11.166, 30.499> <-8.324, -11.197, 30.502> <-8.252, -11.268, 30.508> 
		<-8.500, -10.978, 31.690> <-8.399, -10.978, 31.690> <-8.260, -11.035, 31.695> <-8.189, -11.106, 31.701> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.189, -11.726, 31.754> <-8.260, -11.797, 31.760> <-8.399, -11.854, 31.765> <-8.500, -11.854, 31.765> 
		<-8.178, -11.719, 31.970> <-8.249, -11.790, 31.976> <-8.399, -11.852, 31.981> <-8.500, -11.852, 31.981> 
		<-7.878, -12.011, 32.077> <-8.034, -12.167, 32.090> <-8.279, -12.268, 32.099> <-8.500, -12.268, 32.099> 
		<-7.821, -12.052, 32.282> <-7.977, -12.207, 32.295> <-8.279, -12.332, 32.305> <-8.500, -12.332, 32.305> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -11.854, 31.765> <-8.601, -11.854, 31.765> <-8.740, -11.797, 31.760> <-8.811, -11.726, 31.754> 
		<-8.500, -11.852, 31.981> <-8.601, -11.852, 31.981> <-8.751, -11.790, 31.976> <-8.822, -11.719, 31.970> 
		<-8.500, -12.268, 32.099> <-8.721, -12.268, 32.099> <-8.966, -12.167, 32.090> <-9.122, -12.011, 32.077> 
		<-8.500, -12.332, 32.305> <-8.721, -12.332, 32.305> <-9.023, -12.207, 32.295> <-9.179, -12.052, 32.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.811, -11.726, 31.754> <-8.882, -11.655, 31.748> <-8.940, -11.517, 31.736> <-8.940, -11.416, 31.727> 
		<-8.822, -11.719, 31.970> <-8.894, -11.648, 31.964> <-8.956, -11.499, 31.951> <-8.956, -11.398, 31.943> 
		<-9.122, -12.011, 32.077> <-9.278, -11.856, 32.064> <-9.379, -11.611, 32.044> <-9.379, -11.392, 32.026> 
		<-9.179, -12.052, 32.282> <-9.335, -11.896, 32.269> <-9.461, -11.595, 32.244> <-9.461, -11.375, 32.226> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.940, -11.416, 31.727> <-8.940, -11.315, 31.719> <-8.882, -11.177, 31.707> <-8.811, -11.106, 31.701> 
		<-8.956, -11.398, 31.943> <-8.956, -11.297, 31.934> <-8.894, -11.148, 31.921> <-8.822, -11.077, 31.915> 
		<-9.379, -11.392, 32.026> <-9.379, -11.172, 32.007> <-9.278, -10.927, 31.987> <-9.122, -10.772, 31.974> 
		<-9.461, -11.375, 32.226> <-9.461, -11.155, 32.207> <-9.335, -10.854, 32.182> <-9.179, -10.698, 32.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.811, -11.106, 31.701> <-8.740, -11.035, 31.695> <-8.601, -10.978, 31.690> <-8.500, -10.978, 31.690> 
		<-8.822, -11.077, 31.915> <-8.751, -11.006, 31.909> <-8.601, -10.944, 31.904> <-8.500, -10.944, 31.904> 
		<-9.122, -10.772, 31.974> <-8.966, -10.617, 31.961> <-8.721, -10.515, 31.952> <-8.500, -10.515, 31.952> 
		<-9.179, -10.698, 32.169> <-9.023, -10.543, 32.156> <-8.721, -10.418, 32.146> <-8.500, -10.418, 32.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.978, 31.690> <-8.399, -10.978, 31.690> <-8.260, -11.035, 31.695> <-8.189, -11.106, 31.701> 
		<-8.500, -10.944, 31.904> <-8.399, -10.944, 31.904> <-8.249, -11.006, 31.909> <-8.178, -11.077, 31.915> 
		<-8.500, -10.515, 31.952> <-8.279, -10.515, 31.952> <-8.034, -10.617, 31.961> <-7.878, -10.772, 31.974> 
		<-8.500, -10.418, 32.146> <-8.279, -10.418, 32.146> <-7.977, -10.543, 32.156> <-7.821, -10.698, 32.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.821, -12.052, 32.282> <-7.977, -12.207, 32.295> <-8.279, -12.332, 32.305> <-8.500, -12.332, 32.305> 
		<-7.699, -12.138, 32.715> <-7.855, -12.294, 32.728> <-8.279, -12.469, 32.743> <-8.500, -12.469, 32.743> 
		<-7.664, -12.121, 33.338> <-7.867, -12.324, 33.355> <-8.213, -12.466, 33.366> <-8.500, -12.466, 33.366> 
		<-7.616, -12.132, 33.793> <-7.819, -12.334, 33.810> <-8.213, -12.497, 33.824> <-8.500, -12.497, 33.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.332, 32.305> <-8.721, -12.332, 32.305> <-9.023, -12.207, 32.295> <-9.179, -12.052, 32.282> 
		<-8.500, -12.469, 32.743> <-8.721, -12.469, 32.743> <-9.145, -12.294, 32.728> <-9.301, -12.138, 32.715> 
		<-8.500, -12.466, 33.366> <-8.787, -12.466, 33.366> <-9.133, -12.324, 33.355> <-9.336, -12.121, 33.338> 
		<-8.500, -12.497, 33.824> <-8.787, -12.497, 33.824> <-9.181, -12.334, 33.810> <-9.384, -12.132, 33.793> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.179, -12.052, 32.282> <-9.335, -11.896, 32.269> <-9.461, -11.595, 32.244> <-9.461, -11.375, 32.226> 
		<-9.301, -12.138, 32.715> <-9.457, -11.983, 32.702> <-9.633, -11.560, 32.667> <-9.633, -11.340, 32.649> 
		<-9.336, -12.121, 33.338> <-9.539, -11.919, 33.321> <-9.682, -11.575, 33.293> <-9.682, -11.289, 33.269> 
		<-9.384, -12.132, 33.793> <-9.587, -11.930, 33.777> <-9.750, -11.537, 33.744> <-9.750, -11.251, 33.720> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.461, -11.375, 32.226> <-9.461, -11.155, 32.207> <-9.335, -10.854, 32.182> <-9.179, -10.698, 32.169> 
		<-9.633, -11.340, 32.649> <-9.633, -11.120, 32.631> <-9.457, -10.697, 32.596> <-9.301, -10.542, 32.583> 
		<-9.682, -11.289, 33.269> <-9.682, -11.003, 33.245> <-9.539, -10.658, 33.217> <-9.336, -10.456, 33.200> 
		<-9.750, -11.251, 33.720> <-9.750, -10.965, 33.697> <-9.587, -10.573, 33.664> <-9.384, -10.370, 33.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.179, -10.698, 32.169> <-9.023, -10.543, 32.156> <-8.721, -10.418, 32.146> <-8.500, -10.418, 32.146> 
		<-9.301, -10.542, 32.583> <-9.145, -10.387, 32.570> <-8.721, -10.211, 32.555> <-8.500, -10.211, 32.555> 
		<-9.336, -10.456, 33.200> <-9.133, -10.254, 33.183> <-8.787, -10.111, 33.171> <-8.500, -10.111, 33.171> 
		<-9.384, -10.370, 33.648> <-9.181, -10.168, 33.631> <-8.787, -10.005, 33.617> <-8.500, -10.005, 33.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.418, 32.146> <-8.279, -10.418, 32.146> <-7.977, -10.543, 32.156> <-7.821, -10.698, 32.169> 
		<-8.500, -10.211, 32.555> <-8.279, -10.211, 32.555> <-7.855, -10.387, 32.570> <-7.699, -10.542, 32.583> 
		<-8.500, -10.111, 33.171> <-8.213, -10.111, 33.171> <-7.867, -10.254, 33.183> <-7.664, -10.456, 33.200> 
		<-8.500, -10.005, 33.617> <-8.213, -10.005, 33.617> <-7.819, -10.168, 33.631> <-7.616, -10.370, 33.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.616, -12.132, 33.793> <-7.819, -12.334, 33.810> <-8.213, -12.497, 33.824> <-8.500, -12.497, 33.824> 
		<-7.591, -12.138, 34.029> <-7.794, -12.340, 34.046> <-8.213, -12.513, 34.060> <-8.500, -12.513, 34.060> 
		<-7.603, -12.099, 34.346> <-7.815, -12.310, 34.364> <-8.200, -12.469, 34.377> <-8.500, -12.469, 34.377> 
		<-7.577, -12.106, 34.582> <-7.789, -12.317, 34.599> <-8.200, -12.487, 34.613> <-8.500, -12.487, 34.613> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.497, 33.824> <-8.787, -12.497, 33.824> <-9.181, -12.334, 33.810> <-9.384, -12.132, 33.793> 
		<-8.500, -12.513, 34.060> <-8.787, -12.513, 34.060> <-9.206, -12.340, 34.046> <-9.409, -12.138, 34.029> 
		<-8.500, -12.469, 34.377> <-8.800, -12.469, 34.377> <-9.185, -12.310, 34.364> <-9.397, -12.099, 34.346> 
		<-8.500, -12.487, 34.613> <-8.800, -12.487, 34.613> <-9.211, -12.317, 34.599> <-9.423, -12.106, 34.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.384, -12.132, 33.793> <-9.587, -11.930, 33.777> <-9.750, -11.537, 33.744> <-9.750, -11.251, 33.720> 
		<-9.409, -12.138, 34.029> <-9.612, -11.935, 34.012> <-9.785, -11.518, 33.978> <-9.785, -11.232, 33.954> 
		<-9.397, -12.099, 34.346> <-9.609, -11.888, 34.329> <-9.768, -11.504, 34.297> <-9.768, -11.206, 34.272> 
		<-9.423, -12.106, 34.582> <-9.634, -11.895, 34.564> <-9.805, -11.485, 34.530> <-9.805, -11.186, 34.506> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.750, -11.251, 33.720> <-9.750, -10.965, 33.697> <-9.587, -10.573, 33.664> <-9.384, -10.370, 33.648> 
		<-9.785, -11.232, 33.954> <-9.785, -10.946, 33.930> <-9.612, -10.528, 33.896> <-9.409, -10.326, 33.879> 
		<-9.768, -11.206, 34.272> <-9.768, -10.907, 34.248> <-9.609, -10.523, 34.216> <-9.397, -10.312, 34.198> 
		<-9.805, -11.186, 34.506> <-9.805, -10.888, 34.481> <-9.634, -10.478, 34.447> <-9.423, -10.267, 34.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.384, -10.370, 33.648> <-9.181, -10.168, 33.631> <-8.787, -10.005, 33.617> <-8.500, -10.005, 33.617> 
		<-9.409, -10.326, 33.879> <-9.206, -10.124, 33.862> <-8.787, -9.951, 33.848> <-8.500, -9.951, 33.848> 
		<-9.397, -10.312, 34.198> <-9.185, -10.101, 34.181> <-8.800, -9.942, 34.168> <-8.500, -9.942, 34.168> 
		<-9.423, -10.267, 34.430> <-9.211, -10.056, 34.412> <-8.800, -9.886, 34.398> <-8.500, -9.886, 34.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.005, 33.617> <-8.213, -10.005, 33.617> <-7.819, -10.168, 33.631> <-7.616, -10.370, 33.648> 
		<-8.500, -9.951, 33.848> <-8.213, -9.951, 33.848> <-7.794, -10.124, 33.862> <-7.591, -10.326, 33.879> 
		<-8.500, -9.942, 34.168> <-8.200, -9.942, 34.168> <-7.815, -10.101, 34.181> <-7.603, -10.312, 34.198> 
		<-8.500, -9.886, 34.398> <-8.200, -9.886, 34.398> <-7.789, -10.056, 34.412> <-7.577, -10.267, 34.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.577, -12.106, 34.582> <-7.789, -12.317, 34.599> <-8.200, -12.487, 34.613> <-8.500, -12.487, 34.613> 
		<-7.571, -12.107, 34.643> <-7.783, -12.318, 34.661> <-8.200, -12.491, 34.675> <-8.500, -12.491, 34.675> 
		<-7.551, -12.119, 34.746> <-7.778, -12.346, 34.764> <-8.178, -12.511, 34.778> <-8.500, -12.511, 34.778> 
		<-7.509, -12.159, 34.769> <-7.737, -12.385, 34.787> <-8.178, -12.568, 34.802> <-8.500, -12.568, 34.802> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.487, 34.613> <-8.800, -12.487, 34.613> <-9.211, -12.317, 34.599> <-9.423, -12.106, 34.582> 
		<-8.500, -12.491, 34.675> <-8.800, -12.491, 34.675> <-9.217, -12.318, 34.661> <-9.429, -12.107, 34.643> 
		<-8.500, -12.511, 34.778> <-8.822, -12.511, 34.778> <-9.222, -12.346, 34.764> <-9.449, -12.119, 34.746> 
		<-8.500, -12.568, 34.802> <-8.822, -12.568, 34.802> <-9.263, -12.385, 34.787> <-9.491, -12.159, 34.769> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.423, -12.106, 34.582> <-9.634, -11.895, 34.564> <-9.805, -11.485, 34.530> <-9.805, -11.186, 34.506> 
		<-9.429, -12.107, 34.643> <-9.641, -11.896, 34.626> <-9.814, -11.480, 34.591> <-9.814, -11.181, 34.567> 
		<-9.449, -12.119, 34.746> <-9.677, -11.892, 34.727> <-9.843, -11.493, 34.694> <-9.843, -11.173, 34.667> 
		<-9.491, -12.159, 34.769> <-9.718, -11.932, 34.750> <-9.901, -11.492, 34.713> <-9.901, -11.171, 34.687> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.805, -11.186, 34.506> <-9.805, -10.888, 34.481> <-9.634, -10.478, 34.447> <-9.423, -10.267, 34.430> 
		<-9.814, -11.181, 34.567> <-9.814, -10.883, 34.542> <-9.641, -10.466, 34.507> <-9.429, -10.255, 34.490> 
		<-9.843, -11.173, 34.667> <-9.843, -10.852, 34.641> <-9.677, -10.453, 34.608> <-9.449, -10.227, 34.589> 
		<-9.901, -11.171, 34.687> <-9.901, -10.851, 34.660> <-9.718, -10.410, 34.624> <-9.491, -10.184, 34.605> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.423, -10.267, 34.430> <-9.211, -10.056, 34.412> <-8.800, -9.886, 34.398> <-8.500, -9.886, 34.398> 
		<-9.429, -10.255, 34.490> <-9.217, -10.044, 34.472> <-8.800, -9.871, 34.458> <-8.500, -9.871, 34.458> 
		<-9.449, -10.227, 34.589> <-9.222, -10.000, 34.570> <-8.822, -9.835, 34.557> <-8.500, -9.835, 34.557> 
		<-9.491, -10.184, 34.605> <-9.263, -9.957, 34.586> <-8.822, -9.775, 34.571> <-8.500, -9.775, 34.571> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.886, 34.398> <-8.200, -9.886, 34.398> <-7.789, -10.056, 34.412> <-7.577, -10.267, 34.430> 
		<-8.500, -9.871, 34.458> <-8.200, -9.871, 34.458> <-7.783, -10.044, 34.472> <-7.571, -10.255, 34.490> 
		<-8.500, -9.835, 34.557> <-8.178, -9.835, 34.557> <-7.778, -10.000, 34.570> <-7.551, -10.227, 34.589> 
		<-8.500, -9.775, 34.571> <-8.178, -9.775, 34.571> <-7.737, -9.957, 34.586> <-7.509, -10.184, 34.605> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.509, -12.159, 34.769> <-7.737, -12.385, 34.787> <-8.178, -12.568, 34.802> <-8.500, -12.568, 34.802> 
		<-7.410, -12.254, 34.824> <-7.637, -12.480, 34.842> <-8.178, -12.704, 34.861> <-8.500, -12.704, 34.861> 
		<-7.263, -12.400, 34.833> <-7.571, -12.707, 34.858> <-8.065, -12.911, 34.875> <-8.500, -12.911, 34.875> 
		<-7.161, -12.505, 34.812> <-7.468, -12.811, 34.838> <-8.065, -13.058, 34.858> <-8.500, -13.058, 34.858> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.568, 34.802> <-8.822, -12.568, 34.802> <-9.263, -12.385, 34.787> <-9.491, -12.159, 34.769> 
		<-8.500, -12.704, 34.861> <-8.822, -12.704, 34.861> <-9.363, -12.480, 34.842> <-9.590, -12.254, 34.824> 
		<-8.500, -12.911, 34.875> <-8.935, -12.911, 34.875> <-9.429, -12.707, 34.858> <-9.737, -12.400, 34.833> 
		<-8.500, -13.058, 34.858> <-8.935, -13.058, 34.858> <-9.532, -12.811, 34.838> <-9.839, -12.505, 34.812> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.491, -12.159, 34.769> <-9.718, -11.932, 34.750> <-9.901, -11.492, 34.713> <-9.901, -11.171, 34.687> 
		<-9.590, -12.254, 34.824> <-9.818, -12.027, 34.805> <-10.042, -11.488, 34.760> <-10.042, -11.167, 34.734> 
		<-9.737, -12.400, 34.833> <-10.044, -12.094, 34.807> <-10.249, -11.601, 34.766> <-10.249, -11.168, 34.731> 
		<-9.839, -12.505, 34.812> <-10.147, -12.198, 34.787> <-10.394, -11.603, 34.738> <-10.394, -11.170, 34.702> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.901, -11.171, 34.687> <-9.901, -10.851, 34.660> <-9.718, -10.410, 34.624> <-9.491, -10.184, 34.605> 
		<-10.042, -11.167, 34.734> <-10.042, -10.847, 34.707> <-9.818, -10.308, 34.663> <-9.590, -10.081, 34.644> 
		<-10.249, -11.168, 34.731> <-10.249, -10.734, 34.695> <-10.044, -10.242, 34.654> <-9.737, -9.935, 34.629> 
		<-10.394, -11.170, 34.702> <-10.394, -10.737, 34.666> <-10.147, -10.142, 34.617> <-9.839, -9.835, 34.592> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.491, -10.184, 34.605> <-9.263, -9.957, 34.586> <-8.822, -9.775, 34.571> <-8.500, -9.775, 34.571> 
		<-9.590, -10.081, 34.644> <-9.363, -9.854, 34.625> <-8.822, -9.631, 34.607> <-8.500, -9.631, 34.607> 
		<-9.737, -9.935, 34.629> <-9.429, -9.629, 34.603> <-8.935, -9.425, 34.586> <-8.500, -9.425, 34.586> 
		<-9.839, -9.835, 34.592> <-9.532, -9.529, 34.566> <-8.935, -9.282, 34.546> <-8.500, -9.282, 34.546> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.775, 34.571> <-8.178, -9.775, 34.571> <-7.737, -9.957, 34.586> <-7.509, -10.184, 34.605> 
		<-8.500, -9.631, 34.607> <-8.178, -9.631, 34.607> <-7.637, -9.854, 34.625> <-7.410, -10.081, 34.644> 
		<-8.500, -9.425, 34.586> <-8.065, -9.425, 34.586> <-7.571, -9.629, 34.603> <-7.263, -9.935, 34.629> 
		<-8.500, -9.282, 34.546> <-8.065, -9.282, 34.546> <-7.468, -9.529, 34.566> <-7.161, -9.835, 34.592> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.161, -12.505, 34.812> <-7.468, -12.811, 34.838> <-8.065, -13.058, 34.858> <-8.500, -13.058, 34.858> 
		<-7.123, -12.544, 34.805> <-7.430, -12.850, 34.830> <-8.065, -13.112, 34.852> <-8.500, -13.112, 34.852> 
		<-7.078, -12.594, 34.738> <-7.405, -12.920, 34.765> <-8.037, -13.181, 34.786> <-8.500, -13.181, 34.786> 
		<-7.075, -12.602, 34.684> <-7.402, -12.928, 34.710> <-8.037, -13.190, 34.732> <-8.500, -13.190, 34.732> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.058, 34.858> <-8.935, -13.058, 34.858> <-9.532, -12.811, 34.838> <-9.839, -12.505, 34.812> 
		<-8.500, -13.112, 34.852> <-8.935, -13.112, 34.852> <-9.570, -12.850, 34.830> <-9.877, -12.544, 34.805> 
		<-8.500, -13.181, 34.786> <-8.963, -13.181, 34.786> <-9.595, -12.920, 34.765> <-9.922, -12.594, 34.738> 
		<-8.500, -13.190, 34.732> <-8.963, -13.190, 34.732> <-9.598, -12.928, 34.710> <-9.925, -12.602, 34.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.839, -12.505, 34.812> <-10.147, -12.198, 34.787> <-10.394, -11.603, 34.738> <-10.394, -11.170, 34.702> 
		<-9.877, -12.544, 34.805> <-10.185, -12.237, 34.780> <-10.448, -11.604, 34.727> <-10.448, -11.171, 34.691> 
		<-9.922, -12.594, 34.738> <-10.249, -12.268, 34.711> <-10.511, -11.638, 34.659> <-10.511, -11.177, 34.620> 
		<-9.925, -12.602, 34.684> <-10.252, -12.275, 34.657> <-10.516, -11.642, 34.604> <-10.516, -11.181, 34.566> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.394, -11.170, 34.702> <-10.394, -10.737, 34.666> <-10.147, -10.142, 34.617> <-9.839, -9.835, 34.592> 
		<-10.448, -11.171, 34.691> <-10.448, -10.737, 34.656> <-10.185, -10.105, 34.603> <-9.877, -9.798, 34.578> 
		<-10.511, -11.177, 34.620> <-10.511, -10.716, 34.582> <-10.249, -10.086, 34.530> <-9.922, -9.760, 34.503> 
		<-10.516, -11.181, 34.566> <-10.516, -10.720, 34.528> <-10.252, -10.087, 34.475> <-9.925, -9.761, 34.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.839, -9.835, 34.592> <-9.532, -9.529, 34.566> <-8.935, -9.282, 34.546> <-8.500, -9.282, 34.546> 
		<-9.877, -9.798, 34.578> <-9.570, -9.492, 34.552> <-8.935, -9.230, 34.531> <-8.500, -9.230, 34.531> 
		<-9.922, -9.760, 34.503> <-9.595, -9.433, 34.476> <-8.963, -9.173, 34.455> <-8.500, -9.173, 34.455> 
		<-9.925, -9.761, 34.448> <-9.598, -9.435, 34.421> <-8.963, -9.173, 34.400> <-8.500, -9.173, 34.400> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.282, 34.546> <-8.065, -9.282, 34.546> <-7.468, -9.529, 34.566> <-7.161, -9.835, 34.592> 
		<-8.500, -9.230, 34.531> <-8.065, -9.230, 34.531> <-7.430, -9.492, 34.552> <-7.123, -9.798, 34.578> 
		<-8.500, -9.173, 34.455> <-8.037, -9.173, 34.455> <-7.405, -9.433, 34.476> <-7.078, -9.760, 34.503> 
		<-8.500, -9.173, 34.400> <-8.037, -9.173, 34.400> <-7.402, -9.435, 34.421> <-7.075, -9.761, 34.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.075, -12.602, 34.684> <-7.402, -12.928, 34.710> <-8.037, -13.190, 34.732> <-8.500, -13.190, 34.732> 
		<-7.061, -12.634, 34.454> <-7.388, -12.960, 34.481> <-8.037, -13.228, 34.504> <-8.500, -13.228, 34.504> 
		<-7.060, -12.661, 34.137> <-7.380, -12.980, 34.164> <-8.048, -13.256, 34.187> <-8.500, -13.256, 34.187> 
		<-7.107, -12.633, 33.912> <-7.427, -12.952, 33.939> <-8.048, -13.208, 33.960> <-8.500, -13.208, 33.960> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.190, 34.732> <-8.963, -13.190, 34.732> <-9.598, -12.928, 34.710> <-9.925, -12.602, 34.684> 
		<-8.500, -13.228, 34.504> <-8.963, -13.228, 34.504> <-9.612, -12.960, 34.481> <-9.939, -12.634, 34.454> 
		<-8.500, -13.256, 34.187> <-8.952, -13.256, 34.187> <-9.620, -12.980, 34.164> <-9.940, -12.661, 34.137> 
		<-8.500, -13.208, 33.960> <-8.952, -13.208, 33.960> <-9.573, -12.952, 33.939> <-9.893, -12.633, 33.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.925, -12.602, 34.684> <-10.252, -12.275, 34.657> <-10.516, -11.642, 34.604> <-10.516, -11.181, 34.566> 
		<-9.939, -12.634, 34.454> <-10.266, -12.308, 34.427> <-10.535, -11.661, 34.374> <-10.535, -11.200, 34.336> 
		<-9.940, -12.661, 34.137> <-10.260, -12.343, 34.111> <-10.536, -11.677, 34.056> <-10.536, -11.227, 34.019> 
		<-9.893, -12.633, 33.912> <-10.213, -12.314, 33.886> <-10.470, -11.696, 33.835> <-10.470, -11.245, 33.797> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.516, -11.181, 34.566> <-10.516, -10.720, 34.528> <-10.252, -10.087, 34.475> <-9.925, -9.761, 34.448> 
		<-10.535, -11.200, 34.336> <-10.535, -10.739, 34.298> <-10.266, -10.092, 34.244> <-9.939, -9.766, 34.217> 
		<-10.536, -11.227, 34.019> <-10.536, -10.776, 33.981> <-10.260, -10.110, 33.926> <-9.940, -9.792, 33.900> 
		<-10.470, -11.245, 33.797> <-10.470, -10.794, 33.760> <-10.213, -10.175, 33.709> <-9.893, -9.856, 33.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.925, -9.761, 34.448> <-9.598, -9.435, 34.421> <-8.963, -9.173, 34.400> <-8.500, -9.173, 34.400> 
		<-9.939, -9.766, 34.217> <-9.612, -9.440, 34.190> <-8.963, -9.172, 34.168> <-8.500, -9.172, 34.168> 
		<-9.940, -9.792, 33.900> <-9.620, -9.473, 33.874> <-8.952, -9.197, 33.851> <-8.500, -9.197, 33.851> 
		<-9.893, -9.856, 33.682> <-9.573, -9.538, 33.656> <-8.952, -9.281, 33.635> <-8.500, -9.281, 33.635> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.173, 34.400> <-8.037, -9.173, 34.400> <-7.402, -9.435, 34.421> <-7.075, -9.761, 34.448> 
		<-8.500, -9.172, 34.168> <-8.037, -9.172, 34.168> <-7.388, -9.440, 34.190> <-7.061, -9.766, 34.217> 
		<-8.500, -9.197, 33.851> <-8.048, -9.197, 33.851> <-7.380, -9.473, 33.874> <-7.060, -9.792, 33.900> 
		<-8.500, -9.281, 33.635> <-8.048, -9.281, 33.635> <-7.427, -9.538, 33.656> <-7.107, -9.856, 33.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.107, -12.633, 33.912> <-7.427, -12.952, 33.939> <-8.048, -13.208, 33.960> <-8.500, -13.208, 33.960> 
		<-7.119, -12.626, 33.853> <-7.439, -12.945, 33.879> <-8.048, -13.196, 33.900> <-8.500, -13.196, 33.900> 
		<-7.206, -12.536, 33.879> <-7.494, -12.823, 33.903> <-8.093, -13.071, 33.923> <-8.500, -13.071, 33.923> 
		<-7.246, -12.498, 33.854> <-7.534, -12.785, 33.878> <-8.093, -13.016, 33.897> <-8.500, -13.016, 33.897> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.208, 33.960> <-8.952, -13.208, 33.960> <-9.573, -12.952, 33.939> <-9.893, -12.633, 33.912> 
		<-8.500, -13.196, 33.900> <-8.952, -13.196, 33.900> <-9.561, -12.945, 33.879> <-9.881, -12.626, 33.853> 
		<-8.500, -13.071, 33.923> <-8.907, -13.071, 33.923> <-9.506, -12.823, 33.903> <-9.794, -12.536, 33.879> 
		<-8.500, -13.016, 33.897> <-8.907, -13.016, 33.897> <-9.466, -12.785, 33.878> <-9.754, -12.498, 33.854> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.893, -12.633, 33.912> <-10.213, -12.314, 33.886> <-10.470, -11.696, 33.835> <-10.470, -11.245, 33.797> 
		<-9.881, -12.626, 33.853> <-10.201, -12.307, 33.827> <-10.453, -11.700, 33.777> <-10.453, -11.250, 33.739> 
		<-9.794, -12.536, 33.879> <-10.082, -12.250, 33.855> <-10.330, -11.653, 33.806> <-10.330, -11.247, 33.772> 
		<-9.754, -12.498, 33.854> <-10.042, -12.211, 33.830> <-10.273, -11.654, 33.784> <-10.273, -11.249, 33.751> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.470, -11.245, 33.797> <-10.470, -10.794, 33.760> <-10.213, -10.175, 33.709> <-9.893, -9.856, 33.682> 
		<-10.453, -11.250, 33.739> <-10.453, -10.799, 33.702> <-10.201, -10.192, 33.652> <-9.881, -9.873, 33.625> 
		<-10.330, -11.247, 33.772> <-10.330, -10.841, 33.739> <-10.082, -10.244, 33.689> <-9.794, -9.957, 33.666> 
		<-10.273, -11.249, 33.751> <-10.273, -10.843, 33.717> <-10.042, -10.286, 33.671> <-9.754, -9.999, 33.647> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.893, -9.856, 33.682> <-9.573, -9.538, 33.656> <-8.952, -9.281, 33.635> <-8.500, -9.281, 33.635> 
		<-9.881, -9.873, 33.625> <-9.561, -9.555, 33.599> <-8.952, -9.303, 33.578> <-8.500, -9.303, 33.578> 
		<-9.794, -9.957, 33.666> <-9.506, -9.670, 33.642> <-8.907, -9.423, 33.621> <-8.500, -9.423, 33.621> 
		<-9.754, -9.999, 33.647> <-9.466, -9.712, 33.624> <-8.907, -9.482, 33.604> <-8.500, -9.482, 33.604> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.281, 33.635> <-8.048, -9.281, 33.635> <-7.427, -9.538, 33.656> <-7.107, -9.856, 33.682> 
		<-8.500, -9.303, 33.578> <-8.048, -9.303, 33.578> <-7.439, -9.555, 33.599> <-7.119, -9.873, 33.625> 
		<-8.500, -9.423, 33.621> <-8.093, -9.423, 33.621> <-7.494, -9.670, 33.642> <-7.206, -9.957, 33.666> 
		<-8.500, -9.482, 33.604> <-8.093, -9.482, 33.604> <-7.534, -9.712, 33.624> <-7.246, -9.999, 33.647> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.246, -12.498, 33.854> <-7.534, -12.785, 33.878> <-8.093, -13.016, 33.897> <-8.500, -13.016, 33.897> 
		<-7.252, -12.493, 33.850> <-7.540, -12.779, 33.874> <-8.093, -13.008, 33.893> <-8.500, -13.008, 33.893> 
		<-7.243, -12.504, 33.829> <-7.530, -12.790, 33.853> <-8.094, -13.023, 33.872> <-8.500, -13.023, 33.872> 
		<-7.248, -12.498, 33.824> <-7.536, -12.785, 33.848> <-8.094, -13.015, 33.867> <-8.500, -13.015, 33.867> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.016, 33.897> <-8.907, -13.016, 33.897> <-9.466, -12.785, 33.878> <-9.754, -12.498, 33.854> 
		<-8.500, -13.008, 33.893> <-8.907, -13.008, 33.893> <-9.460, -12.779, 33.874> <-9.748, -12.493, 33.850> 
		<-8.500, -13.023, 33.872> <-8.906, -13.023, 33.872> <-9.470, -12.790, 33.853> <-9.757, -12.504, 33.829> 
		<-8.500, -13.015, 33.867> <-8.906, -13.015, 33.867> <-9.464, -12.785, 33.848> <-9.752, -12.498, 33.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.754, -12.498, 33.854> <-10.042, -12.211, 33.830> <-10.273, -11.654, 33.784> <-10.273, -11.249, 33.751> 
		<-9.748, -12.493, 33.850> <-10.036, -12.206, 33.827> <-10.265, -11.655, 33.781> <-10.265, -11.249, 33.747> 
		<-9.757, -12.504, 33.829> <-10.045, -12.217, 33.805> <-10.278, -11.656, 33.759> <-10.278, -11.251, 33.725> 
		<-9.752, -12.498, 33.824> <-10.039, -12.212, 33.800> <-10.270, -11.656, 33.754> <-10.270, -11.251, 33.721> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.273, -11.249, 33.751> <-10.273, -10.843, 33.717> <-10.042, -10.286, 33.671> <-9.754, -9.999, 33.647> 
		<-10.265, -11.249, 33.747> <-10.265, -10.843, 33.714> <-10.036, -10.292, 33.668> <-9.748, -10.005, 33.645> 
		<-10.278, -11.251, 33.725> <-10.278, -10.846, 33.692> <-10.045, -10.284, 33.645> <-9.757, -9.998, 33.622> 
		<-10.270, -11.251, 33.721> <-10.270, -10.846, 33.687> <-10.039, -10.290, 33.641> <-9.752, -10.004, 33.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.754, -9.999, 33.647> <-9.466, -9.712, 33.624> <-8.907, -9.482, 33.604> <-8.500, -9.482, 33.604> 
		<-9.748, -10.005, 33.645> <-9.460, -9.718, 33.621> <-8.907, -9.490, 33.602> <-8.500, -9.490, 33.602> 
		<-9.757, -9.998, 33.622> <-9.470, -9.712, 33.598> <-8.906, -9.479, 33.579> <-8.500, -9.479, 33.579> 
		<-9.752, -10.004, 33.618> <-9.464, -9.717, 33.594> <-8.906, -9.487, 33.575> <-8.500, -9.487, 33.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.482, 33.604> <-8.093, -9.482, 33.604> <-7.534, -9.712, 33.624> <-7.246, -9.999, 33.647> 
		<-8.500, -9.490, 33.602> <-8.093, -9.490, 33.602> <-7.540, -9.718, 33.621> <-7.252, -10.005, 33.645> 
		<-8.500, -9.479, 33.579> <-8.094, -9.479, 33.579> <-7.530, -9.712, 33.598> <-7.243, -9.998, 33.622> 
		<-8.500, -9.487, 33.575> <-8.094, -9.487, 33.575> <-7.536, -9.717, 33.594> <-7.248, -10.004, 33.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.248, -12.498, 33.824> <-7.536, -12.785, 33.848> <-8.094, -13.015, 33.867> <-8.500, -13.015, 33.867> 
		<-7.272, -12.476, 33.804> <-7.560, -12.763, 33.827> <-8.094, -12.983, 33.846> <-8.500, -12.983, 33.846> 
		<-7.315, -12.434, 33.805> <-7.582, -12.700, 33.827> <-8.122, -12.923, 33.846> <-8.500, -12.923, 33.846> 
		<-7.335, -12.415, 33.778> <-7.603, -12.682, 33.800> <-8.122, -12.896, 33.818> <-8.500, -12.896, 33.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -13.015, 33.867> <-8.906, -13.015, 33.867> <-9.464, -12.785, 33.848> <-9.752, -12.498, 33.824> 
		<-8.500, -12.983, 33.846> <-8.906, -12.983, 33.846> <-9.440, -12.763, 33.827> <-9.728, -12.476, 33.804> 
		<-8.500, -12.923, 33.846> <-8.878, -12.923, 33.846> <-9.418, -12.700, 33.827> <-9.685, -12.434, 33.805> 
		<-8.500, -12.896, 33.818> <-8.878, -12.896, 33.818> <-9.397, -12.682, 33.800> <-9.665, -12.415, 33.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.752, -12.498, 33.824> <-10.039, -12.212, 33.800> <-10.270, -11.656, 33.754> <-10.270, -11.251, 33.721> 
		<-9.728, -12.476, 33.804> <-10.015, -12.190, 33.780> <-10.236, -11.658, 33.736> <-10.236, -11.253, 33.702> 
		<-9.685, -12.434, 33.805> <-9.953, -12.167, 33.783> <-10.176, -11.629, 33.739> <-10.176, -11.252, 33.707> 
		<-9.665, -12.415, 33.778> <-9.932, -12.149, 33.756> <-10.147, -11.631, 33.713> <-10.147, -11.254, 33.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.270, -11.251, 33.721> <-10.270, -10.846, 33.687> <-10.039, -10.290, 33.641> <-9.752, -10.004, 33.618> 
		<-10.236, -11.253, 33.702> <-10.236, -10.848, 33.669> <-10.015, -10.316, 33.625> <-9.728, -10.029, 33.601> 
		<-10.176, -11.252, 33.707> <-10.176, -10.875, 33.676> <-9.953, -10.337, 33.632> <-9.685, -10.071, 33.610> 
		<-10.147, -11.254, 33.682> <-10.147, -10.877, 33.651> <-9.932, -10.360, 33.608> <-9.665, -10.094, 33.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.752, -10.004, 33.618> <-9.464, -9.717, 33.594> <-8.906, -9.487, 33.575> <-8.500, -9.487, 33.575> 
		<-9.728, -10.029, 33.601> <-9.440, -9.743, 33.578> <-8.906, -9.522, 33.559> <-8.500, -9.522, 33.559> 
		<-9.685, -10.071, 33.610> <-9.418, -9.804, 33.588> <-8.878, -9.582, 33.569> <-8.500, -9.582, 33.569> 
		<-9.665, -10.094, 33.586> <-9.397, -9.827, 33.564> <-8.878, -9.613, 33.546> <-8.500, -9.613, 33.546> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.487, 33.575> <-8.094, -9.487, 33.575> <-7.536, -9.717, 33.594> <-7.248, -10.004, 33.618> 
		<-8.500, -9.522, 33.559> <-8.094, -9.522, 33.559> <-7.560, -9.743, 33.578> <-7.272, -10.029, 33.601> 
		<-8.500, -9.582, 33.569> <-8.122, -9.582, 33.569> <-7.582, -9.804, 33.588> <-7.315, -10.071, 33.610> 
		<-8.500, -9.613, 33.546> <-8.122, -9.613, 33.546> <-7.603, -9.827, 33.564> <-7.335, -10.094, 33.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.335, -12.415, 33.778> <-7.603, -12.682, 33.800> <-8.122, -12.896, 33.818> <-8.500, -12.896, 33.818> 
		<-7.361, -12.392, 33.744> <-7.628, -12.659, 33.766> <-8.122, -12.862, 33.783> <-8.500, -12.862, 33.783> 
		<-7.382, -12.376, 33.681> <-7.636, -12.630, 33.702> <-8.141, -12.838, 33.720> <-8.500, -12.838, 33.720> 
		<-7.393, -12.369, 33.635> <-7.647, -12.622, 33.656> <-8.141, -12.826, 33.673> <-8.500, -12.826, 33.673> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.896, 33.818> <-8.878, -12.896, 33.818> <-9.397, -12.682, 33.800> <-9.665, -12.415, 33.778> 
		<-8.500, -12.862, 33.783> <-8.878, -12.862, 33.783> <-9.372, -12.659, 33.766> <-9.639, -12.392, 33.744> 
		<-8.500, -12.838, 33.720> <-8.859, -12.838, 33.720> <-9.364, -12.630, 33.702> <-9.618, -12.376, 33.681> 
		<-8.500, -12.826, 33.673> <-8.859, -12.826, 33.673> <-9.353, -12.622, 33.656> <-9.607, -12.369, 33.635> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.665, -12.415, 33.778> <-9.932, -12.149, 33.756> <-10.147, -11.631, 33.713> <-10.147, -11.254, 33.682> 
		<-9.639, -12.392, 33.744> <-9.906, -12.126, 33.722> <-10.111, -11.634, 33.682> <-10.111, -11.257, 33.650> 
		<-9.618, -12.376, 33.681> <-9.872, -12.123, 33.661> <-10.081, -11.620, 33.619> <-10.081, -11.262, 33.589> 
		<-9.607, -12.369, 33.635> <-9.861, -12.116, 33.614> <-10.066, -11.624, 33.573> <-10.066, -11.266, 33.544> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.147, -11.254, 33.682> <-10.147, -10.877, 33.651> <-9.932, -10.360, 33.608> <-9.665, -10.094, 33.586> 
		<-10.111, -11.257, 33.650> <-10.111, -10.880, 33.619> <-9.906, -10.388, 33.579> <-9.639, -10.122, 33.557> 
		<-10.081, -11.262, 33.589> <-10.081, -10.904, 33.560> <-9.872, -10.401, 33.518> <-9.618, -10.148, 33.497> 
		<-10.066, -11.266, 33.544> <-10.066, -10.908, 33.514> <-9.861, -10.416, 33.473> <-9.607, -10.163, 33.452> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.665, -10.094, 33.586> <-9.397, -9.827, 33.564> <-8.878, -9.613, 33.546> <-8.500, -9.613, 33.546> 
		<-9.639, -10.122, 33.557> <-9.372, -9.855, 33.534> <-8.878, -9.652, 33.518> <-8.500, -9.652, 33.518> 
		<-9.618, -10.148, 33.497> <-9.364, -9.894, 33.476> <-8.859, -9.686, 33.459> <-8.500, -9.686, 33.459> 
		<-9.607, -10.163, 33.452> <-9.353, -9.909, 33.431> <-8.859, -9.706, 33.415> <-8.500, -9.706, 33.415> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.613, 33.546> <-8.122, -9.613, 33.546> <-7.603, -9.827, 33.564> <-7.335, -10.094, 33.586> 
		<-8.500, -9.652, 33.518> <-8.122, -9.652, 33.518> <-7.628, -9.855, 33.535> <-7.361, -10.122, 33.557> 
		<-8.500, -9.686, 33.459> <-8.141, -9.686, 33.459> <-7.636, -9.894, 33.476> <-7.382, -10.148, 33.497> 
		<-8.500, -9.706, 33.415> <-8.141, -9.706, 33.415> <-7.647, -9.909, 33.431> <-7.393, -10.163, 33.452> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.393, -12.369, 33.635> <-7.647, -12.622, 33.656> <-8.141, -12.826, 33.673> <-8.500, -12.826, 33.673> 
		<-7.404, -12.362, 33.589> <-7.658, -12.615, 33.610> <-8.141, -12.814, 33.626> <-8.500, -12.814, 33.626> 
		<-7.396, -12.376, 33.521> <-7.647, -12.626, 33.542> <-8.145, -12.832, 33.559> <-8.500, -12.832, 33.559> 
		<-7.408, -12.367, 33.475> <-7.659, -12.617, 33.496> <-8.145, -12.818, 33.512> <-8.500, -12.818, 33.512> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.826, 33.673> <-8.859, -12.826, 33.673> <-9.353, -12.622, 33.656> <-9.607, -12.369, 33.635> 
		<-8.500, -12.814, 33.626> <-8.859, -12.814, 33.626> <-9.342, -12.615, 33.610> <-9.596, -12.362, 33.589> 
		<-8.500, -12.832, 33.559> <-8.855, -12.832, 33.559> <-9.353, -12.626, 33.542> <-9.604, -12.376, 33.521> 
		<-8.500, -12.818, 33.512> <-8.855, -12.818, 33.512> <-9.341, -12.617, 33.496> <-9.592, -12.367, 33.475> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.607, -12.369, 33.635> <-9.861, -12.116, 33.614> <-10.066, -11.624, 33.573> <-10.066, -11.266, 33.544> 
		<-9.596, -12.362, 33.589> <-9.850, -12.108, 33.568> <-10.050, -11.628, 33.528> <-10.050, -11.270, 33.498> 
		<-9.604, -12.376, 33.521> <-9.855, -12.126, 33.500> <-10.062, -11.629, 33.459> <-10.062, -11.275, 33.430> 
		<-9.592, -12.367, 33.475> <-9.843, -12.117, 33.454> <-10.045, -11.632, 33.414> <-10.045, -11.279, 33.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.066, -11.266, 33.544> <-10.066, -10.908, 33.514> <-9.861, -10.416, 33.473> <-9.607, -10.163, 33.452> 
		<-10.050, -11.270, 33.498> <-10.050, -10.911, 33.469> <-9.850, -10.431, 33.429> <-9.596, -10.177, 33.408> 
		<-10.062, -11.275, 33.430> <-10.062, -10.922, 33.401> <-9.855, -10.425, 33.360> <-9.604, -10.175, 33.339> 
		<-10.045, -11.279, 33.385> <-10.045, -10.926, 33.356> <-9.843, -10.440, 33.316> <-9.592, -10.191, 33.295> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.607, -10.163, 33.452> <-9.353, -9.909, 33.431> <-8.859, -9.706, 33.415> <-8.500, -9.706, 33.415> 
		<-9.596, -10.177, 33.408> <-9.342, -9.924, 33.387> <-8.859, -9.725, 33.371> <-8.500, -9.725, 33.371> 
		<-9.604, -10.175, 33.339> <-9.353, -9.925, 33.318> <-8.855, -9.719, 33.301> <-8.500, -9.719, 33.301> 
		<-9.592, -10.191, 33.295> <-9.341, -9.941, 33.274> <-8.855, -9.740, 33.258> <-8.500, -9.740, 33.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.706, 33.415> <-8.141, -9.706, 33.415> <-7.647, -9.909, 33.431> <-7.393, -10.163, 33.452> 
		<-8.500, -9.725, 33.371> <-8.141, -9.725, 33.371> <-7.658, -9.924, 33.387> <-7.404, -10.177, 33.408> 
		<-8.500, -9.719, 33.301> <-8.145, -9.719, 33.301> <-7.647, -9.925, 33.318> <-7.396, -10.175, 33.339> 
		<-8.500, -9.740, 33.258> <-8.145, -9.740, 33.258> <-7.659, -9.941, 33.274> <-7.408, -10.191, 33.295> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.408, -12.367, 33.475> <-7.659, -12.617, 33.496> <-8.145, -12.818, 33.512> <-8.500, -12.818, 33.512> 
		<-7.411, -12.365, 33.462> <-7.662, -12.615, 33.483> <-8.145, -12.815, 33.500> <-8.500, -12.815, 33.500> 
		<-7.437, -12.338, 33.476> <-7.681, -12.581, 33.496> <-8.155, -12.777, 33.512> <-8.500, -12.777, 33.512> 
		<-7.438, -12.338, 33.463> <-7.682, -12.581, 33.483> <-8.155, -12.776, 33.499> <-8.500, -12.776, 33.499> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.818, 33.512> <-8.855, -12.818, 33.512> <-9.341, -12.617, 33.496> <-9.592, -12.367, 33.475> 
		<-8.500, -12.815, 33.500> <-8.855, -12.815, 33.500> <-9.338, -12.615, 33.483> <-9.589, -12.365, 33.462> 
		<-8.500, -12.777, 33.512> <-8.845, -12.777, 33.512> <-9.319, -12.581, 33.496> <-9.563, -12.338, 33.476> 
		<-8.500, -12.776, 33.499> <-8.845, -12.776, 33.499> <-9.318, -12.581, 33.483> <-9.562, -12.338, 33.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.592, -12.367, 33.475> <-9.843, -12.117, 33.454> <-10.045, -11.632, 33.414> <-10.045, -11.279, 33.385> 
		<-9.589, -12.365, 33.462> <-9.840, -12.115, 33.442> <-10.040, -11.633, 33.402> <-10.040, -11.280, 33.373> 
		<-9.563, -12.338, 33.476> <-9.807, -12.095, 33.456> <-10.003, -11.622, 33.417> <-10.003, -11.279, 33.388> 
		<-9.562, -12.338, 33.463> <-9.805, -12.095, 33.443> <-10.001, -11.623, 33.404> <-10.001, -11.280, 33.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.045, -11.279, 33.385> <-10.045, -10.926, 33.356> <-9.843, -10.440, 33.316> <-9.592, -10.191, 33.295> 
		<-10.040, -11.280, 33.373> <-10.040, -10.927, 33.343> <-9.840, -10.445, 33.304> <-9.589, -10.195, 33.283> 
		<-10.003, -11.279, 33.388> <-10.003, -10.935, 33.360> <-9.807, -10.462, 33.321> <-9.563, -10.219, 33.301> 
		<-10.001, -11.280, 33.375> <-10.001, -10.936, 33.347> <-9.805, -10.465, 33.308> <-9.562, -10.222, 33.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.592, -10.191, 33.295> <-9.341, -9.941, 33.274> <-8.855, -9.740, 33.258> <-8.500, -9.740, 33.258> 
		<-9.589, -10.195, 33.283> <-9.338, -9.945, 33.262> <-8.855, -9.745, 33.246> <-8.500, -9.745, 33.246> 
		<-9.563, -10.219, 33.301> <-9.319, -9.976, 33.281> <-8.845, -9.781, 33.264> <-8.500, -9.781, 33.264> 
		<-9.562, -10.222, 33.288> <-9.318, -9.979, 33.268> <-8.845, -9.784, 33.251> <-8.500, -9.784, 33.251> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.740, 33.258> <-8.145, -9.740, 33.258> <-7.659, -9.941, 33.274> <-7.408, -10.191, 33.295> 
		<-8.500, -9.745, 33.246> <-8.145, -9.745, 33.246> <-7.662, -9.945, 33.262> <-7.411, -10.195, 33.283> 
		<-8.500, -9.781, 33.264> <-8.155, -9.781, 33.264> <-7.681, -9.976, 33.281> <-7.437, -10.219, 33.301> 
		<-8.500, -9.784, 33.251> <-8.155, -9.784, 33.251> <-7.682, -9.979, 33.268> <-7.438, -10.222, 33.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.438, -12.338, 33.463> <-7.682, -12.581, 33.483> <-8.155, -12.776, 33.499> <-8.500, -12.776, 33.499> 
		<-7.471, -12.331, 33.141> <-7.715, -12.574, 33.161> <-8.155, -12.756, 33.176> <-8.500, -12.756, 33.176> 
		<-7.459, -12.380, 32.703> <-7.685, -12.604, 32.722> <-8.181, -12.809, 32.739> <-8.500, -12.809, 32.739> 
		<-7.519, -12.346, 32.387> <-7.744, -12.571, 32.405> <-8.181, -12.751, 32.420> <-8.500, -12.751, 32.420> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.776, 33.499> <-8.845, -12.776, 33.499> <-9.318, -12.581, 33.483> <-9.562, -12.338, 33.463> 
		<-8.500, -12.756, 33.176> <-8.845, -12.756, 33.176> <-9.285, -12.574, 33.161> <-9.529, -12.331, 33.141> 
		<-8.500, -12.809, 32.739> <-8.819, -12.809, 32.739> <-9.315, -12.604, 32.722> <-9.541, -12.380, 32.703> 
		<-8.500, -12.751, 32.420> <-8.819, -12.751, 32.420> <-9.256, -12.571, 32.405> <-9.481, -12.346, 32.387> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.562, -12.338, 33.463> <-9.805, -12.095, 33.443> <-10.001, -11.623, 33.404> <-10.001, -11.280, 33.375> 
		<-9.529, -12.331, 33.141> <-9.773, -12.089, 33.121> <-9.955, -11.650, 33.084> <-9.955, -11.306, 33.056> 
		<-9.541, -12.380, 32.703> <-9.766, -12.155, 32.684> <-9.972, -11.660, 32.643> <-9.972, -11.343, 32.617> 
		<-9.481, -12.346, 32.387> <-9.706, -12.122, 32.368> <-9.887, -11.686, 32.332> <-9.887, -11.369, 32.305> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.001, -11.280, 33.375> <-10.001, -10.936, 33.347> <-9.805, -10.465, 33.308> <-9.562, -10.222, 33.288> 
		<-9.955, -11.306, 33.056> <-9.955, -10.963, 33.027> <-9.773, -10.524, 32.991> <-9.529, -10.281, 32.971> 
		<-9.972, -11.343, 32.617> <-9.972, -11.025, 32.590> <-9.766, -10.530, 32.549> <-9.541, -10.306, 32.531> 
		<-9.887, -11.369, 32.305> <-9.887, -11.051, 32.279> <-9.706, -10.615, 32.242> <-9.481, -10.391, 32.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.562, -10.222, 33.288> <-9.318, -9.979, 33.268> <-8.845, -9.784, 33.251> <-8.500, -9.784, 33.251> 
		<-9.529, -10.281, 32.971> <-9.285, -10.038, 32.951> <-8.845, -9.856, 32.935> <-8.500, -9.856, 32.935> 
		<-9.541, -10.306, 32.531> <-9.315, -10.081, 32.512> <-8.819, -9.876, 32.495> <-8.500, -9.876, 32.495> 
		<-9.481, -10.391, 32.224> <-9.256, -10.166, 32.205> <-8.819, -9.986, 32.190> <-8.500, -9.986, 32.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.784, 33.251> <-8.155, -9.784, 33.251> <-7.682, -9.979, 33.268> <-7.438, -10.222, 33.288> 
		<-8.500, -9.856, 32.935> <-8.155, -9.856, 32.935> <-7.715, -10.038, 32.951> <-7.471, -10.281, 32.971> 
		<-8.500, -9.876, 32.495> <-8.181, -9.876, 32.495> <-7.685, -10.081, 32.512> <-7.459, -10.306, 32.531> 
		<-8.500, -9.986, 32.190> <-8.181, -9.986, 32.190> <-7.744, -10.166, 32.205> <-7.519, -10.391, 32.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.519, -12.346, 32.387> <-7.744, -12.571, 32.405> <-8.181, -12.751, 32.420> <-8.500, -12.751, 32.420> 
		<-7.555, -12.326, 32.195> <-7.780, -12.550, 32.214> <-8.181, -12.716, 32.228> <-8.500, -12.716, 32.228> 
		<-7.667, -12.232, 31.968> <-7.839, -12.403, 31.983> <-8.257, -12.576, 31.997> <-8.500, -12.576, 31.997> 
		<-7.751, -12.161, 31.806> <-7.923, -12.333, 31.820> <-8.257, -12.471, 31.832> <-8.500, -12.471, 31.832> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.751, 32.420> <-8.819, -12.751, 32.420> <-9.256, -12.571, 32.405> <-9.481, -12.346, 32.387> 
		<-8.500, -12.716, 32.228> <-8.819, -12.716, 32.228> <-9.220, -12.550, 32.214> <-9.445, -12.326, 32.195> 
		<-8.500, -12.576, 31.997> <-8.743, -12.576, 31.997> <-9.161, -12.403, 31.983> <-9.333, -12.232, 31.968> 
		<-8.500, -12.471, 31.832> <-8.743, -12.471, 31.832> <-9.077, -12.333, 31.820> <-9.249, -12.161, 31.806> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.481, -12.346, 32.387> <-9.706, -12.122, 32.368> <-9.887, -11.686, 32.332> <-9.887, -11.369, 32.305> 
		<-9.445, -12.326, 32.195> <-9.670, -12.101, 32.177> <-9.836, -11.702, 32.143> <-9.836, -11.384, 32.117> 
		<-9.333, -12.232, 31.968> <-9.505, -12.061, 31.953> <-9.678, -11.644, 31.918> <-9.678, -11.402, 31.898> 
		<-9.249, -12.161, 31.806> <-9.421, -11.990, 31.791> <-9.560, -11.657, 31.763> <-9.560, -11.415, 31.742> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.887, -11.369, 32.305> <-9.887, -11.051, 32.279> <-9.706, -10.615, 32.242> <-9.481, -10.391, 32.224> 
		<-9.836, -11.384, 32.117> <-9.836, -11.067, 32.090> <-9.670, -10.667, 32.057> <-9.445, -10.442, 32.038> 
		<-9.678, -11.402, 31.898> <-9.678, -11.159, 31.877> <-9.505, -10.743, 31.842> <-9.333, -10.572, 31.827> 
		<-9.560, -11.415, 31.742> <-9.560, -11.172, 31.722> <-9.421, -10.840, 31.693> <-9.249, -10.668, 31.679> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.481, -10.391, 32.224> <-9.256, -10.166, 32.205> <-8.819, -9.986, 32.190> <-8.500, -9.986, 32.190> 
		<-9.445, -10.442, 32.038> <-9.220, -10.218, 32.019> <-8.819, -10.052, 32.005> <-8.500, -10.052, 32.005> 
		<-9.333, -10.572, 31.827> <-9.161, -10.400, 31.813> <-8.743, -10.228, 31.798> <-8.500, -10.228, 31.798> 
		<-9.249, -10.668, 31.679> <-9.077, -10.497, 31.664> <-8.743, -10.359, 31.653> <-8.500, -10.359, 31.653> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -9.986, 32.190> <-8.181, -9.986, 32.190> <-7.744, -10.166, 32.205> <-7.519, -10.391, 32.224> 
		<-8.500, -10.052, 32.005> <-8.181, -10.052, 32.005> <-7.780, -10.218, 32.019> <-7.555, -10.442, 32.038> 
		<-8.500, -10.228, 31.798> <-8.257, -10.228, 31.798> <-7.839, -10.400, 31.813> <-7.667, -10.572, 31.827> 
		<-8.500, -10.359, 31.653> <-8.257, -10.359, 31.653> <-7.923, -10.497, 31.664> <-7.751, -10.668, 31.679> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.751, -12.161, 31.806> <-7.923, -12.333, 31.820> <-8.257, -12.471, 31.832> <-8.500, -12.471, 31.832> 
		<-7.803, -12.118, 31.705> <-7.975, -12.289, 31.720> <-8.257, -12.405, 31.730> <-8.500, -12.405, 31.730> 
		<-7.898, -12.030, 31.603> <-8.021, -12.152, 31.613> <-8.326, -12.278, 31.624> <-8.500, -12.278, 31.624> 
		<-7.965, -11.970, 31.522> <-8.088, -12.092, 31.532> <-8.326, -12.190, 31.541> <-8.500, -12.190, 31.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.471, 31.832> <-8.743, -12.471, 31.832> <-9.077, -12.333, 31.820> <-9.249, -12.161, 31.806> 
		<-8.500, -12.405, 31.730> <-8.743, -12.405, 31.730> <-9.025, -12.289, 31.720> <-9.197, -12.118, 31.705> 
		<-8.500, -12.278, 31.624> <-8.674, -12.278, 31.624> <-8.979, -12.152, 31.613> <-9.102, -12.030, 31.603> 
		<-8.500, -12.190, 31.541> <-8.674, -12.190, 31.541> <-8.912, -12.092, 31.532> <-9.035, -11.970, 31.522> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.249, -12.161, 31.806> <-9.421, -11.990, 31.791> <-9.560, -11.657, 31.763> <-9.560, -11.415, 31.742> 
		<-9.197, -12.118, 31.705> <-9.369, -11.946, 31.691> <-9.486, -11.665, 31.667> <-9.486, -11.423, 31.646> 
		<-9.102, -12.030, 31.603> <-9.224, -11.908, 31.593> <-9.351, -11.604, 31.567> <-9.351, -11.430, 31.553> 
		<-9.035, -11.970, 31.522> <-9.157, -11.847, 31.512> <-9.256, -11.610, 31.492> <-9.256, -11.437, 31.478> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.560, -11.415, 31.742> <-9.560, -11.172, 31.722> <-9.421, -10.840, 31.693> <-9.249, -10.668, 31.679> 
		<-9.486, -11.423, 31.646> <-9.486, -11.180, 31.626> <-9.370, -10.899, 31.602> <-9.198, -10.727, 31.588> 
		<-9.351, -11.430, 31.553> <-9.351, -11.257, 31.539> <-9.224, -10.953, 31.513> <-9.102, -10.831, 31.503> 
		<-9.256, -11.437, 31.478> <-9.256, -11.264, 31.464> <-9.157, -11.026, 31.444> <-9.035, -10.904, 31.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.249, -10.668, 31.679> <-9.077, -10.497, 31.664> <-8.743, -10.359, 31.653> <-8.500, -10.359, 31.653> 
		<-9.198, -10.727, 31.588> <-9.026, -10.556, 31.573> <-8.743, -10.439, 31.563> <-8.500, -10.439, 31.563> 
		<-9.102, -10.831, 31.503> <-8.979, -10.709, 31.493> <-8.674, -10.583, 31.482> <-8.500, -10.583, 31.482> 
		<-9.035, -10.904, 31.434> <-8.912, -10.782, 31.424> <-8.674, -10.683, 31.416> <-8.500, -10.683, 31.416> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.359, 31.653> <-8.257, -10.359, 31.653> <-7.923, -10.497, 31.664> <-7.751, -10.668, 31.679> 
		<-8.500, -10.439, 31.563> <-8.257, -10.439, 31.563> <-7.974, -10.556, 31.573> <-7.802, -10.727, 31.588> 
		<-8.500, -10.583, 31.482> <-8.326, -10.583, 31.482> <-8.021, -10.709, 31.493> <-7.898, -10.831, 31.503> 
		<-8.500, -10.683, 31.416> <-8.326, -10.683, 31.416> <-8.088, -10.782, 31.424> <-7.965, -10.904, 31.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.965, -11.970, 31.522> <-8.088, -12.092, 31.532> <-8.326, -12.190, 31.541> <-8.500, -12.190, 31.541> 
		<-7.971, -11.965, 31.515> <-8.094, -12.087, 31.526> <-8.326, -12.183, 31.534> <-8.500, -12.183, 31.534> 
		<-7.985, -11.950, 31.526> <-8.102, -12.067, 31.536> <-8.334, -12.163, 31.543> <-8.500, -12.163, 31.543> 
		<-7.989, -11.946, 31.518> <-8.106, -12.063, 31.527> <-8.334, -12.157, 31.535> <-8.500, -12.157, 31.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.190, 31.541> <-8.674, -12.190, 31.541> <-8.912, -12.092, 31.532> <-9.035, -11.970, 31.522> 
		<-8.500, -12.183, 31.534> <-8.674, -12.183, 31.534> <-8.906, -12.087, 31.526> <-9.029, -11.965, 31.515> 
		<-8.500, -12.163, 31.543> <-8.666, -12.163, 31.543> <-8.898, -12.067, 31.536> <-9.015, -11.950, 31.526> 
		<-8.500, -12.157, 31.535> <-8.666, -12.157, 31.535> <-8.894, -12.063, 31.527> <-9.011, -11.946, 31.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.035, -11.970, 31.522> <-9.157, -11.847, 31.512> <-9.256, -11.610, 31.492> <-9.256, -11.437, 31.478> 
		<-9.029, -11.965, 31.515> <-9.152, -11.842, 31.505> <-9.248, -11.610, 31.486> <-9.248, -11.437, 31.472> 
		<-9.015, -11.950, 31.526> <-9.133, -11.833, 31.516> <-9.229, -11.602, 31.497> <-9.229, -11.436, 31.483> 
		<-9.011, -11.946, 31.518> <-9.128, -11.829, 31.508> <-9.222, -11.602, 31.489> <-9.222, -11.437, 31.475> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.256, -11.437, 31.478> <-9.256, -11.264, 31.464> <-9.157, -11.026, 31.444> <-9.035, -10.904, 31.434> 
		<-9.248, -11.437, 31.472> <-9.248, -11.264, 31.458> <-9.152, -11.032, 31.438> <-9.029, -10.910, 31.428> 
		<-9.229, -11.436, 31.483> <-9.229, -11.271, 31.470> <-9.133, -11.040, 31.451> <-9.015, -10.923, 31.441> 
		<-9.222, -11.437, 31.475> <-9.222, -11.272, 31.462> <-9.128, -11.045, 31.443> <-9.011, -10.928, 31.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.035, -10.904, 31.434> <-8.912, -10.782, 31.424> <-8.674, -10.683, 31.416> <-8.500, -10.683, 31.416> 
		<-9.029, -10.910, 31.428> <-8.906, -10.788, 31.418> <-8.674, -10.692, 31.410> <-8.500, -10.692, 31.410> 
		<-9.015, -10.923, 31.441> <-8.898, -10.806, 31.431> <-8.666, -10.710, 31.423> <-8.500, -10.710, 31.423> 
		<-9.011, -10.928, 31.433> <-8.894, -10.811, 31.424> <-8.666, -10.717, 31.416> <-8.500, -10.717, 31.416> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.683, 31.416> <-8.326, -10.683, 31.416> <-8.088, -10.782, 31.424> <-7.965, -10.904, 31.434> 
		<-8.500, -10.692, 31.410> <-8.326, -10.692, 31.410> <-8.094, -10.788, 31.418> <-7.971, -10.910, 31.428> 
		<-8.500, -10.710, 31.423> <-8.334, -10.710, 31.423> <-8.102, -10.806, 31.431> <-7.985, -10.923, 31.441> 
		<-8.500, -10.717, 31.416> <-8.334, -10.717, 31.416> <-8.106, -10.811, 31.424> <-7.989, -10.928, 31.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.989, -11.946, 31.518> <-8.106, -12.063, 31.527> <-8.334, -12.157, 31.535> <-8.500, -12.157, 31.535> 
		<-7.993, -11.943, 31.511> <-8.110, -12.060, 31.521> <-8.334, -12.152, 31.528> <-8.500, -12.152, 31.528> 
		<-7.979, -11.957, 31.502> <-8.098, -12.076, 31.512> <-8.331, -12.173, 31.520> <-8.500, -12.173, 31.520> 
		<-7.980, -11.957, 31.494> <-8.100, -12.076, 31.504> <-8.331, -12.171, 31.512> <-8.500, -12.171, 31.512> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.157, 31.535> <-8.666, -12.157, 31.535> <-8.894, -12.063, 31.527> <-9.011, -11.946, 31.518> 
		<-8.500, -12.152, 31.528> <-8.666, -12.152, 31.528> <-8.890, -12.060, 31.521> <-9.007, -11.943, 31.511> 
		<-8.500, -12.173, 31.520> <-8.669, -12.173, 31.520> <-8.902, -12.076, 31.512> <-9.021, -11.957, 31.502> 
		<-8.500, -12.171, 31.512> <-8.669, -12.171, 31.512> <-8.900, -12.076, 31.504> <-9.020, -11.957, 31.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.011, -11.946, 31.518> <-9.128, -11.829, 31.508> <-9.222, -11.602, 31.489> <-9.222, -11.437, 31.475> 
		<-9.007, -11.943, 31.511> <-9.125, -11.826, 31.501> <-9.217, -11.603, 31.483> <-9.217, -11.437, 31.469> 
		<-9.021, -11.957, 31.502> <-9.140, -11.839, 31.492> <-9.237, -11.606, 31.473> <-9.237, -11.438, 31.459> 
		<-9.020, -11.957, 31.494> <-9.139, -11.838, 31.484> <-9.235, -11.607, 31.465> <-9.235, -11.439, 31.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.222, -11.437, 31.475> <-9.222, -11.272, 31.462> <-9.128, -11.045, 31.443> <-9.011, -10.928, 31.433> 
		<-9.217, -11.437, 31.469> <-9.217, -11.272, 31.455> <-9.125, -11.049, 31.437> <-9.007, -10.932, 31.427> 
		<-9.237, -11.438, 31.459> <-9.237, -11.270, 31.445> <-9.140, -11.038, 31.426> <-9.021, -10.919, 31.416> 
		<-9.235, -11.439, 31.451> <-9.235, -11.271, 31.437> <-9.139, -11.040, 31.418> <-9.020, -10.921, 31.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.011, -10.928, 31.433> <-8.894, -10.811, 31.424> <-8.666, -10.717, 31.416> <-8.500, -10.717, 31.416> 
		<-9.007, -10.932, 31.427> <-8.890, -10.815, 31.418> <-8.666, -10.723, 31.410> <-8.500, -10.723, 31.410> 
		<-9.021, -10.919, 31.416> <-8.902, -10.800, 31.406> <-8.669, -10.704, 31.398> <-8.500, -10.704, 31.398> 
		<-9.020, -10.921, 31.408> <-8.900, -10.802, 31.398> <-8.669, -10.707, 31.390> <-8.500, -10.707, 31.390> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.717, 31.416> <-8.334, -10.717, 31.416> <-8.106, -10.811, 31.424> <-7.989, -10.928, 31.433> 
		<-8.500, -10.723, 31.410> <-8.334, -10.723, 31.410> <-8.110, -10.815, 31.418> <-7.993, -10.932, 31.427> 
		<-8.500, -10.704, 31.398> <-8.331, -10.704, 31.398> <-8.098, -10.800, 31.406> <-7.979, -10.919, 31.416> 
		<-8.500, -10.707, 31.390> <-8.331, -10.707, 31.390> <-8.100, -10.802, 31.398> <-7.980, -10.921, 31.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.980, -11.957, 31.494> <-8.100, -12.076, 31.504> <-8.331, -12.171, 31.512> <-8.500, -12.171, 31.512> 
		<-7.993, -11.950, 31.423> <-8.112, -12.069, 31.433> <-8.331, -12.160, 31.441> <-8.500, -12.160, 31.441> 
		<-8.035, -11.915, 31.334> <-8.143, -12.021, 31.343> <-8.349, -12.107, 31.350> <-8.500, -12.107, 31.350> 
		<-8.034, -11.922, 31.262> <-8.141, -12.029, 31.271> <-8.349, -12.115, 31.278> <-8.500, -12.115, 31.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.171, 31.512> <-8.669, -12.171, 31.512> <-8.900, -12.076, 31.504> <-9.020, -11.957, 31.494> 
		<-8.500, -12.160, 31.441> <-8.669, -12.160, 31.441> <-8.888, -12.069, 31.433> <-9.007, -11.950, 31.423> 
		<-8.500, -12.107, 31.350> <-8.651, -12.107, 31.350> <-8.857, -12.021, 31.343> <-8.965, -11.915, 31.334> 
		<-8.500, -12.115, 31.278> <-8.651, -12.115, 31.278> <-8.859, -12.029, 31.271> <-8.966, -11.922, 31.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.020, -11.957, 31.494> <-9.139, -11.838, 31.484> <-9.235, -11.607, 31.465> <-9.235, -11.439, 31.451> 
		<-9.007, -11.950, 31.423> <-9.126, -11.831, 31.413> <-9.217, -11.613, 31.395> <-9.217, -11.445, 31.381> 
		<-8.965, -11.915, 31.334> <-9.072, -11.808, 31.325> <-9.157, -11.603, 31.308> <-9.157, -11.452, 31.296> 
		<-8.966, -11.922, 31.262> <-9.073, -11.816, 31.254> <-9.159, -11.609, 31.236> <-9.159, -11.458, 31.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.235, -11.439, 31.451> <-9.235, -11.271, 31.437> <-9.139, -11.040, 31.418> <-9.020, -10.921, 31.408> 
		<-9.217, -11.445, 31.381> <-9.217, -11.277, 31.368> <-9.126, -11.058, 31.349> <-9.007, -10.939, 31.340> 
		<-9.157, -11.452, 31.296> <-9.157, -11.301, 31.283> <-9.072, -11.096, 31.266> <-8.965, -10.989, 31.257> 
		<-9.159, -11.458, 31.224> <-9.159, -11.307, 31.211> <-9.073, -11.100, 31.194> <-8.966, -10.993, 31.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.020, -10.921, 31.408> <-8.900, -10.802, 31.398> <-8.669, -10.707, 31.390> <-8.500, -10.707, 31.390> 
		<-9.007, -10.939, 31.340> <-8.888, -10.820, 31.330> <-8.669, -10.730, 31.322> <-8.500, -10.730, 31.322> 
		<-8.965, -10.989, 31.257> <-8.857, -10.882, 31.249> <-8.651, -10.797, 31.241> <-8.500, -10.797, 31.241> 
		<-8.966, -10.993, 31.185> <-8.859, -10.887, 31.177> <-8.651, -10.801, 31.170> <-8.500, -10.801, 31.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.707, 31.390> <-8.331, -10.707, 31.390> <-8.100, -10.802, 31.398> <-7.980, -10.921, 31.408> 
		<-8.500, -10.730, 31.322> <-8.331, -10.730, 31.322> <-8.112, -10.820, 31.330> <-7.993, -10.939, 31.340> 
		<-8.500, -10.797, 31.241> <-8.349, -10.797, 31.241> <-8.143, -10.882, 31.249> <-8.035, -10.989, 31.257> 
		<-8.500, -10.801, 31.170> <-8.349, -10.801, 31.170> <-8.141, -10.887, 31.177> <-8.034, -10.993, 31.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.034, -11.922, 31.262> <-8.141, -12.029, 31.271> <-8.349, -12.115, 31.278> <-8.500, -12.115, 31.278> 
		<-8.032, -11.931, 31.184> <-8.139, -12.037, 31.193> <-8.349, -12.124, 31.200> <-8.500, -12.124, 31.200> 
		<-7.982, -11.988, 31.099> <-8.104, -12.109, 31.109> <-8.328, -12.201, 31.116> <-8.500, -12.201, 31.116> 
		<-7.970, -12.006, 31.024> <-8.091, -12.128, 31.034> <-8.328, -12.225, 31.042> <-8.500, -12.225, 31.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.115, 31.278> <-8.651, -12.115, 31.278> <-8.859, -12.029, 31.271> <-8.966, -11.922, 31.262> 
		<-8.500, -12.124, 31.200> <-8.651, -12.124, 31.200> <-8.861, -12.037, 31.193> <-8.968, -11.931, 31.184> 
		<-8.500, -12.201, 31.116> <-8.672, -12.201, 31.116> <-8.896, -12.109, 31.109> <-9.018, -11.988, 31.099> 
		<-8.500, -12.225, 31.042> <-8.672, -12.225, 31.042> <-8.909, -12.128, 31.034> <-9.030, -12.006, 31.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.966, -11.922, 31.262> <-9.073, -11.816, 31.254> <-9.159, -11.609, 31.236> <-9.159, -11.458, 31.224> 
		<-8.968, -11.931, 31.184> <-9.075, -11.824, 31.176> <-9.162, -11.615, 31.158> <-9.162, -11.464, 31.146> 
		<-9.018, -11.988, 31.099> <-9.139, -11.866, 31.088> <-9.232, -11.643, 31.070> <-9.232, -11.472, 31.056> 
		<-9.030, -12.006, 31.024> <-9.152, -11.885, 31.014> <-9.250, -11.650, 30.994> <-9.250, -11.478, 30.980> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.159, -11.458, 31.224> <-9.159, -11.307, 31.211> <-9.073, -11.100, 31.194> <-8.966, -10.993, 31.185> 
		<-9.162, -11.464, 31.146> <-9.162, -11.313, 31.133> <-9.075, -11.105, 31.116> <-8.968, -10.998, 31.107> 
		<-9.232, -11.472, 31.056> <-9.232, -11.300, 31.042> <-9.139, -11.077, 31.023> <-9.018, -10.956, 31.013> 
		<-9.250, -11.478, 30.980> <-9.250, -11.306, 30.966> <-9.152, -11.071, 30.946> <-9.030, -10.949, 30.936> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.966, -10.993, 31.185> <-8.859, -10.887, 31.177> <-8.651, -10.801, 31.170> <-8.500, -10.801, 31.170> 
		<-8.968, -10.998, 31.107> <-8.861, -10.891, 31.098> <-8.651, -10.805, 31.091> <-8.500, -10.805, 31.091> 
		<-9.018, -10.956, 31.013> <-8.896, -10.834, 31.003> <-8.672, -10.742, 30.995> <-8.500, -10.742, 30.995> 
		<-9.030, -10.949, 30.936> <-8.909, -10.828, 30.926> <-8.672, -10.731, 30.918> <-8.500, -10.731, 30.918> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.801, 31.170> <-8.349, -10.801, 31.170> <-8.141, -10.887, 31.177> <-8.034, -10.993, 31.185> 
		<-8.500, -10.805, 31.091> <-8.349, -10.805, 31.091> <-8.139, -10.891, 31.098> <-8.032, -10.998, 31.107> 
		<-8.500, -10.742, 30.995> <-8.328, -10.742, 30.995> <-8.104, -10.834, 31.003> <-7.982, -10.956, 31.013> 
		<-8.500, -10.731, 30.918> <-8.328, -10.731, 30.918> <-8.091, -10.828, 30.926> <-7.970, -10.949, 30.936> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.970, -12.006, 31.024> <-8.091, -12.128, 31.034> <-8.328, -12.225, 31.042> <-8.500, -12.225, 31.042> 
		<-7.968, -12.009, 31.013> <-8.090, -12.130, 31.023> <-8.328, -12.229, 31.031> <-8.500, -12.229, 31.031> 
		<-7.990, -11.988, 31.009> <-8.107, -12.105, 31.019> <-8.334, -12.198, 31.027> <-8.500, -12.198, 31.027> 
		<-7.989, -11.989, 30.999> <-8.106, -12.106, 31.008> <-8.334, -12.200, 31.016> <-8.500, -12.200, 31.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.225, 31.042> <-8.672, -12.225, 31.042> <-8.909, -12.128, 31.034> <-9.030, -12.006, 31.024> 
		<-8.500, -12.229, 31.031> <-8.672, -12.229, 31.031> <-8.910, -12.130, 31.023> <-9.032, -12.009, 31.013> 
		<-8.500, -12.198, 31.027> <-8.666, -12.198, 31.027> <-8.893, -12.105, 31.019> <-9.010, -11.988, 31.009> 
		<-8.500, -12.200, 31.016> <-8.666, -12.200, 31.016> <-8.894, -12.106, 31.008> <-9.011, -11.989, 30.999> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.030, -12.006, 31.024> <-9.152, -11.885, 31.014> <-9.250, -11.650, 30.994> <-9.250, -11.478, 30.980> 
		<-9.032, -12.009, 31.013> <-9.154, -11.888, 31.003> <-9.252, -11.650, 30.984> <-9.252, -11.479, 30.969> 
		<-9.010, -11.988, 31.009> <-9.128, -11.871, 31.000> <-9.222, -11.644, 30.981> <-9.222, -11.479, 30.967> 
		<-9.011, -11.989, 30.999> <-9.128, -11.872, 30.989> <-9.222, -11.645, 30.970> <-9.222, -11.480, 30.957> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.250, -11.478, 30.980> <-9.250, -11.306, 30.966> <-9.152, -11.071, 30.946> <-9.030, -10.949, 30.936> 
		<-9.252, -11.479, 30.969> <-9.252, -11.307, 30.955> <-9.154, -11.070, 30.936> <-9.032, -10.949, 30.925> 
		<-9.222, -11.479, 30.967> <-9.222, -11.314, 30.954> <-9.128, -11.087, 30.935> <-9.010, -10.970, 30.925> 
		<-9.222, -11.480, 30.957> <-9.222, -11.315, 30.943> <-9.128, -11.088, 30.924> <-9.011, -10.971, 30.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.030, -10.949, 30.936> <-8.909, -10.828, 30.926> <-8.672, -10.731, 30.918> <-8.500, -10.731, 30.918> 
		<-9.032, -10.949, 30.925> <-8.910, -10.827, 30.915> <-8.672, -10.729, 30.907> <-8.500, -10.729, 30.907> 
		<-9.010, -10.970, 30.925> <-8.893, -10.853, 30.916> <-8.666, -10.760, 30.908> <-8.500, -10.760, 30.908> 
		<-9.011, -10.971, 30.914> <-8.894, -10.854, 30.905> <-8.666, -10.760, 30.897> <-8.500, -10.760, 30.897> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.731, 30.918> <-8.328, -10.731, 30.918> <-8.091, -10.828, 30.926> <-7.970, -10.949, 30.936> 
		<-8.500, -10.729, 30.907> <-8.328, -10.729, 30.907> <-8.090, -10.827, 30.915> <-7.968, -10.949, 30.925> 
		<-8.500, -10.760, 30.908> <-8.334, -10.760, 30.908> <-8.107, -10.853, 30.916> <-7.990, -10.970, 30.925> 
		<-8.500, -10.760, 30.897> <-8.334, -10.760, 30.897> <-8.106, -10.854, 30.905> <-7.989, -10.971, 30.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.989, -11.989, 30.999> <-8.106, -12.106, 31.008> <-8.334, -12.200, 31.016> <-8.500, -12.200, 31.016> 
		<-7.989, -11.991, 30.987> <-8.106, -12.107, 30.997> <-8.334, -12.202, 31.004> <-8.500, -12.202, 31.004> 
		<-7.971, -12.008, 30.986> <-8.094, -12.130, 30.996> <-8.327, -12.226, 31.004> <-8.500, -12.226, 31.004> 
		<-7.967, -12.013, 30.976> <-8.090, -12.134, 30.986> <-8.327, -12.232, 30.994> <-8.500, -12.232, 30.994> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.200, 31.016> <-8.666, -12.200, 31.016> <-8.894, -12.106, 31.008> <-9.011, -11.989, 30.999> 
		<-8.500, -12.202, 31.004> <-8.666, -12.202, 31.004> <-8.894, -12.107, 30.997> <-9.011, -11.991, 30.987> 
		<-8.500, -12.226, 31.004> <-8.673, -12.226, 31.004> <-8.906, -12.130, 30.996> <-9.029, -12.008, 30.986> 
		<-8.500, -12.232, 30.994> <-8.673, -12.232, 30.994> <-8.910, -12.134, 30.986> <-9.033, -12.013, 30.976> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.011, -11.989, 30.999> <-9.128, -11.872, 30.989> <-9.222, -11.645, 30.970> <-9.222, -11.480, 30.957> 
		<-9.011, -11.991, 30.987> <-9.129, -11.874, 30.977> <-9.223, -11.646, 30.959> <-9.223, -11.481, 30.945> 
		<-9.029, -12.008, 30.986> <-9.151, -11.886, 30.976> <-9.248, -11.653, 30.957> <-9.248, -11.481, 30.942> 
		<-9.033, -12.013, 30.976> <-9.155, -11.891, 30.966> <-9.253, -11.654, 30.946> <-9.253, -11.482, 30.932> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.222, -11.480, 30.957> <-9.222, -11.315, 30.943> <-9.128, -11.088, 30.924> <-9.011, -10.971, 30.914> 
		<-9.223, -11.481, 30.945> <-9.223, -11.316, 30.931> <-9.129, -11.088, 30.912> <-9.011, -10.971, 30.903> 
		<-9.248, -11.481, 30.942> <-9.248, -11.309, 30.928> <-9.151, -11.076, 30.909> <-9.029, -10.954, 30.899> 
		<-9.253, -11.482, 30.932> <-9.253, -11.310, 30.918> <-9.155, -11.073, 30.898> <-9.033, -10.951, 30.888> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.011, -10.971, 30.914> <-8.894, -10.854, 30.905> <-8.666, -10.760, 30.897> <-8.500, -10.760, 30.897> 
		<-9.011, -10.971, 30.903> <-8.894, -10.854, 30.893> <-8.666, -10.760, 30.885> <-8.500, -10.760, 30.885> 
		<-9.029, -10.954, 30.899> <-8.906, -10.832, 30.889> <-8.673, -10.736, 30.881> <-8.500, -10.736, 30.881> 
		<-9.033, -10.951, 30.888> <-8.910, -10.829, 30.878> <-8.673, -10.731, 30.870> <-8.500, -10.731, 30.870> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.760, 30.897> <-8.334, -10.760, 30.897> <-8.106, -10.854, 30.905> <-7.989, -10.971, 30.914> 
		<-8.500, -10.760, 30.885> <-8.334, -10.760, 30.885> <-8.106, -10.854, 30.893> <-7.989, -10.971, 30.903> 
		<-8.500, -10.736, 30.881> <-8.327, -10.736, 30.881> <-8.094, -10.832, 30.889> <-7.971, -10.954, 30.899> 
		<-8.500, -10.731, 30.870> <-8.327, -10.731, 30.870> <-8.090, -10.829, 30.878> <-7.967, -10.951, 30.888> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.967, -12.013, 30.976> <-8.090, -12.134, 30.986> <-8.327, -12.232, 30.994> <-8.500, -12.232, 30.994> 
		<-7.943, -12.043, 30.913> <-8.065, -12.165, 30.923> <-8.327, -12.273, 30.932> <-8.500, -12.273, 30.932> 
		<-7.894, -12.098, 30.832> <-8.033, -12.236, 30.843> <-8.303, -12.348, 30.852> <-8.500, -12.348, 30.852> 
		<-7.895, -12.104, 30.758> <-8.034, -12.242, 30.769> <-8.303, -12.353, 30.778> <-8.500, -12.353, 30.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.232, 30.994> <-8.673, -12.232, 30.994> <-8.910, -12.134, 30.986> <-9.033, -12.013, 30.976> 
		<-8.500, -12.273, 30.932> <-8.673, -12.273, 30.932> <-8.935, -12.165, 30.923> <-9.057, -12.043, 30.913> 
		<-8.500, -12.348, 30.852> <-8.697, -12.348, 30.852> <-8.967, -12.236, 30.843> <-9.106, -12.098, 30.832> 
		<-8.500, -12.353, 30.778> <-8.697, -12.353, 30.778> <-8.966, -12.242, 30.769> <-9.105, -12.104, 30.758> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.033, -12.013, 30.976> <-9.155, -11.891, 30.966> <-9.253, -11.654, 30.946> <-9.253, -11.482, 30.932> 
		<-9.057, -12.043, 30.913> <-9.180, -11.921, 30.903> <-9.288, -11.660, 30.881> <-9.288, -11.487, 30.867> 
		<-9.106, -12.098, 30.832> <-9.245, -11.959, 30.820> <-9.356, -11.690, 30.798> <-9.356, -11.494, 30.782> 
		<-9.105, -12.104, 30.758> <-9.244, -11.965, 30.746> <-9.356, -11.696, 30.724> <-9.356, -11.500, 30.708> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.253, -11.482, 30.932> <-9.253, -11.310, 30.918> <-9.155, -11.073, 30.898> <-9.033, -10.951, 30.888> 
		<-9.288, -11.487, 30.867> <-9.288, -11.315, 30.853> <-9.180, -11.054, 30.831> <-9.057, -10.932, 30.821> 
		<-9.356, -11.494, 30.782> <-9.356, -11.299, 30.765> <-9.245, -11.029, 30.743> <-9.106, -10.891, 30.732> 
		<-9.356, -11.500, 30.708> <-9.356, -11.305, 30.691> <-9.244, -11.036, 30.669> <-9.105, -10.897, 30.658> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.033, -10.951, 30.888> <-8.910, -10.829, 30.878> <-8.673, -10.731, 30.870> <-8.500, -10.731, 30.870> 
		<-9.057, -10.932, 30.821> <-8.935, -10.810, 30.811> <-8.673, -10.702, 30.802> <-8.500, -10.702, 30.802> 
		<-9.106, -10.891, 30.732> <-8.967, -10.752, 30.720> <-8.697, -10.641, 30.711> <-8.500, -10.641, 30.711> 
		<-9.105, -10.897, 30.658> <-8.966, -10.759, 30.646> <-8.697, -10.648, 30.637> <-8.500, -10.648, 30.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.731, 30.870> <-8.327, -10.731, 30.870> <-8.090, -10.829, 30.878> <-7.967, -10.951, 30.888> 
		<-8.500, -10.702, 30.802> <-8.327, -10.702, 30.802> <-8.065, -10.810, 30.811> <-7.943, -10.932, 30.821> 
		<-8.500, -10.641, 30.711> <-8.303, -10.641, 30.711> <-8.033, -10.752, 30.720> <-7.894, -10.891, 30.732> 
		<-8.500, -10.648, 30.637> <-8.303, -10.648, 30.637> <-8.034, -10.759, 30.646> <-7.895, -10.897, 30.658> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.895, -12.104, 30.758> <-8.034, -12.242, 30.769> <-8.303, -12.353, 30.778> <-8.500, -12.353, 30.778> 
		<-7.895, -12.109, 30.683> <-8.034, -12.248, 30.694> <-8.303, -12.359, 30.703> <-8.500, -12.359, 30.703> 
		<-7.943, -12.069, 30.593> <-8.065, -12.190, 30.603> <-8.328, -12.298, 30.612> <-8.500, -12.298, 30.612> 
		<-7.970, -12.048, 30.525> <-8.091, -12.169, 30.535> <-8.328, -12.267, 30.543> <-8.500, -12.267, 30.543> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.353, 30.778> <-8.697, -12.353, 30.778> <-8.966, -12.242, 30.769> <-9.105, -12.104, 30.758> 
		<-8.500, -12.359, 30.703> <-8.697, -12.359, 30.703> <-8.966, -12.248, 30.694> <-9.105, -12.109, 30.683> 
		<-8.500, -12.298, 30.612> <-8.672, -12.298, 30.612> <-8.935, -12.190, 30.603> <-9.057, -12.069, 30.593> 
		<-8.500, -12.267, 30.543> <-8.672, -12.267, 30.543> <-8.909, -12.169, 30.535> <-9.030, -12.048, 30.525> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.105, -12.104, 30.758> <-9.244, -11.965, 30.746> <-9.356, -11.696, 30.724> <-9.356, -11.500, 30.708> 
		<-9.105, -12.109, 30.683> <-9.244, -11.971, 30.671> <-9.355, -11.703, 30.649> <-9.355, -11.507, 30.633> 
		<-9.057, -12.069, 30.593> <-9.178, -11.947, 30.582> <-9.287, -11.685, 30.561> <-9.287, -11.514, 30.547> 
		<-9.030, -12.048, 30.525> <-9.152, -11.926, 30.515> <-9.250, -11.691, 30.496> <-9.250, -11.519, 30.482> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.356, -11.500, 30.708> <-9.356, -11.305, 30.691> <-9.244, -11.036, 30.669> <-9.105, -10.897, 30.658> 
		<-9.355, -11.507, 30.633> <-9.355, -11.311, 30.617> <-9.244, -11.042, 30.594> <-9.105, -10.904, 30.583> 
		<-9.287, -11.514, 30.547> <-9.287, -11.342, 30.532> <-9.178, -11.080, 30.511> <-9.057, -10.959, 30.501> 
		<-9.250, -11.519, 30.482> <-9.250, -11.348, 30.467> <-9.152, -11.112, 30.448> <-9.030, -10.991, 30.438> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.105, -10.897, 30.658> <-8.966, -10.759, 30.646> <-8.697, -10.648, 30.637> <-8.500, -10.648, 30.637> 
		<-9.105, -10.904, 30.583> <-8.966, -10.765, 30.571> <-8.697, -10.654, 30.562> <-8.500, -10.654, 30.562> 
		<-9.057, -10.959, 30.501> <-8.935, -10.838, 30.491> <-8.672, -10.729, 30.482> <-8.500, -10.729, 30.482> 
		<-9.030, -10.991, 30.438> <-8.909, -10.869, 30.428> <-8.672, -10.772, 30.420> <-8.500, -10.772, 30.420> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.648, 30.637> <-8.303, -10.648, 30.637> <-8.034, -10.759, 30.646> <-7.895, -10.897, 30.658> 
		<-8.500, -10.654, 30.562> <-8.303, -10.654, 30.562> <-8.034, -10.765, 30.571> <-7.895, -10.904, 30.583> 
		<-8.500, -10.729, 30.482> <-8.328, -10.729, 30.482> <-8.065, -10.838, 30.491> <-7.943, -10.959, 30.501> 
		<-8.500, -10.772, 30.420> <-8.328, -10.772, 30.420> <-8.091, -10.869, 30.428> <-7.970, -10.991, 30.438> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.970, -12.048, 30.525> <-8.091, -12.169, 30.535> <-8.328, -12.267, 30.543> <-8.500, -12.267, 30.543> 
		<-7.974, -12.044, 30.515> <-8.096, -12.166, 30.525> <-8.328, -12.262, 30.533> <-8.500, -12.262, 30.533> 
		<-7.993, -12.025, 30.515> <-8.109, -12.141, 30.525> <-8.336, -12.234, 30.533> <-8.500, -12.234, 30.533> 
		<-7.994, -12.025, 30.503> <-8.110, -12.141, 30.513> <-8.336, -12.234, 30.521> <-8.500, -12.234, 30.521> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.267, 30.543> <-8.672, -12.267, 30.543> <-8.909, -12.169, 30.535> <-9.030, -12.048, 30.525> 
		<-8.500, -12.262, 30.533> <-8.672, -12.262, 30.533> <-8.904, -12.166, 30.525> <-9.026, -12.044, 30.515> 
		<-8.500, -12.234, 30.533> <-8.664, -12.234, 30.533> <-8.891, -12.141, 30.525> <-9.007, -12.025, 30.515> 
		<-8.500, -12.234, 30.521> <-8.664, -12.234, 30.521> <-8.890, -12.141, 30.513> <-9.006, -12.025, 30.503> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.030, -12.048, 30.525> <-9.152, -11.926, 30.515> <-9.250, -11.691, 30.496> <-9.250, -11.519, 30.482> 
		<-9.026, -12.044, 30.515> <-9.148, -11.923, 30.505> <-9.244, -11.692, 30.485> <-9.244, -11.520, 30.471> 
		<-9.007, -12.025, 30.515> <-9.123, -11.909, 30.506> <-9.217, -11.684, 30.487> <-9.217, -11.520, 30.474> 
		<-9.006, -12.025, 30.503> <-9.122, -11.909, 30.494> <-9.215, -11.685, 30.475> <-9.215, -11.521, 30.462> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.250, -11.519, 30.482> <-9.250, -11.348, 30.467> <-9.152, -11.112, 30.448> <-9.030, -10.991, 30.438> 
		<-9.244, -11.520, 30.471> <-9.244, -11.348, 30.457> <-9.148, -11.117, 30.438> <-9.026, -10.996, 30.428> 
		<-9.217, -11.520, 30.474> <-9.217, -11.356, 30.460> <-9.123, -11.131, 30.441> <-9.007, -11.015, 30.432> 
		<-9.215, -11.521, 30.462> <-9.215, -11.357, 30.448> <-9.122, -11.132, 30.429> <-9.006, -11.017, 30.420> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.030, -10.991, 30.438> <-8.909, -10.869, 30.428> <-8.672, -10.772, 30.420> <-8.500, -10.772, 30.420> 
		<-9.026, -10.996, 30.428> <-8.904, -10.874, 30.418> <-8.672, -10.779, 30.410> <-8.500, -10.779, 30.410> 
		<-9.007, -11.015, 30.432> <-8.891, -10.899, 30.422> <-8.664, -10.806, 30.414> <-8.500, -10.806, 30.414> 
		<-9.006, -11.017, 30.420> <-8.890, -10.901, 30.410> <-8.664, -10.808, 30.403> <-8.500, -10.808, 30.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.772, 30.420> <-8.328, -10.772, 30.420> <-8.091, -10.869, 30.428> <-7.970, -10.991, 30.438> 
		<-8.500, -10.779, 30.410> <-8.328, -10.779, 30.410> <-8.096, -10.874, 30.418> <-7.974, -10.996, 30.428> 
		<-8.500, -10.806, 30.414> <-8.336, -10.806, 30.414> <-8.109, -10.899, 30.422> <-7.993, -11.015, 30.432> 
		<-8.500, -10.808, 30.403> <-8.336, -10.808, 30.403> <-8.110, -10.901, 30.410> <-7.994, -11.017, 30.420> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.994, -12.025, 30.503> <-8.110, -12.141, 30.513> <-8.336, -12.234, 30.521> <-8.500, -12.234, 30.521> 
		<-7.995, -12.025, 30.491> <-8.111, -12.141, 30.501> <-8.336, -12.234, 30.508> <-8.500, -12.234, 30.508> 
		<-7.973, -12.047, 30.490> <-8.094, -12.168, 30.500> <-8.329, -12.264, 30.508> <-8.500, -12.264, 30.508> 
		<-7.973, -12.048, 30.478> <-8.094, -12.169, 30.488> <-8.329, -12.266, 30.496> <-8.500, -12.266, 30.496> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.234, 30.521> <-8.664, -12.234, 30.521> <-8.890, -12.141, 30.513> <-9.006, -12.025, 30.503> 
		<-8.500, -12.234, 30.508> <-8.664, -12.234, 30.508> <-8.889, -12.141, 30.501> <-9.005, -12.025, 30.491> 
		<-8.500, -12.264, 30.508> <-8.671, -12.264, 30.508> <-8.906, -12.168, 30.500> <-9.027, -12.047, 30.490> 
		<-8.500, -12.266, 30.496> <-8.671, -12.266, 30.496> <-8.906, -12.169, 30.488> <-9.027, -12.048, 30.478> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.006, -12.025, 30.503> <-9.122, -11.909, 30.494> <-9.215, -11.685, 30.475> <-9.215, -11.521, 30.462> 
		<-9.005, -12.025, 30.491> <-9.121, -11.909, 30.482> <-9.214, -11.686, 30.463> <-9.214, -11.522, 30.450> 
		<-9.027, -12.047, 30.490> <-9.148, -11.926, 30.480> <-9.245, -11.693, 30.460> <-9.245, -11.522, 30.446> 
		<-9.027, -12.048, 30.478> <-9.148, -11.928, 30.468> <-9.245, -11.694, 30.448> <-9.245, -11.523, 30.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.215, -11.521, 30.462> <-9.215, -11.357, 30.448> <-9.122, -11.132, 30.429> <-9.006, -11.017, 30.420> 
		<-9.214, -11.522, 30.450> <-9.214, -11.358, 30.436> <-9.121, -11.134, 30.417> <-9.005, -11.019, 30.408> 
		<-9.245, -11.522, 30.446> <-9.245, -11.352, 30.432> <-9.148, -11.118, 30.413> <-9.027, -10.997, 30.403> 
		<-9.245, -11.523, 30.434> <-9.245, -11.353, 30.420> <-9.148, -11.119, 30.401> <-9.027, -10.998, 30.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.006, -11.017, 30.420> <-8.890, -10.901, 30.410> <-8.664, -10.808, 30.403> <-8.500, -10.808, 30.403> 
		<-9.005, -11.019, 30.408> <-8.889, -10.903, 30.398> <-8.664, -10.810, 30.391> <-8.500, -10.810, 30.391> 
		<-9.027, -10.997, 30.403> <-8.906, -10.877, 30.393> <-8.671, -10.780, 30.385> <-8.500, -10.780, 30.385> 
		<-9.027, -10.998, 30.391> <-8.906, -10.877, 30.381> <-8.671, -10.781, 30.373> <-8.500, -10.781, 30.373> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.808, 30.403> <-8.336, -10.808, 30.403> <-8.110, -10.901, 30.410> <-7.994, -11.017, 30.420> 
		<-8.500, -10.810, 30.391> <-8.336, -10.810, 30.391> <-8.111, -10.903, 30.398> <-7.995, -11.019, 30.408> 
		<-8.500, -10.780, 30.385> <-8.329, -10.780, 30.385> <-8.094, -10.877, 30.393> <-7.973, -10.997, 30.403> 
		<-8.500, -10.781, 30.373> <-8.329, -10.781, 30.373> <-8.094, -10.877, 30.381> <-7.973, -10.998, 30.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.973, -12.048, 30.478> <-8.094, -12.169, 30.488> <-8.329, -12.266, 30.496> <-8.500, -12.266, 30.496> 
		<-7.966, -12.085, 30.119> <-8.087, -12.206, 30.129> <-8.329, -12.306, 30.137> <-8.500, -12.306, 30.137> 
		<-7.969, -12.122, 29.639> <-8.090, -12.243, 29.649> <-8.328, -12.341, 29.657> <-8.500, -12.341, 29.657> 
		<-7.970, -12.151, 29.280> <-8.091, -12.272, 29.290> <-8.328, -12.370, 29.298> <-8.500, -12.370, 29.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.266, 30.496> <-8.671, -12.266, 30.496> <-8.906, -12.169, 30.488> <-9.027, -12.048, 30.478> 
		<-8.500, -12.306, 30.137> <-8.671, -12.306, 30.137> <-8.913, -12.206, 30.129> <-9.034, -12.085, 30.119> 
		<-8.500, -12.341, 29.657> <-8.672, -12.341, 29.657> <-8.910, -12.243, 29.649> <-9.031, -12.122, 29.639> 
		<-8.500, -12.370, 29.298> <-8.672, -12.370, 29.298> <-8.909, -12.272, 29.290> <-9.030, -12.151, 29.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.027, -12.048, 30.478> <-9.148, -11.928, 30.468> <-9.245, -11.694, 30.448> <-9.245, -11.523, 30.434> 
		<-9.034, -12.085, 30.119> <-9.155, -11.965, 30.109> <-9.255, -11.723, 30.089> <-9.255, -11.553, 30.075> 
		<-9.031, -12.122, 29.639> <-9.153, -12.001, 29.629> <-9.252, -11.764, 29.610> <-9.252, -11.593, 29.595> 
		<-9.030, -12.151, 29.280> <-9.152, -12.029, 29.270> <-9.250, -11.794, 29.250> <-9.250, -11.622, 29.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.245, -11.523, 30.434> <-9.245, -11.353, 30.420> <-9.148, -11.119, 30.401> <-9.027, -10.998, 30.391> 
		<-9.255, -11.553, 30.075> <-9.255, -11.382, 30.061> <-9.155, -11.141, 30.041> <-9.034, -11.021, 30.031> 
		<-9.252, -11.593, 29.595> <-9.252, -11.421, 29.581> <-9.153, -11.184, 29.562> <-9.031, -11.063, 29.552> 
		<-9.250, -11.622, 29.236> <-9.250, -11.451, 29.222> <-9.152, -11.215, 29.202> <-9.030, -11.094, 29.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.027, -10.998, 30.391> <-8.906, -10.877, 30.381> <-8.671, -10.781, 30.373> <-8.500, -10.781, 30.373> 
		<-9.034, -11.021, 30.031> <-8.913, -10.900, 30.021> <-8.671, -10.800, 30.013> <-8.500, -10.800, 30.013> 
		<-9.031, -11.063, 29.552> <-8.910, -10.942, 29.541> <-8.672, -10.844, 29.533> <-8.500, -10.844, 29.533> 
		<-9.030, -11.094, 29.192> <-8.909, -10.972, 29.182> <-8.672, -10.875, 29.174> <-8.500, -10.875, 29.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.781, 30.373> <-8.329, -10.781, 30.373> <-8.094, -10.877, 30.381> <-7.973, -10.998, 30.391> 
		<-8.500, -10.800, 30.013> <-8.329, -10.800, 30.013> <-8.087, -10.900, 30.021> <-7.966, -11.021, 30.031> 
		<-8.500, -10.844, 29.533> <-8.328, -10.844, 29.533> <-8.090, -10.942, 29.541> <-7.969, -11.063, 29.552> 
		<-8.500, -10.875, 29.174> <-8.328, -10.875, 29.174> <-8.091, -10.972, 29.182> <-7.970, -11.094, 29.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.970, -12.151, 29.280> <-8.091, -12.272, 29.290> <-8.328, -12.370, 29.298> <-8.500, -12.370, 29.298> 
		<-7.971, -12.187, 28.827> <-8.093, -12.308, 28.837> <-8.328, -12.405, 28.845> <-8.500, -12.405, 28.845> 
		<-7.978, -12.230, 28.224> <-8.097, -12.349, 28.234> <-8.332, -12.446, 28.242> <-8.500, -12.446, 28.242> 
		<-7.981, -12.264, 27.771> <-8.100, -12.383, 27.781> <-8.332, -12.478, 27.789> <-8.500, -12.478, 27.789> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -12.370, 29.298> <-8.672, -12.370, 29.298> <-8.909, -12.272, 29.290> <-9.030, -12.151, 29.280> 
		<-8.500, -12.405, 28.845> <-8.672, -12.405, 28.845> <-8.907, -12.308, 28.837> <-9.029, -12.187, 28.827> 
		<-8.500, -12.446, 28.242> <-8.668, -12.446, 28.242> <-8.903, -12.349, 28.234> <-9.022, -12.230, 28.224> 
		<-8.500, -12.478, 27.789> <-8.668, -12.478, 27.789> <-8.900, -12.383, 27.781> <-9.019, -12.264, 27.771> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.030, -12.151, 29.280> <-9.152, -12.029, 29.270> <-9.250, -11.794, 29.250> <-9.250, -11.622, 29.236> 
		<-9.029, -12.187, 28.827> <-9.151, -12.066, 28.817> <-9.248, -11.831, 28.798> <-9.248, -11.660, 28.784> 
		<-9.022, -12.230, 28.224> <-9.141, -12.111, 28.214> <-9.239, -11.877, 28.195> <-9.239, -11.710, 28.181> 
		<-9.019, -12.264, 27.771> <-9.138, -12.145, 27.762> <-9.234, -11.915, 27.743> <-9.234, -11.747, 27.729> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.250, -11.622, 29.236> <-9.250, -11.451, 29.222> <-9.152, -11.215, 29.202> <-9.030, -11.094, 29.192> 
		<-9.248, -11.660, 28.784> <-9.248, -11.488, 28.769> <-9.151, -11.254, 28.750> <-9.029, -11.133, 28.740> 
		<-9.239, -11.710, 28.181> <-9.239, -11.542, 28.167> <-9.141, -11.308, 28.148> <-9.022, -11.189, 28.138> 
		<-9.234, -11.747, 27.729> <-9.234, -11.579, 27.715> <-9.138, -11.349, 27.696> <-9.019, -11.230, 27.686> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.030, -11.094, 29.192> <-8.909, -10.972, 29.182> <-8.672, -10.875, 29.174> <-8.500, -10.875, 29.174> 
		<-9.029, -11.133, 28.740> <-8.907, -11.011, 28.730> <-8.672, -10.914, 28.722> <-8.500, -10.914, 28.722> 
		<-9.022, -11.189, 28.138> <-8.903, -11.070, 28.128> <-8.668, -10.974, 28.120> <-8.500, -10.974, 28.120> 
		<-9.019, -11.230, 27.686> <-8.900, -11.111, 27.676> <-8.668, -11.016, 27.668> <-8.500, -11.016, 27.668> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, -10.875, 29.174> <-8.328, -10.875, 29.174> <-8.091, -10.972, 29.182> <-7.970, -11.094, 29.192> 
		<-8.500, -10.914, 28.722> <-8.328, -10.914, 28.722> <-8.093, -11.011, 28.730> <-7.971, -11.133, 28.740> 
		<-8.500, -10.974, 28.120> <-8.332, -10.974, 28.120> <-8.097, -11.070, 28.128> <-7.978, -11.189, 28.138> 
		<-8.500, -11.016, 27.668> <-8.332, -11.016, 27.668> <-8.100, -11.111, 27.676> <-7.981, -11.230, 27.686> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.390, -14.557, -40.059> <-8.401, -14.595, -40.034> <-8.430, -14.636, -39.975> <-8.429, -14.684, -39.974> 
		<-8.326, -14.554, -40.027> <-8.338, -14.593, -40.001> <-8.429, -14.685, -39.974> <-8.428, -14.733, -39.974> 
		<-8.272, -14.612, -39.999> <-8.270, -14.683, -39.998> <-8.333, -14.775, -39.999> <-8.396, -14.777, -40.032> 
		<-8.270, -14.683, -39.998> <-8.268, -14.754, -39.998> <-8.319, -14.815, -40.024> <-8.382, -14.817, -40.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.390, -14.557, -40.059> <-8.326, -14.554, -40.027> <-8.272, -14.612, -39.999> <-8.270, -14.683, -39.998> 
		<-8.230, -14.576, -40.370> <-8.166, -14.574, -40.338> <-8.081, -14.630, -40.292> <-8.079, -14.701, -40.292> 
		<-8.016, -14.602, -40.785> <-7.953, -14.600, -40.753> <-7.864, -14.656, -40.710> <-7.862, -14.727, -40.709> 
		<-7.856, -14.622, -41.097> <-7.793, -14.620, -41.064> <-7.739, -14.677, -41.037> <-7.737, -14.748, -41.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.390, -14.557, -40.059> <-8.390, -14.557, -40.059> <-8.390, -14.557, -40.059> <-8.390, -14.557, -40.059> 
		<-8.401, -14.595, -40.034> <-8.338, -14.593, -40.001> <-8.338, -14.593, -40.001> <-8.326, -14.554, -40.027> 
		<-8.430, -14.636, -39.975> <-8.388, -14.635, -39.953> <-8.298, -14.610, -39.959> <-8.272, -14.612, -39.999> 
		<-8.429, -14.684, -39.974> <-8.386, -14.682, -39.952> <-8.296, -14.681, -39.958> <-8.270, -14.683, -39.998> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.390, -14.557, -40.059> <-8.326, -14.554, -40.027> <-8.272, -14.612, -39.999> <-8.270, -14.683, -39.998> 
		<-8.453, -14.559, -40.092> <-8.390, -14.557, -40.059> <-8.298, -14.610, -39.959> <-8.296, -14.681, -39.958> 
		<-8.504, -14.620, -40.118> <-8.521, -14.617, -40.073> <-8.429, -14.684, -39.974> <-8.386, -14.682, -39.952> 
		<-8.502, -14.691, -40.117> <-8.519, -14.688, -40.072> <-8.472, -14.685, -39.996> <-8.429, -14.684, -39.974> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.390, -14.557, -40.059> <-8.453, -14.559, -40.092> <-8.504, -14.620, -40.118> <-8.502, -14.691, -40.117> 
		<-8.401, -14.595, -40.034> <-8.465, -14.597, -40.066> <-8.502, -14.691, -40.117> <-8.500, -14.762, -40.116> 
		<-8.430, -14.636, -39.975> <-8.429, -14.685, -39.974> <-8.460, -14.779, -40.064> <-8.445, -14.819, -40.089> 
		<-8.429, -14.684, -39.974> <-8.428, -14.733, -39.974> <-8.396, -14.777, -40.032> <-8.382, -14.817, -40.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.390, -14.557, -40.059> <-8.390, -14.557, -40.059> <-8.390, -14.557, -40.059> <-8.390, -14.557, -40.059> 
		<-8.401, -14.595, -40.034> <-8.465, -14.597, -40.066> <-8.465, -14.597, -40.066> <-8.453, -14.559, -40.092> 
		<-8.430, -14.636, -39.975> <-8.473, -14.638, -39.997> <-8.521, -14.617, -40.073> <-8.504, -14.620, -40.118> 
		<-8.429, -14.684, -39.974> <-8.472, -14.685, -39.996> <-8.519, -14.688, -40.072> <-8.502, -14.691, -40.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.390, -14.557, -40.059> <-8.453, -14.559, -40.092> <-8.504, -14.620, -40.118> <-8.502, -14.691, -40.117> 
		<-8.230, -14.576, -40.370> <-8.293, -14.578, -40.403> <-8.376, -14.640, -40.444> <-8.374, -14.711, -40.443> 
		<-8.016, -14.602, -40.785> <-8.080, -14.604, -40.818> <-8.160, -14.666, -40.861> <-8.158, -14.737, -40.861> 
		<-7.856, -14.622, -41.097> <-7.920, -14.624, -41.129> <-7.970, -14.685, -41.155> <-7.968, -14.756, -41.154> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.382, -14.817, -40.056> <-8.382, -14.817, -40.056> <-8.382, -14.817, -40.056> <-8.382, -14.817, -40.056> 
		<-8.396, -14.777, -40.032> <-8.460, -14.779, -40.064> <-8.460, -14.779, -40.064> <-8.445, -14.819, -40.089> 
		<-8.428, -14.733, -39.974> <-8.471, -14.734, -39.995> <-8.517, -14.759, -40.071> <-8.500, -14.762, -40.116> 
		<-8.429, -14.684, -39.974> <-8.472, -14.685, -39.996> <-8.519, -14.688, -40.072> <-8.502, -14.691, -40.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.382, -14.817, -40.056> <-8.445, -14.819, -40.089> <-8.500, -14.762, -40.116> <-8.502, -14.691, -40.117> 
		<-8.319, -14.815, -40.024> <-8.382, -14.817, -40.056> <-8.517, -14.759, -40.071> <-8.519, -14.688, -40.072> 
		<-8.268, -14.754, -39.998> <-8.294, -14.752, -39.957> <-8.429, -14.684, -39.974> <-8.472, -14.685, -39.996> 
		<-8.270, -14.683, -39.998> <-8.296, -14.681, -39.958> <-8.386, -14.682, -39.952> <-8.429, -14.684, -39.974> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.382, -14.817, -40.056> <-8.445, -14.819, -40.089> <-8.500, -14.762, -40.116> <-8.502, -14.691, -40.117> 
		<-8.222, -14.837, -40.367> <-8.285, -14.839, -40.400> <-8.372, -14.782, -40.442> <-8.374, -14.711, -40.443> 
		<-8.009, -14.863, -40.782> <-8.072, -14.865, -40.815> <-8.156, -14.808, -40.860> <-8.158, -14.737, -40.861> 
		<-7.849, -14.882, -41.094> <-7.912, -14.884, -41.126> <-7.966, -14.827, -41.154> <-7.968, -14.756, -41.154> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.382, -14.817, -40.056> <-8.222, -14.837, -40.367> <-8.009, -14.863, -40.782> <-7.849, -14.882, -41.094> 
		<-8.319, -14.815, -40.024> <-8.159, -14.835, -40.335> <-7.946, -14.861, -40.750> <-7.786, -14.880, -41.061> 
		<-8.268, -14.754, -39.998> <-8.077, -14.772, -40.291> <-7.860, -14.798, -40.708> <-7.735, -14.819, -41.035> 
		<-8.270, -14.683, -39.998> <-8.079, -14.701, -40.292> <-7.862, -14.727, -40.709> <-7.737, -14.748, -41.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.382, -14.817, -40.056> <-8.382, -14.817, -40.056> <-8.382, -14.817, -40.056> <-8.382, -14.817, -40.056> 
		<-8.319, -14.815, -40.024> <-8.333, -14.775, -39.999> <-8.333, -14.775, -39.999> <-8.396, -14.777, -40.032> 
		<-8.268, -14.754, -39.998> <-8.294, -14.752, -39.957> <-8.385, -14.731, -39.952> <-8.428, -14.733, -39.974> 
		<-8.270, -14.683, -39.998> <-8.296, -14.681, -39.958> <-8.386, -14.682, -39.952> <-8.429, -14.684, -39.974> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.856, -14.622, -41.097> <-7.856, -14.622, -41.097> <-7.856, -14.622, -41.097> <-7.856, -14.622, -41.097> 
		<-7.846, -14.663, -41.118> <-7.909, -14.665, -41.150> <-7.909, -14.665, -41.150> <-7.920, -14.624, -41.129> 
		<-7.824, -14.711, -41.168> <-7.863, -14.712, -41.188> <-7.947, -14.687, -41.192> <-7.970, -14.685, -41.155> 
		<-7.822, -14.758, -41.168> <-7.861, -14.759, -41.188> <-7.945, -14.758, -41.191> <-7.968, -14.756, -41.154> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.856, -14.622, -41.097> <-7.856, -14.622, -41.097> <-7.856, -14.622, -41.097> <-7.856, -14.622, -41.097> 
		<-7.793, -14.620, -41.064> <-7.783, -14.660, -41.086> <-7.783, -14.660, -41.086> <-7.846, -14.663, -41.118> 
		<-7.739, -14.677, -41.037> <-7.722, -14.680, -41.081> <-7.782, -14.709, -41.147> <-7.824, -14.711, -41.168> 
		<-7.737, -14.748, -41.036> <-7.720, -14.751, -41.080> <-7.780, -14.756, -41.146> <-7.822, -14.758, -41.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.856, -14.622, -41.097> <-7.846, -14.663, -41.118> <-7.824, -14.711, -41.168> <-7.822, -14.758, -41.168> 
		<-7.920, -14.624, -41.129> <-7.909, -14.665, -41.150> <-7.822, -14.755, -41.168> <-7.821, -14.802, -41.167> 
		<-7.970, -14.685, -41.155> <-7.968, -14.756, -41.154> <-7.904, -14.847, -41.148> <-7.841, -14.845, -41.116> 
		<-7.968, -14.756, -41.154> <-7.966, -14.827, -41.154> <-7.912, -14.884, -41.126> <-7.849, -14.882, -41.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.856, -14.622, -41.097> <-7.846, -14.663, -41.118> <-7.824, -14.711, -41.168> <-7.822, -14.758, -41.168> 
		<-7.793, -14.620, -41.064> <-7.783, -14.660, -41.086> <-7.822, -14.755, -41.168> <-7.821, -14.802, -41.167> 
		<-7.739, -14.677, -41.037> <-7.737, -14.748, -41.036> <-7.778, -14.843, -41.084> <-7.841, -14.845, -41.116> 
		<-7.737, -14.748, -41.036> <-7.735, -14.819, -41.035> <-7.786, -14.880, -41.061> <-7.849, -14.882, -41.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.856, -14.622, -41.097> <-7.793, -14.620, -41.064> <-7.739, -14.677, -41.037> <-7.737, -14.748, -41.036> 
		<-7.920, -14.624, -41.129> <-7.856, -14.622, -41.097> <-7.722, -14.680, -41.081> <-7.720, -14.751, -41.080> 
		<-7.970, -14.685, -41.155> <-7.947, -14.687, -41.192> <-7.819, -14.758, -41.166> <-7.780, -14.756, -41.146> 
		<-7.968, -14.756, -41.154> <-7.945, -14.758, -41.191> <-7.861, -14.759, -41.188> <-7.822, -14.758, -41.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.849, -14.882, -41.094> <-7.912, -14.884, -41.126> <-7.966, -14.827, -41.154> <-7.968, -14.756, -41.154> 
		<-7.786, -14.880, -41.061> <-7.849, -14.882, -41.094> <-7.943, -14.829, -41.191> <-7.945, -14.758, -41.191> 
		<-7.735, -14.819, -41.035> <-7.718, -14.822, -41.079> <-7.819, -14.758, -41.166> <-7.861, -14.759, -41.188> 
		<-7.737, -14.748, -41.036> <-7.720, -14.751, -41.080> <-7.780, -14.756, -41.146> <-7.822, -14.758, -41.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.849, -14.882, -41.094> <-7.849, -14.882, -41.094> <-7.849, -14.882, -41.094> <-7.849, -14.882, -41.094> 
		<-7.841, -14.845, -41.116> <-7.904, -14.847, -41.148> <-7.904, -14.847, -41.148> <-7.912, -14.884, -41.126> 
		<-7.821, -14.802, -41.167> <-7.860, -14.803, -41.187> <-7.943, -14.829, -41.191> <-7.966, -14.827, -41.154> 
		<-7.822, -14.758, -41.168> <-7.861, -14.759, -41.188> <-7.945, -14.758, -41.191> <-7.968, -14.756, -41.154> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.849, -14.882, -41.094> <-7.849, -14.882, -41.094> <-7.849, -14.882, -41.094> <-7.849, -14.882, -41.094> 
		<-7.841, -14.845, -41.116> <-7.778, -14.843, -41.084> <-7.778, -14.843, -41.084> <-7.786, -14.880, -41.061> 
		<-7.821, -14.802, -41.167> <-7.779, -14.801, -41.146> <-7.718, -14.822, -41.079> <-7.735, -14.819, -41.035> 
		<-7.822, -14.758, -41.168> <-7.780, -14.756, -41.146> <-7.720, -14.751, -41.080> <-7.737, -14.748, -41.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.211, -16.127, -40.942> <-9.211, -16.127, -40.942> <-9.211, -16.127, -40.942> <-9.211, -16.127, -40.942> 
		<-9.326, -16.155, -40.696> <-9.211, -16.127, -40.942> <-9.211, -16.127, -40.942> <-9.096, -16.100, -41.188> 
		<-9.321, -16.380, -40.467> <-9.141, -16.318, -40.699> <-8.965, -16.276, -41.075> <-8.900, -16.279, -41.368> 
		<-9.201, -16.622, -40.437> <-9.020, -16.561, -40.669> <-8.844, -16.519, -41.046> <-8.779, -16.522, -41.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.211, -16.127, -40.942> <-9.326, -16.155, -40.696> <-9.321, -16.380, -40.467> <-9.201, -16.622, -40.437> 
		<-9.270, -16.161, -40.974> <-9.385, -16.188, -40.728> <-9.367, -16.395, -40.409> <-9.246, -16.638, -40.380> 
		<-9.397, -16.166, -41.034> <-9.512, -16.193, -40.789> <-9.506, -16.476, -40.501> <-9.385, -16.719, -40.471> 
		<-9.408, -16.239, -41.048> <-9.523, -16.266, -40.802> <-9.518, -16.491, -40.573> <-9.398, -16.734, -40.544> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.211, -16.127, -40.942> <-9.270, -16.161, -40.974> <-9.397, -16.166, -41.034> <-9.408, -16.239, -41.048> 
		<-9.096, -16.100, -41.188> <-9.155, -16.133, -41.220> <-9.282, -16.138, -41.280> <-9.293, -16.211, -41.294> 
		<-8.900, -16.279, -41.368> <-8.884, -16.280, -41.441> <-9.035, -16.364, -41.507> <-9.097, -16.391, -41.474> 
		<-8.779, -16.522, -41.339> <-8.763, -16.523, -41.412> <-8.914, -16.607, -41.478> <-8.976, -16.633, -41.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.768, -17.017, -40.834> <-8.653, -16.990, -41.080> <-8.658, -16.765, -41.309> <-8.779, -16.522, -41.339> 
		<-8.828, -17.051, -40.866> <-8.713, -17.023, -41.112> <-8.642, -16.766, -41.382> <-8.763, -16.523, -41.412> 
		<-8.903, -17.161, -40.914> <-8.788, -17.133, -41.160> <-8.793, -16.849, -41.448> <-8.914, -16.607, -41.478> 
		<-8.965, -17.129, -40.940> <-8.850, -17.101, -41.186> <-8.855, -16.876, -41.415> <-8.976, -16.633, -41.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.768, -17.017, -40.834> <-8.768, -17.017, -40.834> <-8.768, -17.017, -40.834> <-8.768, -17.017, -40.834> 
		<-8.653, -16.990, -41.080> <-8.768, -17.017, -40.834> <-8.768, -17.017, -40.834> <-8.883, -17.045, -40.588> 
		<-8.658, -16.765, -41.309> <-8.724, -16.762, -41.016> <-8.900, -16.804, -40.640> <-9.080, -16.865, -40.408> 
		<-8.779, -16.522, -41.339> <-8.844, -16.519, -41.046> <-9.020, -16.561, -40.669> <-9.201, -16.622, -40.437> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.768, -17.017, -40.834> <-8.828, -17.051, -40.866> <-8.903, -17.161, -40.914> <-8.965, -17.129, -40.940> 
		<-8.883, -17.045, -40.588> <-8.943, -17.078, -40.620> <-9.018, -17.188, -40.668> <-9.080, -17.156, -40.694> 
		<-9.080, -16.865, -40.408> <-9.125, -16.881, -40.350> <-9.265, -16.962, -40.442> <-9.277, -16.977, -40.514> 
		<-9.201, -16.622, -40.437> <-9.246, -16.638, -40.380> <-9.385, -16.719, -40.471> <-9.398, -16.734, -40.544> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.297, -16.695, -41.048> <-9.330, -16.558, -41.048> <-9.429, -16.376, -41.074> <-9.408, -16.239, -41.048> 
		<-9.307, -16.697, -41.025> <-9.341, -16.560, -41.025> <-9.544, -16.403, -40.828> <-9.523, -16.266, -40.802> 
		<-9.309, -16.719, -41.006> <-9.339, -16.717, -40.868> <-9.541, -16.519, -40.709> <-9.518, -16.491, -40.573> 
		<-9.296, -16.739, -41.002> <-9.326, -16.738, -40.864> <-9.421, -16.762, -40.680> <-9.398, -16.734, -40.544> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.297, -16.695, -41.048> <-9.286, -16.692, -41.070> <-9.271, -16.709, -41.087> <-9.258, -16.730, -41.083> 
		<-9.330, -16.558, -41.048> <-9.320, -16.555, -41.070> <-9.186, -16.680, -41.195> <-9.173, -16.701, -41.192> 
		<-9.429, -16.376, -41.074> <-9.314, -16.348, -41.319> <-9.213, -16.441, -41.412> <-9.092, -16.684, -41.383> 
		<-9.408, -16.239, -41.048> <-9.293, -16.211, -41.294> <-9.097, -16.391, -41.474> <-8.976, -16.633, -41.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.258, -16.730, -41.083> <-9.245, -16.752, -41.080> <-9.238, -16.770, -41.057> <-9.248, -16.772, -41.034> 
		<-9.173, -16.701, -41.192> <-9.160, -16.723, -41.188> <-9.153, -16.877, -41.029> <-9.164, -16.879, -41.006> 
		<-9.092, -16.684, -41.383> <-8.971, -16.927, -41.354> <-8.967, -17.042, -41.235> <-9.082, -17.069, -40.989> 
		<-8.976, -16.633, -41.445> <-8.855, -16.876, -41.415> <-8.850, -17.101, -41.186> <-8.965, -17.129, -40.940> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.248, -16.772, -41.034> <-9.259, -16.775, -41.011> <-9.283, -16.761, -40.998> <-9.296, -16.739, -41.002> 
		<-9.164, -16.879, -41.006> <-9.174, -16.882, -40.983> <-9.313, -16.759, -40.861> <-9.326, -16.738, -40.864> 
		<-9.082, -17.069, -40.989> <-9.197, -17.097, -40.743> <-9.300, -17.005, -40.650> <-9.421, -16.762, -40.680> 
		<-8.965, -17.129, -40.940> <-9.080, -17.156, -40.694> <-9.277, -16.977, -40.514> <-9.398, -16.734, -40.544> 
	}
	texture {chrome_texture}
}
// Layer 3 - the small cork piece
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.828, -17.021, -40.905> <-8.828, -17.021, -40.905> <-8.828, -17.021, -40.905> <-8.828, -17.021, -40.905> 
		<-8.738, -16.995, -41.097> <-8.828, -17.021, -40.905> <-8.828, -17.021, -40.905> <-8.917, -17.047, -40.713> 
		<-8.734, -16.810, -41.267> <-8.832, -16.839, -41.056> <-8.963, -16.877, -40.775> <-9.061, -16.906, -40.564> 
		<-8.817, -16.614, -41.279> <-8.915, -16.643, -41.069> <-9.046, -16.681, -40.787> <-9.145, -16.710, -40.576> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.828, -17.021, -40.905> <-8.738, -16.995, -41.097> <-8.734, -16.810, -41.267> <-8.817, -16.614, -41.279> 
		<-8.766, -16.989, -40.870> <-8.677, -16.963, -41.062> <-8.672, -16.779, -41.232> <-8.756, -16.583, -41.244> 
		<-8.684, -16.947, -40.823> <-8.595, -16.921, -41.015> <-8.590, -16.736, -41.185> <-8.674, -16.540, -41.197> 
		<-8.623, -16.915, -40.787> <-8.533, -16.889, -40.979> <-8.529, -16.704, -41.149> <-8.612, -16.509, -41.162> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.828, -17.021, -40.905> <-8.766, -16.989, -40.870> <-8.684, -16.947, -40.823> <-8.623, -16.915, -40.787> 
		<-8.917, -17.047, -40.713> <-8.856, -17.015, -40.678> <-8.774, -16.973, -40.631> <-8.712, -16.941, -40.595> 
		<-9.061, -16.906, -40.564> <-9.000, -16.874, -40.528> <-8.918, -16.831, -40.481> <-8.856, -16.800, -40.446> 
		<-9.145, -16.710, -40.576> <-9.083, -16.678, -40.541> <-9.001, -16.636, -40.494> <-8.940, -16.604, -40.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.134, -16.303, -40.951> <-9.224, -16.329, -40.759> <-9.228, -16.514, -40.589> <-9.145, -16.710, -40.576> 
		<-9.073, -16.272, -40.915> <-9.162, -16.298, -40.723> <-9.167, -16.482, -40.553> <-9.083, -16.678, -40.541> 
		<-8.991, -16.229, -40.868> <-9.080, -16.255, -40.676> <-9.085, -16.440, -40.506> <-9.001, -16.636, -40.494> 
		<-8.929, -16.197, -40.833> <-9.019, -16.224, -40.641> <-9.023, -16.408, -40.471> <-8.940, -16.604, -40.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.134, -16.303, -40.951> <-9.134, -16.303, -40.951> <-9.134, -16.303, -40.951> <-9.134, -16.303, -40.951> 
		<-9.224, -16.329, -40.759> <-9.134, -16.303, -40.951> <-9.134, -16.303, -40.951> <-9.045, -16.277, -41.143> 
		<-9.228, -16.514, -40.589> <-9.130, -16.485, -40.800> <-8.999, -16.447, -41.081> <-8.901, -16.419, -41.292> 
		<-9.145, -16.710, -40.576> <-9.046, -16.681, -40.787> <-8.915, -16.643, -41.069> <-8.817, -16.614, -41.279> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.134, -16.303, -40.951> <-9.073, -16.272, -40.915> <-8.991, -16.229, -40.868> <-8.929, -16.197, -40.833> 
		<-9.045, -16.277, -41.143> <-8.983, -16.246, -41.107> <-8.901, -16.203, -41.060> <-8.840, -16.171, -41.025> 
		<-8.901, -16.419, -41.292> <-8.839, -16.387, -41.257> <-8.757, -16.345, -41.209> <-8.696, -16.313, -41.174> 
		<-8.817, -16.614, -41.279> <-8.756, -16.583, -41.244> <-8.674, -16.540, -41.197> <-8.612, -16.509, -41.162> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.623, -16.915, -40.787> <-8.623, -16.915, -40.787> <-8.623, -16.915, -40.787> <-8.623, -16.915, -40.787> 
		<-8.712, -16.941, -40.595> <-8.623, -16.915, -40.787> <-8.623, -16.915, -40.787> <-8.533, -16.889, -40.979> 
		<-8.856, -16.800, -40.446> <-8.758, -16.771, -40.657> <-8.627, -16.733, -40.938> <-8.529, -16.704, -41.149> 
		<-8.940, -16.604, -40.458> <-8.842, -16.575, -40.669> <-8.711, -16.537, -40.951> <-8.612, -16.509, -41.162> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.929, -16.197, -40.833> <-8.929, -16.197, -40.833> <-8.929, -16.197, -40.833> <-8.929, -16.197, -40.833> 
		<-8.840, -16.171, -41.025> <-8.929, -16.197, -40.833> <-8.929, -16.197, -40.833> <-9.019, -16.224, -40.641> 
		<-8.696, -16.313, -41.174> <-8.794, -16.341, -40.963> <-8.925, -16.380, -40.682> <-9.023, -16.408, -40.471> 
		<-8.612, -16.509, -41.162> <-8.711, -16.537, -40.951> <-8.842, -16.575, -40.669> <-8.940, -16.604, -40.458> 
	}
	texture {cork_texture}
}
// Layer 4 - the black rubber piece at the end
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.658, -16.426, -43.354> <-4.658, -16.426, -43.354> <-4.658, -16.426, -43.354> <-4.658, -16.426, -43.354> 
		<-4.658, -16.653, -43.338> <-4.658, -16.426, -43.354> <-4.658, -16.426, -43.354> <-4.658, -16.199, -43.370> 
		<-4.468, -16.842, -43.325> <-4.468, -16.593, -43.343> <-4.468, -16.260, -43.366> <-4.468, -16.010, -43.383> 
		<-4.241, -16.842, -43.325> <-4.241, -16.593, -43.343> <-4.241, -16.260, -43.366> <-4.241, -16.010, -43.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.658, -16.426, -43.354> <-4.658, -16.653, -43.338> <-4.468, -16.842, -43.325> <-4.241, -16.842, -43.325> 
		<-4.658, -16.409, -43.104> <-4.658, -16.636, -43.089> <-4.468, -16.825, -43.076> <-4.241, -16.825, -43.076> 
		<-4.658, -16.386, -42.771> <-4.658, -16.613, -42.756> <-4.468, -16.802, -42.743> <-4.241, -16.802, -42.743> 
		<-4.658, -16.369, -42.522> <-4.658, -16.596, -42.506> <-4.468, -16.785, -42.493> <-4.241, -16.785, -42.493> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.658, -16.426, -43.354> <-4.658, -16.409, -43.104> <-4.658, -16.386, -42.771> <-4.658, -16.369, -42.522> 
		<-4.658, -16.199, -43.370> <-4.658, -16.182, -43.120> <-4.658, -16.159, -42.787> <-4.658, -16.142, -42.537> 
		<-4.468, -16.010, -43.383> <-4.468, -15.993, -43.133> <-4.468, -15.970, -42.800> <-4.468, -15.953, -42.550> 
		<-4.241, -16.010, -43.383> <-4.241, -15.993, -43.133> <-4.241, -15.970, -42.800> <-4.241, -15.953, -42.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.823, -16.426, -43.354> <-3.823, -16.199, -43.370> <-4.013, -16.010, -43.383> <-4.241, -16.010, -43.383> 
		<-3.823, -16.409, -43.104> <-3.823, -16.182, -43.120> <-4.013, -15.993, -43.133> <-4.241, -15.993, -43.133> 
		<-3.823, -16.386, -42.771> <-3.823, -16.159, -42.787> <-4.013, -15.970, -42.800> <-4.241, -15.970, -42.800> 
		<-3.823, -16.369, -42.522> <-3.823, -16.142, -42.537> <-4.013, -15.953, -42.550> <-4.241, -15.953, -42.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.823, -16.426, -43.354> <-3.823, -16.426, -43.354> <-3.823, -16.426, -43.354> <-3.823, -16.426, -43.354> 
		<-3.823, -16.199, -43.370> <-3.823, -16.426, -43.354> <-3.823, -16.426, -43.354> <-3.823, -16.653, -43.338> 
		<-4.013, -16.010, -43.383> <-4.013, -16.260, -43.366> <-4.013, -16.593, -43.343> <-4.013, -16.842, -43.325> 
		<-4.241, -16.010, -43.383> <-4.241, -16.260, -43.366> <-4.241, -16.593, -43.343> <-4.241, -16.842, -43.325> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.823, -16.426, -43.354> <-3.823, -16.409, -43.104> <-3.823, -16.386, -42.771> <-3.823, -16.369, -42.522> 
		<-3.823, -16.653, -43.338> <-3.823, -16.636, -43.089> <-3.823, -16.613, -42.756> <-3.823, -16.596, -42.506> 
		<-4.013, -16.842, -43.325> <-4.013, -16.825, -43.076> <-4.013, -16.802, -42.743> <-4.013, -16.785, -42.493> 
		<-4.241, -16.842, -43.325> <-4.241, -16.825, -43.076> <-4.241, -16.802, -42.743> <-4.241, -16.785, -42.493> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.658, -16.369, -42.522> <-4.658, -16.369, -42.522> <-4.658, -16.369, -42.522> <-4.658, -16.369, -42.522> 
		<-4.658, -16.142, -42.537> <-4.658, -16.369, -42.522> <-4.658, -16.369, -42.522> <-4.658, -16.596, -42.506> 
		<-4.468, -15.953, -42.550> <-4.468, -16.202, -42.533> <-4.468, -16.535, -42.510> <-4.468, -16.785, -42.493> 
		<-4.241, -15.953, -42.550> <-4.241, -16.202, -42.533> <-4.241, -16.535, -42.510> <-4.241, -16.785, -42.493> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.823, -16.369, -42.522> <-3.823, -16.369, -42.522> <-3.823, -16.369, -42.522> <-3.823, -16.369, -42.522> 
		<-3.823, -16.596, -42.506> <-3.823, -16.369, -42.522> <-3.823, -16.369, -42.522> <-3.823, -16.142, -42.537> 
		<-4.013, -16.785, -42.493> <-4.013, -16.535, -42.510> <-4.013, -16.202, -42.533> <-4.013, -15.953, -42.550> 
		<-4.241, -16.785, -42.493> <-4.241, -16.535, -42.510> <-4.241, -16.202, -42.533> <-4.241, -15.953, -42.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.414, -43.183> <-4.421, -16.404, -43.030> <-4.241, -16.404, -43.030> 
		<-4.574, -16.437, -43.542> <-4.574, -16.426, -43.363> <-4.421, -16.583, -43.018> <-4.241, -16.583, -43.018> 
		<-4.421, -16.448, -43.695> <-4.421, -16.627, -43.683> <-4.241, -16.758, -43.341> <-4.241, -16.746, -43.161> 
		<-4.241, -16.448, -43.695> <-4.241, -16.627, -43.683> <-4.241, -16.770, -43.520> <-4.241, -16.758, -43.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> 
		<-4.574, -16.605, -43.351> <-4.574, -16.617, -43.530> <-4.574, -16.617, -43.530> <-4.574, -16.437, -43.542> 
		<-4.421, -16.758, -43.341> <-4.421, -16.770, -43.520> <-4.421, -16.627, -43.683> <-4.421, -16.448, -43.695> 
		<-4.241, -16.758, -43.341> <-4.241, -16.770, -43.520> <-4.241, -16.627, -43.683> <-4.241, -16.448, -43.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.437, -43.542> <-4.421, -16.448, -43.695> <-4.241, -16.448, -43.695> 
		<-4.574, -16.414, -43.183> <-4.574, -16.426, -43.363> <-4.421, -16.268, -43.707> <-4.241, -16.268, -43.707> 
		<-4.421, -16.404, -43.030> <-4.421, -16.224, -43.042> <-4.241, -16.093, -43.385> <-4.241, -16.105, -43.564> 
		<-4.241, -16.404, -43.030> <-4.241, -16.224, -43.042> <-4.241, -16.081, -43.205> <-4.241, -16.093, -43.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> 
		<-4.574, -16.246, -43.375> <-4.574, -16.258, -43.554> <-4.574, -16.258, -43.554> <-4.574, -16.437, -43.542> 
		<-4.421, -16.093, -43.385> <-4.421, -16.105, -43.564> <-4.421, -16.268, -43.707> <-4.421, -16.448, -43.695> 
		<-4.241, -16.093, -43.385> <-4.241, -16.105, -43.564> <-4.241, -16.268, -43.707> <-4.241, -16.448, -43.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.437, -43.542> <-4.421, -16.448, -43.695> <-4.241, -16.448, -43.695> 
		<-4.574, -16.246, -43.375> <-4.574, -16.258, -43.554> <-4.241, -16.448, -43.695> <-4.061, -16.448, -43.695> 
		<-4.421, -16.093, -43.385> <-4.241, -16.093, -43.385> <-3.907, -16.258, -43.554> <-3.907, -16.437, -43.542> 
		<-4.241, -16.093, -43.385> <-4.061, -16.093, -43.385> <-3.907, -16.246, -43.375> <-3.907, -16.426, -43.363> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.437, -43.542> <-4.421, -16.448, -43.695> <-4.241, -16.448, -43.695> 
		<-4.574, -16.605, -43.351> <-4.574, -16.617, -43.530> <-4.241, -16.448, -43.695> <-4.061, -16.448, -43.695> 
		<-4.421, -16.758, -43.341> <-4.241, -16.758, -43.341> <-3.907, -16.617, -43.530> <-3.907, -16.437, -43.542> 
		<-4.241, -16.758, -43.341> <-4.061, -16.758, -43.341> <-3.907, -16.605, -43.351> <-3.907, -16.426, -43.363> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> 
		<-4.574, -16.246, -43.375> <-4.574, -16.234, -43.195> <-4.574, -16.234, -43.195> <-4.574, -16.414, -43.183> 
		<-4.421, -16.093, -43.385> <-4.421, -16.081, -43.205> <-4.421, -16.224, -43.042> <-4.421, -16.404, -43.030> 
		<-4.241, -16.093, -43.385> <-4.241, -16.081, -43.205> <-4.241, -16.224, -43.042> <-4.241, -16.404, -43.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> <-4.574, -16.426, -43.363> 
		<-4.574, -16.414, -43.183> <-4.574, -16.593, -43.171> <-4.574, -16.593, -43.171> <-4.574, -16.605, -43.351> 
		<-4.421, -16.404, -43.030> <-4.421, -16.583, -43.018> <-4.421, -16.746, -43.161> <-4.421, -16.758, -43.341> 
		<-4.241, -16.404, -43.030> <-4.241, -16.583, -43.018> <-4.241, -16.746, -43.161> <-4.241, -16.758, -43.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.246, -43.375> <-4.421, -16.093, -43.385> <-4.241, -16.093, -43.385> 
		<-4.574, -16.414, -43.183> <-4.574, -16.234, -43.195> <-4.241, -16.093, -43.385> <-4.061, -16.093, -43.385> 
		<-4.421, -16.404, -43.030> <-4.241, -16.404, -43.030> <-3.907, -16.234, -43.195> <-3.907, -16.246, -43.375> 
		<-4.241, -16.404, -43.030> <-4.061, -16.404, -43.030> <-3.907, -16.414, -43.183> <-3.907, -16.426, -43.363> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.414, -43.183> <-4.421, -16.404, -43.030> <-4.241, -16.404, -43.030> 
		<-4.574, -16.605, -43.351> <-4.574, -16.593, -43.171> <-4.241, -16.404, -43.030> <-4.061, -16.404, -43.030> 
		<-4.421, -16.758, -43.341> <-4.241, -16.758, -43.341> <-3.907, -16.593, -43.171> <-3.907, -16.414, -43.183> 
		<-4.241, -16.758, -43.341> <-4.061, -16.758, -43.341> <-3.907, -16.605, -43.351> <-3.907, -16.426, -43.363> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.605, -43.351> <-4.421, -16.758, -43.341> <-4.241, -16.758, -43.341> 
		<-4.574, -16.246, -43.375> <-4.574, -16.426, -43.363> <-4.421, -16.746, -43.161> <-4.241, -16.746, -43.161> 
		<-4.421, -16.093, -43.385> <-4.421, -16.081, -43.205> <-4.241, -16.404, -43.030> <-4.241, -16.583, -43.018> 
		<-4.241, -16.093, -43.385> <-4.241, -16.081, -43.205> <-4.241, -16.224, -43.042> <-4.241, -16.404, -43.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.574, -16.426, -43.363> <-4.574, -16.605, -43.351> <-4.421, -16.758, -43.341> <-4.241, -16.758, -43.341> 
		<-4.574, -16.246, -43.375> <-4.574, -16.426, -43.363> <-4.421, -16.770, -43.520> <-4.241, -16.770, -43.520> 
		<-4.421, -16.093, -43.385> <-4.421, -16.105, -43.564> <-4.241, -16.448, -43.695> <-4.241, -16.627, -43.683> 
		<-4.241, -16.093, -43.385> <-4.241, -16.105, -43.564> <-4.241, -16.268, -43.707> <-4.241, -16.448, -43.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.907, -16.426, -43.363> <-3.907, -16.414, -43.183> <-4.061, -16.404, -43.030> <-4.241, -16.404, -43.030> 
		<-3.907, -16.437, -43.542> <-3.907, -16.426, -43.363> <-4.061, -16.224, -43.042> <-4.241, -16.224, -43.042> 
		<-4.061, -16.448, -43.695> <-4.061, -16.268, -43.707> <-4.241, -16.093, -43.385> <-4.241, -16.081, -43.205> 
		<-4.241, -16.448, -43.695> <-4.241, -16.268, -43.707> <-4.241, -16.105, -43.564> <-4.241, -16.093, -43.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> 
		<-3.907, -16.246, -43.375> <-3.907, -16.234, -43.195> <-3.907, -16.234, -43.195> <-3.907, -16.414, -43.183> 
		<-4.061, -16.093, -43.385> <-4.061, -16.081, -43.205> <-4.061, -16.224, -43.042> <-4.061, -16.404, -43.030> 
		<-4.241, -16.093, -43.385> <-4.241, -16.081, -43.205> <-4.241, -16.224, -43.042> <-4.241, -16.404, -43.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.907, -16.426, -43.363> <-3.907, -16.437, -43.542> <-4.061, -16.448, -43.695> <-4.241, -16.448, -43.695> 
		<-3.907, -16.414, -43.183> <-3.907, -16.426, -43.363> <-4.061, -16.627, -43.683> <-4.241, -16.627, -43.683> 
		<-4.061, -16.404, -43.030> <-4.061, -16.583, -43.018> <-4.241, -16.758, -43.341> <-4.241, -16.770, -43.520> 
		<-4.241, -16.404, -43.030> <-4.241, -16.583, -43.018> <-4.241, -16.746, -43.161> <-4.241, -16.758, -43.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> 
		<-3.907, -16.605, -43.351> <-3.907, -16.593, -43.171> <-3.907, -16.593, -43.171> <-3.907, -16.414, -43.183> 
		<-4.061, -16.758, -43.341> <-4.061, -16.746, -43.161> <-4.061, -16.583, -43.018> <-4.061, -16.404, -43.030> 
		<-4.241, -16.758, -43.341> <-4.241, -16.746, -43.161> <-4.241, -16.583, -43.018> <-4.241, -16.404, -43.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> 
		<-3.907, -16.605, -43.351> <-3.907, -16.617, -43.530> <-3.907, -16.617, -43.530> <-3.907, -16.437, -43.542> 
		<-4.061, -16.758, -43.341> <-4.061, -16.770, -43.520> <-4.061, -16.627, -43.683> <-4.061, -16.448, -43.695> 
		<-4.241, -16.758, -43.341> <-4.241, -16.770, -43.520> <-4.241, -16.627, -43.683> <-4.241, -16.448, -43.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> <-3.907, -16.426, -43.363> 
		<-3.907, -16.246, -43.375> <-3.907, -16.258, -43.554> <-3.907, -16.258, -43.554> <-3.907, -16.437, -43.542> 
		<-4.061, -16.093, -43.385> <-4.061, -16.105, -43.564> <-4.061, -16.268, -43.707> <-4.061, -16.448, -43.695> 
		<-4.241, -16.093, -43.385> <-4.241, -16.105, -43.564> <-4.241, -16.268, -43.707> <-4.241, -16.448, -43.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.907, -16.426, -43.363> <-3.907, -16.246, -43.375> <-4.061, -16.093, -43.385> <-4.241, -16.093, -43.385> 
		<-3.907, -16.605, -43.351> <-3.907, -16.426, -43.363> <-4.061, -16.105, -43.564> <-4.241, -16.105, -43.564> 
		<-4.061, -16.758, -43.341> <-4.061, -16.770, -43.520> <-4.241, -16.448, -43.695> <-4.241, -16.268, -43.707> 
		<-4.241, -16.758, -43.341> <-4.241, -16.770, -43.520> <-4.241, -16.627, -43.683> <-4.241, -16.448, -43.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.907, -16.426, -43.363> <-3.907, -16.246, -43.375> <-4.061, -16.093, -43.385> <-4.241, -16.093, -43.385> 
		<-3.907, -16.605, -43.351> <-3.907, -16.426, -43.363> <-4.061, -16.081, -43.205> <-4.241, -16.081, -43.205> 
		<-4.061, -16.758, -43.341> <-4.061, -16.746, -43.161> <-4.241, -16.404, -43.030> <-4.241, -16.224, -43.042> 
		<-4.241, -16.758, -43.341> <-4.241, -16.746, -43.161> <-4.241, -16.583, -43.018> <-4.241, -16.404, -43.030> 
	}
	texture {black_plastic_texture}
}
}

// EOF------------------------------------------------------