// "Rounded characters" - made with cylinders, spheres and toruses.
// Contains only characters A,B,C,E,F,H,I,J,K,L,N and P at the moment.
//
#declare Transparent=true;
#declare RAD=0.5;
#declare End=sphere{0,RAD}


#declare char_A =
#if(Transparent)
  merge {
#else
  union { #end
    cylinder{<0,-5.6,0.5>,<0,0,0.5>RAD rotate  z*16.699 }
    cylinder{<0,-5.6,0.5>,<0,0,0.5>RAD rotate -z*16.699 }
    cylinder{<-1,  -3.5,0.5>,<1, -3.5,0.5> RAD }
    object {End translate <0,-5.6,0.5> rotate  z*16.699}
    object {End translate <0,-5.6,0.5> rotate -z*16.699}
    object {End translate <0,-0.1,0.5>}
    translate y*5.4
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_P =
#if(Transparent)
  merge {
#else
  union { #end
    difference{
      torus{1.5 RAD rotate x*90}
      plane{x,0}
      bounded_by{ box { <0,-2,0.5+RAD>, <2.5,2,0.5-RAD> } }
      translate <0,3.3,0.5>
    }
    cylinder{ <-1.5, 4.8, 0.5>, <0.01, 4.8, 0.5> RAD}
    cylinder{ <-1.5, 1.8, 0.5>, <0.01, 1.8, 0.5> RAD}
    cylinder{ <-1.5, 0, 0.5>, <-1.5, 5, 0.5> RAD}
    object {End translate <-1.5,0,0.5>}
    object {End translate <-1.5,4.8,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }  

#declare char_B =
#if(Transparent)
  merge {
#else
  union { #end
    object { char_P }

    difference{
      torus{1.5 RAD rotate x*90}
      plane{x,0}
      bounded_by{ box { <0,-2,0.5+RAD>, <2.5,2,0.5-RAD> } }
      translate <0,0,0.5>
    }
    cylinder{ <-1.5, 0, 0.5>, <0.01, 0, 0.5> RAD}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_C =
#if(Transparent)
  merge {
#else
  union { #end
    difference{
      torus{1.5 RAD rotate x*90}
      plane{-y,0}
      bounded_by{ box { <-2.1,-2,0.5+RAD>, <2.5,0,0.5-RAD> } }
      translate <0,1.5,0.5>
    }
    difference{
      torus{1.5 RAD rotate x*90}
      plane{y,0}
      bounded_by{ box { <-2.1,0,0.5+RAD>, <2.5,2,0.5-RAD> } }
      translate <0,3.5,0.5>
    }
    cylinder{ <-1.5,1,0.5>,<-1.5,3.5,0.5> RAD}
    object {End translate <1.5,3.5,0.5>}
    object {End translate <1.5,1.5,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_F =
#if(Transparent)
  merge {
#else
  union { #end
    cylinder{ <-1.5,0,0.5>,<-1.5,5,0.5> RAD }
    cylinder{ <-1.5,2.5,0.5>,<1,2.5,0.5> RAD }
    cylinder{ <-1.5,5,0.5>,<1.5,5,0.5> RAD }
    object {End translate <-1.5,5,0.5>}
    object {End translate <-1.5,0,0.5>}
    object {End translate <1,2.5,0.5>}
    object {End translate <1.5,5,0.5>}
    
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_E =
#if(Transparent)
  merge {
#else
  union { #end
    object { char_F }
    cylinder{ <-1.5,0,0.5>,<1.5,0,0.5> RAD }
    object {End translate <1.5,0,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_H =
#if(Transparent)
  merge {
#else
  union { #end
    cylinder{ <-1.5,2.5,0.5>,<1.5,2.5,0.5> RAD}
    cylinder{ <-1.5,0,0.5>,<-1.5,5,0.5> RAD}
    cylinder{ <1.5,0,0.5>,<1.5,5,0.5> RAD}
    object {End translate <-1.5,5,0.5>}
    object {End translate <-1.5,0,0.5>}
    object {End translate <1.5,0,0.5>}
    object {End translate <1.5,5,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_I =
#if(Transparent)
  merge {
#else
  union { #end
    cylinder{ <0,0,0.5>,<0,5,0.5> RAD}
    object {End translate <0,5,0.5>}
    object {End translate <0,0,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_J =
#if(Transparent)
  merge {
#else
  union { #end
    difference{
      torus{1.5 RAD rotate x*90}
      plane{-y,0}
      bounded_by{ box { <-2.1,-2,1>, <2.1,0.1,0> } }
      translate <0,1.5,0.5>
    }
    cylinder{ <1.5,1.3,0.5>,<1.5,5,0.5> RAD}
    object {End translate <1.5,5,0.5>}
    object {End translate <-1.5,1.5,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }


#declare char_K =
#if(Transparent)
  merge {
#else
  union {
#end
    cylinder{ <0,0,0.5>,<3.5,0,0.5> RAD rotate z*45  translate <-1.5,2.5,0> }
    cylinder{ <0,0,0.5>,<3.5,0,0.5> RAD rotate -z*45 translate <-1.5,2.5,0> }
    cylinder{ <-1.5,0,0.5>,<-1.5,5,0.5> RAD }
    object {End translate <-1.5,0,0.5>}
    object {End translate <-1.5,5,0.5>}
    object {End translate <1,0,0.5>}
    object {End translate <1,5,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_L =
#if(Transparent)
  merge {
#else
  union {
#end
    object { char_I translate x*-1.5}
    cylinder{ <-1.5,0,0.5>,<1.5,0,0.5> RAD}
    object {End translate <1.5,0,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_R =
#if(Transparent)
  merge {
#else
  union {
#end
    difference{
      torus{1.5 RAD rotate x*90}
      plane{x,0}
      bounded_by{ box { <0,-2,0.5+RAD>, <2.5,2,0.5-RAD> } }
      translate <0,3.3,0.5>
    }
    cylinder{ <-1.5, 4.8, 0.5>, <0.01, 4.8, 0.5> RAD}
    cylinder{ <-1.5, 1.8, 0.5>, <0.01, 1.8, 0.5> RAD}
    cylinder{ <-1.5, 0, 0.5>, <-1.5, 5, 0.5> RAD}
    cylinder{ <0, 0, 0.5>, <0, 2.5, 0.5> RAD rotate z*32.5031 translate <1.25,-0.2,0>}
    object {End translate <-1.5,0,0.5>}
    object {End translate <-1.5,4.8,0.5>}
    object {End translate <1.2,-0.1,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}

  }  

#declare char_N =
#if(Transparent)
  merge {
#else
  union {
#end
    cylinder{ <0.5,0,0.5>,<0.5,5.5,0.5> RAD rotate z*32.5031 translate x}
    cylinder{ <-1.5,0,0.5>,<-1.5,5,0.5> RAD}
    cylinder{ <1.5,0,0.5>,<1.5,5,0.5> RAD}
    object {End translate <-1.5,5,0.5>}
    object {End translate <-1.5,0,0.5>}
    object {End translate <1.5,0,0.5>}
    object {End translate <1.5,5,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }

#declare char_C =
#if(Transparent)
  merge {
#else
  union {
#end
    difference{
      torus{1.5 RAD rotate x*90}
      plane{-y,0}
      bounded_by{ box { <-2.1,-2,0.5+RAD>, <2.5,0,0.5-RAD> } }
      translate <0,1.5,0.5>
    }
    difference{
      torus{1.5 RAD rotate x*90}
      plane{y,0}
      bounded_by{ box { <-2.1,0,0.5+RAD>, <2.5,2,0.5-RAD> } }
      translate <0,3.5,0.5>
    }
    cylinder{ <-1.5,1,0.5>,<-1.5,3.5,0.5> RAD}
    object {End translate <1.5,3.5,0.5>}
    object {End translate <1.5,1.5,0.5>}
    bounded_by{box{<-2,-0.5,-0.5><2,5.8,0.5>}}
  }
  
