// Persistence of Vision Ray Tracer Scene Description File
// File: kartio_glass.pov
// Vers: 3.5
// Desc: An Iittala "Kartio" glass designed by Kaj Franck
// Date: 11/12/01
// Auth: Ari-Matti Leppnen
//

#version 3.5;

#declare Use_photons    =on;
#declare IO_photons     =on;    //!Save_photons = Load_photons
#declare Save_photons   =on;   

#declare Use_radiosity  =on;
#declare IO_radiosity   =on;
#declare Save_radiosity =off;

#declare Use_focal_blur =on;
#declare Use_area_light =on;


global_settings {
  assumed_gamma 1.0
  max_trace_level 50
   #if (Use_photons)
    photons {
      spacing 0.002
      jitter 0.0
     #if (IO_photons)
       #if(Save_photons)
        save_file "kartio_glass.ph"
       #else
        load_file "kartio_glass.ph"
       #end
     #end
      autostop 0
    }

  #end

  #if (Use_radiosity)
   #default {finish {ambient 0}}
   ambient_light 0
   #include "rad_def.inc"
   radiosity { Rad_Settings(5, on, off)
   #if (IO_radiosity)
     always_sample off
     #if (Save_radiosity)
      save_file "kartio_glass.rd"
     #else
      load_file "kartio_glass.rd"
      pretrace_start 1 pretrace_end 1
     #end
   #end
   }
  #end
}

// -----------------Cameras-----------------
#if (on) 
camera {
  right x*image_width/image_height
  location  (<-0.4,7.5,-6>-<-0.4,1.5,0>)*2

  direction 2*z

  look_at   0

  translate <-0.4,1.5,0>

 #if(Use_focal_blur)
  focal_point <0,2,0>

  aperture 0.2
  blur_samples 100

  confidence 0.9
  variance 1/10000
 #end
}
#else
camera {
  right x*image_width/image_height
  location  <0,2.0,-5>
  look_at   <0,2.0,2>
} 
#end
// -----------------Lights-----------------
light_source {
 <50,30,-15>
 color rgb 0.6

 #if(Use_area_light)
  area_light <2,0,0><0,0,2>
  3, 3
  adaptive 1
  jitter
  circular
  orient
 #end

 photons {
   refraction on
   reflection on
 }
}

light_source {
 <50,30,-15>
 color rgb 0.18

 spotlight
 radius 6
 falloff 10
 point_at <0,0,0>

 #if(Use_area_light)
  area_light <2,0,0><0,0,2>
  3, 3
  adaptive 1
  jitter
  circular
  orient
 #end

 photons {
   refraction on
   reflection on
 }
 rotate y*8
}
light_source {
 <50,30,-15>
 color rgb 0.18

 spotlight
 radius 6
 falloff 10
 point_at <0,0,0>

 #if(Use_area_light)
  area_light <2,0,0><0,0,2>
  3, 3
  adaptive 1
  jitter
  circular
  orient
 #end

 photons {
   refraction on
   reflection on
 }
 rotate y*-8
}
// -----------------Surrounding-----------------

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.7,0.8,1.0>]
      [0.7 rgb <0.85,0.9,0.95>]
    }
  }
}

plane {           //floor
  y, 0
  texture {
    pigment { color rgb <1.0, 1.0, 1.0> }
    finish {reflection {0.05 0.3}}
  }
}

/*
plane {           //backwall for testing
  -z, -5
  texture {
    pigment { color rgb <1.0, 1.0, 1.0> }
  }
}
*/

// -----------------Kartio glass-----------------
#include "kartio_glass.inc"

//Kartio_glass(Color,Height,Location,Rotate,Water_level,Use_reflection,Dispersion_samples)

Kartio_glass(4,3.831,<0,0,0>,<0,-90,0>,0.0,true,0)

