// A macro to create an Iittala "Kartio" glass.
//
// Parameters:
// Color          = color of the glass, 1 green, 2 blue, 3 clear.
// Height         = height in units
// Location       = where do you want the glass (base at this point)
// Rotate         = rotate around the center of the base of the glass
// Water_level    = percentage of water level 0.0 .. 1.0 (note: low values aren't correct, rotate may cause weird results)
// Use_reflection = true/ false
// Dispersion_samples = set smaller than 2 if no dispersion is used, otherwise the amount of dispersion_samples used
//

#macro Kartio_glass(Color,Height,Location,Rotate,Water_level,Use_reflection,Dispersion_samples)

#switch (Color)
    #declare Color=<0.3647, 0.9196, 0.6451>;
  #case (1)
    #declare Fade_Color=<0.56, 0.96, 0.64>;
  #break
  #case (2)
    #declare Fade_Color=<0.5255, 0.8510, 0.9176>;
  #break
  #case (3)
    #declare Fade_Color=<0.98, 0.98, 0.99>;
  #break

  #else
    #declare Fade_Color=<0.3647, 0.9196, 0.6451>;
  #break
#end
  

#declare Glass_mat =
  material {
    texture {
      pigment { //rgbf <0.3647, 0.9196, 0.6451, 0.85>
        gradient y
        turbulence 0.05
        color_map{
          [0.00, rgb Color transmit 0.99]
          [0.11, rgb Color transmit 1]
          [0.25, rgb Color transmit 0.99]
          [0.38, rgb Color transmit 0.99]
          [0.52, rgb Color transmit 1]
          [0.60, rgb Color transmit 0.99]
          [0.75, rgb Color transmit 0.99]
          [0.84, rgb Color transmit 1]
          [0.91, rgb Color transmit 0.99]
        }
        quick_color rgb Fade_Color
        scale <1,450,1>
      }

      finish { 
        specular 0.9
        roughness 0.001
        ambient 0.0
        diffuse 0.3//3
       #if (Use_reflection)
        reflection {0.05 0.9 fresnel on}
        conserve_energy
       #end
      } 
   
      normal {
        average 
        normal_map {
          [1.0 
               gradient y turbulence 0.05
               slope_map{
                 [0.00, <0.005,-0.001>]
                 [0.11, <0    , 0.001>]
                 [0.25, <0.005, 0    >]
                 [0.38, <0.005,-0.001>]
                 [0.52, <0    , 0.001>]
                 [0.60, <0.005, 0    >]
                 [0.75, <0.005,-0.001>]
                 [0.84, <0    , 0.001>]
                 [0.91, <0.005, 0    >]
               }
               scale <1,450,1>
          ] 
          [0.05 bozo scale <0.9,1,0.9>*10]
        }  
      }   
    }//texture

    interior {
      ior 1.517
     #if (Dispersion_samples > 1)
      dispersion 1.012 
      dispersion_samples Dispersion_samples
     #end
      fade_distance 0.03
      fade_power 1001
      fade_color rgb Fade_Color
    } 
  } 

#declare Plastic_Pigment= pigment {rgbf <1,1,1, 0.95>}
#declare Plastic_Finish= finish {specular 0.9 roughness 0.003 ambient 0 diffuse 0.6}
#declare Plastic_Finish2= finish {specular 0.5 roughness 0.009 ambient 0 diffuse 0.6}
#declare Plastic_Normal= normal{bumps 0.03 scale 5}


#declare Water_mat =
  material {
    texture {
      pigment { rgbf <1, 1, 1, 0.99> quick_color rgb <1,0,0>}

      finish {
        brilliance 1
        ambient 0
        diffuse 0.1//1
        phong 1.0 phong_size 600
       #if (Use_reflection)
        reflection { 0, 1.0  fresnel}
        conserve_energy
       #end
      }
    }
            
    interior {
      ior 1.33
     #if (Dispersion_samples > 1)
      dispersion 1.007 
      dispersion_samples Use_dispersion
     #end
      fade_distance 2
      fade_power 1001
      fade_color rgb <0.98,0.98,0.99>
    }         
  }

//----------Parts for the glass----------

#declare Glass_outside=
merge {

  torus { 1421 30                                              //top edge
    scale <1,0.7,1>
    translate y*4000
  }

  cone { <0, 400, 0> 1121 <0, 4000 ,0> 1450}                   //middle part

  merge {                                                      //base

    difference {
      cylinder { <0, -310, 0> <0, -100, 0> 840 }
      sphere { <0, -4100, 0> 840 scale <1,0.08,1> }
      bounded_by {  box { <-840.1,-310.1,-840.1><840.1,-99.9,840.1>} }
    }
 
    difference {
      torus { 859.5 280 }
      box {<-1139.6, -100,-1139.6><1139.6, 281,1139.6>}
      bounded_by {  box { <-1139.6,-281,-1139.6><1139.6,-99.9,1139.6>} }
    }
   
    union {                                                    //designers name "Kaj Franck"
      #include "lepi_char.inc"                                 //on the bottom
      #declare rad=20;
      #declare a=-3;
      object {char_K rotate x*a translate y*rad }
      object {char_A rotate x*a translate y*rad rotate -z*12}
      object {char_J rotate x*a translate y*rad rotate -z*23}
      object {char_F rotate x*a translate y*rad rotate -z*40}
      object {char_R rotate x*a translate y*rad rotate -z*51}
      object {char_A rotate x*a translate y*rad rotate -z*64}
      object {char_N rotate x*a translate y*rad rotate -z*78}
      object {char_C rotate x*a translate y*rad rotate -z*91}
      object {char_K rotate x*a translate y*rad rotate -z*103}
      scale 20
      rotate -x*90
      translate <0.0,-275,0.0>
      bounded_by{box { <-40,-291,-513><512,-254, 144>}}
    }
    translate y*500.1
  }
}


#declare Glass_inside=
merge {
  cone { <0, 600, 0> 1060 <0, 4100 ,0> 1400 }
  #declare r=100;
  torus { 1060-r, r translate y*600}
  sphere { <0, 2750, 0> 1000 scale <1.04, 0.2, 1.04>  }
}


//----------The logo----------
#declare Angle= degrees(atan((1450-1121.05)/(4000-400)));

#declare Text=                                                 //text objects for the logo
union {
 #declare Iittala = "iittala";
 #declare Finland = "FINLAND";
 #declare Font = "arial.ttf";
 text { ttf Font, Iittala, 0.5, 0 scale 1.5 bounded_by{ box{<-0.05,-0.1,-1><4.1,1.3,1>} }}
 text { ttf Font, Finland, 0.75, 0 translate <0,-1,0> bounded_by{ box{<-0.05,-1.2,-1><4.1,-0.1,1>} }}
 pigment {rgb 1}
 finish{Plastic_Finish2}
 normal{Plastic_Normal}
}

#declare I=
union {
  box {<-25,3760,-1410><25,3730,-1454> }
  box {<-25,3720,-1410><25,3600,-1454> }
  pigment {rgb 1}
  finish{Plastic_Finish2}
  normal{Plastic_Normal}
}

#declare Iittala_logo=
union {
  difference {     
    cylinder {<0,3680,-1410><0,3680,-1453> 100 pigment {rgb<0.7,0,0>} finish{Plastic_Finish2} normal{Plastic_Normal} }
    object {I}
  }
  union {
    object {I}
    object {Text scale 60 translate <-110,3500,-1450>}
  }
}

#declare a=min_extent(Iittala_logo);
#declare BBox=box {<-149,3400,-1410> <149,3820,-1450> translate -<0,3400,-1440> rotate x*-Angle translate <0,3400,-1440>+<0,0,45>}

#declare Sticker=
intersection {
  difference{
   cone {<0, 400, 0> 1123.05 <0, 4000 ,0> 1452}
   cone {<0, 400, 0> 1121.05 <0, 4000 ,0> 1450}
   bounded_by { BBox }
  }                 
  superellipsoid {<0.2,0.2> scale<150,200,150>translate <0,3600,-1450>}
  bounded_by { BBox }
}

#declare Iittala_sticker=
union {

  intersection {
    object {Iittala_logo translate -a rotate x*-Angle translate a+<0,0,49>} 
    difference{
      cone {<0, 400, 0> 1123.1 <0, 4000 ,0> 1452.05}
      cone {<0, 400, 0> 1123.05 <0, 4000 ,0> 1452}
      bounded_by { BBox }
    }                 
    cutaway_textures 
    bounded_by { BBox }
  }

  object {Sticker pigment{Plastic_Pigment} finish{Plastic_Finish} normal{Plastic_Normal}}
  interior {ior 1.460}
}

//----------Putting the glass together----------

//#declare Kartio_glass = 
union {

  difference {
    object { Glass_outside }
    object { Glass_inside }
    material { Glass_mat }
  }

  object {Iittala_sticker rotate y*70}

 #if(Water_level>0)
  #if(Water_level>1.0)
   #warning "Water level is over 100%. Using value 1.0."
   #declare Water_level = 1.0;
  #end

  difference {
   #declare a = (3300*Water_level)+700;       //Water level 700..4000
   #declare c = 70;
   #declare b = ((a*(17/175))+(7012/7))-c;

   #if((Rotate.x = 0) & (Rotate.z = 0))
    object { Glass_inside }
    cylinder {<0, a, 0><0, 4500, 0> 3000}
    torus {b c translate y*a+0.1}
    cylinder {<0, a-c, 0><0, 4600, 0> b}
    bounded_by{ cone {<0,a+c+0.1,0>1331 <0,100,0>1061} }

   #else
    object { Glass_inside rotate Rotate}

   #local Mopo=sphere{<b+c,a,0>.1 rotate Rotate}
   #local Max_level= min_extent(Mopo).y;

   #warning concat("Water level and rotating around x/ z might not work well.")

    plane{-y,0 translate y*Max_level}
    rotate -Rotate
    bounded_by{ cone {<0,a+0.1,0>b <0,100,0>1061} }
   #end
    scale 0.9999
    translate y*0.05
    material { Water_mat }
  }
 #end
  photons {
    target 1.0
    refraction on
    reflection on
    collect off
  }

  translate <0,-190,0>
  scale (Height/3831)
  rotate Rotate
  translate Location + <0,0.01,0>
}
#end