//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 11/04/2001    (04.11.2001)
//  Autor: Andreas Tillner, webmaster@tabsnet.de, Germany
//  
//  If you do some nice modifications or additions to this file, please send
//  me a copy. My Internet address is:  webmaster@tabsnet.de
//  

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

#version 3.5;                           

#declare Photons=1; // 0 = Photons off, 1 = Photons on
#declare radio=1;   // 0 = Radiosity off, 1 = Radiosity on
#declare Dispersion=1;
#declare solid_col=0;
#declare fBlur=0;       

global_settings {
  adc_bailout 0.0039
  ambient_light <0.0,0.0,0.0>
  assumed_gamma 2
  #if ( radio>0 )
    radiosity{brightness 0.5}
  #end
  hf_gray_16 off
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  #if(Photons>0)
    photons
    {
      count 500000 autostop 0 jitter .4
      save_file "caustics.ph"
    }
  #end
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.000,     -20.000,      11.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,       0.000,      10.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Spotlight003
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
  fade_distance  3.0
  fade_power 0.25
  rotate <73.773026, -161.670471, -199.942062>
  translate  <15.0, 47.0, 5.0>
}

light_source {   // Spotlight Spotlight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
  fade_distance  3.0
  fade_power 0.25
  rotate <-69.903961, -2.320104, -26.737648>
  translate  <15.0, 47.0, 15.0>
}

light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
  fade_distance  3.0
  fade_power 0.25
  rotate <110.808403, 16.849586, 38.404694>
  translate  <17.0, 30.0, 5.0>
}

light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  fade_distance  3.0
  fade_power 0.5
  scale 3.0
  rotate -90.0*y
  translate  <-28.0, 45.0, 10.0>
}


light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  3.0
  fade_power 0.25
  translate  <-28.0, 35.0, 15.0>
}


//
// ********  MATERIALS  *******
//

#declare wall_txt = 
   material  // Wall
   {   
      texture
      {      
         pigment
         {
            color rgb <0.568627, 0.858824, 1.0>
         }      
         finish
         {
            ambient 0.2086
            reflection 0.071933
         }
      }
   }


//  $MRY$: 'Chrome'


#declare Chrome = 
   material  // Chrome
   {   
      texture
      {      
         pigment
         {
            color rgb <0.5, 0.5, 0.5>
         }      
         finish
         {
            ambient 0.1
            metallic 1.5
            reflection 0.6187
            irid
            {
               0.2
               thickness 0.5
               turbulence <1.0, 1.0, 1.0>               
            }
         }
      }
   }


//  $MRY$: 'PovLogo_Txt'


#declare PovLogo_Txt =material
  {
    texture      
    {
      pigment 
      {
        color rgb <1,.8,.8>
        #if(solid_col=0)                        
          transmit .5                        
          filter .4                  
        #end            
      }            
      finish            
      {                  
        specular 1                  
        roughness .02                                     
        #if(solid_col=0)
          reflection{.3,.9 fresnel}
        #end                  
        conserve_energy            
      }                   
      normal            
      {                  
        dents .05 scale .01            
      }      
    }        
    interior        
    {                     
      ior 1.4              
      #if(Dispersion>0) 
        dispersion 1.05
      #end            
      dispersion_samples 8 // 14        
    }
  }


//  $MRY$: 'Ball_Txt'


#declare Ball_Txt = 
   material  // Ball_Txt
   {   
      texture
      {      
         pigment
         {
            color rgbft <0.0, 0.501961, 1.0, 0.114567, 0.031233>
         }      
         finish
         {
            ambient 0.187033
            phong 0.690633
            phong_size 19.203333
            reflection 0.294933
         }
      }
   }


//  $MRY$: 'Wall_Back'


#declare Wall_Back = 
   material  // Wall_Back
   {   
      texture
      {      
         pigment
         {
            bumps
            color_map
            {
               [ 0.0     rgbft <0.568627, 0.858824, 1.0, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            }
         }      
         normal
         {
            bumps , 0.5
            scale  <0.5, 1.0, 1.0>
         }      
         finish
         {
            ambient 0.1
         }
      }
   }


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//


#declare small_shere = 
  sphere { 
    <0,0,0>,1
    material {
      Ball_Txt
    }
  }
#declare big_shere = 
  sphere { 
    <0,0,0>,1
    material {
      Ball_Txt
    }
    scale 2.0
  }

#declare wall = 
  box { // Wall8
    <-1, -1, -1>, <1, 1, 1>
    material {
      wall_txt
    }
  }

#declare beam_plus =
  cylinder { // beam20
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.2, 0.2, 2.5>
    rotate 45.0*x
  }

#declare beam_minus =
  cylinder { // beam20
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.2, 0.2, 2.5>
    rotate -45.0*x
  }



union { // Ball_Line
  object { small_shere 
    translate  <3.0, 27.5, 2.0>
  }
  object { small_shere 
    translate  <2.8, 30.0, 2.0>
  }
  object { small_shere 
    translate  <2.2, 32.5, 2.0>
  }
  object { small_shere 
    translate  <1.0, 35.0, 2.0>
  }
  object { small_shere 
    translate  <-1.3, 37.3, 2.0>
  }
  object { small_shere 
    translate  <-4.0, 38.8, 2.0>
  }
  object { small_shere 
    translate  <3.0, -2.0, 2.0>
  }
  object { small_shere 
    translate  <3.0, 1.0, 2.0>
  }
  object { small_shere 
    translate  <3.0, 4.0, 2.0>
  }
  object { small_shere 
    translate  <3.0, 7.0, 2.0>
  }
  object { small_shere 
    translate  <3.0, 10.0, 2.0>
  }
  object { small_shere 
    translate  <3.0, 13.0, 2.0>
  }
  object { small_shere 
    translate  <-7.0, 39.7, 2.0>
  }
  object { small_shere 
    translate  <3.0, 16.0, 2.0>
  }
  object { small_shere 
    translate  <3.0, 19.0, 2.0>
  }
  object { small_shere 
    translate  <3.0, 22.0, 2.0>
  }
  object { small_shere 
    translate  <3.0, 25.0, 2.0>
  }
  object { small_shere 
    translate  <-10.0, 40.0, 2.0>
  }
}


#declare Beam_Union4 = union {
object { beam_plus
    translate  <0.0, 1.8, 5.4>
  }
object { beam_minus
    translate  3.6*z
  }
object { beam_plus
    translate  <0.0, 1.8, 1.8>
  }
object { beam_minus
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.25, 0.25, 20.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 9.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 12.6>
  }
object { beam_plus
    translate  <0.0, 1.8, 16.2>
  }
object { beam_minus
    translate  7.2*z
  }
object { beam_minus
    translate  10.8*z
  }
object { beam_minus
    translate  14.4*z
  }
  translate  <16.0, 46.0, 1.0>
}

#declare Beam_Union5 = union {
object { beam_plus
    translate  <0.0, 1.8, 5.4>
  }
object { beam_minus
    translate  3.6*z
  }
object { beam_plus
    translate  <0.0, 1.8, 1.8>
  }
object { beam_minus
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.25, 0.25, 20.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 9.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 12.6>
  }
object { beam_plus
    translate  <0.0, 1.8, 16.2>
  }
object { beam_minus
    translate  7.2*z
  }
object { beam_minus
    translate  10.8*z
  }
object { beam_minus
    translate  14.4*z
  }
  rotate 90.0*z
  translate  <17.8, 46.0, 1.0>
}


#declare Beam_Union6 = union {
object { beam_plus
    translate  <0.0, 1.8, 5.4>
  }
object { beam_minus
    translate  3.6*z
  }
object { beam_plus
    translate  <0.0, 1.8, 1.8>
  }
object { beam_minus
    rotate -45.0*x
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.25, 0.25, 20.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 9.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 12.6>
  }
object { beam_plus
    translate  <0.0, 1.8, 16.2>
  }
object { beam_minus
    translate  7.2*z
  }
object { beam_minus
    translate  10.8*z
  }
object { beam_minus
    translate  14.4*z
  }
  rotate 180.0*z
  translate  <17.8, 47.8, 1.0>
}

#declare Beam_Union7 = union {
object { beam_plus
    translate  <0.0, 1.8, 5.4>
  }
object { beam_minus
    translate  3.6*z
  }
object { beam_plus
    translate  <0.0, 1.8, 1.8>
  }
object { beam_minus
    rotate -45.0*x
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.25, 0.25, 20.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 9.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 12.6>
  }
object { beam_plus
    translate  <0.0, 1.8, 16.2>
  }
object { beam_minus
    translate  7.2*z
  }
object { beam_minus
    translate  10.8*z
  }
object { beam_minus
    translate  14.4*z
  }
  rotate -90.0*z
  translate  <16.0, 47.8, 1.0>
}
union { // Beam_Group1
  object { Beam_Union4 }
  object { Beam_Union5 }
  object { Beam_Union6 }
  object { Beam_Union7 }
  translate  -26.0*x
}


#declare Beam_Union = union {
object { beam_plus
    translate  <0.0, 1.8, 5.4>
  }
object { beam_minus
    translate  3.6*z
  }
object { beam_plus
    translate  <0.0, 1.8, 1.8>
  }
object { beam_minus
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.25, 0.25, 20.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 9.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 12.6>
  }
object { beam_plus
    translate  <0.0, 1.8, 16.2>
  }
object { beam_minus
    translate  7.2*z
  }
object { beam_minus
    translate  10.8*z
  }
object { beam_minus
    translate  14.4*z
  }
  translate  <16.0, 46.0, 1.0>
}
#declare Beam_Union3 = union {
object { beam_plus
    translate  <0.0, 1.8, 5.4>
  }
object { beam_minus
    translate  3.6*z
  }
object { beam_plus
    translate  <0.0, 1.8, 1.8>
  }
object { beam_minus
    rotate -45.0*x
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.25, 0.25, 20.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 9.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 12.6>
  }
object { beam_plus
    translate  <0.0, 1.8, 16.2>
  }
object { beam_minus
    translate  7.2*z
  }
object { beam_minus
    translate  10.8*z
  }
object { beam_minus
    translate  14.4*z
  }
  rotate 90.0*z
  translate  <17.8, 46.0, 1.0>
}


#declare Beam_Union2 = union {
object { beam_plus
    translate  <0.0, 1.8, 5.4>
  }
object { beam_minus
    translate  3.6*z
  }
object { beam_plus
    translate  <0.0, 1.8, 1.8>
  }
object { beam_minus
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.25, 0.25, 20.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 9.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 12.6>
  }
object { beam_plus
    translate  <0.0, 1.8, 16.2>
  }
object { beam_minus
    translate  7.2*z
  }
object { beam_minus
    translate  10.8*z
  }
object { beam_minus
    translate  14.4*z
  }
  rotate 180.0*z
  translate  <17.8, 47.8, 1.0>
}



#declare Beam_Union1 = union {
object { beam_plus
    translate  <0.0, 1.8, 5.4>
  }
object { beam_minus
    translate  3.6*z
  }
object { beam_plus
    translate  <0.0, 1.8, 1.8>
  }
object { beam_minus
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    // All transformations fixed
    scale <0.25, 0.25, 20.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 9.0>
  }
object { beam_plus
    translate  <0.0, 1.8, 12.6>
  }
object { beam_plus
    translate  <0.0, 1.8, 16.2>
  }
object { beam_minus
    translate  7.2*z
  }
object { beam_minus
    translate  10.8*z
  }
object { beam_minus
    translate  14.4*z
  }
  rotate -90.0*z
  translate  <16.0, 47.8, 1.0>
}
union { // Beam_Group
  object { Beam_Union }
  object { Beam_Union3 }
  object { Beam_Union2 }
  object { Beam_Union1 }
  // All transformations fixed
}


object { small_shere 
  translate  <14.0, 44.0, 3.5>
}
object { small_shere 
  translate  <13.0, 43.0, 2.0>
}
object { small_shere 
  translate  <15.0, 43.0, 2.0>
}
object { small_shere 
  translate  <13.0, 45.0, 2.0>
}
object { small_shere 
  translate  <15.0, 45.0, 2.0>
}


object { big_shere 
  translate  <0.96, 45.44, 3.0>
}
object { big_shere 
  translate  <12.8, 20.16, 3.0>
}
object { big_shere 
  translate  <-5.76, 25.6, 3.0>
}


object { wall 
  scale <0.1, 10.0, 10.0>
  rotate -90.0*z
  translate  <-20.0, 30.0, 10.0>
}

object { wall 
  scale <0.01, 30.0, 10.0>
  translate  <-30.0, 20.0, 10.0>
}

object { wall 
  scale <1.0, 40.0, 10.0>
  rotate -90.0*z
  translate  <10.0, -25.0, 10.0>
}

object { wall 
  scale <1.0, 40.0, 40.0>
  rotate -90.0*y
  translate  <10.0, 15.0, 0.0>
}

box { // caeling
  <-1, -1, -1>, <1, 1, 1>
  material {
    Wall_Back
  }
  scale <1.0, 40.0, 40.0>
  rotate -90.0*y
  translate  <10.0, 15.0, 20.0>
}

object { wall 
  scale <1.0, 40.0, 10.0>
  rotate -90.0*z
  translate  <10.0, 50.0, 10.0>
}
object { wall 
  scale <1.0, 40.0, 10.0>
  translate  <20.0, 10.0, 10.0>
}
object { wall 
  scale <1.0, 30.0, 10.0>
  translate  <-10.0, 0.0, 10.0>
}


//---------- POVRAY Logo -------------------------------

#declare logo_part1 = difference {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 0.4
    material {
      PovLogo_Txt
    }
  #if (Photons>0)
    photons      
    {              
      target              
      refraction on              
      reflection on      
    }
  #end        
    // All transformations fixed
    scale <1.0, 1.0, 2.4>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      PovLogo_Txt
    }
  #if (Photons>0)
    photons      
    {              
      target              
      refraction on              
      reflection on      
    }
  #end        
    // All transformations fixed
    scale <0.6, 0.7, 1.0>
    rotate <-90.0, -15.0, 0.0>
    translate  <-0.053168, -0.5, 2.832008>
  }
  // All transformations fixed
  rotate 17.0*y
  translate  -0.8*x
}
#declare logo_part2 = difference {
  torus { // Torus001
    1.025, 0.175  rotate -x*90
    material {
      PovLogo_Txt
    }
    // All transformations fixed
  #if (Photons>0)
    photons      
    {              
      target              
      refraction on              
      reflection on      
    }
  #end        
    scale <1.1, 1.0, 0.8>
    rotate -90.0*x
    translate  2.7*z
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      PovLogo_Txt
    }
  #if (Photons>0)
    photons      
    {              
      target              
      refraction on              
      reflection on      
    }
  #end        
    // All transformations fixed
    scale <1.15, 0.85, 1.0>
    rotate -90.0*x
    translate  <-0.2, -0.5, 2.7>
  }
  // All transformations fixed
}
union { // PovLogo
  object { logo_part1 }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      PovLogo_Txt
    }
  #if (Photons>0)
    photons      
    {              
      target              
      refraction on              
      reflection on      
    }
  #end        
    hollow
    // All transformations fixed
    scale 0.5
    translate  2.7*z
  }
  object { logo_part2 }
  material {
    PovLogo_Txt
  }
  #if (Photons>0)
    photons      
    {              
      target              
      refraction on              
      reflection on      
    }
  #end        
  scale 3.0
  translate  <5.0, 47.0, 5.0>
}


