//\\/////////////////////////////////////////////////////////////////////\\//
//\\/              //                                                   /\\//
//\\/ Mosaic Paint //  MACRO FOR MAKING mOSAICS WITH CIRCULAR PATTERN   /\\//
//\\/              //                                                   /\\//
//\\/              //                                                   /\\//
//\\/   l33t m   //   Fill in the form below with your image in the   /\\//
//\\/              //    same folder or the include folder and enjoy!   /\\//
//\\/              //                                                   /\\//
//\\/////////////////////////////////////////////////////////////////////\\//

#version 3.5;

global_settings {
 assumed_gamma 1.0
 noise_generator 1
}

#declare Image_Width = 100;          //  Width of input image in pixels.

#declare Image_Height = 100;         //  Height of input image in pixels.

#declare Grid_Width = 8;             //  Width of mosaic array. (Keep input image aspect ratio)

#declare Grid_Height = 8;            //  Height of mosaic array. (Keep input image aspect ratio)

#declare Cell_Depth = 2;             //  How many iterations per cell (no more than 3!).

#declare Use_Colour_Map = yes;       //  Determined weteher RGB values are averaged or not.

#declare No_Interpolation = yes;     //  Between steps in colour map will not be interpolated.

#declare Trace_Samples = 3;          //  Number of averaged samples or colour map entries.

#declare Image_Map = "plasma2.png"   //  Your image filename.

#declare Pattern_Scale_Factor = 5;   //  Determines size of patterns on secondary cells.

camera {
 orthographic
 location <Image_Width/2,Image_Height/2,0>
 up y*Image_Height
 right x*Image_Width
 look_at <Image_Width/2,Image_Height/2,1>
}

#macro eval_pigment(pigm, vec)
    #local fn = function { pigment { pigm } }
    #local result = (fn(vec.x, vec.y, vec.z));
    result
#end

#declare Cell_Depth = int(Cell_Depth);

#if (Cell_Depth < 1 | Cell_Depth > 3)

 #error "incorrect Cell_Depth value (use values 1 - 3)."

#end

#macro Moo (Image_Width,Image_Height,Grid_Width,Grid_Height,Cell_Depth,Image_Map,Use_Colour_Map,No_Interpolation,Trace_Samples,Pattern_Scale_Factor)

 #declare Map = pigment {
  image_map {
   png Image_Map
   interpolate 2
   once
  }
  scale <Image_Width,Image_Height,1>
 }

 #local Variable1 = 0;

 #local Variable2 = 0;
 
 #local Variable3 = Cell_Depth;

 #local Variable4 = 0;
 
 #local Variable5 = Trace_Samples;
 
 #while (Variable1 < Grid_Width)

  #while (Variable2 < Grid_Height)

   sphere {
    0, 1
    scale <((Image_Width/Grid_Width)/2)/Cell_Depth,((Image_Height/Grid_Height)/2)/Cell_Depth,1>
    translate <((Image_Width/Grid_Width)*Variable1)+(Image_Width/Grid_Width)/2,((Image_Height/Grid_Height)*Variable2)+(Image_Height/Grid_Height)/2,300>
    pigment {
     eval_pigment(Map<((Image_Width/Grid_Width)*Variable1)+(Image_Width/Grid_Width)/2,((Image_Height/Grid_Height)*Variable2)+(Image_Height/Grid_Height)/2,300>)
    }
    finish {
     ambient 0
     diffuse 1
    }
   }

    #while(Variable3 > 1)

     #declare Pigment_Map = pigment_map {
      #local Variable6 = 0;
       #while (Variable6 < Variable5)
       #declare Position = <(((Image_Width/Grid_Width)*Variable1)+(Image_Width/Grid_Width)/2),((Image_Height/Grid_Height)*Variable2)+(Image_Height/Grid_Height)/2,300>;
        [((Variable6-No_Interpolation)/Variable5) eval_pigment(Map Position+<(sin(Variable6/Variable5)-.5)*(1.7*(Image_Width/(Grid_Width*Variable3)/2)),-(cos(Variable6/Variable5)-.5)*(1.7*(Image_Width/(Grid_Width*Variable3)/2)),300>)]
        [(Variable6/Variable5) eval_pigment(Map Position+<(sin(Variable6/Variable5)-.5)*(1.7*(Image_Width/(Grid_Width*Variable3)/2)),-(cos(Variable6/Variable5)-.5)*(1.7*(Image_Width/(Grid_Width*Variable3)/2)),300>)]
        [((Variable6+No_Interpolation)/Variable5) eval_pigment(Map Position+<(sin(Variable6/Variable5)-.5)*(1.7*(Image_Width/(Grid_Width*Variable3)/2)),-(cos(Variable6/Variable5)-.5)*(1.7*(Image_Width/(Grid_Width*Variable3)/2)),300>)]
       #local Variable6 = Variable6 + 1;
      #end
     }
 
    torus {
     1.7,.3
     rotate x*90
     scale <Image_Width/(Grid_Width*Variable3)/2,Image_Height/(Grid_Height*Variable3)/2,1>
     translate <((Image_Width/Grid_Width)*Variable1)+(Image_Width/Grid_Width)/2,((Image_Height/Grid_Height)*Variable2)+(Image_Height/Grid_Height)/2,300>
     pigment {
      #if (Use_Colour_Map)
       bozo
        pigment_map {
         Pigment_Map
        }
       scale <Pattern_Scale_Factor/Grid_Width*Grid_Height,Pattern_Scale_Factor/Grid_Width*Grid_Height,1>
      #else
       average
        pigment_map {
         Pigment_Map
        }
      #end
     }
    }
    
    #local Variable3 = Variable3 - 1;
    
    #end
    
    #local Variable3 = Cell_Depth;
    #local Variable2 = Variable2 + 1;

  #end
  #local Variable1 = Variable1 + 1;
  #local Variable2 = 0;

 #end

#end

Moo (Image_Width,Image_Height,Grid_Width,Grid_Height,Cell_Depth,Image_Map,Use_Colour_Map,No_Interpolation,Trace_Samples,Pattern_Scale_Factor)

light_source {
 0, rgb 1
}