//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 7 lights, 1 materials and 27 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 09/17/2001    (17.09.2001)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,1,1> }
  }
}


/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.000,     -24.930,       0.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,       0.000,       0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // lRed
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.000>*0.2500
  translate  <-1.0, 0.0, 1.0>
}

light_source {   // lWhite
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.1000
}

light_source {   // lYellow
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.000>*0.1000
  translate  1.5*z
}

light_source {   // lGreen
  <0.0, 0.0, 0.0>
  color rgb <0.000, 1.000, 0.000>*0.1000
  translate  <1.0, 0.0, 1.0>
}

light_source {   // lCyan
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.500, 0.500>*0.1000
  translate  <1.0, 0.0, -0.5>
}

light_source {   // lBlue
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.000, 1.000>*0.1000
  translate  -1.0*z
}

light_source {   // lViolet
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.000, 0.500>*0.1000
  translate  <-1.0, 0.0, -0.5>
}


//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "psycho.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Sphere001 = object {
  sphere { // Sphere001
    <0,0,0>,1
    material {
      texBall
    }
    hollow
    translate  <0.0, 4.866423, 4.405765>
  }
}




//
// ********  OBJECTS  *******
//

merge { // Ring
  object { // Sphere011 -> Sphere001
    Sphere001
    translate  <-4.091229, 0.0, -2.087576>
  }
  object { // Sphere012 -> Sphere001
    Sphere001
    translate  <-2.276004, 0.0, -0.503898>
  }
  object { // Sphere010 -> Sphere001
    Sphere001
    translate  <-4.89866, 0.0, -4.40577>
  }
  object { // Sphere008 -> Sphere001
    Sphere001
    translate  <-2.338367, 0.0, -8.350305>
  }
  object { // Sphere007 -> Sphere001
    Sphere001
    translate  -8.926188*z
  }
  object { // Sphere009 -> Sphere001
    Sphere001
    translate  <-4.122411, 0.0, -6.766626>
  }
  object { // Sphere005 -> Sphere001
    Sphere001
    translate  <4.16553, 0.0, -6.694641>
  }
  object { // Sphere006 -> Sphere001
    Sphere001
    translate  <2.381487, 0.0, -8.27832>
  }
  object { // Sphere004 -> Sphere001
    Sphere001
    translate  <4.797808, 0.0, -4.40577>
  }
  object { // Sphere003 -> Sphere001
    Sphere001
    translate  <4.206334, 0.0, -2.159562>
  }
  object { // Sphere002 -> Sphere001
    Sphere001
    translate  <2.319123, 0.0, -0.503898>
  }
  object { Sphere001 }
  torus { // Torus001
    1.6025, 0.0925  rotate -x*90
    material {
      texBall
    }
    hollow
    scale <3.087576, 2.877385, 1.224604>
    rotate -90.0*x
    translate  4.791555*y
  }
}






#version unofficial megapov 0.7;
light_source
{<0.000,0.000,0.000>
	glow
	{
		type 1
		size 0.250
		radius 0.000
		color rgb <1.000,1.000,1.000>
	}
fade_distance   0
fade_power   0
}


#version unofficial megapov 0.7;
light_source
{<-1.000,0.000,1.000>
	glow
	{
		type 2
		size 1.000
		radius 0.000
		color rgb <1.000,0.000,0.000>
	}
fade_distance   0
fade_power   0
}


#version unofficial megapov 0.7;
light_source
{<1.000,0.000,1.000>
	glow
	{
		type 2
		size 1.000
		radius 0.000
		color rgb <0.000,1.000,0.000>
	}
fade_distance   0
fade_power   0
}


#version unofficial megapov 0.7;
light_source
{<0.000,0.000,-1.000>
	glow
	{
		type 2
		size 1.000
		radius 0.000
		color rgb <0.000,0.000,1.000>
	}
fade_distance   0
fade_power   0
}


#version unofficial megapov 0.7;
light_source
{<0.000,0.000,1.500>
	glow
	{
		type 2
		size 1.000
		radius 0.000
		color rgb <0.500,0.500,0.000>
	}
fade_distance   0
fade_power   0
}


#version unofficial megapov 0.7;
light_source
{<1.000,0.000,-0.500>
	glow
	{
		type 2
		size 1.000
		radius 0.000
		color rgb <0.000,0.500,0.500>
	}
fade_distance   0
fade_power   0
}


#version unofficial megapov 0.7;
light_source
{<-1.000,0.000,-0.500>
	glow
	{
		type 2
		size 1.000
		radius 0.000
		color rgb <0.500,0.000,0.500>
	}
fade_distance   0
fade_power   0
}












