#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "finish.inc"
#include "woods.inc"
#include "golds.inc" 
#include "glass.inc"
#include "metals.inc" 

global_settings{
        ambient_light color White
        radiosity{
                brightness 3.3          //3.3 is default
                count 200              //100-150 are usually good, higher is better, longer
                distance_maximum 1      //default is 0
                error_bound .33          //def. is .44, .5 is rough, .33 is good, lower takes too long
                gray_threshold .5
                low_error_factor .8
                recursion_limit 1      //can use 1 or 2
                }
                }

#declare Location=<0,40,-200>;
#declare LookAt=<0,40,00>;
#declare Rotation=<0,0,0>;

camera {location Location look_at LookAt rotate Rotation }
                  
#declare Clouds =
pigment {
    wrinkles
    turbulence 0.1
    lambda 2.2
    omega 0.707
    color_map {
        [0.20 SkyBlue  ]
        [0.50 rgb <1,.7,.86>]
        [1.00 rgb <1,.7,.86>*.8 ]
    }
    scale <0.5, 0.15, 1>
}
                  

#declare CandySky =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00 rgb <0.847, 0.749, 0.847> ] // horizon
            [0.10 rgb <.47,.79,.89> ]                   // horizon
            [0.20 Clouds ]
        }
    }
}      
 
sky_sphere{CandySky translate <0,-1,0> }
       
//light_source {<100,150,-100> color White}   
//light_source {<100,150,100> color White}   
//light_source {<-100,150,-100> color White}   
//light_source {<-100,150,100> color White}
light_source{<0,40,-100> color White}




plane {y,0
pigment{checker color White color Black scale 4}
finish {specular .2 roughness .02}
}

/*
#include "mint.inc"  
#include "lolly.inc"    
#declare PathCT=0;                                  //temp. counting varable    
#declare PathEnd=300;
#declare PathSeed=seed(2);
#declare PS1=seed (PathSeed);
#declare PS2=seed(PS1);              
#declare PathWidth=10;                          //1/2 path width

#while (PathCT<PathEnd/30)      
                #declare Lolly=mod (PathCT+5,5);
                #switch (Lolly)
                        #case (0) #declare CurrLolly=object {RedLolly} #break
                        #case (1) #declare CurrLolly=object {YellowLolly} #break
                        #case (2) #declare CurrLolly=object {PurpleLolly} #break
                        #case (3) #declare CurrLolly=object {OrangeLolly} #break
                        #case (4) #declare CurrLolly=object {GreenLolly} #break
                #end                   
                object {Mint rotate z*90 translate <-(PathWidth+5),2,30*PathCT>}
                object {Mint rotate z*90 translate <PathWidth+5,2,30*PathCT>}
                object {CurrLolly translate <PathWidth+5,0,15+(30*PathCT)>} 
                object {CurrLolly translate <-(PathWidth+5),0,15+(30*PathCT)>}     
        #declare PathCT=PathCT+1;
#end
*/

//#include "button.inc"
//object {ButtonCandy translate <-3,0,0>}
//object {ButtonCandy translate <3,0,0>}
//object {ButtonCandy translate <9,0,0>}
//object {ButtonCandy translate <-9,0,0>}

        



box {<-42,0,-42>,<42,.5,42> pigment {color Blue}}
#include "house.inc"
object {GingerBreadHouse}


 


