/*------------------------------------------------------
This is the gingerbread house.  It is 84 unitsx84unitsx84units
with a sloping roof, dutch door, windows, and various
candy embellishments
------------------------------------------------------*/

/*------------------------------------------------------
TEXTURES AND COLORS
------------------------------------------------------*/   
#declare GingerBreadTex=texture{
pigment {color rgb <.55,.35,.22>}
normal {bump_map {tga "ginger_htfld.tga"} rotate x*90}
finish {ambient .15}
}


/*------------------------------------------------------
OBJECTS
------------------------------------------------------*/  
 
//front step
#declare Step=superellipsoid {<.2,.2> texture {GingerBreadTex} scale <14,.5,7> translate <0,.5,-7-42>}        

//Side walls: 
#declare SideWalls=union{
superellipsoid {<.2,.2> texture {GingerBreadTex}
                rotate z*90
                translate <-1,0,0>
                scale <.5,15,42>
                translate <-42,15,0>
                }
superellipsoid {<.2,.2> texture {GingerBreadTex}
                rotate z*90
                translate <1,0,0>
                scale <.5,15,42>
                translate <42,15,0>
                }         
}                
                               
//Front and Back Walls:
#declare BackWall=
difference{             //difference is for peaked roof
superellipsoid {<.2,.2> texture {GingerBreadTex}        //back wall
                rotate x*90 
                translate <0,0,1>
                scale <42,42,.5>
                translate <0,42,42>
                }
box {<-100,0,-100>,<100,100,100>                             
     rotate z*52.125
     translate <0,84,0>
     }
box {<-100,0,-100>,<100,100,100>                                  
     rotate z*-52.125
     translate <0,84,0>
     }                 
}//end difference    

//Roof Pieces
#declare Roof=union{
superellipsoid {<.2,.2> texture {GingerBreadTex}
                translate <-1,0,0>
                scale <75/2,.5,50>
                rotate z*52.125
                translate <0,84,0>
                }    
superellipsoid {<.2,.2> texture {GingerBreadTex}
                translate <1,0,0>
                scale <75/2,.5,50>
                rotate z*-52.125
                translate <0,84,0>
                }   
}

//front wall with hole for door, window
#declare FrontWall=
difference{
merge{    
#include "m&m.inc"
object {RedMM scale 2 rotate x*-90 translate <0,65,-42>}
object {RedMM scale 2 rotate x*-90 translate <0,45,-42>}
object {RedMM scale 2 rotate x*-90 translate <10,55,-42>}
object {RedMM scale 2 rotate x*-90 translate <-10,55,-42>}
object {YellowMM scale 2 rotate x*-90 translate <7.07,55+7.07,-42>}
object {YellowMM scale 2 rotate x*-90 translate <7.07,55-7.07,-42>}
object {YellowMM scale 2 rotate x*-90 translate <-7.07,55+7.07,-42>}
object {YellowMM scale 2 rotate x*-90 translate <-7.07,55-7.07,-42>}
object {GreenMM scale 2 rotate x*-90 translate <0,55,-42>} 
                                                                 
difference{
superellipsoid {<.2,.2> texture {GingerBreadTex}       //front wall
                rotate x*90 
                translate <0,0,-1>
                scale <42,42,.5>
                translate <0,42,-42>
                }                                                  
box {<-8,.5,-44>,<8,31.5,-40>}
cylinder {<0,55,-44>,<0,55,-40>,8}
}                        
superellipsoid{<.2,.2> texture {GingerBreadTex}
                rotate x*90 
                scale <1,8,.5>
                translate <0,55,-42-.5>
                }
superellipsoid{<.2,.2> texture {GingerBreadTex}
                rotate x*90 
                scale <8,1,.5>
                translate <0,55,-42-.501>
                }               
}
box {<-100,0,-100>,<100,100,100>                             
     rotate z*52.125
     translate <0,84,0>
     }
box {<-100,0,-100>,<100,100,100>                                  
     rotate z*-52.125
     translate <0,84,0>
     }                 
}                
     
//half of a dutch door
#declare DoorPiece=                           
superellipsoid{<.2,.2> texture {GingerBreadTex}
                rotate x*90 translate <0,1,0>
                scale <8,8,1> 
                }

#declare Door=union{                
object {DoorPiece translate <0,0,-43>}     
object {DoorPiece 
        translate <-8,0,0>                  
        rotate y*-75
        translate <8,0,0>
        translate <0,16,-43>
        }
}       
                
/*------------------------------------------------------
FINAL ASSEMBLIES
------------------------------------------------------*/  
#declare GingerBreadHouse=union{
object {SideWalls}
object {FrontWall}
object {BackWall}
object {Roof}
object {Door}
object {Step}
}                
                