/*------------------------------------------------------
This file has definitions for M&M's.  They are 2 units high,

------------------------------------------------------*/

/*------------------------------------------------------
TEXTURES AND COLORS
------------------------------------------------------*/   
#declare MMRedPig=rgb <1,0,0>;
#declare MMGreenPig=rgb <0,1,0>;
#declare MMOrangePig=rgb <1,.5,0>;
#declare MMYellowPig=rgb <1,1,0>;
#declare MMBrownPig=rgb <.25,.1,0>*.75;
#declare MMBluePig=rgb <0,0,1>;

#declare MMFinish=finish{ambient .01 specular .05}

#declare RedTex=texture{
                        pigment {MMRedPig}
                        finish {MMFinish}
                        } 
#declare RedTex2=texture{
                        pigment {bozo color_map{
                                        [0 MMRedPig]
                                        [.5 color White]
                                        [1 MMRedPig]
                                }
                                turbulence .65
                                ramp_wave
                                }
                        finish {MMFinish}                                
                        }                                                        

#declare GreenTex=texture{
                        pigment {MMGreenPig}
                        finish {MMFinish}
                        } 
#declare GreenTex2=texture{
                        pigment {bozo color_map{
                                        [0 MMGreenPig]
                                        [.5 color White]
                                        [1 MMGreenPig]
                                }
                                turbulence .65
                                ramp_wave
                                }
                        finish {MMFinish}                                
                        }                                                        
#declare OrangeTex=texture{
                        pigment {MMOrangePig}
                        finish {MMFinish}
                        } 
#declare OrangeTex2=texture{
                        pigment {bozo color_map{
                                        [0 MMOrangePig]
                                        [.5 color White]
                                        [1 MMOrangePig]
                                }
                                turbulence .65
                                ramp_wave
                                }
                        finish {MMFinish}                                
                        }                                                        
#declare YellowTex=texture{
                        pigment {MMYellowPig}
                        finish {MMFinish}
                        } 
#declare YellowTex2=texture{
                        pigment {bozo color_map{
                                        [0 MMYellowPig]
                                        [.5 color White]
                                        [1 MMYellowPig]
                                }
                                turbulence .65
                                ramp_wave
                                }
                        finish {MMFinish}                                
                        }                                                        
#declare BrownTex=texture{
                        pigment {MMBrownPig}
                        finish {MMFinish}
                        } 
#declare BrownTex2=texture{
                        pigment {bozo color_map{
                                        [0 MMBrownPig]
                                        [.5 color White]
                                        [1 MMBrownPig]
                                }
                                turbulence .65
                                ramp_wave
                                }
                        finish {MMFinish}                                
                        }   
                        
#declare BlueTex=texture{
                        pigment {MMBluePig}
                        finish {MMFinish}
                        } 
#declare BlueTex2=texture{
                        pigment {bozo color_map{
                                        [0 MMBluePig]
                                        [.5 color White]
                                        [1 MMBluePig]
                                }
                                turbulence .65
                                ramp_wave
                                }
                        finish {MMFinish}                                
                        }                                                        
                                                                             

 
 #declare RTex=texture{material_map{tga "mm.tga" once texture {RedTex} texture {RedTex2} }translate <-.5,-.5,0> }
 #declare YTex=texture{material_map{tga "mm.tga" once texture {YellowTex} texture {YellowTex2} }translate <-.5,-.5,0> }
 #declare GTex=texture{material_map{tga "mm.tga" once texture {GreenTex} texture {GreenTex2} }translate <-.5,-.5,0> }
 #declare OTex=texture{material_map{tga "mm.tga" once texture {OrangeTex} texture {OrangeTex2} }translate <-.5,-.5,0> }
 #declare BTex=texture{material_map{tga "mm.tga" once texture {BrownTex} texture {BrownTex2} }translate <-.5,-.5,0> }
 #declare BlTex=texture{material_map{tga "mm.tga" once texture {BlueTex} texture {BlueTex2} }translate <-.5,-.5,0> }
      

/*------------------------------------------------------
Objects
-------------------------------------------------------*/                     
#declare MMRad=1;
#declare MM=sphere {<0,0,0>,MMRad}

/*------------------------------------------------------
Final Assemblies
-------------------------------------------------------*/
#declare RedMM=object {MM texture {RTex  scale (2.1*MMRad/1.5) rotate x*90}  scale <1,.5,1> translate <0,1.5*.5,0>}
#declare YellowMM=object {MM texture {YTex  scale (2.1*MMRad/1.5) rotate x*90}  scale <1,.5,1> translate <0,1.5*.5,0>}
#declare GreenMM=object {MM texture {GTex  scale (2.1*MMRad/1.5) rotate x*90}  scale <1,.5,1> translate <0,1.5*.5,0>}
#declare OrangeMM=object {MM texture {OTex  scale (2.1*MMRad/1.5) rotate x*90}  scale <1,.5,1> translate <0,1.5*.5,0>}
#declare BrownMM=object {MM texture {BTex  scale (2.1*MMRad/1.5) rotate x*90}  scale <1,.5,1> translate <0,1.5*.5,0>}
#declare BlueMM=object {MM texture {BlTex  scale (2.1*MMRad/1.5) rotate x*90}  scale <1,.5,1> translate <0,1.5*.5,0>}

