// Persistence of Vision Ray Tracer Scene Description File
// File: basketball.pov
// Vers: MegaPOV 0.7
// Desc: An isosurface basketball.  Have fun.
// Date: Began - 11 July 2001
// Auth: Alan Holding - manhog@lineone.net

//  Set ups
#version unofficial MegaPOV 0.7;
global_settings {assumed_gamma 1.8}
background {rgb <0.4,0.4,0.8>}

//  Lights
light_source {<-300,500,-500> rgb 1.7}
light_source {<200,-100,-100> rgb 0.7 shadowless}

//  Camera
camera {location <0,0,-8> angle 20 look_at <0,0,0> perspective}  

//  Action!
#local txt_basketball=texture {
  pigment {image_map {png "basketballnew" map_type 1 interpolate 2}}
  finish {specular 0.1 roughness 0.02 phong 0.25 phong_size 150 ambient 0.05 diffuse 0.5 metallic}
}

#local fnc_basketballbump=function {pigment {image_map {png "basketballbumpnew" map_type 1 interpolate 2}}}
 
#local obj_basketball=isosurface {
  function {(x*x+y*y+z*z-0.95 - fnc_basketballbump(x,y,z)*0.025) + noise3d(x*100,y*100,z*100)*0.01}
  threshold 0
  sign 1
  accuracy 0.001
  method 2
  max_gradient 3.444
  contained_by {box {-1, 1}}
  all_intersections
  texture {txt_basketball}
}

object {obj_basketball rotate <75,50,45>}
