// Mouse and mousetrap - Mousetrap now

#version 3.1;
#include "base.inc"

#local WireT =
texture{
   pigment{ crackle
            pigment_map{ [0 rgb 0.9][0.7 rgb 0.3][1 rgb 0] } scale 0.5 }
   finish{ phong 0.5 phong_size 200
           diffuse 0.7 metallic brilliance 5 reflection 0.05 }
}

//#include "springs.mcr"

// Tpi= Turns/(CL/(WR*2))

#local Turns = 31.51;
// Coil Length, Wire Radius, Coil Radius, Turn pitch (0.5 = wire diameter).
#local Cl=2.5; #local Wr=0.03; #local Cr=0.16; #local Tp = Turns/(Cl/(Wr*2));

#local Tack =
union{ torus{ 0.16, 0.04 clipped_by{ plane{ x,0 } } }
       cylinder{ <0,0, 0.16>,<0.2,0, 0.16>, 0.04 }
       cylinder{ <0,0,-0.16>,<0.2,0,-0.16>, 0.04 }
       rotate <90,0,-90>
}
/*
#local Spring =   // Commented out
union{
   object{ Spring2( Cl, Wr, Cr, Tp ) }
   cylinder{ <Cr,0,0>,<Cr,0,1.5>, Wr } sphere{ x*Cr, Wr scale <1,1,1.3>}
   difference{ torus{ Wr*3, Wr rotate -z*90 }
            box{ <-0.5,0,0>,<0.5,1,1> inverse }
            translate <Cr,-Wr*3,1.5> }
   cylinder{ <Cr, -Wr*3, 1.5+Wr*3>, <Cr, -(Wr*3+0.2), 1.5+Wr*3>, Wr}
   sphere{ <-Cr,Cl,0>, Wr rotate -y*1 }
   cylinder{ <-Cr,Cl,0>,<-Cr,Cl,1.4>, Wr rotate -y*1 }
   rotate <90,0,91>
   translate <0,Wr+Cr,-Cl/2>
}
*/
#local Pin =
union{
  union{
    torus{ 0.1, 0.04 rotate x*90
           clipped_by{ box{ <-1,0,-1>,<0.05,1,1> inverse } } }
    cylinder{ <-0.1,0,0>,<-0.1,0.17,0>, 0.04 }
    rotate -z*30
    clipped_by{ box{ <0.05,0,-1>,<1,1,1> inverse } }
    translate -y*0.15
  }
  cylinder{ <0.1,-0.15,0>,<0.1,0,0>, 0.04 }
  torus{ 0.1, 0.04 rotate x*90
          clipped_by{ plane{ -y,0 } }
          clipped_by{ plane{ -x,0 rotate -z*36 } } }
  cylinder{ <-2.95, 0.1,0>,<0,0.1,0>, 0.04 rotate -z*36 }
  rotate z*36
  translate <-0.09,0.13,0>
}

#local Half=
union{
   torus{ 0.08, 0.034 rotate x*90
           clipped_by{ plane{ -y,0 } }
           clipped_by{ plane{ y,0 rotate z*60 } } }
   cylinder{ <-1,0.08,0>,<0,0.08,0>, 0.034 rotate -z*30 }
   torus{ 0.08, 0.034 rotate x*90
           clipped_by{ plane{ y,0 } }
           translate x*0.16 }
   cylinder{ 0, y*0.2, 0.034 translate x*0.24 }
}

#local Trigger =
union{
  object{ Half translate  z*0.1 }
  object{ Half translate -z*0.1 }
  torus{ 0.1, 0.034 rotate z*90 clipped_by{ plane{ -y,0 } }
         translate <0.24,0.2,0> }
}

#local Hinge =
union{
   torus{ 0.05, 0.034 rotate z*90
          clipped_by{ box{ <-0.5,0,0>,<0.5,1,1> } }
          translate z*0.134 }
   torus{ 0.05, 0.034 rotate z*90
          clipped_by{ box{ <-0.5,0,0>,<0.5,1,-1> } }
          translate -z*0.134 }
   cylinder{ -z*0.134,z*0.134, 0.034 translate y*0.05 }
   cylinder{ 0 ,-y*0.30, 0.034 translate  z*(0.1+0.034+0.05) }
   cylinder{ 0 ,-y*0.30, 0.034 translate -z*(0.1+0.034+0.05) }
}

// Make squareish frame, z*2.8  x*2.3
#local Wr2 = 0.034; // Frame wire
#local Rad2 = 12;   // Frame curve under pin.
#local FrameEnd =
torus{ Rad2, Wr2 clipped_by{ plane{ z,0 rotate -y*6.2 } }
                   clipped_by{ plane{-z,0 rotate  y*6.2 } }
//       translate x*(2.5-Rad2)
}

#local FrameSide =
union{
  cylinder{ 0, -z*0.4, Wr2 translate -x*0.1 }
  torus{ 0.1, 0.034 clipped_by{ box{ <-1,-0.5,0>,<0,0.5,1> } } }
  cylinder{ 0, x*2.1, Wr2 translate z*0.1 }
  translate <-2.1,0,-0.1> rotate x*6.2 // Adjust angle here
}

#local Frame =
union{   // Total frame
  object{ FrameEnd }
union{
  object{ FrameSide }
  torus{ 0.1, Wr2 clipped_by{ box{ <0,-0.5,0>,<1,0.5,1> } } translate -z*0.1 }
  translate <-0.1,0,0.1>
  rotate z*90
  translate x*Rad2
  rotate -y*6.2
}

union{
  object{ FrameSide scale <1,1,-1> }
  torus{ 0.1, Wr2 clipped_by{ box{ <0,-0.5,0>,<1,0.5,-1> } } translate z*0.1 }
  translate <-0.1,0,-0.1>
  rotate z*93  // 90 + twist on single side
  translate x*Rad2
  rotate y*6.2
}
  translate -x*Rad2 // Small offset will raise or lower ALL frame
  rotate -z*86
  rotate x*3
  translate <2.3,0.38,0>
}
#declare Trap =
union{
//  object{ Spring }
  object{ Tack translate <0, 0.15,-(Cl/2+Wr+0.04)> }
  object{ Tack translate <0, 0.15, (Cl/2+Wr+0.04)> }
  object{ Tack rotate y*90 translate <2.6,0.06,0> }
  object{ Frame }
  object{ Pin translate <2.6,0.23,0> }
  object{ Trigger translate <-0.6,0.24,0> }
  object{ Hinge translate <-0.435,0.17,0> }
  object{ Base }
  texture{ WireT }
}
