//  Persistence of Vision Ray Tracer Scene Description File
//  File: grass-pr.pov
//  Vers: MegaPOV 0.7
//  Desc: Grass on heightfield using trace()
//  Date: Began - 12 May 2001 (continuation of Spline Wall)
//  Auth: Alan Holding - manhog@lineone.net

//  PUBLIC RELEASE VERSION
//  Removed references to my robot, bless him.

//  SWITCHES
//  Set the switches below to yes or no depending on what you want to appear in the scene.
#local do_fancy_sky=yes;

//  See the note below about using the SplineTree
//#local do_tree=yes;

//  If you set the heightfield to no, you won't get any grass either.
//  You don't just expect the grass to hang in mid-air do you?
#local do_heightfield=yes;
#local do_grass=yes;

//  Number of grass blade objects - it's actually DOUBLE this number.
//  Good spreads start around 90,000(!).  I used 150,000 for the posted image.
#local grass=10000;

//  Probability of a lighter coloured (bleached) blade of grass appearing.
//  0=Every blade is bleached 1=No bleached blades
#local probability=0.90;

//  Set-ups and main includes
#version unofficial MegaPOV 0.7;
global_settings {assumed_gamma 1.7 max_trace_level 40}

//  Textures
//  Cheapo soil from my collection
#local txt_soil=texture {
  pigment {
    wrinkles
    colour_map {
      [0.2 rgb <0.6,0.45,0.4>]
      [0.5 rgb <0.6,0.5,0.45>]
      [0.7 rgb <0.6,0.55,0.5>]
    }
    scale 0.5
  }
  finish {ambient 0.2 diffuse 0.6}
  normal {
    average
    normal_map {
      [granite 0.3 scale 5]
      [dents 1 scale 3]
      [0.5 wrinkles 0.2 scale 2]
    }
  }
}

//  Environment
background {rgb <0.3,0.3,0.7>}
fog {fog_type 2 rgb <0.4,0.4,0.8> distance 2000 fog_alt 200}

//  Camera
camera {
  location <0,60,-420>
  right x*image_width up y*image_height
  angle 60
  look_at <30,150,0>
  perspective 
}  

//  Lights
light_source {<-5000,5000,-10000> rgb <1,0.975,0.95>*1.75}
light_source {<500,100,500> rgb 0.5 shadowless}

//  Variables
#local seeder=seed(2058);

//  SPLINE TREE
//  You should only uncomment this block of code if you have Andrew Clinton's
//  SplineTree macro installed in your POV-Ray set-up.
//  See his website for more information - http://povplace.addr.com/
/*
#if (do_tree=yes)
  #include "leafdefs.inc"
  #include "splinetree.inc"
  #declare recursionmax = 6; // Defines the complexity of the tree
  #declare divisions = array[6] {6,5,5,4,3,2}
  init_rand (23000,24,25)     // Supply seeds to initialize the random variable
  // Variables modeled exponentially
  // Use: init_variable (start_size, end_size, base)
  init_tdev (0.4, 0.8, 0.5)
  init_rdev (70, 10, 1)
  init_twigprob (0.1, 0.8, 0.2)
  init_branchl (6, 0.2, 0.4)
  init_branchw (0.4, 0.005, 0.6)
  // Odd variables
  init_roots (2)			// Use: init_roots (rootrecursionmax)
  init_splinedev (0.15,1.0)	// Use: init_splinedev (min_dev, max_dev)
  init_simplify (2,5)		// Use: init_simplify (num_simplify_levels, num_segments)
  // Add some gravity
  #declare tendancy = <0,-0.1,0.1>;
  // Variables for leaves
  #declare leafarray = array[5] {fallmaple1,maple2,maple3,pinkflower,fallmaple2}
  #declare leafprob = array[5] {0.1,0.1,0.1,0.2,0.3}
  #declare leafscale = array[5] {0.2,0.2,0.2,0.3,0.3}
  #declare leafnoise = array[5] {1,1,1,0.5,0.2}
  // Assign the branch texture
  #declare branchtexture = texture {light_branch2} // standard_branch is defined in leafdefs.inc
  // Define transformations assigned to the whole tree here.
  #declare global_transform = transform {
  	scale 26
  	rotate <0,23,0>
  	translate <-40,60,-180>
  }
  // Provide feedback in the first 2 recursion levels
  #declare feedback=1;
  // Call the macro
  splinetree(0,0)
#end
*/

//  FANCY SKY
//  Note - the higher number_of_cloud_layers, the slower the render
#if (do_fancy_sky=yes)
  #local number_of_cloud_layers=4;
  #local sw_map1=colour_map {
    [0.0 rgbf <1,1,1,1>]
    [0.4 rgbf <0.5,0.7,0.75+(rand(seeder)/4),1>]
    [0.5 rgbf <0.5,0.7,0.75+(rand(seeder)/4),0.8>]
    [0.6 rgbf <0.5+(rand(seeder)/4),0.65,0.8+(rand(seeder)/5),0.6>]
    [0.7 rgbf <0.5+(rand(seeder)/4),0.75,1,0.2>]
    [1.0 rgbf <0.5+(rand(seeder)/4),0.75,0.75+(rand(seeder)/4),0.1>]
  }
  #local looper=0;
  #while (looper<number_of_cloud_layers)
    sphere {
      y 15000+(5000*looper)
      pigment {
        wrinkles
        colour_map {
          [0.0 rgbf <0.75+(rand(seeder)/4),0.75,0.75,1>]
          [0.4 rgbf <0.75+(rand(seeder)/4),0.75,0.75+(rand(seeder)/4),1>]
          [0.5 rgbf <0.75,0.75+(rand(seeder)/4),0.75+(rand(seeder)/4),0.8>]
          [0.6 rgbf <0.75+(rand(seeder)/4),1,0.75+(rand(seeder)/4),0.6>]
          [0.7 rgbf <1,1,0.75+(rand(seeder)/4),0.2>]
          [1.0 rgbf <0.75+(rand(seeder)/4),0.75+(rand(seeder)/4),0.75+(rand(seeder)/4),0.1>]
        }
        turbulence 0.01+rand(seeder)
        translate y*(looper*10)
        scale 7000+(looper*100)
        rotate looper*20
      }
      finish {ambient 0.75 diffuse 0.25}
      hollow on no_shadow
      scale <1,0.25,1>
    }
    #local looper=looper+1;
  #end
#end

//  HEIGHTFIELD AND GRASS
//  hf_scale          - scale of the heightfield
//  hf_object         - the heightfield itself, based on the supplied image 'hf_grass.png'
//  grass_spread_x    - spread of the grass in the x axis, from -grass_spread_x to +grass_spread_x
//  grass_spread_z    - as above, but for the z axis
//  grass_translate_z - moving the grass about in z
//  looper            - the loop counter
//  hf_tester         - creates a random x and z co-ordinate, limited by the grass spread co-ordinates above
//  hf_norm           - gets the normal of the above point (ignore if you're scratching you're head - it's not used here)
//  hf_object_pos     - gets the y location of the heightfield at the specified x and z co-ordinates in hf_tester
#if (do_heightfield=yes)
  #local hf_scale=<800,100,800>;
  #local hf_object=height_field {
    png "hf_grass" smooth hierarchy on
    translate <-0.5,0,-0.5> scale hf_scale
    hollow on
  }
  #if (do_grass=yes)
    #include "blade-pr.inc"
    #local grass_spread_x=270;
    #local grass_spread_z=245;
    #local grass_translate_z=-245;
    #local looper=0;
    #while (looper<grass)
      //  Get blade height on heightfields
      #local hf_tester=<(rand(seeder)-0.5)*grass_spread_x,0,((rand(seeder)-0.5)*grass_spread_z)+grass_translate_z>;
      #local hf_norm=<0,0,0>;
      #local hf_object_pos=trace (hf_object, <hf_tester.x,hf_tester.y+400,hf_tester.z>,<0,-100,0>,hf_norm);
      object {
        blade_mesh2
        texture {
          #if (rand(seeder)>probability)
            pigment {rgbf <0.6,0.7,0.5,0.7>}
          #else
            pigment {rgb <(rand(seeder)*0.1)+0.2,0.4,0.1>}
          #end
          finish {phong 0.7 phong_size 100 ambient 0.25 diffuse (rand(seeder)*0.4)+0.4 metallic specular 0.5 roughness 0.1}
        }
        scale <0.5+(rand(seeder)*1),0.5+(rand(seeder)*1.5),1>*2.6
        rotate <rand(seeder)*-15,(rand(seeder)*360),0>
        translate hf_object_pos
      }
      #local looper=looper+1;
    #end
  #end
  #version 3.1;
  object {hf_object texture {txt_soil}}
#else
  plane {y 0 texture {txt_soil}}
#end
