/*
// Persistence of Vision Ray Tracer Scene Description File
// File Name : spot light
// Version : 3.1g
// Description :  basic old movie soptlight 
// Date Started : 2-12-01
// Date Completed : 2-14-01 
// Author : Jason Scott
*/
/*=============================================== Includes ======================================*/
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "odd.inc" 
#include "effects.inc"
#include "glass.inc"

#version unofficial MegaPov 0.7;
                                     

/*=============================================== Camera's ======================================*/
#declare Cam1 = camera { location <0,-10,0> look_at <0,0,0> }          
#declare Cam2 = camera { location <0,2.5,-10> look_at <0,2.5,0> } 
#declare Cam3 = camera { location <10,5,0> look_at <0,0,0> }

camera { Cam2 }

/*=============================================== Light's =======================================*/
light_source { <1000,1000,-1500> color White media_attenuation off shadowless }
light_source { <-1000,1000,-1500> color White media_attenuation off shadowless }
light_source { <0,1000,-1500> color White media_attenuation off shadowless }

/*=============================================== Sky ===========================================*/
sphere {
        <0,0,0>,1 
        hollow 
        texture {
                pigment {
                        gradient <0,1,0>
                        color_map {
                                [0.0 color rgb<1,1,1> ]
                                [0.8 color rgb<0.1,0.6,0.9> ]
                                [1.0 color rgb<0.1,0.6,0.9> ]
                        }
                }
                finish { ambient 1 diffuse 0 } 
        }// end of texture
        scale 10000
}
/*=============================================== Plane =========================================*/  
plane {
        y, 0 
        pigment { 
                checker
                        color White
                        color Black
        }
        finish { reflection .25 }
        scale 5
}
/*=============================================== Pigments & Textures ===========================*/ 
#declare Odd = texture {
  pigment {
    leopard
    color_map {
      [0.00 rgbf<0.498,0.968,0.946,0.000>]
      [0.06 rgbf<0.565,0.741,0.273,0.000>]
      [0.13 rgbf<0.714,0.321,0.568,0.000>]
      [0.19 rgbf<0.193,0.812,0.992,0.017>]
      [0.25 rgbf<0.937,0.551,0.195,0.000>]
      [0.31 rgbf<0.270,0.952,0.794,0.000>]
      [0.38 rgbf<0.739,0.685,0.996,0.920>]
      [0.44 rgbf<0.016,0.971,0.929,0.902>]
      [0.50 rgbf<0.956,0.481,0.998,0.000>]
      [0.56 rgbf<0.140,0.996,0.970,0.000>]
      [0.63 rgbf<0.382,1.000,0.725,0.968>]
      [0.69 rgbf<0.507,0.631,0.790,0.942>]
      [0.75 rgbf<0.112,0.611,0.297,0.158>]
      [0.81 rgbf<0.758,0.877,0.252,0.000>]
      [0.88 rgbf<0.663,0.971,0.411,0.000>]
      [0.94 rgbf<0.854,0.966,0.498,0.000>]
      [1.00 rgbf<0.602,0.247,0.485,0.987>]
    }
  }
  finish {
    phong 0.821
    phong_size 23
    metallic 0.095
    brilliance 94.264
  }
}
   
#declare Metal =
        texture {
                pigment { color Gold }
                finish { reflection .25 }
        }   
        
media {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
  intervals 10
  scattering { 1, rgb 0.03 }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
  samples 1, 10                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
  confidence 0.9999                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
  variance 1/1000                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
  ratio 0.9                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       


/*=============================================== Objects =======================================*/

#declare Spotlight =
union {
//----------------------------------------------- start of main stand and handle
difference {       // light stand  base
        cylinder {
                <0,0,0><0,.125,0> 2.75
        }            
                
        cylinder {
                <0,-1,0><0,1,0> 2
        } 
        texture { Fantasy }
}                               

#declare Brace = // up pointing stand for the main shaft
union {
        box {    
                <-.125,0,-.25><.125,3,.25>
        }
        
        cylinder {
                <-.125,3,0><.125,3,0>.5
        }
        texture { Fantasy }
}


object { Brace translate <2.25,0,0> }  
object { Brace translate <-2.25,0,0> }   


cylinder {      // center pole
        <4,3,0><-2.25,3,0> .125
        texture { Metal }
}

#declare Handle = // bar for main shaft to connect to hand hold
union {
        box {
                <3.75,3,.25><3.5,1.5,-.25>
        }
        cylinder { 
                <3.75,3,0><3.5,3,0>.25
        }
        cylinder { 
                <3.75,1.5,0><3.5,1.5,0>.25
        }        
        texture { Asteroid }
}
object { Handle }

cylinder { // hand hold
        <3.25,1.5,0><5,1.5,0> .125
        texture { Metal }
}    

sphere { 
        <5,1.5,0> .25
        texture { Metal }
}                     

//----------------------------------------------- start or light body
#declare Light_Body =
union {
        #declare Base =
        union {
                cylinder {
                        <0,0,0><0,3,0>2
                }

                sphere { 
                        <0,0,0>2
                        scale <1,.5,1>
                }  
                texture { T_Chrome_1D }            
        }

        difference {
                object { Base }

                torus {
                        2,.125
                        translate <0,.5,0>
                }
                torus {
                        2,.125
                        translate <0,1.5,0>
                }
                torus {
                        2,.125
                        translate <0,2.5,0>
                }
                object { Base  scale <.85,1,.85> translate <0,.5,0> }  
                texture { T_Chrome_1D }
        } 
        difference {
                cylinder { 
                        <0,3,0><0,3.25> 2
                        texture { T_Blue_Glass }
                }        
                cylinder {
                        <0,0,0><0,5,0> 1.85 
                }
        }
        cylinder {
                <0,3,0><0,3.25,0>.5
                        texture { T_Blue_Glass }
        } 
        #declare N = 3;
        #declare C = 0;
        #while ( C < N )
                box { <.125,3.125,0><-.125,3.25,1.95> texture { T_Blue_Glass } rotate (360/N*C)*y }
                #declare C = C + 1;
        #end   
        
        #declare Intensity = 5;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
        light_source {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
                <0, 2.5, 0> color rgb<1, 1, 1> * Intensity                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
                cylinder                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
                point_at <0,10, 0>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
                radius 3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
                falloff 2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
                tightness 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
                media_attenuation on                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
        } 
}

object { Light_Body rotate <-45,0,0> translate <0,2.5,0> }

}

object { Spotlight rotate <0,45,0> }



