//********************************************************* Includes
#include "colors.inc"
#include "textures.inc"

//********************************************************** Fantasy   
#declare Fantasy =
        texture {
        pigment { 
                bozo
                pigment_map {
                        [ 0.0 marble 
                                color_map {
                                        [0.0 color rgb <0.0, 0.0, 0.0>]
                                        [1.0 color rgb <0.2, 0.0, 0.5>]
                                }
                                frequency 2.0
                                turbulence 1.0
                        ]
                        [ 0.3 marble
                                color_map {
                                        [0.0 color rgb <0.0, 0.0, 0.0>]
                                        [1.0 color rgb <0.0, 0.3, 0.2>]
                                }
                                frequency 2.0
                                turbulence 1.0
                        ]
                        [ 1.0 marble
                                color_map {
                                        [0.0 color rgb <0.0, 0.0, 0.0>]
                                        [1.0 color rgb <0.6, 0.1, 0.15>]
                                }
                        frequency 2.0
                        turbulence 1.0
                        ]
                }
        turbulence 0.5
        rotate <20, 59, 100>
        scale 0.1
        }
        finish {
                ambient 0.05
                diffuse 0.6
                reflection 0.05
                specular 0.4
                roughness 0.4
                metallic
        }
}


//********************************************************** Dying Star
#declare DyingStar = 
        texture {
                pigment {
                        bozo
                        color_map {
                                [0.0 color rgb <0.3, 0, 0>]
                                [1.0 color rgb <0.6, 0.2, 0>]
                        }
                        turbulence 0.3
                        scale 1/2
                }
        }
        texture {
                pigment {
                        agate
                        color_map {
                                [0.0 color rgbf <1, 1, 1, 1>]
                                [0.5 color rgbf <1, 1, 1, 1>]
                                [0.5 color rgbf <0.5, 0, 0, 1>]
                                [0.75 color rgb <0.5, 0, 0>]
                                [1.0 color rgb <1, 0.5, 0>]
                        }
                        turbulence 1.0
                        scale 1.5
                }
        }
        texture {
                pigment {
                        granite
                        color_map {
                                [0.0 color rgb <1, 1, 0>]
                                [0.2 color rgbf <1, 1, 1, 1>]
                                [1.0 color rgbf <1, 1, 1, 1>]
                        }
                }
        }

//********************************************************** Wack
#declare Wack_Map =
        color_map {
                [ 0.0, 0.8 color rgbft <0.1, 0.6, 0.1,0,1> color rgbft <0.0, 0.3, 0.0,.2,.25> ]
                [ 0.8, 1.0 color rgbft <0.1, 0.6, 0.1,.4,.75> color rgbft <0.0, 0.2, 0.0,.6,0> ]
        }

        #declare Wack =
                pigment {
                        marble
                        turbulence 1.8
                        color_map { Wack_Map }
                }

//********************************************************** Negativ 1
#declare Negativ1=
        texture { // Sun1
                pigment { 
                        bozo
                        turbulence -3
                        octaves 2
                        lambda 6
                        color_map { 
                                [0.0 0.2 color Firebrick color Firebrick]
                                [0.2 1.0 color Firebrick color Orange]
                        }
                }
                finish  { 
                        diffuse 1
                        ambient 0
                }
        }

//********************************************************** Negativ 2
#declare Negativ2=
  texture { // Haze
  pigment
  { agate
    agate_turb 0
    octaves -1
    omega -10
    lambda -5
    color_map
    { [0.0, 0.4 color Grey color DimGrey]
      [0.4, 0.5 color DimGrey color DimGrey]
      [0.5, 0.7 color DimGrey color Mica]
      [0.7, 1.0 color Mica color Grey]
     }
    rotate <15, 15, 0>
    }
    finish  { diffuse 1
            ambient 0
          }
          }

//********************************************************** Negativ 3 
#declare Negativ3=
  texture { // BlueHaze
  pigment
  { agate
    turbulence -3
    octaves 6
    omega .001
    lambda 1
    color_map
    { [0.0, 0.3 color NeonBlue color NewMidnightBlue]
      [0.3, 0.5 color NewMidnightBlue color NeonBlue]
      [0.5, 0.7 color NeonBlue color NewMidnightBlue]
      [0.7, 1.0 color NewMidnightBlue color NeonBlue]
    }
    scale <2, 2, 2> 
    }
  finish  { diffuse 1
            ambient 0
          }
          }

//********************************************************** Negativ 4 
#declare Negativ4=
  texture { // TheCloud
  pigment
  { bozo
    turbulence 1
    octaves 3
    //  omega .2
    lambda -10
    color_map
    { [0.0, 0.1 color Mica color Scarlet]
      [0.1, 0.9 color Scarlet color Mica]
      [0.9, 1.0 color Mica color Mica]
    }
    }
    finish  { diffuse 1
              ambient 0
          }
          }

//********************************************************** Negativ 5 
#declare Negativ5=
  texture { // DKGreenMarble
  pigment
  { marble
    turbulence -3
    octaves 3
    omega .2
    lambda -4
    color_map
    { [0.0, 0.7 color Mica color DkGreenCopper]
      [0.7, 1.0 color DkGreenCopper color Mica]
     }
    scale <2, 2, 2>
    }
    finish  { diffuse 1
            ambient 0
          }
    }

//********************************************************* Negativ 6
#declare Negativ6=
  texture { // Haze2
  pigment
  { agate
    agate_turb 0
    octaves -1
    omega 0
    lambda -5
    color_map
    { [0.0, 0.4 color MediumBlue color NeonBlue]
      [0.4, 0.5 color NeonBlue color MediumBlue]
      [0.5, 0.7 color MediumBlue color NewMidnightBlue]
      [0.7, 1.0 color NewMidnightBlue color MediumBlue]
    }
    }
    finish  { diffuse 1
            ambient 0
          }
          }

//********************************************************* Dirty Grass
#declare DirtyGrass =
        texture {
                pigment { 
                        granite
                        turbulence .5 
                        color_map {
                                [ 0 color MediumSeaGreen ]
                                [ .4 color LightWood ]
                                [ .5 color Feldspar ]
                                [ 1 color ForestGreen ]
                        }
                }
        finish { crand .8 }  
        }
        
