
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "wuerfel.inc"
#include "glass.inc"
#include "stones.inc"

camera
{
  location  <-1.0 , 38.0 ,-50.0>
  look_at   <0.0 , 4.0 , 0.0>
angle 55
 /* aperture 7               // 0...N (bigger is narrower depth of field)
  blur_samples 40             // # of rays per pixel
  focal_point <0,5,-3>       // x,y,z point that is in focus
  confidence 0.99
  variance 1/1280
*/
}

#default {texture{finish{ambient .7}}}

//#background{color White}
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color

  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <-10, 40, -20>   // <x y z> position of light

  //shadowless
}
light_source
{
  0*x // light's position (translated below)
  color Gray85
  translate <0, 1200, 40>

  shadowless
}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1.0 // distance from the origin in the direction of the surface normal

  //pigment{color Yellow}
  texture{T_Stone32 scale 0.5}
  translate y*1
}

/*difference{
           cone{<0,0,0>, 16 <0,50,0>,17}
           cone{<0,0.1,0>, 15.5 <0,50.1,0>,16.5}

           pigment
           {
               colour rgb<0.725,0.776,0.659>
           }
           normal
           {
           dents 0.31
           phase 0.47
           frequency 3
           scale <0.1, 0.1, 0.1>
           }
           finish {
                  specular 0.22    roughness 0.56
                  phong 0.07
                  reflection 0.04
                  }
}
*/

#declare USE_GLASS=on
object{wuerfel
       #declare COLOR=Red
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*90
       rotate y*24

       scale 10
       translate <0,5,-3>
       }

object{wuerfel
       #declare COLOR=Yellow
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*180
       rotate y*-54

       scale 10
       translate <-15,5,-6>
       }
object{wuerfel
       #declare COLOR=DarkGreen
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate z*180
       rotate y*-4

       scale 10
       translate <13,5,0>
       }
object{wuerfel
       #declare COLOR=LightBlue
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*90
       rotate z*180
       rotate y*-34

       scale 10
       translate <10,5,-15>
       }

object{wuerfel
       #declare COLOR=Brown
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*180
       rotate z*90
       rotate y*104

       scale 10
       translate <-6,5,-22>
       }

object{wuerfel
       #declare COLOR=Orange
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*0
       rotate z*90
       rotate y*29

       scale 10
       translate <25,5,-10>
       }

object{wuerfel
       #declare COLOR=SummerSky
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*0
       rotate z*90
       rotate y*-15

       scale 10
       translate <-23,5,-17>
       }


object{wuerfel
       #declare COLOR=SteelBlue
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*180
       rotate z*180
       rotate y*3

       scale 10
       translate <23,5,13>
       }

object{wuerfel
       #declare COLOR=Firebrick
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*270
       rotate z*0
       rotate y*2

       scale 10
       translate <15,5,24>
       }

object{wuerfel
       #declare COLOR=Violet
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end

       rotate x*270
       rotate z*270
       rotate y*-123

       scale 10
       translate <29,5,46>
       }

object{wuerfel
       #declare COLOR=Gray10
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end

       rotate x*270
       rotate z*270
       rotate y*-123

       scale 10
       translate <-31,5,6>
       }

object{wuerfel
       #declare COLOR=Pink
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*0
       rotate z*0
       rotate y*-11

       scale 10
       translate <-30,5,27>
       }

object{wuerfel
       #declare COLOR=LimeGreen
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*0
       rotate z*0
       rotate y*-45

       scale 10
       translate <1,5,38>
       }

object{wuerfel
       #declare COLOR=Gold
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*0
       rotate z*180
       rotate y*-67

       scale 10
       translate <40,5,35>
       }

object{wuerfel
       #declare COLOR=Khaki
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*90
       rotate z*270
       rotate y*17

       scale 10
       translate <-43,5,46>
       }

object{wuerfel
       #declare COLOR=MediumSeaGreen
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*180
       rotate z*180
       rotate y*-23

       scale 10
       translate <10,5,59>
       }

object{wuerfel
       #declare COLOR=SeaGreen
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end

       rotate x*90
       rotate z*90
       rotate y*53

       scale 10
       translate <-28,5,55>
       }

object{wuerfel
       #declare COLOR=Tan
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*90
       rotate z*0
       rotate y*3

       scale 10
       translate <-10,5,57>
       }

object{wuerfel
       #declare COLOR=NewMidnightBlue
       #ifndef (USE_GLASS)
               pigment{COLOR}
       #else
               texture{T_Ruby_Glass pigment{COLOR filter .9}}
       #end
       rotate x*180
       rotate z*0
       rotate y*13

       scale 10
       translate <-11,5,13>
       }
