/*
Geschrieben von KK
Das Thermometer 
Hhe           : 33.5;
Radius : Unten : max. 3.65;
         sonst : ca. 2.5;
GlasWandDicke  : ca. .1;
WasserHoehe    : 26;
Kapsel         : Hhe   : 5.2 (mit Gewicht) von -1.6 bis 3.6
                 Radius : 1.4
Problematik    : Grenze zwischen drei Elementen - ohne doppelte oberflchen...
                 daher Gedns
*/
               
#local TAArrayAnzahl = 44; //ThermoAuenArrayAnzahl
#local TAPArray = array[TAArrayAnzahl][2] //ThermoAuenPunkteArray  
 {
  {-.125, .15},
  {0, .05}, {.125, .15}, {.25, .25}, {.5, .25}, {1, .25}, {1.25, .2}, {1.5, .15} //7
  {2, .15}, {2.4, .14}, {2.5, .1}, {3, 0}, {3.5, .25},{3.65, .5}, {3.65, 1}, // 7
  {3.5, 1.35}, {3.2, 1.6}, {3, 1.65}, {2.65, 1.7}, // 4
  {2.5, 1.75}, {2.5, 2}, {2.5, 2.5}, {2.5, 3}, {2.5, 3.5}, {2.5, 10}, // 6
  
  {2.5, 20}, {2.5, 26}, {2.5, 27}, {2.5, 28}, {2.5, 28.5}, // 5
  {2.3, 29}, {2, 29.35}, {1.8, 29.5}, {1.5, 29.65}, {1.2, 30}, // 5
  {1, 30.25}, {0.8, 30.5}, {0.65, 31}, {0.55, 31.5}, {0.4, 32.5}, // 5
  {0.35, 33}, {0.3, 33.5}, {0, 33.7}, //3
  {-.3, 33.5}
 }
 
#local TAObject =
 lathe {
  cubic_spline
  TAArrayAnzahl
  #local C = 0;
  #while (C < TAArrayAnzahl)
   <TAPArray[C][0], TAPArray[C][1]>
   #local C = C + 1;
  #end
 }

#local TIArrayAnzahl = 44;
#local TIPArray = array[TIArrayAnzahl][2] //InnenPunkeArray
 {
  {-1.25, .25},
  {0, .15}, {.125, .25}, {.25, .35}, {.5, .35}, {1, .35}, {1.25, .3}, {1.5, .25} //7
  {2, .25}, {2.4, .24}, {2.5, .2}, {3, .1}, {3.45, .3}, {3.55, .5}, {3.55, 1}, // 7
  {3.44, 1.29}, {3.19, 1.51}, {2.99, 1.56}, {2.65, 1.6}, // 4
  {2.41, 1.66}, {2.4, 2}, {2.4, 2.5}, {2.4, 3}, {2.4, 3.5}, {2.4, 10}, // 6
  {2.4, 20}, {2.4, 26}, {2.4, 27}, {2.4, 28}, {2.4, 28.5}, // 5
  {2.24, 28.94}, {1.94, 29.29}, {1.77, 29.43}, {1.47, 29.53}, {1.17, 29.93}, // 5
  {0.94, 30.19}, {0.72, 30.48}, {0.57, 30.98}, {0.46, 31.49}, {0.31, 32.49}, // 5
  {0.26, 32.99}, {0.24, 33.44}, {0, 33.6}, //3
  {-.24, 33.44}
 }
#local TIObject =
 lathe {
  cubic_spline
  TIArrayAnzahl
  #local C = 0;
  #while (C < TIArrayAnzahl)
   <TIPArray[C][0], TIPArray[C][1]>
   #local C = C + 1;
  #end
 }

#local LuftMat =
 material {
  texture {pigment {rgbf 1}}
  interior {
   ior 1
   fade_power 2
   fade_distance 40000
  }
 }

#local WasserMat =
 material {
  texture {pigment {rgbf 1}}
  interior {
   ior 1.33
   caustics 1.33
   fade_power 1
   fade_distance 400 //300
  }
 }

#local GlasMat = 
 material {
  #ifdef (TestRender)
   texture {
    pigment {color rgb 1}
    finish {phong 1 phong_size 200}
   }
  #else
  texture {
   pigment {color rgb 1 filter 1}
   finish {
    phong 1
    phong_size 200
   }
  }
  interior {
   ior 1.5
   caustics 1.5
   fade_power 1
   fade_distance 10
  }
  #end
 }
 
#local ThermoLuftWasserKomplex =
 difference {
  union {
   box {<-3.6, -1, -3.6>, <3.6, 40, 3.6> material {WasserMat} }
   cylinder { <0,26,0>, <0,40.1,0>, 4    material {LuftMat} }
  }
  difference {
   box {<-15, -10,-15>, <15, 50, 15>}
   union {
    difference {
     object {TIObject}
     box { <-10, 26, -10>, <10, 40.2, 10>}
     material {WasserMat}
    }
    difference {
     object {TIObject}
     box { <-10, 26, -10>, <10, -5, 10>}
     material {LuftMat}
    }
   }
  }
 }

#local ThermometerGlas = 
 object {TAObject material {GlasMat} }

#local TKAArrayAnzahl = 13; //ThermoKapselAuenArrayAnzahl
#local TKAPArray = array[TKAArrayAnzahl][2] //ThermoKapselAuenPunkteArray
 {
  {-.25, .2},
  {0,0}, {.25, .2}, {.35, .75}, {.8, .825}, {1, .9},
  {1.5, 1.3}, {1.75, 2.25}, {1.35, 3}, {0.45, 3.5}, 
  {.2, 4.35}, {0, 4.5},
  {-.2, 4.35}
 }
#local TKAObject =
 lathe {
  cubic_spline
  TKAArrayAnzahl
  #local C = 0; 
  #while (C < TKAArrayAnzahl)
   <TKAPArray[C][0], TKAPArray[C][1]>
   #local C = C + 1;
  #end
 }
  
#local TKIArrayAnzahl = 11; //ThermoKapselInnenArrayAnzahl
#local TKIPArray = array[TKIArrayAnzahl][2] //ThermoKapselInnenPunkteArray
 {
  {-.5, .94},
  {0, .9}, {.5, .94}, {.91, .99},
  {1.43, 1.37}, {1.65, 2.25}, {1.275, 2.925}, {0.375, 3.425}, 
  {.14, 4.24}, {0, 4.4},
  {-.14, 4.24}
 }
#local TKIObject =
 lathe {
  cubic_spline
  TKIArrayAnzahl
  #local C = 0; 
  #while (C < TKIArrayAnzahl)
   <TKIPArray[C][0], TKIPArray[C][1]>
   #local C = C + 1;
  #end
 }
 
#macro Kapsel (WasserFarbe, Temperatur)
 #local KapselWasserMat =
  material { 
   texture {
    pigment {color WasserFarbe}
    finish {
     phong 1
     phong_size 300
    }
   }
   interior {
    ior 1.33
    caustics 1.33
    fade_power 1
    fade_distance 400 //300
   }
  }         
 union {
  //ThermometerKapselmassivGlas
  object {TKAObject material {GlasMat}}
  //ThermometerKapselLuftWasserKomplex
  difference {
   union {
    box {<-2, -1, -2>, <2, 2, 2>     material {KapselWasserMat}}
    cylinder { <0,2,0>, <0,5,0>, 2.1 material {LuftMat}}
   } 
   difference {
    box {<-4, -4, -4>, <4, 8, 4>}
    union {
     difference {
      object {TKIObject}
      box { <-3, 2, -3>, <3, 7, 3>}
      material {KapselWasserMat}
     }
     difference {
      object {TKIObject}
      box { <-3, -3, -3>, <3, 2, 3>}
      material {LuftMat}
     }
    }
   }
  }
 
  //der Ring unter der Kapsel
  torus {0.45, .045
   texture {
    pigment {color rgb <.8,.8,.9>}
    finish {
     reflection .9
     ambient .05
     phong 1
     phong_size 600
     metallic
    }
   }
   rotate x*90
   translate y * -.05
  }
  //das Gewicht mit der Temperaturinschrift
  difference {
   cylinder {<-.1, -1.2, 0>, <.1, -1.2, 0> .8}

   #local Abschnitt =
    union {
     torus {.58, .04
      rotate z*90
      translate <-.1, -1.2, 0>
     }
     union {
      text {ttf "arial.ttf", Temperatur, .1/0.65,0}
      difference {  // der Gradkringel
       cylinder {<1.17, .75,   0>, <1.17, .75, .1/0.65>    .175}
       cylinder {<1.17, .75, -.1>, <1.17, .75, .1/0.65+.2> .095}
      }
      rotate y*90
      scale .65
      translate <-.15, -1.46, .45>
     }
    }
     
   cylinder {<-.2, -.55,0>, <.2, -.55, 0> .1}
   object {Abschnitt}
   object {Abschnitt rotate y*180}
   texture {
    pigment {color rgb <.9,.9,.95>}
    normal {
     bumps .01
     scale .001
    }
    finish {
     reflection .4
     phong 1
     phong_size 50
     metallic
     ambient .3
    }
   }    
  }        
  scale .8  //weil die wohl zu gro waren. (Die Kapseln)
 }
#end  //vom Kapsel-macro

//Die Farben der TkermoKapsel"wsserchen"
#local TKWF1 = color rgbf <1.00, 0.70, 0.20, 0.90>; // orange
#local TKWF2 = color rgbf <0.20, 0.20, 0.80, 0.80>; // blau
#local TKWF3 = color rgbf <1.00, 0.20, 0.20, 0.85>; // rot
#local TKWF4 = color rgbf <0.05, 0.70, 0.40, 0.80>; // grn
#local TKWF5 = color rgbf <0.10, 0.10, 0.10, 0.00>; // schwarz

#local ThermoKapsel1 =
 object {
  Kapsel (TKWF1, "18")
  translate <1,2,0>
 }
#local ThermoKapsel2 =
 object {
  Kapsel (TKWF2, "20") 
  translate <-1,5.5,0>
 }
#local ThermoKapsel3 =
 object {
  Kapsel (TKWF3, "22")
  translate <0,10.5,1>
 }
#local ThermoKapsel4 =
 object {
  Kapsel (TKWF4, "24")
  translate <0,14,-1>
 }
#local ThermoKapsel5 =
 object {
  Kapsel (TKWF5, "26")
  translate y * 22.42 //0.2 mm ber der Oberflche ist die Spitze der Kapsel.
 }
  


#local DasGanzeThermometer =
 union {
  object {ThermometerGlas}
  object {ThermoLuftWasserKomplex}

  object {ThermoKapsel1}
  object {ThermoKapsel2}
  object {ThermoKapsel3}
  object {ThermoKapsel4}
  object {ThermoKapsel5}
  pigment {color rgb 1}//Alibi-Pigment, da sonst lauter Meldungen reinflattern.
 }  
                    
object {DasGanzeThermometer}