// Der kleien Tisch im Wohnzimmer, abstrakt
// Letzte nderung : 2.4.99

#local SeedTransR  = seed(1201); 
#local SeedRotateR = seed(2312);
#local SeedScaleR  = seed(3423);
#macro TextureMover (ZielTexture)
  #declare ZielTexture = texture {ZielTexture
    translate <-1 + rand(SeedTransR) * 2,
               -1 + rand(SeedTransR) * 2,
               -1 + rand(SeedTransR) * 2>
    rotate <-10 + rand(SeedRotateR)*20 ,
            -10 + rand(SeedRotateR)*20 ,
            -10 + rand(SeedRotateR)*20 >
    scale 0.8 + rand (SeedScaleR) * 0.4
  }
#end     


#local HolzTex =
 texture {
  pigment {
   wood
   turbulence 0.05
   color_map {
    [0.0 color rgb <.85,  .775, .3> ]
    [0.7 color rgb <.65, .6, .2> ]
    [0.8 color rgb <.75,  .65,  0> ]
    [1.0 color rgb <.6,  .55, .1> ]
   }
   scale 3
   rotate y*10
   translate y * 46.25 
   translate x*100
   warp {repeat x*80/16 offset y*4.5}
  }  
  finish {
//      reflection .05
   phong .5
   phong_size 200
  }
 }        

#local TPTex = array[16]
#declare Counter = 0;

#while (Counter < 16)
  #declare TPTex[Counter] = texture {HolzTex scale 2}
  TextureMover (TPTex[Counter])
  #declare TPTex[Counter] = 
    texture {
      TPTex[Counter]
      translate y * 46.25 
      translate x * (5 * (8 - Counter) - 2.5) 
      scale 1/80
    } 
  #declare Counter = Counter + 1;
#end

#declare Tischplatte =
  union {
    #local TAR = 0.5; //TischAbplattungsRadius
    #local THM = 40;  //TischHalbMesser
    #local TD = 2.5;  //TischDicke
    #local TH = 45;   //TischHhe
    
    #local POHR = < THM-TAR, TH+TD-TAR,  THM-TAR>;
    #local POHL = <-THM+TAR, TH+TD-TAR,  THM-TAR>;
    #local POVR = < THM-TAR, TH+TD-TAR, -THM+TAR>;
    #local POVL = <-THM+TAR, TH+TD-TAR, -THM+TAR>;
         
    #local PUHR = < THM-TAR, TH+TAR,  THM-TAR>;
    #local PUHL = <-THM+TAR, TH+TAR,  THM-TAR>;
    #local PUVR = < THM-TAR, TH+TAR, -THM+TAR>;
    #local PUVL = <-THM+TAR, TH+TAR, -THM+TAR>;
    
    sphere {POHR, TAR}
    sphere {POHL, TAR}
    sphere {POVR, TAR}
    sphere {POVL, TAR}

    sphere {PUHR, TAR}
    sphere {PUHL, TAR}
    sphere {PUVR, TAR}
    sphere {PUVL, TAR}
    
    cylinder {POHL, POHR, TAR}
    cylinder {POHL, POVL, TAR}
    cylinder {POVR, POHR, TAR}
    cylinder {POVR, POVL, TAR}
    
    cylinder {PUHL, PUHR, TAR}
    cylinder {PUHL, PUVL, TAR}
    cylinder {PUVR, PUHR, TAR}
    cylinder {PUVR, PUVL, TAR}

    cylinder {POHR, PUHR, TAR}
    cylinder {POHL, PUHL, TAR}
    cylinder {POVR, PUVR, TAR}
    cylinder {POVL, PUVL, TAR}
    
    box {POHR+<TAR,0,0>, PUVL-<TAR,0,0>}
    box {POHR+<0,TAR,0>, PUVL-<0,TAR,0>}
    box {POHR+<0,0,TAR>, PUVL-<0,0,TAR>}
    
    texture {HolzTex}
/*      gradient x
      texture_map {
        [0 /16 TPTex[0 ]] [1 /16 TPTex[0 ]]
        [1 /16 TPTex[1 ]] [2 /16 TPTex[1 ]]
        [2 /16 TPTex[2 ]] [3 /16 TPTex[2 ]]
        [3 /16 TPTex[3 ]] [4 /16 TPTex[3 ]]
        [4 /16 TPTex[4 ]] [5 /16 TPTex[4 ]]
        [5 /16 TPTex[5 ]] [6 /16 TPTex[5 ]]
        [6 /16 TPTex[6 ]] [7 /16 TPTex[6 ]]
        [7 /16 TPTex[7 ]] [8 /16 TPTex[7 ]]
        [8 /16 TPTex[8 ]] [9 /16 TPTex[8 ]]
        [9 /16 TPTex[9 ]] [10/16 TPTex[9 ]]
        [10/16 TPTex[10]] [11/16 TPTex[10]]
        [11/16 TPTex[11]] [12/16 TPTex[11]]
        [12/16 TPTex[12]] [13/16 TPTex[12]]
        [13/16 TPTex[13]] [14/16 TPTex[13]]
        [14/16 TPTex[14]] [15/16 TPTex[14]]
        [15/16 TPTex[15]] [16/16 TPTex[15]]
      }  
      scale 80
      translate x * 40
    }*/
  }    

#declare TischBein =
  union {
    #local BH = 45;   //BeinHhe
    #local BHM = 2.5; //BeinHalbMesser
    #local BAR = 1;   //Bein AbplattungsRadius
    
    #local POHR = < BHM-BAR, BH,  BHM-BAR>;
    #local POHL = <-BHM+BAR, BH,  BHM-BAR>;
    #local POVR = < BHM-BAR, BH, -BHM+BAR>;
    #local POVL = <-BHM+BAR, BH, -BHM+BAR>;
         
    #local PUHR = < BHM-BAR, 0,  BHM-BAR>;
    #local PUHL = <-BHM+BAR, 0,  BHM-BAR>;
    #local PUVR = < BHM-BAR, 0, -BHM+BAR>;
    #local PUVL = <-BHM+BAR, 0, -BHM+BAR>;
    
    cylinder {POHR, PUHR, BAR}
    cylinder {POHL, PUHL, BAR}
    cylinder {POVR, PUVR, BAR}
    cylinder {POVL, PUVL, BAR}
    
    box {POHR+<BAR,0,0>, PUVL-<BAR,0,0>}
    box {POHR+<0,0,BAR>, PUVL-<0,0,BAR>}
    
    texture {
      HolzTex
      rotate x * 90
    }
  }    
#declare TischBeine = 
  union {
    #declare TBMA = 36.5; //TischBeinMittelPunktAbstand
    object {TischBein
      translate <TBMA, 0, TBMA>
    }
    object {TischBein
      translate <-TBMA, 0, TBMA>
    }
    object {TischBein
      translate <TBMA, 0, -TBMA>
    }
    object {TischBein
      translate <-TBMA, 0, -TBMA>
    }
  }
  
#declare TischSeiten =
  union {
    #local TSH = 39;  //TischSeitenHhe
    #local TSD = 6;   //TischSeitenDicke
    #local TSB = 1.5; //TischSeitenBreite
    #local TSL = 68;  //TischSeitenLge
    #local TSA = 37;  //TischSeienAbstand (zum Mittelpunkt)
    
    box {
      <TSL/2, TSH, TSA>, <-TSL/2, TSH + TSD, TSA + TSB>
      texture {
        HolzTex
        rotate y * 90
        translate <0, TSH + TSD /2, TSA + TSB/2>
      }
    }
    box {
      <TSL/2, TSH, -TSA>, <-TSL/2, TSH + TSD, -(TSA + TSB)>
      texture {
        HolzTex
        rotate y * 90
        translate <0, TSH + TSD /2, -(TSA + TSB/2)>
      }
    }

    box {
      <TSA, TSH, TSL/2>, <TSA + TSB, TSH + TSD, -TSL / 2>
      texture {
        HolzTex
        translate <TSA + TSB / 2, TSH + TSD /2, 0>
      }
    }
    box {
      <-TSA, TSH, TSL/2>, <-(TSA + TSB), TSH + TSD, -TSL / 2>
      texture {
        HolzTex
        translate <-(TSA + TSB / 2), TSH + TSD /2, 0>
      }
    }
  }      

union { 
 object {Tischplatte}
 object {TischBeine}
 object {TischSeiten}
}
    