// Copyright (C) 2003
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


// ========================================
//  Notes
// ========================================
// Author: Rune S. Johansen
//
// From: povray.binaries.scene-files
// Subject: FurTex
// Date: 26 Apr 2000 11:50:48 EDT

// ========================================
//  FurTex macro
// ========================================
#macro FurTex(Color)
  texture {
    average
    texture_map {
      [
        pigment {
          bozo
          color_map {[0,color Color*0.9][1,color Color*1.1]}
          scale 0.001
        }
        normal {
          average
          normal_map {
            [
              bumps 0.3*2
              warp {turbulence 1}
              scale 0.2
            ]
            [
              bumps 0.2*2
              warp {turbulence 0.5}
              scale 0.001
            ]
          }
        }
        finish {ambient 0.1*2 diffuse 0.6*2 brilliance 0.6}
      ]
      [
        pigment {color -Color}
        finish {ambient 0 diffuse 0 phong 0.5*2 phong_size 2 metallic}
      ]
    }
  }
#end

// ========================================
//  The ball
// ========================================
sphere {
  0,1
  ball_at (3,3)
  #if (radiosity_stage = 1)
    pigment {rgb <.85, .85, 1>}
  #else
    FurTex (color <.85,.85,1>)
  #end
}



