// Copyright (C) 2003
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


// ========================================
//  Notes
// ========================================
// From: Tor Olav Kristensen
// Subject: "72 Antiblobs" source code
// Date: 23 Aug 2000 14:35:29 EDT

// ========================================
//  The ball
// ========================================


// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7
// First the macro that generates all the blobs

#macro AntiBlobs(CtrArray, RadArray, StrArray, Trh, BlbArray)

  #local NrOfBlobs = dimension_size(CtrArray, 1);
  #local CntA = 0;
  #while (CntA < NrOfBlobs)
    #local CtrA = CtrArray[CntA];
    #local RadA = RadArray[CntA];
    #local StrA = StrArray[CntA];
    #declare BlbArray[CntA] =
      blob {
        threshold Trh
        sphere {
          CtrA, RadA
          strength StrA
        }
        #local CntB = 0;
        #while (CntB < NrOfBlobs)
          #if (CntA != CntB)
            #local CtrB = CtrArray[CntB];
            #local RadB = RadArray[CntB];
            #local Dist = vlength(CtrB - CtrA);
            #if (Dist < RadA + RadB)
              #local PowA = pow(1 - pow(Dist/2/RadA, 2), 2);
              #local PowB = pow(1 - pow(Dist/2/RadB, 2), 2);
              #local NStrB = (Trh - StrA*PowA)/PowB;
              sphere {
                CtrB, RadB
                strength NStrB
              }
            #end // if
          #end // if
          #local CntB = CntB + 1;
        #end // while
      }
    #local CntA = CntA + 1;
  #end // while

#end // macro AntiBlobs


// Then a macro that returns the passed object tilted in
// the direction of a vector

#macro Tilt(Thing, Vector)

  #local xAngle = (Vector.z < 0 ? -1 : 1)*
                  degrees(acos(vnormalize((x + z)*Vector).x));
  #local yAngle = degrees(acos(vnormalize(Vector).y));

  object {
    Thing
    rotate  xAngle*y
    rotate -yAngle*z
    rotate -xAngle*y
  }

#end // macro Tilt

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7
// Code to find the coordinates for the centers of all the 92 "anti-
// blobs" (60 + 12 + 20 = 92)


// Co-ordinates for a Buckminsterfullerene

#declare NrOfBuckyPts = 60;

#declare BuckyArray =
array[NrOfBuckyPts] {
  < 2.226730,  0.594920,  2.684200>,
  < 3.134080,  0.161810,  1.635440>,
  < 3.250250,  1.240130,  0.668290>,
  < 2.414560,  2.339640,  1.119120>,
  < 1.782170,  1.940950,  2.364960>,
  < 1.342130, -0.311850,  3.256820>,
  <-0.027000,  0.086540,  3.535890>,
  <-0.890470, -1.048410,  3.257750>,
  <-0.054970, -2.148180,  2.806770>,
  < 1.324810, -1.692910,  2.806120>,
  < 3.117650, -1.159560,  1.204400>,
  < 2.193000, -2.107290,  1.802560>,
  < 1.720910, -2.995760,  0.754440>,
  < 2.353890, -2.597090, -0.491290>,
  < 3.216930, -1.462050, -0.213260>,
  < 3.345290,  0.950710, -0.688050>,
  < 3.328380, -0.430390, -1.138540>,
  < 2.581820, -0.487170, -2.383660>,
  < 2.137050,  0.858790, -2.702690>,
  < 2.608990,  1.747420, -1.654660>,
  < 1.709970,  3.101980,  0.194250>,
  < 1.809270,  2.799410, -1.223290>,
  < 0.501490,  3.010120, -1.820490>,
  <-0.406030,  3.443130, -0.771880>,
  < 0.340880,  3.499990,  0.473170>,
  < 0.472290,  2.321910,  2.631870>,
  <-0.264220,  3.118480,  1.665080>,
  <-1.643750,  2.662990,  1.665550>,
  <-1.759930,  1.585190,  2.632880>,
  <-0.452190,  1.374270,  3.230230>,

  <-2.230680, -0.584280, -2.701320>,
  <-3.138380, -0.151090, -1.652660>,
  <-3.254550, -1.228980, -0.685460>,
  <-2.418840, -2.328500, -1.136370>,
  <-1.785970, -1.930080, -2.382100>,
  <-1.346280,  0.322850, -3.273640>,
  < 0.023000, -0.074940, -3.552420>,
  < 0.885930,  1.060390, -3.274220>,
  < 0.049970,  2.159870, -2.823390>,
  <-1.329630,  1.704060, -2.823020>,
  <-3.122300,  1.170370, -1.221530>,
  <-2.197990,  2.118350, -1.819620>,
  <-1.725990,  3.007160, -0.771470>,
  <-2.358450,  2.608490,  0.474240>,
  <-3.221550,  1.473440,  0.196030>,
  <-3.349590, -0.938890,  0.670910>,
  <-3.332630,  0.442150,  1.121470>,
  <-2.585870,  0.499300,  2.366750>,
  <-2.141500, -0.846500,  2.686090>,
  <-2.613600, -1.735240,  1.637920>,
  <-1.714530, -3.090350, -0.211190>,
  <-1.814140, -2.787320,  1.206480>,
  <-0.506670, -2.998220,  1.803800>,
  < 0.400930, -3.431500,  0.755070>,
  <-0.345460, -3.488360, -0.490180>,
  <-0.475910, -2.310710, -2.648970>,
  < 0.260190, -3.107130, -1.682110>,
  < 1.639710, -2.651480, -1.682710>,
  < 1.756120, -1.573340, -2.649740>,
  < 0.448510, -1.362650, -3.246970>
}


// Code that are not needed for this scene.
// This array contains information about how to select pairs
// of points in the BuckyArray that are to be used as endpoints
// in e.g. cylinders so that they ties the pentagons together.
/*
#declare OtherLines =
array[30][2] {
  { 00, 05 }, { 01, 10 }, { 02, 15 }, { 03, 20 }, { 04, 25 },
  { 09, 11 }, { 14, 16 }, { 19, 21 }, { 24, 26 }, { 29, 06 },
  { 35, 30 }, { 40, 31 }, { 45, 32 }, { 50, 33 }, { 55, 34 },
  { 39, 41 }, { 44, 46 }, { 49, 51 }, { 54, 56 }, { 59, 36 },
  { 07, 48 }, { 12, 53 }, { 17, 58 }, { 22, 38 }, { 27, 43 },
  { 08, 52 }, { 13, 57 }, { 18, 37 }, { 23, 42 }, { 28, 47 }
}
*/


// If you like to make the hexagons in a "Buckyball" instead of
// pentagons, then you need this information.
// Just use the array below to look up which pair of points in the
// BuckyArray to use for the cylinders.
// Note that if you render all of them, then some of the cylinders
// will "double"

#declare Hexagons =
array [20][6][2] {
  { { 00,05 }, { 05,09 }, { 09,11 }, { 11,10 }, { 10,01 }, { 01,00 } },
  { { 01,10 }, { 10,14 }, { 14,16 }, { 16,15 }, { 15,02 }, { 02,01 } },
  { { 02,15 }, { 15,19 }, { 19,21 }, { 21,20 }, { 20,03 }, { 03,02 } },
  { { 03,20 }, { 20,24 }, { 24,26 }, { 26,25 }, { 25,04 }, { 04,03 } },
  { { 04,25 }, { 25,29 }, { 29,06 }, { 06,05 }, { 05,00 }, { 00,04 } },

  { { 09,08 }, { 08,52 }, { 52,53 }, { 53,12 }, { 12,11 }, { 11,09 } },
  { { 14,13 }, { 13,57 }, { 57,58 }, { 58,17 }, { 17,16 }, { 16,14 } },
  { { 19,18 }, { 18,37 }, { 37,38 }, { 38,22 }, { 22,21 }, { 21,19 } },
  { { 24,23 }, { 23,42 }, { 42,43 }, { 43,27 }, { 27,26 }, { 26,24 } },
  { { 29,28 }, { 28,47 }, { 47,48 }, { 48,07 }, { 07,06 }, { 06,29 } },

  { { 30,35 }, { 35,39 }, { 39,41 }, { 41,40 }, { 40,31 }, { 31,30 } },
  { { 31,40 }, { 40,44 }, { 44,46 }, { 46,45 }, { 45,32 }, { 32,31 } },
  { { 32,45 }, { 45,49 }, { 49,51 }, { 51,50 }, { 50,33 }, { 33,32 } },
  { { 33,50 }, { 50,54 }, { 54,56 }, { 56,55 }, { 55,34 }, { 34,33 } },
  { { 34,55 }, { 55,59 }, { 59,36 }, { 36,35 }, { 35,30 }, { 30,34 } },

  { { 39,38 }, { 38,22 }, { 22,23 }, { 23,42 }, { 42,41 }, { 41,39 } },
  { { 44,43 }, { 43,27 }, { 27,28 }, { 28,47 }, { 47,46 }, { 46,44 } },
  { { 49,48 }, { 48,07 }, { 07,08 }, { 08,52 }, { 52,51 }, { 51,49 } },
  { { 54,53 }, { 53,12 }, { 12,13 }, { 13,57 }, { 57,56 }, { 56,54 } },
  { { 59,58 }, { 58,17 }, { 17,18 }, { 18,37 }, { 37,36 }, { 36,59 } }
}


// Find and store the points in the middle of each of the pentagons

#declare NrOfPents = 12; // Number of pentagons
#declare PentagonMids = array[NrOfPents]

#declare Counter = 0;

#while (Counter < NrOfPents)
  #declare Cnt = Counter*5;
  #declare PentagonMids[Counter] =
    (BuckyArray[Cnt + 00] +
     BuckyArray[Cnt + 01] +
     BuckyArray[Cnt + 02] +
     BuckyArray[Cnt + 03] +
     BuckyArray[Cnt + 04])/5;
  #declare Counter = Counter + 1;
#end // while


// Find and store the points in middle of each of the hexagons

#declare NrOfHexs = 20; // Number of hexagons
#declare HexagonMids = array[NrOfHexs]

#declare Counter = 0;
#while (Counter < NrOfHexs)
  #declare HexagonMids[Counter] =
    (BuckyArray[Hexagons[Counter][0][0]] +
     BuckyArray[Hexagons[Counter][1][0]] +
     BuckyArray[Hexagons[Counter][2][0]] +
     BuckyArray[Hexagons[Counter][3][0]] +
     BuckyArray[Hexagons[Counter][4][0]] +
     BuckyArray[Hexagons[Counter][5][0]])/6;
  #declare Counter = Counter + 1;
#end // while


// Now copy all these point into a new matrix: BallArray

#declare vNr = NrOfBuckyPts + NrOfPents + NrOfHexs;
#declare BallArray = array[vNr]

#declare Counter = 0;
#while (Counter < NrOfBuckyPts)
  #declare BallArray[Counter] =
    BuckyArray[Counter];
  #declare Counter = Counter + 1;
#end // while

#declare Counter = 0;
#while (Counter < NrOfPents)
  #declare BallArray[NrOfBuckyPts + Counter] =
    PentagonMids[Counter];
  #declare Counter = Counter + 1;
#end // while

#declare Counter = 0;
#while (Counter < NrOfHexs)
  #declare BallArray[NrOfBuckyPts + NrOfPents + Counter] =
    HexagonMids[Counter];
  #declare Counter = Counter + 1;
#end // while


// Then make the length of all of the vectors in BallArray equal to 3

#declare Counter = 0;
#while (Counter < vNr)
  #declare BallArray[Counter] = vnormalize(BallArray[Counter])*3;
  #declare Counter = Counter + 1;
#end // while

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7
// Prepare some arrays to hold intial information about each "antiblob"
// (Center, Radii and Strength arrays)

#declare CenterArray = array[vNr]
#declare RadiusArray = array[vNr]
#declare StrengthArray = array[vNr]


// Fill the arrays

#declare CenterArray = BallArray


#declare PtCnt = 0;
#while (PtCnt < vNr)
  #declare RadiusArray[PtCnt] = 0.95; // Experiment with this value
  #declare PtCnt = PtCnt + 1;
#end // while


#declare PtCnt = 0;
#while (PtCnt < vNr)
  #declare StrengthArray[PtCnt] = 1; // Experiment with this value
  #declare PtCnt = PtCnt + 1;
#end // while


// Define the threshold for all the "antiblobs"
// This value will control how "intimate" their "kissing" will be

#declare Threshold = 0.03; // Experiment with this value


// Generate the antiblobs

#declare BlobArray = array[vNr]

AntiBlobs(CenterArray, RadiusArray, StrengthArray, Threshold, BlobArray)



// Code for "Exploding" the resulting ball a little bit
/*
#declare PtCnt = 0;
#while (PtCnt < vNr)
  #declare BlobArray[PtCnt] =
    object {
      BlobArray[PtCnt]
      translate BallArray[PtCnt]*0.4
    }
  #declare PtCnt = PtCnt + 1;
#end // while
*/

// And then let all the "antiblobs" loose
#include "colors.inc"
#include "stones.inc"
#declare PtCnt = 0;
union {
  #while (PtCnt < vNr)
    object {
      BlobArray[PtCnt]
      #if (radiosity_stage = 1)
        pigment {rgb 1}
      #else
        texture {T_Stone13}
      #end
    }
    #declare PtCnt = PtCnt + 1;
  #end // while
  scale .25
  ball_at (2,2)
}



// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7
// Sample code to make 8 simpler "antiblobs"
// This code only needs the AntiBlobs macro above.
// (So to render this you may delete all the other code between the
// Tilt macro and these lines.)

/*

#declare NrOfBlobs = 8;

#declare CenterArray =
array[NrOfBlobs] {
  < 1, -1,  1>/2,
  <-1, -1,  1>/2,
  <-1, -1, -1>/2,
  < 1, -1, -1>/2,
  < 1,  1,  1>/2,
  <-1,  1,  1>/2,
  <-1,  1, -1>/2,
  < 1,  1, -1>/2,
}

#declare RadiusArray =
array[NrOfBlobs] {
  1.0,
  1.0,
  1.0,
  1.0,
  1.0,
  1.0,
  1.0,
  1.0
}

#declare StrengthArray =
array[NrOfBlobs] {
  1.0,
  1.0,
  1.0,
  1.0,
  1.0,
  1.0,
  1.0,
  1.0
}

#declare Threshold = 0.04; // Also try 0.001 and 0.12 here

#declare BlobArray = array[NrOfBlobs]

AntiBlobs(CenterArray, RadiusArray, StrengthArray, Threshold, BlobArray)

#declare SomeCells =
union {
  #declare PtCnt = 0;
  #while (PtCnt < NrOfBlobs)
    object { BlobArray[PtCnt] texture { T_Stone23 } }
    #declare PtCnt = PtCnt + 1;
  #end // while
}

object {
  SomeCells
  translate <0, 0, -8>
}

//light_source { -100*z color White }

*/
