// Copyright (C) 2003
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// ========================================
//  Notes
// ========================================
//  Author: 
//
//  Even distribution of points on a sphere (golf ball)
//  Non even distribution of balls in a cube using megapov and mechanic simulation

// ========================================
//  Ball
// ========================================


#include "shapes.inc"
#include "golfball.dat"
#declare n = 492;
#local i= 0;
#if (radiosity_stage = 1)
  #declare ball = 
    sphere {
      0,.5 
      pigment {rgb .85}
    }
#else
  #declare ball = difference {
    sphere {0,1}
    #while (i<n)
      sphere {
	0,.065
	Axial_Scale_Trans (pos[i], .4)
	translate pos[i]
      }
      #local i=i+1;
    #end
    scale .5
    pigment {rgb .85}
    finish {specular .4 roughness 0.005 reflection{0.05,0.01} ambient 0 diffuse 1}
  }
#end

#declare pos = array[13] {
  <0.904653363257, 0.933586701493, 0.354085637794>,
  <-0.963489550821, -0.987332753387, 0.217587169295>,
  <0.939143141310, -0.973789596611, 0.343276716535>,
  <-0.749109002313, -0.050903950650, 0.352954648608>,
  <-0.014657164540, -0.760986508449, 0.312317899187>,
  <-0.928955098753, 0.918174221340, 0.329932998369>,
  <0.742214564025, -0.032468140623, 0.321104969984>,
  <-0.010555555979, 0.601996671939, 0.260815597734>,
  <0.010943518191, -0.060768202579, 0.996646142602>,
  <-0.825909681603, 0.444393584421, 1.196759708318>,
  <0.868444792147, 0.396346913060, 1.192886141798>,
  <0.036965310685, 0.910977500262, 1.186438505146>,
  <-0.599599118938, -0.833263064942, 1.115294919227>
}

#local i = 0;
union {
  #while (i<13)
    object {
      ball
      translate x*pos[i].x
      translate y*pos[i].z+0.217587169295*y
      translate z*pos[i].y
    }
    #local i=i+1;
  #end
  rotate y*90
  scale.85
  ball_at (0,2)
  translate -1.05*y
  translate z*.3  
}



