camera {
	location <0, 4, -15>    
    look_at 0
}   

light_source {
	<30, 20, -50>
	color rgb 1.3
}
background{rgb 0.8}                

#local Pgm1 = pigment{color rgb<1, 0.6, 0.4>}
#local Pgm2 = pigment{
	//granite 
	cells
	color_map{
		[0.0 0.2 color rgb<1, 0.6, 0.4> color rgb<0.8, 0.4, 0.2>]
		[0.2 0.4 color rgb<1, 0.7, 0.5> color rgb<1, 0.5, 0.3>]
		[0.4 0.8 color rgb<0.9, 0.6, 0.4> color rgb<0.8, 0.4, 0.3>]
		[0.8 1.0 color rgb<1, 0.65, 0.45> color rgb<0.95, 0.55, 0.35>]
	}	
};

/*

Creates single tile
n - number of faces. Big number makes smooth surface
maxR - maximim radius
minR - minimum radius
depth - length in z direction
base - make flat tile's base 

*/
#macro Tile(n, maxR, minR, depth, base)
    #local counter=0;
    #local a = 180/n;
	#local b = <0, 0, a>;

	#local P1 = <maxR, 0, 0>;
	#local P2 = vrotate(P1, b);
	#local P3 = <minR, 0, 0>;
	#local P4 = vrotate(P1, b);

	#declare T = mesh {
    	#while (counter < n)
    		#local b = <0, 0, a*counter>;
    		#local d = <0, 0, b.z + a>;
    		#local P1 = <maxR, 0, 0>;
    		#local P11 = vrotate(P1, b);
			#local P2 = vrotate(P1, d);
			#local P3 = <minR, 0, 0>;
			#local P33 = vrotate(P3, b);
			#local P4 = vrotate(P3, d);
			
			// front
			triangle{<P11.x, P11.y, 0>, <P4.x, P4.y, 0>, <P33.x, P33.y, 0>}
			triangle{<P11.x, P11.y, 0>, <P2.x, P2.y, 0>, <P4.x, P4.y, 0>}
			
			// top
			triangle{<P11.x, P11.y, 0>, <P2.x, P2.y, 0>, <P33.x, P33.y, depth>}
			triangle{<P33.x, P33.y, depth>, <P2.x, P2.y, 0>, <P4.x, P4.y, depth>}
			
			// base
			#if(base = 1 & counter = 0)
				triangle{<P11.x, P11.y, 0>, <P11.x, P11.y, depth>, <P33.x, P33.y, depth>}
			#end
			#if(base = 1 & counter = (n - 1))
				triangle{<P2.x, P2.y, 0>, <P2.x, P2.y, depth>, <P33.x, P33.y, depth>}
			#end
			
        	#declare counter = counter + 1;
    	#end
    };  
#end

#include "functions.inc"

/*

Createes rectangle roof in x-z plane
f - number of faces in a single tile
k - minR/maxR
w - width
d - depth (z)
nx - number of tiles in x direction
nz - number of tiles in z direction
pg - pigment type 0 - single color, 1 - multi-color

*/
#macro Roof(f, k, w, d, nx, nz, pg)
	#local iw = w/nx;
	#local id = d/nz;
	#local counter=0;
	
	Tile(f, iw/2, (iw/2) * k, 1, 1)
	union {
		#while (counter < nx)
			#local counter1=0;
			#while (counter1 < nz)
				object{
					T
		  			scale<1, 1, id>
		  			translate<iw/2 + (iw*counter), 0, id*counter1>
		  		}   
		  		#declare counter1 = counter1 + 1;
			#end
			#declare counter = counter + 1;
		#end
	    texture{		  		
			#if(pg = 0)
				pigment{Pgm1}
			#else	
				pigment{Pgm2 scale<iw, 1, id>} 
			#end
			finish{diffuse 0.66} 
		}
	}	
#end

/*

Createes the row of tiles in z direction
f - number of faces in a single tile
minR - minimum radius
maxR - maximum radius
d - depth (z)
nz - number of tiles in z direction
pg - pigment type 0 - single color, 1 - multi-color

*/
#macro Row(f, maxR, minR, d, nz, pg)
	#local id = d/nz;
	#local counter=0;
	
	Tile(f, maxR, minR, 1, 0)
	union {
		#while (counter < nz)
			object{
				T
		  		scale<1, 1, id>
		  		translate<0, 0, id*counter>
		  	}   
		  	#declare counter = counter + 1;
		#end
		texture{		  		
			#if(pg = 0)
				pigment{Pgm1}
			#else	
				pigment{Pgm2 scale<1/maxR, 1, id> translate x*(maxR/2)} 
			#end
			finish{diffuse 0.66} 
		}
	}	
#end

union {
	object {
		Roof(20, 0.75, 10, 5, 30, 10, 1)
		translate<-5, 0, -5> 
		rotate -x*20 
	}
	object {
		Roof(20, 0.75, 10, 5, 30, 10, 1)
		translate<-5, 0, -5> 
		rotate<0, 180, 0>
		rotate x*20
	}
	object {
		Row(20, 0.2, 0.2*0.7, 10, 20, 1)
		rotate -y*90
		translate x*5
	}    
	
	translate<0, 3, 0>
	rotate y*60
	rotate -x*30      
}
