global_settings{
	max_trace_level 10
}

camera {
	location <0, 1, -10>    
    look_at <0, 1, 0>
}   

light_source {
	<30, 20, -50>
	color rgb 1.1
}

#local showCloudTxt = 1;

sky_sphere {
	pigment {
		gradient y
		color_map {
			[0 rgb 1]
			[1 rgb <0.2, 0.5, 0.9>]
		}
		rotate x*40
	}
}

#local C = mesh{
	triangle{0, <0, 1, 0>, <1, 0, 0>}
	triangle{<0, 1, 0>, <1, 1, 0>, <1, 0, 0>}
	
	#if(showCloudTxt)
 		pigment{
			onion
			color_map{
				[0 0.6 color rgb 0.8 color rgbt 1]
				[0.6 1 color rgbt 1 color rgbt 1]
			}
			turbulence 0.1
			omega 0.8
		
			scale 0.8
			translate<0.5, 0.5, 0>
		}
		finish{ambient 0.57}                         
	#else
		pigment{color rgb 1}
	#end
	
	translate -x*0.5
	no_shadow
}

union {
	object{C}
	object{C scale 0.8 translate<0.3, -0.2, -0.0001>}
	object{C scale 0.8 translate<-0.2, -0.2, 0.0001>}
	object{C scale 0.6 translate<0.5, 0.2, 0.0002>}
	object{C scale 0.6 translate<-0.4, 0.15, -0.0002>}
	object{C scale 0.4 translate<0.7, 0, 0.0003>}
	object{C scale 0.4 translate<0.6, 0, -0.0003>}
	object{C scale<0.8, 0.5, 1> translate<0.65, -0.2, 0.0004>}
	object{C scale<1.6, 1, 1> rotate -x*20 translate<-0.2, -0.2, -0.000>}
	object{C scale<1.8, 1, 1> rotate -x*40 translate<-0.3, -0.4, -0.000>}
	object{C scale<1.8, 1, 1> rotate -x*60 translate<-0.4, -0.4, -0.000>}
	
	scale<6, 4, 2>
	scale 0.7
}
