// Persistence Of Vision Ray Tracer Include File
// -------------------------------------------------------
// File: @(#)steps.inc
// Desciption: steps for capriccio scene
// Creation Date: $ 03 May 2003, 21:40:22 $
// Last modified: $ 04 May 2003, 11:05:52 $
// Author: Christoph Hormann
//


#include "math.inc"
#include "transforms.inc" 

#declare showHelpers = off;
#declare test_version = off;

#declare Step_Point_Cnt=8;
#declare Step_Brick_Length=0.4;

#declare Steps_Point=array[Step_Point_Cnt]
  
#declare Steps_Point[0]=<4.40, 0, -49.0>;
#declare Steps_Point[1]=<2.70, 0, -42.0>;
#declare Steps_Point[2]=<1.00, 0, -44.0>;
#declare Steps_Point[3]=<1.72, 0, -46.5>;
#declare Steps_Point[4]=<1.84, 0, -49.3>;
#declare Steps_Point[5]=<0.50, 0, -53.0>;
#declare Steps_Point[6]=<-0.5, 0, -54.5>;
#declare Steps_Point[7]=<5, 0, -56>;

#declare VCorner=array[Step_Point_Cnt]
#declare AngleCorner=array[Step_Point_Cnt]
  
#declare Rough_Depth=0.075;  

#declare Pig_01=
  pigment {
    granite
    color_map {
     [ 0.0000  color rgb<0.7373, 0.5961, 0.4549> ]
     [ 0.0526  color rgb<0.7451, 0.6039, 0.4549> ]
     [ 0.1053  color rgb<0.6706, 0.5294, 0.3725> ]
     [ 0.1579  color rgb<0.7451, 0.6118, 0.4431> ]
     [ 0.2105  color rgb<0.6902, 0.5569, 0.3961> ]
     [ 0.2632  color rgb<0.6471, 0.5098, 0.3804> ]
     [ 0.3158  color rgb<0.6863, 0.5490, 0.4118> ]
     [ 0.3684  color rgb<0.6627, 0.5255, 0.3804> ]
     [ 0.4211  color rgb<0.7020, 0.5608, 0.4118> ]
     [ 0.4737  color rgb<0.6941, 0.5490, 0.3882> ]
     [ 0.5263  color rgb<0.7333, 0.5843, 0.4196> ]
     [ 0.5789  color rgb<0.7294, 0.5569, 0.4118> ]
     [ 0.6316  color rgb<0.7451, 0.5765, 0.3961> ]
     [ 0.6842  color rgb<0.7373, 0.5765, 0.3569> ]
     [ 0.7368  color rgb<0.7451, 0.5765, 0.3451> ]
     [ 0.7895  color rgb<0.7608, 0.5804, 0.3725> ]
     [ 0.8421  color rgb<0.8275, 0.6353, 0.4353> ]
     [ 0.8947  color rgb<0.8667, 0.6235, 0.4039> ]
     [ 0.9474  color rgb<0.8000, 0.5922, 0.3922> ]
     [ 1.0000  color rgb<0.7098, 0.5529, 0.4000> ]
    }
    scale 3.6
  }

#declare Pig_02=
  pigment {
    granite
    color_map {
     [ 0.0000  color rgb<0.8000, 0.5137, 0.3569> ]
     [ 0.0526  color rgb<0.7922, 0.5059, 0.3412> ]
     [ 0.1053  color rgb<0.7922, 0.5137, 0.3412> ]
     [ 0.1579  color rgb<0.7843, 0.5176, 0.3451> ]
     [ 0.2105  color rgb<0.7765, 0.5176, 0.3451> ]
     [ 0.2632  color rgb<0.8000, 0.5529, 0.3804> ]
     [ 0.3158  color rgb<0.7882, 0.5412, 0.3765> ]
     [ 0.3684  color rgb<0.7412, 0.4980, 0.3373> ]
     [ 0.4211  color rgb<0.7294, 0.4824, 0.3216> ]
     [ 0.4737  color rgb<0.7451, 0.4980, 0.3373> ]
     [ 0.5263  color rgb<0.7020, 0.4471, 0.2863> ]
     [ 0.5789  color rgb<0.6784, 0.4392, 0.2784> ]
     [ 0.6316  color rgb<0.7333, 0.4902, 0.3216> ]
     [ 0.6842  color rgb<0.7059, 0.4667, 0.2980> ]
     [ 0.7368  color rgb<0.7255, 0.4824, 0.3137> ]
     [ 0.7895  color rgb<0.7216, 0.4863, 0.3216> ]
     [ 0.8421  color rgb<0.7843, 0.5373, 0.3725> ]
     [ 0.8947  color rgb<0.8157, 0.5686, 0.4039> ]
     [ 0.9474  color rgb<0.8039, 0.5608, 0.3922> ]
     [ 1.0000  color rgb<0.7686, 0.5294, 0.3647> ]
    }
    scale 3.6
  }    

#declare Tex_Steps=
  texture {
    pigment {
      bozo
      pigment_map {
        
        [0.15 color rgb <0.41, 0.5, 0.37>*1.2]  
        [0.25 color rgb <0.45, 0.4, 0.37>*1.2 ]
        [0.35 color rgb <0.56, 0.42, 0.31>*1.2]
        [0.45 Pig_02 ]
        [0.47 color rgb <0.55, 0.33, 0.24>*1.2 ]
        [0.52 color rgb <0.56, 0.48, 0.22>*1.2]
        [0.55 Pig_01]        
        
        [0.67 
          granite 
          color_map {
            [ 0.4 color rgb <0.45, 0.36,0.29> ]
            [ 0.6 color rgb <0.35, 0.32,0.23> ]
            [ 0.8 color rgb <0.35, 0.30,0.21> ]
            [ 0.85 color rgb <0.35, 0.42,0.21> ]
          }
          scale 3
        ]        
      }
      warp { 
        turbulence 0.68
        lambda 3
        omega 0.6
      }
      scale 0.3      
    }
    finish {
      diffuse 0.6
      specular 0.08
    }
  }

#declare Tex_Steps2=
  texture {
    pigment {
      bozo
      pigment_map {
       
        [0.15 color rgb <0.41, 0.5, 0.37>*1.2]  
        [0.25 color rgb <0.45, 0.4, 0.37>*1.2 ]
        [0.35 color rgb <0.5, 0.4, 0.31>*1.2]
        [0.45 Pig_02 ]
        [0.47 color rgb <0.55, 0.33, 0.24>*1.2 ]
        [0.52 color rgb <0.56, 0.42, 0.22>*1.2]
        [0.55 Pig_01]
        [0.67 
          granite 
          color_map {
            [ 0.4 color rgb <0.45, 0.39,0.29> ]
            [ 0.6 color rgb <0.35, 0.32,0.23> ]
            [ 0.8 color rgb <0.35, 0.30,0.21> ]
            [ 0.85 color rgb <0.35, 0.42,0.21> ]
          }
          scale 3
        ]      
      }
      warp { 
        turbulence 0.8
        lambda 3
        omega 0.6
      }
      scale 0.3      
    }
    finish {
      diffuse 0.54
      specular 0.1
    }
  }

#local fn_Surface=
  function {
    pigment {
      bozo
      color_map {
        [0 rgb 0]
        [0.65 rgb 0.2]
        [1 rgb 1]
      }
      warp {
        turbulence 0.6
        lambda 2.7
        omega 0.65
      }
      scale 0.6
    }
  }  

  
#local Cnt=0;
  
#while (Cnt < Step_Point_Cnt)
    
  #if ((Cnt>0) & (Cnt < Step_Point_Cnt-1))
    #declare AngleCorner[Cnt]=VAngle(Steps_Point[Cnt]-Steps_Point[Cnt-1],
                                     Steps_Point[Cnt]-Steps_Point[Cnt+1]);
    #declare VCorner[Cnt]=vnormalize(
                            vnormalize(Steps_Point[Cnt]-Steps_Point[Cnt-1])+
                            vnormalize(Steps_Point[Cnt]-Steps_Point[Cnt+1])
                          );
      
    #if ((VCorner[Cnt].x>0.1) & (Steps_Point[Cnt].x<2))
      #declare VCorner[Cnt]=-VCorner[Cnt];
    #end
  #else
    #if (Cnt>0)
      #declare VCorner[Cnt]=vrotate(vnormalize(Steps_Point[Cnt]-Steps_Point[Cnt-1]), 90*y);
    #else
      #declare VCorner[Cnt]=vrotate(vnormalize(Steps_Point[Cnt]-Steps_Point[Cnt+1]), -90*y);
    #end
    #declare AngleCorner[Cnt]=pi;
  #end
  
  #local Cnt=Cnt+1;
#end
  
union { 

  #local Start_Level=true;
  #local SSeed=seed(9);
  #local YPos=Step_Surface_Height;
  #local XPos=0;
  #while (YPos > -0.2)    
    
    #local Cnt=0;
    #while (Cnt < Step_Point_Cnt)
      
      #if (showHelpers)
        cylinder { Steps_Point[Cnt]-y, Steps_Point[Cnt]+Step_Surface_Height*y, 0.05  pigment { color rgb x } }
        cylinder { 0, VCorner[Cnt], 0.05  pigment { color rgb z } translate Steps_Point[Cnt]+Step_Surface_Height*y }
      #end
        
      #if (Cnt < Step_Point_Cnt-1)
        #local Seg_Length=vlength(Steps_Point[Cnt+1]-Steps_Point[Cnt]);
        intersection {
          
         #if (test_version)          
          box {              
            <XPos, -1, -2>, <XPos-Step_Depth, YPos, Seg_Length+2>
            Reorient_Trans(z, Steps_Point[Cnt+1]-Steps_Point[Cnt]) 
            texture { Tex_Steps translate rand(SSeed)*10 }
          }          
         #else
          merge {
            
            #if (Start_Level)
              #local ZPos=0;
              #local ZEnd=Seg_Length;
            #else
              #local ZPos=-2;   
              #local ZEnd=Seg_Length+2;
            #end
            
            #while (ZPos < ZEnd)  
                
              #local BLength=Step_Brick_Length*(1+0.2*(rand(SSeed)-0.5));
              #if (ZPos+BLength > ZEnd)
                #local BLength=ZEnd-ZPos;
              #end
              #local RndMove=rand(SSeed)*10;
                
              #local fn_Brick=
                function {
                  f_rounded_box(                      
                    x+Step_Depth*0.5, 
                    y+Step_Height*0.5, 
                    z-BLength*0.5, 
                    Step_Round,                      
                    Step_Depth*0.5, Step_Height*0.5, BLength*0.5 
                  ) 
                  -Rough_Depth*0.24
                  +fn_Surface(x, y+RndMove, z).red*Rough_Depth*1.35                    
                }
                
              isosurface {
                  
                function { fn_Brick(x, y, z) }
                  
                max_gradient 5
                  
                contained_by {  
                  box {                      
                    //<0, 0, 0>, <-Step_Depth, -Step_Height, BLength>
                    <Rough_Depth, Rough_Depth, -Rough_Depth>, 
                    <-Step_Depth-Rough_Depth, -Step_Height-Rough_Depth, BLength+Rough_Depth>                      
                  }
                }
                texture { Tex_Steps translate rand(SSeed)*10 } 
                
                translate <XPos, YPos, ZPos>
              }
                
              #undef fn_Brick
                
              #local ZPos=ZPos+BLength;
            #end 
            box {              
              <XPos-Step_Round, -1, Step_Round>, <XPos-Step_Depth+Step_Round, YPos-Step_Round, Seg_Length-Step_Round>
            }              
            Reorient_Trans(z, Steps_Point[Cnt+1]-Steps_Point[Cnt])     
          }
         #end
          plane {   
            VCorner[Cnt], 0
            rotate 90*y
            #if (showHelpers)
              pigment { color rgb z } 
            #end
          }             
          plane { 
            VCorner[Cnt+1], 0
            rotate -90*y
            translate Seg_Length*vnormalize(Steps_Point[Cnt+1]-Steps_Point[Cnt])
            #if (showHelpers)
              pigment { color rgb x } 
            #end
          }  
          translate Steps_Point[Cnt]
        }
      #end 
      
      #local Cnt=Cnt+1;
    #end  
    
    #local YPos=YPos-Step_Height;
    #local XPos=XPos+Step_Depth;
    #if (Start_Level)
      #local Start_Level=false;
    #end
  #end 
  
  intersection {
  
    prism {                                
      linear_sweep 
      linear_spline 
      Step_Surface_Height-0.1,  
      Step_Surface_Height+0.1,
      Step_Point_Cnt 
      
      #local Cnt=0;
      #while (Cnt < Step_Point_Cnt)
        #local Point=Steps_Point[Cnt]-VCorner[Cnt]*Step_Depth*0.5;
        
        ,<Point.x, Point.z>
        #local Cnt=Cnt+1;
      #end         
    }
    
    
    #if (test_version) 
      
      plane {
        y, Step_Surface_Height-Step_Round*1
      }
      
    #else
    
      #local fn_Plane=
        function {
          y
          +fn_Surface(x, y, z).red*Rough_Depth                    
        }
    
      isosurface {
      
        function { fn_Plane(x, y, z) }
                  
        max_gradient 5
                  
        contained_by {  
          box {                      
            <-1, -0.1, -40>, 
            <5, 0.01, -55>                      
          }
        }      
        
        translate (Step_Surface_Height-Step_Round*0.7)*y
      }
    #end
  } 
    
  texture { Tex_Steps2 }
  
  translate <0.1, 0, -1.2> 
}
