/*	aspect ratio of this image is 1.24
	you can use the following sizes:
	cmd://+w300 +h372 +a0.3 +r2 +am1
	cmd://+w450 +h558 +a0.3 +r3 +am1
	cmd://+w600 +h744 +a0.2 +r2 +am2
	cmd://+w900 +h1116 +a0.1 +r4 +am1
*/

/*******************************************************************

  modifications:

    - 03-27-2003:
        Christoph Hormann: 	added water
                           	added radiosity
                           	added some dummy shapes
                           	changed scale
                           	changed light
                           	changed sky

    - 03-27-2003
        Matti Karnaattu:   	changed sky colors to match more with
							original image
							added sky.inc for light adjustments

    - 03-28-2003
        Gena Obukhov:      	added House1

    - 04-01-2003
        Bob Hughes:        	added building front (to St. Paul's)
                           	changed lighting, sky, some textures
                           	moved buildings (houses) a little
                           	scaled St. Paul's down and moved closer by half
                           	added clouds (not very usable)

	- 04-01-2003
		Gena Obukhov:      	added House2, House3, House4 (without textures)

    - 04-04-2003
		Jim Charter:       	added figure standing on slip,
		                   	modified righthand building placers
		                   	added rough version of slip and steps
		                   	lower water level 1 unit

	- 04-07-2003
		Gena Obukhov:      	added House5, House6 (without textures)
						   	rearranged objects

	- 04-11-2003
		Txemi Jendrix:		added Boat1

	- 04-12-2003
		Gena Obukhov:		added House5-House10
							rearranged objects

    - 04-14-2003:
        Christoph Hormann:
                           	changed lighting
                           	changed sky
                           	removed ambient finishes
                           	changed sun position

	- 04-17-2003
		Txemi Jendrix:		added Boat2 and modified Boat1
                           	
                           	
	- 04-20-2003:
        Jim Charter: 		added new figure: woman, child and man in boat
        					modified textures
        					
	- 04-20-2003:
        Gena Obukhov:		painted House1, House3-House5
        
	- 04-27-2003:
        Gena Obukhov:		painted House2, House6-House10
        					reduced fog thickness
        					added textures to cathedral dome suggested by Matti Karnaattu 
    - 05-04-2003:
        Christoph Hormann:
                           	added isosurface steps
                           	added test camera for steps
                           	added test light for rendering without radiosity
                           	added alternative media fog


*******************************************************************/

#version 3.5;


/************************************* Flags ****************************************/
#declare showCathedral = 1;
#declare showDome = 1;
#declare showEntrance = 1;
#declare showSteps = 1;

#declare showLeftHouses = 1;
#declare showHouse1 = 1;
#declare showHouse2 = 1;
#declare showHouse3 = 1;
#declare showHouse4 = 1;
#declare showHouse5 = 1;
#declare showHouse6 = 1;
#declare showHouse7 = 1;
#declare showHouse8 = 1;
#declare showHouse9 = 1;
#declare showHouse10 = 1;

#declare showWater = 1;
#declare showSky = 1;
#declare showFog = 0;
#declare showMediaFog = 0;
#declare showClouds = 0; // shadows cause much slower render-time, impractical

#declare showTestObjects1 = 1;
#declare showTestObjects2 = 1;
#declare showSlip = 1;
#declare showFigures = 1;  
#declare showManOnSlip = 1;   
#declare showWomanOnSteps = 1;
#declare showchildOnSteps = 1;      
#declare showmanInBoat = 1;

#declare showBoat1 = 1;
#declare showBoat2=1;

#declare use_Rad = true;
#declare Rad_HQ = false;
#declare use_area_light = false;

#declare Camera=0;
//#declare Camera=1;

//#declare Sun_Pos=vnormalize(<15, 8, 3>);
// Sun flags
#declare useSun = 0;
//#declare sunZenithAngle = 30;             // 0 - 90
//#declare sunAzimuthAngle = 75; // changed // 0 is north (direction <0, 0, 1>)
#declare sunZenithAngle = 57;
#declare sunAzimuthAngle = 47;
#declare sunLightColor = <1.9,1.75,1.5>*1.5;  // <2.0, 1.7, 1.3> * 0.8;
#declare sunSize = 10;                    // Angle
#declare sunLightShadowMinimumDetail = 0; // 0 - 9
#declare sunLightShadowMaximumDetail = 4; // 0 - 9

// sunLightShadowMinimumDetail must be less or equal than
// sunLightShadowMaximumDetail. If sunLightShadowMaximumDetail is
// greater than zero then sunLightShadowMinimumDetail must be greater
// than zero.

#declare sunLightInteractWithMedia = false;
#declare sunPhotonsRefraction = off;
#declare sunPhotonsReflection = off;
#declare sunPhotonsAreaLight = off;


/********************************* global variables **********************************/
#declare reverse = transform {
	matrix <
		-1,0,0,
		0,1,0,
		0,0,1,
		0,0,0 >  
}


/********************************* global_settings **********************************/

global_settings {
	max_trace_level 10
	assumed_gamma 1
	#if (use_Rad)
		//ambient_light 0.0
		radiosity {
			pretrace_start 0.08
			pretrace_end   0.02

			#if (Rad_HQ)
			  count 200
			  nearest_count 7
			  error_bound 0.5
			#else
			  count 99 // 60 // changed
			  nearest_count 5
			  error_bound 0.9 // 1.0 // changed
			#end

			recursion_limit 1 // 3

			low_error_factor 0.5
			gray_threshold 0.0 // 0.2 // changed
			minimum_reuse 0.015
			brightness 0.75 // changed

			normal on
			media on
		}
	#end
}

#if (use_Rad)
  #default { finish { ambient 0 } }
#end


/************************************* Camera ***************************************/

#switch (Camera)
  #case (1)         // --- test view for foreground stairs ---
  
  camera {
    location <3, 5.0, -60>
    right x*image_width/image_height
    up y
    look_at <2, 0, -50>
    angle 32
  }     
    
  #break
#else
  
  camera {
    location <0, 1.5, -60>
    //location <0, 2.0, -60>
    right x*image_width/image_height
    up y
    look_at <0, 8, 0>
    angle 24
  }  
  
#end

/************************************* Lights ***************************************/
#if(useSun)
	#include "sun.inc"
#else
  light_source {
    //Sun_Pos*10000
    y*10000
    //color rgb <1.9, 1.7, 1.5> // changed
    color rgb <2.0, 1.6, 1.3>

    #if (use_area_light)
      area_light 100*x 100*z  3,3
      adaptive 1
      jitter orient circular
    #end

    rotate <sunZenithAngle, 0, 0>
    rotate <0, sunAzimuthAngle, 0>
  }
#end

#if (!use_Rad)
  light_source {
    y*10000    
    color rgb 1    
    rotate <sunZenithAngle, 0, 0>
    rotate <0, sunAzimuthAngle+180, 0>
  }
#end

/*********************************** Test Objects ***********************************/
#if(showTestObjects1)

union {
	box {0, <4, 12.00, 5>}
	box {0, <4, 10.00,  4> translate <0.2, 0, 5>}
	box {0, <4, 9,  6> translate <0, 0, 9>}
	box {0, <4, 7.00, 5> translate <0.1, 0, 15>}
	box {0, <4, 7.20, 4> translate <0, 0, 20>}
	box {0, <4, 5.50, 5> translate <0.1, 0, 24>}
	box {0, <4, 5.00, 4> translate <0, 0, 29>}

    rotate -y*1
  	translate <7, 0, -28> //8.3

  	texture {
    	pigment { color rgb <.75,.7,.6> }
    	finish { ambient 0.0 diffuse 0.5 }
  	}
}

#end


/************************************* Cathedral ************************************/
#if(showCathedral)
	union {
		#if(showDome)
			#include "colors.inc"
			#include "glass_old.inc"
			#include "metals.inc"
			#include "Stpaul.inc"

			object{StPauls scale 0.035}
		#end

		#if(showEntrance)
			#include "entrance.inc"
			object {Entrance}
		#end

		scale .65 rotate -35*y translate <-16, 38, 220>
	}
	#if(showSteps)
		union{
			box{<-30, -0.1, 10>, <30, 0.03, 200>}
			box{<-30, 0.03, 10.05>, <30, 0.06, 200>}
			box{<-30, 0.06, 10.10>, <30, 0.09, 200>}

			union{
				box{<-40, -0.1, 10>, <40, 0.03, 200>}
				box{<-40, 0.03, 10.05>, <40, 0.06, 200>}
				box{<-40, 0.06, 10.10>, <40, 0.09, 200>}
				translate<0, 0.09, 15>
			}

			pigment{color rgb 1}
		}
	#end
#end


/**************************************** Sky ***************************************/
#if(showSky)
/*
	sky_sphere {
		pigment {
			gradient y
			color_map {
				[0.0 rgb <212, 191, 189> / 255]
				[0.03 rgb <189, 226, 255> / 255] // <176, 226, 255>
				[0.15 rgb <  63, 136, 212> / 255]
				[0.5 rgb <  15, 112, 191> / 255] // <  0, 104, 139>
				[0.5 rgb 0]
			}
			scale 2
		}
	} */

#declare Sky_Pig1=
  pigment {
    gradient y
    color_map {
      [0.00 rgb <0.92,0.95,0.91>]
      [0.07 rgb <0.65,0.8,0.92>]
      [0.20 rgb <0.38,0.58,0.8>*0.85]
      [0.37 rgb <0.12,0.43,0.8>*0.5]
    }
  }

sky_sphere {
  pigment {
  //Sky_Pig1
    pigment_pattern {
      spherical
      color_map { [0 rgb 0][1 rgb 1] }
      scale 2
      //translate Sun_Pos
      translate y
      rotate <sunZenithAngle, 0, 0>
      rotate <0, sunAzimuthAngle, 0>
    }

    pigment_map {
      [0.2 rgb <0.12,0.43,0.8>*0.4]
      [0.6 Sky_Pig1]
    }
  }
}
#end


/***************************************** Fog **************************************/
#if(showFog)
	fog {
		fog_type 2
		distance 1150
		color <.6,.75,.9>
		fog_alt 12
		fog_offset 0
	}
#end

#if(showMediaFog)
sphere { 0, 300 

  pigment { color rgbt <1,1,1,1> }
  interior {
    media {
      scattering { 5, 0.002 eccentricity 0.85 extinction 1 }
      method 3
      intervals 1
      samples 5//,7
      //aa_level 2
      //aa_threshold 0.1
      
      density {
        planar
        poly_wave 2
        color_map {
          [0.00 rgb 0]
          [1.00 rgb 1]
        }

        scale 20
      }      
    }
  }
  hollow
}
#end


/**************************************** Clouds ***********************************/
#if(showClouds)
	#declare ClearSky=pigment {rgbf 1}

	#declare CloudySky=pigment {
		bumps
		color_map {
			[0 rgbf <1,1,1,0>]
			[0.5 rgbf <1,1,1,0.1>]
			[0.8 rgbf <1,1,1,0.9>]
			[0.9 rgbf 1]
		}
		turbulence 0.1 scale 0.1
	}

	// clouds added
	sphere {
		-5000*y,6000
		pigment {
			granite
			pigment_map {
				[0.3 ClearSky]
				[0.5 CloudySky]
			}
			frequency 1 scale 300
		}
		finish {
			ambient 0.75 diffuse 0.9
		}
		hollow
	}
#end


/*************************************** Water **************************************/
#if(showWater)
  #include "water.inc"
#end


/********************************* Houses. Left Side ********************************/
#local widthHouse1 = 2.4;
#local widthHouse2 = 4.3;
#local widthHouse3 = 4;
#local widthHouse4 = 4;
#local widthHouse5 = 5;
#local widthHouse6 = 5;
#local widthHouse7 = 5;
#local widthHouse8 = 4;
#local widthHouse9 = 5;
#local widthHouse10 = 4;

union {
	// 1
	#if(showLeftHouses & showHouse1)
		#include "house1.inc"
		object {House1 scale 10 translate <0, 0, 0.44>}
	#end

	// 2
	#local shift2 = widthHouse1;
	#if(showLeftHouses & showHouse2)
		#include "house2.inc"
		object{House2 scale 10 translate <shift2, 0, 0.4>}
	#end

	// 3
	#local shift3 = shift2 + widthHouse2;
	#if(showLeftHouses & showHouse3)
		#include "house3.inc"
		object {House3 scale 10 translate <shift3, 0, 0.3>}
	#end

	// 4
	#local shift4 = shift3 + widthHouse3;
	#if(showLeftHouses & showHouse4)
		#include "house4.inc"
		object {House4 scale 10 translate <shift4, 0.4, 0.4>}
	#end

	// 5
	#local shift5 = shift4 + widthHouse4;
	#if(showLeftHouses & showHouse5)
		#include "house5.inc"
		object {House5 scale 10 translate <shift5, 0, 0.1>}
	#end

    // 6
    #local shift6 = shift5 + widthHouse5;
	#if(showLeftHouses & showHouse6)
		#include "house6.inc"
		object {House6 scale 10 translate <shift6, 0, 0>}
	#end

	// 7
	#local shift7 = shift6 + widthHouse6;
	#if(showLeftHouses & showHouse7)
		#include "house7.inc"
		object {House7 scale 10 translate <shift7, 0, 0.1>}
	#end

	// 8
	#local shift8 = shift7 + widthHouse7;
	#if(showLeftHouses & showHouse8)
		#include "house8.inc"
		object {House8 scale 10 translate <shift8, 0, 0.3>}
	#end

	// 9
	#local shift9 = shift8 + widthHouse8;
	#if(showLeftHouses & showHouse9)
		#include "house9.inc"
		object {House9 scale 10 translate <shift9, 0, 0.2>}
	#end

	// 10
	#local shift10 = shift9 + widthHouse9;
	#if(showLeftHouses & showHouse10)
		#include "house10.inc"
		object {House10 scale 10 translate <shift10, 0, 0.1>}
	#end

	rotate -y*82 
	translate <-5.5, 0, -35>
}


/*********************************** Steps measures ***********************************/ 

#declare Step_Depth=0.25;
#declare Step_Height=0.15;
#declare Step_Round=0.01;
#declare Step_Surface_Height=0.7;

/*************************************** Figures **************************************/ 
             

#if(showFigures & showManOnSlip)
	#include "manOnSlip.inc"
	object{ 
          manOnSlip transform { reverse } rotate y*-30 scale 0.13 
          translate < 2.0,  Step_Surface_Height-Step_Round*0.7, -47.0 > 
        }
#end 
#if(showFigures & showWomanOnSteps)
	#include "womanOnSteps.inc"            
	object{ 
          womanOnSteps transform { reverse } rotate y*-32 scale 0.13 
          translate < 1.53,  Step_Surface_Height-Step_Height*2, -47.55 > 
        }
#end  
#if(showFigures & showchildOnSteps)
	#include "childOnSteps.inc"             
	object{ 
          childOnSteps transform { reverse } rotate y*-32 scale 0.13 
          translate < 1.53,  Step_Surface_Height-Step_Height*2, -47.55 > 
        }
#end
#if(showFigures & showmanInBoat)
	#include "manInBoat.inc"             
	object{ manInBoat transform { reverse } rotate y*-32 scale 0.11 translate <-1,-.05,-38>} 
#end

 
/************************************** Slip *****************************************/

#if(showSlip)   
  
  /*
  #declare slip =
    union {
      box { <-3,   -2, -12>, <3, 0.2, 12> }  
      box { <-3.25,   -2, -12.25>, <3.25, 0.2, 12.25> translate y*-.25 } 
      box { <-3.5,   -2, -12.5>, <3.5, 0.2, 12.5> translate y*-.5 }     
      box { <-3.75,   -2, -12.75>, <3.75, 0.2, 12.75> translate y*-.75 }
      box { <-4,   -2, -13>, <4, 0.2, 13> translate y*-1 } 
        
    }
  
  union { 
        
    object { slip }
    object { slip rotate y*20 translate <-3.95,-.00001,-.5>   }       
    
        
    rotate -32*y              
    translate <10.4, 0.3, -54>
          
    translate -y*0.5
    scale<1, 0.5, 1>
    translate y*0.5 
           
    pigment { color rgb <.75,.7,.6> }  
            
  }
  */
  
  #include "steps.inc"
  
#end


/**************************************** Boats ***************************************/
#if(showBoat1)
	#include "boat_1.inc"
    object {boat_1
    scale .25
    rotate <-10,25,-5>
    translate <-1,-.05,-38>}
#end

#if(showBoat2)
        #include "boat_2.inc"
        object {boat_2 
        scale 0.1 
        rotate <-7.0, -15.0, 0.0>
        translate <-3.6, 0.0, -47.0>}
#end
