// Persistence of Vision Ray Tracer Scene Description File
// File: sun.inc
// Desc: Sun
// Date: March 2003
// Auth: Matti Karnaattu

light_source {
  <0, 100000, 0>, rgb sunLightColor
    
  #if (sunLightShadowMaximumDetail)
    #local sunAreaLightSize = pow(2, sunLightShadowMaximumDetail - 1) + 1;

    #if (sunLightShadowMaximumDetail = 1)
      #local sunAreaLightAxis = tan(radians(sunSize / 2)) * pi * 50000;   
    #else
      #local sunAreaLightAxis = tan(radians(sunSize / 2)) * 200000;
    #end

    area_light <sunAreaLightAxis, 0, 0> , <0, 0, sunAreaLightAxis>,
      sunAreaLightSize, sunAreaLightSize

    adaptive sunLightShadowMinimumDetail - 1

    #if (sunLightShadowMaximumDetail > 1)
      circular
    #end
  #end

  #if (sunLightInteractWithMedia)
    media_attenuation on
  #end

  photons {
    refraction sunPhotonsRefraction
    reflection sunPhotonsReflection 
    
    #if (sunLightShadowMaximumDetail & sunPhotonsAreaLight)
      area_light
    #end
  }
  rotate <sunZenithAngle, 0, 0>
  rotate <0, sunAzimuthAngle, 0>
}