/*	aspect ratio of this image is 1.24
	you can use the following sizes:
	+w300 +h372
	+w450 +h558
	+w600 +h744
	+w900 +h1116
*/

/*******************************************************************

  modifications:

    - 03-27-2003:
        Christoph Hormann: added water
                           added radiosity
                           added some dummy shapes
                           changed scale
                           changed light
                           changed sky

    - 03-27-2003
        Matti Karnaattu:   changed sky colors to match more with
                             original image
                           added sky.inc for light adjustments
                           
	- 03-28-2003
        Gena Obukhov:      added House1


*******************************************************************/


/************************************* Flags ****************************************/
#declare showDome = 1;
#declare showWater = 1;
#declare showTestObjects = 1;
#declare showSky = 1;
#declare showHouse1 = 1;

#declare use_Rad = true;
#declare use_area_light = false;


// Sun flags 
#declare useSun = 0;
#declare sunZenithAngle = 30;             // 0 - 90
#declare sunAzimuthAngle = 60;            // 0 is north (direction <0, 0, 1>)
#declare sunLightColor = <2.0, 1.7, 1.3> * 0.8;
#declare sunSize = 10;                    // Angle
#declare sunLightShadowMinimumDetail = 0; // 0 - 9
#declare sunLightShadowMaximumDetail = 9; // 0 - 9

// sunLightShadowMinimumDetail must be less or equal than
// sunLightShadowMaximumDetail. If sunLightShadowMaximumDetail is
// greater than zero then sunLightShadowMinimumDetail must be greater
// than zero.

#declare sunLightInteractWithMedia = false;
#declare sunPhotonsRefraction = off;
#declare sunPhotonsReflection = off;
#declare sunPhotonsAreaLight = off;


/********************************* global_settings **********************************/

global_settings {
   max_trace_level 10
   assumed_gamma 1

   #if (use_Rad)
     radiosity {
       pretrace_start 0.08
       pretrace_end   0.02
       count 60

       nearest_count 5
       error_bound 1.0
       recursion_limit 1

       low_error_factor .5
       gray_threshold 0.0
       minimum_reuse 0.015
       brightness 0.6

       normal on
       media on
     }
   #end
}

#if (use_Rad)
  #default { finish { ambient 0 } }
#end

/************************************* Camera ***************************************/
camera {
    location <0, 2, -60>
    right x*image_width/image_height
    up y
    look_at <0, 6, 0>
    angle 24
}


/************************************* Lights ***************************************/
#if(useSun)
	#include "sun.inc"
#else
	light_source {
		<10, 8, 3>*10000
		color rgb <2.0, 1.6, 1.3>*0.8

		#if (use_area_light)
			area_light 200*x 200*y  3,3
			jitter orient circular
		#end
	}	
#end


/*********************************** Test Objects ***********************************/
#if(showTestObjects)
	sphere{<0, 1, 0>, 1 pigment{color rgb<1, 0, 0>}}

union {
  box { <-1, -2, -12>, <5, 0.2, 12> }
  box { <4, -2, -10>, <8, 8, 10> }
  rotate -4*y
  translate <3, 0, -35>

  texture {
    pigment { color rgb 0.7 }
    finish { ambient 0 diffuse 0.6 }
  }
}

#end


/*************************************** Dome ***************************************/
#if(showDome)
	#include "colors.inc"
	#include "glass_old.inc"
	#include "metals.inc"
	#include "Stpaul.inc"

	object{StPauls scale 0.035 translate<-20, 60, 420>}
#end

/**************************************** Sky ***************************************/
#if(showSky)

/*
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.00 rgb <0.96,0.95,0.91>*0.9]
      [0.07 rgb <0.72,0.8,0.92>*0.9]
      [0.20 rgb <0.45,0.58,0.8>*0.85]
      [0.37 rgb <0.26,0.43,0.72>*0.56]
    }
  }
}*/

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <176, 226, 255> / 255]       
      [0.5 rgb <  0, 104, 139> / 255]
      [0.5 rgb 0]
    }
    scale 2
  }
}

#end


/*************************************** Water **************************************/
#if(showWater)
  #include "water.inc"
#end 


/********************************* Houses. Left Side ********************************/ 
union {
	#if(showHouse1)
		#include "house1.inc"
		object {House1 scale 10}
	#end
	
	#if(showTestObjects)
		union {
  			box { <0, -2, 0>, <4, 8, 4> translate <-4.4, 0, 0.4>}
  			box { <0, -2, 0>, <4, 5, 4> translate <5.2, 0, 0.5>}
  			box { <0, -2, 0>, <5, 7, 4> translate <9.2, 0, 0.3>}

  			texture {
    			pigment { color rgb<0.7, 0.67, 0.6> }
    			finish { ambient 0 diffuse 0.4 }
  			}
		}
	#end
	
	rotate -y*78
	translate <-4.5, 0, -28>   
} 
