#version unofficial mlpov 0.8;

global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 50                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    normal on                     // take surface normals into account [off]
  }
  max_trace_level 10
} 

camera {
  location <0, 0, -500>
  look_at <0, 0, 0>
  rotate <45, 0, 0>
  translate <0, 125, 0>
  }

sphere {
  <0, 0, 0>
  100000
  hollow
  texture {
    pigment {
      image_map {
        hdr "kitchen_probe.hdr" once interpolate 2
        }
      translate -.5
      scale 300000
      }
    finish {
      ambient 1
      diffuse 0
      }
    }
  }
  
plane {
  y, 0
  texture {
    pigment {
      color rgb <.75, 1, 1>
      }
    finish {
      reflection .125
      }
    normal {
      bozo scale 4
      }
    }
  }
  
merge {
  
  difference {
  
    sphere {
      <0, 0, 0>
      50
      }
      
    sphere {
      <0, 0, 0>
      40
      }
    
    }
    
#local Count = 16;
#local Deg = 360 / Count;

#while (Count > 0)

  sphere {
    <0, 0, 0>
    15
    translate <-45, 0, 0>
    rotate <0, Count * Deg, 0>
    }
    
  #local Count = Count - 1;   

#end

#local Count = 8;
#local Deg = 360 / Count;

#while (Count > 0)

  sphere {
    <0, 50, 0>
    15
    translate <-15, 0, 0>
    rotate <0, Count * Deg, 0>
    }
    
  #local Count = Count - 1;   

#end

#local Count = 32;
#local Deg = 360 / Count;

#while (Count > 0)

  sphere {
    <0, 150, 0>
    16
    translate <-95, 0, 0>
    rotate <0, Count * Deg, 0>
    }
    
  #local Count = Count - 1;   

#end
  
  difference {
  
    sphere {
      <0, 150, 0>
      100
      }
      
    sphere {
      <0, 150, 0>
      95
      }
      
    box {
      <-200, 150, -200>
      <200, 500, 200>
      }
      
    }
  
  translate <0, .01, 0>
  
  interior { ior 1.5 }
  
  texture {
    pigment {
      color rgb 1 filter 1
      }
    finish {
      reflection { 0, 1 }
      conserve_energy
      }
    }
  
  }



sphere {
  <0, 0, 0>
  79 
  translate <0, 150, 0>
  interior { ior 1.75 }
  texture {
    pigment {
      color rgb <1, .75, 0> filter 1
      }
    finish {
      reflection { 0, .5 }
      conserve_energy
      }
    }
  }
  
    