/*********************************************************************/
// Test scene for perrotts.inc
//
// 2002-12-25 - Ib Rasmussen - www.ibras.dk
/*********************************************************************/
#include "colors.inc"
#include "skies.inc"

#version 3.1;
global_settings { assumed_gamma 2.2 }


/************************* Declarations ******************************/

/*------------------------ Control Flags ----------------------------*/

// Cam 1 = TestCam
// Cam 2 = 
// Cam 3 = 
#declare Cam = 1; 


/*--------------------- Camera and Lights ---------------------------*/

#declare CamPos = <00, 170, -4000>;

#declare TestCam=camera {
   location  CamPos
   angle 52
   look_at   <00, 1400,  0 >
   right <3/4, 0, 0>
}


#declare MainLight=light_source { <0, 0, 0>, colour White*1.5}
#declare CamLight=light_source { <0, 0, 0>, colour White*0.5 }
  
/*--------------------------- Objects ---.---------------------------*/

#include "perrotts.inc"

/***************************** Scene *********************************/

/*--------------- Camera, Lights and Background ---------------------*/

#switch(Cam)
   #case (1)
      camera { TestCam }
      object { MainLight translate < 50000, 250000, -180000> }
      object { CamLight translate CamPos }
      #break   
   #else
      camera { TestCam }
      object { MainLight translate < 50000, 50000, -50000> }
      object { CamLight translate CamPos }
#end


sky_sphere { S_Cloud1 }
                    
plane { y, 0 pigment { rgb <0, 0.4, 0> } }
                    
/*------------------------- Objects ----------------------------------*/
 
object { Perrotts rotate <0, 30, 0> }
