/*********************************************************************/
// Perrott's Folly, Birmingham, UK
// Modelled in response to Alf Peake's suggestion in povray.general
//
// The model is based on photos found on the internet, hence the lack
// of detail on the lower part (in particular: an entrance), as this
// is not shown on any of the photos. The side opposite the cylindrical
// part is not shown either, so I have made it the same as the two
// sides at right angle to it.
//
// 2002-12-25 - Ib Rasmussen - www.ibras.dk
/*********************************************************************/
// Scale:  1 unit = 1 cm (approximately)
// Origin: Bottom center of the square base
// Use:    object { Perrotts [rotate] [translate] }
/*********************************************************************/
#version 3.1;

#include "colors.inc"
#include "glass.inc"

/************************* Declarations ******************************/

/*-------------------------- Constants ------------------------------*/

#local BHeight=  7.6;
#local BWidth=  24;
#local BMortar=  1.5;

/*-------------------------- Textures -------------------------------*/

#local T_Mortar=texture {
   pigment { granite
      turbulence 0.6
      color_map{
	  [0.000, 0.154   color rgbf <0.5, 0.5, 0.366, 0.000>
			            color rgbf <0.5, 0.5, 0.477, 0.000>]
	  [0.154, 0.300   color rgbf <0.5, 0.5, 0.5, 0.000>
			            color rgbf <0.5, 0.5, 0.366, 0.000>]
	  [0.300, 0.320   color rgbf <0.3, 0.3, 0.4, 0.000>
			            color rgbf <0.4, 0.4, 0.5, 0.000>]
	  [0.320, 0.615   color rgbf <0.5, 0.5, 0.5, 0.000>
			            color rgbf <0.5, 0.5, 0.366, 0.000>]
	  [0.615, 0.812   color rgbf <0.5, 0.5, 0.366, 0.000>
		               color rgbf <0.5, 0.5, 0.477, 0.000>]
	  [0.812, 1.001   color rgbf <0.5, 0.5, 0.5, 0.000>
		               color rgbf <0.1, 0.1, 0.1, 0.000>]
      }
   }
   scale <3, 3, 3>
}

#local T_Brickcolor=texture {
   pigment { bozo
      turbulence 1.0
      color_map{
	  [0.0, 0.5   color rgbf <0.45, 0.25, 0.15, 0.0>
		           color rgbf <0.50, 0.30, 0.20, 0.0>]
	  [0.5, 1.001 color rgbf <0.50, 0.30, 0.20, 0.0>
		           color rgbf <0.45, 0.25, 0.15, 0.0>]
      }
   }
   scale <50, 150, 50>
}

#local T_Brick=texture {
   brick texture {T_Mortar}, texture {T_Brickcolor}
   brick_size <BWidth, BHeight, BWidth>
   mortar BMortar
}

#local T_Sandstone=texture {
   pigment { granite
      turbulence 0.6
      color_map{
	  [0.000, 0.154   color rgb <0.42, 0.42, 0.37>
			            color rgb <0.42, 0.42, 0.40>]
	  [0.154, 0.300   color rgb <0.42, 0.42, 0.42>
			            color rgb <0.42, 0.42, 0.29>]
	  [0.300, 0.320   color rgb <0.37, 0.37, 0.17>
			            color rgb <0.35, 0.35, 0.35>]
	  [0.320, 0.615   color rgb <0.42, 0.42, 0.42>
	                  color rgb <0.42, 0.42, 0.32>]
	  [0.615, 0.812   color rgb <0.42, 0.42, 0.32>
			            color rgb <0.42, 0.42, 0.41>]
	  [0.812, 1.001   color rgb <0.42, 0.42, 0.42>
			            color rgb <0.10, 0.10, 0.10>]
      }
   }
   scale 10
}

#local T_Skifer=texture {
   pigment { bozo
      turbulence 1.0
      color_map{
	  [0.0, 0.5   color Gray35
		           color Gray45 ]
	  [0.5, 1.001 color Gray45
		           color Gray35 ]
      }
   }
   scale 100
}

/*------------------------- Objects ----------------------------------*/

/*----- Windows -----*/

#local Window1Arc1=difference {
   cylinder { <0, 0,  0>, <0, 0, 6>, 64 scale <1, 42/64, 1> }
   cylinder { <0, 0, -1>, <0, 0, 7>, 58 scale <1, 38/58, 1> }
   plane { x, 0 translate <16, 0, 0> }
   plane { y, 0 }
}

#local Window1Arc2=difference {
   cylinder { <0, 0,  0>, <0, 0, 6>, 64 scale <1, 42/64, 1> }
   cylinder { <0, 0, -1>, <0, 0, 7>, 58 scale <1, 38/58, 1> }
   plane { x, 0 translate <31, 0, 0> }
   plane { y, 0 }
}

#local Window1Arc3=difference {
   cylinder { <0, 0,  0>, <0, 0, 6>, 64 scale <1, 42/64, 1> }
   cylinder { <0, 0, -1>, <0, 0, 7>, 58 scale <1, 38/58, 1> }
   plane { x, 0 translate <46, 0, 0> }
   plane { y, 0 }
}

#local Window1=union {     
   difference {
      box { <-48, 0, 0>, <48, 100, 6> }
      box { <-42, 10, -1>, <42, 101, 11> }
   }
   box { <-18, 8, 0>, <-12, 100, 6> }
   box { < 18, 8, 0>, < 12, 100, 6> }       
   box { <-42, 36, 0>, <42, 42, 6> }
   box { <-42, 67, 0>, <42, 73, 6> }
   object { Window1Arc1 translate <-16, 100, 0> }
   object { Window1Arc1 scale <-1, 1, 1> translate <16, 100, 0> }
   object { Window1Arc2 translate <-46, 100, 0> }
   object { Window1Arc2 scale <-1, 1, 1> translate <46, 100, 0> }
   object { Window1Arc3 translate <-76, 100, 0> }
   object { Window1Arc3 scale <-1, 1, 1> translate <76, 100, 0> }   
   box { <-42, 10, 2>, <42, 135, 2.3> texture { T_Glass3 } }
   texture { pigment { White } }
}
      
#local Window1Cutout=union {
   box { <-48, 0, -220>, <48, 100, 220> }                                             
   intersection {
      cylinder { <0, 0, -220>, <0, 0, 220>, 64 scale <1, 42/64, 1> translate <-16, 100, 0> }
      cylinder { <0, 0, -220>, <0, 0, 220>, 64 scale <1, 42/64, 1> translate < 16, 100, 0> }
   }
}
                         
#local Window2Arc1=difference {
   cylinder { <0, 0,  0>, <0, 0, 6>, 96 scale <1, 81/96, 1> }
   cylinder { <0, 0, -1>, <0, 0, 7>, 90 scale <1, 75/90, 1> }
   plane { x, 0 translate <48, 0, 0> }
   plane { y, 0 }
}

#local Window2Arc2=difference {
   cylinder { <0, 0,  0>, <0, 0, 6>, 96 scale <1, 81/96, 1> }
   cylinder { <0, 0, -1>, <0, 0, 7>, 90 scale <1, 75/90, 1> }
   plane { x, 0 translate <63, 0, 0> }
   plane { y, 0 }
}

#local Window2Arc3=difference {
   cylinder { <0, 0,  0>, <0, 0, 6>, 96 scale <1, 81/96, 1> }
   cylinder { <0, 0, -1>, <0, 0, 7>, 90 scale <1, 75/90, 1> }
   plane { x, 0 translate <78, 0, 0> }
   plane { y, 0 }
}

#local Window2=union {     
   difference {
      box { <-48, 0, 0>, <48, 120, 6> }
      box { <-42, 10, -1>, <42, 121, 11> }
   }
   box { <-18, 8, 0>, <-12, 120, 6> }
   box { < 18, 8, 0>, < 12, 120, 6> }       
   box { <-42,  41, 0>, <42,  47, 6> }
   box { <-42,  78, 0>, <42,  84, 6> }
   box { <-42, 115, 0>, <42, 121, 6> }
   object { Window2Arc1 translate <-48, 120, 0> }
   object { Window2Arc1 scale <-1, 1, 1> translate <48, 120, 0> }
   object { Window2Arc2 translate <-78, 120, 0> }
   object { Window2Arc2 scale <-1, 1, 1> translate <78, 120, 0> }
   object { Window2Arc3 translate <-108, 120, 0> }
   object { Window2Arc3 scale <-1, 1, 1> translate <108, 120, 0> }   
   box { <-42, 10, 2>, <42, 185, 2.3> texture { T_Glass3 } }
   texture { pigment { White } }
}
      
#local Window2Cutout=union {
   box { <-48, 0, -220>, <48, 120, 0> }                                             
   intersection {
      cylinder { <0, 0, -220>, <0, 0, 220>, 96 scale <1, 81/96, 1> translate <-48, 120, 0> }
      cylinder { <0, 0, -220>, <0, 0, 220>, 96 scale <1, 81/96, 1> translate < 48, 120, 0> }
   }
}

#local Window3=union{                                                          
   difference {
      cylinder { <0, 0, 0>, <0, 0, 6>, 36 scale <1, 34/36, 1> }
      cylinder { <0, 0, -1>, <0, 0, 7>, 28 scale <1, 26/28, 1> }
   }
   difference {
      cylinder { <0, 0, 0>, <0, 0, 6>, 14 }
      cylinder { <0, 0, -1>, <0, 0, 7>, 8 }
   }                                                         
   box { <-3, -26, 0>, <3, -13, 6> }
   box { <-3,  13, 0>, <3,  26, 6> }
   box { <-28, -3, 0>, <-13, 3, 6> }
   box { < 13, -3, 0>, < 28, 3, 6> }
   cylinder { <0, 0, 2>, <0, 0, 2.3>, 28 scale <1, 26/28, 1> texture { T_Glass3 } }
   texture { pigment { White } }
}

#local Window3Cutout=cylinder { <0, 0, 0>, <0, 0, -220>, 36 scale <1, 34/36, 1> }
                         
#local Window4Arc1=difference {
   cylinder { <0, 0,  0>, <0, 0, 6>, 72 scale <1, 58/72, 1> }
   cylinder { <0, 0, -1>, <0, 0, 7>, 65 scale <1, 51/65, 1> }
   plane { x, 0 translate <36, 0, 0> }
   plane { y, 0 }
}

#local Window4Arc2=difference {
   cylinder { <0, 0,  0>, <0, 0, 3>, 68 scale <1, 54/68, 1> }
   cylinder { <0, 0, -1>, <0, 0, 4>, 65 scale <1, 51/65, 1> }
   plane { x, 0 translate <51.25, 0, 0> }
   plane { y, 0 }
}

#local Window4=union {     
   difference {
      box { <-36, -7, 0>, <36, 80, 6> }
      box { <-29,  8, -1>, <29, 71, 11> }
   }
   box { <-1.5, 8, 0>, <1.5, 72, 3> }
   box { <-30,  38, 0>, <30,  41, 3> }
   object { Window4Arc1 translate <-36, 80, 0> }
   object { Window4Arc1 scale <-1, 1, 1> translate <36, 80, 0> }
   object { Window4Arc2 translate <-66.5, 80, 0> }
   object { Window4Arc2 scale <-1, 1, 1> translate <66.5, 80, 0> }
   box { <-30, 8, 2>, <30, 125, 2.3> texture { T_Glass3 } }
   texture { pigment { White } }
}
      
#local Window4Cutout=union {
   box { <-36, -BHeight, -220>, <36, 80, 0> }                                             
   intersection {
      cylinder { <0, 0, -220>, <0, 0, 220>, 72 scale <1, 58/71, 1> translate <-36, 80, 0> }
      cylinder { <0, 0, -220>, <0, 0, 220>, 72 scale <1, 58/71, 1> translate < 36, 80, 0> }
   }
}


#local WindowC1=union {
   difference {
      box { <-6, 0, 0>, <6, 14*BHeight, 6> }
      box { <-3, 3, -1>, <3, 14*BHeight-3, 7> }
      texture { pigment { White } }
   }
   box { <-3, 3, 2>, <3, 14*BHeight-3, 2.3> texture { T_Glass3 } }
}
   
#local WindowC1Cutout=box { <-6, 0, 0>, <6, 14*BHeight, -150> }

#local WindowC2=union {
   difference {
      box { <-6, 0, 0>, <6, 10*BHeight, 6> }
      box { <-3, 3, -1>, <3, 10*BHeight-3, 7> }
      texture { pigment { White } }
   }
   box { <-3, 3, 2>, <3, 10*BHeight-3, 2.3> texture { T_Glass3 } }
}
   
#local WindowC2Cutout=box { <-6, 0, 0>, <6, 10*BHeight, -150> }

/*----- Walls -----*/

#local OctoTowerGesimsProfil=union{
   box { <-1, 0, 0>, <1, 10, -2> }
   cylinder { <-1, 2, -2>, <1, 2, -2>, 2 }
   box { <-1, 10, 0>, <1, 31, -4> }
   cylinder { <-1, 19, -4>, <1, 19, -4>, 2 }
   difference {
      box { <-1, 31, 0>, <1, 38, -11> }
      cylinder { <-1.1, 31, -11>, <1.1, 31, -11>, 7 }
   }
   box { <-1, 38, 0>, <1, 45, -11> }
   box { <-1, 45, 0>, <1, 53, -14> }
   difference {
      cylinder { <-1, 61.5622, -11.4378>, <1, 61.5622, -11.4378>, 9.8995 }
      plane {-y, 0 translate <0, 59, 0> }
   }
   difference {
      box { <-1, 59, 0>, <1, 66, -28> }
      cylinder { <-1.1, 56.4378, -30.5622>, <1.1, 56.4378, -30.5622>, 9.8995 }
   }
   box { <-1, 66, 215>, <1, 68, -28> }
}

#local OctoTowerColumn=difference {
   union{
      box { <50, 0, -203>, <95, 3*BHeight, -218> }
      box { <55, 3*BHeight, -203>, <90, 33*BHeight, -215> }
      box { <50, 33*BHeight, -203>, <95, 35*BHeight, -218> }
   }
   plane {-x, 0 rotate <0, -22.5, 0> }            
   texture { T_Sandstone }
}

#local OctoWall1=union {
   difference {                                                                                                                                                                                  
      box { <-90, 105*BHeight, -215>, <90, 292*BHeight, -190> }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      object { Window1Cutout translate <0, 118*BHeight, 0> }
      object { Window2Cutout translate <0, 165*BHeight, 0> }
      object { Window2Cutout translate <0, 218*BHeight, 0> }
      object { Window3Cutout translate <0, 275*BHeight, 0> }
   }   
   object { OctoTowerColumn translate <0, 289*BHeight, 0> }
   object { OctoTowerColumn scale <-1, 1, 1> translate <0, 289*BHeight, 0> }
   difference {
      box { <-90, 292*BHeight, -203>, <90, 335*BHeight, -190> }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      object { Window4Cutout translate <0, 303*BHeight, 0> }
   }
   difference {                                                                                                                                                                                  
      box { <-90, 322*BHeight, -215>, <90, 372*BHeight, -190> }
      intersection {
         cylinder { <-55, 322*BHeight, -220>, <-55, 322*BHeight, -180>, 110 }
         cylinder { < 55, 322*BHeight, -220>, < 55, 322*BHeight, -180>, 110 }
      }   
      plane {-y, 0 rotate <30, 0, 0> translate <0, 372*BHeight, -215> }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      box { <-42, 0, -50>, <42, 15*BHeight, 50> rotate <30, 0, 0> translate <0, 362*BHeight, -215> }
   }   
   difference {
      object { OctoTowerGesimsProfil scale <105, 1, 1> translate <0, 338*BHeight, -215> texture { T_Sandstone } }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
   }
   difference {                                             
      box { <-95, 0, -6>, <95, 3, 30> rotate <30, 0, 0> translate <0, 372*BHeight, -215> }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      box { <-42, 362*BHeight, -230>, <42, 375*BHeight, -150> }
      texture { T_Skifer }
   }   
   object { Window1 translate <0, 118*BHeight, 12-215> }
   object { Window2 translate <0, 165*BHeight, 12-215> }
   object { Window2 translate <0, 218*BHeight, 12-215> }
   object { Window3 translate <0, 275*BHeight, 12-215> }
   object { Window4 translate <0, 303*BHeight, 12-203> }
   box { <-48, -1, -6>, <48, 0, 15> rotate <-30, 0, 0> translate <0, 118*BHeight, -215> texture { T_Skifer } }
   box { <-48, -1, -6>, <48, 0, 15> rotate <-30, 0, 0> translate <0, 165*BHeight, -215> texture { T_Skifer } }
   box { <-48, -1, -6>, <48, 0, 15> rotate <-30, 0, 0> translate <0, 218*BHeight, -215> texture { T_Skifer } }
   box { <-36, -1, -6>, <36, 0, 15> rotate <-30, 0, 0> translate <0, 302*BHeight, -203> texture { T_Skifer } }
   box { <-42, 0, -6>, <42, 3, 30> rotate <30, 0, 0> translate <0, 362*BHeight, -215> texture { T_Skifer } }
   cylinder { <-50, 370*BHeight, -195>, <50, 370*BHeight, -195>, 2 texture { pigment { Black } } }
   texture { T_Brick }
}

#local OctoWall2=union{
   difference {
      box { <-90, 105*BHeight, -215>, <90, 292*BHeight, -190> }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      object { Window3Cutout translate <0, 275*BHeight, 0> }
   }
   object { OctoTowerColumn translate <0, 289*BHeight, 0> }
   object { OctoTowerColumn scale <-1, 1, 1> translate <0, 289*BHeight, 0> }
   difference {
      box { <-90, 292*BHeight, -203>, <90, 335*BHeight, -190> }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      object { Window4Cutout translate <0, 303*BHeight, 0> }
   }
   difference {
      box { <-90, 322*BHeight, -215>, <90, 372*BHeight, -190> }
      intersection {
         cylinder { <-55, 322*BHeight, -220>, <-55, 322*BHeight, -180>, 110 }
         cylinder { < 55, 322*BHeight, -220>, < 55, 322*BHeight, -180>, 110 }
      }   
      plane {-y, 0 rotate <30, 0, 0> translate <0, 372*BHeight, -215> }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      box { <-42, 0, -50>, <42, 15*BHeight, 50> rotate <30, 0, 0> translate <0, 362*BHeight, -215> }
   }
   difference {
      object { OctoTowerGesimsProfil scale <105, 1, 1> translate <0, 338*BHeight, -215> texture { T_Sandstone } }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
   }
   difference {                                             
      box { <-95, 0, -6>, <95, 3, 30> rotate <30, 0, 0> translate <0, 372*BHeight, -215> }
      plane { x, 0 rotate <0, 22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      box { <-42, 362*BHeight, -230>, <42, 375*BHeight, -150> }
      texture { T_Skifer }
   }   
   object { Window3 translate <0, 275*BHeight, 12-215> }
   object { Window4 translate <0, 303*BHeight, 12-203> }
   box { <-36, -1, -6>, <36, 0, 15> rotate <-30, 0, 0> translate <0, 302*BHeight, -203> texture { T_Skifer } }
   box { <-42, 0, -6>, <42, 3, 30> rotate <30, 0, 0> translate <0, 362*BHeight, -215> texture { T_Skifer } }
   cylinder { <-50, 370*BHeight, -195>, <50, 370*BHeight, -195>, 2 texture { pigment { Black } } }
   texture { T_Brick translate <1000, 700, 0> }
}

   
#local OctoCornerProfil=union {
   difference { 
      box { <0, 0, 0>, <1, 127.6518, 63> }
      plane { z, 0 rotate <11.2948, 0, 0> }
   }
   cylinder { <0, 115.9003, 84.3333>, <1, 115.9003, 84.3333>, 60 }
   difference {
      box { <0, 150.3149, 35.1842>, <1, 190, 63> }
      plane { z, 0 rotate <35, 0, 0> translate <0, 150.3149, 35.1842> }
   }      
}

#local OctoCorner=union {
   difference {
      object { OctoCornerProfil scale <126, 1, 1> }
      plane {-x, 0 rotate <0, -45, 0> translate <125.9441, 0, 0> }
   }   
   difference {
      object { OctoCornerProfil scale <126, 1, 1> }
      plane {-x, 0 rotate <0, -45, 0> translate <125.9441, 0, 0> }
      scale <-1, 1, 1> rotate <0, -90, 0> translate <125.9441, 0, 125.9441> 
   }
   translate <-125.9441, 0, 0>                                                                       
   texture { T_Sandstone }
}
   

#local OctoTower=union{                                                    
// Square base
   difference {
      box { <-215, 0, -215>, <215, 105*BHeight, 215> }
      object { Window1Cutout translate <0, 67*BHeight, 0> }
      object { Window1Cutout rotate <0, 90, 0> translate <0, 67*BHeight, 0> }
      texture { T_Brick translate <6, 0, 6> } 
   }                                                
   #local ang = 0;
   #while (ang < 200)
      object { Window1 translate <0, 67*BHeight, -212> rotate <0, ang, 0> }
      #local ang = ang + 90;
   #end   
   box { <-48, -1, -6>, <48, 0, 10> rotate <-30, 0, 0> translate <0, 67*BHeight, -215> texture { T_Skifer } }
   #local ang = 0;
   #while (ang < 360)
      object { OctoCorner translate <215, 105*BHeight, -215> rotate <0, ang, 0> }
      #local ang = ang + 90;
   #end   
// Octogonal part
   #local ang = 0;
   #while (ang < 360)
      object { OctoWall1 rotate <0, ang, 0> }
      object { OctoWall2 rotate <0, ang+45, 0> }
      #local ang = ang + 90;
   #end
// Gesimskant
   box { <-221, 47*BHeight, -221>, <221, 51*BHeight, 221> texture { T_Brick } }
   #local ang = 0;
   #while(ang < 360)
      difference {
         box { <-227, 51*BHeight, -227>, <227, 52*BHeight, -215> }
         plane {-y, 0 rotate <-30, 0, 0> translate<0, 52*BHeight, -215> }  
         plane { x, 0 rotate <0,  45, 0> }
         plane {-x, 0 rotate <0, -45, 0> }
         rotate <0, ang, 0>
         texture { T_Skifer } 
      }
      #local ang = ang + 90;
   #end   
}
                    
/*----- Cylinderical Part -----*/

#local CylTowerLayer=union{
   #local ang = 0;
   #while (ang < 360)
      box { <-11.25, 0, -122.25>, <11.25, BHeight-BMortar, -100> rotate <0, ang, 0> }
      #local ang = ang + 360/32;
   #end   
}

#local CylTowerLayerWindow1=difference{
   union{
      #local ang = 0;
      #while (ang < 360)
         box { <-11.25, 0, -122.25>, <11.25, BHeight-BMortar, -100> rotate <0, ang, 0> }
         #local ang = ang + 360/32;
      #end   
   }
   box { <-6, -1, 0>, <6, 8, -150> }
}    

#local CylTowerLayerWindow2=difference{
   union{
      #local ang = 0;
      #while (ang < 360)
         box { <-11.25, 0, -122.25>, <11.25, BHeight-BMortar, -100> rotate <0, ang, 0> }
         #local ang = ang + 360/32;
      #end   
      rotate <0, 360/64, 0> 
   }
   box { <-6, -1, 0>, <6, 8, -150> }
}

#local CylTowerLayer2=union{
   #local ang = 0;
   #while (ang < 360)
      box { <-11.25, 0, -129.87>, <11.25, BHeight-BMortar, -100> rotate <0, ang, 0> }
      #local ang = ang + 360/34;
   #end   
}

#local CylTowerGesims=union{
   cylinder { <0, 0, 0>, <0, 7, 0>, 125.25 }
   cylinder { <0, 7, 0>, <0, 14, 0>, 128.25 }
   difference {
      torus { 122.25+3.4378, 9.8995 translate <0, 23.5622, 0> }
      plane {-y, 0 translate <0, 21, 0> }
   }   
   difference {
      cylinder { <0, 21, 0>, <0, 28, 0>, 142.25 }
      torus { 122.25+22.5622, 9.8995 translate <0, 18.4378, 0> }
   }   
   cylinder { <0, 28, 0>, <0, 30, 0>, 142.25 }
   texture { T_Sandstone }
}

#local CylTowerTopCutout=difference{
   union{
      cone { <0, 0, 0>, 122.26, <0, -9.287*BHeight, 0>, 0 }
      cylinder { <0, 0, 0>, <0, 11*BHeight, 0>, 130 }
   }
   plane { x, 0 rotate <0,  20, 0> }   
   plane {-x, 0 rotate <0, -20, 0> }   
}

#local CylTowerTopSkifer=difference{
   union {
      cone { <0, 3.5, 0>, 128.25, <0, -9.287*BHeight, 0>, 0 }
      cylinder { <0, 3.5, 0>, <0, 6, 0>, 128.26 }
   }   
   cone { <0, 3.5, 0>, 128.26, <0, -9.287*BHeight, 0>, 0 translate <0, 3, 0> }
   cylinder { <0, -10*BHeight, 0>, <0, BHeight, 0>, 95 }  
   plane { x, 0 rotate <0,  20, 0> }   
   plane {-x, 0 rotate <0, -20, 0> }   
   texture { T_Skifer }
}  
                                                                                                                      
#local CylTower=union {
// Mortar               
   difference {
      cylinder { <0, 0, 0>, <0, 380*BHeight, 0>, 122.25 }
      cylinder { <0, 351*BHeight, 0>, <0, 381*BHeight, 0>, 102 }  
      cone { <0, 380*BHeight+0.1, 0>, 122.26, <0, (380-9.287)*BHeight, 0>, 0 }
      object { CylTowerTopCutout scale <1.002, 1, 1> translate <0, 370*BHeight, 0> rotate <0,  45, 0> }
      object { CylTowerTopCutout scale <1.002, 1, 1> translate <0, 370*BHeight, 0> rotate <0, 135, 0> }
      object { CylTowerTopCutout scale <1.002, 1, 1> translate <0, 370*BHeight, 0> rotate <0, 225, 0> }
      object { CylTowerTopCutout scale <1.002, 1, 1> translate <0, 370*BHeight, 0> rotate <0, 315, 0> }
      object { WindowC1Cutout translate <0,  92*BHeight, 0> }
      object { WindowC2Cutout translate <0, 144*BHeight, 0> }
      object { WindowC2Cutout translate <0, 194*BHeight, 0> }
      object { WindowC2Cutout translate <0, 244*BHeight, 0> }
      object { WindowC2Cutout translate <0, 294*BHeight, 0> }
      object { WindowC2Cutout rotate <0, 180, 0> translate <0,  32*BHeight, 0> }
      object { WindowC2Cutout rotate <0, 180, 0> translate <0,  72*BHeight, 0> }
      object { WindowC2Cutout rotate <0, 180, 0> translate <0, 114*BHeight, 0> }
      object { WindowC2Cutout rotate <0, 180, 0> translate <0, 164*BHeight, 0> }
      object { WindowC2Cutout rotate <0, 180, 0> translate <0, 214*BHeight, 0> }
      object { WindowC2Cutout rotate <0, 180, 0> translate <0, 264*BHeight, 0> }
      object { WindowC2Cutout rotate <0, 180, 0> translate <0, 310*BHeight, 0> }
      texture { T_Mortar } 
   }   
// Bricks
   #local pos = 0;
   #while(pos < 32)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end              
   #local pos = 32;
   #while(pos < 42)
      object { CylTowerLayerWindow1 rotate <0, 180, 0> translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 rotate <0, 180, 0> translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 42;
   #while(pos < 72)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }      
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end              
   #local pos = 72;
   #while(pos < 82)
      object { CylTowerLayerWindow1 rotate <0, 180, 0> translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 rotate <0, 180, 0> translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 82;
   #while(pos < 92)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end              
   #local pos = 92;
   #while(pos < 106)
      object { CylTowerLayerWindow1 translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 106;
   #while(pos < 114)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end
   #local pos = 114;
   #while(pos < 124)
      object { CylTowerLayerWindow1 rotate <0, 180, 0> translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 rotate <0, 180, 0> translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 124;
   #while(pos < 144)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end
   #local pos = 144;
   #while(pos < 154)
      object { CylTowerLayerWindow1 translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 154;
   #while(pos < 164)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end
   #local pos = 164;
   #while(pos < 174)
      object { CylTowerLayerWindow1 rotate <0, 180, 0> translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 rotate <0, 180, 0> translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 174;
   #while(pos < 194)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end
   #local pos = 194;
   #while(pos < 204)
      object { CylTowerLayerWindow1 translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 204;
   #while(pos < 214)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end
   #local pos = 214;
   #while(pos < 224)
      object { CylTowerLayerWindow1 rotate <0, 180, 0> translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 rotate <0, 180, 0> translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 224;
   #while(pos < 244)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end
   #local pos = 244;
   #while(pos < 254)
      object { CylTowerLayerWindow1 translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 254;
   #while(pos < 264)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end
   #local pos = 264;
   #while(pos < 274)
      object { CylTowerLayerWindow1 rotate <0, 180, 0> translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 rotate <0, 180, 0> translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 274;
   #while(pos < 294)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end
   #local pos = 294;
   #while(pos < 304)
      object { CylTowerLayerWindow1 translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 304;
   #while(pos < 310)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end
   #local pos = 310;
   #while(pos < 320)
      object { CylTowerLayerWindow1 rotate <0, 180, 0> translate <0, pos*BHeight, 0> }
      object { CylTowerLayerWindow2 rotate <0, 180, 0> translate <0, (pos+1)*BHeight, 0>}
      #local pos = pos + 2;
   #end
   #local pos = 320;
   #while(pos < 370)
      object { CylTowerLayer translate <0, pos*BHeight, 0> }
      object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
      #local pos = pos + 2;
   #end

   difference {
      union{
         #local pos = 370;
         #while(pos < 380)
            object { CylTowerLayer translate <0, pos*BHeight, 0> }
            object { CylTowerLayer translate <0, (pos+1)*BHeight, 0> rotate <0, 360/64, 0> }
            #local pos = pos + 2;
         #end
      }   
      cone { <0, 380*BHeight+0.1, 0>, 122.26, <0, (380-9.287)*BHeight, 0>, 0 }
      object { CylTowerTopCutout translate <0, 370*BHeight, 0> rotate <0,  45, 0> }
      object { CylTowerTopCutout translate <0, 370*BHeight, 0> rotate <0, 135, 0> }
      object { CylTowerTopCutout translate <0, 370*BHeight, 0> rotate <0, 225, 0> }
      object { CylTowerTopCutout translate <0, 370*BHeight, 0> rotate <0, 315, 0> }
   }  
   difference {
      union {
         cone { <0, 380*BHeight+3.5, 0>, 128.25, <0, (380-9.287)*BHeight, 0>, 0 }
         cylinder { <0, 380*BHeight+3.5, 0>, <0, 380*BHeight+6, 0>, 128.26 }
      }   
      cone { <0, 380*BHeight+3.5, 0>, 128.26, <0, (380-9.287)*BHeight, 0>, 0 translate <0, 3, 0> }
      cylinder { <0, 370*BHeight, 0>, <0, 381*BHeight, 0>, 95 }  
      object { CylTowerTopCutout translate <0, 370*BHeight, 0> rotate <0,  45, 0> }
      object { CylTowerTopCutout translate <0, 370*BHeight, 0> rotate <0, 135, 0> }
      object { CylTowerTopCutout translate <0, 370*BHeight, 0> rotate <0, 225, 0> }
      object { CylTowerTopCutout translate <0, 370*BHeight, 0> rotate <0, 315, 0> } 
      texture { T_Skifer }
   }  
   object { CylTowerTopSkifer translate <0, 370*BHeight, 0> rotate <0,  45, 0> }
   object { CylTowerTopSkifer translate <0, 370*BHeight, 0> rotate <0, 135, 0> }
   object { CylTowerTopSkifer translate <0, 370*BHeight, 0> rotate <0, 225, 0> }
   object { CylTowerTopSkifer translate <0, 370*BHeight, 0> rotate <0, 315, 0> }
// Gesimskant
   cylinder { <0, 47*BHeight, 0>, <0, 51*BHeight-BMortar, 0>, 129.87 texture { T_Mortar } }
   #local pos = 47*BHeight;
   #while(pos < 51*BHeight)
      object { CylTowerLayer2 translate <0, pos, 0> }
      object { CylTowerLayer2 translate <0, pos+BHeight, 0> rotate <0, 360/68, 0> }
      #local pos = pos + 2*BHeight;
   #end      
   cone{ <0, 51*BHeight-BMortar, 0>, 134, <0, 52*BHeight, 0>, 122 texture { T_Skifer } }
   object { CylTowerGesims translate <0, 343*BHeight, 0> }
   
   object { WindowC1 translate <0,  92*BHeight, -120> }
   object { WindowC2 translate <0, 144*BHeight, -120> }
   object { WindowC2 translate <0, 194*BHeight, -120> }
   object { WindowC2 translate <0, 244*BHeight, -120> }
   object { WindowC2 translate <0, 294*BHeight, -120> }
   object { WindowC2 rotate <0, 180, 0> translate <0,  32*BHeight, 120> }
   object { WindowC2 rotate <0, 180, 0> translate <0,  72*BHeight, 120> }
   object { WindowC2 rotate <0, 180, 0> translate <0, 114*BHeight, 120> }
   object { WindowC2 rotate <0, 180, 0> translate <0, 164*BHeight, 120> }
   object { WindowC2 rotate <0, 180, 0> translate <0, 214*BHeight, 120> }
   object { WindowC2 rotate <0, 180, 0> translate <0, 264*BHeight, 120> }
   object { WindowC2 rotate <0, 180, 0> translate <0, 310*BHeight, 120> }
   torus { 110, 2 translate <0, 379*BHeight, 0> texture { pigment { Black } } }
   texture { T_Brickcolor }                                        
   translate <300, 0, 0>   
}
   
/*********************** Assembled Building ****************************/

#declare Perrotts=union{
   object { OctoTower }
   object { CylTower } 
}
   