/************************************************************************* 

testSnowflakes.pov

Author: Gennady Obukhov 
obukhov@mail.com 
http://propro.ru/go/
date: November 1 2002
Walnut Creek, California

*************************************************************************/ 

#include "snowflakes.inc"

camera{
	orthographic
	location <(11*1.7)/2, -(8*1.7)/2, -16> 
	look_at <(11*1.7)/2, -(8*1.7)/2, 0> 
}

#declare numX = 12;
#declare numY = 9;
#declare cntX = 0;
#declare cntY = 0;
#while(cntY < numY)     
	#local cntX = 0;
	#while(cntX < numX)
		#local counter = (numX * cntY) + cntX;
		union {     
			object{Snowflakes[counter]}
			text {
				ttf "c:\windows\fonts\Verdanab.ttf" str(counter, 0, 0) 0.01, 0 
				pigment {color rgb 1}
				finish{ambient 2 phong 0} 
				no_shadow 
				scale 0.2
				translate <-0.1, -0.8, 0>
			}
			translate<cntX * 1.7, -cntY * 1.7, 0>
		}
		#local cntX = cntX + 1;
	#end               
	#local cntY = cntY + 1;
#end

background{color rgb<0, 0.2, 0.4>}