#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"
#include "metals.inc"
#include "glass.inc"
#include "skies.inc"
#include "woods.inc"

#version 3.1;
global_settings { assumed_gamma 2.2 }

#declare R = seed(0);

/************************* Declarations ******************************/

/*------------------------ Control Flags ----------------------------*/

#declare ShowDetail = 1;
#declare ShowGlass  = 0;

// Cam 1 = TestCam
// Cam 2 = FrontCam
// Cam 3 = CornerCam
// Cam 4 = Corner2Cam
// Cam 5 = Mur4Cam
// Cam 6 = Mur5Cam
#declare Cam = 5; 

//#declare imageratio = <4/3, 0, 0>;
#declare imageratio = <3/2, 0, 0>;                                            

/*--------------------- Camera and Lights ---------------------------*/

#declare CamPos = <1000, 1700, 3590>;

#declare TestCam=camera {
   location  CamPos
   angle 30
   right imageratio
   look_at   <1000, 1700,  2590 >
}

#declare FrontCamPos = <1227, 1000, -3500>; 

#declare FrontCam=camera {
   location  FrontCamPos
   angle 45
   right imageratio
   look_at   <1227, 1000,  0 >
}

#declare CornerCamPos = <-2600, 170, -1800>;

#declare CornerCam=camera {
   location  CornerCamPos
   angle 41
   right imageratio
   look_at   <300, 970,  500 >
}

#declare Corner2CamPos = <-2000, 170, 4000>;

#declare Corner2Cam=camera {
   location  Corner2CamPos
   angle 38
   right imageratio
   look_at   <150, 750,  2000 >
}

#declare Mur4CamPos = <-2000, 170, 6500>;

#declare Mur4Cam=camera {
   location  Mur4CamPos
   angle 52
   right imageratio
   look_at   <1025, 900,  3500 >
}

#declare Mur5CamPos = <3144, 670, 9000>;

#declare Mur5Cam=camera {
   location  Mur5CamPos
   angle 40
   right imageratio
   look_at   <3144, 670,  4440 >
}

#declare MainLight=light_source { <0, 0, 0>, colour White*1.5}
#declare CamLight=light_source { <0, 0, 0>, colour White*0.5 }

#declare AreaLight=light_source {
   <0, 0, 0> colour White
   area_light <150, 0, 0>, <0, 100, 100>, 12, 12
   adaptive 0
   jitter
}               

/*------------------------- Objects ----------------------------------*/

#include "Bygning4.inc"     

/***************************** Scene *********************************/

/*--------------- Camera, Lights and Background ---------------------*/

#switch(Cam)
   #case (1)
      camera { TestCam }
      object { MainLight translate <-50000, 30000, 50000> }
      object { MainLight translate < 50000, 30000, 50000> }
      object { CamLight translate CamPos }
      #break   
   #case (2)
      camera { FrontCam }
      object { MainLight translate <30000, 50000, -35000> }
      object { CamLight translate FrontCamPos }
      #break   
   #case (3)
      camera { CornerCam }
      object { MainLight translate <-50000, 50000, -35000> }
      object { CamLight translate CornerCamPos }
      #break   
   #case (4)
      camera { Corner2Cam }
      object { MainLight translate <-50000, 50000, 35000> }
      object { CamLight translate Corner2CamPos }
      #break   
   #case (5)
      camera { Mur4Cam }
      object { MainLight translate <-50000, 50000, 70000> }
      object { CamLight translate Mur4CamPos }
      #break   
   #case (6)
      camera { Mur5Cam }
      object { MainLight translate <50000, 30000, 50000> }
      object { CamLight translate Mur5CamPos }
      #break   
   #else
      camera { TestCam }
      object { MainLight translate <-50000, 50000, -30000> }
      object { CamLight translate CamPos }
#end


#if(ShowDetail = 1)
   sky_sphere { S_Cloud1 }
#else
   background { Blue }
#end

difference {
   plane { y, 0 }
   box { <1, -30, 0>, <2100, 1, 1000> }
   texture { pigment { Gray30 } } 
}

/*------------------------- Objects ----------------------------------*/

object { Bygning4 }   
