/*-------------------------- Constants ------------------------------*/

#local BHeight=  6.65;
#local BWidth=  24.00;
#local BMortar=  1.00;

/*-------------------------- Textures -------------------------------*/

#local T_Malet=texture {
   pigment { rgb <0.79, 0.77, 0.73> }
}

#local T_MaletStucco=texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.0,  0.2     color rgb <0.79, 0.77, 0.73>
                     color rgb <0.79, 0.77, 0.73>]
      [0.2,  0.4     color rgb <0.66, 0.66, 0.66>
                     color rgb <0.79, 0.77, 0.73>]
      [0.4,  0.55    color rgb <0.79, 0.77, 0.73>
                     color rgb <0.68, 0.68, 0.68>]
      [0.55, 0.7     color rgb <0.68, 0.68, 0.68>
                     color rgb <0.79, 0.77, 0.73>]
      [0.7,  1.001   color rgb <0.79, 0.77, 0.73>
                     color rgb <0.50, 0.50, 0.50>]
    }
    scale 30
  }
  normal { bumps 0.5 }
}

#local T_DoerWood=texture {
   T_Wood27 rotate <88, 0, 0> scale 50
}

#local T_Granit=texture {
  pigment{
    color rgb <0.5, 0.5, 0.5>
  }
}
texture{
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.0,  0.2     color rgbf <0.10, 0.10, 0.10, 0>
                     color rgbf <0.10, 0.10, 0.10, 0>]
      [0.2,  0.4     color rgbf <0.769, 0.686, 0.592, 0.792>
                     color rgbf <0.843, 0.753, 0.718, 0.396>]
      [0.4,  0.55    color rgbf <0.843, 0.753, 0.718, 0.396>
                     color rgbf <0.780, 0.667, 0.561, 0.976>]
      [0.55, 0.7     color rgbf <0.780, 0.667, 0.561, 0.976>
                     color rgbf <0.741, 0.659, 0.576, 0.820>]
      [0.7,  1.001   color rgbf <0.741, 0.659, 0.576, 0.820>
                     color rgbf <0.190, 0.102, 0.051, 0>]
    }
  }
  scale 3
  rotate <0, 0, -30>
}

#local T_Sokkel=texture {
    brick
    texture { pigment { Gray80 } },
    texture { T_Granit scale 0.6 translate <-500, 0, 0> }
    brick_size <145, 1000, 145>
    mortar 1
    translate <0, -100, -100>
}

#local T_Mortar=texture {
   pigment { granite
      turbulence 0.6
      color_map{
	  [0.000, 0.154   color rgbf <0.6, 0.6, 0.466, 0.000>
			            color rgbf <0.6, 0.6, 0.577, 0.000>]
	  [0.154, 0.300   color rgbf <0.6, 0.6, 0.6, 0.000>
			            color rgbf <0.6, 0.6, 0.466, 0.000>]
	  [0.300, 0.320   color rgbf <0.4, 0.4, 0.5, 0.000>
			            color rgbf <0.5, 0.5, 0.6, 0.000>]
	  [0.320, 0.615   color rgbf <0.6, 0.6, 0.6, 0.000>
			            color rgbf <0.6, 0.6, 0.466, 0.000>]
	  [0.615, 0.812   color rgbf <0.6, 0.6, 0.466, 0.000>
		               color rgbf <0.6, 0.6, 0.577, 0.000>]
	  [0.812, 1.001   color rgbf <0.6, 0.6, 0.6, 0.000>
		               color rgbf <0.1, 0.1, 0.1, 0.000>]
      }
   }
   scale <3, 3, 3>
}

#local T_B4Brickcolor=texture {
   pigment { bozo
      turbulence 1.0
      color_map{
	  [0.0, 0.4   color rgbf <0.40, 0.15, 0.08, 0.0>
		           color rgbf <0.60, 0.27, 0.18, 0.0>]
	  [0.6, 1.001 color rgbf <0.60, 0.27, 0.18, 0.0>
		           color rgbf <0.40, 0.15, 0.08, 0.0>]
      }
   }
   scale <17, 20, 15>
}

#local T_B4Brick=texture {
   brick texture {T_Mortar}, texture {T_B4Brickcolor}
   brick_size <BWidth, BHeight, BWidth>
   mortar BMortar
}

#local T_B4Saalbaenkcolor=texture {
   pigment { color rgb <0.45, 0.22, 0.15> }
}

#local B4SaalbaenkMortar=1.16;

#local T_B4Saalbaenk=texture {
   brick texture {T_Mortar}, texture {T_B4Saalbaenkcolor}
   brick_size <BWidth/2, 1000, 1000>
   mortar B4SaalbaenkMortar
}

#local T_Skifer=texture {
#if(ShowDetail = 1)
   pigment { bozo
      turbulence 1.0
      color_map{
	  [0.0, 0.5   color Gray35
		           color Gray45 ]
	  [0.5, 1.001 color Gray45
		           color Gray35 ]
      }
   }
   scale 100
#else
   pigment { Gray40 }
#end
}

#local T_SkiferTag=texture {
   brick texture { pigment { Black } }, texture { T_Skifer }
   brick_size <30, 19, 1000>
   mortar 1
}

#local T_Tagsten=   // to lags texture
texture {
   pigment {
    gradient x
      color_map{
         [0.000, 0.5 color rgb <0.10, 0.10, 0.10>
                     color rgb <0.30, 0.30, 0.30>]
         [0.5, 1.001 color rgb <0.30, 0.30, 0.30>
                     color rgb <0.10, 0.10, 0.10>]
      }
      sine_wave
   }
   scale <24, 1, 1>
}
texture {
   pigment{ gradient y
      color_map{
         [0.000, 0.8 color rgbt <0.0, 0.0, 0.0, 1>
                     color rgbt <0.0, 0.0, 0.0, 1>]
         [0.8, 1.001 color rgbt <0.0, 0.0, 0.0, 1>
                     color rgb <0.00, 0.00, 0.00>]
      }
      scale <1, 24, 1>
   }
}

#local T_Rygning=texture {
   T_Tagsten rotate <90, 0, 0> scale <2, 1, 1.2>
}

#local T_Sandstone=texture {
   pigment { granite
      turbulence 0.6
      color_map{
	  [0.000, 0.154   color rgb <0.62, 0.62, 0.57>
			            color rgb <0.62, 0.62, 0.60>]
	  [0.154, 0.300   color rgb <0.62, 0.62, 0.62>
			            color rgb <0.62, 0.62, 0.49>]
	  [0.300, 0.320   color rgb <0.57, 0.57, 0.37>
			            color rgb <0.55, 0.55, 0.55>]
	  [0.320, 0.615   color rgb <0.62, 0.62, 0.62>
	                  color rgb <0.62, 0.62, 0.52>]
	  [0.615, 0.812   color rgb <0.62, 0.62, 0.52>
			            color rgb <0.62, 0.62, 0.61>]
	  [0.812, 1.001   color rgb <0.62, 0.62, 0.62>
			            color rgb <0.10, 0.10, 0.10>]
      }
   }
   scale 10
}

#local T_Zink=texture {
   pigment { Gray50 }
}

#local T_LinedZink=texture {
   pigment{ gradient y
      color_map{
         [0.000, 0.980 color rgb <0.50, 0.50, 0.50>
                       color rgb <0.50, 0.50, 0.50>]
         [0.980, 1.001 color rgb <0.50, 0.50, 0.50>
                       color rgb <0.00, 0.00, 0.00>]
      }
      scale <1, 50, 1>
   }
}

#local T_NyZink=texture {
   pigment { Gray80 }
}

#local T_LinedNyZink=texture {
   pigment{ gradient y
      color_map{
         [0.000, 0.990 color rgb <0.60, 0.60, 0.60>
                       color rgb <0.60, 0.60, 0.60>]
         [0.990, 1.001 color rgb <0.60, 0.60, 0.60>
                       color rgb <0.10, 0.10, 0.10>]
      }
      scale <1, 50, 1>
   }
}

#local T_Ir=texture{
   pigment { color rgb <0.64, 0.78, 0.65> }
}

#local T_LinedIr=texture{
   pigment{ gradient y
      color_map{
         [0.000, 0.980 color rgb <0.64, 0.78, 0.65>
                       color rgb <0.65, 0.78, 0.65>]
         [0.980, 1.001 color rgb <0.65, 0.78, 0.65>
                       color rgb <0.22, 0.26, 0.22>]
      }
      scale <1, 84, 1>
   }
}

#local T_DoerIr=texture{
   pigment { color rgb <0.32 0.39, 0.30> }
}

#local T_Galvano =
texture {
   pigment {
   	agate
   	agate_turb 0.75
   	frequency 6
   	scale 0.5
   	rotate <0, -45, 5>
   	color_map {
   	    [0.02 color rgbf <0.65, 0.65, 0.65, 0.0> ]
   	    [0.06 color rgbf <0.75, 0.75, 0.75, 0.0> ]
   	    [0.10 color rgbf <0.80, 0.80, 0.80, 0.0> ]
   	    [1.00 color rgbf <0.75, 0.75, 0.75, 0.0> ]
   	}
   }
   finish { phong 0.9 phong_size 60 metallic }
}
texture {
   pigment {
   	crackle
   	turbulence 0.1
   	lambda 2.5
   	omega 0.75
   	octaves 5
   	scale 0.75
   	frequency 1
   	phase 0.25
   	rotate <0, 45, 60>
   	color_map {
   	    [0.00 color Clear ]
   	    [0.25 color rgbf <0.80, 0.80, 0.80, 0.50> ]
   	    [0.30 color rgbf <0.70, 0.70, 0.70, 0.00> ]
   	    [0.35 color rgbf <0.75, 0.75, 0.75, 0.50> ]
   	    [0.40 color rgbf <0.65, 0.65, 0.65, 0.60> ]
   	    [0.65 color Clear ]
   	}
   }
}
texture {
   pigment {
   	crackle
   	turbulence 0.1
   	lambda 2.5
   	omega 0.75
   	octaves 5
   	scale 0.45
   	frequency 2
   	phase 0.25
   	rotate <0, 5, 60>
   	color_map {
   	    [0.00 color Clear ]
   	    [0.25 color rgbf <0.65, 0.65, 0.65, 0.50> ]
   	    [0.30 color rgbf <0.80, 0.80, 0.80, 0.00> ]
   	    [0.45 color rgbf <0.70, 0.70, 0.70, 0.25> ]
   	    [0.50 color rgbf <0.70, 0.70, 0.70, 0.50> ]
   	    [0.65 color Clear ]
   	}
   }
}

#local T_Jern=texture{
   pigment { Gray25 }
   finish { phong 0.05  phong_size 10}
   normal { bumps 0.1 scale <0.5, 0.5, 1> }
}

#local T_B4Hegn=texture{
   pigment { Gray15 }
   finish { phong 0.15  phong_size 10}
   normal { bumps 0.1 scale <0.5, 0.5, 1> }
}

#local T_Bly=texture{
   pigment { Gray25 }
   finish { phong 0.05  phong_size 10}
   normal { bumps 0.1 scale <0.5, 0.5, 1> }
}


#local T_Rude=texture {
#if (ShowGlass = 1)
   pigment { color rgbf <1, 1, 0.95, 1> }
   finish {
      reflection .5
      specular 0.5
      roughness 0.05
   }
//   normal { bumps 0.03 scale <100, 100, 0.005> }
#else
//   pigment { Clear }
   pigment { Black }
#end
}

#local T_GulRude=texture {
#if (ShowGlass = 1)
   pigment { color rgbf <0.80, 0.61, 0.32, 1> }
   finish {
      ambient 0.1
      diffuse 0.1
      reflection .05
      specular 0.5
      roughness 0.05
   }
   normal { bumps 0.03 scale <1, 1, 0.05> }
#else
   pigment { Black }
#end
}

#local T_RaaGlasRude=texture {
#if (ShowGlass = 1)
   pigment { color rgbf <1, 1, 0.95, 1> }
   finish {
      ambient 0.1
      diffuse 0.1
      reflection .05
      specular 0.5
      roughness 0.05
   }
   normal { bumps 0.03 scale <1, 1, 0.05> }
#else
   pigment { Black }
#end
}

#local T_Stentavle=texture {
#if (ShowDetail = 1)
   pigment { image_map { gif "byg4tavle.gif" once } }
   scale <52, 93, 1>
#else
   pigment { rgb <0.6, 0.6, 0.6> }
#end
}

/*------------------------- Objects ----------------------------------*/

//#include "StM_Skilte.inc"

/*------------------- Deco -----------------------*/

#local B4SaalbaenkProfil=union{
   box { <0, 0, 2>, <1, -3, -25> rotate <-29, 0, 0> }
   box { <0, -BHeight-3, -BWidth/2>, <1, -3*BHeight, -BWidth/2-2> }
}

#local B4Saalbaenk1=object {
   B4SaalbaenkProfil scale <2*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-0.15*BWidth, 0, 0>
}

#local B4Saalbaenk2=object {
   B4SaalbaenkProfil scale <7*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk3=object {
   B4SaalbaenkProfil scale <6.3*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk3A=object {
   B4SaalbaenkProfil scale <6*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk3B=difference { // Fra vindue3 scaleret til 5.50 til murkant
   object { B4SaalbaenkProfil scale <9*BWidth-B4SaalbaenkMortar, 1, 1> translate <-8*BWidth, 0, 0> }
   plane {-x, 0 rotate <0, -45, 0> translate <0, 0, -BWidth/2> }
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
}

#local B4Saalbaenk3C=difference { // Vindue 3 scaleret til 5.4 fra murkant
   object { B4SaalbaenkProfil scale <8.85*BWidth-B4SaalbaenkMortar, 1, 1> translate <-3.2*BWidth, 0, 0> }
   plane { x, 0 rotate <0, 45, 0> translate <-2.2*BWidth, 0, -BWidth/2> }
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
}

#local B4Saalbaenk3D=difference { // Over Vindue 3 scaleret til 5.4+1.15 fra murkant
   object { B4SaalbaenkProfil scale <10*BWidth-B4SaalbaenkMortar, 1, 1> translate <-3.2*BWidth, 0, 0> }
   plane { x, 0 rotate <0, 45, 0> translate <-2.2*BWidth, 0, -BWidth/2> }
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
}

#local B4Saalbaenk4=object {
   B4SaalbaenkProfil scale <8.75*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk4A=difference { // Fra murkant til vindue4 scaleret til 7.75
   object { B4SaalbaenkProfil scale <10.75*BWidth-B4SaalbaenkMortar, 1, 1> translate <B4SaalbaenkMortar/2-2.75*BWidth, 0, 0> }
   plane { x, 0 rotate <0, 45, 0> translate <-2.2*BWidth, 0, -BWidth/2> }
   texture { T_B4Saalbaenk translate <BWidth/2, 10, -100> }
}

#local B4Saalbaenk4B=difference { // Fra vindue4 scaleret til 7.50 til murkant
   object { B4SaalbaenkProfil scale <10.75*BWidth-B4SaalbaenkMortar, 1, 1> translate <B4SaalbaenkMortar/2-9.75*BWidth, 0, 0> }
   plane {-x, 0 rotate <0, -45, 0> translate <0, 0, -BWidth/2> }
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
}

#local B4Saalbaenk5=object {
   B4SaalbaenkProfil scale <11*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk5A=object { // Vindue 5 scaleret til 10.75
   B4SaalbaenkProfil scale <11.25*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk5Altan=object {
   B4SaalbaenkProfil scale <5.375*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk7=object {
   B4SaalbaenkProfil scale <3.9*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk9=object {
   B4SaalbaenkProfil scale <10.25*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk9A=object { // Vindue 9 skaleret til 9
   B4SaalbaenkProfil scale <9.5*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk3x5=object {
   B4SaalbaenkProfil scale <39.5*BWidth-B4SaalbaenkMortar, 1, 1>
   texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
   translate <B4SaalbaenkMortar/2-BWidth/4, 0, 0>
}

#local B4Saalbaenk7Gavl=object {
   box { <0, 0, -4>, <3.25*BWidth, -2, 15> rotate <-25, 0, 0> }
   texture { T_Skifer }
}

#local B4TagGesimsprofil=union{
   difference {
      box { <0, 0, 0>, <1, BHeight, -BHeight> }
      cylinder { <-0.1, 0, -BHeight>, <1.1, 0, -BHeight>, 5 }
   }
   cylinder { <0, 2*BHeight, -BHeight>, <1, 2*BHeight, -BHeight>, BHeight }
   box { <0, 2*BHeight, 0>, <1, 4*BHeight, -4*BHeight> }
   box { <0, 4*BHeight, 0>, <1, 6*BHeight, -5*BHeight> }
}

#local B4TagGesimsprofilA=union{ // For "Trn" p mur3
   box { <0, -4*BHeight, -1>, <1, -2.5*BHeight, 0> }
   cylinder { <0, -3.25*BHeight, -1>, <1, -3.25*BHeight, -1>, 4 }
   difference {
      box { <0, 0, 0>, <1, BHeight, -BHeight> }
      cylinder { <-0.1, 0, -BHeight>, <1.1, 0, -BHeight>, 5 }
   }
   cylinder { <0, 2*BHeight, -BHeight>, <1, 2*BHeight, -BHeight>, BHeight }
   box { <0, 2*BHeight, 0>, <1, 4*BHeight, -4*BHeight> }
   box { <0, 4*BHeight, 0>, <1, 6*BHeight, -5*BHeight> }
}

#local B4MansardGesimsprofil=union{
   difference {
      box { <0, 0, 0>, <1, 7, -7> }
      cylinder { <-0.1, 0, -7>, <1.1, 0, -7>, 5 }
   }
   difference {
     cylinder { <0, 20, -7>, <1, 20, -7>, 13 }
     plane {-y, 0 translate <0, 20, 0> }
   }
   box { <0, 18, 0>, <1, 20, -20> }
   scale <1, 1, 0.5>
}

#local B4Rygningprofil=difference {
   cylinder { <0, 0, 0>, <0, 0, 1>, 10 }
   cylinder { <0, 0, -0.1>, <0, 0, 1.1>, 9 }
   plane { y, 0 }
//   scale <1, 0.5, 1>
}

#local B4Tagrendeprofil=union{
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 7 }
      cylinder { <-0.1, 0, 0>, <1.1, 0, 0>, 6.9 }
      plane {-y, 0 }
   }
   cylinder { <0, 0, -7.4>, <1, 0, -7.4>, 0.5 }
   translate <0, 0, -7>
}

#local B4TagrendeEnde=difference {
   cylinder { <-1, 0, 0>, <1, 0, 0>, 7.5 }
   plane {-y, 0 }
   translate <0, 0, -7>
   texture { T_Zink }
}

#local B4Nedloeb=union {
   cylinder { <0, -4, -40>, <0, -15, -40>, 5 }
   difference {
      torus { 5, 5 rotate <0, 0, 90> }
      plane { y, 0 rotate <-45, 0, 0> }
      plane {-y, 0 }
      translate <0, -15, -35>
   }
   cylinder { <0, 0, -5>, <0, -38.2843, -5>, 5 texture { T_LinedZink translate <0, 40, 0> } rotate <-45, 0, 0> translate <0, -15, -35> }
   difference {
      torus { 5, 5 rotate <0, 0, 90> }
      plane {-y, 0 rotate <-45, 0, 0> }
      plane { y, 0 }
      translate <0, -49.1421, -15>
   }
   cylinder { <0, -49.1421, -10>, <0, -1700, -10>, 5 }
   translate <0, 207*BHeight, 0>
   texture { T_LinedZink }
}

#local B4Mur3Gesimsprofil=union{
   difference {
      box { <0, 0, 0>, <1, 8, -6> }
      cylinder { <-0.1, 0, -7>, <1.1, 0, -7>, 5 }
   }
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 9 scale <1, 1, 5/9> translate <0, 16, -6> }
      plane { -y, 0 translate <0, 16, 0> }
   }
   box { <0, 16, 0>, <1, 20, -13> }
}

#local B4Mur3Kobberprofil=difference {
   box { <0, -2, 0>, <1, 100, -30> }
   cylinder { <-0.1, 0, 0>, <1.1, 0, 0>, 35 scale <1, 102/35, 1> translate <0, 100, -35> }
}

#local B4Mur3Kobberprofil2=difference {
   box { <0, -2, 0>, <1, 100, -31> }
   cylinder { <-0.1, 0, 0>, <1.1, 0, 0>, 32 scale <1, 99/32, 1> translate <0, 100, -35> }
}

#local B4Mur3Kobberprofil3=difference {
   box { <0, 0, -9>, <1, 25, 15> }
   plane {-y, 0 rotate <-45, 0, 0> translate <0, 7, -9> }
}

#local B4Mur3Taarnprofil=union{
   difference {
      box { <-0.5, 0, 0>, <0.5, 75.193, -314> }
      cylinder { <-1, 100, -389>, <1, 100, -389>, 125 }
   }
   difference {
      box { <-0.5, 75.193, 0>, <0.5, 149.92, -267> }
      plane { z, 0 rotate <11.4467, 0, 0> translate <0, 75.193, -266.4863> }
   }
   cylinder { <-0.5, 135.1291, -101.3061>, < 0.5, 135.1291, -101.3061>, 150 }
   difference {
      box { <-0.5, 236.8266, 0>, <0.5, 366.8464, -202> }
      plane { z, 0 rotate <42.6863, 0, 0> translate <0, 247.2404, -201.9625> }
   }
   difference {
      box { <-0.5, 366.8464, 0>, <0.5, 472.746, -92> }
      cylinder { <-1, 502.4432, -238.6619>, <1, 502.4432, -238.6619> 200 }
   }
   difference {
      box { <-0.5, 472.746, 0>, <0.5, 745, -41> }
      plane { z, 0 rotate <8.539, 0, 0> translate <0, 472.746, -40.879> }
   }
}

/*------------------- Vinduer -----------------------*/

#local B4VindueKarmprofil=union{
   cylinder { <0, 0, -3>, <1, 0, -3>, 5 }
   box { <0, 0, 0>, <1, -11, -3> }
}

#local B4KaelderVindue=union{
   difference {
      box { <0, 0, 0>, <3.6*BWidth, 7.5*BHeight, 20> }
      box { <6, 6, -1>, <3.6*BWidth-6, 7.5*BHeight-6, 21> }
   }
   difference {
      box { <6, 6, 8>, <3.6*BWidth-6, 7.5*BHeight-6, 10> }
      box { <10, 10, 7>, <3.6*BWidth-10, 7.5*BHeight-10, 11> }
   }
   box { <1.8*BWidth-2, 6, 8>, <1.8*BWidth+2, 7.5*BHeight-6, 10> }

   box { <6, 6, 10>, <3.6*BWidth-6, 7.5*BHeight-6, 10.3> texture { T_Rude } }

   texture { pigment { rgb <0, 0.15, 0> } }
}

#local B4Vindue1=union{
   difference {
      box { <0, 0, 0>, <1.75*BWidth, 9.5*BHeight, 10> }
      box { <5, 9, -1>, <1.75*BWidth-5, 9.5*BHeight-5, 11> }
   }
   box { <5, 9, 2>, <1.75*BWidth-5, 9.5*BHeight-5, 2.3> texture { T_GulRude } }
   texture { pigment { White } }
}

#local B4Vindue2=union{
   difference {
      box { <0, 0, 0>, <2.75*BWidth, 20*BHeight, 10> }
      box { <11, 11, -1>, <2.75*BWidth-11, 20*BHeight-11, 11> }
   }
   box { <11, 10*BHeight-1.5, 0>, <2.75*BWidth-11, 10*BHeight+1.5, 2> }
   box { <11, 11, 1>, <2.75*BWidth-11, 20*BHeight-11, 1.3> texture { T_RaaGlasRude } }
   texture { pigment { White } }
}

#local B4Vindue3=union{ // 2-fag
   difference {
      box { <0, 0, 0>, <5.8*BWidth, 27*BHeight, 10> }
      box { <20, 13, -1>, <5.8*BWidth-20, 27*BHeight-20, 11> }
   }
   box { <2.9*BWidth-9, 10, 0>, <2.9*BWidth+9, 27*BHeight-20, 10> }
   box { <20, 17*BHeight-18, 0>, <5.8*BWidth-20, 17*BHeight, 10> }

   difference {
      object { B4VindueKarmprofil scale <5.8*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      plane {-x, 0 rotate <0, 0, -45> translate <5.8*BWidth, 0, 0> }
      translate <0, 27*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <28*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      rotate <0, 0, -90> translate <5.8*BWidth, 27*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <28*BHeight, 1, 1> translate <-28*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <0, 27*BHeight, 0>
   }

   box { <20, 10, 1>, <5.8*BWidth-20, 27*BHeight-20, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue4=union{ // 3-fag
   difference {
      box { <0, 0, 0>, <8.25*BWidth, 27*BHeight, 10> }
      box { <20, 13, -1>, <8.25*BWidth-20, 27*BHeight-20, 11> }
   }
   box { <2.9*BWidth-9, 10, 0>, <2.9*BWidth+9, 27*BHeight-20, 10> }
   box { <5.35*BWidth-9, 10, 0>, <5.35*BWidth+9, 27*BHeight-20, 10> }
   box { <20, 17*BHeight-18, 0>, <8.25*BWidth-20, 17*BHeight, 10> }

   difference {
      object { B4VindueKarmprofil scale <8.25*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      plane {-x, 0 rotate <0, 0, -45> translate <8.25*BWidth, 0, 0> }
      translate <0, 27*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <28*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      rotate <0, 0, -90> translate <8.25*BWidth, 27*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <28*BHeight, 1, 1> translate <-28*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <0, 27*BHeight, 0>
   }

   box { <20, 10, 1>, <8.25*BWidth-20, 27*BHeight-20, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue4Bue=union{ // 3-fag med buetop
   difference {
      box { <0, 0, 0>, <8.25*BWidth, 23.75*BHeight, 10> }
      box { <20, 13, -1>, <8.25*BWidth-20, 24*BHeight, 11> }
   }
   difference {
      cylinder { <4.125*BWidth, -6.365*BHeight,  0>, <4.125*BWidth, -6.365*BHeight, 10>, 9.8*BWidth }
      cylinder { <4.125*BWidth, -6.365*BHeight, -1>, <4.125*BWidth, -6.365*BHeight, 11>, 9.8*BWidth-20 }
      plane { y, 0 translate <0, 18*BHeight, 0> }
      plane { x, 0 }
      plane {-x, 0 translate <8.25*BWidth, 0, 0> }
   }
   box { <2.9*BWidth-9, 10, 0>, <2.9*BWidth+9, 26*BHeight, 10> }
   box { <5.35*BWidth-9, 10, 0>, <5.35*BWidth+9, 26*BHeight, 10> }
   box { <20, 17*BHeight-18, 0>, <8.25*BWidth-20, 17*BHeight, 10> }

   difference {
      torus { 9.8*BWidth, 5 rotate <90, 0, 0> translate <4.125*BWidth, -6.365*BHeight, -3> }
      plane { y, 0 rotate <0, 0, -33.3739> translate <0, 25.7176*BHeight, 0> }
      plane { y, 0 rotate <0, 0,  33.3739> translate <8.25*BWidth, 25.7176*BHeight, 0> }
   }
   difference {
      cylinder { <4.125*BWidth, -6.365*BHeight, -3>, <4.125*BWidth, -6.365*BHeight, 0>, 9.8*BWidth }
      cylinder { <4.125*BWidth, -6.365*BHeight, -4>, <4.125*BWidth, -6.365*BHeight, 1>, 9.8*BWidth-11 }
      plane { y, 0 rotate <0, 0, -33.3739> translate <0, 25.7176*BHeight, 0> }
      plane { y, 0 rotate <0, 0,  33.3739> translate <8.25*BWidth, 25.7176*BHeight, 0> }
   }
   difference {
      object { B4VindueKarmprofil scale <26.7176*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  33.3739> }
      rotate <0, 0, -90> translate <8.25*BWidth, 25.7176*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <26.7176*BHeight, 1, 1> translate <-26.7176*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -33.3739> }
      rotate <0, 0, 90> translate <0, 25.7176*BHeight, 0>
   }

   box { <20, 10, 1>, <8.25*BWidth-20, 28.5*BHeight-20, 1.3> texture { T_Rude } }

   texture { pigment { White } }
}

#local B4Vindue4BueCutout=union{ // 8.25x23.5 med bue
   box { <0, 17*BHeight, -1>, <8.25*BWidth, 38.5*BHeight, 51> }
   difference {
      cylinder { <4.125*BWidth, 11.635*BHeight, -1>, <4.125*BWidth, 11.635*BHeight, 51>, 9.8*BWidth }
      plane { y, 0 translate <0, 38*BHeight, 0> }
      plane { x, 0 }
      plane {-x, 0 translate <8.25*BWidth, 0, 0> }
   }
}


#local B4Vindue5=union{ // 4-fag
   difference {
      box { <0, 0, 0>, <10.5*BWidth, 27*BHeight, 10> }
      box { <20, 13, -1>, <10.5*BWidth-20, 27*BHeight-20, 11> }
   }
   box { <2.85*BWidth-9, 10, 0>, <2.85*BWidth+9, 27*BHeight-20, 10> }
   box { <5.25*BWidth-9, 10, 0>, <5.25*BWidth+9, 27*BHeight-20, 10> }
   box { <7.65*BWidth-9, 10, 0>, <7.65*BWidth+9, 27*BHeight-20, 10> }
   box { <20, 17*BHeight-18, 0>, <10.5*BWidth-20, 17*BHeight, 10> }

   difference {
      object { B4VindueKarmprofil scale <10.5*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      plane {-x, 0 rotate <0, 0, -45> translate <10.5*BWidth, 0, 0> }
      translate <0, 27*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <28*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      rotate <0, 0, -90> translate <10.5*BWidth, 27*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <28*BHeight, 1, 1> translate <-28*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <0, 27*BHeight, 0>
   }

   box { <20, 10, 1>, <10.5*BWidth-20, 27*BHeight-20, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue5Bue=union{ // 4-fag med buetop
   difference {
      box { <0, 0, 0>, <10.5*BWidth, 23.5*BHeight, 10> }
      box { <20, 13, -1>, <10.5*BWidth-20, 24*BHeight, 11> }
   }
   difference {
      cylinder { <5.25*BWidth, -6.365*BHeight,  0>, <5.25*BWidth, -6.365*BHeight, 10>, 9.8*BWidth }
      cylinder { <5.25*BWidth, -6.365*BHeight, -1>, <5.25*BWidth, -6.365*BHeight, 11>, 9.8*BWidth-20 }
      plane { y, 0 translate <0, 18*BHeight, 0> }
      plane { x, 0 }
      plane {-x, 0 translate <10.5*BWidth, 0, 0> }
   }
   box { <2.85*BWidth-9, 10, 0>, <2.85*BWidth+9, 28*BHeight, 10> }
   box { <5.25*BWidth-9, 10, 0>, <5.25*BWidth+9, 28.5*BHeight, 10> }
   box { <7.65*BWidth-9, 10, 0>, <7.65*BWidth+9, 28*BHeight, 10> }
   box { <20, 17*BHeight-18, 0>, <10.5*BWidth-20, 17*BHeight, 10> }

   difference {
      torus { 9.8*BWidth, 5 rotate <90, 0, 0> translate <5.25*BWidth, -6.365*BHeight, -3> }
      plane { y, 0 rotate <0, 0, -29.5> translate <0, 23.5*BHeight, 0> }
      plane { y, 0 rotate <0, 0,  29.5> translate <10.5*BWidth, 23.5*BHeight, 0> }
   }
   difference {
      cylinder { <5.25*BWidth, -6.365*BHeight, -3>, <5.25*BWidth, -6.365*BHeight, 0>, 9.8*BWidth }
      cylinder { <5.25*BWidth, -6.365*BHeight, -4>, <5.25*BWidth, -6.365*BHeight, 1>, 9.8*BWidth-11 }
      plane { y, 0 rotate <0, 0, -29.5> translate <0, 23.5*BHeight, 0> }
      plane { y, 0 rotate <0, 0,  29.5> translate <10.5*BWidth, 23.5*BHeight, 0> }
   }
   difference {
      object { B4VindueKarmprofil scale <24.5*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  29.5> }
      rotate <0, 0, -90> translate <10.5*BWidth, 23.5*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <24.5*BHeight, 1, 1> translate <-24.5*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -29.5> }
      rotate <0, 0, 90> translate <0, 23.5*BHeight, 0>
   }

   box { <20, 10, 1>, <10.5*BWidth-20, 28.5*BHeight-20, 1.3> texture { T_Rude } }

   texture { pigment { White } }
}


#local B4Vindue5BueCutout=union{ // 10.5x23.5 med bue
   box { <0, 17*BHeight, -1>, <10.5*BWidth, 38.5*BHeight, 51> }
   difference {
      cylinder { <5.25*BWidth, 11.635*BHeight, -1>, <5.25*BWidth, 11.635*BHeight, 51>, 9.8*BWidth }
      plane { y, 0 translate <0, 38*BHeight, 0> }
      plane { x, 0 }
      plane {-x, 0 translate <10.5*BWidth, 0, 0> }
   }
}

#local B4Vindue5Altan=union{ // 4-fag med sidedr
   difference {
      box { <0, 0, 0>, <10.25*BWidth, 26*BHeight, 10> }
      box { <15, 13, -1>, <10.25*BWidth-15, 26*BHeight-15, 11> }
   }
   box { <2.69*BWidth-9, 10, 0>, <2.69*BWidth+9, 26*BHeight-15, 10> }
   box { <5.125*BWidth-9, 10, 0>, <5.125*BWidth+9, 26*BHeight-15, 10> }
   box { <7.56*BWidth-9, 10, 0>, <7.56*BWidth+9, 26*BHeight-15, 10> }
   box { <15, 17*BHeight-18, 0>, <10.25*BWidth-15, 17*BHeight, 10> }

   difference {
      box { <5.125*BWidth, -14*BHeight, 0>, <10.25*BWidth, 0, 10> }
      box { <5.125*BWidth+9, -10*BHeight, -1>, <7.56*BWidth-9, -2*BHeight, 2> }
      box { <7.56*BWidth+9, -10*BHeight, -1>, <10.25*BWidth-15, -2*BHeight, 2> }
   }
   box { <5.125*BWidth+14, -10*BHeight+5, 0>, <7.56*BWidth-14, -2*BHeight-5, 2> }
   box { <7.56*BWidth+14, -10*BHeight+5, -0>, <10.25*BWidth-20, -2*BHeight-5, 2> }

   box { <15, 10, 1>, <10.25*BWidth-15, 26*BHeight-15, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue5FranskAltan=union{ // 4-fag med midterdr
   difference {
      box { <0, -14*BHeight, 0>, <10.75*BWidth, 27*BHeight, 10> }
      box { <20, 13, -1>, <10.75*BWidth-20, 27*BHeight-20, 11> }
      box { <2.92*BWidth+9, -15*BHeight, -1>, <7.83*BWidth-9, 14, 11> }
   }
   box { <2.92*BWidth-9, 10, 0>, <2.92*BWidth+9, 27*BHeight-20, 10> }
   box { <5.375*BWidth-9, 17*BHeight, 0>, <5.375*BWidth+9, 27*BHeight-20, 10> }
   box { <7.83*BWidth-9, 10, 0>, <7.83*BWidth+9, 27*BHeight-20, 10> }
   box { <20, 17*BHeight-18, 0>, <10.75*BWidth-20, 17*BHeight, 10> }

//dr
   difference {
      box { <2.92*BWidth+9, -14*BHeight, 5>, <7.83*BWidth-9, 17*BHeight-18, 10> }
      box { <2.92*BWidth+15, 11, 4>, <5.375*BWidth-9, 14*BHeight-6, 11> }
      box { <5.375*BWidth+9, 11, 4>, <7.83*BWidth-15, 14*BHeight-6, 11> }
      box { <2.92*BWidth+15, -10*BHeight, 4>, <5.375*BWidth-9, -2*BHeight, 7> }
      box { <5.375*BWidth+9, -10*BHeight, 4>, <7.83*BWidth-15, -2*BHeight, 7> }
   }
   box { <2.92*BWidth+20, -10*BHeight+5, 5>, <5.375*BWidth-14, -2*BHeight-5, 7> }
   box { <5.375*BWidth+14, -10*BHeight+5, 5>, <7.83*BWidth-20, -2*BHeight-5, 7> }
   box { <5.375*BWidth-2, -14*BHeight, 4>, <5.375*BWidth+2, 17*BHeight-18, 5> }

   difference {
      object { B4VindueKarmprofil scale <10.75*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      plane {-x, 0 rotate <0, 0, -45> translate <10.75*BWidth, 0, 0> }
      translate <0, 27*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <28*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      rotate <0, 0, -90> translate <10.75*BWidth, 27*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <28*BHeight, 1, 1> translate <-28*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <0, 27*BHeight, 0>
   }
   difference {
      box { <20, 10, 1>, <10.75*BWidth-20, 27*BHeight-20, 1.3> }
      box { <2.92*BWidth, 0, 0>, <7.83*BWidth, 17*BHeight, 2>}
      texture { T_Rude }
   }
   box { <2.92*BWidth+9, 10, 6>, <7.83*BWidth-9, 17*BHeight-20, 6.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue7=union{ // 1-fag
   difference {
      box { <0, 0, 0>, <3.4*BWidth, 21*BHeight, 10> }
      box { <20, 13, -1>, <3.4*BWidth-20, 21*BHeight-20, 11> }
   }
   box { <20, 10*BHeight-1.5, 0>, <3.4*BWidth-20, 10*BHeight+1.5, 2> }

   difference {
      object { B4VindueKarmprofil scale <3.4*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      plane {-x, 0 rotate <0, 0, -45> translate <3.4*BWidth, 0, 0> }
      translate <0, 21*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <22*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      rotate <0, 0, -90> translate <3.4*BWidth, 21*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <22*BHeight, 1, 1> translate <-22*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <0, 21*BHeight, 0>
   }

   box { <16, 13, 1>, <3.4*BWidth-11, 21*BHeight-16, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue7Gavl=union{ // 1-fag gavltrekant
   difference {
      box { <0, 0, 0>, <3.25*BWidth, 22*BHeight, 10> }
      box { <16, 16, -1>, <3.25*BWidth-16, 22*BHeight-16, 11> }
   }
   box { <16, 11*BHeight-1.5, 0>, <3.25*BWidth-16, 11*BHeight+1.5, 2> }

   difference {
      cylinder { <0, 0, 0>, <3.25*BWidth, 0, 0>, 5 }
      plane { x, 0 rotate <0, 0,  45> }
      plane {-x, 0 rotate <0, 0, -45> translate <3.25*BWidth, 0, 0> }
      translate <0, 22*BHeight, 0>
   }
   difference {
      cylinder { <0, 0, 0>, <23*BHeight, 0, 0>, 5 }
      plane { x, 0 rotate <0, 0,  45> }
      rotate <0, 0, -90> translate <3.25*BWidth, 22*BHeight, 0>
   }
   difference {
      cylinder { <0, 0, 0>, <23*BHeight, 0, 0>, 5 translate <-23*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <0, 22*BHeight, 0>
   }

   box { <16, 13, 1>, <3.25*BWidth-11, 22*BHeight-16, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue8=union{ // Ovalt gavltrekant
   difference {
      cylinder { <0, 0, 0>, <0, 0, 10>, 6*BHeight scale <17/12, 1, 1> }
      cylinder { <0, 0, -1>, <0, 0, 11>, 6*BHeight-11 scale <(8.5*BHeight-11)/(6*BHeight-11), 1, 1> }
   }
   box { <-8, -5*BHeight, 0>, <8, 6*BHeight, 10> }
   box { <-8*BHeight, -1.5, 0>, <8*BHeight, 1.5, 2> }
   box { <-28.3, -5*BHeight, 0>, <-25.3, 6*BHeight, 2> }
   box { < 28.3, -5*BHeight, 0>, < 25.3, 6*BHeight, 2> }
   cylinder { <0, 0, 1>, <0, 0, 1.3>, 6*BHeight-11 scale <17/12, 1, 1> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue9=union{ // 3-fag 22*BHeight
   difference {
      box { <0, 0, 0>, <9.75*BWidth, 22*BHeight, 10> }
      box { <20, 20, -1>, <9.75*BWidth-20, 22*BHeight-20, 11> }
   }
   box { <1.75*BWidth+20, 10, 0>, <1.75*BWidth+54, 22*BHeight-20, 10> }
   box { <1.75*BWidth+31, 0, -3>, <1.75*BWidth+43, 22*BHeight, 10> }
   box { <8.00*BWidth-20, 10, 0>, <8.00*BWidth-54, 22*BHeight-20, 10> }
   box { <8.00*BWidth-31, 0, -3>, <8.00*BWidth-43, 22*BHeight, 10> }
   box { <20, 11*BHeight-1.5, 0>, <9.75*BWidth-20, 11*BHeight+1.5, 2> }

   difference {
      object { B4VindueKarmprofil scale <9.75*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      plane {-x, 0 rotate <0, 0, -45> translate <9.75*BWidth, 0, 0> }
      translate <0, 22*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <23*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      rotate <0, 0, -90> translate <9.75*BWidth, 22*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <23*BHeight, 1, 1> translate <-22*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <0, 22*BHeight, 0>
   }

   box { <20, 10, 1>, <9.75*BWidth-20, 22*BHeight-20, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue10=union{ // 2-fag 22*BHeight
   difference {
      box { <0, 0, 0>, <5.5*BWidth, 22*BHeight, 10> }
      box { <20, 20, -1>, <5.5*BWidth-20, 22*BHeight-20, 11> }
   }
   box { <1.5*BWidth+20, 10, 0>, <4.0*BWidth-20, 22*BHeight-20, 10> }
   box { <20, 11*BHeight-1.5, 0>, <5.5*BWidth-20, 11*BHeight+1.5, 2> }

   difference {
      object { B4VindueKarmprofil scale <5.5*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      plane {-x, 0 rotate <0, 0, -45> translate <5.5*BWidth, 0, 0> }
      translate <0, 22*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <23*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      rotate <0, 0, -90> translate <5.5*BWidth, 22*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <23*BHeight, 1, 1> translate <-22*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <0, 22*BHeight, 0>
   }

   box { <20, 10, 1>, <5.5*BWidth-20, 22*BHeight-20, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue11=union{ // 3-fag 22*BHeight "Trn"-midtfor
   difference {
      box { <0, 0, 0>, <8.25*BWidth, 22*BHeight, 10> }
      box { <20, 20, -1>, <8.25*BWidth-20, 22*BHeight-20, 11> }
   }
   box { <2.9*BWidth-9, 10, 0>, <2.9*BWidth+9, 22*BHeight-20, 10> }
   box { <5.35*BWidth-9, 10, 0>, <5.35*BWidth+9, 22*BHeight-20, 10> }
   box { <20, 11*BHeight-1.5, 0>, <8.25*BWidth-20, 11*BHeight+1.5, 2> }

   difference {
      object { B4VindueKarmprofil scale <8.25*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      plane {-x, 0 rotate <0, 0, -45> translate <8.25*BWidth, 0, 0> }
      translate <0, 22*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <23*BHeight, 1, 1> }
      plane { x, 0 rotate <0, 0,  45> }
      rotate <0, 0, -90> translate <8.25*BWidth, 22*BHeight, 0>
   }
   difference {
      object { B4VindueKarmprofil scale <23*BHeight, 1, 1> translate <-22*BHeight, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <0, 22*BHeight, 0>
   }

   box { <20, 10, 1>, <8.25*BWidth-20, 22*BHeight-20, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue12=union{ // Ny stil buevindue mur4
   difference {
      box { <0, 14*BHeight, 0>, <9*BWidth, 37*BHeight, 10> }
      box { <6, 14*BHeight+6, -1>, <9*BWidth-6, 38*BHeight, 11> }
   }
   difference {
      cylinder { <4.5*BWidth, 21.65*BHeight,  0>, <4.5*BWidth, 21.65*BHeight, 10>, 24.35*BHeight-BWidth/2  }
      cylinder { <4.5*BWidth, 21.65*BHeight, -1>, <4.5*BWidth, 21.65*BHeight, 11>, 24.35*BHeight-BWidth/2-6 }
      plane { y, 0 translate <0, 37*BHeight, 0> }
   }
   box { <6, 31.5*BHeight, 0>, <9*BWidth-6, 31.5*BHeight+6, 5> }
   box { < 31.8, 32*BHeight, 0>, < 35.7, 40.5*BHeight, 3> }
   box { < 61.5, 32*BHeight, 0>, < 65.4, 42.5*BHeight, 3> }
   box { < 91.2, 32*BHeight, 0>, < 95.1, 43.5*BHeight, 3> }
   box { <120.9, 32*BHeight, 0>, <124.8, 43.5*BHeight, 3> }
   box { <150.6, 32*BHeight, 0>, <154.5, 42.5*BHeight, 3> }
   box { <180.3, 32*BHeight, 0>, <184.2, 40.5*BHeight, 3> }

   box { <6, 14*BHeight+6, 1>, <9*BWidth-6, 44*BHeight, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue12Cutout=intersection{
   box { <0, 13*BHeight, -1>, <9*BWidth, 45*BHeight, 76> }
   cylinder { <4.5*BWidth, 21.65*BHeight, -1>, <4.5*BWidth, 21.65*BHeight, 76>, 24.35*BHeight-BWidth/2  }
}

#local B4Vindue13=union{ // Ny stil buevindue mur5
   difference {
      box { <0, 14*BHeight, 0>, <12.5*BWidth, 32.5*BHeight, 10> }
      box { <6, 14*BHeight+6, -1>, <12.5*BWidth-6, 33*BHeight, 11> }
   }
   difference {
      cylinder { <6.25*BWidth, 16.65*BHeight,  0>, <6.25*BWidth, 16.65*BHeight, 10>, 29.35*BHeight-BWidth/2  }
      cylinder { <6.25*BWidth, 16.65*BHeight, -1>, <6.25*BWidth, 16.65*BHeight, 11>, 29.35*BHeight-BWidth/2-6 }
      plane { y, 0 translate <0, 32.5*BHeight, 0> }
   }
   box { <6, 31.5*BHeight, 0>, <12.5*BWidth-6, 31.5*BHeight+6.65, 5> }
   box { < 31.2, 32*BHeight, 0>, < 35.2, 38.0*BHeight, 3> }
   box { < 60.4, 32*BHeight, 0>, < 64.4, 41.0*BHeight, 3> }
   box { < 89.6, 32*BHeight, 0>, < 93.6, 43.0*BHeight, 3> }
   box { <118.8, 32*BHeight, 0>, <122.8, 44.0*BHeight, 3> }
   box { <148.0, 32*BHeight, 0>, <152.0, 44.5*BHeight, 3> }
   box { <177.2, 32*BHeight, 0>, <181.2, 44.0*BHeight, 3> }
   box { <206.4, 32*BHeight, 0>, <210.4, 43.0*BHeight, 3> }
   box { <235.6, 32*BHeight, 0>, <239.6, 41.0*BHeight, 3> }
   box { <264.8, 32*BHeight, 0>, <268.8, 38.0*BHeight, 3> }

   box { <6, 14*BHeight+6, 1>, <12.5*BWidth-6, 44*BHeight, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue13A=union{ // Ny stil buevindue mur5 - variant med opdelt rude
   object { B4Vindue13 }
   box { <8.6*BWidth-6, 14*BHeight, 0>, <8.6*BWidth, 31.5*BHeight, 10> }
   texture { pigment { White } }
}

#local B4Vindue13Cutout=intersection{
   box { <0, 13*BHeight, -1>, <12.5*BWidth, 45*BHeight, 76> }
   cylinder { <6.25*BWidth, 16.65*BHeight, -1>, <6.25*BWidth, 16.65*BHeight, 76>, 29.35*BHeight-BWidth/2  }
}

#local B4Vindue14=union{ // 1-fag for mur5 karnap
   difference {
      box { <-1.5*BWidth, 0, 0>, <1.5*BWidth, 27*BHeight, 10> }
      box { <-21, 13, -1>, <21, 17*BHeight-18, 11> }
      box { <-21, 17*BHeight, -1>, <21, 27*BHeight-20, 11> }
   }

   difference {
      object { B4VindueKarmprofil scale <3.2*BWidth, 1, 1> translate <-1.6*BWidth, 27*BHeight, 0> }
      plane { x, 0 rotate <0,  7.5, 0> translate <0, 0, 11.275*BWidth> }
      plane {-x, 0 rotate <0, -7.5, 0> translate <0, 0, 11.275*BWidth> }
   }

   box { <-22, 10, 1>, <22, 27*BHeight-20, 1.3> texture { T_Rude } }
   texture { pigment { White } }
}

#local B4Vindue14A=union{ // 1-fag for mur5 karnap midtdel
   object { B4Vindue14 }
   difference {
      object { B4SaalbaenkProfil scale <3.2*BWidth, 1, 1> translate <-1.6*BWidth, 0, 0> }
      plane { x, 0 rotate <0,  7.5, 0> translate <0, 0, 11.275*BWidth> }
      plane {-x, 0 rotate <0, -7.5, 0> translate <0, 0, 11.275*BWidth> }
      texture { T_B4Saalbaenk translate <0, 10, -100> }
   }
   texture { pigment { White } }
}

#local B4Vindue14B=union{ // 1-fag for mur5 karnap med sidekarm
   object { B4Vindue14 }
   difference {
      object { B4SaalbaenkProfil scale <4*BWidth, 1, 1> translate <-2.4*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> translate <0, 0, 11.275*BWidth> }
      texture { T_B4Saalbaenk translate <0, 10, -100> }
   }
   object { B4VindueKarmprofil scale <29*BHeight, 1, 1>
            translate <-28*BHeight, 0, 0>
            rotate <0, 0, 90> translate <-1.65*BWidth, 27*BHeight, 0>
   }
   texture { pigment { White } }
}

#local B4KvistVindue=union{
   difference {
      box { <-BWidth, 0, 0>, <BWidth, 20.5*BHeight, 5> }
      box { <-0.8*BWidth, 0.75*BHeight, -1>, <0.8*BWidth, 19.75*BHeight, 6> }
   }
   box { <-0.06*BWidth, 0.75*BHeight, 0>, <0.06*BWidth, 19.75*BHeight, 3> }
   box { <-0.8*BWidth,  5.17*BHeight, 0>, <0.8*BWidth,  5.61*BHeight, 3> }
   box { <-0.8*BWidth, 10.03*BHeight, 0>, <0.8*BWidth, 10.47*BHeight, 3> }
   box { <-0.8*BWidth, 14.89*BHeight, 0>, <0.8*BWidth, 15.33*BHeight, 3> }

   box { <-0.8*BWidth, 0.75*BHeight, 1>, <0.8*BWidth, 19.75*BHeight, 1.3> texture { T_Rude } }
}

#local B4Kvist2Fag=union{
   difference {
      box { <-2.575*BWidth, 0, 0>, <2.575*BWidth, 22.5*BHeight, 75> }
      box { <-2.075*BWidth, BHeight, -1>, <2.075*BWidth, 21.5*BHeight, 76> }
   }
   box { <-0.075*BWidth, BHeight, 0>, < 0.075*BWidth, 21.5*BHeight, 5> }

   box { <-2.775*BWidth, 22.5*BHeight, -2>, <2.775*BWidth, 23.5*BHeight, 75> }
   intersection {
      box { <-2.775*BWidth, 23.5*BHeight, -2>, <2.775*BWidth, 31.5*BHeight, 75> }
      cylinder { <0, 13*BHeight, -3>, <0, 13*BHeight, 76>, 18*BHeight }
   }
   difference {
      cylinder { <0, 13*BHeight, -5>, <0, 13*BHeight, 76>, 15.0*BHeight }
      cylinder { <0, 13*BHeight, -6>, <0, 13*BHeight, 77>, 14.4*BHeight }
      plane { y, 0 translate <0, 13*BHeight, 0> }
      plane { x, 0 translate <-2.875*BWidth, 0, 0> }
      plane {-x, 0 translate < 2.875*BWidth, 0, 0> }
   }
   difference {
      torus { 17.2*BHeight, 2.4*BHeight rotate <90, 0, 0> translate <0, 13*BHeight, -4> }
      cylinder { <0, 13*BHeight, -21>, <0, 13*BHeight, 77>, 17.2*BHeight inverse }
      plane { x, 0 rotate <0,  45,  38.5> translate <0, 13*BHeight, 0> }
      plane {-x, 0 rotate <0, -45, -38.5> translate <0, 13*BHeight, 0> }
   }
   difference {
      cylinder { <0, 0, -3*BHeight>, <0, 0, 76>, 2.4*BHeight translate <0, 17.2*BHeight, 0> }
      cylinder { <0, 0, -21>, <0, 0, 77>, 17.2*BHeight inverse }
      plane { x, 0 rotate <0, -45, 0> }
      rotate <0, 0, -38.5>
      translate <0, 13*BHeight, -4>
   }
   difference {
      cylinder { <0, 0, -3*BHeight>, <0, 0, 76>, 2.4*BHeight translate <0, 17.2*BHeight, 0> }
      cylinder { <0, 0, -21>, <0, 0, 77>, 17.2*BHeight inverse }
      plane {-x, 0 rotate <0, 45, 0> }
      rotate <0, 0,  38.5>
      translate <0, 13*BHeight, -4>
   }
   difference {
      cylinder { <0, 13*BHeight, -22>, <0, 13*BHeight, 76>, 18.0*BHeight }
      cylinder { <0, 13*BHeight, -23>, <0, 13*BHeight, 77>, 17.2*BHeight }
      plane { x, 0 rotate <0, 0,  50.3> translate <0, 13*BHeight, 0> }
      plane {-x, 0 rotate <0, 0, -50.3> translate <0, 13*BHeight, 0> }
   }
   difference {
      cylinder { <0, 13*BHeight, -25>, <0, 13*BHeight, 76>, 18.1*BHeight }
      cylinder { <0, 13*BHeight, -26>, <0, 13*BHeight, 77>, 18.0*BHeight }
      plane { x, 0 rotate <0, 0,  52> translate <0, 13*BHeight, 0> }
      plane {-x, 0 rotate <0, 0, -52> translate <0, 13*BHeight, 0> }
      texture { pigment { Gray20 } }
   }
   texture { pigment { Gray60 } }
}

#local B4Kvist2FagHvid=union{
   object { B4Kvist2Fag }
   object { B4KvistVindue translate <-1.075*BWidth, BHeight, 0> texture { pigment { White } } }
   object { B4KvistVindue translate < 1.075*BWidth, BHeight, 0> texture { pigment { White } } }
}

#local B4Kvist2FagGraa=union{
   object { B4Kvist2Fag }
   object { B4KvistVindue translate <-1.075*BWidth, BHeight, 0> texture { pigment { Gray60 } } }
   object { B4KvistVindue translate < 1.075*BWidth, BHeight, 0> texture { pigment { Gray60 } } }
}

#local B4Kvist3Fag=union{
   difference {
      box { <-3.65*BWidth, 0, 0>, <3.65*BWidth, 22.5*BHeight, 75> }
      box { <-3.15*BWidth, BHeight, -1>, <3.15*BWidth, 21.5*BHeight, 76> }
   }
   box { <-1.15*BWidth, BHeight, 0>, <-1.0*BWidth, 21.5*BHeight, 5> }
   box { < 1.00*BWidth, BHeight, 0>, < 1.15*BWidth, 21.5*BHeight, 5> }

   box { <-3.85*BWidth, 22.5*BHeight, -2>, <3.85*BWidth, 23.5*BHeight, 75> }
   intersection {
      box { <-3.85*BWidth, 23.5*BHeight, -2>, <3.85*BWidth, 31.5*BHeight, 75> }
      cylinder { <0, BHeight, -3>, <0, BHeight, 76>, 30*BHeight }
   }
   difference {
      cylinder { <0, BHeight, -5>, <0, BHeight, 76>, 27.0*BHeight }
      cylinder { <0, BHeight, -6>, <0, BHeight, 77>, 26.4*BHeight }
      plane { y, 0 translate <0, BHeight, 0> }
      plane { x, 0 translate <-3.95*BWidth, 0, 0> }
      plane {-x, 0 translate < 3.95*BWidth, 0, 0> }
   }
   difference {
      torus { 29.2*BHeight, 2.4*BHeight rotate <90, 0, 0> translate <0, BHeight, -4> }
      cylinder { <0, BHeight, -21>, <0, BHeight, 77>, 29.2*BHeight inverse }
      plane { x, 0 rotate <0,  45,  30> translate <0, BHeight, -4> }
      plane {-x, 0 rotate <0, -45, -30> translate <0, BHeight, -4> }
   }
   difference {
      cylinder { <0, 0, -3*BHeight>, <0, 0, 76>, 2.4*BHeight translate <0, 29.2*BHeight, 0> }
      cylinder { <0, 0, -21>, <0, 0, 77>, 29.2*BHeight inverse }
      plane { x, 0 rotate <0, -45, 0> }
      rotate <0, 0, -30>
      translate <0, BHeight, -4>
   }
   difference {
      cylinder { <0, 0, -3*BHeight>, <0, 0, 76>, 2.4*BHeight translate <0, 29.2*BHeight, 0> }
      cylinder { <0, 0, -21>, <0, 0, 77>, 29.2*BHeight inverse }
      plane {-x, 0 rotate <0,  45, 0> }
      rotate <0, 0,  30>
      translate <0, BHeight, -4>
   }
   difference {
      cylinder { <0, BHeight, -22>, <0, BHeight, 76>, 30.0*BHeight }
      cylinder { <0, BHeight, -23>, <0, BHeight, 77>, 29.2*BHeight }
      plane { x, 0 rotate <0, 0,  34.5> }
      plane {-x, 0 rotate <0, 0, -34.5> }
   }
   difference {
      cylinder { <0, BHeight, -25>, <0, BHeight, 76>, 30.1*BHeight }
      cylinder { <0, BHeight, -26>, <0, BHeight, 77>, 30.0*BHeight }
      plane { x, 0 rotate <0, 0,  35.5> }
      plane {-x, 0 rotate <0, 0, -35.5> }
      texture { pigment { Gray20 } }
   }
   texture { pigment { Gray60 } }
}

#local B4Kvist3FagHvid=union{
   object { B4Kvist3Fag }
   object { B4KvistVindue translate <-2.15*BWidth, BHeight, 0> texture { pigment { White } } }
   object { B4KvistVindue translate < 0,           BHeight, 0> texture { pigment { White } } }
   object { B4KvistVindue translate < 2.15*BWidth, BHeight, 0> texture { pigment { White } } }
}

#local B4Kvist3FagGraa=union{
   object { B4Kvist3Fag }
   object { B4KvistVindue translate <-2.15*BWidth, BHeight, 0> texture { pigment { Gray60 } } }
   object { B4KvistVindue translate < 0,           BHeight, 0> texture { pigment { Gray60 } } }
   object { B4KvistVindue translate < 2.15*BWidth, BHeight, 0> texture { pigment { Gray60 } } }
}

#local B4Kvist4Fag=union{
   difference {
      box { <-4.725*BWidth, 0, 0>, <4.725*BWidth, 22.5*BHeight, 75> }
      box { <-4.225*BWidth, BHeight, -1>, <4.225*BWidth, 21.5*BHeight, 76> }
   }
   box { <-2.225*BWidth, BHeight, 0>, <-2.075*BWidth, 21.5*BHeight, 5> }
   box { <-0.075*BWidth, BHeight, 0>, < 0.075*BWidth, 21.5*BHeight, 5> }
   box { < 2.075*BWidth, BHeight, 0>, < 2.225*BWidth, 21.5*BHeight, 5> }

   object { B4KvistVindue translate <-3.225*BWidth, BHeight, 0> texture { pigment { Gray60 } } }
   object { B4KvistVindue translate <-1.075*BWidth, BHeight, 0> texture { pigment { Gray60 } } }
   object { B4KvistVindue translate < 1.075*BWidth, BHeight, 0> texture { pigment { Gray60 } } }
   object { B4KvistVindue translate < 3.225*BWidth, BHeight, 0> texture { pigment { Gray60 } } }

   box { <-4.925*BWidth, 22.5*BHeight, -2>, <4.925*BWidth, 23.5*BHeight, 75> }
   intersection {
      box { <-4.925*BWidth, 23.5*BHeight, -2>, <4.925*BWidth, 31.5*BHeight, 75> }
      cylinder { <0, -15*BHeight, -3>, <0, -15*BHeight, 76>, 46*BHeight }
   }
   difference {
      cylinder { <0, -15*BHeight, -5>, <0, -15*BHeight, 76>, 43.0*BHeight }
      cylinder { <0, -15*BHeight, -6>, <0, -15*BHeight, 77>, 42.4*BHeight }
      plane { y, 0 }
      plane { x, 0 translate <-5.025*BWidth, 0, 0> }
      plane {-x, 0 translate < 5.025*BWidth, 0, 0> }
   }
   difference {
      torus { 45.2*BHeight, 2.4*BHeight rotate <90, 0, 0> translate <0, -15*BHeight, -4> }
      cylinder { <0, -15*BHeight, -21>, <0, -15*BHeight, 77>, 45.2*BHeight inverse }
      plane { x, 0 rotate <0,  45,  24> translate <0, -15*BHeight, -4>}
      plane {-x, 0 rotate <0, -45, -24> translate <0, -15*BHeight, -4>}
   }
   difference {
      cylinder { <0, 0, -3*BHeight>, <0, 0, 76>, 2.4*BHeight translate <0, 45.2*BHeight, 0> }
      cylinder { <0, 0, -21>, <0, 0, 77>, 45.2*BHeight inverse }
      plane { x, 0 rotate <0, -45, 0> }
      rotate <0, 0, -24>
      translate <0, -15*BHeight, -4>
   }
   difference {
      cylinder { <0, 0, -3*BHeight>, <0, 0, 76>, 2.4*BHeight translate <0, 45.2*BHeight, 0> }
      cylinder { <0, 0, -21>, <0, 0, 77>, 45.2*BHeight inverse }
      plane {-x, 0 rotate <0, 45, 0> }
      rotate <0, 0, 24>
      translate <0, -15*BHeight, -4>
   }
   difference {
      cylinder { <0, -15*BHeight, -22>, <0, -15*BHeight, 76>, 46.0*BHeight }
      cylinder { <0, -15*BHeight, -23>, <0, -15*BHeight, 77>, 45.2*BHeight }
      plane { x, 0 rotate <0, 0,  39.8> }
      plane {-x, 0 rotate <0, 0, -39.8> }
   }
   difference {
      cylinder { <0, -15*BHeight, -25>, <0, -15*BHeight, 76>, 46.1*BHeight }
      cylinder { <0, -15*BHeight, -26>, <0, -15*BHeight, 77>, 46.0*BHeight }
      plane { x, 0 rotate <0, 0,  40.5> }
      plane {-x, 0 rotate <0, 0, -40.5> }
      texture { pigment { Gray20 } }
   }
   texture { pigment { Gray60 } }
}

#local B4TagterrasseDoer=union{
   difference {
      box { <-3.65*BWidth, -11*BHeight, 0>, <3.65*BWidth, 22.5*BHeight, 75> }
      box { <-3.15*BWidth, -12*BHeight, -1>, <3.15*BWidth, 23*BHeight, 76> }
      texture { pigment { Gray60 } }
   }
   difference {
      box { <-3.15*BWidth, -11*BHeight,  0>, < 3.15*BWidth, 22.5*BHeight,  5> }
      box { <-2.80*BWidth,  2.5*BHeight, -1>, <-1.80*BWidth, 21.5*BHeight, 11> }
      box { <-1.30*BWidth,  2.5*BHeight, -1>, < 1.30*BWidth, 21.5*BHeight, 11> }
      box { < 1.80*BWidth,  2.5*BHeight, -1>, < 2.80*BWidth, 21.5*BHeight, 11> }
   }

   box { <-2.8*BWidth,  6.92*BHeight, 0>, <-1.8*BWidth,  7.36*BHeight, 3> }
   box { <-2.8*BWidth, 11.78*BHeight, 0>, <-1.8*BWidth, 12.22*BHeight, 3> }
   box { <-2.8*BWidth, 16.64*BHeight, 0>, <-1.8*BWidth, 17.08*BHeight, 3> }
   box { < 1.8*BWidth,  6.92*BHeight, 0>, < 2.8*BWidth,  7.36*BHeight, 3> }
   box { < 1.8*BWidth, 11.78*BHeight, 0>, < 2.8*BWidth, 12.22*BHeight, 3> }
   box { < 1.8*BWidth, 16.64*BHeight, 0>, < 2.8*BWidth, 17.08*BHeight, 3> }

   box { <-2.8*BWidth, 2.5*BHeight, 1>, <2.8*BWidth, 21.5*BHeight, 1.3> texture { T_Rude } }

   box { <-3.85*BWidth, 22.5*BHeight, -2>, <3.85*BWidth, 23.5*BHeight, 75> }
   intersection {
      box { <-3.85*BWidth, 23.5*BHeight, -2>, <3.85*BWidth, 31.5*BHeight, 75> }
      cylinder { <0, BHeight, -3>, <0, BHeight, 76>, 30*BHeight }
   }
   difference {
      cylinder { <0, BHeight, -5>, <0, BHeight, 76>, 27.0*BHeight }
      cylinder { <0, BHeight, -6>, <0, BHeight, 77>, 26.4*BHeight }
      plane { y, 0 translate <0, BHeight, 0> }
      plane { x, 0 translate <-3.95*BWidth, 0, 0> }
      plane {-x, 0 translate < 3.95*BWidth, 0, 0> }
   }
   difference {
      torus { 29.2*BHeight, 2.4*BHeight rotate <90, 0, 0> translate <0, BHeight, -4> }
      cylinder { <0, BHeight, -21>, <0, BHeight, 77>, 29.2*BHeight inverse }
      plane { x, 0 rotate <0,  45,  30> translate <0, BHeight, -4> }
      plane {-x, 0 rotate <0, -45, -30> translate <0, BHeight, -4> }
   }
   difference {
      cylinder { <0, 0, -3*BHeight>, <0, 0, 76>, 2.4*BHeight translate <0, 29.2*BHeight, 0> }
      cylinder { <0, 0, -21>, <0, 0, 77>, 29.2*BHeight inverse }
      plane { x, 0 rotate <0, -45, 0> }
      rotate <0, 0, -30>
      translate <0, BHeight, -4>
   }
   difference {
      cylinder { <0, 0, -3*BHeight>, <0, 0, 76>, 2.4*BHeight translate <0, 29.2*BHeight, 0> }
      cylinder { <0, 0, -21>, <0, 0, 77>, 29.2*BHeight inverse }
      plane {-x, 0 rotate <0,  45, 0> }
      rotate <0, 0,  30>
      translate <0, BHeight, -4>
   }
   difference {
      cylinder { <0, BHeight, -22>, <0, BHeight, 76>, 30.0*BHeight }
      cylinder { <0, BHeight, -23>, <0, BHeight, 77>, 29.2*BHeight }
      plane { x, 0 rotate <0, 0,  34.5> }
      plane {-x, 0 rotate <0, 0, -34.5> }
   }
   difference {
      cylinder { <0, BHeight, -25>, <0, BHeight, 76>, 30.1*BHeight }
      cylinder { <0, BHeight, -26>, <0, BHeight, 77>, 30.0*BHeight }
      plane { x, 0 rotate <0, 0,  35.5> }
      plane {-x, 0 rotate <0, 0, -35.5> }
      texture { pigment { Gray20 } }
   }
   texture { pigment { White } }
}

// Dr

#local B4Doer1Decoprofil=union{
   box { <0, 0, -0.1>, <1, 3*BHeight, 0> }
   cylinder { <0, 0.6*BHeight, 0>, <1, 0.6*BHeight, 0>, 0.4*BHeight }
   box { <0, 3*BHeight, -2.8>, <1, 5*BHeight, 0> }
   cylinder { <0, 4.4*BHeight, -2.8>, <1, 4.4*BHeight, -2.8>, 0.4*BHeight }
   difference {
      cylinder { <0, 5*BHeight+11.8, 0>, <1, 5*BHeight+11.8, 0>, 11.8 }
      plane {-y, 0 translate <0, 6.6*BHeight, 0> }
   }
   box { <0, 6.6*BHeight, -12.8>, <1, 7*BHeight, 0> }
}

#local B4Doer1Deco1=union{
   difference {
      object { B4Doer1Decoprofil scale <1.75*BWidth+15, 1, 1> translate <-15, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, 0, 44> translate <1.75*BWidth, 3*BHeight, 0> }
   }
   difference {
      object { B4Doer1Decoprofil scale <15, 1, 1> }
      plane {-x, 0 rotate <0, -45, 0> }
      rotate <0, 90, 0>
   }
   texture { T_Sandstone }
}

#local B4Doer1DecoBue=union{
   difference {
      cylinder { <0, 0, -2.8>, <0, 0, 0>, 3.7*BWidth+2*BHeight }
      cylinder { <0, 0, -2.9>, <0, 0, 0.1>, 3.7*BWidth-0.1 }
   }
   torus { 3.7*BWidth+1.4*BHeight, 0.4*BHeight rotate <90, 0, 0> translate <0, 0, -2.8> }
   difference {
      torus { 3.7*BWidth+2*BHeight+11.8, 11.8 rotate <90, 0, 0> }
      cylinder { <0, 0, -12>, <0, 0, 0.1>, 3.7*BWidth+3.6*BHeight inverse }
   }
   difference {
      cylinder { <0, 0, -12.8>, <0, 0, 0>, 3.7*BWidth+4*BHeight }
      cylinder { <0, 0, -12.9>, <0, 0, 0.1>, 3.7*BWidth+3.6*BHeight }
   }
   scale <1, 1/1.2, 1>
}


#local B4Doer1=union{
   box { <-5*BWidth, 0, -1.25*BWidth>, <5*BWidth, 2*BHeight, 50> texture { T_Granit } }
   box { <-5*BWidth, 2*BHeight, -0.1>, <-3.7*BWidth+0.1, 5*BHeight, 50> texture { T_Granit } }
   box { < 5*BWidth, 2*BHeight, -0.1>, < 3.7*BWidth-0.1, 5*BHeight, 50> texture { T_Granit } }

   difference {
      box { <-3.7*BWidth, 2*BHeight, BWidth/2>, <-2.95*BWidth, 41*BHeight, 50> }
      cylinder { <-2.95*BWidth, 0, BWidth/2>, <-2.95*BWidth, 41*BHeight+1, BWidth/2>, 14 }
      texture { T_Sandstone }
   }
   difference {
      box { < 3.7*BWidth, 2*BHeight, BWidth/2>, < 2.95*BWidth, 41*BHeight, 50> }
      cylinder { < 2.95*BWidth, 0, BWidth/2>, < 2.95*BWidth, 41*BHeight+1, BWidth/2>, 14 }
      texture { T_Sandstone }
   }
   difference {
      cylinder { <0, 0, BWidth/2>, <0, 0, 50>, 3.7*BWidth }
      cylinder { <0, 0, 0>, <0, 0, 51>, 2.95*BWidth }
      torus { 2.95*BWidth, 14 rotate <90, 0, 0> translate <0, 0, BWidth/2> }
      plane { y, 0 }
      scale <1, 1/1.2, 1>
      translate <0, 41*BHeight, 0>
      texture { T_Sandstone }
   }

   box { <-2.95*BWidth, 2*BHeight, 1.25*BWidth>, <-2.73*BWidth, 38*BHeight, 50> texture { pigment { rgb <0.3, 0.1, 0.05> } } }
   box { < 2.95*BWidth, 2*BHeight, 1.25*BWidth>, < 2.73*BWidth, 38*BHeight, 50> texture { pigment { rgb <0.3, 0.1, 0.05> } } }
   difference {
      box { <-2.95*BWidth, 38*BHeight, 1.25*BWidth>, <2.95*BWidth, 41*BHeight, 50> }
      box { <-2.55*BWidth, 40*BHeight, BWidth>, <2.55*BWidth, 42*BHeight, 51> }
      texture { pigment { rgb <0.3, 0.1, 0.05> } }
   }
   difference {
      cylinder { <-2.95*BWidth, 0, 1.25*BWidth>, < 2.95*BWidth, 0, 1.25*BWidth>, 4 }
      plane { y, 0 }
      texture { pigment { rgb <0.3, 0.1, 0.05> } }
      translate <0, 39*BHeight-4, 0>
   }

   difference {
      cylinder { <0, 0, 1.25*BWidth>, <0, 0, 50>, 2.95*BWidth scale <1, 1/1.2, 1> }
      cylinder { <0, 0, BWidth>, <0, 0, 51>, 2.55*BWidth scale <1, 1/1.23887, 1> }
      plane { y, 0 }
      translate <0, 41*BHeight, 0>
      texture { pigment { rgb <0.3, 0.1, 0.05> } }
   }
   box { <-1.275*BWidth, 40*BHeight, 1.25*BWidth>, <-1.401*BWidth, 48*BHeight, 1.25*BWidth+2> texture { pigment { rgb <0.3, 0.1, 0.05> } } }
   box { < -0.0625*BWidth, 40*BHeight, 1.25*BWidth>, <0.0625*BWidth, 49*BHeight, 1.25*BWidth+2> texture { pigment { rgb <0.3, 0.1, 0.05> } } }
   box { < 1.275*BWidth, 40*BHeight, 1.25*BWidth>, < 1.401*BWidth, 48*BHeight, 1.25*BWidth+2> texture { pigment { rgb <0.3, 0.1, 0.05> } } }
   difference {
      cylinder { <0, 0, 1.25*BWidth+1>, <0, 0, 1.25*BWidth+1.3>, 2.95*BWidth scale <1, 1/1.2, 1> }
      plane { y, 0 translate <0, -2*BHeight, 0> }
      translate <0, 41*BHeight, 0>
      texture { T_Rude }
   }

   box { <-2.73*BWidth, 2*BHeight, 1.5*BWidth>, <-1.75*BWidth, 38*BHeight, 2*BWidth> texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> translate <-2*BWidth, 0, 0> } }
   box { <-2.73*BWidth, 2*BHeight+2, 1.5*BWidth-0.1>, <-1.75*BWidth, 4.4*BHeight-1, 1.5*BWidth> texture { T_DoerIr } }
   box { < 2.73*BWidth, 2*BHeight, 1.5*BWidth>, < 1.75*BWidth, 38*BHeight, 2*BWidth> texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> translate < 2*BWidth, 0, 0> } }
   box { < 2.73*BWidth, 2*BHeight+2, 1.5*BWidth-0.1>, < 1.75*BWidth, 4.4*BHeight-1, 1.5*BWidth> texture { T_DoerIr } }
   difference {
      box { <-1.75*BWidth, 2*BHeight, 1.5*BWidth+1>, < 1.75*BWidth, 38*BHeight, 1.7*BWidth> }
      box { <-1.25*BWidth, BHeight, 1.5*BWidth>, < 1.25*BWidth, 39*BHeight, 2*BWidth> }
      texture { T_Wood27 rotate <88, 0, 0> scale <20, 80, 10> }
   }
   union {
      box { <-1.75*BWidth, 2*BHeight, 1.5*BWidth>, < 1.75*BWidth, 4.4*BHeight, 1.7*BWidth> }
      box { <-1.25*BWidth, 4.4*BHeight, 1.5*BWidth+1>, < 1.25*BWidth, 6.75*BHeight, 1.7*BWidth> }
      box { <-1.25*BWidth, 19.75*BHeight, 1.5*BWidth+1>, < 1.25*BWidth, 24*BHeight, 1.7*BWidth> }
      box { <-1.25*BWidth, 34*BHeight, 1.5*BWidth+1>, < 1.25*BWidth, 38*BHeight, 1.7*BWidth> }
      texture { T_Wood27 rotate <88, 0, 90> scale <80, 10, 10> translate <0, 19*BHeight, 0> }
   }
   box { <-1.73*BWidth, 2*BHeight+2, 1.5*BWidth-0.1>, < 1.75*BWidth, 4.4*BHeight-1, 1.5*BWidth> texture { T_DoerIr } }
   box { <-1.25*BWidth, 6.75*BHeight, 1.5*BWidth+3>, < 1.25*BWidth, 19.75*BHeight, 1.7*BWidth> texture { T_Wood27 rotate <92, 0, 0> scale <20, 80, 10> } }
   box { <-1*BWidth, 7.65*BHeight, 1.5*BWidth+2>, < 1*BWidth, 18.85*BHeight, 1.7*BWidth> texture { T_Wood27 rotate <92, 0, 0> scale <10, 40, 10> } }
   cylinder { <0, 0, 1.5*BWidth+1>, <0, 0, 1.7*BWidth>, BWidth-2 scale <1, 1.6, 1> translate <0, 13.25*BHeight, 0> texture { T_Wood27 rotate <88, 0, 0> scale <15, 80, 10> } }

   union {
      box { <-1.25*BWidth, 21.75*BHeight, 1.5*BWidth>, < 1.25*BWidth, 24*BHeight, 1.7*BWidth> }
      cylinder { <-1.25*BWidth-1, 21.75*BHeight+2, 1.5*BWidth>, < 1.25*BWidth+1, 21.75*BHeight+2, 1.5*BWidth>, 0.9 }
      difference {
         box { <-1.54*BWidth, 23*BHeight, 1.5*BWidth-3.5>, <1.54*BWidth, 24*BHeight, 1.7*BWidth> }
         plane {-y, 0 rotate <-45, 0, 0> translate <0, 24*BHeight, 1.5*BWidth+1> }
         plane {-y, 0 rotate <0, 0, 33> translate <-1.25*BWidth, 24*BHeight, 0> }
         plane {-y, 0 rotate <0, 0, -33> translate <1.25*BWidth, 24*BHeight, 0> }
      }
      texture { T_Wood27 rotate <92, 0, 90> scale <70, 10, 10> translate <0, 22*BHeight, 0> }
   }

   box { <-1.5, 24*BHeight, 1.5*BWidth+1>, < 1.5, 34*BHeight, 1.5*BWidth+3> texture { T_Wood27 rotate <92, 0, 0> scale <15, 80, 10> } }
   box { <-1.25*BWidth, 29*BHeight-1.5, 1.5*BWidth+1>, < 1.25*BWidth, 29*BHeight+1.5, 1.5*BWidth+3> texture { T_Wood27 rotate <92, 0, 90> scale <15, 80, 10> } }

   box { <-1.25*BWidth, 24*BHeight, 1.5*BWidth+2>, < 1.25*BWidth, 34*BHeight, 1.5*BWidth+2.3> texture { T_Rude } }

   union {
      cylinder { <0, 0, 0>, <0, 0, -0.5>, 3 }
      cylinder { <0, 0, 0>, <0, 0, -5>, 1 }
      sphere { <0, 0, -5>, 1 }
      cylinder { <0, 0, -5>, <8, 0, -5>, 1 }
      sphere { <8, 0, -5>, 1 }
      texture { T_Brass_5A }
      translate <-1.5*BWidth, 18.8*BHeight, 1.5*BWidth+1>
   }
   union {
      cylinder { <0, 0, 0>, <0, 0, -0.5>, 3.1 }
      cylinder { <0, 0, 0>, <0, 0, -0.7>, 2.2 }
      texture { T_Brass_5A }
      translate <-1.6*BWidth, 21.5*BHeight, 1.5*BWidth+1>
   }

// Sandstenskarm
   object { B4Doer1Deco1 scale <1.02, 0.94, 1> translate <-5.45*BWidth, 38*BHeight, 0> }
   object { B4Doer1Deco1 scale <1.02, 0.94, 1> translate <-5.45*BWidth, 38*BHeight, 0> scale <-1, 1, 1> }
   difference {
      object { B4Doer1DecoBue }
      plane { x, 0 rotate <0, 0,  47> translate <-3.7*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, 0, -47> translate < 3.7*BWidth, 0, 0> }
      plane { y, 0 }
      translate <0, 41*BHeight, 0>
      texture { T_Sandstone }
   }

}

/*------------------- Mure -----------------------*/

#local B4MurCutout1=union{ // 10.5x41.5 med bue
   box { <0, 0, -1>, <10.5*BWidth, 38.5*BHeight, BWidth/2> }
   difference {
      cylinder { <5.25*BWidth, 11.635*BHeight, -1>, <5.25*BWidth, 11.635*BHeight, BWidth/2>, 9.8*BWidth }
      plane { y, 0 }
      plane { x, 0 }
      plane {-x, 0 translate <10.5*BWidth, 0, 0> }
   }
}

#local B4Mur1=union{
   difference {
      box { <0, -5*BHeight, 0>, <102.25*BWidth, 3*BHeight, 50> }
      plane { x, 0 rotate <0, 45, 0> }
      box { <5*BWidth, -1, -1>, <15.5*BWidth, 4*BHeight, BWidth/2> }
      box { <32.1*BWidth, -1, -1>, <42.6*BWidth, 4*BHeight, BWidth/2> }
      // Kldervinduer
      box { <21.70*BWidth, -6*BHeight, -1>, <25.30*BWidth, 4*BHeight, 51> }
      box { <32.90*BWidth, -6*BHeight, -1>, <36.50*BWidth, 4*BHeight, 51> }
      box { <38.20*BWidth, -6*BHeight, -1>, <41.80*BWidth, 4*BHeight, 51> }
      box { <49.95*BWidth, -6*BHeight, -1>, <53.55*BWidth, 4*BHeight, 51> }
      box { <58.25*BWidth, -6*BHeight, -1>, <61.85*BWidth, 4*BHeight, 51> }
      box { <66.55*BWidth, -6*BHeight, -1>, <70.15*BWidth, 4*BHeight, 51> }
      box { <74.85*BWidth, -6*BHeight, -1>, <78.45*BWidth, 4*BHeight, 51> }
      box { <83.15*BWidth, -6*BHeight, -1>, <86.75*BWidth, 4*BHeight, 51> }

      box { <91.35*BWidth, -1, -1>, <98.75*BWidth, 4*BHeight, 51> }  // Dr
      texture { T_Granit }
   }
   difference {
      box { <0, 3*BHeight, 0>, <102.25*BWidth, 202*BHeight, 50> }
      plane { x, 0 rotate <0, 45, 0> }

      // Kldervinduer
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <23.50*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <34.70*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <40.00*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <51.75*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <60.05*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <68.35*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <76.65*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <84.95*BWidth, -5.5*BHeight, 0> }

      object { B4MurCutout1 translate <5*BWidth, 0, 0> }
      box { <9.375*BWidth, 24*BHeight, -1>, <11.125*BWidth, 34.5*BHeight, 51> }
      box { <20.25*BWidth, 17*BHeight, -1>, <26.75*BWidth, 38*BHeight, 51> }
      object { B4MurCutout1 translate <32.1*BWidth, 0, 0> }
      object { B4Vindue5BueCutout translate <32.1*BWidth, 0, 0> }
      box { <48.85*BWidth, 17*BHeight, -1>, <54.65*BWidth, 45*BHeight, 51> }
      box { <57.15*BWidth, 17*BHeight, -1>, <62.95*BWidth, 45*BHeight, 51> }
      box { <65.45*BWidth, 17*BHeight, -1>, <71.25*BWidth, 45*BHeight, 51> }
      box { <73.75*BWidth, 17*BHeight, -1>, <79.55*BWidth, 45*BHeight, 51> }
      box { <82.05*BWidth, 17*BHeight, -1>, <87.85*BWidth, 45*BHeight, 51> }
      box { <91.35*BWidth, 0, -1>, <98.75*BWidth, 41*BHeight, 51> } // Dr
      cylinder { <0, 0, -1>, <0, 0, 51>, 3.7*BWidth scale <1, 1/1.2, 1> translate <95.05*BWidth, 41*BHeight, 0> }

      box { <9.375*BWidth, 74*BHeight, -1>, <11.125*BWidth, 84.5*BHeight, 51> }
      box { <20.25*BWidth, 67*BHeight, -1>, <26.75*BWidth, 88*BHeight, 51> }
      box { <32.10*BWidth, 67*BHeight, -1>, <42.60*BWidth, 95*BHeight, 51> }
      box { <48.85*BWidth, 67*BHeight, -1>, <54.65*BWidth, 95*BHeight, 51> }
      box { <57.15*BWidth, 67*BHeight, -1>, <62.95*BWidth, 95*BHeight, 51> }
      box { <65.45*BWidth, 67*BHeight, -1>, <71.25*BWidth, 95*BHeight, 51> }
      box { <73.75*BWidth, 67*BHeight, -1>, <79.55*BWidth, 95*BHeight, 51> }
      box { <85.80*BWidth, 67*BHeight, -1>, <96.30*BWidth, 95*BHeight, 51> }

      box { <9.375*BWidth, 125*BHeight, -1>, <11.125*BWidth, 135.5*BHeight, 51> }
      box { <20.25*BWidth, 118*BHeight, -1>, <26.75*BWidth, 139*BHeight, 51> }
      box { <32.10*BWidth, 118*BHeight, -1>, <42.60*BWidth, 146*BHeight, 51> }
      box { <48.85*BWidth, 118*BHeight, -1>, <54.65*BWidth, 146*BHeight, 51> }
      box { <57.15*BWidth, 118*BHeight, -1>, <62.95*BWidth, 146*BHeight, 51> }
      box { <65.45*BWidth, 118*BHeight, -1>, <71.25*BWidth, 146*BHeight, 51> }
      box { <73.75*BWidth, 118*BHeight, -1>, <79.55*BWidth, 146*BHeight, 51> }
      box { <85.80*BWidth, 118*BHeight, -1>, <96.30*BWidth, 146*BHeight, 51> }

      box { <9.375*BWidth, 175*BHeight, -1>, <11.125*BWidth, 185.5*BHeight, 51> }
      box { <20.25*BWidth, 168*BHeight, -1>, <26.75*BWidth, 189*BHeight, 51> }
      box { <32.10*BWidth, 168*BHeight, -1>, <42.60*BWidth, 196*BHeight, 51> }
      box { <48.85*BWidth, 168*BHeight, -1>, <54.65*BWidth, 196*BHeight, 51> }
      box { <57.15*BWidth, 168*BHeight, -1>, <62.95*BWidth, 196*BHeight, 51> }
      box { <65.45*BWidth, 168*BHeight, -1>, <71.25*BWidth, 196*BHeight, 51> }
      box { <73.75*BWidth, 168*BHeight, -1>, <79.55*BWidth, 196*BHeight, 51> }
      box { <85.80*BWidth, 168*BHeight, -1>, <96.30*BWidth, 196*BHeight, 51> }
   }
   difference {  // Gavltrekant
      box { <43*BWidth, 202*BHeight, 0>, <86*BWidth, 295*BHeight, 50> }
      box { <52.25*BWidth, 219*BHeight, -1>, <76.75*BWidth, 241*BHeight, 51> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 6*BHeight scale <17/12, 1, 1> translate <64.5*BWidth, 271*BHeight, 0> }
      plane { x, 0 rotate <0, 0, -41> translate <64.50*BWidth, 295*BHeight, 0> }
      plane {-x, 0 rotate <0, 0,  41> translate <64.50*BWidth, 295*BHeight, 0> }
   }

   difference { // Over kldervinduer
      box { <1, 3*BHeight, BWidth/2>, <88*BWidth, 6*BHeight, 50> }
      box { <32.1*BWidth, 0, -1>, <42.6*BWidth, 7*BHeight, BWidth> }
      texture { T_Sandstone }
   }
   box { <45.50*BWidth, 217*BHeight, -0.1>, <83.50*BWidth, 219*BHeight, 50> texture { T_Sandstone } }
   box { <55.50*BWidth, 219*BHeight, -0.1>, <56.50*BWidth, 241*BHeight, 50> texture { T_Sandstone } }
   box { <59.75*BWidth, 219*BHeight, -0.1>, <60.75*BWidth, 241*BHeight, 50> texture { T_Sandstone } }
   box { <64.00*BWidth, 219*BHeight, -0.1>, <65.00*BWidth, 241*BHeight, 50> texture { T_Sandstone } }
   box { <68.25*BWidth, 219*BHeight, -0.1>, <69.25*BWidth, 241*BHeight, 50> texture { T_Sandstone } }
   box { <72.50*BWidth, 219*BHeight, -0.1>, <73.50*BWidth, 241*BHeight, 50> texture { T_Sandstone } }
   box { <51.50*BWidth, 241*BHeight, -0.1>, <77.50*BWidth, 243*BHeight, 50> texture { T_Sandstone } }

   object { B4KaelderVindue translate <21.70*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <32.90*BWidth, -4.5*BHeight, BWidth> }
   object { B4KaelderVindue translate <38.20*BWidth, -4.5*BHeight, BWidth> }
   object { B4KaelderVindue translate <49.95*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <58.25*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <66.55*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <74.85*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <83.15*BWidth, -4.5*BHeight, BWidth/2> }

   object { B4Vindue1 translate <9.375*BWidth, 25*BHeight, BWidth> }
   object { B4Vindue2 translate <20.25*BWidth, 18*BHeight, BWidth/2> }
   box { <23*BWidth, 17*BHeight, 0>, <24*BWidth, 38*BHeight, 50> texture { T_Sandstone } }
   object { B4Vindue2 translate <24.00*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue5Bue translate <32.10*BWidth, 18*BHeight, BWidth> }
   object { B4Vindue3 translate <48.85*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue3 translate <57.15*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue3 translate <65.40*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue3 translate <73.75*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue3 translate <82.05*BWidth, 18*BHeight, BWidth/2> }
   object { B4Doer1 translate <95.05*BWidth, 0, 0> }

   object { B4Saalbaenk1 translate < 9.375*BWidth, 25*BHeight, BWidth> }
   object { B4Saalbaenk2 translate <20.25*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk5 translate <32.10*BWidth, 18*BHeight, BWidth> }
   object { B4Saalbaenk3x5 translate <48.85*BWidth, 18*BHeight, BWidth/2> }

   object { B4Vindue1 translate <9.375*BWidth, 75*BHeight, BWidth/2> }
   object { B4Vindue2 translate <20.25*BWidth, 68*BHeight, BWidth/2> }
   box { <23*BWidth, 67*BHeight, 0>, <24*BWidth, 88*BHeight, 50> texture { T_Sandstone } }
   object { B4Vindue2 translate <24.00*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue5 translate <32.10*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue3 translate <48.85*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue3 translate <57.15*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue3 translate <65.40*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue3 translate <73.75*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue5 translate <85.80*BWidth, 68*BHeight, BWidth/2> }

   object { B4Saalbaenk1 translate < 9.375*BWidth, 75*BHeight, BWidth/2> }
   object { B4Saalbaenk2 translate <20.25*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk5 translate <32.10*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk3 translate <48.85*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk3 translate <57.15*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk3 translate <65.40*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk3 translate <73.75*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk5 translate <85.80*BWidth, 68*BHeight, BWidth/2> }

   object { B4Vindue1 translate <9.375*BWidth, 126*BHeight, BWidth/2> }
   object { B4Vindue2 translate <20.25*BWidth, 119*BHeight, BWidth/2> }
   box { <23*BWidth, 118*BHeight, 0>, <24*BWidth, 139*BHeight, 50> texture { T_Sandstone } }
   object { B4Vindue2 translate <24.00*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue5 translate <32.10*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue3 translate <48.85*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue3 translate <57.15*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue3 translate <65.40*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue3 translate <73.75*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue5 translate <85.80*BWidth, 119*BHeight, BWidth/2> }

   object { B4Saalbaenk1 translate < 9.375*BWidth, 126*BHeight, BWidth/2> }
   object { B4Saalbaenk2 translate <20.25*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk5 translate <32.10*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk3 translate <48.85*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk3 translate <57.15*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk3 translate <65.40*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk3 translate <73.75*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk5 translate <85.80*BWidth, 119*BHeight, BWidth/2> }

   object { B4Vindue1 translate <9.375*BWidth, 176*BHeight, BWidth/2> }
   object { B4Vindue2 translate <20.25*BWidth, 169*BHeight, BWidth/2> }
   box { <23*BWidth, 168*BHeight, 0>, <24*BWidth, 189*BHeight, 50> texture { T_Sandstone } }
   object { B4Vindue2 translate <24.00*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue5 translate <32.10*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue3 translate <48.85*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue3 translate <57.15*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue3 translate <65.40*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue3 translate <73.75*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue5 translate <85.80*BWidth, 169*BHeight, BWidth/2> }

   difference {
      box { <-0.1, 164*BHeight, -0.1>, <102.25*BWidth, 166*BHeight, 50> }
      plane { x, 0 rotate <0, 45, 0> }
      texture { T_Sandstone }
   }
   difference {
      object { B4SaalbaenkProfil scale <103.5*BWidth, 1, 1> translate <-1.25*BWidth, 0, BWidth/2> }
      plane { x, 0 rotate <0, 45,0> }
      texture { T_B4Saalbaenk translate <-4, 10, -100> }
      translate <0, 169*BHeight, 0>
   }
   object { B4Saalbaenk1 translate < 9.375*BWidth, 176*BHeight, BWidth/2> }

   object { B4Vindue7Gavl translate <52.25*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue7Gavl translate <56.50*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue7Gavl translate <60.75*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue7Gavl translate <65.00*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue7Gavl translate <69.25*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue7Gavl translate <73.50*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue8 translate <64.50*BWidth, 271*BHeight, BWidth/2-3> }

   object { B4Saalbaenk7Gavl translate <52.25*BWidth, 219*BHeight, 0> }
   object { B4Saalbaenk7Gavl translate <56.50*BWidth, 219*BHeight, 0> }
   object { B4Saalbaenk7Gavl translate <60.75*BWidth, 219*BHeight, 0> }
   object { B4Saalbaenk7Gavl translate <65.00*BWidth, 219*BHeight, 0> }
   object { B4Saalbaenk7Gavl translate <69.25*BWidth, 219*BHeight, 0> }
   object { B4Saalbaenk7Gavl translate <73.50*BWidth, 219*BHeight, 0> }

   difference {
      object { B4TagGesimsprofil scale <48*BWidth, 1, 1> translate <-1.5*BWidth, 202*BHeight, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <43.75*BWidth, 0, 0> }
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <47.4*BWidth, 1, 1> translate <-2.25*BWidth, 0, -33> }
      plane { x, 0 rotate <0, 45, 0> }
      texture { T_LinedZink rotate <0, 0, 90> translate <-2.25*BWidth, 0, 0>  }
      translate <0, 207*BHeight, 0>
   }
   object { B4TagrendeEnde translate <45.1*BWidth, 207*BHeight, -33> }

   difference {
      object { B4TagGesimsprofil scale <2*BWidth, 1, 1> translate <-1.5*BWidth, 202*BHeight, 0> }
      plane { x, 0 rotate <0, 45, 0>}
      rotate <0, -90, 0> translate <43.75*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <2*BWidth, 1, 1> translate <-0.5*BWidth, 202*BHeight, 0> }
      plane {-x, 0 rotate <0, -45, 0>}
      rotate <0, 90, 0> translate <85.25*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <18.5*BWidth, 1, 1> translate <-1.5*BWidth, 202*BHeight, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      translate <85.25*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   object { B4Tagrendeprofil scale <18.4*BWidth, 1, 1> translate <0, 0, -33>
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <83.875*BWidth, 207*BHeight, 0>
   }
   object { B4TagrendeEnde translate <83.9*BWidth, 207*BHeight, -33> }
   object { B4TagrendeEnde translate <102.3*BWidth, 207*BHeight, -33> }

   difference {
      object { B4TagGesimsprofil scale <130*BHeight, 1, 1> translate <-7*BHeight, 0, 0> rotate <0, 0, -49> }
      plane { x, 0 }
      plane { y, 0 translate <0, -87*BHeight, 0> }
      translate <64.5*BWidth, 295*BHeight, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <130*BHeight, 1, 1> translate <-7*BHeight, 0, 0> rotate <0, 0, -49> }
      plane { x, 0 }
      plane { y, 0 translate <0, -87*BHeight, 0> }
      scale <-1, 1, 1>
      translate <64.5*BWidth, 295*BHeight, 0>
      texture { T_Sandstone }
   }
   object { B4Nedloeb translate <18*BWidth, 0, 0> }
   object { B4Nedloeb translate <101.3*BWidth, 0, 0> }


   //Gavltrekanttag
   box { <-7*BHeight, 6*BHeight, -4.99*BHeight>, <121*BHeight, 6*BHeight+2, 19*BWidth> rotate <0, 0, -49> texture { T_Tagsten rotate <0,  90, 0> translate <0, -500, 0> } translate <64.5*BWidth, 295*BHeight, 0> }
   box { <-121*BHeight, 6*BHeight, -4.99*BHeight>, <7*BHeight, 6*BHeight+1, 19*BWidth> rotate <0, 0,  49> texture { T_Tagsten rotate <0, -90, 0> translate <0, -500, 0> } translate <64.5*BWidth, 295*BHeight, 0> }
   object { B4Rygningprofil scale <1, 1, 20*BWidth> texture { T_Rygning } translate <64.5*BWidth, 303*BHeight, -5*BHeight> }
   cylinder { <0, 0, -5*BHeight>, <0, 0, 19*BHeight>, 9 texture { T_Sandstone } translate <64.5*BWidth, 303*BHeight, 0> }

//   object { SMASign scale 1.5 translate <0.25*BWidth, 40*BHeight, 0> }

   texture { T_B4Brick }
}

#local B4Mur2=union{
   difference {
      box { <0, -5*BHeight, 0>, <58*BWidth, 3*BHeight, 50> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <58*BWidth, 0, 0> }
      box { <42.75*BWidth, -1, -1>, <53.25*BWidth, 4*BHeight, BWidth/2> }
      // Kldervinduer
      box { <16.05*BWidth, -6*BHeight, -1>, <19.65*BWidth, 4*BHeight, 51> }
      box { <28.075*BWidth, -6*BHeight, -1>, <31.675*BWidth, 4*BHeight, 51> }
      box { <46.20*BWidth, -6*BHeight, -1>, <49.80*BWidth, 4*BHeight, 51> }
      texture { T_Granit }
   }
   difference {
      box { <0, 3*BHeight, 0>, <58*BWidth, 202*BHeight, 50> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <58*BWidth, 0, 0> }

      // Kldervinduer
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <17.85*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <29.875*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <48.00*BWidth, -5.5*BHeight, 0> }
      object { B4MurCutout1 translate <42.75*BWidth, 0, 0> }

      box { < 2.20*BWidth, 17*BHeight, -1>, < 9.95*BWidth, 45*BHeight, 51> }
      box { <16.15*BWidth, 17*BHeight, -1>, <19.55*BWidth, 39*BHeight, 51> }
      box { <25.75*BWidth, 17*BHeight, -1>, <34.00*BWidth, 45*BHeight, 51> }
      object { B4Vindue4BueCutout translate <43.875*BWidth, 0, 0> }

      box { < 2.20*BWidth, 67*BHeight, -1>, < 9.95*BWidth, 95*BHeight, 51> }
      box { <16.15*BWidth, 67*BHeight, -1>, <19.55*BWidth, 89*BHeight, 51> }
      box { <25.75*BWidth, 67*BHeight, -1>, <34.00*BWidth, 95*BHeight, 51> }
      box { <43.875*BWidth, 67*BHeight, -1>, <52.125*BWidth, 95*BHeight, 51> }

      box { < 2.20*BWidth, 118*BHeight, -1>, < 9.95*BWidth, 146*BHeight, 51> }
      box { <16.15*BWidth, 118*BHeight, -1>, <19.55*BWidth, 140*BHeight, 51> }
      box { <25.75*BWidth, 118*BHeight, -1>, <34.00*BWidth, 146*BHeight, 51> }
      box { <43.875*BWidth, 118*BHeight, -1>, <52.125*BWidth, 146*BHeight, 51> }

      box { < 2.20*BWidth, 168*BHeight, -1>, < 9.95*BWidth, 196*BHeight, 51> }
      box { <16.15*BWidth, 168*BHeight, -1>, <19.55*BWidth, 190*BHeight, 51> }
      box { <25.75*BWidth, 168*BHeight, -1>, <34.00*BWidth, 196*BHeight, 51> }
      box { <43.875*BWidth, 168*BHeight, -1>, <52.125*BWidth, 196*BHeight, 51> }
   }

   difference {
      union {
         box { <20*BWidth, 202*BHeight, 0>, <58*BWidth, 246*BHeight, 50> }
         box { <20*BWidth, 246*BHeight, -1>, <58*BWidth, 247*BHeight, 50> texture { T_Sandstone } }
      }
      box { <28.875*BWidth, 218*BHeight, -1>, <49.125*BWidth, 241*BHeight, 51> }
      cylinder { <0, 0, -2>, <0, 0, 51>, 5*BWidth scale <1, 13/5, 1> translate <17.5*BWidth, 250*BHeight, 0> }
      cylinder { <0, 0, -2>, <0, 0, 51>, 5*BWidth scale <1, 13/5, 1> translate <60.5*BWidth, 250*BHeight, 0> }
   }
   difference {
      intersection {
         box { <18.7*BWidth, 208*BHeight, -0.1>, <23*BWidth, 247*BHeight, 50> }
         cylinder { <0, 0, -2>, <0, 0, 51>, 5*BWidth scale <1, 13/5, 1> translate <17.5*BWidth, 250*BHeight, 0> }
      }
      cylinder { <0, 0, -2>, <0, 0, 51>, 5*BWidth scale <1, 13/5, 1> translate <16.3*BWidth, 250*BHeight, 0> }
      texture { T_Sandstone }
   }
   difference {
      intersection {
         box { <55*BWidth, 208*BHeight, -0.1>, <59.3*BWidth, 247*BHeight, 50> }
         cylinder { <0, 0, -2>, <0, 0, 51>, 5*BWidth scale <1, 13/5, 1> translate <60.5*BWidth, 250*BHeight, 0> }
      }
      cylinder { <0, 0, -2>, <0, 0, 51>, 5*BWidth scale <1, 13/5, 1> translate <61.7*BWidth, 250*BHeight, 0> }
      texture { T_Sandstone }
   }

   difference { // Over kldervinduer
      box { <15*BWidth, 3*BHeight, BWidth/2>, <50*BWidth, 6*BHeight, 50> }
      box { <44*BWidth, 0, -1>, <52*BWidth, 7*BHeight, BWidth> }
      texture { T_Sandstone }
   }

   box { <32.125*BWidth, 218*BHeight, -0.1>, <33.125*BWidth, 241*BHeight, 50> texture { T_Sandstone } }
   box { <36.375*BWidth, 218*BHeight, -0.1>, <37.375*BWidth, 241*BHeight, 50> texture { T_Sandstone } }
   box { <40.625*BWidth, 218*BHeight, -0.1>, <41.625*BWidth, 241*BHeight, 50> texture { T_Sandstone } }
   box { <44.875*BWidth, 218*BHeight, -0.1>, <45.875*BWidth, 241*BHeight, 50> texture { T_Sandstone } }
   box { <22.4*BWidth, 241*BHeight, -0.1>, <55.6*BWidth, 243*BHeight, 50> texture { T_Sandstone } }

   object { B4KaelderVindue translate <16.05*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <28.075*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <46.20*BWidth, -4.5*BHeight, BWidth> }

   object { B4Vindue4 scale <7.75/8.25, 1, 1> translate < 2.20*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue7 translate <16.15*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue4 translate <25.75*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue4Bue translate <43.875*BWidth, 18*BHeight, BWidth> }

   object { B4Saalbaenk4A translate <2.20*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk7 translate <16.15*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <25.75*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <43.875*BWidth, 18*BHeight, BWidth> }

   object { B4Vindue4 scale <7.75/8.25, 1, 1> translate < 2.20*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue7 translate <16.15*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue4 translate <25.75*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue4 translate <43.875*BWidth, 68*BHeight, BWidth/2> }

   object { B4Saalbaenk4A translate <2.20*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk7 translate <16.15*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <25.75*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <43.875*BWidth, 68*BHeight, BWidth/2> }

   object { B4Vindue4 scale <7.75/8.25, 1, 1> translate < 2.20*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue7 translate <16.15*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue4 translate <25.75*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue4 translate <43.875*BWidth, 119*BHeight, BWidth/2> }

   object { B4Saalbaenk4A translate <2.20*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk7 translate <16.15*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <25.75*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <43.875*BWidth, 119*BHeight, BWidth/2> }

   object { B4Vindue4 scale <7.75/8.25, 1, 1> translate < 2.20*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue7 translate <16.15*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue4 translate <25.75*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue4 translate <43.875*BWidth, 169*BHeight, BWidth/2> }
   box { <0.1, 196*BHeight, -0.1>, <11.5*BWidth, 198*BHeight, 50> texture { T_Sandstone } }

   difference {
      box { <-0.1, 164*BHeight, -0.1>, <58*BWidth, 166*BHeight, 50> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <58*BWidth, 0, 0> }
      texture { T_Sandstone }
   }
   difference {
      object { B4SaalbaenkProfil scale <60.5*BWidth, 1, 1> translate <-1.25*BWidth, 0, BWidth/2> }
      plane { x, 0 rotate <0, 45,0> }
      plane {-x, 0 rotate <0, -45, 0> translate <58*BWidth, 0, 0> }
      texture { T_B4Saalbaenk translate <-4, 10, -100> }
      translate <0, 169*BHeight, 0>
   }

   object { B4Vindue7Gavl translate <28.875*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue7Gavl translate <33.125*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue7Gavl translate <37.375*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue7Gavl translate <41.625*BWidth, 219*BHeight, BWidth/2-3> }
   object { B4Vindue7Gavl translate <45.875*BWidth, 219*BHeight, BWidth/2-3> }

   object { B4SaalbaenkProfil scale <20.75*BWidth-B4SaalbaenkMortar, 1, 1>
            texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
            translate <B4SaalbaenkMortar/2-BWidth/4, 0, BWidth/2>
            translate <28.875*BWidth, 219*BHeight, 0>
   }

   difference {
      object { B4TagGesimsprofil scale <2*BWidth, 1, 1> translate <-1.5*BWidth, 202*BHeight, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      rotate <0, -90, 0> translate <22*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <25*BWidth, 1, 1> translate <-1.5*BWidth, 202*BHeight, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <22*BWidth, 0, 0>}
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <2*BWidth, 1, 1> translate <-0.5*BWidth, 202*BHeight, 0> }
      plane {-x, 0 rotate <0, -45, 0>}
      rotate <0, 90, 0> translate <56*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <5*BWidth, 1, 1> translate <-1.5*BWidth, 202*BHeight, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <2*BWidth, 0, 0>}
      translate <56*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <5.5*BWidth, 1, 1> translate <0, 0, -33> }
      plane {-x, 0 rotate <0, -45, 0> translate <3.4*BWidth, 0, 0>}
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <54.6*BWidth, 207*BHeight, 0>
   }
   object { B4TagrendeEnde translate <54.6*BWidth, 207*BHeight, -33> }

   difference {
      object { B4TagGesimsprofil scale <3*BWidth, 1, 1> translate <-1.5*BWidth, 247*BHeight, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      rotate <0, 90, 0> translate <21.8*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <3.5*BWidth, 1, 1> translate <-1.5*BWidth, 0, -33> }
      plane {-x, 0 rotate <0, -45, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      rotate <0, 90, 0> translate <21.8*BWidth, 252*BHeight, 0>
   }
   object { B4TagrendeEnde translate <-1.5*BWidth, 0, -33> rotate <0, 90, 0> translate <21.8*BWidth, 252*BHeight, 0> }
   difference {
      object { B4TagGesimsprofil scale <38*BWidth, 1, 1> translate <-1.5*BWidth, 247*BHeight, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <34.4*BWidth, 0, 0>}
      translate <21.8*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <39*BWidth, 1, 1> translate <-2*BWidth, 0, -33> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <34.4*BWidth, 0, 0>}
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <21.8*BWidth, 252*BHeight, 0>
   }
   difference {
      object { B4TagGesimsprofil scale <3*BWidth, 1, 1> translate <-1.5*BWidth, 247*BHeight, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      rotate <0, -90, 0> translate <56.2*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <3.5*BWidth, 1, 1> translate <-2*BWidth, 0, -33> }
      plane { x, 0 rotate <0,  45, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      rotate <0, -90, 0> translate <56.2*BWidth, 252*BHeight, 0>
   }
   object { B4TagrendeEnde translate <1.5*BWidth, 0, -33> rotate <0, -90, 0> translate <56.2*BWidth, 252*BHeight, 0> }
   object { B4Nedloeb translate <24.5*BWidth, 45*BHeight, 0> }

//   object { SMPSign scale 1.5 translate <53.5*BWidth, 40*BHeight, 0> }

   texture { T_B4Brick }
}

#local B4Mur3Del1=union{
   difference {
      box { <-9.75*BWidth, -5*BHeight, 0>, <0, 3*BHeight, 50> }
      plane {-x, 0 rotate <0, -45, 0> }
      texture { T_Granit }
   }
   difference {
      box { <-9.75*BWidth, 3*BHeight, 0>, <0, 202*BHeight, 50> }
      plane {-x, 0 rotate <0, -45, 0> }

      box { <-9.50*BWidth,  17*BHeight, -1>, < -2.00*BWidth,  45*BHeight, 51> }
      box { <-9.50*BWidth,  67*BHeight, -1>, < -2.00*BWidth,  95*BHeight, 51> }
      box { <-9.50*BWidth, 118*BHeight, -1>, < -2.00*BWidth, 146*BHeight, 51> }
      box { <-9.50*BWidth, 168*BHeight, -1>, < -2.00*BWidth, 196*BHeight, 51> }
   }

   object { B4Vindue4 scale <7.5/8.25, 1, 1> translate <-9.50*BWidth,  18*BHeight, BWidth/2> }
   object { B4Saalbaenk4B translate <0, 18*BHeight, BWidth/2> }
   box { <-9.75*BWidth, 45*BHeight, -0.1>, <-0.1, 47*BHeight, 50> texture { T_Sandstone } }
   object { B4Saalbaenk4B translate <0, 50*BHeight, BWidth/2> }

   object { B4Vindue4 scale <7.5/8.25, 1, 1> translate <-9.50*BWidth,  68*BHeight, BWidth/2> }
   object { B4Saalbaenk4B translate <0, 68*BHeight, BWidth/2> }
   box { <-9.75*BWidth, 95*BHeight, -0.1>, <-0.1, 97*BHeight, 50> texture { T_Sandstone } }
   object { B4Saalbaenk4B translate <0, 100*BHeight, BWidth/2> }

   object { B4Vindue4 scale <7.5/8.25, 1, 1> translate <-9.50*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk4B translate <0, 119*BHeight, BWidth/2> }
   box { <-9.75*BWidth, 146*BHeight, -0.1>, <-0.1, 148*BHeight, 50> texture { T_Sandstone } }
   object { B4Saalbaenk4B translate <0, 151*BHeight, BWidth/2> }

   box { <-9.75*BWidth, 164*BHeight, -0.1>, <-0.1, 166*BHeight, 50> texture { T_Sandstone } }
   object { B4Vindue4 scale <7.5/8.25, 1, 1> translate <-9.50*BWidth, 169*BHeight, BWidth/2> }
   object { B4Saalbaenk4B translate <0, 170*BHeight, BWidth/2> }
   box { <-9.75*BWidth, 196*BHeight, -0.1>, <-0.1, 198*BHeight, 50> texture { T_Sandstone } }

   difference {
      object { B4TagGesimsprofil scale <13*BWidth, 1, 1> translate <-11.5*BWidth, 202*BHeight, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      texture { T_Sandstone }
   }

   texture { T_B4Brick translate <20*BWidth, 0, 0> }
}

#local B4Mur3Del2=union{
   box { <-16.25*BWidth, -5*BHeight, 0>, <0, 3*BHeight, 50> texture { T_Granit } }
   difference {
      box { <-18*BWidth, 3*BHeight, 0>, <0, 250*BHeight, 50> }
      cylinder { <0, 0, -200>, <0, 0, 100>, 5*BWidth scale <1, 13/5, 1> rotate <0, 45, 0> translate <4.5*BWidth, 250*BHeight, 0> }

      box { <-12.60*BWidth,  17*BHeight, -1>, < -4.35*BWidth,  45*BHeight, 51> }
      box { <-12.60*BWidth,  67*BHeight, -1>, < -4.35*BWidth,  95*BHeight, 51> }
      box { <-12.60*BWidth, 118*BHeight, -1>, < -4.35*BWidth, 146*BHeight, 51> }
      box { <-12.60*BWidth, 168*BHeight, -1>, < -4.35*BWidth, 196*BHeight, 51> }
      box { <-16.10*BWidth, 219*BHeight, -1>, < -6.35*BWidth, 241*BHeight, 51> }
   }

   object { B4Vindue4 translate <-12.60*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <-12.60*BWidth, 18*BHeight, BWidth/2> }
   box { <-16.25*BWidth, 45*BHeight, -0.1>, <0, 47*BHeight, 50> texture { T_Sandstone } }
   object { B4SaalbaenkProfil scale <16.25*BWidth-B4SaalbaenkMortar, 1, 1>
            texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
            translate <B4SaalbaenkMortar/2-BWidth/4, 0, BWidth/2>
            translate <-16.25*BWidth, 50*BHeight, 0>
   }

   object { B4Vindue4 translate <-12.60*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <-12.60*BWidth, 68*BHeight, BWidth/2> }

   object { B4Vindue4 translate <-12.60*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <-12.60*BWidth, 119*BHeight, BWidth/2> }

   box { <-16.25*BWidth, 164*BHeight, -0.1>, <0, 166*BHeight, 50> texture { T_Sandstone } }

   object { B4Vindue4 translate <-12.60*BWidth, 169*BHeight, BWidth/2> }
   object { B4SaalbaenkProfil scale <16.25*BWidth-B4SaalbaenkMortar, 1, 1>
            texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
            translate <B4SaalbaenkMortar/2-BWidth/4, 0, BWidth/2>
            translate <-16.25*BWidth, 169*BHeight, 0>
   }

   object { B4Vindue9 translate <-16.10*BWidth, 219*BHeight, BWidth/2> }
   object { B4Saalbaenk9 translate <-16.10*BWidth, 220*BHeight, BWidth/2> }

   difference {
      object { B4TagGesimsprofil scale <18*BWidth, 1, 1> translate <-18*BWidth, 247*BHeight, 0.5*BWidth> }
      plane {-x, 0 rotate <0, -22.5, 0> translate <-2.5*BWidth, 0, 0> }
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <18*BWidth, 1, 1> translate <-18*BWidth, 0, 0.5*BWidth-33> }
      plane { x, 0 rotate <0, -22.5, 0> translate <-16.25*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> translate <-2.5*BWidth, 0, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <0, 252*BHeight, 0>
   }

   difference {
      intersection {
         box { <-4*BWidth, 3*BHeight, -0.5>, <BWidth, 250*BHeight, 100> }
         cylinder { <0, 0, -200>, <0, 0, 200>, 5.5*BWidth scale <1, 13/5, 1> rotate <0, 45, 0> translate <4.5*BWidth, 250*BHeight, 0> }
      }
      cylinder { <0, 0, -200>, <0, 0, 200>, 4.95*BWidth scale <1, 13/5, 1> rotate <0, 45, 0> translate <4.5*BWidth, 250*BHeight, 0> }
      texture { T_LinedIr }
   }

   texture { T_B4Brick translate <40*BWidth, 0, 0> }
}

#local B4Mur3Del3=union{
   difference {
      box { <-9.25*BWidth, -5*BHeight, 0>, <0, 3*BHeight, 50> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }
      texture { T_Granit }
   }
   difference {
      box { <-9.25*BWidth, 3*BHeight, 0>, <0, 202*BHeight, 50> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }

      box { <-7.75*BWidth,  17*BHeight, -1>, < -2.25*BWidth,  45*BHeight, 51> }
      box { <-7.75*BWidth,  67*BHeight, -1>, < -2.25*BWidth,  95*BHeight, 51> }
      box { <-7.75*BWidth, 118*BHeight, -1>, < -2.25*BWidth, 146*BHeight, 51> }
      box { <-7.75*BWidth, 168*BHeight, -1>, < -2.25*BWidth, 196*BHeight, 51> }
   }

   object { B4Vindue3 scale <5.5/5.8, 1, 1> translate <-7.75*BWidth,  18*BHeight, BWidth/2> }
   object { B4Saalbaenk3A translate <-7.75*BWidth, 18*BHeight, BWidth/2> }

   object { B4Vindue3 scale <5.5/5.8, 1, 1> translate <-7.75*BWidth,  68*BHeight, BWidth/2> }
   object { B4Saalbaenk3A translate <-7.75*BWidth, 68*BHeight, BWidth/2> }

   object { B4Vindue3 scale <5.5/5.8, 1, 1> translate <-7.75*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk3A translate <-7.75*BWidth, 119*BHeight, BWidth/2> }

   box { <-9.25*BWidth, 164*BHeight, -0.1>, <0, 166*BHeight, 50> texture { T_Sandstone } }

   object { B4Vindue3 scale <5.5/5.8, 1, 1> translate <-7.75*BWidth, 169*BHeight, BWidth/2> }
   difference {
      object { B4SaalbaenkProfil scale <10.25*BWidth-B4SaalbaenkMortar, 1, 1>
               texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
               translate <B4SaalbaenkMortar/2-BWidth/4, 0, BWidth/2>
               translate <-10.25*BWidth, 169*BHeight, 0>
      }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }
   }
   box { <-9.25*BWidth, 196*BHeight, -0.1>, <0, 199*BHeight, 50> texture { T_Sandstone } }

   difference {
      object { B4Mur3Gesimsprofil scale <11.25*BWidth, 1, 1> translate <-10.25*BWidth, 199*BHeight, 0> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <13*BWidth, 1, 1> translate <-11*BWidth, 0, -21> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, 22.5, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <0, 252*BHeight, 0>
   }

   difference {
      union {
         object { B4Mur3Kobberprofil scale <60, 1, 1> texture { T_LinedIr translate <0, -40, 0> } translate <-240, 0, 0> }
         object { B4Mur3Kobberprofil2 texture { T_Ir }  translate <-180, 0, 0> }
         object { B4Mur3Kobberprofil scale <60, 1, 1> texture { T_Ir }  translate <-180, 0, 0> }
         object { B4Mur3Kobberprofil2 texture { T_Ir }  translate <-120, 0, 0> }
         object { B4Mur3Kobberprofil scale <60, 1, 1> texture { T_LinedIr translate <0, -40, 0> } translate <-120, 0, 0> }
         object { B4Mur3Kobberprofil2 texture { T_Ir }  translate <-60, 0, 0> }
         object { B4Mur3Kobberprofil scale <90, 1, 1> texture { T_Ir }  translate < -60, 0, 0> }
         translate <0, 202*BHeight, 0.5*BWidth>
      }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }
      texture { T_Ir }
   }
   difference {
      object { B4Mur3Kobberprofil2 scale <25, 1, 1> translate <-235, 202*BHeight, 0.5*BWidth> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, 22.5, 0> translate <1-9.25*BWidth, 0, 0> }
      texture { T_Ir }
   }
   difference {
      object { B4Mur3Kobberprofil3 scale <11.25*BWidth, 1, 1> translate <-10.25*BWidth, 217*BHeight, 0.5*BWidth> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> translate <-BWidth, 0, 0.5*BWidth> }
      texture { T_Ir }
   }
   difference {
      object { B4Mur3Kobberprofil3 scale <1.5*BWidth, 1, 1> translate <-BWidth, 217*BHeight, 0> }
      plane { x, 0 rotate <0, 22.5, 0> }
      rotate <0, -45, 0> translate <-BWidth, 0, 0.5*BWidth>
      texture { T_Ir }
   }

   difference {
      box { <-9.25*BWidth, 202*BHeight, 0.5*BWidth>, <0, 247*BHeight, 50> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, 45, 0> translate <-BWidth, 0, 0.5*BWidth> }
      box { <-7.75*BWidth, 219*BHeight, -1>, < -2.25*BWidth, 241*BHeight, 51> }
      texture { T_Sandstone }
   }
   object { B4Vindue10 translate <-7.75*BWidth, 219*BHeight, BWidth> }

   difference {
      object { B4TagGesimsprofilA scale <11.25*BWidth, 1, 1> translate <-10.25*BWidth, 247*BHeight, 0.5*BWidth> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-9.25*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> translate <-BWidth, 0, 0.5*BWidth> }
      texture { T_Sandstone }
   }

   difference {
      object { B4TagGesimsprofilA scale <1.5*BWidth, 1, 1> translate <-BWidth, 247*BHeight, 0> }
      plane { x, 0 rotate <0, 22.5, 0> }
      rotate <0, -45, 0> translate <-BWidth, 0, 0.5*BWidth>
      texture { T_Sandstone }
   }


   texture { T_B4Brick translate <60*BWidth, 0, 0> }
}

#local B4Mur3Side=union{
   object { B4Mur3Del1 }
   object { B4Mur3Del2 rotate <0, -45, 0> translate <-9.75*BWidth, 0, 0> }
   object { B4Mur3Del3 rotate <0, -90, 0> translate <-21.2405*BWidth, 0, -11.4905*BWidth> }
}

#local B4Mur3Midt=union{
   difference {
      box { <-11.3406*BWidth, -5*BHeight, 0>, <0, 3*BHeight, 50> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-11.3406*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      texture { T_Granit }
   }
   difference {
      box { <-11.3406*BWidth, 3*BHeight, 0>, <0, 202*BHeight, 50> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-11.3406*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }

      box { <-9.80*BWidth,  17*BHeight, -1>, < -1.55*BWidth,  45*BHeight, 51> }
      box { <-9.80*BWidth,  67*BHeight, -1>, < -1.55*BWidth,  95*BHeight, 51> }
      box { <-9.80*BWidth, 118*BHeight, -1>, < -1.55*BWidth, 146*BHeight, 51> }
      box { <-9.80*BWidth, 168*BHeight, -1>, < -1.55*BWidth, 196*BHeight, 51> }
   }
   object { B4Vindue4 translate <-9.80*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <-9.80*BWidth, 18*BHeight, BWidth/2> }

   object { B4Vindue4 translate <-9.80*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <-9.80*BWidth, 68*BHeight, BWidth/2> }

   object { B4Vindue4 translate <-9.80*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <-9.80*BWidth, 119*BHeight, BWidth/2> }

   box { <-11.3406*BWidth, 164*BHeight, -0.1>, <0, 166*BHeight, 50> texture { T_Sandstone } }
   object { B4Vindue4 translate <-9.80*BWidth, 169*BHeight, BWidth/2> }
   difference {
      object { B4SaalbaenkProfil scale <13.35*BWidth-B4SaalbaenkMortar, 1, 1>
               texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
               translate <B4SaalbaenkMortar/2-BWidth/4, 0, BWidth/2>
               translate <-11.35*BWidth, 169*BHeight, 0>
      }
      plane { x, 0 rotate <0, 22.5, 0> translate <-11.3406*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
   }

   box { <-11.3406*BWidth, 196*BHeight, -0.1>, <0, 199*BHeight, 50> texture { T_Sandstone } }
   difference {
      object { B4Mur3Gesimsprofil scale <13.3406*BWidth, 1, 1> translate <-12.3406*BWidth, 199*BHeight, 0> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-11.3406*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <14*BWidth, 1, 1> translate <-12.5*BWidth, 0, -21> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-11.3406*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <0, 252*BHeight, 0>
   }

   difference {
      union {
         object { B4Mur3Kobberprofil scale <60, 1, 1> texture { T_Ir }  translate <-150, 0, 0> }
         object { B4Mur3Kobberprofil2 texture { T_Ir }  translate <-90, 0, 0> }
         object { B4Mur3Kobberprofil scale <60, 1, 1> texture { T_LinedIr translate <0, -40, 0> } translate <-90, 0, 0> }
         object { B4Mur3Kobberprofil2 texture { T_Ir }  translate <-30, 0, 0> }
         object { B4Mur3Kobberprofil scale <60, 1, 1> texture { T_Ir }  translate <-30, 0, 0> }
         object { B4Mur3Kobberprofil2 texture { T_Ir }  translate < 30, 0, 0> }
         object { B4Mur3Kobberprofil scale <60, 1, 1> texture { T_LinedIr translate <0, -40, 0> } translate < 30, 0, 0> }
         object { B4Mur3Kobberprofil2 texture { T_Ir }  translate < 90, 0, 0> }
         object { B4Mur3Kobberprofil scale <60, 1, 1> texture { T_Ir }  translate < 90, 0, 0> }
         translate <-136, 202*BHeight, 0.5*BWidth>
      }
      plane { x, 0 rotate <0, 22.5, 0> translate <-11.3406*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      texture { T_Ir }
   }
   difference {
      object { B4Mur3Kobberprofil3 scale <13.3406*BWidth, 1, 1> translate <-12.3406*BWidth, 217*BHeight, 0.5*BWidth> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-11.3406*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      texture { T_Ir }
   }
   difference {
      box { <-11.3406*BWidth, 202*BHeight, 0.5*BWidth>, <0, 247*BHeight, 50> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-11.3406*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }

      box { <-9.80*BWidth, 219*BHeight, -1>, < -1.55*BWidth, 241*BHeight, 51> }
      texture { T_Sandstone }
   }
   object { B4Vindue11 translate <-9.80*BWidth, 219*BHeight, BWidth> }

   difference {
      object { B4TagGesimsprofilA scale <13.3406*BWidth, 1, 1> translate <-12.3406*BWidth, 247*BHeight, 0.5*BWidth> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-11.3406*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      texture { T_Sandstone }
   }

   texture { T_B4Brick translate <2, 0, 0>  }
}

#local B4Mur3Kant=union{
   difference {
      box { <-8.00*BWidth, -5*BHeight, 0>, <0, 3*BHeight, 50> }
      plane {-x, 0 rotate <0, -45, 0> }
      box { <-7.1*BWidth, -6*BHeight, -1>, <-3.5*BWidth, 4*BHeight, 51> }
      texture { T_Granit }
   }
   difference {
      box { <-8.00*BWidth, 3*BHeight, 0>, <0, 202*BHeight, 50> }
      plane {-x, 0 rotate <0, -45, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <-5.3*BWidth, -5.5*BHeight, 0> }
      box { <-7.60*BWidth,  17*BHeight, -1>, < -2.10*BWidth,  45*BHeight, 51> }
      box { <-7.60*BWidth,  67*BHeight, -1>, < -2.10*BWidth,  95*BHeight, 51> }
      box { <-7.60*BWidth, 118*BHeight, -1>, < -2.10*BWidth, 146*BHeight, 51> }
      box { <-7.60*BWidth, 168*BHeight, -1>, < -2.10*BWidth, 196*BHeight, 51> }
   }

   // Over kldervindue
   box { <-7.1*BWidth, 3*BHeight, BWidth/2>, <-3.5*BWidth, 6*BHeight, 50> texture { T_Sandstone } }

   object { B4KaelderVindue translate <-7.1*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4Vindue3 scale <5.5/5.8, 1, 1> translate <-7.60*BWidth,  18*BHeight, BWidth/2> }
   object { B4Saalbaenk3B translate <0, 18*BHeight, BWidth/2> }
   box { <-8*BWidth, 45*BHeight, -0.1>, <0, 47*BHeight, 50> texture { T_Sandstone } }
   object { B4Saalbaenk3B translate <0, 50*BHeight, BWidth/2> }

   object { B4Vindue3 scale <5.5/5.8, 1, 1> translate <-7.60*BWidth,  68*BHeight, BWidth/2> }
   object { B4Saalbaenk3B translate <0, 68*BHeight, BWidth/2> }
   box { <-8*BWidth, 95*BHeight, -0.1>, <0, 97*BHeight, 50> texture { T_Sandstone } }
   object { B4Saalbaenk3B translate <0, 100*BHeight, BWidth/2> }

   object { B4Vindue3 scale <5.5/5.8, 1, 1> translate <-7.60*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk3B translate <0, 119*BHeight, BWidth/2> }
   box { <-8*BWidth, 146*BHeight, -0.1>, <0, 148*BHeight, 50> texture { T_Sandstone } }
   object { B4Saalbaenk3B translate <0, 151*BHeight, BWidth/2> }

   box { <-8*BWidth, 164*BHeight, -0.1>, <0, 166*BHeight, 50> texture { T_Sandstone } }
   object { B4Vindue3 scale <5.5/5.8, 1, 1> translate <-7.60*BWidth, 169*BHeight, BWidth/2> }
   object { B4Saalbaenk3B translate <0, 170*BHeight, BWidth/2> }
   box { <-8*BWidth, 196*BHeight, -0.1>, <0, 198*BHeight, 50> texture { T_Sandstone } }

   difference {
      object { B4TagGesimsprofil scale <9.5*BWidth, 1, 1> translate <-8*BWidth, 202*BHeight, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      texture { T_Sandstone }
   }

   texture { T_B4Brick translate <80*BWidth, 0, 0> }
}

#local B4Tagterrasse1=union {
    box { <0, -10, 0>, <21*BWidth, 0, 11*BWidth> } // Gulv
    box { <0, 0, 0>, <21*BWidth, 25, 23> }
    box { <0, 0, 23>, <23, 25, 11*BWidth> }
    box { <2, 25, 2>, <21*BWidth, 32, 21> }
    box { <2, 25, 21>, <21, 32, 11*BWidth> }
    difference { // Hjrne
       box { <3, 32, 3>, <40, 88, 40> }
       box { <20, 31, 20>, <41, 89, 41> }
    }
    difference {
       box { <40, 32, 4>, <21*BWidth, 88, 19> }
       #declare pos = 58;
       #while (pos < 440)
          cylinder { <0, 0, 0>, <0, 0, 20>,  8 scale <1, 2, 1> translate <pos, 60, 0> }
          cylinder { <0, 0, 0>, <0, 0,  6>, 10 scale <1, 2, 1> translate <pos, 60, 0> }
          #declare pos = pos + 27;
       #end
       texture { pigment { rgb <0.65, 0.65, 0.60> } }
    }
    difference {
       box { <4, 32, 40>, <19, 88, 11*BWidth> }
       #declare pos = 58;
       #while (pos < 230)
          cylinder { <0, 0, 0>, <20, 0, 00>,  8 scale <1, 2, 1> translate <0, 60, pos> }
          cylinder { <0, 0, 0>, < 6, 0, 0>, 10 scale <1, 2, 1> translate <0, 60, pos> }
          #declare pos = pos + 27;
       #end
       texture { pigment { rgb <0.65, 0.65, 0.60> } }
    }
    box { <-3, 88, -3>, <20.3*BWidth, 94, 26> }
    box { <-3, 88, 26>, <26, 94, 11*BWidth> }
    box { <-6, 94, -6>, <20.3*BWidth, 100, 29> }
    box { <-6, 94, 29>, <29, 100, 11*BWidth> }

    texture { T_Sandstone }
}

#local B4Tagterrasse2=union {
    box { <0, -10, 0>, <11*BWidth, 0, 9*BWidth> } // Gulv
    box { <0, 0, 0>, <11*BWidth, 25, 23> }
    box { <0, 0, 23>, <23, 25, 9*BWidth> }
    box { <2, 25, 2>, <11*BWidth, 32, 21> }
    box { <2, 25, 21>, <21, 32, 9*BWidth> }
    difference { // Hjrne
       box { <3, 32, 3>, <40, 88, 40> }
       box { <20, 31, 20>, <41, 89, 41> }
    }
    difference {
       box { <40, 32, 4>, <11*BWidth, 88, 19> }
       #declare pos = 58;
       #while (pos < 230)
          cylinder { <0, 0, 0>, <0, 0, 20>,  8 scale <1, 2, 1> translate <pos, 60, 0> }
          cylinder { <0, 0, 0>, <0, 0,  6>, 10 scale <1, 2, 1> translate <pos, 60, 0> }
          #declare pos = pos + 27;
       #end
       texture { pigment { rgb <0.65, 0.65, 0.60> } }
    }
    difference {
       box { <4, 32, 40>, <19, 88, 9*BWidth> }
       #declare pos = 58;
       #while (pos < 170)
          cylinder { <0, 0, 0>, <20, 0, 00>,  8 scale <1, 2, 1> translate <0, 60, pos> }
          cylinder { <0, 0, 0>, < 6, 0, 0>, 10 scale <1, 2, 1> translate <0, 60, pos> }
          #declare pos = pos + 27;
       #end
       texture { pigment { rgb <0.65, 0.65, 0.60> } }
    }
    box { <-3, 88, -3>, <11*BWidth, 94, 26> }
    box { <-3, 88, 26>, <26, 94, 8*BWidth> }
    box { <-6, 94, -6>, <11*BWidth, 100, 29> }
    box { <-6, 94, 29>, <29, 100, 8*BWidth> }

    texture { T_Sandstone }
}

#local B4Mur3TaarnDel1=difference {
   union {
      object { B4Mur3Taarnprofil scale <60, 1, 1> texture { T_LinedIr } translate <-120, 0, 0> }
      object { B4Mur3Taarnprofil texture { T_LinedIr } translate <-90, 3, -3> }
      object { B4Mur3Taarnprofil scale <60, 1, 1> texture { T_LinedIr translate <0, -42, 0> } translate <-60, 0, 0> }
      object { B4Mur3Taarnprofil texture { T_LinedIr } translate <-30, 3, -3> }
      object { B4Mur3Taarnprofil scale <60, 1, 1> texture { T_LinedIr } }
      object { B4Mur3Taarnprofil texture { T_LinedIr } translate < 30, 3, -3> }
      object { B4Mur3Taarnprofil scale <60, 1, 1> texture { T_LinedIr translate <0, -42, 0> } translate < 60, 0, 0> }
      object { B4Mur3Taarnprofil texture { T_LinedIr } translate < 90, 3, -3> }
      object { B4Mur3Taarnprofil scale <60, 1, 1> texture { T_LinedIr } translate < 120, 0, 0> }
   }
   plane { x, 0 rotate <0,  24.748, 0> }
   plane {-x, 0 rotate <0, -24.748, 0> }
   texture { T_Ir }
}

#local B4Mur3TaarnDel2=difference {
   union {
      object { B4Mur3Taarnprofil scale <90, 1, 13.53/13.1> texture { T_LinedIr translate <0, -42, 0> } translate <-75, 0, 0> }
      object { B4Mur3Taarnprofil scale <1, 1, 13.53/13.1> texture { T_LinedIr } translate <-30, 3, -3> }
      object { B4Mur3Taarnprofil scale <60, 1, 13.53/13.1> texture { T_LinedIr }  }
      object { B4Mur3Taarnprofil scale <1, 1, 13.53/13.1> texture { T_LinedIr } translate < 30, 3, -3> }
      object { B4Mur3Taarnprofil scale <90, 1, 13.53/13.1> texture { T_LinedIr translate <0, -42, 0> } translate < 75, 0, 0> }
   }
   plane { x, 0 rotate <0,  20.252, 0> }
   plane {-x, 0 rotate <0, -20.252, 0> }
   texture { T_Ir }
}

#local B4Mur3Taarn=union{
   #declare ang = 0;
   #while (ang < 360)
      object { B4Mur3Taarnprofil scale <1, 1, 1.1> texture { T_LinedIr } translate <0, 3, -3> rotate <0,  ang-24.748, 0> }
      object { B4Mur3TaarnDel1 rotate <0, ang, 0> }
      object { B4Mur3Taarnprofil scale <1, 1, 1.1> texture { T_LinedIr } translate <0, 3, -3> rotate <0,  ang+24.748, 0> }
      object { B4Mur3TaarnDel2 rotate <0, ang+45, 0> }
      #declare ang = ang + 90;
   #end
   cone { <0, 720, 0>, 4, <0, 1065, 0>, 3 texture { T_Zink } }
   translate <-5.6703*BWidth, 0, 12.211*BWidth>
}

#local B4Mur3=union{
   object { B4Mur3Side rotate <0, 90, 0> }
   object { B4Mur3Midt rotate <0, 45, 0> translate <-20.7405*BWidth, 0, 21.2405*BWidth> }
   object { B4Mur3Taarn rotate <0, 45, 0> translate <-20.7405*BWidth, 253*BHeight, 21.2405*BWidth> }
   object { B4Mur3Side scale <-1, 1, 1> translate <-50*BWidth, 0, 50*BWidth> }
   object { B4Mur3Kant rotate <0, 90, 0> translate <-50*BWidth, 0, 50*BWidth> }
   object { B4Tagterrasse1 translate <0, 208*BHeight, 0> }
   object { B4Tagterrasse2 translate <-50*BWidth, 208*BHeight, 50*BWidth> }
   object { B4Nedloeb rotate <0, 90, 0> translate <-38*BWidth, 45*BHeight, 48*BWidth> }

}

#local B4PortCutout=intersection {
   box { <-6.75*BWidth, 0, -1>, <6.75*BWidth, 55*BHeight, 76> }
   cylinder { <0, 19.3*BHeight, -2>, <0, 19.3*BHeight, 76>, 34.7*BHeight }
}

#local B4PortRamme=union {
//sokkel
   union {
      box { <-1.5*BWidth, 0, -0.1>, <0, 5*BHeight, 66> }
      difference {
         cylinder { <0, 0, -0.10>, <0, 0, 66>, 5*BHeight scale <0.6, 1, 1> }
         plane { x, 0 }
         plane { y, 0 }
      }
      texture { T_Granit }
      translate <-6*BWidth, 0, 0>
   }
   union {
      box { <0, 0, -0.1>, <3*BWidth, 5*BHeight, 66> }
      difference {
         cylinder { <0, 0, -0.10>, <0, 0, 66>, 5*BHeight scale <0.6, 1, 1> }
         plane {-x, 0 }
         plane { y, 0 }
      }
      texture { T_Granit }
      translate <6*BWidth, 0, 0>
   }

   box { <-6.75*BWidth, 0, 0.75*BWidth>, <-6*BWidth, 43*BHeight, 75> }
   box { < 6.75*BWidth, 0, 0.75*BWidth>, < 6*BWidth, 43*BHeight, 75> }
   difference {
      box { <-6.75*BWidth, 43*BHeight, 0.75*BWidth>, <6.75*BWidth, 55*BHeight, 75> }
      cylinder { <0, 19.3*BHeight, -2>, <0, 19.3*BHeight, 76>, 32*BHeight }
      texture { T_B4Brick rotate <90, 90, 0> }
   }

   #declare pos = 3;
   #while (pos < 44)
      cylinder { <0, 0, 0>, <0, BHeight-BMortar, 0>, 0.65*BWidth translate <-6.75*BWidth, pos*BHeight, 0.75*BWidth> texture { T_B4Brickcolor } }
      cylinder { <0, 0, 0>, <0, BHeight-BMortar, 0>, 0.65*BWidth translate < 6.75*BWidth, pos*BHeight, 0.75*BWidth> texture { T_B4Brickcolor } }
      #declare pos = pos + 1;
   #end
   #declare ang = 45;
   #while (ang < 135)
      cylinder { <0, 0, 0>, <0, BHeight-BMortar, 0>, 0.65*BWidth
                 translate <34.7*BHeight, 0, 0.75*BWidth>
                 rotate <0, 0, ang> translate <0, 19.3*BHeight, 0>
                 texture { T_B4Brickcolor }
      }
      #declare ang = ang + 1.8;
   #end

   cylinder { <-6.75*BWidth, 3*BHeight, 0.75*BWidth>, <-6.75*BWidth, 44*BHeight, 0.75*BWidth>, 0.65*BWidth-0.1 texture { T_Mortar } }
   cylinder { < 6.75*BWidth, 3*BHeight, 0.75*BWidth>, < 6.75*BWidth, 44*BHeight, 0.75*BWidth>, 0.65*BWidth-0.1 texture { T_Mortar } }
   difference {
      torus { 34.7*BHeight, 0.65*BWidth-0.1 rotate <90, 0, 0> translate <0, 19.3*BHeight, 0.75*BWidth> }
      plane { x, 0 rotate <0, 0,  45> translate <0, 19.3*BHeight, 0> }
      plane {-x, 0 rotate <0, 0, -45> translate <0, 19.3*BHeight, 0> }
      texture { T_Mortar }
   }

   texture { T_B4Brick translate <1000, 0, 0.75*BWidth> }
}

#local B4PortDoer=union {
   box { <-4.40*BWidth, 1, 0>, <-3.80*BWidth, 37*BHeight-1, 5>  texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> translate <-4*BWidth, 0, 0> } }
   box { <-0.55*BWidth, 1, 0>, <           0, 37*BHeight-1, 5>  texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> } }
   box { <-3.80*BWidth, 1, 0>, <-0.55*BWidth, 3.4*BHeight, 5> texture { T_Wood27 rotate <88, 0, 90> scale <80, 10, 10> } }
   box { <-3.80*BWidth, 34.2*BHeight, 0>, <-0.55*BWidth, 37*BHeight-1, 5> texture { T_Wood27 rotate <88, 0, 90> scale <80, 10, 10> translate <0, 36*BHeight, 0> } }

   box { <-3.80*BWidth,  3.4*BHeight, 1>, <-3.35*BWidth, 34.2*BHeight, 5> texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> translate <-3*BWidth, 0, 0> } }
   box { <-1.00*BWidth,  3.4*BHeight, 1>, <           0, 34.2*BHeight, 5> texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> translate <-1*BWidth, 0, 0> } }
   box { <-3.35*BWidth,  3.4*BHeight, 1>, <-1.00*BWidth,  6.0*BHeight, 5> texture { T_Wood27 rotate <92, 0, 90> scale <80, 10, 10> } }
   box { <-3.35*BWidth, 18.9*BHeight, 1>, <-1.00*BWidth, 23.0*BHeight, 5> texture { T_Wood27 rotate <92, 0, 90> scale <80, 10, 10> translate <0, 20*BHeight, 0> } }
   box { <-3.35*BWidth, 32.8*BHeight, 1>, <-1.00*BWidth, 34.2*BHeight, 5> texture { T_Wood27 rotate <92, 0, 90> scale <80, 10, 10> translate <0, 30*BHeight, 0> } }

   box { <-3.35*BWidth,  6.0*BHeight, 3>, <-1.00*BWidth, 18.9*BHeight, 5> texture { T_Wood27 rotate <92, 0, 0> scale <10, 70, 10> translate <-2*BWidth, 0, 2> } }
   box { <-3.14*BWidth,  6.8*BHeight, 2>, <-1.26*BWidth, 18.1*BHeight, 5> texture { T_Wood27 rotate <88, 0, 0> scale <40, 50, 10> translate <-2*BWidth, 0, 2> } }
   cylinder { <0, 0, 1>, <0, 0, 5>, 22 scale <1, 37/22, 1> translate <-2.2*BWidth, 12.45*BHeight, 0> texture { T_Wood27 rotate <88, 0, 0> scale <20, 80, 10> translate <-2*BWidth, 0, 0> } }

   box { <-3.35*BWidth, 27.9*BHeight-1.5, 1>, <-1.00*BWidth, 27.9*BHeight+1.5, 3> texture { T_Wood27 rotate <92, 0, 90> scale <80, 10, 10> translate <0, 30*BHeight, 0> } }
   box { <-2.2*BWidth-1.5, 23.0*BHeight, 1>, <-2.2*BWidth+1.5, 32.8*BHeight, 3> texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> } }

   box { <-3.35*BWidth, 23.0*BHeight, 2>, <-1.00*BWidth, 32.8*BHeight, 2.3> texture { T_Rude } }
   box { <-4.40*BWidth,            0, 0>, <           0,          1, 5> texture { pigment { Black } } } //"luft" under dr
   box { <-4.40*BWidth, 37*BHeight-1, 0>, <           0, 37*BHeight, 5> texture { pigment { Black } } } //"luft" over dr

   box { <-4.40*BWidth, 1, -0.1>, <0, 3.3*BHeight, 0> texture { T_DoerIr } }
}

#local B4Port=union {
//karm
   box { <-6*BWidth, 0, -12>, <-5.75*BWidth, 42.5*BHeight, 24> texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> } }
   box { < 6*BWidth, 0, -12>, < 5.75*BWidth, 42.5*BHeight, 24> texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> } }
   difference {
      cylinder { <0, 19.3*BHeight, -12>, <0, 19.3*BHeight, 24>, 32*BHeight }
      cylinder { <0, 19.3*BHeight, -13>, <0, 19.3*BHeight, 25>, 32*BHeight-6 }
      texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> translate <-2*BWidth, 0, 0> }
   }

//top
   difference {
      intersection {
         box { <-5.75*BWidth, 37*BHeight, -1>, <5.75*BWidth, 51*BHeight, 12> }
         cylinder { <0, 19.3*BHeight, -2>, <0, 19.3*BHeight, 13>, 32*BHeight-6  }
      }
      box { <-4.4*BWidth, 36*BHeight, -2>, <4.4*BWidth, 52*BHeight, 13> }
      texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> }
   }
   difference {
      intersection {
         box { <-4.4*BWidth, 37*BHeight, 0>, <4.4*BWidth, 51*BHeight, 12> }
         cylinder { <0, 19.3*BHeight, -2>, <0, 19.3*BHeight, 13>, 32*BHeight-6  }
      }
      box { <-4.4*BWidth, 38*BHeight, -1>, <4.4*BWidth, 46*BHeight, 5> }
      texture { T_Wood27 rotate <88, 0, 90> scale <80, 10, 10> }
   }
   box { <-4.4*BWidth, 38*BHeight, -1>, <4.4*BWidth, 38*BHeight+3, 5> texture { T_Wood27 rotate <88, 0, 90> scale <60, 15, 10> } }
   box { <-4.4*BWidth, 0, 0>, <4.4*BWidth, 3, 8>
         texture { T_Wood27 rotate <88, 0, 90> scale <70, 15, 10> }
         rotate <-30, 0, 0> translate <0, 38*BHeight+3, -1>
   }
   union {
      cylinder{ <0, 44.5*BHeight, 2.5>, <0, 44.5*BHeight, 5>, 8 }
      cylinder{ <-2.2*BWidth, 40.5*BHeight, 2.5>, <-2.2*BWidth, 40.5*BHeight, 5>, 8 }
      difference {
         cylinder{ <-2.2*BWidth, 47.94*BHeight, 3>, <-2.2*BWidth, 47.94*BHeight, 5>, 57.126 }
         cylinder{ <-2.2*BWidth, 50.46*BHeight, 2>, <-2.2*BWidth, 50.46*BHeight, 6>, 59.561 }
      }
      cylinder{ < 2.2*BWidth, 40.5*BHeight, 2.5>, < 2.2*BWidth, 40.5*BHeight, 5>, 8 }
      difference {
         cylinder{ < 2.2*BWidth, 47.94*BHeight, 3>, < 2.2*BWidth, 47.94*BHeight, 5>, 57.126 }
         cylinder{ < 2.2*BWidth, 50.46*BHeight, 2>, < 2.2*BWidth, 50.46*BHeight, 6>, 59.561 }
      }
      texture { T_Wood16 rotate <88, 0, 90> scale <70, 10, 10> translate <0, 42*BHeight, 0> }
   }
//sidestykker
   union {
      box { <-5.75*BWidth, 0*BHeight,  0>, <-4.4*BWidth, 37*BHeight, 12> }
      box { <-5.55*BWidth, 0*BHeight, -1>, <-4.6*BWidth, 37*BHeight, 12> }
      texture { T_Wood27 rotate <88, 0, 0> scale <10, 80, 10> translate <-5*BWidth, 0, 0> }
   }
   union {
      box { < 5.75*BWidth, 0*BHeight,  0>, < 4.4*BWidth, 37*BHeight, 12> }
      box { < 5.55*BWidth, 0*BHeight, -1>, < 4.6*BWidth, 37*BHeight, 12> }
      texture { T_Wood27 rotate <88, 0, 0> scale <15, 80, 10> translate < 4.5*BWidth, 0, 0> }
   }
   union {
      box { <-5.75*BWidth, 0*BHeight, -0.1>, <-4.40*BWidth, 3.3*BHeight, 0> }
      box { <-5.60*BWidth, 0*BHeight, -1.1>, <-4.55*BWidth, 3.3*BHeight, 0> }
      texture { T_DoerIr }
   }
   union {
      box { < 5.75*BWidth, 0*BHeight, -0.1>, < 4.40*BWidth, 3.3*BHeight, 0> }
      box { < 5.60*BWidth, 0*BHeight, -1.1>, < 4.55*BWidth, 3.3*BHeight, 0> }
      texture { T_DoerIr }
   }
// dre
   object { B4PortDoer translate <0, 0, 1> }
   object { B4PortDoer scale <-1, 1, 1> translate <0, 0, 1> }
   box { <0, 1, 0>, <4.5, 37*BHeight, 1> texture { pigment { rgb <0.3, 0.1, 0.05> } } }

   union {
      cylinder { <0, 0, 0>, <0, 0, -0.5>, 3 }
      cylinder { <0, 0, 0>, <0, 0, -5>, 1 }
      sphere { <0, 0, -5>, 1 }
      cylinder { <0, 0, -5>, <8, 0, -5>, 1 }
      sphere { <8, 0, -5>, 1 }
      texture { T_Brass_5A }
      scale <-1, 1, 1>
      translate <-0.3*BWidth, 18.1*BHeight, 1>
   }
   union {
      cylinder { <0, 0, 0>, <0, 0, -0.5>, 3.1 }
      cylinder { <0, 0, 0>, <0, 0, -0.7>, 2.2 }
      texture { T_Brass_5A }
      translate <-4, 20.5*BHeight, 1>
   }
}

#local B4MurCutout4=union{ // 10x45 med bue - niche til vindue12
   box { <0, 0, -1>, <10*BWidth, 38*BHeight, BWidth/2> }
   difference {
      cylinder { <5*BWidth, 21.65*BHeight, -1>, <5*BWidth, 21.65*BHeight, BWidth/2>, 24.35*BHeight}
      plane { y, 0 }
      plane { x, 0 }
      plane {-x, 0 translate <10*BWidth, 0, 0> }
   }
}

#local B4Mur4AltanPind=union{
   box { <-1.25, 0, 0>, <1.25, 23.11, 0.5> }
   difference {
      cylinder { <-1.25, 0, 0>, <1.25, 0, 0>, 9.975 scale <1, 11.97/9.975, 1> }
      cylinder { <-1.3, 0, 0>, <1.3, 0, 0>, 9.475 scale <1, 11.47/9.475, 1> }
      plane {-z, 0 }
      plane {-y, 0 }
      translate <0, 34.58, 0>
   }
   difference {
      cylinder { <-1.25, 0, 0>, <1.25, 0, 0>, 9.975 scale <1, 18.62/9.975, 1> }
      cylinder { <-1.3, 0, 0>, <1.3, 0, 0>, 9.475 scale <1, 18.12/9.475, 1> }
      plane {-z, 0 }
      plane { y, 0 }
      plane {-y, 0 translate <0, 16.03116, 0> }
      translate <0, 34.58, 0>
   }
   difference {
      cylinder { <-1.25, 0, 0>, <1.25, 0, 0>, 10.475 scale <1, 19.12/10.475, 1> }
      cylinder { <-1.3, 0, 0>, <1.3, 0, 0>, 9.975 scale <1, 18.62/9.975, 1> }
      plane { z, 0 }
      plane {-y, 0 }
      plane { y, 0 translate <0, -16.21736, 0> }
      translate <0, 66.8285, -9.975>
   }
   box { <-1.25, 66.8285, 0>, <1.25,100, 0.5> }
   texture { T_Jern }
}

#local B4Mur4Altan=union{
   box { <-1.25*BWidth, 0, -35>, <14.5*BWidth, 3*BHeight, 120> texture { T_Sandstone } }
   #declare pos = -0.975*BWidth;
   object { B4Mur4AltanPind rotate <0, 90, 0> translate <pos, 3*BHeight, -23> }
   #while (pos < 14.5*BWidth)
      object { B4Mur4AltanPind translate <pos, 3*BHeight, -25> }
      #declare pos = pos + 0.76*BWidth;
   #end
   object { B4Mur4AltanPind rotate <0, -90, 0> translate <14.225*BWidth, 3*BHeight, -23> }
   box { <-0.975*BWidth-0.5, 6.4*BHeight-2.5, 0>, <-0.975*BWidth+0.5, 6.4*BHeight, -25.5> texture { T_Jern } }
   box { <-0.975*BWidth, 6.4*BHeight-2.5, -24.5>, <14.225*BWidth, 6.4*BHeight, -25.5> texture { T_Jern } }
   box { <14.225*BWidth-0.5, 6.4*BHeight-2.5, 0 >, <14.225*BWidth+0.5, 6.4*BHeight, -25.5> texture { T_Jern } }
   box { <-0.975*BWidth-0.5, 18*BHeight-5, 0>, <-0.975*BWidth+0.5, 18*BHeight-2.5, -25.5> texture { T_Jern } }
   box { <-0.975*BWidth,     18*BHeight-5, -24.5>, <14.225*BWidth, 18*BHeight-2.5, -25.5> texture { T_Jern } }
   box { <14.225*BWidth-0.5, 18*BHeight-5, 0>, <14.225*BWidth+0.5, 18*BHeight-2.5, -25.5> texture { T_Jern } }
   box { <-0.975*BWidth-1.5, 18*BHeight-2.5, 0>, <-0.975*BWidth+1.5, 18*BHeight+0.5, -26.5> texture { T_Jern } }
   box { <-0.975*BWidth,     18*BHeight-2.5, -23.5>, <14.225*BWidth, 18*BHeight+0.5, -26.5> texture { T_Jern } }
   box { <14.225*BWidth-1.5, 18*BHeight-2.5, 0>, <14.225*BWidth+1.5, 18*BHeight+0.5, -26.5> texture { T_Jern } }
}

#local B4Mur4Gavltrekant=union{
   difference {
      box { <-14*BWidth, 0, 0>, <14*BWidth, 62*BHeight, 75> }
      plane { x, 0 rotate <0, 0, -37.45> translate <0, 62*BHeight, 0> }
      plane {-x, 0 rotate <0, 0,  37.45> translate <0, 62*BHeight, 0> }
      box { <-4.5*BWidth, 17*BHeight, -1>, <4.5*BWidth, 39*BHeight, 76> }
   }
   object { B4Vindue9 scale <9/9.75, 1, 1> translate <-4.5*BWidth, 17*BHeight, BWidth/2> }
   object { B4Saalbaenk9A translate <-4.5*BWidth, 18*BHeight, BWidth/2> }
   box { <-5*BWidth, 39*BHeight, -0.1>, <5*BWidth, 41*BHeight, 75> texture { T_Sandstone } }
   difference {
      object { B4TagGesimsprofil scale <23*BWidth, 1, 1> translate <-21*BWidth, 0, 0> rotate <0, 0, 52.55> }
      plane {-x, 0 }
      translate <0, 62*BHeight, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <23*BWidth, 1, 1> translate <-2*BWidth, 0, 0> rotate <0, 0, -52.55> }
      plane { x, 0 }
      translate <0, 62*BHeight, 0>
      texture { T_Sandstone }
   }

   difference {
      object { B4TagGesimsprofil scale <5*BWidth, 1, 1> translate <-1.5*BWidth, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      rotate <0, -90, 0> translate <13.5*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <5*BWidth, 1, 1> translate <-1.5*BWidth, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <2*BWidth, 0, 0>}
      translate <11.5*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <2*BWidth, 1, 1> translate <-0.5*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0>}
      rotate <0, 90, 0> translate <11.5*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <6*BWidth, 1, 1> translate <-2*BWidth, 0, -33> }
      plane { x, 0 rotate <0, 45, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      rotate <0, -90, 0> translate <13.5*BWidth, 5*BHeight, 0>
   }
   difference {
      object { B4Tagrendeprofil scale <6*BWidth, 1, 1> translate <-2*BWidth, 0, -33> }
      plane {-x, 0 rotate <0, -45, 0> translate <2*BWidth, 0, 0>}
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <11.5*BWidth, 5*BHeight, 0>
   }
   object { B4TagrendeEnde translate <9.5*BWidth, 5*BHeight, -33> }

   difference {
      object { B4TagGesimsprofil scale <12*BWidth, 1, 1> translate <-10.5*BWidth, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> translate <-8.9*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-11.5*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <2*BWidth, 1, 1> translate <-1.5*BWidth, 0, 0> }
      plane { x, 0 rotate <0, 45, 0>}
      rotate <0, -90, 0> translate <-11.5*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <13*BWidth, 1, 1> translate <-11*BWidth, 0, -33> }
      plane { x, 0 rotate <0,  45, 0> translate <-8.9*BWidth, 0, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <-11.5*BWidth, 5*BHeight, 0>
   }
   object { B4TagrendeEnde translate <-9.5*BWidth, 5*BHeight, -33> }
   //Tag
   box { <-21*BWidth, 6*BHeight, -5*BHeight>, <1.8*BWidth, 6*BHeight+2, 19*BWidth> rotate <0, 0,  52.55> texture { T_Tagsten rotate <0, 90, 0> translate <0, -500, 0> } translate <0, 62*BHeight, 0> }
   box { < 21*BWidth, 6*BHeight, -5*BHeight>, <-1.8*BWidth, 6*BHeight+1, 19*BWidth> rotate <0, 0, -52.55> texture { T_Tagsten  rotate <0, -90, 0> translate <0, -500, 0> } translate <0, 62*BHeight, 0> }
   object { B4Rygningprofil scale <1, 1, 24*BWidth> texture { T_Rygning } translate <0, 70*BHeight, -5*BHeight> }
   cylinder { <0, 0, -5*BHeight>, <0, 0, 19*BHeight>, 9 texture { T_Sandstone } translate <0, 70*BHeight, 0> }

}

#local B4Mur4=union{
   difference {
      box { <0, -5*BHeight, 0>, <77*BWidth, 3*BHeight, 50> }
      plane { x, 0 rotate <0, 45, 0> }
      box { <4.5*BWidth, -1, -1>, <14.5*BWidth, 4*BHeight, BWidth/2> }
      // Kldervinduer
      box { <21.20*BWidth, -6*BHeight, -1>, <24.80*BWidth, 4*BHeight, 51> }
      box { <35.10*BWidth, -6*BHeight, -1>, <38.70*BWidth, 4*BHeight, 51> }
      box { <42.40*BWidth, -6*BHeight, -1>, <46.00*BWidth, 4*BHeight, 51> }
      box { <51.80*BWidth, -6*BHeight, -1>, <55.40*BWidth, 4*BHeight, 51> }
      box { <61.25*BWidth, -1, -1>, <74.75*BWidth, 4*BHeight, 52> }  // Port
      texture { T_Granit }
   }
   difference {
      box { <0, 3*BHeight, 0>, <77*BWidth, 202*BHeight, 75> }
      plane { x, 0 rotate <0, 45, 0> }

      // Kldervinduer
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <23.0*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <36.9*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <44.2*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <53.6*BWidth, -5.5*BHeight, 0> }

      object { B4MurCutout4 translate <4.5*BWidth, 0, 0> }
      object { B4Vindue12Cutout translate <5*BWidth, 0, 0> }
      box { <18.90*BWidth, 17*BHeight, -1>, <27.15*BWidth, 45*BHeight, 76> }
      box { <30*BWidth, 28*BHeight, -1>, <30*BWidth+52, 40*BHeight, 10> } // stenplade
      box { <30*BWidth+9, 39*BHeight, -1>, <30*BWidth+43, 42*BHeight, 10> } //stenplade
      box { <35.15*BWidth, 17*BHeight, -1>, <45.90*BWidth, 45*BHeight, 76> }
      box { <50.70*BWidth, 17*BHeight, -1>, <56.50*BWidth, 45*BHeight, 76> }
      object { B4PortCutout translate <68*BWidth, 0, 0> }

      box { <33.90*BWidth, 51*BHeight, -1>, <47.15*BWidth, 146*BHeight, 76> }
      intersection {
         box { <33.90*BWidth, 145*BHeight, -1>, <47.15*BWidth, 154*BHeight, 76> }
         cylinder { <40.525*BWidth, 146*BHeight-227.81, -1>, <40.525*BWidth, 146*BHeight-227.81, 76>, 277.81 }
      }

      box { < 2.20*BWidth, 67*BHeight, -1>, < 7.60*BWidth, 95*BHeight, 76> }
      box { <19.10*BWidth, 67*BHeight, -1>, <27.35*BWidth, 95*BHeight, 76> }
      box { <52.75*BWidth, 67*BHeight, -1>, <56.15*BWidth, 89*BHeight, 76> }
      box { <61.75*BWidth, 67*BHeight, -1>, <70.00*BWidth, 95*BHeight, 76> }

      box { < 2.20*BWidth, 118*BHeight, -1>, < 7.60*BWidth, 146*BHeight, 76> }
      box { <19.10*BWidth, 118*BHeight, -1>, <27.35*BWidth, 146*BHeight, 76> }
      box { <52.75*BWidth, 118*BHeight, -1>, <56.15*BWidth, 140*BHeight, 76> }
      box { <61.75*BWidth, 118*BHeight, -1>, <70.00*BWidth, 146*BHeight, 76> }

      box { < 2.20*BWidth, 168*BHeight, -1>, < 7.60*BWidth, 196*BHeight, 76> }
      box { <19.10*BWidth, 168*BHeight, -1>, <27.35*BWidth, 196*BHeight, 76> }
      box { <52.75*BWidth, 168*BHeight, -1>, <56.15*BWidth, 190*BHeight, 76> }
      box { <61.75*BWidth, 168*BHeight, -1>, <70.00*BWidth, 196*BHeight, 76> }

      box { <33.90*BWidth, 168*BHeight, -1>, <47.15*BWidth, 203*BHeight, 76> }

   }
   difference {
      box { <33*BWidth, 50*BHeight, 3*BWidth>, <47.25*BWidth, 202*BHeight, 5*BWidth> }
      box { <35.40*BWidth,  67*BHeight, 70>, <45.65*BWidth,  94*BHeight, 125> }  // Altanvindue
      box { <40.525*BWidth,  54*BHeight, 70>, <45.65*BWidth,  94*BHeight, 125> } // Altandr
      box { <35.40*BWidth, 118*BHeight, 70>, <45.65*BWidth, 145*BHeight, 125> }  // Altanvindue
      box { <40.525*BWidth, 105*BHeight, 70>, <45.65*BWidth, 145*BHeight, 125> } // Altandr
      box { <35.15*BWidth, 168*BHeight, 70>, <45.90*BWidth, 196*BHeight, 125> }
   }
   object { B4Mur4Gavltrekant translate <20.40*BWidth, 202*BHeight, 0> }
   object { B4Mur4Gavltrekant scale <-1, 1, 1> translate <60.65*BWidth, 202*BHeight, 0> }
   difference {
      box { <21*BWidth, 202*BHeight, 3*BWidth>, <61*BWidth, 247*BHeight, 5*BWidth> }
      plane { x, 0 rotate <0, 0,  37.45> translate <33.90*BWidth, 202*BHeight, 0> }
      plane {-x, 0 rotate <0, 0, -37.45> translate <47.15*BWidth, 202*BHeight, 0> }
      box { <34.30*BWidth, 219*BHeight, 2*BWidth>, <37.55*BWidth, 241*BHeight, 6*BWidth> }
      box { <38.90*BWidth, 219*BHeight, 2*BWidth>, <42.15*BWidth, 241*BHeight, 6*BWidth> }
      box { <43.50*BWidth, 219*BHeight, 2*BWidth>, <46.75*BWidth, 241*BHeight, 6*BWidth> }
   }
   box { <21*BWidth, 241*BHeight, 2.9*BWidth>, <61*BWidth, 243*BHeight, 5*BWidth> texture { T_Sandstone  } }

   // Over kldervinduer
   box { <21*BWidth, 3*BHeight, BWidth/2>, <56*BWidth, 6*BHeight, 50> texture { T_Sandstone } }

   object { B4KaelderVindue translate <21.20*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <35.10*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <42.40*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <51.80*BWidth, -4.5*BHeight, BWidth/2> }

   object { B4Vindue12 translate <5*BWidth, 0, BWidth/2> }
   object { B4Vindue4 translate <18.90*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue5 scale <10.75/10.5, 1, 1> translate <35.15*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue3 translate <50.70*BWidth, 18*BHeight, BWidth/2> }
   object { B4PortRamme translate <68*BWidth, 0, 0> }
   object { B4Port translate <68*BWidth, 0, 3.25*BWidth> }

   object { B4SaalbaenkProfil scale <9*BWidth-B4SaalbaenkMortar, 1, 1>
            texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
            translate <B4SaalbaenkMortar/2, 0, BWidth/2>
            translate <5*BWidth, 15*BHeight, BWidth/2>
   }
   object { B4Saalbaenk4 translate <18.9*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk5A translate <35.15*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk3 translate <50.70*BWidth, 18*BHeight, BWidth/2> }

   object { B4Mur4Altan translate <33.9*BWidth, 51*BHeight, 0>}
   object { B4Vindue3 scale <5.4/5.8, 1, 1> translate <2.2*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue4 translate <18.90*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue5Altan translate <35.40*BWidth, 68*BHeight, 3*BWidth> }
   object { B4Vindue7 translate <52.75*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue4 translate <61.75*BWidth, 68*BHeight, BWidth/2> }

   difference {
      box { <-0.1, 63*BHeight, -0.1>, <7.85*BWidth, 65*BHeight, 5*BWidth> }
      plane { x, 0 rotate <0, 45, 0> }
      texture { T_Sandstone  }
   }

   object { B4Saalbaenk3C translate <2.20*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <18.90*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk5Altan translate <35.40*BWidth, 68*BHeight, 3*BWidth> }
   object { B4Saalbaenk7 translate <52.75*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <61.75*BWidth, 68*BHeight, BWidth/2> }

   object { B4Saalbaenk3D translate <2.20*BWidth, 98*BHeight, BWidth/2> }

   object { B4Mur4Altan translate <33.9*BWidth, 102*BHeight, 0>}
   object { B4Vindue3 scale <5.4/5.8, 1, 1> translate <2.2*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue4 translate <18.90*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue5Altan translate <35.40*BWidth, 119*BHeight, 3*BWidth> }
   object { B4Vindue7 translate <52.75*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue4 translate <61.75*BWidth, 119*BHeight, BWidth/2> }

   object { B4Saalbaenk3C translate <2.20*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <18.90*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk5Altan translate <35.40*BWidth, 119*BHeight, 3*BWidth> }
   object { B4Saalbaenk7 translate <52.75*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <61.75*BWidth, 119*BHeight, BWidth/2> }

   object { B4Saalbaenk3D translate <2.20*BWidth, 149*BHeight, BWidth/2> }

   object { B4Vindue3 scale <5.4/5.8, 1, 1> translate <2.2*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue4 translate <18.90*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue5 scale <10.75/10.5, 1, 1> translate <35.15*BWidth, 169*BHeight, 3.5*BWidth> }
   object { B4Vindue7 translate <52.75*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue4 translate <61.75*BWidth, 169*BHeight, BWidth/2> }

   difference {
      box { <-0.1, 196*BHeight, -0.1>, <9.6*BWidth, 198*BHeight, 5*BWidth> }
      plane { x, 0 rotate <0, 45, 0> }
      texture { T_Sandstone  }
   }

   object { B4Vindue7Gavl translate <34.30*BWidth, 219*BHeight, 3.5*BWidth> }
   object { B4Vindue7Gavl translate <38.90*BWidth, 219*BHeight, 3.5*BWidth> }
   object { B4Vindue7Gavl translate <43.50*BWidth, 219*BHeight, 3.5*BWidth> }
   object {
      B4SaalbaenkProfil scale <13*BWidth-B4SaalbaenkMortar, 1, 1>
      texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
      translate <34.3*BWidth+B4SaalbaenkMortar/2-BWidth/4, 220*BHeight, 3.5*BWidth>
   }

   difference {
      box { <0, 164*BHeight, -0.1>, <77*BWidth, 166*BHeight, 75> }
      plane { x, 0 rotate <0, 45, 0> }
      texture { T_Sandstone }
   }
   difference {
      object { B4SaalbaenkProfil scale <78.5*BWidth, 1, 1> translate <-1.5*BWidth, 0, BWidth/2> }
      plane { x, 0 rotate <0, 45,0> }
      texture { T_B4Saalbaenk translate <-4, 10, -100> }
      translate <0, 169*BHeight, 0>
   }
   object { B4Saalbaenk5A translate <35.15*BWidth, 18*BHeight, 3.5*BWidth> }

   difference {
      object { B4TagGesimsprofil scale <39*BWidth, 1, 1> }
      plane {-y, 0 translate <0, 5.5*BHeight, 0> }
      translate <21*BWidth, 247*BHeight, 3*BWidth>
      texture { T_Sandstone }
   }
   object { B4Tagrendeprofil scale <39*BWidth, 1, 1> texture { T_LinedZink rotate <0, 0, 90> } translate <21*BWidth, 252*BHeight, 3*BWidth-33> }
   object { B4Nedloeb translate <32.40*BWidth, 45*BHeight, 3*BWidth> }
   object { B4Nedloeb rotate <0, -90, 0> translate <33.90*BWidth, 0, 2.7*BWidth> }
   object { B4Nedloeb rotate <0,  90, 0> translate <47.15*BWidth, 0, 2.7*BWidth> }
   object { B4Nedloeb rotate <0,  45, 0> translate <76.75*BWidth, 0, 0> }

//   object { SMPSign scale 1.5 translate <0, 44*BHeight, 0> }
   box { <0, 0, 0>, <52, 93, 10> texture { T_Stentavle } translate <30*BWidth, 28*BHeight, 3> }

   texture { T_B4Brick }
}

#local B4MurCutout5=union{ // 13.5x46 med bue - niche til vindue13
   box { <0, 0, -1>, <13.5*BWidth, 33*BHeight, BWidth/2> }
   difference {
      cylinder { <6.75*BWidth, 16.65*BHeight, -1>, <6.75*BWidth, 16.65*BHeight, BWidth/2>, 29.35*BHeight}
      plane { y, 0 }
      plane { x, 0 }
      plane {-x, 0 translate <13.5*BWidth, 0, 0> }
   }
}

#local B4Mur5Altan=union{ // Fransk altan
   box { <3.90*BWidth, 4*BHeight, -20>, <8.85*BWidth, 5*BHeight, 12> texture { T_Sandstone } }
   #declare pos = 0;
   object { B4Mur4AltanPind rotate <0, 90, 0> translate <pos, 3*BHeight, -23> }
   #while (pos < 12.8*BWidth)
      object { B4Mur4AltanPind translate <pos, 3*BHeight, -25> }
      #declare pos = pos + 0.75*BWidth;
   #end
   object { B4Mur4AltanPind rotate <0, -90, 0> translate <12.75*BWidth, 3*BHeight, -23> }
   box { < -0.5, 6.4*BHeight-2.5, 0>, <0.5, 6.4*BHeight, -25.5> texture { T_Jern } }
   box { <  0,   6.4*BHeight-2.5, -24.5>, <12.75*BWidth, 6.4*BHeight, -25.5> texture { T_Jern } }
   box { <12.75*BWidth-0.5, 6.4*BHeight-2.5, 0 >, <12.75*BWidth+0.5, 6.4*BHeight, -25.5> texture { T_Jern } }
   box { <-0.5, 18*BHeight-5, 0>, <0.5, 18*BHeight-2.5, -25.5> texture { T_Jern } }
   box { < 0,     18*BHeight-5, -24.5>, <12.75*BWidth, 18*BHeight-2.5, -25.5> texture { T_Jern } }
   box { <12.75*BWidth-0.5, 18*BHeight-5, 0>, <12.75*BWidth+0.5, 18*BHeight-2.5, -25.5> texture { T_Jern } }
   box { <-1.5, 18*BHeight-2.5, 0>, <1.5, 18*BHeight+0.5, -26.5> texture { T_Jern } }
   box { <0,     18*BHeight-2.5, -23.5>, <12.75*BWidth, 18*BHeight+0.5, -26.5> texture { T_Jern } }
   box { <12.75*BWidth-1.5, 18*BHeight-2.5, 0>, <12.75*BWidth+1.5, 18*BHeight+0.5, -26.5> texture { T_Jern } }
}

#local B4Mur5KarnapMidtdel=union{
   difference {
      union {
         box { <-1.55*BWidth, 6*BHeight,     -11.775*BWidth>, <1.55*BWidth,  8*BHeight-0.5, 50-11.775*BWidth> texture { T_Sandstone } }
         box { <-1.55*BWidth, 8*BHeight-0.5, -11.775*BWidth>, <1.55*BWidth,  8*BHeight,     50-11.775*BWidth> texture { pigment { Black } } }
         box { <-1.55*BWidth, 8*BHeight,     -11.775*BWidth>, <1.55*BWidth, 10*BHeight,     50-11.775*BWidth> texture { T_Sandstone } }
      }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
   }
   box { <-1.55*BWidth, 10*BHeight, -11.775*BWidth>, <1.55*BWidth, 22*BHeight, 50-11.775*BWidth> }
   object { B4Vindue14A translate <0, 23*BHeight, -11.275*BWidth> }
   difference {
      object { B4SaalbaenkProfil scale <3.6*BWidth, 1, 1> translate <-1.8*BWidth, 0, -11.775*BWidth> }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      texture { T_B4Saalbaenk translate <0, 10, -11.775*BWidth-100> }
      translate <0, 54*BHeight, 0>
   }
   box { <-1.55*BWidth, 50*BHeight, -11.775*BWidth>, <1.55*BWidth, 73*BHeight, 50-11.775*BWidth> }
   object { B4Vindue14A translate <0, 74*BHeight, -11.275*BWidth> }
   difference {
      object { B4SaalbaenkProfil scale <3.6*BWidth, 1, 1> translate <-1.8*BWidth, 0, -11.775*BWidth> }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      texture { T_B4Saalbaenk translate <0, 10, -11.775*BWidth-100> }
      translate <0, 105*BHeight, 0>
   }
   box { <-1.55*BWidth, 100*BHeight, -11.775*BWidth>, <1.55*BWidth, 123*BHeight, 50-11.775*BWidth> }
   object { B4Vindue14A translate <0, 124*BHeight, -11.275*BWidth> }
   texture { T_B4Brick translate < 6, 0, 0> }
}

#local B4Mur5KarnapSidedel=union{
   difference {
      union {
         box { <-1.65*BWidth, 6*BHeight,     -11.775*BWidth>, <1.55*BWidth,  8*BHeight-0.5, 50-11.775*BWidth> texture { T_Sandstone } }
         box { <-1.65*BWidth, 8*BHeight-0.5, -11.775*BWidth>, <1.55*BWidth,  8*BHeight,     50-11.775*BWidth> texture { pigment { Black } } }
         box { <-1.65*BWidth, 8*BHeight,     -11.775*BWidth>, <1.55*BWidth, 10*BHeight,     50-11.775*BWidth> texture { T_Sandstone } }
      }
      plane {-x, 0 rotate <0, -7.5, 0> }
   }
   box { <-1.65*BWidth, 10*BHeight, -11.775*BWidth>, <1.55*BWidth, 22*BHeight, 50-11.775*BWidth> }
   object { B4Vindue14B translate <0, 23*BHeight, -11.275*BWidth> }
   difference {
      object { B4SaalbaenkProfil scale <4.2*BWidth, 1, 1> translate <-2.4*BWidth, 0, -11.775*BWidth> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      texture { T_B4Saalbaenk translate <0, 10, -11.775*BWidth-100> }
      translate <0, 54*BHeight, 0>
   }
   box { <-1.65*BWidth, 50*BHeight, -11.775*BWidth>, <1.55*BWidth, 73*BHeight, 50-11.775*BWidth> }
   object { B4Vindue14B translate <0, 74*BHeight, -11.275*BWidth> }
   difference {
      object { B4SaalbaenkProfil scale <4.2*BWidth, 1, 1> translate <-2.4*BWidth, 0, -11.775*BWidth> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      texture { T_B4Saalbaenk translate <0, 10, -11.775*BWidth-100> }
      translate <0, 105*BHeight, 0>
   }
   box { <-1.65*BWidth, 100*BHeight, -11.775*BWidth>, <1.55*BWidth, 123*BHeight, 50-11.775*BWidth> }
   object { B4Vindue14B translate <0, 124*BHeight, -11.275*BWidth> }
   texture { T_B4Brick translate <102, 0, 0> }
}

#local B4Mur5KarnapTagprofil=union{
   difference {
      box { <0, 0, 2.4*BWidth>, <1, 2.3*BWidth, -1.8*BWidth> }
      cylinder { <-0.1, 0, 0>, <1.1, 0, 0>, 2.6825*BWidth scale <1, 2.98/2.6825, 1> translate <0, 2.3*BWidth, -3.5*BWidth> }
   }
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 0.8175*BWidth scale <1, 1.54/0.8175, 1> translate <0, 2.3*BWidth, 0> }
      plane { y, 0 translate <0, 2.3*BWidth, 0> }
      plane {-y, 0 translate <0, 3.71*BWidth, 0> }
      plane {-z, 0 }
   }
   difference {
      box { <0, 3.7*BWidth, 2.4*BWidth>, <1, 4.3*BWidth, -0.4*BWidth> }
      cylinder { <-0.1, 0, 0>, <1.1, 0, 0>, 0.82*BWidth scale <1, 1.5/0.82, 1> translate <0, 5.05*BWidth, -0.7*BWidth> }
   }
   box { <0, 0, 0>, <1, -0.2*BHeight, -1.75*BWidth> texture { pigment { White } } }
   box { <0, -0.2*BHeight, 0>, <1, -1.2*BHeight, -1.6*BWidth> texture { pigment { White } } }
   cylinder { <0, 0, 0>, <1, 0, 0>, 0.8*BHeight scale <1, 1, 2> translate <0, -1.2*BHeight, -0.7*BWidth> texture { pigment { White } } }
}

#local B4Mur5KarnapTagSamling=object {
   B4Mur5KarnapTagprofil translate <0, 0, -10.6*BWidth-5>
   texture { T_Ir }
}

#local B4Mur5KarnapTag=union{
   difference {
      object { B4Mur5KarnapTagprofil scale <5*BWidth, 1, 1> translate <-3*BWidth, 0, -10.6*BWidth> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      plane {-z, 0 translate <0, 0, -9.375*BWidth> rotate <0, -30, 0>  }
      texture { T_LinedIr translate <0, 5, 0>  }
      rotate <0, 30, 0>
   }
   object { B4Mur5KarnapTagSamling rotate <0, 22.5, 0> }
   difference {
      object { B4Mur5KarnapTagprofil scale <4*BWidth, 1, 1> translate <-2*BWidth, 0, -10.6*BWidth> }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      texture { T_LinedIr translate <0, 120, 0>  }
      rotate <0, 15, 0>
   }
   object { B4Mur5KarnapTagSamling rotate <0, 7.5, 0> }
   difference {
      object { B4Mur5KarnapTagprofil scale <4*BWidth, 1, 1> translate <-2*BWidth, 0,  -10.6*BWidth> }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      texture { T_LinedIr translate <0, 5, 0>  }
   }
   object { B4Mur5KarnapTagSamling rotate <0, -7.5, 0> }
   difference {
      object { B4Mur5KarnapTagprofil scale <4*BWidth, 1, 1> translate <-2*BWidth, 0, -10.6*BWidth> }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      texture { T_LinedIr translate <0, 120, 0> }
      rotate <0, -15, 0>
   }
   object { B4Mur5KarnapTagSamling rotate <0, -22.5, 0> }
   difference {
      object { B4Mur5KarnapTagprofil scale <5*BWidth, 1, 1> translate <-2*BWidth, 0, -10.6*BWidth> }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-z, 0 translate <0, 0, -9.375*BWidth> rotate <0, 30, 0>  }
      texture { T_LinedIr translate <0, 5, 0>  }
      rotate <0, -30, 0>
   }
}

#local B4Mur5KarnapBunddeco=union{
   cylinder { <0, 0, 0>, <0, 0, -3>, 4*BHeight }
   cylinder { <0, 0, 0>, <0, 0, -5>, 2.2*BHeight }
   texture { T_Sandstone }
}

#local B4Mur5Karnap=union{
   box { <-7.31*BWidth, 0, -9.375*BWidth-1>, <7.31*BWidth, 6*BHeight, -9.375*BWidth> texture { T_Sandstone } }
   object { B4Mur5KarnapBunddeco translate <4*BHeight-7.31*BWidth, 5*BHeight, -9.375*BWidth> }
   object { B4Mur5KarnapBunddeco translate <7.31*BWidth-4*BHeight, 5*BHeight, -9.375*BWidth> }
   difference {
      sphere { <0, 0, 0>, 4.3*BWidth scale <7.5/4.3, 1.6/4.3, 1> }
      plane {-y, 0 }
      translate <0, 6*BHeight, -7.375*BWidth>
      texture { T_Sandstone }
   }
   object { B4Mur5KarnapSidedel rotate <0, 30, 0> }
   object { B4Mur5KarnapMidtdel rotate <0, 15, 0> }
   object { B4Mur5KarnapMidtdel }
   object { B4Mur5KarnapMidtdel rotate <0, -15, 0> }
   object { B4Mur5KarnapSidedel scale <-1, 1, 1> rotate <0, -30, 0> }
   box { <-5, 20*BHeight, -11.54*BWidth>, <5, 151*BHeight, -11*BWidth> rotate <0,  22.5, 0> }
   box { <-5, 20*BHeight, -11.54*BWidth>, <5, 151*BHeight, -11*BWidth> rotate <0,   7.5, 0> }
   box { <-5, 20*BHeight, -11.54*BWidth>, <5, 151*BHeight, -11*BWidth> rotate <0,  -7.5, 0> }
   box { <-5, 20*BHeight, -11.54*BWidth>, <5, 151*BHeight, -11*BWidth> rotate <0, -22.5, 0> }
   object { B4Mur5KarnapTag translate <0, 153*BHeight, 0> }
   texture { pigment { White } }
   translate <0, 0, 9.375*BWidth>
}

#local B4Mur5Gavltrekant=union{
   difference {
      box { <-14*BWidth, 0, 0>, <14*BWidth, 65*BHeight, 75> }
      plane { x, 0 rotate <0, 0, -37.45> translate <0, 65*BHeight, 0> }
      plane {-x, 0 rotate <0, 0,  37.45> translate <0, 65*BHeight, 0> }
      box { <-4.875*BWidth, 17*BHeight, -1>, <4.875*BWidth, 39*BHeight, 76> }
   }
   object { B4Vindue9 translate <-4.875*BWidth, 17*BHeight, BWidth/2> }
   box { <-4.88*BWidth, -1, -5>, <4.88*BWidth, 0, 15> rotate <-35, 0, 0> translate <0, 17*BHeight, 0> texture { T_Skifer } }
   box { <-10.6*BWidth, 15*BHeight, -0.1>, <10.6*BWidth, 17*BHeight, 75> texture { T_Sandstone } }
   box { <-5.6*BWidth, 39*BHeight, -0.1>, <5.6*BWidth, 41*BHeight, 75> texture { T_Sandstone } }
   difference {
      object { B4TagGesimsprofil scale <24*BWidth, 1, 1> translate <-22*BWidth, 0, 0> rotate <0, 0, 52.55> }
      plane {-x, 0 }
      translate <0, 65*BHeight, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <24*BWidth, 1, 1> translate <-2*BWidth, 0, 0> rotate <0, 0, -52.55> }
      plane { x, 0 }
      translate <0, 65*BHeight, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <2*BWidth, 1, 1> translate <-0.5*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0>}
      rotate <0, 90, 0> translate <11.8*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagGesimsprofil scale <2*BWidth, 1, 1> translate <-1.5*BWidth, 0, 0> }
      plane { x, 0 rotate <0, 45, 0>}
      rotate <0, -90, 0> translate <-11.8*BWidth, 0, 0>
      texture { T_Sandstone }
   }
   //Tag
   box { <-22*BWidth, 6*BHeight, -5*BHeight>, <1.8*BWidth, 6*BHeight+2, 19*BWidth> rotate <0, 0,  52.55> texture { T_Tagsten rotate <0, 90, 0> translate <0, -500, 0> } translate <0, 65*BHeight, 0> }
   box { < 22*BWidth, 6*BHeight, -5*BHeight>, <-1.8*BWidth, 6*BHeight+1, 19*BWidth> rotate <0, 0, -52.55> texture { T_Tagsten  rotate <0, -90, 0> translate <0, -500, 0> } translate <0, 65*BHeight, 0> }
   object { B4Rygningprofil scale <1, 1, 24*BWidth> texture { T_Rygning } translate <0, 73*BHeight, -5*BHeight> }
   cylinder { <0, 0, -5*BHeight>, <0, 0, 19*BHeight>, 9 texture { T_Sandstone } translate <0, 73*BHeight, 0> }
}

#local B4Mur5=union{
   difference {
      box { <0, -5*BHeight, 0>, <146*BWidth, 3*BHeight, 50> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <146*BWidth, 0, 0>  }
      box { <6.9*BWidth, -1, -1>, <14.3*BWidth, 4*BHeight, 51> }  // Dr
      box { <75.125*BWidth, -1, -1>, <82.525*BWidth, 4*BHeight, 51> }  // Dr

      box { <109.025*BWidth, -1, -1>, <122.525*BWidth, 4*BHeight, BWidth/2> }
      box { <127.500*BWidth, -1, -1>, <141.000*BWidth, 4*BHeight, BWidth/2> }

      // Kldervinduer
      box { <23.20*BWidth, -6*BHeight, -1>, < 26.80*BWidth, 4*BHeight, 51> }
      box { <30.50*BWidth, -6*BHeight, -1>, < 34.10*BWidth, 4*BHeight, 51> }
      box { <44.70*BWidth, -6*BHeight, -1>, < 48.30*BWidth, 4*BHeight, 51> }
      box { <57.20*BWidth, -6*BHeight, -1>, < 60.80*BWidth, 4*BHeight, 51> }
      box { <64.50*BWidth, -6*BHeight, -1>, < 68.10*BWidth, 4*BHeight, 51> }
      box { <91.20*BWidth, -6*BHeight, -1>, < 94.80*BWidth, 4*BHeight, 51> }
      box { <98.50*BWidth, -6*BHeight, -1>, <102.10*BWidth, 4*BHeight, 51> }
      texture { T_Granit }
   }
   difference {
      box { <0, 3*BHeight, 0>, <146*BWidth, 202*BHeight, 50> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <146*BWidth, 0, 0>  }

      // Kldervinduer
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate < 25.0*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate < 32.3*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate < 46.5*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate < 59.0*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate < 66.3*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate < 93.0*BWidth, -5.5*BHeight, 0> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 10.7*BHeight translate <100.3*BWidth, -5.5*BHeight, 0> }

      // Stuen
      box { <6.9*BWidth, 0, -1>, <14.3*BWidth, 41*BHeight, 51> } // Dr
      cylinder { <0, 0, -1>, <0, 0, 51>, 3.7*BWidth scale <1, 1/1.2, 1> translate <10.6*BWidth, 41*BHeight, 0> }
      box { <23.20*BWidth, 17*BHeight, -1>, <33.95*BWidth, 45*BHeight, 51> }
      box { <42.35*BWidth, 17*BHeight, -1>, <50.60*BWidth, 45*BHeight, 51> }
      box { <57.20*BWidth, 17*BHeight, -1>, <67.95*BWidth, 45*BHeight, 51> }
      box { <75.125*BWidth, 0, -1>, <82.525*BWidth, 41*BHeight, 51> } // Dr
      cylinder { <0, 0, -1>, <0, 0, 51>, 3.7*BWidth scale <1, 1/1.2, 1> translate <78.825*BWidth, 41*BHeight, 0> }
      box { <91.225*BWidth, 17*BHeight, -1>, <101.975*BWidth, 45*BHeight, 51> }
      object { B4MurCutout5 translate <109.0*BWidth, 0, 0> }
      object { B4Vindue13Cutout translate <109.5*BWidth, 0, 0> }
      object { B4MurCutout5 translate <127.5*BWidth, 0, 0> }
      object { B4Vindue13Cutout translate <128.0*BWidth, 0, 0> }

      // 1. sal
      box { <  8.90*BWidth, 67*BHeight, -1>, < 12.30*BWidth, 89*BHeight, 76> }
      box { < 21.30*BWidth, 67*BHeight, -1>, < 35.85*BWidth, 197*BHeight, 76> } // Karnap
      box { < 42.35*BWidth, 67*BHeight, -1>, < 50.60*BWidth, 95*BHeight, 51> }
      box { < 57.20*BWidth, 67*BHeight, -1>, < 67.95*BWidth, 95*BHeight, 51> }
      box { < 60.10*BWidth, 54*BHeight, -1>, < 65.05*BWidth, 68*BHeight, 51> } // Fransk altandr
      box { < 74.70*BWidth, 67*BHeight, -1>, < 82.95*BWidth, 95*BHeight, 76> }
      box { < 89.33*BWidth, 67*BHeight, -1>, <103.87*BWidth, 197*BHeight, 76> } // Karnap
      box { <110.45*BWidth, 67*BHeight, -1>, <121.15*BWidth, 95*BHeight, 76> }
      box { <128.75*BWidth, 67*BHeight, -1>, <132.15*BWidth, 89*BHeight, 76> }
      box { <138.45*BWidth, 67*BHeight, -1>, <143.85*BWidth, 95*BHeight, 76> }

      // 2. sal
      box { <  8.90*BWidth, 118*BHeight, -1>, < 12.30*BWidth, 140*BHeight, 76> }
      box { < 42.35*BWidth, 118*BHeight, -1>, < 50.60*BWidth, 146*BHeight, 51> }
      box { < 57.20*BWidth, 118*BHeight, -1>, < 67.95*BWidth, 146*BHeight, 51> }
      box { < 74.70*BWidth, 118*BHeight, -1>, < 82.95*BWidth, 146*BHeight, 76> }
      box { <110.45*BWidth, 118*BHeight, -1>, <121.15*BWidth, 146*BHeight, 76> }
      box { <128.75*BWidth, 118*BHeight, -1>, <132.15*BWidth, 140*BHeight, 76> }
      box { <138.45*BWidth, 118*BHeight, -1>, <143.85*BWidth, 146*BHeight, 76> }

      // 3.sal
      box { <  6.47*BWidth, 168*BHeight, -1>, < 14.72*BWidth, 196*BHeight, 76> }
      box { < 42.35*BWidth, 168*BHeight, -1>, < 51.85*BWidth, 190*BHeight, 76> }
      box { < 54.70*BWidth, 168*BHeight, -1>, < 61.20*BWidth, 190*BHeight, 76> }
      box { < 64.10*BWidth, 168*BHeight, -1>, < 70.60*BWidth, 190*BHeight, 76> }
      box { < 73.45*BWidth, 168*BHeight, -1>, < 82.95*BWidth, 190*BHeight, 76> }
      box { <110.45*BWidth, 168*BHeight, -1>, <121.15*BWidth, 196*BHeight, 76> }
      box { <128.75*BWidth, 168*BHeight, -1>, <132.15*BWidth, 190*BHeight, 76> }
      box { <138.45*BWidth, 168*BHeight, -1>, <143.85*BWidth, 196*BHeight, 76> }

   }

   // Over kldervinduer
   box { <23*BWidth, 3*BHeight, BWidth/2>, < 70*BWidth, 6*BHeight, 50> texture { T_Sandstone } }
   box { <91*BWidth, 3*BHeight, BWidth/2>, <103*BWidth, 6*BHeight, 50> texture { T_Sandstone } }

   object { B4KaelderVindue translate <23.20*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <30.50*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <44.70*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <57.20*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <64.50*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <91.20*BWidth, -4.5*BHeight, BWidth/2> }
   object { B4KaelderVindue translate <98.50*BWidth, -4.5*BHeight, BWidth/2> }

   object { B4Doer1 translate <10.6*BWidth, 0, 0> }
   object { B4Vindue5 scale <10.75/10.5, 1, 1> translate <23.20*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue4 translate <42.35*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue5 scale <10.75/10.5, 1, 1> translate <57.20*BWidth, 18*BHeight, BWidth/2> }
   object { B4Doer1 translate <78.825*BWidth, 0, 0> }
   object { B4Vindue5 scale <10.75/10.5, 1, 1> translate <91.225*BWidth, 18*BHeight, BWidth/2> }
   object { B4Vindue13 translate <109.5*BWidth, 0, BWidth/2> }
   object { B4Vindue13A translate <128.0*BWidth, 0, BWidth/2> }

   object { B4Saalbaenk5A translate <23.20*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <42.35*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk5A translate <57.20*BWidth, 18*BHeight, BWidth/2> }
   object { B4Saalbaenk5A translate <91.225*BWidth, 18*BHeight, BWidth/2> }
   object { B4SaalbaenkProfil scale <12.75*BWidth-B4SaalbaenkMortar, 1, 1>
            texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
            translate <B4SaalbaenkMortar/2, 0, BWidth/2>
            translate <109.375*BWidth, 15*BHeight, BWidth/2>
   }
   object { B4SaalbaenkProfil scale <12.75*BWidth-B4SaalbaenkMortar, 1, 1>
            texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
            translate <B4SaalbaenkMortar/2, 0, BWidth/2>
            translate <127.875*BWidth, 15*BHeight, BWidth/2>
   }

   object { B4Mur5Karnap translate <28.575*BWidth, 45*BHeight, 0> }
   object { B4Mur5Karnap translate <96.600*BWidth, 45*BHeight, 0> }

   object { B4Vindue7 translate <  8.90*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue4 translate < 42.35*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue5FranskAltan translate <57.20*BWidth, 68*BHeight, BWidth/2> }
   object { B4Mur5Altan translate <56.20*BWidth, 50*BHeight, BWidth/2> }
   object { B4Vindue4 translate < 74.70*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue5 scale <10.75/10.5, 1, 1> translate <110.45*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue7 translate <128.75*BWidth, 68*BHeight, BWidth/2> }
   object { B4Vindue3 scale <5.4/5.8, 1, 1> translate <138.45*BWidth, 68*BHeight, BWidth/2> }

   difference {
      box { <125.5*BWidth, 63*BHeight, -0.1>, <146*BWidth+0.1, 65*BHeight, 5*BWidth> }
      plane {-x, 0 rotate <0, -45, 0> translate <146*BWidth, 0, 0> }
      texture { T_Sandstone  }
   }
   object { B4Saalbaenk7 translate < 8.90*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <42.35*BWidth, 68*BHeight, BWidth/2> }
   difference {
      object { B4Saalbaenk5A translate <57.20*BWidth, 68*BHeight, BWidth/2> }
      box { < 60.10*BWidth, 65*BHeight, -20>, < 65.05*BWidth, 70*BHeight, 51> } // Fransk altandr
      texture { T_B4Saalbaenkcolor }
   }
   object { B4Saalbaenk4 translate <74.70*BWidth, 68*BHeight, BWidth/2> }
   object { B4Saalbaenk5A translate <110.45*BWidth, 68*BHeight, BWidth/2> }
   difference {
      object { B4SaalbaenkProfil scale <21.5*BWidth-B4SaalbaenkMortar, 1, 1> }
      plane { -x, 0 rotate <0, -45, 0> translate <20.5*BWidth, 0, 0> }
      texture { T_B4Saalbaenk translate <BWidth/4, 10, -100> }
      translate <125.5*BWidth, 68*BHeight, BWidth/2>
   }

   object { B4Vindue7 translate <  8.90*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue4 translate < 42.35*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue5 scale <10.75/10.5, 1, 1> translate <57.20*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue4 translate < 74.70*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue5 scale <10.75/10.5, 1, 1> translate <110.45*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue7 translate <128.75*BWidth, 119*BHeight, BWidth/2> }
   object { B4Vindue3 scale <5.4/5.8, 1, 1> translate <138.45*BWidth, 119*BHeight, BWidth/2> }

   object { B4Saalbaenk3D scale <-1, 1, 1> translate <(146-2.20)*BWidth, 98*BHeight, BWidth/2> }

   object { B4Saalbaenk7 translate < 8.90*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <42.35*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk5A translate <57.20*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk4 translate <74.70*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk5A translate <110.45*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk7 translate <128.75*BWidth, 119*BHeight, BWidth/2> }
   object { B4Saalbaenk3C scale <-1, 1, 1> translate <(146-2.20)*BWidth, 119*BHeight, BWidth/2> }

   object { B4Saalbaenk3D scale <-1, 1, 1> translate <(146-2.20)*BWidth, 149*BHeight, BWidth/2> }

   object { B4Vindue4 translate < 6.47*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue9 scale <9.5/9.75, 1, 1> translate <42.35*BWidth, 168*BHeight, BWidth/2> }
   object { B4Vindue10 scale <6.5/5.5, 1, 1> translate <54.70*BWidth, 168*BHeight, BWidth/2> }
   object { B4Vindue10 scale <6.5/5.5, 1, 1> translate <64.10*BWidth, 168*BHeight, BWidth/2> }
   object { B4Vindue9 scale <9.5/9.75, 1, 1> translate <73.45*BWidth, 168*BHeight, BWidth/2> }
   object { B4Vindue5 scale <10.75/10.5, 1, 1> translate <110.45*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue7 translate <128.75*BWidth, 169*BHeight, BWidth/2> }
   object { B4Vindue3 scale <5.4/5.8, 1, 1> translate <138.45*BWidth, 169*BHeight, BWidth/2> }

   difference {
      box { <0, 164*BHeight, -0.1>, <146*BWidth, 166*BHeight, 75> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <146*BWidth, 0, 0> }
      texture { T_Sandstone }
   }
   difference {
      object { B4SaalbaenkProfil scale <149*BWidth, 1, 1> translate <-1.5*BWidth, 0, BWidth/2> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <146*BWidth, 0, 0> }
      texture { T_B4Saalbaenk translate <-4, 10, -100> }
      translate <0, 169*BHeight, 0>
   }
   box { <40.75*BWidth, 190*BHeight, -2>, <84.55*BWidth, 194*BHeight, 0> texture { T_Sandstone } }
   difference {
      box { <40.75*BWidth, 192*BHeight, -12>, <84.55*BWidth, 194*BHeight, 0> }
      cylinder { <40*BWidth, 192*BHeight, -12>, <85*BWidth, 192*BHeight, -12>, 7 }
      texture { T_Sandstone }
   }
   difference {
      box { <137*BWidth, 196*BHeight, -0.1>, <146*BWidth+0.1, 198*BHeight, 5*BWidth> }
      plane {-x, 0 rotate <0, -45, 0> translate <146*BWidth, 0, 0> }
      texture { T_Sandstone  }
   }

   difference {
      object { B4TagGesimsprofil scale <20*BWidth, 1, 1> translate <-1.5*BWidth, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <16.775*BWidth, 0, 0> }
      translate <0, 202*BHeight, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <20.2*BWidth, 1, 1> translate <-2*BWidth, 0, -33> }
      plane { x, 0 rotate <0,  45, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <0, 207*BHeight, 0>
   }
   object { B4TagrendeEnde translate <18.2*BWidth, 207*BHeight, -33> }
   object { B4Mur5Gavltrekant translate <28.575*BWidth, 202*BHeight, 0> }
   difference {
      object { B4TagGesimsprofil scale <47.5*BWidth, 1, 1> translate <-1.5*BWidth, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <44.425*BWidth, 0, 0> }
      translate <40.375*BWidth, 202*BHeight, 0>
      texture { T_Sandstone }
   }
   object { B4TagrendeEnde translate <38.6*BWidth, 207*BHeight, -33> }
   object { B4Tagrendeprofil scale <48*BWidth, 1, 1> texture { T_LinedZink rotate <0, 0, 90> } translate <38.6*BWidth, 207*BHeight, -33> }
   object { B4TagrendeEnde translate <86.6*BWidth, 207*BHeight, -33> }
   object { B4Mur5Gavltrekant translate <96.600*BWidth, 202*BHeight, 0> }
   difference {
      object { B4TagGesimsprofil scale <41*BWidth, 1, 1> translate <-1.5*BWidth, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <37.6*BWidth, 0, 0> }
      translate <108.4*BWidth, 202*BHeight, 0>
      texture { T_Sandstone }
   }
   difference {
      object { B4Tagrendeprofil scale <42*BWidth, 1, 1> translate <-1.5*BWidth, 0, -33> }
      plane {-x, 0 rotate <0, -45, 0> translate <37.6*BWidth, 0, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      translate <108.4*BWidth, 207*BHeight, 0>
   }
   object { B4TagrendeEnde translate <106.9*BWidth, 207*BHeight, -33> }
   object { B4Nedloeb translate <53.275*BWidth, 0, 0> }
   object { B4Nedloeb translate <125*BWidth, 0, 0> }

//   object { ForchSign scale 1.5 translate <141.5*BWidth, 44*BHeight, 0> }

//Gavlmur - "Mur 6"
   union {
      difference {
         box { <-58*BWidth, 0, 0>, <0, 3*BHeight, 50> }
         plane { -x, 0 rotate <0, 45, 0> }
         texture { T_Granit }
      }
      difference {
         box { <-58*BWidth, 3*BHeight, 0>, <0, 202*BHeight, 50> }
         plane { -x, 0 rotate <0, 45, 0> }
         texture { T_B4Brick }
      }
      difference {
         object { B4TagGesimsprofil scale <61*BWidth, 1, 1> translate <-59.5*BWidth, 0, 0> }
         plane {-x, 0 rotate <0, -45, 0>}
         translate <0, 202*BHeight, 0>
         texture { T_Sandstone }
      }
      difference {
         object { B4Tagrendeprofil scale <63*BWidth, 1, 1> translate <-60*BWidth, 0, -33> }
         plane {-x, 0 rotate <0, -45, 0>}
         texture { T_LinedZink rotate <0, 0, 90> }
         translate <0, 207*BHeight, 0>
      }
      rotate <0, 90, 0>
   }

   texture { T_B4Brick }
}

/*------------------- Tage -----------------------*/

#local B4Skorsten=union {
   box { <-1.25*BWidth, -25*BHeight, -2.5*BWidth>, <1.25*BWidth, 0, 2.5*BWidth> }
   box { <-1.125*BWidth, 0, -2.25*BWidth>, <1.125*BWidth, BHeight, 2.25*BWidth> }
   box { <-1*BWidth, BHeight, -2*BWidth>, <1*BWidth, 12*BHeight, 2*BWidth> }
   box { <-1.25*BWidth, 12*BHeight, -2.25*BWidth>, <1.25*BWidth, 12*BHeight+5, 2.25*BWidth> texture { T_Skifer } }
   texture { T_B4Brick }
}

#local B4TagMansardRygning=difference{
   torus { 7.071*BWidth, 10 rotate <0, 0, 90> }
   cylinder { <-11, 0, 0>, <11, 0, 0>, 7.071*BWidth inverse }
   plane {-y, 0 }
   plane { z, 0 }
   plane { z, 0 rotate <-60, 0, 0> translate <0, -6.5*BWidth, 3.8*BWidth> } // Trial and error values
   scale <1, 13/7.071, 1> translate <0, 0, -7.071*BWidth>
   texture { T_Tagsten scale <1, 1.2, 1> }
}

#local B4TagValmprofil=difference {
   box { <0, 0, 0.6*BWidth>, <1, 51*BHeight, 19*BWidth> }
   plane {-y, 0 rotate <-37.65, 0, 0> translate <0, 51*BHeight, 19*BWidth> }
   translate <0, 45*BHeight, 0>
}

#local B4Tag1=union{
   difference {
      box { <0.1, 0, -1.4*BWidth>, <102.25*BWidth, 42*BHeight, 3*BWidth> }
      intersection {
         plane {-x, 0 rotate <0, 0, -41> }
         plane { x, 0 rotate <0, 0,  41> }
         translate <64.5*BWidth, (9+87)*BHeight, 0>
      }
      cylinder { <-1.5*BWidth, 0, 0>, <104*BWidth, 0, 0>, 5*BWidth scale <1, 13/5, 1> translate <0, 42*BHeight, -3.8*BWidth> }
      box { <-2.075*BWidth, BHeight, -1>, <2.075*BWidth, 21.5*BHeight, 76> translate <23.50*BWidth, 11*BHeight, 0> pigment { White } }
      box { <-3.150*BWidth, BHeight, -1>, <3.150*BWidth, 21.5*BHeight, 76> translate <37.35*BWidth, 11*BHeight, 0> pigment { White } }
      box { <-3.150*BWidth, BHeight, -1>, <3.150*BWidth, 21.5*BHeight, 76> translate <91.05*BWidth, 11*BHeight, 0> pigment { White } }
      texture { T_Tagsten scale <1, 1.2, 1> }
   }
   difference {
      object { B4MansardGesimsprofil scale <100.75*BWidth, 1, 1> translate <1.5*BWidth, 42*BHeight, 1.3*BWidth> }
      intersection {
         plane {-x, 0 rotate <0, 0, -41> }
         plane { x, 0 rotate <0, 0,  41> }
         translate <64.5*BWidth, (9+87)*BHeight, 0>
      }
      texture { T_Sandstone }
   }
   difference {
      object { B4TagValmprofil scale <103.65*BWidth, 1, 1> translate <-1.4*BWidth, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> translate <-1.35*BWidth, 0, 0> }
      texture { T_Tagsten rotate <52, 0, 0> }
   }
   object { B4Rygningprofil scale <1, 1, 29.5*BWidth> texture { T_Rygning } rotate <-28.62, 0, 0> rotate <0, 45, 0> translate <-0.35*BWidth, 45*BHeight, BWidth> }
   object { B4Rygningprofil scale <1, 1, 84.6*BWidth> texture { T_Rygning } rotate <0, 90, 0> translate <17.65*BWidth, 96*BHeight, 19*BWidth> }

   object { B4Kvist2FagHvid translate <23.50*BWidth, 11*BHeight, 0> }
   object { B4Kvist3FagHvid translate <37.35*BWidth, 11*BHeight, 0> }
   object { B4Kvist3FagHvid translate <91.05*BWidth, 11*BHeight, 0> }

// "Bagside"
   difference {
      box { <0, 0, -1.4*BWidth>, <102.15*BWidth, 42*BHeight, 3*BWidth> }
      cylinder { <-1.5*BWidth, 0, 0>, <104*BWidth, 0, 0>, 5*BWidth scale <1, 13/5, 1> translate <0, 42*BHeight, -3.8*BWidth> }
      texture { T_Tagsten scale <1, 1.2, 1> }
      rotate <0, 180, 0> translate <102.25*BWidth, 0, 38*BWidth>
   }
   object { B4MansardGesimsprofil scale <100.75*BWidth, 1, 1> translate <1.5*BWidth, 42*BHeight, 1.3*BWidth>
            texture { T_Sandstone }
            rotate <0, 180, 0> translate <102.25*BWidth, 0, 38*BWidth>
   }
   difference {
      object { B4TagValmprofil scale <103.65*BWidth, 1, 1> translate <-102.25*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <1.35*BWidth, 0, 0> }
      texture { T_Tagsten rotate <52, 0, 0> }
      rotate <0, 180, 0> translate <0, 0, 38*BWidth>
   }
// Mur 2
   difference {
      object { B4TagValmprofil scale <38*BWidth, 1, 1> translate <-19*BWidth, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> translate <0, 0, 19*BWidth> }
      plane {-x, 0 rotate <0, -45, 0> translate <0, 0, 19*BWidth> }
      texture { T_Tagsten rotate <52, 0, 0> }
      rotate <0, 90, 0> translate <-1.35*BWidth, 0, 19*BWidth>
   }
   object { B4Rygningprofil scale <1, 1, 29.5*BWidth> texture { T_Rygning } rotate <-28.62, 0, 0> rotate <0, 135, 0> translate <-0.35*BWidth, 45*BHeight, 37*BWidth> }
   object { B4Skorsten translate <20*BWidth, 98*BHeight, 19*BWidth> }
   object { B4Skorsten translate <40.5*BWidth, 98*BHeight, 19*BWidth> }
   object { B4Skorsten translate <55*BWidth, 98*BHeight, 19*BWidth> }
   object { B4Skorsten translate <85*BWidth, 98*BHeight, 19*BWidth> }
}

#local B4Tag3=union{
   difference {
      box { <1.2*BWidth, 0, -1.4*BWidth>, <22*BWidth, 42*BHeight, 3*BWidth> }
      cylinder { <-1, 0, 0>, <23*BWidth, 0, 0>, 5*BWidth scale <1, 13/5, 1> translate <0, 42*BHeight, -3.8*BWidth> }
      box { <-3.65*BWidth, -1, -50>, <3.65*BWidth, 32.5*BHeight, 76> translate <15.0*BWidth, 0, 0> pigment { Gray60 } }
      texture { T_Tagsten scale <1, 1.2, 1> }
      translate <0, 0, 10.25*BWidth>
   }
   difference {
      object { B4MansardGesimsprofil scale <25*BWidth, 1, 1> translate <-2.5*BWidth, 42*BHeight, 1.3*BWidth> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-2.5*BWidth, 0, 0> }
      texture { T_Sandstone }
      translate <0, 0, 10*BWidth>
   }

   difference {
      object { B4Tagrendeprofil scale <25*BWidth, 1, 1> translate <-3.5*BWidth, 0, 1.5*BWidth-20> }
      plane { x, 0 rotate <0, 22.5, 0> translate <-2.4*BWidth, 0, 0>  }
      plane {-x, 0 rotate <0, 45, 0> translate <20.5*BWidth, 0, 0>  }
      texture { T_LinedZink rotate <0, 0, 90> translate <-2.5*BWidth, 0, 0>  }
      translate <0, 44*BHeight, 10*BWidth>
   }

   difference {
      object { B4Tagrendeprofil scale <10.5*BWidth, 1, 1> translate <-2*BWidth, 0, 1.3*BWidth-20> }
      plane { x, 0 rotate <0, -45, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      rotate <0, 90, 0> translate <20.5*BWidth, 44*BHeight, 10.25*BWidth>
   }
   difference {
      object { B4TagValmprofil scale <41.5*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 22.5, 0> }
      texture { T_Tagsten rotate <52, 0, 0> }
      translate <-2.5*BWidth, 0, 10*BWidth>
   }
   object { B4Rygningprofil scale <1, 1, 33.3*BWidth> texture { T_Rygning } rotate <0, 90, 0> translate <5.38*BWidth, 96*BHeight, (10+19)*BWidth> }
   object { B4Rygningprofil scale <1, 1, 24.3*BWidth> texture { T_Rygning } rotate <-35.53, 0, 0> rotate <0, 22.5, 0> translate <-2*BWidth, 45*BHeight, (1+10)*BWidth> }

   object { B4TagterrasseDoer translate <15.0*BWidth, 11*BHeight, 10.25*BWidth> }
   object { B4Skorsten translate <13*BWidth, 98*BHeight, 29*BWidth> }

   difference {
      object { B4TagValmprofil scale <57*BWidth, 1, 1> translate <-28.5*BWidth, 0, -1.5*BWidth> }
      plane { x, 0 rotate <0,  22.5, 0> translate <-26*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> translate < 26*BWidth, 0, 0> }
      texture { T_Tagsten rotate <52, 0, 0> }
      rotate <0, 45, 0> translate <-20.125*BWidth, 0, 29.875*BWidth>
   }
   object { B4Rygningprofil scale <1, 1, 36.8*BWidth> texture { T_Rygning }
            rotate <0, 90, 0> translate <-18.4*BWidth, 96*BHeight, (19-1.5)*BWidth>
            rotate <0, 45, 0> translate <-20.125*BWidth, 0, 29.875*BWidth>
   }

   object { B4Rygningprofil scale <1, 1, 24.3*BWidth> texture { T_Rygning } rotate <-35.53, 0, 0> rotate <0, 67.5, 0> translate <-39.25*BWidth, 45*BHeight, 47.75*BWidth> }

   difference {
      box { <0, 0, -1.4*BWidth>, <12*BWidth, 42*BHeight, 3*BWidth> }
      cylinder { <-1, 0, 0>, <13*BWidth, 0, 0>, 5*BWidth scale <1, 13/5, 1> translate <0, 42*BHeight, -3.8*BWidth> }
      texture { T_Tagsten scale <1, 1.2, 1> }
      rotate <0, 90, 0> translate <-40.25*BWidth, 0, 63.2*BWidth>
   }
   difference {
      object { B4MansardGesimsprofil scale <12*BWidth, 1, 1> translate <-12*BWidth, 42*BHeight, 1.3*BWidth> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      texture { T_Sandstone }
      rotate <0, 90, 0> translate <-40.25*BWidth, 0, 47.5*BWidth>
   }
   difference {
      object { B4TagValmprofil scale <32*BWidth, 1, 1> translate <-32*BWidth, 0, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      texture { T_Tagsten rotate <52, 0, 0> }
      rotate <0, 90, 0> translate <-40.25*BWidth, 0, 47.5*BWidth>
   }
   object { B4Rygningprofil scale <1, 1, 24.5*BWidth> texture { T_Rygning } translate <-21.25*BWidth, 96*BHeight, 55.5*BWidth> }
   difference {
      object { B4Tagrendeprofil scale <7*BWidth, 1, 1> translate <-4*BWidth, 0, 1.3*BWidth-10> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      texture { T_LinedZink rotate <0, 0, 90> }
      rotate <0, 90, 0> translate <-40.25*BWidth, 44*BHeight, 47.5*BWidth>
   }
   object { B4TagrendeEnde translate <-4*BWidth, 0, 1.3*BWidth-10> rotate <0, 90, 0> translate <-40.25*BWidth, 44*BHeight, 47.5*BWidth> }
}

#local B4Tag4=union{
   difference {
      box { <-1.4*BWidth, 0, -1.4*BWidth>, <15*BWidth, 42*BHeight, 3*BWidth> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, 0, -37.45> translate <6.4*BWidth, 0, 0> }
      cylinder { <-1.5*BWidth, 0, 0>, <16*BWidth, 0, 0>, 5*BWidth scale <1, 13/5, 1> translate <0, 42*BHeight, -3.8*BWidth> }
      texture { T_Tagsten scale <1, 1.2, 1> }
   }
   difference {
      box { <65*BWidth, 0, -1.4*BWidth>, <88*BWidth, 42*BHeight, 3*BWidth> }
      box { <-3.65*BWidth, -1, -50>, <3.65*BWidth, 32.5*BHeight, 76> translate <81.0*BWidth, 0, 0> pigment { Gray60 } }
      plane { x, 0 rotate <0, 0, 37.45> translate <74.65*BWidth, 0, 0> }
      cylinder { <64*BWidth, 0, 0>, <90*BWidth, 0, 0>, 5*BWidth scale <1, 13/5, 1> translate <0, 42*BHeight, -3.8*BWidth> }
      texture { T_Tagsten scale <1, 1.2, 1> }
   }
   difference {
      object { B4MansardGesimsprofil scale <20*BWidth, 1, 1> translate <0, 42*BHeight, 1.3*BWidth> }
      plane { x, 0 rotate <0, 45, 0> }
      texture { T_Sandstone }
   }
   object { B4MansardGesimsprofil scale <28*BWidth, 1, 1> translate <60*BWidth, 42*BHeight, 1.3*BWidth> texture { T_Sandstone } }
   difference {
      object { B4TagValmprofil scale <107*BWidth, 1, 1>}
      plane { x, 0 rotate <0,  45, 0> }
      box { <21*BWidth, 44*BHeight, 0>, <60*BWidth, 50*BHeight, 1.4*BWidth> }
      texture { T_Tagsten rotate <52, 0, 0> }
   }
   object { B4TagMansardRygning rotate <0, 45, 0> translate <1.5*BWidth, 42*BHeight, 1.5*BWidth> }
   object { B4Rygningprofil scale <1, 1, 29.5*BWidth> texture { T_Rygning }  rotate <-28.62, 0, 0> rotate <0, 45, 0> translate <BWidth, 45*BHeight, BWidth> }
   object { B4Rygningprofil scale <1, 1, 86*BWidth> texture { T_Rygning } rotate <0, 90, 0> translate <19*BWidth, 96*BHeight, 19*BWidth> }
   object { B4TagterrasseDoer translate <81.0*BWidth, 11*BHeight, 0> }
   object { B4Skorsten translate <50*BWidth, 98*BHeight, 19*BWidth> }
}

#local B4Tag5=union{
   difference {
      box { <-1.4*BWidth, 0, -1.4*BWidth>, <147.4*BWidth, 42*BHeight, 3*BWidth> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <146*BWidth, 0, 0> }
      intersection {
         plane {-x, 0 rotate <0, 0, -37.45> }
         plane { x, 0 rotate <0, 0,  37.45> }
         translate <28.575*BWidth, (9+59)*BHeight, 0>
      }
      intersection {
         plane {-x, 0 rotate <0, 0, -37.45> }
         plane { x, 0 rotate <0, 0,  37.45> }
         translate <96.6*BWidth, (9+59)*BHeight, 0>
      }
      cylinder { <-1.5*BWidth, 0, 0>, <148*BWidth, 0, 0>, 5*BWidth scale <1, 13/5, 1> translate <0, 42*BHeight, -3.8*BWidth> }
      box { <-2.075*BWidth, BHeight, -1>, <2.075*BWidth, 21.5*BHeight, 76> translate <46.500*BWidth, 11*BHeight, 0> pigment { White } }
      box { <-4.225*BWidth, BHeight, -1>, <4.225*BWidth, 21.5*BHeight, 76> translate <62.575*BWidth, 11*BHeight, 0> pigment { White } }
      box { <-2.075*BWidth, BHeight, -1>, <2.075*BWidth, 21.5*BHeight, 76> translate <78.650*BWidth, 11*BHeight, 0> pigment { White } }
      box { <-3.150*BWidth, BHeight, -1>, <3.150*BWidth, 21.5*BHeight, 76> translate <115.80*BWidth, 11*BHeight, 0> pigment { White } }
      box { <-3.150*BWidth, BHeight, -1>, <3.150*BWidth, 21.5*BHeight, 76> translate <130.10*BWidth, 11*BHeight, 0> pigment { White } }
      texture { T_Tagsten scale <1, 1.2, 1> }
   }
   difference {
      object { B4MansardGesimsprofil scale <146*BWidth, 1, 1> translate <0, 42*BHeight, 1.3*BWidth> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <146*BWidth, 0, 0> }
      texture { T_Sandstone }
   }
   difference {
      object { B4TagValmprofil scale <146*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <146*BWidth, 0, 0> }
      texture { T_Tagsten rotate <52, 0, 0> }
   }
   object { B4TagMansardRygning rotate <0, 45, 0> translate <1.5*BWidth, 42*BHeight, 1.5*BWidth> }
   object { B4Rygningprofil scale <1, 1, 29.5*BWidth> texture { T_Rygning } rotate <-28.62, 0, 0> rotate <0, 45, 0> translate <BWidth, 45*BHeight, BWidth> }
   object { B4Rygningprofil scale <1, 1, 108*BWidth> texture { T_Rygning } rotate <0, 90, 0> translate <19*BWidth, 96*BHeight, 19*BWidth> }

   object { B4Skorsten translate <86*BWidth, 98*BHeight, 19*BWidth> }

   object { B4Kvist2FagGraa translate <46.5*BWidth, 11*BHeight, 0> }
   object { B4Kvist4Fag translate <62.575*BWidth, 11*BHeight, 0> }
   object { B4Kvist2FagGraa translate <78.65*BWidth, 11*BHeight, 0> }
   object { B4Kvist3FagGraa translate <115.8*BWidth, 11*BHeight, 0> }
   object { B4Kvist3FagGraa translate <130.1*BWidth, 11*BHeight, 0> }

// "Mur 6"
   difference {
      box { <-1.4*BWidth, 0, -1.4*BWidth>, <59.4*BWidth, 42*BHeight, 3*BWidth> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <58*BWidth, 0, 0> }
      cylinder { <-1.5*BWidth, 0, 0>, <60*BWidth, 0, 0>, 5*BWidth scale <1, 13/5, 1> translate <0, 42*BHeight, -3.8*BWidth> }
      texture { T_Tagsten scale <1, 1.2, 1> }
      rotate <0, 90, 0> translate <0, 0, 58*BWidth>
   }
   difference {
      object { B4MansardGesimsprofil scale <58*BWidth, 1, 1> translate <0, 42*BHeight, 1.3*BWidth> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <58*BWidth, 0, 0> }
      rotate <0, 90, 0> translate <0, 0, 58*BWidth>
      texture { T_Sandstone }
   }
   difference {
      object { B4TagValmprofil scale <58*BWidth, 1, 1> }
      plane { x, 0 rotate <0, 45, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <58*BWidth, 0, 0> }
      texture { T_Tagsten rotate <52, 0, 0> }
      rotate <0, 90, 0> translate <0, 0, 58*BWidth>
   }
}

/*------------------- Omgivelser -----------------------*/

#local B4HegnPind=union {
   box { <-2.5, 0, -2.5>, <2.5, 100, 2.5> }
   difference {
      cylinder { <-2.5, 0, 0>, <2.5, 0, 0>, 10 scale <1, 12.2/10, 1> }
      cylinder { <-3, 0, 0>, <3, 0, 0>, 5 scale <1, 13.3/5, 1> }
      plane {-z, 0 }
      plane { y, 0 }
      plane {-y, 0 rotate <-16, 0, 0> translate <0, 11.3, -3.7792> }
      translate <0, 100, 7.5>
   }
   difference {
      cylinder { <-2.5, 0, 0>, <2.5, 0, 0>, 5 scale <1, 8.57/5, 1> }
      cylinder { <-3, 0, 0>, <3, 0, 0>, 4.5 scale <1, 8/4.5, 1> }
      plane { z, 0 }
      plane {-y, 0 }
      plane { y, 0 rotate <-16, 0, 0> translate <0, -7.7, 1.2208> }
      translate <0, 119, 2.5>
   }
   difference {
      cylinder { <-2.5, 0, 0>, <2.5, 0, 0>, 5 }
      cylinder { <-3, 0, 0>, <3, 0, 0>, 4.5 }
      plane { y, 0 }
      translate <0, 119, 2.5>
   }
   difference {
      cylinder { <-2.5, 0, 0>, <2.5, 0, 0>, 4 }
      cylinder { <-3, 0, 0>, <3, 0, 0>, 3.5 }
      plane {-y, 0 }
      plane {-z, 0 }
      translate <0, 119, 1.5>
   }
   difference {
      cylinder { <-2.5, 0, 0>, <2.5, 0, 0>, 2 }
      cylinder { <-3, 0, 0>, <3, 0, 0>, 1.5 }
      plane { z, 0 }
      translate <0, 117, 1.5>
   }
   texture { T_B4Hegn }
}

#local B4HegnDel=union {
   cylinder { <-5, 35, 0>, <-5, 110, 0>, 0.5 }
   difference {
      torus { 5, 0.5 rotate <90, 0, 0> }
      plane { y, 0 }
      translate <0, 110, 0>
   }
   cylinder { < 5, 35, 0>, < 5, 110, 0>, 0.5 }
   texture { T_B4Hegn }
}

#local B4Hegn=union {
   difference {
      cylinder { <0, 11, 0>, <0, 15, 0>, 50*BWidth-5 }
      cylinder { <0, 10, 0>, <0, 16, 0>, 50*BWidth-6 }
      plane {-x, 0 }
      plane { z, 0 }
      texture { T_B4Hegn }
   }
   difference {
      cylinder { <0, 32, 0>, <0, 36, 0>, 50*BWidth-5 }
      cylinder { <0, 31, 0>, <0, 37, 0>, 50*BWidth-6 }
      plane {-x, 0 }
      plane { z, 0 }
      texture { T_B4Hegn }
   }
   difference {
      cylinder { <0, 100, 0>, <0, 104, 0>, 50*BWidth-5 }
      cylinder { <0,  99, 0>, <0, 105, 0>, 50*BWidth-6 }
      plane {-x, 0 }
      plane { z, 0 }
      texture { T_B4Hegn }
   }
   #declare ang = 0;
   #while (ang <= 90)
      #if (ang = 0)
         object { B4HegnPind rotate <0, 90, 0> translate <7-50*BWidth, 0, 0> rotate <0, ang+1, 0> }
         #declare an = ang + 2;
      #else
         #if (ang = 90)
            object { B4HegnPind rotate <0, 90, 0> translate <7-50*BWidth, 0, 0> rotate <0, 89, 0> }
         #else
            object { B4HegnPind rotate <0, 90, 0> translate <7-50*BWidth, 0, 0> rotate <0, ang, 0> }
            #declare an = ang + 1;
         #end
      #end
      #if(ang < 90)
         #while (an < (ang+10))
            #if(an < 89)
               object { B4HegnDel rotate <0, 90, 0> translate <6.5-50*BWidth, 0, 0> rotate <0, an, 0>}
            #end
            #declare an = an + 1;
         #end
      #end
      #declare ang = ang + 10;
   #end
/*
   #declare ang = 1;
   #while (ang <= 91)
       cylinder { <0, 0, 0>, <0, 25, 0>, 0.2 texture { T_B4Hegn } rotate <45, 0, 0> translate <6-50*BWidth, 14.75, 0> rotate <0, ang, 0> }
       cylinder { <0, 0, 0>, <0, 25, 0>, 0.2 texture { T_B4Hegn } rotate <-45, 0, 0> translate <6-50*BWidth, 14.75, 0> rotate <0, ang, 0> }
       #declare ang = ang + 0.336;
   #end
*/
}

#local B4Have=union {
   difference {
      cylinder { <0, 0, 0>, <0, 8, 0>, 50*BWidth }
      cylinder { <0, -1, 0>, <0, 10, 0>, 49.5*BWidth }
      plane {-x, 0 }
      plane { z, 0 }
      texture { T_Granit }
   }
   difference {
      cylinder { <0, 0, 0>, <0, 7, 0>, 49.5*BWidth }
      plane {-x, 0 }
      plane { z, 0 }
      texture { pigment { Green } }
   }
   object { B4Hegn }
}

/*------------------- Samlet bygning -----------------------*/

#declare Bygning4=union{
   box { <51, 0, 51>, <102*BWidth, 200*BHeight, 1300> pigment { Black } }
   object { B4Mur1 }
   object { B4Tag1 translate <0, 208*BHeight, 0> }
   object { B4Mur2 rotate <0,  90, 0> translate <0, 0, 58*BWidth> }
   object { B4Mur3 rotate <0,  90, 0> translate <0, 0, 58*BWidth> }
   object { B4Tag3 rotate <0,  90, 0> translate <0, 208*BHeight, 58*BWidth> }
   object { B4Mur4 rotate <0,  90, 0> translate <58*BWidth, 0, 185*BWidth> }
   object { B4Tag4 rotate <0,  90, 0> translate <58*BWidth, 208*BHeight, 185*BWidth> }
   object { B4Mur5 rotate <0, 180, 0> translate <204*BWidth, 0, 185*BWidth> }
   object { B4Tag5 rotate <0, 180, 0> translate <204*BWidth, 208*BHeight, 185*BWidth> }
   object { B4Have translate <50*BWidth, 0, 58*BWidth> }
}
