//@---------Include Header--------------------------------------------------------

#ifdef(Murasaki_Inc_Temp)
  #ifdef (View_POV_Include_Stack)
    #debug "Murasaki.inc already included!\n"
  #end
#else
  #declare Murasaki_Inc_Temp = version;
  #ifdef(View_POV_Include_Stack)
    #debug "including Murasaki.inc\n"
  #end

//@---------Variables-------------------------------------------------------------

#declare GenjiDist  = -300;
#declare ChujoDist  = -300;
#declare RyozenDist = -450;
#declare ReefDist   = -600;
#declare SuzakuDist = -800;

//@---------Sub Includes----------------------------------------------------------

#include "colors.inc"

//@---------Textures--------------------------------------------------------------

#declare GenjiLandPig  = pigment{ Green }
#declare GenjiWaterPig = pigment{ SkyBlue }
#declare ChujoLandPig  = pigment{ NewTan }
#declare ChujoWaterPig = pigment{ SkyBlue }

#declare GenjiTex =
texture{
  pigment{
    bozo
    turbulence 1
    scale 2
    pigment_map{
      [ 0.0 GenjiWaterPig ]
      [ 0.8 GenjiWaterPig ]
      [ 0.8 GenjiLandPig ]
      [ 1.0 GenjiLandPig ]
    }
  }
  normal{
    bozo
    turbulence 1
    scale 2
  }
}
#declare ChujoTex =
texture{
  pigment{
    bozo
    turbulence 1
    scale 2
    pigment_map{
      [ 0.0 ChujoWaterPig ]
      [ 0.2 ChujoWaterPig ]
      [ 0.2 ChujoLandPig ]
      [ 1.0 ChujoLandPig ]
    }
  }
  normal{
    bozo
    turbulence 1
    scale 2
  }
}

#declare R_CloudPig =
pigment{
  bozo
  turbulence 0.65
  pigment_map{
    [ 0.0 Blue ]
    [ 0.2 Aquamarine ]
    [ 0.5 Cyan ]
    [ 0.8 Aquamarine ]
    [ 1.0 Blue ]
  }
  scale .25
}
#declare S_CloudPig =
pigment{
  bozo
  turbulence 0.65
  pigment_map{
    [ 0.0 Brown ]
    [ 0.2 NewTan ]
    [ 0.5 Yellow ]
    [ 0.8 NewTan ]
    [ 1.0 Brown ]
  }
  scale .25
}
#declare SuzakuPig =
pigment{
  marble
  rotate 90*z
  scale 10
  turbulence < .25, .1, .25>
  scale 1
  pigment_map{
    [ 0.000 Orange ]
    [ 0.200 S_CloudPig ]
    [ 0.300 S_CloudPig ]
    [ 0.500 Orange ]
    [ 0.700 S_CloudPig ]
    [ 0.800 S_CloudPig ]
    [ 1.000 Orange ]
  }
}
#declare RyozenPig =
pigment{
  marble
  rotate 90*z
  scale 10
  turbulence < .25, .1, .25>
  scale 1
  pigment_map{
    [ 0.000 SummerSky ]
    [ 0.200 R_CloudPig ]
    [ 0.300 R_CloudPig ]
    [ 0.500 SummerSky ]
    [ 0.700 R_CloudPig ]
    [ 0.800 R_CloudPig ]
    [ 1.000 SummerSky ]
  }
}
#declare RingTex =
texture{
  pigment{
    granite
    pigment_map{
      [ 0.00000 Clear ]
      [ 0.35000 Clear ]
      [ 0.35001 LightBlue ]
      [ 0.65000 LightBlue ]
      [ 0.65001 Clear ]
      [ 1.00000 Clear ]
    }
  }
  normal{
    bumps
    bump_size 5
  }
}
#declare AsteroidTexA =
texture{
  pigment{ Gray80 }
  normal{
    wrinkles
    scale .4
    bump_size 2
  }
  finish{ ambient .4 }
}
#declare AsteroidTexB =
texture{
  pigment{ NewTan }
  normal{
    dents
    scale .4
    bump_size 2
  }
  finish{ ambient .3 }
}

//@---------Object Declares-------------------------------------------------------

//@@---Genji & Chujo---
#declare Genji =
sphere{
  0,5
  texture{ GenjiTex }
  translate GenjiDist*z
  rotate < 0,-145, 0>
  translate SunPos
}
#declare Chujo =
sphere{
  0,5
  texture{ ChujoTex }
  translate ChujoDist*z
  rotate < 0,-147, 0>
  translate SunPos
}

//@@---Ryozen & Suzaku---
#declare Ryozen =
union{
  sphere{
    0, 20
    pigment{ RyozenPig }
  }
  union{
    disc{ 0, y, 27, 25 }
    disc{ 0, y, 35, 30 }
    disc{ 0, y, 40, 38 }
    texture{ RingTex }
  }
  rotate <-20, 0, 5>
  translate RyozenDist*z
  rotate < 0, 60,-3>
  translate SunPos
}
#declare Suzaku =
sphere{
  0, 20
  pigment{ SuzakuPig }
  translate -300*z//SuzakuDist*z
  rotate < 0, 135, 0>
  rotate <-15, 0,-20>
  translate SunPos
}

//@@---Omiya Reef---
#declare Asteroid1 = sphere{ 0,1 }
#declare Asteroid2 = sphere{ 0,1 }
#declare ReefArcA =
union{
  object{
    Asteroid1
    scale .75
    translate ReefDist*z
    rotate < 0, 1, 0>
    translate < 0, 0, .25>
  }
  object{
    Asteroid1
    scale < 1, .75, 1>
    translate ReefDist*z
    rotate < 0, 0.5, 0>
    translate < 0, .25,-.75>
  }
  object{
    Asteroid1
    scale .5
    translate ReefDist*z
    rotate < 0, 1.5, 0>
    translate < 0,-.5, .35>
  }
  object{
    Asteroid1
    scale .6
    translate ReefDist*z
    rotate < 0, 1.25, 0>
    translate < 0, 1,-.4>
  }
  object{
    Asteroid1
    scale .35
    translate ReefDist*z
    rotate < 0, 0.75, 0>
    translate <-1,-1,-.25>
  }
}
#declare ReefArcB =
union{
  object{
    Asteroid2
    scale .45
    translate ReefDist*z
    rotate < 0, 1.15, 0>
    translate < 0, .9,-.5>
  }
  object{
    Asteroid2
    scale < .75, 1, .75>
    translate ReefDist*z
    rotate < 0, 0.65, 0>
    translate < 0,-1, .25>
  }
  object{
    Asteroid2
    scale .35
    translate ReefDist*z
    rotate < 0, 1.7, 0>
    translate < 0, .35,-.25>
  }
  object{
    Asteroid2
    scale .5
    translate ReefDist*z
    rotate < 0, 1.15, 0>
    translate < 0,-.85, .75>
  }
  object{
    Asteroid2
    scale .75
    translate ReefDist*z
    rotate < 0, 0.85, 0>
    translate < 0, .35, 0>
  }
  texture{ AsteroidTexB }
}
#declare ReefArcA_1 =
union{
  object{ ReefArcA }
  object{ ReefArcA translate < 0, 1,-4> rotate < 0, .25, 0> }
  object{ ReefArcA translate < 0,-2,-4> rotate < 0,-.25, 0> }
  
  object{ ReefArcA translate < 0,-5,-6> rotate < 0, 0, 0> }
  object{ ReefArcA translate < 0,-5,-10> rotate < 0, .25, 0> }
}
#declare ReefArcB_1 =
union{
  object{ ReefArcB }
  object{ ReefArcB translate < 0, 1,-4> rotate < 0, .25, 0> }
  object{ ReefArcB translate < 0,-2,-4> rotate < 0,-.25, 0> }
  
  object{ ReefArcB translate < 0,-5,-6> rotate < 0, 0, 0> }
  object{ ReefArcB translate < 0,-5,-10> rotate < 0, .25, 0> }
}
#declare ReefArcA_15 =
union{
  object{ ReefArcA_1 rotate < 0,  0, 0> }
  object{ ReefArcA_1 rotate < 0,  1, 0> }
  object{ ReefArcA_1 rotate < 0,  2, 0> }
  object{ ReefArcA_1 rotate < 0,  3, 0> }
  object{ ReefArcA_1 rotate < 0,  4, 0> }
  object{ ReefArcA_1 rotate < 0,  5, 0> }
  object{ ReefArcA_1 rotate < 0,  6, 0> }
  object{ ReefArcA_1 rotate < 0,  7, 0> }
  object{ ReefArcA_1 rotate < 0,  8, 0> }
  object{ ReefArcA_1 rotate < 0,  9, 0> }
  object{ ReefArcA_1 rotate < 0, 10, 0> }
  object{ ReefArcA_1 rotate < 0, 11, 0> }
  object{ ReefArcA_1 rotate < 0, 12, 0> }
  object{ ReefArcA_1 rotate < 0, 13, 0> }
  object{ ReefArcA_1 rotate < 0, 14, 0> }
}
#declare ReefArcA_180 =
union{
  object{ ReefArcA_15 rotate < 0,   0, 0> }
  object{ ReefArcA_15 rotate < 0,  15, 0> }
  object{ ReefArcA_15 rotate < 0,  30, 0> }
  object{ ReefArcA_15 rotate < 0,  45, 0> }
  object{ ReefArcA_15 rotate < 0,  60, 0> }
  object{ ReefArcA_15 rotate < 0,  75, 0> }
  object{ ReefArcA_15 rotate < 0,  90, 0> }
  object{ ReefArcA_15 rotate < 0, 105, 0> }
  object{ ReefArcA_15 rotate < 0, 120, 0> }
  object{ ReefArcA_15 rotate < 0, 135, 0> }
  object{ ReefArcA_15 rotate < 0, 150, 0> }
  object{ ReefArcA_15 rotate < 0, 165, 0> }
}
#declare ReefArcB_15 =
union{
  object{ ReefArcB_1 rotate < 0,  0, 0> }
  object{ ReefArcB_1 rotate < 0,  1, 0> }
  object{ ReefArcB_1 rotate < 0,  2, 0> }
  object{ ReefArcB_1 rotate < 0,  3, 0> }
  object{ ReefArcB_1 rotate < 0,  4, 0> }
  object{ ReefArcB_1 rotate < 0,  5, 0> }
  object{ ReefArcB_1 rotate < 0,  6, 0> }
  object{ ReefArcB_1 rotate < 0,  7, 0> }
  object{ ReefArcB_1 rotate < 0,  8, 0> }
  object{ ReefArcB_1 rotate < 0,  9, 0> }
  object{ ReefArcB_1 rotate < 0, 10, 0> }
  object{ ReefArcB_1 rotate < 0, 11, 0> }
  object{ ReefArcB_1 rotate < 0, 12, 0> }
  object{ ReefArcB_1 rotate < 0, 13, 0> }
  object{ ReefArcB_1 rotate < 0, 14, 0> }
}
#declare ReefArcB_180 =
union{
  object{ ReefArcB_15 rotate < 0,   0, 0> }
  object{ ReefArcB_15 rotate < 0,  15, 0> }
  object{ ReefArcB_15 rotate < 0,  30, 0> }
  object{ ReefArcB_15 rotate < 0,  45, 0> }
  object{ ReefArcB_15 rotate < 0,  60, 0> }
  object{ ReefArcB_15 rotate < 0,  75, 0> }
  object{ ReefArcB_15 rotate < 0,  90, 0> }
  object{ ReefArcB_15 rotate < 0, 105, 0> }
  object{ ReefArcB_15 rotate < 0, 120, 0> }
  object{ ReefArcB_15 rotate < 0, 135, 0> }
  object{ ReefArcB_15 rotate < 0, 150, 0> }
  object{ ReefArcB_15 rotate < 0, 165, 0> }
}

#declare ReefA =
union{
  object{ ReefArcA_180 }
  object{ ReefArcA_180 rotate 180*y }
  rotate <-15, 0,-10>
  translate SunPos
  texture{ AsteroidTexA }
}
#declare ReefB =
union{
  object{ ReefArcB_180 }
  object{ ReefArcB_180 rotate 180*y }
  rotate <-15, 0,-10>
  translate SunPos
  texture{ AsteroidTexB }
}

//@---------Include Footer--------------------------------------------------------

  #version Murasaki_Inc_Temp;
#end

//@-------------------------------------------------------------------------------