// ************************************************************************
// TEX_HOME.INC
// ************************************************************************
//
//             Persistence of Vision Raytracer Version 3.1g
//             MBH   Revision   of  Standard   TEXTURES.INC
//     texture declares for Our_House.INC v4.0             Fall 1999
//     texture declares for Modernist_House v2.0           Fall 2001
//
//   Contents:
//   ===========================
//   Grass, Tree_Jade,
//   T_Glass1, T_Ruby_Glass, T_Green_Glass,
//   T_Stone2, Spex, Grnt20, T_MBH_Brick1, Red_Marble, Bright_AquaBlue4,
//   T_Wood2_MBH, EMBWood1, Seams_X, Seams_Y, RosewoodB, Bright_Bronze,
//   T_Copper_3D, T_Chrome_2C,
//
// *******************************************************************
// *******************************************************************

#version 3.1;

#include "finish.inc"

#ifdef(View_POV_Include_Stack)
#   debug "including tex_home.inc\n"
#end

#local Tex_Home_Inc_Temp = version;

// *******************************************************************
// *******************************************************************

#declare Grass =
texture {
   pigment {
      spotted
      color_map {
         [ 0.00  0.35  color Green        color PaleGreen   ]
         [ 0.35  0.60  color PaleGreen    color Green       ]
         [ 0.60  0.80  color Green        color SpringGreen ]
         [ 0.80  1.00  color SpringGreen  color LimeGreen   ]
                } // end color map
   turbulence 7.5
   quick_color Green
           } // end pigment
   scale < 0.75, 0.4, 0.75 >
   normal { bumps 0.4  scale 0.2 }
        } // end Grass texture

// *******************************************************************

// DEFINE A Variant of Jade for Tree Foliage:
#declare Tree_Jade =
texture {
   pigment {
      marble
      color_map {
         [ 0.0  0.2   color red 0.1  green 0.8  blue 0.1
                      color red 0.0  green 0.7  blue 0.0 ]
         [ 0.2  0.5   color red 0.1  green 0.7  blue 0.1
                      color red 0.0  green 0.5  blue 0.0 ]
         [ 0.5  0.85  color red 0.1  green 0.5  blue 0.1
                      color red 0.0  green 0.3  blue 0.0 ]
         [ 0.85 1.0   color red 0.0  green 0.4  blue 0.1  filter 0.6
                      color red 0.1  green 0.6  blue 0.1  filter 0.6 ]
                } // end color map
      turbulence 5
      frequency 3 
      quick_color Green
              }//end pigment
   finish {
      ambient 0.1
      reflection 0.0
      diffuse    0.1
          }// end finish
   normal {
      bumps 3
      scale 0.15
          }//end normal
        } // end texture Tree Jade

// *******************************************************************
// *******************************************************************
//                           GLASS Textures
// *******************************************************************

#declare I_Glass=
   interior { ior 1.5 }
  
#declare F_Glass1 =
   finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1 }   
  
#declare F_Glass3 =
finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.1
    specular 0.8
    roughness 0.003
    phong 1
    phong_size 400 }

#declare F_Glass4 =
finish {
    ambient 0.1
    diffuse 0.1
    reflection .25
    specular 1
    roughness 0.001 }

// **************************************************************

// Clear:
#declare T_Glass1 =
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.9> }
    finish  { F_Glass1 }
        }

// **************************************************************

// An excellent lead crystal glass!: dimmed-down variant:
#declare T_Glass3 =
texture {
    pigment { color rgbft < 0.18, 0.18, 0.18, 0.5, 0.5 > }
finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.5 //0.1
    specular 0.8
    roughness 0.95 //0.003
    phong 1
    phong_size 400 }


//    pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }  //orig.
//    finish { F_Glass3 }
}

// **************************************************************

// Red:
#declare T_Ruby_Glass =
texture {
    finish { F_Glass4 }
    pigment { color rgbf <0.9, 0.1, 0.2, 0.8> }
        }

// **************************************************************

// Green:
#declare T_Green_Glass =
texture {
    pigment { color rgbf <0.5, 1, 0.85, 0.8> }
    finish { F_Glass3 }
        }

//********************************************************************
//********************************************************************
//                           STONE TEXTURES
//********************************************************************

//--------- Gray  Tan with Rose
#declare T_Grnt0 =
texture {
pigment
 {granite
  turbulence 0.4
  color_map
   {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.000>
                    color rgbf <0.769, 0.686, 0.592, 0.000>]
    [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.000>
                    color rgbf <0.843, 0.753, 0.718, 0.000>]
    [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.000>
                    color rgbf <0.780, 0.667, 0.561, 0.000>]
    [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.000>
                    color rgbf <0.741, 0.659, 0.576, 0.000>]
    [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.000>
                    color rgbf <0.729, 0.502, 0.451, 0.000>] }//end map
 }//end pig
 }//end tex

// *********************************************************

//-----Translucent T_Grnt7
#declare T_Grnt7a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.439, 0.310, 0.282, 0.631>
                    color rgbf <0.463, 0.369, 0.259, 0.847>]
    [0.119, 0.322   color rgbf <0.463, 0.369, 0.259, 0.847>
                    color rgbf <0.541, 0.369, 0.298, 0.549>]
    [0.322, 0.449   color rgbf <0.541, 0.369, 0.298, 0.549>
                    color rgbf <0.573, 0.424, 0.286, 0.965>]
    [0.449, 0.729   color rgbf <0.573, 0.424, 0.286, 0.965>
                    color rgbf <0.494, 0.396, 0.306, 0.741>]
    [0.729, 1.001   color rgbf <0.494, 0.396, 0.306, 0.741>
                    color rgbf <0.439, 0.310, 0.282, 0.631>] }//end map
 }//end pig
 }//end tex

// *********************************************************

//------------- Light Greenish Tan Marble with Agate style veining
#declare T_Stone2 =
texture{T_Grnt0  scale <2, 3, 2> rotate <0, 0, 40>}
texture{T_Grnt7a scale <1.3, 2, 1.3> rotate <0, 0, -30> rotate <40, 0, 0>
        finish{phong 1.0 phong_size 90 ambient 0.2 }
}

// **************************************************************

//--------- Tan Cream & Red Rose
#declare T_Grnt12 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.969, 0.800, 0.000>
                    color rgbf <0.996, 0.682, 0.604, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.682, 0.604, 0.000>
                    color rgbf <0.906, 0.820, 0.714, 0.000>]
    [0.308, 0.444   color rgbf <0.906, 0.820, 0.714, 0.000>
                    color rgbf <0.816, 0.631, 0.537, 0.000>]
    [0.444, 0.615   color rgbf <0.816, 0.631, 0.537, 0.000>
                    color rgbf <0.890, 0.792, 0.675, 0.000>]
    [0.615, 0.812   color rgbf <0.890, 0.792, 0.675, 0.000>
                    color rgbf <0.973, 0.627, 0.627, 0.000>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.000>
                    color rgbf <0.996, 0.969, 0.800, 0.000>] }
 } }

// *********************************************************

#declare T_Grnt17a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.034   color rgbf <0.027, 0.012, 0.012, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.235>]
    [0.034, 0.342   color rgbf <0.851, 0.812, 0.741, 0.235>
                    color rgbf <0.792, 0.694, 0.690, 0.839>]
    [0.342, 0.462   color rgbf <0.792, 0.694, 0.690, 0.839>
                    color rgbf <0.631, 0.506, 0.471, 0.608>]
    [0.462, 0.632   color rgbf <0.631, 0.506, 0.471, 0.608>
                    color rgbf <0.851, 0.812, 0.741, 0.922>]
    [0.632, 0.983   color rgbf <0.851, 0.812, 0.741, 0.922>
                    color rgbf <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.282>
                    color rgbf <0.027, 0.012, 0.012, 0.000>] }
 } }

// *********************************************************

#declare T_Crack1 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color Scarlet filter 0.80 color DimGray filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0] }
 } }

// *********************************************************

//    M_House roofing:
//------------- White Cream Marble with Pink veining
#declare T_Stone5 =
texture{ T_Grnt12   scale < 2, 3,   2 >  rotate <  0, 0,  40 > }
//texture{ T_Grnt17a  scale < 2, 3,   2 >  rotate <  0, 0, -30 > }
//texture{ T_Crack1   scale < 1, 2, 1.4 >  rotate < 10, 0, -20 >
//         finish { phong 1.0  phong_size 90  ambient 0.2 } }

// **************************************************************

// Moss Greens & Tan: altered Mar 2001: make more green:
#declare T_Grnt25 =
texture {
   pigment {
      marble
      turbulence 23   //0.7...more seems better...
      color_map {
    [0.000, 0.168   color rgbf <0.714, 0.825, 0.574, 0.000>
                    color rgbf <0.504, 0.784, 0.523, 0.000>]
    [0.168, 0.301   color rgbf <0.504, 0.684, 0.523, 0.000>
                    color rgbf <0.288, 0.586, 0.308, 0.000>]
    [0.301, 0.398   color rgbf <0.288, 0.486, 0.308, 0.000>
                    color rgbf <0.253, 0.387, 0.282, 0.000>]
    [0.398, 0.558   color rgbf <0.253, 0.437, 0.282, 0.000>
                    color rgbf <0.421, 0.506, 0.451, 0.000>]
    [0.558, 0.655   color rgbf <0.421, 0.506, 0.451, 0.000>
                    color rgbf <0.519, 0.631, 0.471, 0.000>]
    [0.655, 0.735   color rgbf <0.519, 0.631, 0.471, 0.000>
                    color rgbf <0.323, 0.376, 0.320, 0.000>]
    [0.735, 0.823   color rgbf <0.323, 0.376, 0.320, 0.000>
                    color rgbf <0.288, 0.486, 0.318, 0.000>]
    [0.823, 0.876   color rgbf <0.288, 0.486, 0.318, 0.000>
                    color rgbf <0.406, 0.506, 0.318, 0.000>]
    [0.876, 0.929   color rgbf <0.506, 0.646, 0.318, 0.000>
                    color rgbf <0.606, 0.746, 0.318, 0.000>]
    [0.929, 1.001   color rgbf <0.706, 0.816, 0.318, 0.000>
                    color rgbf <0.714, 0.825, 0.584, 0.000>] }//end map
           }//end pig
       }//end tex

// *********************************************************

// Transparent Green Moss Colors: altered Mar 2001:
#declare T_Grnt23a =
texture {
pigment
 {granite
   color_map
   {[0.000, 0.168   color rgbf <0.714, 0.825, 0.574, 0.020>
                    color rgbf <0.504, 0.784, 0.523, 0.020>]
    [0.168, 0.301   color rgbf <0.504, 0.684, 0.523, 0.020>
                    color rgbf <0.288, 0.586, 0.308, 0.020>]
    [0.301, 0.398   color rgbf <0.288, 0.486, 0.308, 0.020>
                    color rgbf <0.253, 0.387, 0.282, 0.020>]
    [0.398, 0.558   color rgbf <0.253, 0.437, 0.282, 0.020>
                    color rgbf <0.421, 0.506, 0.451, 0.020>]
    [0.558, 0.655   color rgbf <0.421, 0.506, 0.451, 0.020>
                    color rgbf <0.519, 0.631, 0.471, 0.020>]
    [0.655, 0.735   color rgbf <0.519, 0.631, 0.471, 0.020>
                    color rgbf <0.323, 0.376, 0.320, 0.020>]
    [0.735, 0.823   color rgbf <0.323, 0.376, 0.320, 0.020>
                    color rgbf <0.288, 0.486, 0.318, 0.020>]
    [0.823, 0.876   color rgbf <0.288, 0.486, 0.318, 0.020>
                    color rgbf <0.406, 0.506, 0.318, 0.020>]
    [0.876, 0.929   color rgbf <0.506, 0.646, 0.318, 0.020>
                    color rgbf <0.606, 0.746, 0.318, 0.020>]
    [0.929, 1.001   color rgbf <0.706, 0.816, 0.318, 0.020>
                    color rgbf <0.714, 0.825, 0.584, 0.020>] }//end map
 }//end pig
 }//end tex

// *********************************************************

//------------- Green & Tan Moss Marble
#declare T_Stone24 =
texture{ T_Grnt25   scale < 2, 1, 6 >  }
texture{ T_Grnt23a  scale < 2, 1, 4 >  }
texture{ pigment { color Gray  filter 0.6 }  //tint to liking
         finish { phong 6.0 phong_size 150 }  }

// **************************************************************

//--------- White Marble with Gray feather Viens
#declare T_Grnt20 =
texture {
   pigment {
     granite
     turbulence 0.0
     color_map {
        [ 0.0, 0.3  color Mica   color White ]
        [ 0.3, 0.4  color White  color White ]
        [ 0.4, 0.6  color White  color White ]
        [ 0.6, 1.0  color White  color White ] }//end map
     quick_color Gray70
           }//end pigmnt
   finish { crand 0.02 }//end finish
        } //end tex

// *********************************************************

//-----Aqua Tints
#declare T_Grnt8a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.310, 0.384, 0.420, 0.631>
                    color rgbf <0.322, 0.369, 0.416, 0.847>]
    [0.119, 0.322   color rgbf <0.322, 0.369, 0.416, 0.847>
                    color rgbf <0.424, 0.369, 0.420, 0.549>]
    [0.322, 0.449   color rgbf <0.424, 0.369, 0.420, 0.549>
                    color rgbf <0.373, 0.424, 0.518, 0.965>]
    [0.449, 0.729   color rgbf <0.373, 0.424, 0.518, 0.965>
                    color rgbf <0.482, 0.573, 0.533, 0.741>]
    [0.729, 1.001   color rgbf <0.482, 0.573, 0.533, 0.741>
                    color rgbf <0.310, 0.384, 0.420, 0.631>] }
     quick_color Gray70 } }

// *********************************************************

//------------- Deep Gray Marble with white veining
#declare T_Stone15 =
texture{T_Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03} }
texture{T_Grnt8a scale <1, 2, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90} }

// **************************************************************

#declare Spex=                         // By Dan Farmer
texture {
    pigment {
        granite
        color_map {
            [ 0.0 0.7  color Black   color Black  ]
            [ 0.7 1.0  color Orange  color Orange ] }//end map
        turbulence 2
        quick_color Orange
            }//end pigment
    finish {
        phong 0.5
        phong_size 0.75
        ambient 0.3
        diffuse 0.7
            }//end finish
        } // end texture

// **************************************************************
//                              Bricks
// **************************************************************

//    DEFINE  variation of Ib Rassmensen's brick texture (c)Nov 99
#declare BHeight =  10;
#declare BWidth  =  15;

#declare T_MBH_MortarColor_1 = 
texture {
   pigment { Gray80 }                  // end pigment
   finish { ambient 0.3 diffuse 0.4 }  // end finish
        } // end mortar texture 1

#declare C_MBH_Brick_Color=
color rgbf <0.70, 0.22, 0.24, 0.0>;

#declare T_MBH_BrickColor_1 = 
texture {
   pigment { C_MBH_Brick_Color }       // end pigment
   finish { ambient 0.3 diffuse 0.4 }  // end finish
        } // end brick texture 1

#declare T_MBH_Brick_1 = 
texture {
   brick texture { T_MBH_MortarColor_1 }, texture { T_MBH_BrickColor_1 }
   brick_size < BWidth, BHeight, BWidth/2 >
   mortar 0.75
        } // end MBH Brick texture

// **************************************************************

//    DEFINE  Red Marble from TEXTURES.INC:
// Classic white marble with red veins.
#declare Red_Marble_Map = 
color_map {
    [0.0 rgb <0.8, 0.8, 0.6>]
    [0.8 rgb <0.8, 0.4, 0.4>]
    [1.0 rgb <0.8, 0.2, 0.2>]
}

#declare Red_Marble = 
pigment {
    marble
    color_map { Red_Marble_Map }
    turbulence 1
}

// *******************************************************************
// *******************************************************************
//                           SKY PIGMENTS
// *******************************************************************

#declare Bright_AquaBlue4 =            //AQUA09 version
pigment {
   bozo
   turbulence  0.75
   octaves 5
   lambda 9
   color_map {
      [ 0.0  0.2  color rgbt < 0.4392, 0.7008, 0.7606, 0.0 >
                  color rgbt < 0.4,    0.6,    0.8,    0.0 > ]
      [ 0.2  0.5  color rgbt < 0.4     0.6     0.8,    0.0 >
                  color rgbt < 0.5,    0.5,    0.9,    0.0 > ]
      [ 0.5  0.7  color rgbt < 0.5,    0.5,    1.0,    0.0 >
                  color rgbt < 1.0,    1.0,    1.0,    0.0 > ]
      [ 0.7  1.0  color rgbt < 1.0,    1.0,    1.0,    0.0 >
                  color rgbt < 0.5,    0.5,    0.5,    0.0 > ] } //end map
        } // end pigment

// *******************************************************************
// *******************************************************************
//                            Wood Textures
// *******************************************************************

#declare P_WoodGrain2A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.15, .15, 1>
}

#declare P_WoodGrain2B =
pigment {
    wood  
    turbulence <0.1, 0.35, 0.1>
    octaves 5
    lambda 3.25
    scale <0.25, .25, 1>
    rotate <5, 10, 5>
    translate -x*2
}

// *********************************************************

#declare M_Wood2A = 
color_map { 
    [0.0, 0.1 color rgb <0.35, 0.16, 0.12 >* 0.5
              color rgb <0.35, 0.16, 0.12>* 0.5]
    [0.1, 0.9 color rgb <0.35, 0.20, 0.16>* 0.5
              color rgb <0.46, 0.26, 0.18>* 0.5]
    [0.9, 1.0 color rgb <0.46, 0.26, 0.18>* 0.5
              color rgb <0.35, 0.16, 0.12>* 0.5]
}
#declare M_Wood2B = 
color_map { 
    [0.0, 0.1 color rgbf <0.50, 0.30, 0.20, 0.100> 
              color rgbf <0.50, 0.30, 0.20, 0.500>]
    [0.1, 0.9 color rgbf <0.50, 0.30, 0.20, 0.650>
              color rgbf <0.50, 0.25, 0.15, 0.975>]
    [0.9, 1.0 color rgbf <0.50, 0.25, 0.15, 0.975>
              color rgbf <0.50, 0.30, 0.20, 0.000>]
}

// *********************************************************

// Dark brown
#declare T_Wood2   =
    texture { pigment { P_WoodGrain2A  color_map { M_Wood2A }}}
    texture { pigment { P_WoodGrain2B  color_map { M_Wood2B }}}

// **************************************************************

//   DEFINE  variant for deco trim panels:
#declare T_Wood2_MBH =
texture { T_Wood2
          scale < 1, 1, 2 >
          rotate y*90 rotate x*80 
          finish {
             ambient 0.3 diffuse 0.5
             specular 0.5
             roughness 0.00075
             reflection 0.05
                  }//end finish
       } // end my t_wood 2


// **************************************************************

#declare P_WoodGrain3A = 
pigment {
    wood  
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
    rotate <2,2,0>
}

#declare P_WoodGrain3B =
pigment {
    wood  
    turbulence <0.1, 0.5, 1> 
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2
}

// **************************************************************

#declare M_Wood3A =
color_map {
    [0.0, 0.1 color rgb <0.75, 0.65, 0.45>
              color rgb <0.75, 0.65, 0.45>]
    [0.1, 0.9 color rgb <0.75, 0.65, 0.45>
              color rgb <0.70, 0.55, 0.40>]
    [0.9, 1.0 color rgb <0.70, 0.55, 0.40>
              color rgb <0.75, 0.65, 0.45>]
}
#declare M_Wood3B =
color_map {
    [0.0, 0.1 color rgbf <0.70, 0.60, 0.40, 0.100>
              color rgbf <0.70, 0.60, 0.40, 0.500>]
    [0.1, 0.9 color rgbf <0.70, 0.60, 0.40, 0.650>
              color rgbf <0.75, 0.70, 0.60, 0.975>]
    [0.9, 1.0 color rgbf <0.75, 0.70, 0.60, 0.975>
              color rgbf <0.70, 0.60, 0.40, 1.000>]
}

// **************************************************************

// Bleached oak (white)
#declare T_Wood3   =         
    texture { pigment { P_WoodGrain3A  color_map { M_Wood3A }}} 
    texture { pigment { P_WoodGrain3B  color_map { M_Wood3B }}}

// *******************************************************************

#declare EMBWood1 =                    // front doors
texture {                              // Bottom layer
    pigment {
        wood
        turbulence 0.5       // 0.05
        color_map {
            [0.00 0.34  color rgb <0.58, 0.45, 0.23>
                        color rgb <0.65, 0.45, 0.25>]
            [0.34 0.40  color rgb <0.65, 0.45, 0.25>
                        color rgb <0.33, 0.23, 0.13>]
            [0.40 0.47  color rgb <0.33, 0.23, 0.13>
                        color rgb <0.60, 0.40, 0.20>]
            [0.47 1.00  color rgb <0.60, 0.40, 0.20>
                        color rgb <0.25, 0.15, 0.05>]
                  }//end map
        quick_color Yellow
            }//end pigment
    finish {
        crand 0.02
        ambient 0.32
        diffuse 0.63
        phong 0.2
        phong_size 10
           }//end finish
    normal { bumps 0.05 }
}
texture {                              // top layer, adds small dark spots
    pigment {
        bozo
        color_map {
            [ 0.0 0.8  color rgbf < 1.00, 1.00, 1.00, 1.00 >
                       color rgbf < 1.00, 0.90, 0.80, 0.80 > ]
            [ 0.8 1.0  color rgbf < 1.00, 0.90, 0.80, 0.80 >
                       color rgbf < 0.30, 0.20, 0.10, 0.40 > ]
                  }//end map
    scale 0.25
    quick_color Yellow
            }//end pigment
        } // end texture 2nd layer

// *******************************************************************
/*
//   DEFINE   to simulate the seams between wooden boards
#declare Seams_Y =
texture {
   pigment {
      gradient y
      color_map {
         [ 0.0 0.1  color Black  color Black ]
         [ 0.1 1.0  color Clear  color Clear ]
                } //end map
           } //end pigmnet
        } // end Seams Y-axis

#declare Seams_X =
texture {
   pigment {
      gradient x
      color_map {
         [ 0.0 0.1  color Black  color Black ]
         [ 0.1 1.0  color Clear  color Clear ]
                } //end map
           } //end pigmnet
        } // end Seams X-axis
*/
// **************************************************************

//   DEFINE RosewoodB   floor texture:
#declare RosewoodB =
texture {
   pigment {
      bozo
      turbulence  3 //0.4
      color_map {     // r: +0.26   g:+0.012   b:-0.05
      [0.000, 0.256   color rgbf <0.406, 0.122, 0.028, 0.000>
                      color rgbf <0.433, 0.137, 0.030, 0.000>]
      [0.256, 0.303   color rgbf <0.433, 0.137, 0.030, 0.000>
                      color rgbf <0.436, 0.147, 0.039, 0.000>]
      [0.303, 0.393   color rgbf <0.436, 0.137, 0.030, 0.000>
                      color rgbf <0.445, 0.147, 0.039, 0.000>]
      [0.393, 0.581   color rgbf <0.445, 0.147, 0.039, 0.000>
                      color rgbf <0.447, 0.147, 0.025, 0.000>]
      [0.581, 0.826   color rgbf <0.447, 0.147, 0.025, 0.000>
                      color rgbf <0.462, 0.146, 0.032, 0.000>]
      [0.826, 0.983   color rgbf <0.462, 0.146, 0.032, 0.000>
                      color rgbf <0.433, 0.138, 0.136, 0.000>]
      [0.983, 1.000   color rgbf <0.433, 0.138, 0.136, 0.000>
                      color rgbf <0.406, 0.122, 0.028, 0.000>] } //end map
      scale < 6,2,10> //< 0.05, 0.05, 1 >
      quick_color DarkGreen
           } //end pigment
   finish {
      ambient 0.2
      diffuse 0.2
      reflection 0.2 } //end finish
        } // end texture layer 1
// Rosewood layer 2
texture {
   pigment {
      wood
      turbulence 0.4
      color_map {
         [ 0.000, 0.139  color rgbf < 0.565, 0.349, 0.247, 1.000 >
                         color rgbf < 0.565, 0.349, 0.247, 1.000 > ]
         [ 0.139, 0.148  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.148, 0.287  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.565, 0.349, 0.247, 1.000 > ]
         [ 0.287, 0.443  color rgbf < 0.565, 0.349, 0.247, 1.000 >
                         color rgbf < 0.565, 0.349, 0.247, 1.000 > ]
         [ 0.443, 0.626  color rgbf < 0.565, 0.349, 0.247, 1.000 >
                         color rgbf < 0.400, 0.300, 0.200, 0.040 > ]
         [ 0.626, 0.635  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.635, 0.843  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.565, 0.349, 0.247, 1.000 > ]
         [ 0.843, 1      color rgbf < 0.565, 0.349, 0.247, 1.000 >
                         color rgbf < 0.565, 0.349, 0.247, 1.000 > ] }
      scale < 0.15, 0.05, 1 >
      rotate z*-1.1
      quick_color DarkBrown
           } //end pigment
        } // end texture layer 2

// *******************************************************************
//                           METAL FINISHES
// *******************************************************************

#declare P_Copper3   = color rgb <0.60, 0.30, 0.15>;
#declare P_Chrome2   = color rgb <0.39, 0.41, 0.43>;

#declare Metallic_Finish =
finish {
   metallic
   ambient 0.1
   diffuse 0.65
   specular 0.85
   roughness 0.01
   reflection 0.45
   brilliance 1.5
       } //end finish

#declare F_MetalC  =
finish {
    ambient 0.25
    brilliance 3   //orig=4
    diffuse 0.3    //     0.5
    metallic
    specular 0.50   //0.80
    roughness 1/80
    reflection 0.15     //orig=0.5
}

#declare F_MetalD  =
finish {
    ambient 0.15
    brilliance 2  //5
    diffuse 0.3   //0.6
    metallic
    specular 0.50  //0.80
    roughness 2.0  //1/100
    reflection 0.15     //0.65
}

#declare T_Copper_3D = 
   texture { pigment { P_Copper3 } finish { F_MetalD  } }

#declare T_Chrome_2C = 
   texture { pigment { P_Chrome2 } finish { F_MetalC  } }

// *******************************************************************
//                           METAL TEXTURES
// *******************************************************************

#declare Bright_Bronze  = 
texture {
    pigment { rgb <0.36, 0.28, 0.20> }
    finish { Metallic_Finish }
        } // end brite bronze

// *******************************************************************

// *******************************************************************
// *******************************************************************

#version Tex_Home_Inc_Temp;

// ************************************************************************
// Michael Brendan Hurley    ShadowDancer, LTD.     Fall 2000 - Spring 2001
// ************************************************************************
