///////////////////////////////////////////////////////////////////////////
//
// RoundBox.inc for POV Version 3.0 and above
//
//  Author: Philip Cowley (philip.cowley@totem.co.uk)
//  Date:   13/07/97
//
// It may be freely altered and distributed, but must be provided free of cost.
//
///////////////////////////////////////////////////////////////////////////
//
// Example of how to use this inc file
//
// #declare RB_P1 = <20, 20, 20>
// #declare RB_P2 = <-20, -20, -20>
// #declare RB_Thickness = 1        //Assumes 1 if not defined
// #declare RB_Solid = 0          //Assumes "On" if not defined
//
// difference
// {
//   union                          //This union allows the use of scale etc.
//   {
//     #include "roundbox.inc"
//     scale 1
//   }
//   sphere
//   {
//     <30, 30, -30>
//     50
//   }
// }
//
///////////////////////////////////////////////////////////////////////////

#ifndef (RB_Solid)
  #declare RB_Solid = 1
#end

#ifndef (RB_Thickness)
  #declare RB_Thickness = 1;
#end

#ifdef (RB_P1)
  #ifdef (RB_P2)

    #declare x1 = RB_P1.x;
    #declare y1 = RB_P1.y;
    #declare z1 = RB_P1.z;

    #declare x2 = RB_P2.x;
    #declare y2 = RB_P2.y;
    #declare z2 = RB_P2.z;

    #if (x1 > x2)
      #declare temp = x1;
      #declare x1 = x2;
      #declare x2 = temp;
    #end
    #if (y1 > y2)
      #declare temp = y1;
      #declare y1 = y2;
      #declare y2 = temp;
    #end
    #if (z1 > z2)
      #declare temp = z1;
      #declare z1 = z2;
      #declare z2 = temp;
    #end

    #declare x1c = x1 + (RB_Thickness/2);
    #declare x2c = x2 - (RB_Thickness/2);
    #declare y1c = y1 + (RB_Thickness/2);
    #declare y2c = y2 - (RB_Thickness/2);
    #declare z1c = z1 + (RB_Thickness/2);
    #declare z2c = z2 - (RB_Thickness/2);

  union
  {
    sphere
    {
      <x1c, y1c, z1c>
      RB_Thickness/2
    }
    sphere
    {
      <x2c, y1c, z1c>
      RB_Thickness/2
    }
    sphere
    {
      <x1c, y2c, z1c>
      RB_Thickness/2
    }
    sphere
    {
      <x2c, y2c, z1c>
      RB_Thickness/2
    }
    sphere
    {
      <x1c, y1c, z2c>
      RB_Thickness/2
    }
    sphere
    {
      <x2c, y1c, z2c>
      RB_Thickness/2
    }
    sphere
    {
      <x1c, y2c, z2c>
      RB_Thickness/2
    }
    sphere
    {
      <x2c, y2c, z2c>
      RB_Thickness/2
    }
    
    cylinder
    {
      <x1c, y1c, z1c>
      <x1c, y1c, z2c>
      RB_Thickness/2
    }
    cylinder
    {
      <x2c, y1c, z1c>
      <x2c, y1c, z2c>
      RB_Thickness/2
    }
    cylinder
    {
      <x1c, y2c, z1c>
      <x1c, y2c, z2c>
      RB_Thickness/2
    }
    cylinder
    {
      <x2c, y2c, z1c>
      <x2c, y2c, z2c>
      RB_Thickness/2
    }
    
    cylinder
    {
      <x1c, y1c, z1c>
      <x1c, y2c, z1c>
      RB_Thickness/2
    }
    cylinder
    {
      <x1c, y2c, z1c>
      <x2c, y2c, z1c>
      RB_Thickness/2
    }
    cylinder
    {
      <x2c, y2c, z1c>
      <x2c, y1c, z1c>
      RB_Thickness/2
    }
    cylinder
    {
      <x2c, y1c, z1c>
      <x1c, y1c, z1c>
      RB_Thickness/2
    }
    
    cylinder
    {
      <x1c, y1c, z2c>
      <x1c, y2c, z2c>
      RB_Thickness/2
    }
    cylinder
    {
      <x1c, y2c, z2c>
      <x2c, y2c, z2c>
      RB_Thickness/2
    }
    cylinder
    {
      <x2c, y2c, z2c>
      <x2c, y1c, z2c>
      RB_Thickness/2
    }
    cylinder
    {
      <x2c, y1c, z2c>
      <x1c, y1c, z2c>
      RB_Thickness/2
    }

#if (RB_Solid > 0)
    box
    {
      <x1, y1c, z1c>
      <x2, y2c, z2c>
    }
    box
    {
      <x1c, y1, z1c>
      <x2c, y2, z2c>
    }
    box
    {
      <x1c, y1c, z1>
      <x2c, y2c, z2>
    }
#else
    box
    {
      <x1, y1c, z1c>
      <x1c + RB_Thickness/2, y2c, z2c>
    }
    box
    {
      <x1c, y1, z1c>
      <x2c, y1c + RB_Thickness/2, z2c>
    }
    box
    {
      <x1c, y1c, z1>
      <x2c, y2c, z1c + RB_Thickness/2>
    }
    box
    {
      <x2c - RB_Thickness/2, y1c, z1c>
      <x2, y2c, z2c>
    }
    box
    {
      <x1c, y2c - RB_Thickness/2, z1c>
      <x2c, y2, z2c>
    }
    box
    {
      <x1c, y1c, z2c - RB_Thickness/2>
      <x2c, y2c, z2>
    }
#end
  }
     
  #end
#end

// ///////////////////////////////////////////////////////////////////
