// ************************************************************************
// KITCHN07.POV                                                    Oct 2001
// Development of Kitchen for M_House: table and chairs:
// ************************************************************************

// ************************************************************************
// I.    DEFINE Includes, Constants and Conditionals:
// ************************************************************************

#version 3.1; 

#include "brendan.inc"                 // universal scene objects
                                       // and calls to support INC's

#declare ShowDetails = 1;    // 0=some, 1=full 
#declare GridOn      = 0;    // 0=hide, 1=show
#declare ShowLights  = 1;    // 0=off,  1=on
#declare DayLight    = 0;    // 0=no,   1=yes
#declare ShowFloor   = 1;    // 0=hide, 1=show
#declare ShowGlass   = 1;    // 0=hide, 1=show

// *******************************************************************

global_settings { assumed_gamma 1.0 
                  max_trace_level 6 }

// *******************************************************************
// Lights!
// *******************************************************************

#if ( DayLight = 0 )
   background { color Black }             // nite
#else
   background { color LightBlue }         // day
   #declare LightLocate = < 80, 100, 150 >;
   #declare intensity = 1;
   #if ( ShowDetails = 0 )
      light_source { LightLocate  color White }
   #else
      light_source { LightLocate  color White }
   #end
#end

// *******************************************************************
// CAMERA!
// *******************************************************************

#declare Camera_BeautyShot =
camera {
   direction < 0, 0, 3 >
   location  < -7, 8,  60 >              // north of west room
   look_at   < -18, 5, -30 > }

#declare Camera_North =
camera {
   direction < 0, 0, 3 >
   location  < 10, 8,  70 >              // north of west room
   look_at   <  0, 5, -30 > }

#declare Camera_West =
camera {
   direction <    0, 0, 3 >
   location  < -110, 6, 0 >          // west
   look_at   <    0, 6, 0 > }

#declare Camera_South =
camera {
   direction < 0, 0, 2 >
   location  < 0, 0, -30 >          // south of cntr
   look_at   < 0, 0, 0 > }

#declare Camera_SW =
camera {
   direction < 0, 0, 2 >
   location  < -70, 50, -70 >          // SW of center
   look_at   < 0, 0, 0 > }             //

#declare Camera_SE =
camera {
   direction < 0, 0, 2 >
   location  < 90, 7, -50 >         // SE of center
   look_at   <  5, 0, -30 > }

#declare Camera_Above =
camera {         
   direction < 0,   0, 6 >
   location  < 0, 200, 0 >             // Above: dir 2, +200y
   look_at   < 0,   0, 0 > }           //  shows 150x 100z area

#declare Camera_Quarter =
camera { 
   direction < 0, 0, 2 >
   location  < 60, 60, -60 >           // SE and above 
   look_at   < 0, 0, 0 > }             // center of scene

// *******************************************************************
// *******************************************************************

#declare MoveX = -40;
#declare MoveY = 0;
#declare MoveZ = 0; //-30;

//camera { Camera_BeautyShot   translate < MoveX, MoveY, MoveZ > }
camera { Camera_North   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_West    translate < MoveX, MoveY, MoveZ > }
//camera { Camera_South   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_SW      translate < MoveX, MoveY, MoveZ > }
//camera { Camera_SE      translate < MoveX, MoveY, MoveZ > }
//camera { Camera_Above   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_Quarter translate < MoveX, MoveY, MoveZ > }


// ************************************************************************
// II.   DEFINE the scene:
// ************************************************************************

//    DEFINE  generic scalable building block: 1x 1y 1z:
#declare Build_Block_1 =
box { <-0.5, -0.5, -0.5>  < 0.5, 0.5, 0.5 > } // end bldg block 1

// **************************************************************

//   DEFINE   a 1-unit square window glass pane:
#declare Pane_Square_2 =
object { UnitBox
         scale < 0.5, 0.5, 0.01 >
         #if ( ShowDetails = 0 )
            texture { Black_Tex }
         #else
            texture { T_Glass1 }
         #end
       } // end square glass pane

// **************************************************************

// **************************************************************
//       D.  West Room: 
// **************************************************************

//    DEFINE  West room roof:
#declare West_Roof =
object {
   #declare RB_P1 = <  20,  1.05,  20 >;  // right upper rear corner
   #declare RB_P2 = < -20, -1.05, -20 >;  // left lower front corner
   #include "roundbox.inc"
   #if ( ShowDetails = 0 )
      texture { Green_Tex }
   #else
      texture { T_Stone24 }
   #end
      } // end west roof

// **************************************************************

//    DEFINE  West room: north wall frames:
#declare W_North_Frame =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate < -18, 0, 0 > }//w
   object { CubeY1
            scale < 1, 10, 1 >  translate <  18, 0, 0 > }//e
   object { CubeX1
            scale < 34, 1, 1 >  translate < 0,  5, 0 > }//top
   object { CubeX1
            scale < 34, 1, 1 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end west room north frames

// **************************************************************

//    DEFINE  West room: north panel:
#declare W_North_Panel =
union {
   //solid panel w/ window hole:
   difference {
      object {
         #declare RB_P1 = < 11.5,  5.5,  1.1 >; // right upper rear corner
         #declare RB_P2 = < -8.5, -6.5, -1.1 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  8,  2.5,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -2, -2.5, -2.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 }
      #end
              }//end difference
   //glass in windows:
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               scale < 8, 9, 0.05 >
               translate < 5, 0, 0 > 
             }//center window
      object { Pane_Square_2
               scale < 5, 10, 0.05 >
               translate < -21, 0, 0 > 
             }//far west window
   #end // show windows?
      } // end west room north panels

// **************************************************************

//    DEFINE  West room: south wall frames:
#declare W_South_Frame =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate <  -17, 0, 0 > }//w
   object { CubeY1
            scale < 1, 10, 1 >  translate < -8.5, 0, 0 > }
   object { CubeY1   
            scale < 1, 10, 1 >  translate <  8.5, 0, 0 > }
   object { CubeY1
            scale < 1, 10, 1 >  translate <   17, 0, 0 > }//e
   object { CubeX1
            scale < 34, 1, 1 >  translate < 0,  5, 0 > }//top
   object { CubeX1
            scale < 34, 1, 1 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end west room south frames

// **************************************************************

//    DEFINE  West room: south panel:
#declare W_South_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  18.5,  5.5,  1.1 >;  // right upper rear corner
         #declare RB_P2 = < -18.5, -6.5, -1.1 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  15, 0.65,  2.5 >; // right upper rear corner
         #declare RB_P2 = <   1, -1.5, -2.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 }
      #end
              }//end difference
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               scale < 20, 7.2, 0.05 >
               translate < 0, 1, 0 > 
             }//center window
   #end                  
      } // end west room south panels

// **************************************************************

//    DEFINE  West room: west wall frames:
#declare W_West_Frame =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,  15 > }//n
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,   7 > }
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,  -7 > }
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0, -15 > }//s
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0,  5, 0 > }//top
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 2, 4 > }
   #end
      } // end west room west frames

// **************************************************************

//    DEFINE  West room: west wall panels:
#declare W_West_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  5.5,  16 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -6.5, -16 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  2.5,  -3 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -2.5, -12 >; // left lower front corner
         #include "roundbox.inc"
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 }
      #end
              }//end difference 
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 10, 25 > }
   #end
      } // end west wall window panels

// **************************************************************

//    DEFINE  West room: east wall frames:
#declare W_East_Frame =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,  15 > }//rear
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,   3 > }//middle
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0, -6 > }//middle
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0, -15 > }//front
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0,  5, 0 > }//top
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 2, 4 > }
   #end
      } // end west room east frames

// **************************************************************

//    DEFINE  West room: east wall panels:
#declare W_East_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  5.5,   7.5 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -6.5, -10.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  2.5,  6.0 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -1.5, -6.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 }
      #end
              }//end difference 
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 10, 13 > }
   #end
      } // end east wall window panel

// **************************************************************
// **************************************************************
//    Lamps:
// **************************************************************

//   DEFINE  an object for a light source
#declare Flat_Light =
object {
   box { < -0.5, -0.1, -0.5 > < 0.5, 0.1, 0.5 >
         #if ( ShowDetails = 0 )
            texture { White_Tex }
         #else
            texture { White_Tex }
         #end
         hollow
       } // end box of glass
       } // end obj flat light

// **************************************************************

//   DEFINE  a light fixture, for stove:
#declare Lamp_A =
light_source {
   < 0, 0, 0 >
   color White
   looks_like { Flat_Light }
   fade_distance 5
   fade_power 2
             } // end light source  

// **************************************************************

//   DEFINE  a light fixture, for rooms:
#declare Lamp_B =
light_source {
   < 0, 0, 0 >
   color White
   looks_like { Flat_Light }
   fade_distance 9
   fade_power 2
             } // end light source  

// **************************************************************
// **************************************************************

//    DEFINE  a stove:
#declare Stove_1 =
union {
   //hood:
   intersection {
      box { < 5.85, 9.00,  1.00 > < -5.85,  6.00, -1.75 > } 
      plane { y, 1
              scale < 5, 5, 0.25 >
              rotate x*45
              translate y*0.3
            }//end plane
      #if ( ShowDetails = 0 )
         texture { Green_Tex }
      #else
         texture { T_Copper_3D }
      #end 
                }// end intersected  box

   //body:
   box { < 5.85, 1.75,  1.75 > < -5.85, -1.75, -1.75 >
         #if ( ShowDetails = 0 )
            texture { FireBrick_Tex }
         #else
            texture { T_Chrome_2C }
         #end }

   //vent stack:
   box { < 1.55, 11.5, -1.00 > < -1.55,  1.00, -1.55 >
         #if ( ShowDetails = 0 )
            texture { Blue_Tex }
         #else
            texture { T_Copper_3D }
         #end }

   //oven doors:
   box { < 1.00, 1.00,  0.05 > < -1.00, -1.00, -0.05 > 
         translate < -4, 0.2, 1.75 >
         texture { Black_Tex } }
   box { < 1.00, 1.00,  0.05 > < -1.00, -1.00, -0.05 > 
         translate < -1, 0.2, 1.75 >
         texture { Black_Tex } }

   //back panel:
   box { < 5.85, 7.00, -1.60 > < -5.85,  1.50, -1.70 >
         #if ( ShowDetails = 0 )
            texture { Yellow_Tex }
         #else
            texture { T_Chrome_2C }
         #end }
#if (ShowDetails = 1 )
   //utility drawers:
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50,  1.0, 1.76 >
         texture { Black_Tex } }
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50,  0.5, 1.76 >
         texture { Black_Tex } }
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50, -0.0, 1.76 >
         texture { Black_Tex } }
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50, -0.5, 1.76 >
         texture { Black_Tex } }

   //burners:
   disc { < 0, 0, 0 >  z, 0.5, 0.0
          rotate x*90
          translate < 1, 1.75, -0.3 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.5, 0.0
          rotate x*90
          translate < 1, 1.75,  1.0 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -1.5, 1.75, -0.3 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -0.25, 1.75, -0.3 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -1.5, 1.75, 1 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -0.25, 1.75, 1 > 
          texture { Black_Tex } }

   //grills:
   box { < 1.4, 0.1, 1.4 > < -1.4, -0.1, -1.4 >
         translate < -4, 1.67, 0.2 >
         texture {Black_Tex} }
   box { < 1.1, 0.1, 1.4 > < -1.1, -0.1, -1.4 >
         translate <  4, 1.67, 0.2 >
         texture {Black_Tex} }
#end

   #if ( ShowLights = 1 )
   //hood lights:
   object { Lamp_A  translate <  4, 5.9, 0 > }
   object { Lamp_A  translate < -4, 5.9, 0 > }
   #end

      } // end stove

// **************************************************************
// **************************************************************

//    DEFINE  a table: 10x 0.5y 4.5z
#declare Table_1 =
union {
   //top:
   object {
      box { < 5, 0.20, 2.25 > < -5, -0.20, -2.25 > }
            #if ( ShowDetails = 0 )
               texture { Orchid_Tex }
            #else
               texture { T_Wood3 
                         scale < 3, 1, 2 >
                         rotate y*90 rotate x*8
                         finish { specular 0.3 
                                  roughness 1.0
                                  reflection 0.15 }
                       }//end tex
            #end 
          }//end table top

   //legs:
   union {                             
      object {
         box { < 0.20, 1.75, 0.20 > < -0.20, -1.75, -0.20 > }
               translate <  2.5, -1.75, -1.5 > }//right front
      object {
         box { < 0.20, 1.75, 0.20 > < -0.20, -1.75, -0.20 > }
               translate <  2.5, -1.75,  1.5 > }//right rear
      object {
         box { < 0.20, 1.75, 0.20 > < -0.20, -1.75, -0.20 > }
               translate < -2.5, -1.75, -1.5 > }//left front
      object {
         box { < 0.20, 1.75, 0.20 > < -0.20, -1.75, -0.20 > }
               translate < -2.5, -1.75,  1.5 > }//left rear
      #if ( ShowDetails = 0 )
         texture { Blue_Tex }
      #else
         texture { T_Wood3 
                   scale < 1, 3, 2 >
                   rotate y*90 rotate x*8
                   finish { specular 0.3 
                            roughness 1.0
                            reflection 0.15 }
                 }//end tex
      #end 
         }// end union legs
   union {
      object { 
         box { < 2.50, 0.20, 0.20 > < -2.50, -0.20, -0.20 > }
               translate <  0.0, -3.35, 0.0 > }//center bottom foot
      object {
         box { < 2.50, 0.20, 0.20 > < -2.50, -0.20, -0.20 > }
               translate <  0.0, -0.45, 0.0 > }//center top foot
      object { 
         box { < 0.20, 0.20, 1.70 > < -0.20, -0.20, -1.70 > }
               translate <  2.5, -3.35, 0.0 > }//right foot
      object { 
         box { < 0.20, 0.20, 1.70 > < -0.20, -0.20, -1.70 > }
               translate < -2.5, -3.35, 0.0 > }//left foot
      object { 
         box { < 0.20, 0.20, 1.70 > < -0.20, -0.20, -1.70 > }
               translate <  2.5, -0.45, 0.0 > }//right foot
      object { 
         box { < 0.20, 0.20, 1.70 > < -0.20, -0.20, -1.70 > }
               translate < -2.5, -0.45, 0.0 > }//left foot
      #if ( ShowDetails = 0 )
         texture { Blue_Tex }
      #else
         texture { T_Wood3 
                   scale < 2, 1, 3 >
                   rotate y*90 rotate x*8
                   finish { specular 0.3 
                            roughness 1.0
                            reflection 0.15 }
                 }//end tex
      #end 
         }// end union feet
     } // end union table

// **************************************************************
// **************************************************************

//    DEFINE  a hanging cabinet: 18x 4y 3z:
#declare Cabinet_1 =
object {
   box { < 9.0, 2.0, 1.5 > < -9.0, -2.0, -1.0 > }
         #if ( ShowDetails = 0 )
            texture { Blue_Tex }
         #else
            texture { T_Wood2 scale < 1, 3, 1 > }
         #end
       } // end cabinet 1

// **************************************************************
// **************************************************************

//    DEFINE  a counter: 12x 3y 3z:
#declare Counter_1 =
object {
   box { < 6.0, 1.5, 1.5 > < -6.0, -1.5, -1.5 > }
   texture { Coral_Tex }
       } // end counter 1

// **************************************************************

//    DEFINE  a counter: 3x 3.5y 12z:
#declare Counter_2 =
union {
   box { < 1.6, 1.74, 6.0 > < -1.6, -1.75, -6.0 >
         #if ( ShowDetails = 0 )
            texture { Orchid_Tex }
         #else
            texture { T_Wood2 scale < 1, 1, 5 > }
         #end }
   box { < 1.7, 1.75, 6.0 > < -1.7, 1.70, -6.0 >
         #if ( ShowDetails = 0 )
            texture { Black_Tex }
         #else
            texture { Spex }
         #end }
      } // end counter 2

// **************************************************************

//    DEFINE  a cylinder counter: 5x 3.5y 4.5z:
#declare Counter_3 =
union {
   object {
      cylinder { 1.74*y, -1.75*y, 2.20 }
         #if ( ShowDetails = 0 )
            texture { Violet_Tex }
         #else
            texture { T_Wood2 scale < 1, 5, 1 > }
         #end
          }//body
   object { 
      cylinder { 1.75*y, 1.70*y, 2.30 }
         #if ( ShowDetails = 0 )
            texture { Black_Tex }
         #else
            texture { Spex }
         #end
          }//top
      } // end union cyl counter 3

// **************************************************************

//    DEFINE  a counter: 12x 3.5y 12z:
#declare Counter_4 =
union {
   box { < 8.0, 1.74, 1.5 > < -8.0, -1.75, -1.5 >
         #if ( ShowDetails = 0 )
            texture { Yellow_Tex }
         #else
            texture { T_Wood2 scale < 1, 1, 5 > }
         #end }//body
   box { < 8.0, 1.75, 1.6 > < -8.0, 1.70, -1.6 >
         #if ( ShowDetails = 0 )
            texture { Black_Tex }
         #else
            texture { Spex }
         #end }//top
      } // end counter 4

// **************************************************************
// **************************************************************

//    DEFINE  a sink: 3x 3.5y 12z:
#declare Sink_1 =
union {
   box { < 1.6, 1.75, 6.0 > < -1.6, -1.75, -6.0 >
         #if ( ShowDetails = 0 )
            texture { White_Tex }
         #else
            texture { T_Wood2 scale < 1, 1, 5 > }
         #end }//end box
   //over sink:
   object { Lamp_A  translate < 0, 8, 0 > }//end lamp
      } // end union sink

// **************************************************************
// **************************************************************

//    DEFINE a refrigerator:
#declare Frig_1 =
object {
   box { < 1.5, 3.5, 2.7 > < -1.5, -3.5, -2.7 > }
   texture { Blue_Tex }
       } // end frig

// **************************************************************
// **************************************************************

//    DEFINE  generic kitchen:
#declare W_Kitchen =
union {
   object { Table_1    translate <   0.0, 3.50,   7.0 > }
   object { Cabinet_1  translate <   7.5, 8.00, -13.0 > }//top south
   //prep area:
   object { Stove_1    translate <  -7.5, 1.75, -12.5 > }//sw corner
   object { Sink_1     translate < -15.0, 1.75,  -8.0 > }//west side
   object { Counter_2  translate <   0.0, 1.75,  -8.0 > }//center
   object { Counter_3  translate <   0.0, 1.75,  -2.5 > }//center
   object { Counter_2  translate <  15.0, 1.75,  -5.0 > }//east side
   object { Counter_4  translate <   9.0, 1.75, -12.5 > }//southeast 
   object { Frig_1     translate < -15.0, 3.50,   0.75 > }
      } // end kitchen fixtures


// **************************************************************
//       D.  West Room: the kitchen:
// **************************************************************

//    DEFINE  West Room:
#declare West_Room =

union {

//test this:
object { W_South_Panel  translate < -42.5, 6, -35 > }
object { W_Kitchen      translate < -42.5, 1, -20 > }
object { W_West_Panel   translate < -60.0, 6, -20 > }
object { W_East_Panel   translate < -25.0, 6, -25 > }


   #if ( ShowLights = 1 )
   //ceiling lights:
   object { Lamp_B  translate < -49, 11, -20 > }
   object { Lamp_B  translate < -35, 11, -20 > }
   #end

   //roof:
   object { West_Roof  translate < -43, 19.5, -22 >
                       scale < 1, 0.6, 1 > }



/*
   //kitchen:
   object { W_Kitchen      translate < -42.5, 1, -20 > }
   //walls:
   object { W_North_Frame  translate < -42.5, 6,  -5 > }
   object { W_South_Frame  translate < -42.5, 6, -35 > }
   object { W_East_Frame   translate < -25.0, 6, -20 > }
   object { W_West_Frame   translate < -60.0, 6, -20 > }

#if ( ShowDetails = 1 )
   //walls:
   object { W_North_Panel  translate < -36.5, 6,  -5 > }
   object { W_South_Panel  translate < -42.5, 6, -35 > }
   object { W_East_Panel   translate < -25.0, 6, -25 > }
   object { W_West_Panel   translate < -60.0, 6, -20 > }
   //door:
   object { M_Front_Door   translate < -50.0, 4,  -5 > } //nw entrance
   //floor:
#end  // of show details?
*/

#if ( ShowFloor = 1 )
   object { Build_Block_1
            scale < 36, 1, 31 >        
            translate < -42.5, 0.5, -20 >
            #if ( ShowDetails = 0 )
               texture { Brown_Tex }
            #else
               texture { Brown_Tex }
            #end
          }// end west floor
#end //show floor?

      } // end west room union


// ************************************************************************
// III.  RENDER this:
// ************************************************************************

object { West_Room }

// GROUND:
//object { Clip_Floor }

// **************************************************************
// **************************************************************

// graph paper:
#if ( GridOn = 1 )
//   object { Grid10XY } // vert rods
//   object { Grid10XZ } // horz rods  centered
//   object { Grid10XZ  translate < -10, 0,  10 > } // nw
//   object { Grid10XZ  translate <  10, 0, -10 > } // se
//   object { Grid5XY } // vert balls
//   object { Mark01  translate < 0, 0, 0 > } // center
   //centered y,z:
   object { Mark01  translate <   0, 0, 0 > } // center
   object { Mark01  translate <  10, 0, 0 > } // 10x apart
   object { Mark01  translate < -10, 0, 0 > } //    "
   object { Mark01  translate <  20, 0, 0 > } //        
   object { Mark01  translate < -20, 0, 0 > } //    "
   object { Mark01  translate <  30, 0, 0 > } // 
   object { Mark01  translate < -30, 0, 0 > } //    "
   object { Mark01  translate <  40, 0, 0 > } // 
   object { Mark01  translate < -40, 0, 0 > } //    "
   object { Mark01  translate <  50, 0, 0 > } // 
   object { Mark01  translate < -50, 0, 0 > } //    "
   //centered x,y: 
   object { Mark01  translate < 0, 0,  10 > } // 10z apart
   object { Mark01  translate < 0, 0, -10 > } //    "
   object { Mark01  translate < 0, 0,  20 > } //        
   object { Mark01  translate < 0, 0, -20 > } //    "
   object { Mark01  translate < 0, 0,  30 > } // 
   object { Mark01  translate < 0, 0, -30 > } //    "
   object { Mark01  translate < 0, 0,  40 > } // 
   object { Mark01  translate < 0, 0, -40 > } //    "
   object { Mark01  translate < 0, 0,  50 > } // 
   object { Mark01  translate < 0, 0, -50 > } //    "
   //south -50z:
   object { Mark01  translate <   0, 0, -50 > } // center
   object { Mark01  translate <  10, 0, -50 > } // 10x apart
   object { Mark01  translate < -10, 0, -50 > } //    "
   object { Mark01  translate <  20, 0, -50 > } //        
   object { Mark01  translate < -20, 0, -50 > } //    "
   object { Mark01  translate <  30, 0, -50 > } // 
   object { Mark01  translate < -30, 0, -50 > } //    "
   object { Mark01  translate <  40, 0, -50 > } // 
   object { Mark01  translate < -40, 0, -50 > } //    "
   object { Mark01  translate <  50, 0, -50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
   //west -50x
   object { Mark01  translate < -50, 0,  10 > } // 10z apart
   object { Mark01  translate < -50, 0, -10 > } //    "
   object { Mark01  translate < -50, 0,  20 > } //        
   object { Mark01  translate < -50, 0, -20 > } //    "
   object { Mark01  translate < -50, 0,  30 > } // 
   object { Mark01  translate < -50, 0, -30 > } //    "
   object { Mark01  translate < -50, 0,  40 > } // 
   object { Mark01  translate < -50, 0, -40 > } //    "
   object { Mark01  translate < -50, 0,  50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
#end 

// *******************************************************************
// Michael Brendan Hurley                                    Sept 2001
// *******************************************************************