// ************************************************************************
// KITCHN01.POV                                                   Sept 2001
// Development of Stove for M_House 
// ************************************************************************
// *******************************************************************
// I.    DEFINE Includes, Constants and Conditionals:
// *******************************************************************

#version 3.1; 

#include "brendan.inc"                 // universal scene objects
                                       // and calls to support INC's

#declare ShowDetails = 1;    // 0=minimum, 1=full 
#declare GridOn      = 0;    // 0=hide, 1=show
#declare ShowLights  = 0;    // 0=day,  1=night
#declare ShowFloor   = 1;    // 0=hide, 1=show
#declare ShowGlass   = 0;    // 0=hide, 1=show

// *******************************************************************

global_settings { assumed_gamma 1.0 
                  max_trace_level 7 }

// *******************************************************************
// Lights!
// *******************************************************************

#declare LightLocate = < 80, 100, 150 >;
#declare intensity = 1;

#if ( ShowDetails = 0 )
   light_source { LightLocate  color White }
#else
   light_source { LightLocate  color White }
#end

// *******************************************************************
// Define Sky                                                        
// *******************************************************************

background { color LightBlue }      // day

// *******************************************************************
// CAMERA!
// *******************************************************************

#declare Camera_North =
camera {
   direction < 0, 0, 2 >
   location  < 0, 15, 0 >              // north of west room
   look_at   < 0, 5, -34 > }

#declare Camera_South =
camera {
   direction < 0, 0, 2 >
   location  < -55, 80, -24 >          // south of cntr
   look_at   < -55,  0, -23 > }

#declare Camera_SW =
camera {
   direction < 0, 0, 2 >
   location  < -70, 50, -70 >          // SW of center
   look_at   < 0, 0, 0 > }             //eye level

#declare Camera_SE =
camera {
   direction < 0, 0, 2 >
   location  < 90, 7, -50 >         // SE of center
   look_at   <  5, 0, -30 > }

#declare Camera_Above =
camera {         
   direction < 0,   0, 2 >
   location  < 0, 400, 0 >             // Above: dir 2, +200y
   look_at   < 0,   0, 0.1 > }           //  shows 150x 100z area

#declare Camera_Quarter =
camera { 
   direction < 0, 0, 2 >
   location  < 60, 60, -60 >           // SE and above 
   look_at   < 0, 0, 0 > }             // center of scene

// *******************************************************************
// *******************************************************************

#declare MoveX = -50;
#declare MoveY = 0;
#declare MoveZ = 0;

camera { Camera_North   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_South   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_SW      translate < MoveX, MoveY, MoveZ > }
//camera { Camera_SE      translate < MoveX, MoveY, MoveZ > }
//camera { Camera_Above   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_Quarter translate < MoveX, MoveY, MoveZ > }


// *******************************************************************
// Describe the set:
// *******************************************************************

//    DEFINE  generic scalable building block: 1x 1y 1z:
#declare Build_Block_1 =
box { <-0.5, -0.5, -0.5>  < 0.5, 0.5, 0.5 > } // end bldg block 1


// **************************************************************
//       D.  West Room: 
// **************************************************************

//    DEFINE  West room roof:
#declare West_Roof =
object {
   #declare RB_P1 = <  20,  1.05,  20 >;  // right upper rear corner
   #declare RB_P2 = < -20, -1.05, -20 >;  // left lower front corner
   #include "roundbox.inc"
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Stone24 }
   #end
      } // end west roof

// **************************************************************

//    DEFINE  West room: north wall frames:
#declare W_North_Frame =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate < -18, 0, 0 > }//w
   object { CubeY1
            scale < 1, 10, 1 >  translate <  18, 0, 0 > }//e
   object { CubeX1
            scale < 34, 1, 1 >  translate < 0,  5, 0 > }//top
   object { CubeX1
            scale < 34, 1, 1 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end west room north frames

// **************************************************************

//    DEFINE  West room: north panel:
#declare W_North_Panel =
union {
   //solid panel w/ window hole:
   difference {
      object {
         #declare RB_P1 = < 11.5,  5.5,  1.1 >; // right upper rear corner
         #declare RB_P2 = < -8.5, -5.5, -1.1 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  8,  2.5,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -2, -2.5, -2.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #end
              }//end difference
   //glass in windows:
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               scale < 8, 9, 0.05 >
               translate < 5, 0, 0 > 
             }//center window
      object { Pane_Square_2
               scale < 5, 10, 0.05 >
               translate < -21, 0, 0 > 
             }//far west window
   #end // show windows?
      } // end west room north panels

// **************************************************************

//    DEFINE  West room: south wall frames:
#declare W_South_Frame =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate <  -17, 0, 0 > }//w
   object { CubeY1
            scale < 1, 10, 1 >  translate < -8.5, 0, 0 > }
   object { CubeY1   
            scale < 1, 10, 1 >  translate <  8.5, 0, 0 > }
   object { CubeY1
            scale < 1, 10, 1 >  translate <   17, 0, 0 > }//e
   object { CubeX1
            scale < 34, 1, 1 >  translate < 0,  5, 0 > }//top
   object { CubeX1
            scale < 34, 1, 1 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end west room south frames

// **************************************************************

//    DEFINE  West room: south panel:
#declare W_South_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  18.5,  5.5,  1.1 >;  // right upper rear corner
         #declare RB_P2 = < -18.5, -5.5, -1.1 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  15,  2.5,  2.5 >; // right upper rear corner
         #declare RB_P2 = <   2, -2.5, -2.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #end
              }//end difference
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               scale < 20, 7.2, 0.05 >
               translate < 0, 1, 0 > 
             }//center window
   #end                  
      } // end west room south panels

// **************************************************************

//    DEFINE  West room: west wall frames:
#declare W_West_Frame =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,  15 > }//n
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,   7 > }
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,  -7 > }
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0, -15 > }//s
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0,  5, 0 > }//top
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 2, 4 > }
   #end
      } // end west room west frames

// **************************************************************

//    DEFINE  West room: west wall panels:
#declare W_West_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  5.5,  16 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -5.5, -16 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  2.5,  7 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -2.5, -7 >; // left lower front corner
         #include "roundbox.inc"
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4 > }
      #end
              }//end difference 
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 10, 25 > }
   #end
      } // end west wall window panels

// **************************************************************

//    DEFINE  West room: east wall frames:
#declare W_East_Frame =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,  15 > }//rear
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0,   3 > }//middle
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0, -6 > }//middle
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, 0, -15 > }//front
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0,  5, 0 > }//top
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 2, 4 > }
   #end
      } // end west room east frames

// **************************************************************

//    DEFINE  West room: east wall panels:
#declare W_East_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  5.5,  7.5 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -5.5, -10.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  2.5,  4.5 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -2.5, -7 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4 > }
      #end
              }//end difference 
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 10, 13 > }
   #end
      } // end east wall window panel

// **************************************************************
// **************************************************************
//    Lamps:
// **************************************************************

//   DEFINE   an object for a light source
#declare Flat_Light =
object {
   box { < -0.5, -0.1, -0.5 > < 0.5, 0.1, 0.5 >
         #if ( ShowDetails = 0 )
            texture { White_Tex }
         #else
            texture { T_Glass1 }
         #end
         hollow
       } // end box of glass
       } // end obj flat light

// **************************************************************

//   DEFINE   a light fixture:
#declare Lamp_A =
light_source {
   < 0, 0, 0 >
   color White
   looks_like { Flat_Light }
   fade_distance 5
   fade_power 2
             } // end light source  

// **************************************************************
// **************************************************************

//    DEFINE  a stove:
#declare Stove_1 =
union {

   //hood:
   box { < 5.85,  9.5,  1.00 > < -5.85,  6.00, -2.00 > 
         #if ( ShowDetails = 0 )
            texture { Green_Tex }
         #else
            texture { T_Copper_3D }
         #end }

   //vent stack:
   box { < 1.55, 11.5, -1.00 > < -1.55,  1.00, -1.55 >
         #if ( ShowDetails = 0 )
            texture { Blue_Tex }
         #else
            texture { T_Copper_3D }
         #end }

   //back panel:
   box { < 5.85, 7.00, -1.53 > < -5.85,  1.00, -1.56 >
         #if ( ShowDetails = 0 )
            texture { Yellow_Tex }
         #else
            texture { T_Chrome_2C }
         #end }

   //body:
   box { < 5.85, 1.75,  1.75 > < -5.85, -1.75, -1.65 >
         #if ( ShowDetails = 0 )
            texture { FireBrick_Tex }
         #else
            texture { T_Chrome_2C }
         #end }

   //oven doors:
   box { < 1.00, 1.00,  0.05 > < -1.00, -1.00, -0.05 > 
         translate < -4, 0.2, 1.75 >
         texture { Black_Tex } }
   box { < 1.00, 1.00,  0.05 > < -1.00, -1.00, -0.05 > 
         translate < -1, 0.2, 1.75 >
         texture { Black_Tex } }

   //utility drawers:
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50,  1.0, 1.76 >
         texture { Black_Tex } }
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50,  0.5, 1.76 >
         texture { Black_Tex } }
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50, -0.0, 1.76 >
         texture { Black_Tex } }
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50, -0.5, 1.76 >
         texture { Black_Tex } }

   //burners:
   disc { < 0, 0, 0 >  z, 0.5, 0.0
          rotate x*90
          translate < 1, 1.75, -0.3 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.5, 0.0
          rotate x*90
          translate < 1, 1.75,  1.0 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -1.5, 1.75, -0.3 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -0.25, 1.75, -0.3 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -1.5, 1.75, 1 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -0.25, 1.75, 1 > 
          texture { Black_Tex } }

   //grills:
   box { < 1.4, 0.1, 1.4 > < -1.4, -0.1, -1.4 >
         translate < -4, 1.67, 0.2 >
         texture {Black_Tex} }
   box { < 1.1, 0.1, 1.4 > < -1.1, -0.1, -1.4 >
         translate <  4, 1.67, 0.2 >
         texture {Black_Tex} }

      } // end stove

// **************************************************************

//    DEFINE  a table:
#declare Table_1 =
object {
   box { < 4, 2, 3 > < -4, -2, -3 > }
   texture { Red_Tex }
       } // end table

// **************************************************************

//    DEFINE  a hanging cabinet: 10x 2.5y 3z:
#declare Cabinet_1 =
object {
   box { < 5.0, 1.25, 1.5 > < -5.0, -1.25, -1.5 > }
   texture { Green_Tex }
       } // end cabinet 1

// **************************************************************

//    DEFINE  a counter: 12x 3y 3z:
#declare Counter_1 =
object {
   box { < 6.0, 1.5, 1.5 > < -6.0, -1.5, -1.5 > }
   texture { Coral_Tex }
       } // end counter 1

// **************************************************************

//    DEFINE  a counter: 3x 3.5y 12z:
#declare Counter_2 =
object {
   box { < 1.6, 1.75, 6.0 > < -1.6, -1.75, -6.0 > }
   texture { Orchid_Tex }
       } // end counter 2

// **************************************************************

//    DEFINE  a cylinder counter: 5x 4y 4z:
#declare Counter_3 =
object {
   cylinder { 0*y,  4*y,  2.5 }
   texture { Violet_Tex }
       } // end cyl counter 3

// **************************************************************

//    DEFINE a refrigerator:
#declare Frig_1 =
object {
   box { < 1.7, 7, 1.5 > < -1.7, -0.1, -1.5 > }
   texture { Blue_Tex }
       } // end frig

// **************************************************************

//    DEFINE  generic kitchen:
#declare W_Kitchen =
union {
/*
   object { Frig_1  translate < 10.5, 0, -13 > }
   object { Table_1  translate < -10, 2, -10 > }

   object { Cabinet_1  translate < -12.0, 8.5, -13 > }//up front
   object { Cabinet_1  translate <  12.0, 8.5, -13 > }//up front
   object { Cabinet_1  translate <   3.5, 9.0, 13 > }//up rear
   object { Counter_1  translate <   3.5, 1.5, 13 > }//down rear
*/
   //prep area:
//   object { Counter_1  translate <  10.5,  1.5,  -13.0 > }//right front
//   object { Counter_1  translate <  -7.0,  1.5,  -12.5 > }//left front
   object { Counter_2  translate <   0.0,  1.0, -8.0 > }//center
   object { Counter_2  translate < -15.0,  1.0, -8.0 > }//left side
//   object { Counter_3  translate <   0.0, -1.25, -2.5 > }//center
   object { Stove_1  translate < -7.5, 1.0, -12.5 > }

      } // end kitchen fixtures

// **************************************************************
// **************************************************************
//       D.  West Room: 
// **************************************************************

//    DEFINE West Room:
#declare West_Room =
union {

//test this:
object { W_South_Panel  translate < -42.5, 6, -35 > }
object { W_Kitchen      translate < -42.5, 1, -20 > }
object { W_West_Panel   translate < -60.0, 6, -20 > }

/*
   //roof:
   object { West_Roof  translate < -43, 11, -22 >
                       scale < 1, 0.8, 1 >
                       translate y*2.5 }
   //kitchen:
   object { W_Kitchen      translate < -42.5, 1, -20 > }
   //walls:
   object { W_North_Frame  translate < -42.5, 6,  -5 > }
   object { W_South_Frame  translate < -42.5, 6, -35 > }
   object { W_East_Frame   translate < -25.0, 6, -20 > }
   object { W_West_Frame   translate < -60.0, 6, -20 > }

#if ( ShowDetails = 1 )
   //walls:
   object { W_North_Panel  translate < -36.5, 6,  -5 > }
   object { W_South_Panel  translate < -42.5, 6, -35 > }
   object { W_East_Panel   translate < -25.0, 6, -25 > }
   object { W_West_Panel   translate < -60.0, 6, -20 > }
   //door:
   object { M_Front_Door   translate < -50.0, 4,  -5 > } //nw entrance
   //floor:
#end  // of show details?
*/

#if ( ShowFloor = 1 )
   object { Build_Block_1
            texture { Brown_Tex }
            scale < 36, 1, 31 >        
            translate < -42.5, 0.5, -20 >
          }// end west floor
#end //show floor?
      } // end west room union

// **************************************************************
// **************************************************************

object { West_Room }

// **************************************************************
// **************************************************************

// graph paper:
#if ( GridOn = 1 )
//   object { Grid10XY } // vert rods
//   object { Grid10XZ } // horz rods  centered
//   object { Grid10XZ  translate < -10, 0,  10 > } // nw
//   object { Grid10XZ  translate <  10, 0, -10 > } // se
//   object { Grid5XY } // vert balls
//   object { Mark01  translate < 0, 0, 0 > } // center
   //centered y,z:
   object { Mark01  translate <   0, 0, 0 > } // center
   object { Mark01  translate <  10, 0, 0 > } // 10x apart
   object { Mark01  translate < -10, 0, 0 > } //    "
   object { Mark01  translate <  20, 0, 0 > } //        
   object { Mark01  translate < -20, 0, 0 > } //    "
   object { Mark01  translate <  30, 0, 0 > } // 
   object { Mark01  translate < -30, 0, 0 > } //    "
   object { Mark01  translate <  40, 0, 0 > } // 
   object { Mark01  translate < -40, 0, 0 > } //    "
   object { Mark01  translate <  50, 0, 0 > } // 
   object { Mark01  translate < -50, 0, 0 > } //    "
   //centered x,y: 
   object { Mark01  translate < 0, 0,  10 > } // 10z apart
   object { Mark01  translate < 0, 0, -10 > } //    "
   object { Mark01  translate < 0, 0,  20 > } //        
   object { Mark01  translate < 0, 0, -20 > } //    "
   object { Mark01  translate < 0, 0,  30 > } // 
   object { Mark01  translate < 0, 0, -30 > } //    "
   object { Mark01  translate < 0, 0,  40 > } // 
   object { Mark01  translate < 0, 0, -40 > } //    "
   object { Mark01  translate < 0, 0,  50 > } // 
   object { Mark01  translate < 0, 0, -50 > } //    "
   //south -50z:
   object { Mark01  translate <   0, 0, -50 > } // center
   object { Mark01  translate <  10, 0, -50 > } // 10x apart
   object { Mark01  translate < -10, 0, -50 > } //    "
   object { Mark01  translate <  20, 0, -50 > } //        
   object { Mark01  translate < -20, 0, -50 > } //    "
   object { Mark01  translate <  30, 0, -50 > } // 
   object { Mark01  translate < -30, 0, -50 > } //    "
   object { Mark01  translate <  40, 0, -50 > } // 
   object { Mark01  translate < -40, 0, -50 > } //    "
   object { Mark01  translate <  50, 0, -50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
   //west -50x
   object { Mark01  translate < -50, 0,  10 > } // 10z apart
   object { Mark01  translate < -50, 0, -10 > } //    "
   object { Mark01  translate < -50, 0,  20 > } //        
   object { Mark01  translate < -50, 0, -20 > } //    "
   object { Mark01  translate < -50, 0,  30 > } // 
   object { Mark01  translate < -50, 0, -30 > } //    "
   object { Mark01  translate < -50, 0,  40 > } // 
   object { Mark01  translate < -50, 0, -40 > } //    "
   object { Mark01  translate < -50, 0,  50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
#end 

// *******************************************************************
// Michael Brendan Hurley                                    Sept 2001
// *******************************************************************